/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.serializer;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.parser.IParser;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import org.hl7.fhir.instance.model.api.IBaseResource;

public class FhirResourceSerializer
extends StdSerializer<IBaseResource> {
    private final IParser myParser;

    public FhirResourceSerializer(FhirContext theFhirContext) {
        super(IBaseResource.class);
        this.myParser = theFhirContext.newJsonParser().setPrettyPrint(true);
    }

    public void serialize(IBaseResource theResource, JsonGenerator theJsonGenerator, SerializerProvider theProvider) throws IOException {
        String resourceJson = this.myParser.encodeResourceToString(theResource);
        theJsonGenerator.writeRawValue(resourceJson);
    }
}

