/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.util;

import ca.uhn.fhir.util.StreamUtil;
import com.google.common.collect.Streams;
import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Stream;

public class TaskChunker<T> {
    public void chunk(Collection<T> theInput, int theChunkSize, Consumer<List<T>> theBatchConsumer) {
        ArrayList<T> input = theInput instanceof List ? (ArrayList<T>)theInput : new ArrayList<T>(theInput);
        for (int i = 0; i < input.size(); i += theChunkSize) {
            int to = i + theChunkSize;
            to = Math.min(to, input.size());
            List batch = input.subList(i, to);
            theBatchConsumer.accept(batch);
        }
    }

    @Nonnull
    public <T> Stream<List<T>> chunk(Stream<T> theStream, int theChunkSize) {
        return StreamUtil.partition(theStream, theChunkSize);
    }

    @Nonnull
    public void chunk(Iterator<T> theIterator, int theChunkSize, Consumer<List<T>> theListConsumer) {
        this.chunk(Streams.stream(theIterator), theChunkSize).forEach(theListConsumer);
    }
}

