/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.interceptor.executor;

import ca.uhn.fhir.interceptor.api.Hook;
import ca.uhn.fhir.interceptor.api.HookParams;
import ca.uhn.fhir.interceptor.api.IAnonymousInterceptor;
import ca.uhn.fhir.interceptor.api.IInterceptorBroadcaster;
import ca.uhn.fhir.interceptor.api.IInterceptorService;
import ca.uhn.fhir.interceptor.api.Pointcut;
import ca.uhn.fhir.interceptor.executor.BaseInterceptorService;
import com.google.common.annotations.VisibleForTesting;
import java.lang.reflect.Method;
import java.util.Optional;
import org.apache.commons.lang3.Validate;

public class InterceptorService
extends BaseInterceptorService<Pointcut>
implements IInterceptorService,
IInterceptorBroadcaster {
    public InterceptorService() {
        this("default");
    }

    public InterceptorService(String theName) {
        super(Pointcut.class, theName);
    }

    @Override
    protected Optional<BaseInterceptorService.HookDescriptor> scanForHook(Method nextMethod) {
        return InterceptorService.findAnnotation(nextMethod, Hook.class).map(t -> new BaseInterceptorService.HookDescriptor((BaseInterceptorService)this, (Enum)t.value(), t.order()));
    }

    @Override
    @VisibleForTesting
    public void registerAnonymousInterceptor(Pointcut thePointcut, IAnonymousInterceptor theInterceptor) {
        this.registerAnonymousInterceptor(thePointcut, 0, theInterceptor);
    }

    @Override
    public void registerAnonymousInterceptor(Pointcut thePointcut, int theOrder, IAnonymousInterceptor theInterceptor) {
        Validate.notNull((Object)thePointcut);
        Validate.notNull((Object)theInterceptor);
        AnonymousLambdaInvoker invoker = new AnonymousLambdaInvoker(thePointcut, theInterceptor, theOrder);
        this.registerAnonymousInterceptor(thePointcut, theInterceptor, invoker);
    }

    private static class AnonymousLambdaInvoker
    extends BaseInterceptorService.BaseInvoker {
        private final IAnonymousInterceptor myHook;
        private final Pointcut myPointcut;

        public AnonymousLambdaInvoker(Pointcut thePointcut, IAnonymousInterceptor theHook, int theOrder) {
            super(theHook, theOrder);
            this.myHook = theHook;
            this.myPointcut = thePointcut;
        }

        @Override
        Object invoke(HookParams theParams) {
            this.myHook.invoke(this.myPointcut, theParams);
            return true;
        }
    }
}

