/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.interceptor.api;

import ca.uhn.fhir.interceptor.api.HookParams;
import ca.uhn.fhir.interceptor.api.IPointcut;
import ca.uhn.fhir.interceptor.executor.SupplierFilterHookWrapper;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.function.Supplier;
import org.apache.commons.lang3.Validate;

public interface IBaseInterceptorBroadcaster<POINTCUT extends IPointcut> {
    public boolean callHooks(POINTCUT var1, HookParams var2);

    default public boolean ifHasCallHooks(POINTCUT thePointcut, Supplier<HookParams> theParamsSupplier) {
        if (this.hasHooks(thePointcut)) {
            HookParams params = theParamsSupplier.get();
            return this.callHooks(thePointcut, params);
        }
        return true;
    }

    public Object callHooksAndReturnObject(POINTCUT var1, HookParams var2);

    default public Object ifHasCallHooksAndReturnObject(POINTCUT thePointcut, Supplier<HookParams> theParams) {
        if (this.hasHooks(thePointcut)) {
            HookParams params = theParams.get();
            return this.callHooksAndReturnObject(thePointcut, params);
        }
        return null;
    }

    default public void runWithFilterHooks(POINTCUT thePointcut, HookParams theHookParams, Runnable theRunnable) {
        this.runWithFilterHooks(thePointcut, theHookParams, () -> {
            theRunnable.run();
            return null;
        });
    }

    default public <T> T runWithFilterHooks(POINTCUT thePointcut, HookParams theHookParams, Supplier<T> theSupplier) {
        Validate.isTrue((thePointcut.getReturnType() == IInterceptorFilterHook.class ? 1 : 0) != 0, (String)"Only pointcuts that return IInterceptorFilterHook can be used with this method", (Object[])new Object[0]);
        List<IInvoker> invokers = this.getInvokersForPointcut(thePointcut);
        Supplier<T> supplier = theSupplier;
        for (IInvoker nextInvoker : Lists.reverse(invokers)) {
            IInterceptorFilterHook filter = (IInterceptorFilterHook)nextInvoker.invoke(theHookParams);
            supplier = new SupplierFilterHookWrapper<T>(supplier, filter, nextInvoker::getHookDescription);
        }
        return supplier.get();
    }

    public boolean hasHooks(POINTCUT var1);

    public List<IInvoker> getInvokersForPointcut(POINTCUT var1);

    @FunctionalInterface
    public static interface IInterceptorFilterHook {
        public void wrapCall(Runnable var1);
    }

    public static interface IInvoker
    extends Comparable<IInvoker> {
        public Object invoke(HookParams var1);

        public int getOrder();

        public Object getInterceptor();

        default public String getHookDescription() {
            return this.toString();
        }
    }
}

