/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.util.rdf;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.WriterOutputStream;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;

public class RDFUtil {
    public static Model initializeRDFModel() {
        return ModelFactory.createDefaultModel();
    }

    public static Model readRDFToModel(Reader reader, Lang lang) throws IOException {
        Model rdfModel = RDFUtil.initializeRDFModel();
        if (reader instanceof StringReader) {
            RDFDataMgr.read((Model)rdfModel, (StringReader)((StringReader)reader), null, (Lang)lang);
        } else if (reader instanceof InputStreamReader) {
            String content = IOUtils.toString((Reader)reader);
            RDFDataMgr.read((Model)rdfModel, (StringReader)new StringReader(content), null, (Lang)lang);
        }
        return rdfModel;
    }

    public static void writeRDFModel(Writer writer, Model rdfModel, Lang lang) throws IOException {
        WriterOutputStream outputStream = ((WriterOutputStream.Builder)WriterOutputStream.builder().setWriter(writer)).setCharset("UTF-8").get();
        RDFDataMgr.write((OutputStream)outputStream, (Model)rdfModel, (Lang)lang);
    }
}

