/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.param;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.model.api.IQueryParameterAnd;
import ca.uhn.fhir.model.api.IQueryParameterOr;
import ca.uhn.fhir.rest.api.QualifiedParamList;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import java.util.ArrayList;
import java.util.List;

public abstract class BaseAndListParam<T extends IQueryParameterOr<?>>
implements IQueryParameterAnd<T> {
    private List<T> myValues = new ArrayList<T>();

    public abstract BaseAndListParam<T> addAnd(T var1);

    public BaseAndListParam<T> addValue(T theValue) {
        this.myValues.add(theValue);
        return this;
    }

    @Override
    public List<T> getValuesAsQueryTokens() {
        return this.myValues;
    }

    abstract T newInstance();

    @Override
    public void setValuesAsQueryTokens(FhirContext theContext, String theParamName, List<QualifiedParamList> theParameters) throws InvalidRequestException {
        this.myValues.clear();
        for (QualifiedParamList nextParam : theParameters) {
            T nextList = this.newInstance();
            nextList.setValuesAsQueryTokens(theContext, theParamName, nextParam);
            this.myValues.add(nextList);
        }
    }

    public String toString() {
        return this.myValues.toString();
    }

    public int size() {
        return this.myValues.size();
    }
}

