/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.util;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.rest.api.EncodingEnum;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import com.google.common.base.Charsets;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.function.Function;
import java.util.zip.GZIPInputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.BOMInputStream;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClasspathUtil {
    private static final Logger ourLog = LoggerFactory.getLogger(ClasspathUtil.class);

    private ClasspathUtil() {
    }

    public static String loadResource(String theClasspath) throws InternalErrorException {
        return ClasspathUtil.loadResource(theClasspath, Function.identity());
    }

    @Nonnull
    public static InputStream loadResourceAsStream(String theClasspath) throws InternalErrorException {
        InputStream retVal;
        String classpath = theClasspath;
        if (classpath.startsWith("classpath:")) {
            classpath = classpath.substring("classpath:".length());
        }
        if ((retVal = ClasspathUtil.class.getResourceAsStream(classpath)) == null && (retVal = classpath.startsWith("/") ? ClasspathUtil.class.getResourceAsStream(classpath.substring(1)) : ClasspathUtil.class.getResourceAsStream("/" + classpath)) == null) {
            throw new InternalErrorException(Msg.code(1758) + "Unable to find classpath resource: " + classpath);
        }
        return retVal;
    }

    public static Reader loadResourceAsReader(String theClasspath) {
        return new InputStreamReader(ClasspathUtil.loadResourceAsStream(theClasspath), StandardCharsets.UTF_8);
    }

    @Nonnull
    public static String loadResource(String theClasspath, Function<InputStream, InputStream> theStreamTransform) {
        String string;
        block8: {
            InputStream stream = ClasspathUtil.loadResourceAsStream(theClasspath);
            try {
                InputStream newStream = theStreamTransform.apply(stream);
                string = IOUtils.toString((InputStream)newStream, (Charset)Charsets.UTF_8);
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new InternalErrorException(Msg.code(1759) + String.valueOf(e));
                }
            }
            stream.close();
        }
        return string;
    }

    @Nonnull
    public static String loadCompressedResource(String theClasspath) {
        Function<InputStream, InputStream> streamTransform = t -> {
            try {
                return new GZIPInputStream((InputStream)t);
            }
            catch (IOException e) {
                throw new InternalErrorException(Msg.code(1760) + String.valueOf(e));
            }
        };
        return ClasspathUtil.loadResource(theClasspath, streamTransform);
    }

    @Nonnull
    public static <T extends IBaseResource> T loadCompressedResource(FhirContext theCtx, Class<T> theType, String theClasspath) {
        String resource = ClasspathUtil.loadCompressedResource(theClasspath);
        return ClasspathUtil.parseResource(theCtx, theType, resource);
    }

    @Nonnull
    public static <T extends IBaseResource> T loadResource(FhirContext theCtx, Class<T> theType, String theClasspath) {
        String raw = ClasspathUtil.loadResource(theClasspath);
        return ClasspathUtil.parseResource(theCtx, theType, raw);
    }

    private static <T extends IBaseResource> T parseResource(FhirContext theCtx, Class<T> theType, String raw) {
        return EncodingEnum.detectEncodingNoDefault(raw).newParser(theCtx).parseResource(theType, raw);
    }

    public static void close(InputStream theInput) {
        try {
            if (theInput != null) {
                theInput.close();
            }
        }
        catch (IOException e) {
            ourLog.debug("Closing InputStream threw exception", (Throwable)e);
        }
    }

    public static Function<InputStream, InputStream> withBom() {
        return t -> new BOMInputStream(t);
    }

    public static byte[] loadResourceAsByteArray(String theClasspath) {
        InputStream stream = ClasspathUtil.loadResourceAsStream(theClasspath);
        try {
            byte[] byArray = IOUtils.toByteArray((InputStream)stream);
            return byArray;
        }
        catch (IOException e) {
            throw new InternalErrorException(Msg.code(1761) + String.valueOf(e));
        }
        finally {
            ClasspathUtil.close(stream);
        }
    }
}

