/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.validation;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public class ValidationOptions {
    private Set<String> myProfiles;
    private Object myAppContext;

    public Set<String> getProfiles() {
        return this.myProfiles != null ? Collections.unmodifiableSet(this.myProfiles) : Collections.emptySet();
    }

    public ValidationOptions addProfile(String theProfileUri) {
        Validate.notBlank((CharSequence)theProfileUri);
        if (this.myProfiles == null) {
            this.myProfiles = new HashSet<String>();
        }
        this.myProfiles.add(theProfileUri);
        return this;
    }

    public ValidationOptions addProfileIfNotBlank(String theProfileUri) {
        if (StringUtils.isNotBlank((CharSequence)theProfileUri)) {
            return this.addProfile(theProfileUri);
        }
        return this;
    }

    public ValidationOptions setAppContext(Object theContext) {
        this.myAppContext = theContext;
        return this;
    }

    public Object getAppContext() {
        return this.myAppContext;
    }

    public static ValidationOptions empty() {
        ValidationOptions retval = new ValidationOptions();
        retval.myProfiles = Collections.emptySet();
        return retval;
    }
}

