/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.context.support;

import java.util.Collection;
import java.util.Collections;
import java.util.Objects;

public class LookupCodeRequest {
    private final String mySystem;
    private final String myCode;
    private String myDisplayLanguage;
    private Collection<String> myPropertyNames;

    public LookupCodeRequest(String theSystem, String theCode) {
        this.mySystem = theSystem;
        this.myCode = theCode;
    }

    public LookupCodeRequest(String theSystem, String theCode, String theDisplayLanguage, Collection<String> thePropertyNames) {
        this(theSystem, theCode);
        this.myDisplayLanguage = theDisplayLanguage;
        this.myPropertyNames = thePropertyNames;
    }

    public String getSystem() {
        return this.mySystem;
    }

    public String getCode() {
        return this.myCode;
    }

    public String getDisplayLanguage() {
        return this.myDisplayLanguage;
    }

    public Collection<String> getPropertyNames() {
        if (this.myPropertyNames == null) {
            return Collections.emptyList();
        }
        return this.myPropertyNames;
    }

    public boolean equals(Object theO) {
        if (this == theO) {
            return true;
        }
        if (!(theO instanceof LookupCodeRequest)) {
            return false;
        }
        LookupCodeRequest that = (LookupCodeRequest)theO;
        return Objects.equals(this.mySystem, that.mySystem) && Objects.equals(this.myCode, that.myCode) && Objects.equals(this.myDisplayLanguage, that.myDisplayLanguage) && Objects.equals(this.myPropertyNames, that.myPropertyNames);
    }

    public int hashCode() {
        return Objects.hash(this.mySystem, this.myCode, this.myDisplayLanguage, this.myPropertyNames);
    }
}

