/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.context.support;

import java.util.Objects;
import org.apache.commons.lang3.Validate;

public class ValueSetExpansionOptions {
    private boolean myFailOnMissingCodeSystem = true;
    private int myCount = 1000;
    private int myOffset = 0;
    private boolean myIncludeHierarchy;
    private String myFilter;
    private String myDisplayLanguage;

    public String getFilter() {
        return this.myFilter;
    }

    public ValueSetExpansionOptions setFilter(String theFilter) {
        this.myFilter = theFilter;
        return this;
    }

    public int getCount() {
        return this.myCount;
    }

    public ValueSetExpansionOptions setCount(int theCount) {
        Validate.isTrue((theCount >= 0 ? 1 : 0) != 0, (String)"theCount must be >= 0", (Object[])new Object[0]);
        this.myCount = theCount;
        return this;
    }

    public int getOffset() {
        return this.myOffset;
    }

    public ValueSetExpansionOptions setOffset(int theOffset) {
        Validate.isTrue((theOffset >= 0 ? 1 : 0) != 0, (String)"theOffset must be >= 0", (Object[])new Object[0]);
        this.myOffset = theOffset;
        return this;
    }

    public boolean isFailOnMissingCodeSystem() {
        return this.myFailOnMissingCodeSystem;
    }

    public ValueSetExpansionOptions setFailOnMissingCodeSystem(boolean theFailOnMissingCodeSystem) {
        this.myFailOnMissingCodeSystem = theFailOnMissingCodeSystem;
        return this;
    }

    public boolean isIncludeHierarchy() {
        return this.myIncludeHierarchy;
    }

    public void setIncludeHierarchy(boolean theIncludeHierarchy) {
        this.myIncludeHierarchy = theIncludeHierarchy;
    }

    public static ValueSetExpansionOptions forOffsetAndCount(int theOffset, int theCount) {
        return new ValueSetExpansionOptions().setOffset(theOffset).setCount(theCount);
    }

    public String getTheDisplayLanguage() {
        return this.myDisplayLanguage;
    }

    public ValueSetExpansionOptions setTheDisplayLanguage(String theDisplayLanguage) {
        this.myDisplayLanguage = theDisplayLanguage;
        return this;
    }

    public boolean equals(Object theO) {
        if (this == theO) {
            return true;
        }
        if (!(theO instanceof ValueSetExpansionOptions)) {
            return false;
        }
        ValueSetExpansionOptions that = (ValueSetExpansionOptions)theO;
        return this.myFailOnMissingCodeSystem == that.myFailOnMissingCodeSystem && this.myCount == that.myCount && this.myOffset == that.myOffset && this.myIncludeHierarchy == that.myIncludeHierarchy && Objects.equals(this.myFilter, that.myFilter) && Objects.equals(this.myDisplayLanguage, that.myDisplayLanguage);
    }

    public int hashCode() {
        return Objects.hash(this.myFailOnMissingCodeSystem, this.myCount, this.myOffset, this.myIncludeHierarchy, this.myFilter, this.myDisplayLanguage);
    }
}

