/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.interceptor.api;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimaps;
import jakarta.annotation.Nonnull;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.instance.model.api.IBaseResource;

public class HookParams {
    private ListMultimap<Class<?>, Object> myParams = ArrayListMultimap.create();

    public HookParams() {
    }

    public HookParams(Object ... theParams) {
        for (Object next : theParams) {
            this.add(next);
        }
    }

    public <T> HookParams add(@Nonnull T theNext) {
        Class<?> nextClass = theNext.getClass();
        this.add(nextClass, theNext);
        return this;
    }

    public <T> HookParams add(Class<T> theType, T theParam) {
        return this.doAdd(theType, theParam);
    }

    private <T> HookParams doAdd(Class<T> theType, Object theParam) {
        Validate.isTrue((!theType.equals(Supplier.class) ? 1 : 0) != 0, (String)"Can not add parameters of type Supplier", (Object[])new Object[0]);
        this.myParams.put(theType, theParam);
        return this;
    }

    public <T> T get(Class<T> theParamType) {
        return this.get(theParamType, 0);
    }

    public <T> T get(Class<T> theParamType, int theIndex) {
        List objects = this.myParams.get(theParamType);
        Object retVal = null;
        if (objects.size() > theIndex) {
            retVal = objects.get(theIndex);
        }
        retVal = this.unwrapValue(retVal);
        return (T)retVal;
    }

    private Object unwrapValue(Object theValue) {
        if (theValue instanceof Supplier) {
            theValue = ((Supplier)theValue).get();
        }
        return theValue;
    }

    public ListMultimap<Class<?>, Object> getParamsForType() {
        ArrayListMultimap retVal = ArrayListMultimap.create();
        this.myParams.entries().forEach(entry -> retVal.put((Object)((Class)entry.getKey()), this.unwrapValue(entry.getValue())));
        return Multimaps.unmodifiableListMultimap((ListMultimap)retVal);
    }

    public Collection<Object> values() {
        return Collections.unmodifiableCollection(this.myParams.values()).stream().map(t -> this.unwrapValue(t)).collect(Collectors.toList());
    }

    public <T> HookParams addIfMatchesType(Class<T> theType, Object theParam) {
        if (theParam == null) {
            this.add(theType, null);
        } else if (theType.isAssignableFrom(theParam.getClass())) {
            Object param = theParam;
            this.add(theType, param);
        } else {
            this.add(theType, null);
        }
        return this;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        this.myParams.forEach((key, value) -> b.append("  ").append(key.getSimpleName()).append(": ").append(HookParams.valueAsStringForLog(value)).append("\n"));
        return b.toString();
    }

    private static String valueAsStringForLog(Object theValue) {
        if (theValue instanceof IBaseResource) {
            return ((IBaseResource)theValue).getIdElement().toString();
        }
        return theValue.toString();
    }
}

