/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.narrative2;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.util.BundleUtil;
import ca.uhn.fhir.util.TerserUtil;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseCoding;
import org.hl7.fhir.instance.model.api.IBaseResource;

public class NarrativeGeneratorTemplateUtils {
    public static final NarrativeGeneratorTemplateUtils INSTANCE = new NarrativeGeneratorTemplateUtils();

    public boolean bundleHasEntriesWithResourceType(IBaseBundle theBaseBundle, String theResourceType) {
        FhirVersionEnum fhirVersionEnum = theBaseBundle.getStructureFhirVersionEnum();
        FhirContext ctx = FhirContext.forCached(fhirVersionEnum);
        List<Pair<String, IBaseResource>> entryResources = BundleUtil.getBundleEntryUrlsAndResources(ctx, theBaseBundle);
        return entryResources.stream().map(Pair::getValue).filter(Objects::nonNull).anyMatch(t -> ctx.getResourceType((IBaseResource)t).equals(theResourceType));
    }

    public boolean bundleHasEntriesWithCode(IBaseBundle theBundle, String theResourceType, String theCodeSystem, String theCode) {
        FhirVersionEnum fhirVersionEnum = theBundle.getStructureFhirVersionEnum();
        FhirContext ctx = FhirContext.forCached(fhirVersionEnum);
        return this.getEntryResources(ctx, theBundle, theResourceType).anyMatch(t -> {
            List<IBase> codeList = TerserUtil.getFieldByFhirPath(ctx, "code.coding", t);
            return codeList.stream().anyMatch(m -> {
                IBaseCoding coding = (IBaseCoding)m;
                return StringUtils.equals((CharSequence)coding.getSystem(), (CharSequence)theCodeSystem) && StringUtils.equals((CharSequence)coding.getCode(), (CharSequence)theCode);
            });
        });
    }

    public boolean bundleHasEntriesWithoutCode(IBaseBundle theBundle, String theResourceType, String theCodeSystem, String theCode) {
        FhirVersionEnum fhirVersionEnum = theBundle.getStructureFhirVersionEnum();
        FhirContext ctx = FhirContext.forCached(fhirVersionEnum);
        return this.getEntryResources(ctx, theBundle, theResourceType).anyMatch(t -> {
            List<IBase> codeList = TerserUtil.getFieldByFhirPath(ctx, "code.coding", t);
            return codeList.stream().allMatch(m -> {
                IBaseCoding coding = (IBaseCoding)m;
                return !StringUtils.equals((CharSequence)coding.getSystem(), (CharSequence)theCodeSystem) || !StringUtils.equals((CharSequence)coding.getCode(), (CharSequence)theCode);
            });
        });
    }

    private Stream<IBaseResource> getEntryResources(FhirContext theContext, IBaseBundle theBundle, String theResourceType) {
        List<Pair<String, IBaseResource>> entryResources = BundleUtil.getBundleEntryUrlsAndResources(theContext, theBundle);
        return entryResources.stream().map(Pair::getValue).filter(Objects::nonNull).filter(t -> theContext.getResourceType((IBaseResource)t).equals(theResourceType));
    }
}

