/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.param;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.model.api.IQueryParameterType;
import ca.uhn.fhir.rest.param.BaseParam;
import ca.uhn.fhir.rest.param.ParameterUtil;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import ca.uhn.fhir.util.ReflectionUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class CompositeParam<A extends IQueryParameterType, B extends IQueryParameterType>
extends BaseParam
implements IQueryParameterType {
    private final A myLeftType;
    private final B myRightType;

    public CompositeParam(A theLeftInstance, B theRightInstance) {
        this.myLeftType = theLeftInstance;
        this.myRightType = theRightInstance;
    }

    public CompositeParam(Class<A> theLeftType, Class<B> theRightType) {
        Validate.notNull(theLeftType, (String)"theLeftType must not be null", (Object[])new Object[0]);
        Validate.notNull(theRightType, (String)"theRightType must not be null", (Object[])new Object[0]);
        this.myLeftType = (IQueryParameterType)ReflectionUtil.newInstance(theLeftType);
        this.myRightType = (IQueryParameterType)ReflectionUtil.newInstance(theRightType);
    }

    @Override
    String doGetQueryParameterQualifier() {
        return null;
    }

    @Override
    String doGetValueAsQueryToken() {
        StringBuilder b = new StringBuilder();
        if (this.myLeftType != null) {
            b.append(this.myLeftType.getValueAsQueryToken());
        }
        b.append('$');
        if (this.myRightType != null) {
            b.append(this.myRightType.getValueAsQueryToken());
        }
        return b.toString();
    }

    @Override
    void doSetValueAsQueryToken(FhirContext theContext, String theParamName, String theQualifier, String theValue) {
        if (StringUtils.isBlank((CharSequence)theValue)) {
            this.myLeftType.setValueAsQueryToken(theContext, theParamName, theQualifier, "");
            this.myRightType.setValueAsQueryToken(theContext, theParamName, theQualifier, "");
        } else {
            List<String> parts = ParameterUtil.splitParameterString(theValue, '$', false);
            if (parts.size() > 2) {
                throw new InvalidRequestException(Msg.code(1947) + "Invalid value for composite parameter (only one '$' is valid for this parameter, others must be escaped). Value was: " + theValue);
            }
            this.myLeftType.setValueAsQueryToken(theContext, theParamName, theQualifier, parts.get(0));
            if (parts.size() > 1) {
                this.myRightType.setValueAsQueryToken(theContext, theParamName, theQualifier, parts.get(1));
            }
        }
    }

    public A getLeftValue() {
        return this.myLeftType;
    }

    public B getRightValue() {
        return this.myRightType;
    }

    public List<IQueryParameterType> getValues() {
        return Collections.unmodifiableList(Arrays.asList(this.myLeftType, this.myRightType));
    }

    public String toString() {
        ToStringBuilder b = new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE);
        b.append("myLeftType", this.getLeftValue());
        b.append("myRightType", this.getRightValue());
        return b.toString();
    }
}

