/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.param;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.model.api.IQueryParameterType;
import ca.uhn.fhir.rest.param.BaseParamWithPrefix;
import ca.uhn.fhir.rest.param.ParameterUtil;
import java.math.BigDecimal;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class NumberParam
extends BaseParamWithPrefix<NumberParam>
implements IQueryParameterType {
    private static final long serialVersionUID = 1L;
    private BigDecimal myQuantity;

    public NumberParam() {
    }

    public NumberParam(int theValue) {
        this.setValue(new BigDecimal(theValue));
    }

    public NumberParam(String theValue) {
        this.setValueAsQueryToken(null, null, null, theValue);
    }

    @Override
    String doGetQueryParameterQualifier() {
        return null;
    }

    @Override
    String doGetValueAsQueryToken() {
        StringBuilder b = new StringBuilder();
        if (this.getPrefix() != null) {
            b.append(ParameterUtil.escapeWithDefault(this.getPrefix().getValue()));
        }
        b.append(ParameterUtil.escapeWithDefault(this.myQuantity.toPlainString()));
        return b.toString();
    }

    @Override
    void doSetValueAsQueryToken(FhirContext theContext, String theParamName, String theQualifier, String theValue) {
        if (this.getMissing() != null && StringUtils.isBlank((CharSequence)theValue)) {
            return;
        }
        String value = super.extractPrefixAndReturnRest(theValue);
        this.myQuantity = null;
        if (StringUtils.isNotBlank((CharSequence)value)) {
            this.myQuantity = new BigDecimal(value);
        }
    }

    public BigDecimal getValue() {
        return this.myQuantity;
    }

    public NumberParam setValue(BigDecimal theValue) {
        this.myQuantity = theValue;
        return this;
    }

    public String toString() {
        ToStringBuilder b = new ToStringBuilder((Object)this, ToStringStyle.SIMPLE_STYLE);
        b.append("prefix", (Object)this.getPrefix());
        b.append("value", (Object)this.myQuantity);
        return b.build();
    }
}

