/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.util;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.util.ParametersUtil;
import jakarta.annotation.Nonnull;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseParameters;

public class FhirPatchBuilder {
    public static final String PARAMETER_ALLOW_MULTIPLE_MATCHES = "allowMultipleMatches";
    private final FhirContext myContext;
    private final IBaseParameters myPatch;

    public FhirPatchBuilder(@Nonnull FhirContext theFhirContext) {
        Validate.notNull((Object)theFhirContext, (String)"theFhirContext must not be null", (Object[])new Object[0]);
        this.myContext = theFhirContext;
        this.myPatch = ParametersUtil.newInstance(this.myContext);
    }

    public IAddStep1 add() {
        return new AddBuilder();
    }

    public IInsertStep1 insert() {
        return new InsertBuilder();
    }

    public IDeleteStep1 delete() {
        return new DeleteBuilder();
    }

    public IReplaceStep1 replace() {
        return new ReplaceBuilder();
    }

    public IMoveStep1 move() {
        return new MoveBuilder();
    }

    public IBaseParameters build() {
        return this.myPatch;
    }

    private class AddBuilder
    extends BaseOperationBuilder<IAddStep2, IAddStep3, IStepComplete, Void, Void, Void>
    implements IAddStep1,
    IAddStep2,
    IAddStep3 {
        private AddBuilder() {
        }

        @Override
        public IStepComplete value(@Nonnull IBase theValue) {
            super.value(theValue);
            IBase operation = ParametersUtil.addParameterToParameters(FhirPatchBuilder.this.myContext, FhirPatchBuilder.this.myPatch, "operation");
            ParametersUtil.addPartString(FhirPatchBuilder.this.myContext, operation, "type", "add");
            ParametersUtil.addPartString(FhirPatchBuilder.this.myContext, operation, "path", this.myPath);
            ParametersUtil.addPartString(FhirPatchBuilder.this.myContext, operation, "name", this.myName);
            ParametersUtil.addPart(FhirPatchBuilder.this.myContext, operation, "value", this.myValue);
            return this;
        }
    }

    private class InsertBuilder
    extends BaseOperationBuilder<IInsertStep2, Void, IStepComplete, IInsertStep3, Void, Void>
    implements IInsertStep1,
    IInsertStep2,
    IInsertStep3 {
        private InsertBuilder() {
        }

        @Override
        public IStepComplete value(@Nonnull IBase theValue) {
            super.value(theValue);
            IBase operation = ParametersUtil.addParameterToParameters(FhirPatchBuilder.this.myContext, FhirPatchBuilder.this.myPatch, "operation");
            ParametersUtil.addPartString(FhirPatchBuilder.this.myContext, operation, "type", "insert");
            ParametersUtil.addPartString(FhirPatchBuilder.this.myContext, operation, "path", this.myPath);
            ParametersUtil.addPartInteger(FhirPatchBuilder.this.myContext, operation, "index", this.myIndex);
            ParametersUtil.addPart(FhirPatchBuilder.this.myContext, operation, "value", this.myValue);
            return this;
        }
    }

    private class DeleteBuilder
    extends BaseOperationBuilder<IDeleteStepAfter, Void, Void, Void, Void, Void>
    implements IDeleteStep1,
    IDeleteStepAfter {
        private IBase myOperation;
        private IBase myAllowMultipleMatches;

        private DeleteBuilder() {
        }

        @Override
        public IDeleteStepAfter allowMultipleMatches() {
            if (this.myAllowMultipleMatches == null) {
                this.myAllowMultipleMatches = ParametersUtil.addPartBoolean(FhirPatchBuilder.this.myContext, this.myOperation, FhirPatchBuilder.PARAMETER_ALLOW_MULTIPLE_MATCHES, true);
            }
            return this;
        }

        @Override
        public IDeleteStepAfter path(String thePath) {
            super.path(thePath);
            this.myOperation = ParametersUtil.addParameterToParameters(FhirPatchBuilder.this.myContext, FhirPatchBuilder.this.myPatch, "operation");
            ParametersUtil.addPartString(FhirPatchBuilder.this.myContext, this.myOperation, "type", "delete");
            ParametersUtil.addPartString(FhirPatchBuilder.this.myContext, this.myOperation, "path", this.myPath);
            return this;
        }
    }

    private class ReplaceBuilder
    extends BaseOperationBuilder<IReplaceStep2, Void, IStepComplete, Void, Void, Void>
    implements IReplaceStep1,
    IReplaceStep2 {
        private ReplaceBuilder() {
        }

        @Override
        public IStepComplete value(@Nonnull IBase theValue) {
            super.value(theValue);
            IBase operation = ParametersUtil.addParameterToParameters(FhirPatchBuilder.this.myContext, FhirPatchBuilder.this.myPatch, "operation");
            ParametersUtil.addPartString(FhirPatchBuilder.this.myContext, operation, "type", "replace");
            ParametersUtil.addPartString(FhirPatchBuilder.this.myContext, operation, "path", this.myPath);
            ParametersUtil.addPart(FhirPatchBuilder.this.myContext, operation, "value", this.myValue);
            return this;
        }
    }

    private class MoveBuilder
    extends BaseOperationBuilder<IMoveStep2, Void, Void, Void, IMoveStep3, IStepComplete>
    implements IMoveStep1,
    IMoveStep2,
    IMoveStep3 {
        private MoveBuilder() {
        }

        @Override
        public IStepComplete destination(int theDestination) {
            super.destination(theDestination);
            IBase operation = ParametersUtil.addParameterToParameters(FhirPatchBuilder.this.myContext, FhirPatchBuilder.this.myPatch, "operation");
            ParametersUtil.addPartString(FhirPatchBuilder.this.myContext, operation, "type", "move");
            ParametersUtil.addPartString(FhirPatchBuilder.this.myContext, operation, "path", this.myPath);
            ParametersUtil.addPartInteger(FhirPatchBuilder.this.myContext, operation, "source", this.mySource);
            ParametersUtil.addPartInteger(FhirPatchBuilder.this.myContext, operation, "destination", this.myDestination);
            return this;
        }
    }

    private abstract class BaseOperationBuilder<RET_PATH, RET_NAME, RET_VALUE, RET_INDEX, RET_SOURCE, RET_DESTINATION>
    implements IStepPath<RET_PATH>,
    IStepName<RET_NAME>,
    IStepValue<RET_VALUE>,
    IStepIndex<RET_INDEX>,
    IStepSource<RET_SOURCE>,
    IStepDestination<RET_DESTINATION>,
    IStepComplete {
        protected String myPath;
        protected String myName;
        protected IBase myValue;
        protected Integer myIndex;
        protected Integer mySource;
        protected Integer myDestination;

        protected BaseOperationBuilder() {
        }

        @Override
        public RET_PATH path(String thePath) {
            Validate.notBlank((CharSequence)thePath, (String)"thePath must not be blank", (Object[])new Object[0]);
            this.myPath = thePath;
            return (RET_PATH)this;
        }

        @Override
        public RET_NAME name(String theName) {
            Validate.notBlank((CharSequence)theName, (String)"theName must not be blank", (Object[])new Object[0]);
            this.myName = theName;
            return (RET_NAME)this;
        }

        @Override
        public RET_VALUE value(@Nonnull IBase theValue) {
            Validate.notNull((Object)theValue, (String)"theValue must not be null", (Object[])new Object[0]);
            this.myValue = theValue;
            return (RET_VALUE)this;
        }

        @Override
        public RET_INDEX index(int theIndex) {
            Validate.isTrue((theIndex >= 0 ? 1 : 0) != 0, (String)"theIndex must not be negative", (Object[])new Object[0]);
            this.myIndex = theIndex;
            return (RET_INDEX)this;
        }

        @Override
        public RET_DESTINATION destination(int theIndex) {
            Validate.isTrue((theIndex >= 0 ? 1 : 0) != 0, (String)"theIndex must not be negative", (Object[])new Object[0]);
            this.myDestination = theIndex;
            return (RET_DESTINATION)this;
        }

        @Override
        public RET_SOURCE source(int theIndex) {
            Validate.isTrue((theIndex >= 0 ? 1 : 0) != 0, (String)"theIndex must not be negative", (Object[])new Object[0]);
            this.mySource = theIndex;
            return (RET_SOURCE)this;
        }

        @Override
        public FhirPatchBuilder andThen() {
            return FhirPatchBuilder.this;
        }
    }

    public static interface IMoveStep3
    extends IStepDestination<IStepComplete> {
    }

    public static interface IMoveStep2
    extends IStepSource<IMoveStep3> {
    }

    public static interface IMoveStep1
    extends IStepPath<IMoveStep2> {
    }

    public static interface IReplaceStep2
    extends IStepValue<IStepComplete> {
    }

    public static interface IReplaceStep1
    extends IStepPath<IReplaceStep2> {
    }

    public static interface IDeleteStepAfter
    extends IStepComplete {
        public IDeleteStepAfter allowMultipleMatches();
    }

    public static interface IDeleteStep1
    extends IStepPath<IDeleteStepAfter> {
    }

    public static interface IInsertStep3
    extends IStepValue<IStepComplete> {
    }

    public static interface IInsertStep2
    extends IStepIndex<IInsertStep3> {
    }

    public static interface IInsertStep1
    extends IStepPath<IInsertStep2> {
    }

    public static interface IAddStep3
    extends IStepValue<IStepComplete> {
    }

    public static interface IAddStep2
    extends IStepName<IAddStep3> {
    }

    public static interface IAddStep1
    extends IStepPath<IAddStep2> {
    }

    public static interface IStepDestination<T> {
        public T destination(int var1);
    }

    public static interface IStepSource<T> {
        public T source(int var1);
    }

    public static interface IStepIndex<T> {
        public T index(int var1);
    }

    public static interface IStepValue<T> {
        public T value(IBase var1);
    }

    public static interface IStepName<T> {
        public T name(String var1);
    }

    public static interface IStepPath<T> {
        public T path(String var1);
    }

    public static interface IStepComplete {
        public FhirPatchBuilder andThen();
    }
}

