/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.util;

import ca.uhn.fhir.context.BaseRuntimeChildDefinition;
import ca.uhn.fhir.context.BaseRuntimeElementCompositeDefinition;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.util.ExtensionUtil;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseExtension;
import org.hl7.fhir.instance.model.api.IBaseHasExtensions;
import org.hl7.fhir.instance.model.api.IBaseMetaType;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaUtil {
    private static final Logger ourLog = LoggerFactory.getLogger(MetaUtil.class);

    private MetaUtil() {
    }

    public static String extractSourceUriOrEmpty(String theProvenanceSourceUri) {
        String sanitizedProvenance = StringUtils.defaultString((String)theProvenanceSourceUri);
        return StringUtils.substringBefore((String)sanitizedProvenance, (String)"#");
    }

    public static String getSource(FhirContext theContext, IBaseResource theResource) {
        return MetaUtil.getSource(theContext, theResource.getMeta());
    }

    public static String getSource(FhirContext theContext, IBaseMetaType theMeta) {
        if (theContext.getVersion().getVersion().isEqualOrNewerThan(FhirVersionEnum.R4)) {
            return MetaUtil.getSourceR4Plus(theContext, theMeta);
        }
        if (theContext.getVersion().getVersion().equals((Object)FhirVersionEnum.DSTU3)) {
            return MetaUtil.getSourceDstu3((IBaseHasExtensions)((Object)theMeta));
        }
        throw new UnsupportedOperationException(Msg.code(1782) + MetaUtil.class.getSimpleName() + ".getSource() not supported on FHIR Version " + String.valueOf((Object)theContext.getVersion().getVersion()));
    }

    private static String getSourceDstu3(IBaseHasExtensions theMeta) {
        IBaseHasExtensions metaWithExtensions = theMeta;
        List<IBaseExtension<?, ?>> extensions = metaWithExtensions.getExtension();
        for (IBaseExtension<?, ?> extension : extensions) {
            if (!"http://hapifhir.io/fhir/StructureDefinition/resource-meta-source".equals(extension.getUrl())) continue;
            IPrimitiveType value = (IPrimitiveType)extension.getValue();
            return value.getValueAsString();
        }
        return null;
    }

    private static String getSourceR4Plus(FhirContext theFhirContext, IBaseMetaType theMeta) {
        BaseRuntimeElementCompositeDefinition elementDef = (BaseRuntimeElementCompositeDefinition)theFhirContext.getElementDefinition(theMeta.getClass());
        BaseRuntimeChildDefinition sourceChild = elementDef.getChildByName("source");
        if (sourceChild == null) {
            return null;
        }
        List<IBase> sourceValues = sourceChild.getAccessor().getValues(theMeta);
        String retVal = null;
        if (sourceValues.size() > 0) {
            retVal = ((IPrimitiveType)sourceValues.get(0)).getValueAsString();
        }
        return retVal;
    }

    public static <R extends IBaseResource> void populateResourceSource(FhirContext theFhirContext, String theProvenanceSourceUri, String theProvenanceRequestId, R theRetVal) {
        Object sourceString = MetaUtil.extractSourceUriOrEmpty(theProvenanceSourceUri);
        if (StringUtils.isNotBlank((CharSequence)theProvenanceRequestId)) {
            sourceString = (String)sourceString + "#" + theProvenanceRequestId;
        }
        if (StringUtils.isNotBlank((CharSequence)sourceString)) {
            MetaUtil.setSource(theFhirContext, theRetVal, (String)sourceString);
        }
    }

    public static void setSource(FhirContext theContext, IBaseResource theResource, String theValue) {
        if (theContext.getVersion().getVersion().isEqualOrNewerThan(FhirVersionEnum.R4)) {
            MetaUtil.setSource(theContext, theResource.getMeta(), theValue);
        } else if (theContext.getVersion().getVersion().equals((Object)FhirVersionEnum.DSTU3)) {
            IBaseExtension<?, ?> sourceExtension = ((IBaseHasExtensions)((Object)theResource.getMeta())).addExtension();
            sourceExtension.setUrl("http://hapifhir.io/fhir/StructureDefinition/resource-meta-source");
            IPrimitiveType value = (IPrimitiveType)theContext.getElementDefinition("uri").newInstance();
            value.setValue(theValue);
            sourceExtension.setValue(value);
        } else {
            ourLog.debug(MetaUtil.class.getSimpleName() + ".setSource() not supported on FHIR Version " + String.valueOf((Object)theContext.getVersion().getVersion()));
        }
    }

    public static void setSource(FhirContext theContext, IBaseMetaType theMeta, String theValue) {
        IPrimitiveType sourceElement;
        BaseRuntimeElementCompositeDefinition elementDef = (BaseRuntimeElementCompositeDefinition)theContext.getElementDefinition(theMeta.getClass());
        BaseRuntimeChildDefinition sourceChild = elementDef.getChildByName("source");
        List<IBase> sourceValues = sourceChild.getAccessor().getValues(theMeta);
        if (sourceValues.size() > 0) {
            sourceElement = (IPrimitiveType)sourceValues.get(0);
        } else {
            sourceElement = (IPrimitiveType)theContext.getElementDefinition("uri").newInstance();
            sourceChild.getMutator().setValue(theMeta, sourceElement);
        }
        sourceElement.setValueAsString(theValue);
    }

    public static Set<String> getAutoVersionReferencesAtPath(IBaseMetaType theMeta, String theResourceType) {
        return ExtensionUtil.getExtensionPrimitiveValues(theMeta, "http://hapifhir.io/fhir/StructureDefinition/auto-version-references-at-path").stream().map(path -> String.format("%s.%s", theResourceType, path)).collect(Collectors.toSet());
    }
}

