/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.util;

import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Stream;

public class StopLimitAccumulator<T> {
    private final boolean isTruncated;
    private final List<T> myList;

    private StopLimitAccumulator(List<T> theList, boolean theIsTruncated) {
        this.myList = Collections.unmodifiableList(theList);
        this.isTruncated = theIsTruncated;
    }

    public static <T> StopLimitAccumulator<T> fromStreamAndLimit(@Nonnull Stream<T> theItemStream, long theLimit) {
        assert (theLimit > 0L);
        AtomicBoolean isBeyondLimit = new AtomicBoolean(false);
        ArrayList accumulator = new ArrayList();
        theItemStream.limit(theLimit + 1L).forEach(item -> {
            if ((long)accumulator.size() < theLimit) {
                accumulator.add(item);
            } else {
                isBeyondLimit.set(true);
            }
        });
        return new StopLimitAccumulator(accumulator, isBeyondLimit.get());
    }

    public boolean isTruncated() {
        return this.isTruncated;
    }

    public List<T> getItemList() {
        return this.myList;
    }
}

