/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.validation;

import ca.uhn.fhir.validation.ResultSeverityEnum;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class SingleValidationMessage {
    private Integer myLocationCol;
    private Integer myLocationLine;
    private String myLocationString;
    private String myMessage;
    private String myMessageId;
    private ResultSeverityEnum mySeverity;
    private List<String> mySliceMessages;

    public SingleValidationMessage() {
    }

    public SingleValidationMessage(SingleValidationMessage theMessage) {
        this.myLocationCol = theMessage.myLocationCol;
        this.myLocationLine = theMessage.myLocationLine;
        this.myLocationString = theMessage.myLocationString;
        this.myMessage = theMessage.myMessage;
        this.myMessageId = theMessage.myMessageId;
        this.mySeverity = theMessage.mySeverity;
        this.mySliceMessages = theMessage.mySliceMessages == null ? null : new ArrayList<String>(theMessage.mySliceMessages);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SingleValidationMessage)) {
            return false;
        }
        SingleValidationMessage other = (SingleValidationMessage)obj;
        EqualsBuilder b = new EqualsBuilder();
        b.append((Object)this.myLocationCol, (Object)other.myLocationCol);
        b.append((Object)this.myLocationLine, (Object)other.myLocationLine);
        b.append((Object)this.myLocationString, (Object)other.myLocationString);
        b.append((Object)this.myMessage, (Object)other.myMessage);
        b.append((Object)this.mySeverity, (Object)other.mySeverity);
        b.append(this.mySliceMessages, other.mySliceMessages);
        return b.isEquals();
    }

    public Integer getLocationCol() {
        return this.myLocationCol;
    }

    public Integer getLocationLine() {
        return this.myLocationLine;
    }

    public String getLocationString() {
        return this.myLocationString;
    }

    public String getMessage() {
        return this.myMessage;
    }

    public String getMessageId() {
        return this.myMessageId;
    }

    public ResultSeverityEnum getSeverity() {
        return this.mySeverity;
    }

    public int hashCode() {
        HashCodeBuilder b = new HashCodeBuilder();
        b.append((Object)this.myLocationCol);
        b.append((Object)this.myLocationCol);
        b.append((Object)this.myLocationString);
        b.append((Object)this.myMessage);
        b.append((Object)this.mySeverity);
        b.append(this.mySliceMessages);
        return b.toHashCode();
    }

    public void setLocationCol(Integer theLocationCol) {
        this.myLocationCol = theLocationCol;
    }

    public void setLocationLine(Integer theLocationLine) {
        this.myLocationLine = theLocationLine;
    }

    public void setLocationString(String theLocationString) {
        this.myLocationString = theLocationString;
    }

    public void setMessage(String theMessage) {
        this.myMessage = theMessage;
    }

    public void setMessageId(String messageId) {
        this.myMessageId = messageId;
    }

    public void setSeverity(ResultSeverityEnum theSeverity) {
        this.mySeverity = theSeverity;
    }

    public String toString() {
        ToStringBuilder b = new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE);
        if (this.myLocationCol != null || this.myLocationLine != null) {
            b.append("col", (Object)this.myLocationCol);
            b.append("row", (Object)this.myLocationLine);
        }
        if (this.myLocationString != null) {
            b.append("locationString", (Object)this.myLocationString);
        }
        b.append("message", (Object)this.myMessage);
        if (this.myMessageId != null) {
            b.append((Object)this.myMessageId);
        }
        if (this.mySeverity != null) {
            b.append("severity", (Object)this.mySeverity.getCode());
        }
        if (this.mySliceMessages != null) {
            b.append("sliceMessages", this.mySliceMessages);
        }
        return b.toString();
    }

    public void setSliceMessages(List<String> theSliceMessages) {
        this.mySliceMessages = theSliceMessages;
    }

    public List<String> getSliceMessages() {
        return this.mySliceMessages;
    }

    public boolean hasSliceMessages() {
        return ObjectUtils.isNotEmpty(this.mySliceMessages);
    }
}

