/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.client.method;

import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.model.api.IDatatype;
import ca.uhn.fhir.model.api.IQueryParameterAnd;
import ca.uhn.fhir.model.api.IQueryParameterOr;
import ca.uhn.fhir.model.api.IQueryParameterType;
import ca.uhn.fhir.rest.annotation.OperationParam;
import ca.uhn.fhir.rest.api.QualifiedParamList;
import ca.uhn.fhir.rest.api.ValidationModeEnum;
import ca.uhn.fhir.rest.client.method.IParameter;
import ca.uhn.fhir.rest.client.method.SearchParameter;
import ca.uhn.fhir.rest.param.DateRangeParam;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import ca.uhn.fhir.util.ParametersUtil;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IPrimitiveType;

public class OperationParameter
implements IParameter {
    private static final Class<? extends IQueryParameterType>[] COMPOSITE_TYPES = new Class[0];
    static final String REQUEST_CONTENTS_USERDATA_KEY = OperationParam.class.getName() + "_PARSED_RESOURCE";
    private final FhirContext myContext;
    private IOperationParamConverter myConverter;
    private int myMax;
    private int myMin;
    private final String myName;
    private Class<?> myParameterType;
    private String myParamType;
    private SearchParameter mySearchParameterBinding;

    public OperationParameter(FhirContext theCtx, String theOperationName, OperationParam theOperationParam) {
        this(theCtx, theOperationName, theOperationParam.name(), theOperationParam.min(), theOperationParam.max());
    }

    OperationParameter(FhirContext theCtx, String theOperationName, String theParameterName, int theMin, int theMax) {
        this.myName = theParameterName;
        this.myMin = theMin;
        this.myMax = theMax;
        this.myContext = theCtx;
    }

    protected FhirContext getContext() {
        return this.myContext;
    }

    public String getName() {
        return this.myName;
    }

    public String getParamType() {
        return this.myParamType;
    }

    public String getSearchParamType() {
        if (this.mySearchParameterBinding != null) {
            return this.mySearchParameterBinding.getParamType().getCode();
        }
        return null;
    }

    @Override
    public void initializeTypes(Method theMethod, Class<? extends Collection<?>> theOuterCollectionType, Class<? extends Collection<?>> theInnerCollectionType, Class<?> theParameterType) {
        if (this.getContext().getVersion().getVersion().isRi() && IDatatype.class.isAssignableFrom(theParameterType)) {
            throw new ConfigurationException("Incorrect use of type " + theParameterType.getSimpleName() + " as parameter type for method when context is for version " + this.getContext().getVersion().getVersion().name() + " in method: " + theMethod.toString());
        }
        this.myParameterType = theParameterType;
        if (theInnerCollectionType != null) {
            if (this.myMax == -2) {
                this.myMax = -1;
            }
        } else if (IQueryParameterAnd.class.isAssignableFrom(this.myParameterType)) {
            if (this.myMax == -2) {
                this.myMax = -1;
            }
        } else if (this.myMax == -2) {
            this.myMax = 1;
        }
        boolean typeIsConcrete = !this.myParameterType.isInterface() && !Modifier.isAbstract(this.myParameterType.getModifiers());
        boolean isSearchParam = IQueryParameterType.class.isAssignableFrom(this.myParameterType) || IQueryParameterOr.class.isAssignableFrom(this.myParameterType) || IQueryParameterAnd.class.isAssignableFrom(this.myParameterType);
        isSearchParam &= typeIsConcrete && !IBase.class.isAssignableFrom(this.myParameterType);
        if (!this.myParameterType.equals(IBase.class) && !this.myParameterType.equals(String.class)) {
            if (IBaseResource.class.isAssignableFrom(this.myParameterType) && this.myParameterType.isInterface()) {
                this.myParamType = "Resource";
            } else if (DateRangeParam.class.isAssignableFrom(this.myParameterType)) {
                this.myParamType = "date";
                this.myMax = 2;
            } else if (this.myParameterType.equals(ValidationModeEnum.class)) {
                this.myParamType = "code";
            } else if (IBase.class.isAssignableFrom(this.myParameterType) && typeIsConcrete) {
                this.myParamType = this.myContext.getElementDefinition(this.myParameterType).getName();
            } else if (isSearchParam) {
                this.myParamType = "string";
                this.mySearchParameterBinding = new SearchParameter(this.myName, this.myMin > 0);
                this.mySearchParameterBinding.setCompositeTypes(COMPOSITE_TYPES);
                this.mySearchParameterBinding.setType(this.myContext, theParameterType, theInnerCollectionType, theOuterCollectionType);
                this.myConverter = new OperationParamConverter();
            } else {
                throw new ConfigurationException("Invalid type for @OperationParam: " + this.myParameterType.getName());
            }
        }
    }

    public OperationParameter setConverter(IOperationParamConverter theConverter) {
        this.myConverter = theConverter;
        return this;
    }

    @Override
    public void translateClientArgumentIntoQueryArgument(FhirContext theContext, Object theSourceClientArgument, Map<String, List<String>> theTargetQueryArguments, IBaseResource theTargetResource) throws InternalErrorException {
        assert (theTargetResource != null);
        Object sourceClientArgument = theSourceClientArgument;
        if (sourceClientArgument == null) {
            return;
        }
        if (this.myConverter != null) {
            sourceClientArgument = this.myConverter.outgoingClient(sourceClientArgument);
        }
        ParametersUtil.addParameterToParameters((FhirContext)theContext, (IBaseResource)theTargetResource, (Object)sourceClientArgument, (String)this.myName);
    }

    public static void throwInvalidMode(String paramValues) {
        throw new InvalidRequestException("Invalid mode value: \"" + paramValues + "\"");
    }

    class OperationParamConverter
    implements IOperationParamConverter {
        public OperationParamConverter() {
            Validate.isTrue((OperationParameter.this.mySearchParameterBinding != null ? 1 : 0) != 0);
        }

        @Override
        public Object incomingServer(Object theObject) {
            IPrimitiveType obj = (IPrimitiveType)theObject;
            List<QualifiedParamList> paramList = Collections.singletonList(QualifiedParamList.splitQueryStringByCommasIgnoreEscape(null, (String)obj.getValueAsString()));
            return OperationParameter.this.mySearchParameterBinding.parse(OperationParameter.this.myContext, paramList);
        }

        @Override
        public Object outgoingClient(Object theObject) {
            IQueryParameterType obj = (IQueryParameterType)theObject;
            IPrimitiveType retVal = (IPrimitiveType)OperationParameter.this.myContext.getElementDefinition("string").newInstance();
            retVal.setValueAsString(obj.getValueAsQueryToken(OperationParameter.this.myContext));
            return retVal;
        }
    }

    static interface IOperationParamConverter {
        public Object incomingServer(Object var1);

        public Object outgoingClient(Object var1);
    }
}

