/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.client.method;

import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.rest.api.SummaryEnum;
import ca.uhn.fhir.rest.client.method.IParameter;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBaseResource;

public class ElementsParameter
implements IParameter {
    @Override
    public void translateClientArgumentIntoQueryArgument(FhirContext theContext, Object theSourceClientArgument, Map<String, List<String>> theTargetQueryArguments, IBaseResource theTargetResource) throws InternalErrorException {
        if (theSourceClientArgument instanceof Collection) {
            StringBuilder values = new StringBuilder();
            for (String next : (Collection)theSourceClientArgument) {
                if (!StringUtils.isNotBlank((CharSequence)next)) continue;
                if (values.length() > 0) {
                    values.append(',');
                }
                values.append(next);
            }
            theTargetQueryArguments.put("_elements", Collections.singletonList(values.toString()));
        } else {
            String elements = (String)theSourceClientArgument;
            if (elements != null) {
                theTargetQueryArguments.put("_elements", Collections.singletonList(elements));
            }
        }
    }

    @Override
    public void initializeTypes(Method theMethod, Class<? extends Collection<?>> theOuterCollectionType, Class<? extends Collection<?>> theInnerCollectionType, Class<?> theParameterType) {
        if (theOuterCollectionType != null) {
            throw new ConfigurationException("Method '" + theMethod.getName() + "' in type '" + theMethod.getDeclaringClass().getCanonicalName() + "' is of type " + SummaryEnum.class + " but can not be a collection of collections");
        }
    }
}

