/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.client.impl;

import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.rest.api.EncodingEnum;
import ca.uhn.fhir.rest.api.SummaryEnum;
import ca.uhn.fhir.rest.client.api.IClientInterceptor;
import ca.uhn.fhir.rest.client.api.IHttpClient;
import ca.uhn.fhir.rest.client.api.IRestfulClient;
import ca.uhn.fhir.rest.client.impl.ClientInvocationHandler;
import ca.uhn.fhir.rest.client.impl.RestfulClientFactory;
import ca.uhn.fhir.rest.client.method.BaseMethodBinding;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public class ClientInvocationHandlerFactory {
    private final Map<Method, BaseMethodBinding<?>> myBindings = new HashMap();
    private final IHttpClient myClient;
    private final FhirContext myContext;
    private final Map<Method, ILambda> myMethodToLambda = new HashMap<Method, ILambda>();
    private final Map<Method, Object> myMethodToReturnValue = new HashMap<Method, Object>();
    private final String myUrlBase;

    public ClientInvocationHandlerFactory(IHttpClient theClient, FhirContext theContext, String theUrlBase, Class<? extends IRestfulClient> theClientType) {
        this.myClient = theClient;
        this.myUrlBase = theUrlBase;
        this.myContext = theContext;
        try {
            this.myMethodToReturnValue.put(theClientType.getMethod("getFhirContext", new Class[0]), theContext);
            this.myMethodToReturnValue.put(theClientType.getMethod("getHttpClient", new Class[0]), theClient);
            this.myMethodToReturnValue.put(theClientType.getMethod("getServerBase", new Class[0]), theUrlBase);
            this.myMethodToLambda.put(theClientType.getMethod("setEncoding", EncodingEnum.class), new SetEncodingLambda());
            this.myMethodToLambda.put(theClientType.getMethod("setPrettyPrint", Boolean.class), new SetPrettyPrintLambda());
            this.myMethodToLambda.put(theClientType.getMethod("registerInterceptor", Object.class), new RegisterInterceptorLambda());
            this.myMethodToLambda.put(theClientType.getMethod("unregisterInterceptor", Object.class), new UnregisterInterceptorLambda());
            this.myMethodToLambda.put(theClientType.getMethod("setSummary", SummaryEnum.class), new SetSummaryLambda());
            this.myMethodToLambda.put(theClientType.getMethod("fetchResourceFromUrl", Class.class, String.class), new FetchResourceFromUrlLambda());
        }
        catch (NoSuchMethodException e) {
            throw new ConfigurationException("Failed to find methods on client. This is a HAPI bug!", (Throwable)e);
        }
        catch (SecurityException e) {
            throw new ConfigurationException("Failed to find methods on client. This is a HAPI bug!", (Throwable)e);
        }
    }

    public void addBinding(Method theMethod, BaseMethodBinding<?> theBinding) {
        this.myBindings.put(theMethod, theBinding);
    }

    ClientInvocationHandler newInvocationHandler(RestfulClientFactory theRestfulClientFactory) {
        return new ClientInvocationHandler(this.myClient, this.myContext, this.myUrlBase, this.myMethodToReturnValue, this.myBindings, this.myMethodToLambda, theRestfulClientFactory);
    }

    class UnregisterInterceptorLambda
    implements ILambda {
        UnregisterInterceptorLambda() {
        }

        @Override
        public Object handle(ClientInvocationHandler theTarget, Object[] theArgs) {
            IClientInterceptor interceptor = (IClientInterceptor)theArgs[0];
            theTarget.unregisterInterceptor(interceptor);
            return null;
        }
    }

    class SetSummaryLambda
    implements ILambda {
        SetSummaryLambda() {
        }

        @Override
        public Object handle(ClientInvocationHandler theTarget, Object[] theArgs) {
            SummaryEnum encoding = (SummaryEnum)theArgs[0];
            theTarget.setSummary(encoding);
            return null;
        }
    }

    class SetPrettyPrintLambda
    implements ILambda {
        SetPrettyPrintLambda() {
        }

        @Override
        public Object handle(ClientInvocationHandler theTarget, Object[] theArgs) {
            Boolean prettyPrint = (Boolean)theArgs[0];
            theTarget.setPrettyPrint(prettyPrint);
            return null;
        }
    }

    class SetEncodingLambda
    implements ILambda {
        SetEncodingLambda() {
        }

        @Override
        public Object handle(ClientInvocationHandler theTarget, Object[] theArgs) {
            EncodingEnum encoding = (EncodingEnum)theArgs[0];
            theTarget.setEncoding(encoding);
            return null;
        }
    }

    class FetchResourceFromUrlLambda
    implements ILambda {
        FetchResourceFromUrlLambda() {
        }

        @Override
        public Object handle(ClientInvocationHandler theTarget, Object[] theArgs) {
            Class type = (Class)theArgs[0];
            String url = (String)theArgs[1];
            return theTarget.fetchResourceFromUrl(type, url);
        }
    }

    class RegisterInterceptorLambda
    implements ILambda {
        RegisterInterceptorLambda() {
        }

        @Override
        public Object handle(ClientInvocationHandler theTarget, Object[] theArgs) {
            IClientInterceptor interceptor = (IClientInterceptor)theArgs[0];
            theTarget.registerInterceptor(interceptor);
            return null;
        }
    }

    public static interface ILambda {
        public Object handle(ClientInvocationHandler var1, Object[] var2);
    }
}

