/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.client.method;

import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.model.primitive.IdDt;
import ca.uhn.fhir.model.valueset.BundleTypeEnum;
import ca.uhn.fhir.rest.annotation.Elements;
import ca.uhn.fhir.rest.annotation.IdParam;
import ca.uhn.fhir.rest.annotation.Read;
import ca.uhn.fhir.rest.api.RestOperationTypeEnum;
import ca.uhn.fhir.rest.client.method.BaseResourceReturningMethodBinding;
import ca.uhn.fhir.rest.client.method.HttpGetClientInvocation;
import ca.uhn.fhir.rest.client.method.IClientResponseHandlerHandlesBinary;
import ca.uhn.fhir.rest.client.method.IParameter;
import ca.uhn.fhir.rest.param.ParameterUtil;
import ca.uhn.fhir.rest.server.exceptions.BaseServerResponseException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.instance.model.api.IBaseBinary;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;

public class ReadMethodBinding
extends BaseResourceReturningMethodBinding
implements IClientResponseHandlerHandlesBinary<Object> {
    private Integer myIdIndex;
    private boolean mySupportsVersion;
    private Class<? extends IIdType> myIdParameterType;

    public ReadMethodBinding(Class<? extends IBaseResource> theAnnotatedResourceType, Method theMethod, FhirContext theContext, Object theProvider) {
        super(theAnnotatedResourceType, theMethod, theContext, theProvider);
        Validate.notNull((Object)theMethod, (String)"Method must not be null", (Object[])new Object[0]);
        Integer idIndex = ParameterUtil.findIdParameterIndex((Method)theMethod, (FhirContext)this.getContext());
        Class<?>[] parameterTypes = theMethod.getParameterTypes();
        this.mySupportsVersion = theMethod.getAnnotation(Read.class).version();
        this.myIdIndex = idIndex;
        if (this.myIdIndex == null) {
            throw new ConfigurationException("@" + Read.class.getSimpleName() + " method " + theMethod.getName() + " on type \"" + theMethod.getDeclaringClass().getName() + "\" does not have a parameter annotated with @" + IdParam.class.getSimpleName());
        }
        this.myIdParameterType = parameterTypes[this.myIdIndex];
        if (!IIdType.class.isAssignableFrom(this.myIdParameterType)) {
            throw new ConfigurationException("ID parameter must be of type IdDt or IdType - Found: " + this.myIdParameterType);
        }
    }

    @Override
    public List<Class<?>> getAllowableParamAnnotations() {
        ArrayList retVal = new ArrayList();
        retVal.add(IdParam.class);
        retVal.add(Elements.class);
        return retVal;
    }

    @Override
    public RestOperationTypeEnum getRestOperationType() {
        return this.isVread() ? RestOperationTypeEnum.VREAD : RestOperationTypeEnum.READ;
    }

    @Override
    public BaseResourceReturningMethodBinding.ReturnTypeEnum getReturnType() {
        return BaseResourceReturningMethodBinding.ReturnTypeEnum.RESOURCE;
    }

    @Override
    public HttpGetClientInvocation invokeClient(Object[] theArgs) {
        IIdType id = (IIdType)theArgs[this.myIdIndex];
        String resourceName = this.getResourceName();
        HttpGetClientInvocation retVal = id.hasVersionIdPart() ? ReadMethodBinding.createVReadInvocation(this.getContext(), (IIdType)new IdDt(resourceName, id.getIdPart(), id.getVersionIdPart()), resourceName) : ReadMethodBinding.createReadInvocation(this.getContext(), id, resourceName);
        for (int idx = 0; idx < theArgs.length; ++idx) {
            IParameter nextParam = this.getParameters().get(idx);
            nextParam.translateClientArgumentIntoQueryArgument(this.getContext(), theArgs[idx], null, null);
        }
        return retVal;
    }

    @Override
    public Object invokeClientForBinary(String theResponseMimeType, InputStream theResponseReader, int theResponseStatusCode, Map<String, List<String>> theHeaders) throws IOException, BaseServerResponseException {
        byte[] contents = IOUtils.toByteArray((InputStream)theResponseReader);
        IBaseBinary resource = (IBaseBinary)this.getContext().getResourceDefinition("Binary").newInstance();
        resource.setContentType(theResponseMimeType);
        resource.setContent(contents);
        switch (this.getMethodReturnType()) {
            case LIST_OF_RESOURCES: {
                return Collections.singletonList(resource);
            }
            case RESOURCE: {
                return resource;
            }
        }
        throw new IllegalStateException("" + (Object)((Object)this.getMethodReturnType()));
    }

    @Override
    public boolean isBinary() {
        return "Binary".equals(this.getResourceName());
    }

    public boolean isVread() {
        return this.mySupportsVersion;
    }

    public static HttpGetClientInvocation createAbsoluteReadInvocation(FhirContext theContext, IIdType theId) {
        return new HttpGetClientInvocation(theContext, theId.toVersionless().getValue());
    }

    public static HttpGetClientInvocation createAbsoluteVReadInvocation(FhirContext theContext, IIdType theId) {
        return new HttpGetClientInvocation(theContext, theId.getValue());
    }

    public static HttpGetClientInvocation createReadInvocation(FhirContext theContext, IIdType theId, String theResourceName) {
        return new HttpGetClientInvocation(theContext, new IdDt(theResourceName, theId.getIdPart()).getValue());
    }

    public static HttpGetClientInvocation createVReadInvocation(FhirContext theContext, IIdType theId, String theResourceName) {
        return new HttpGetClientInvocation(theContext, new IdDt(theResourceName, theId.getIdPart(), theId.getVersionIdPart()).getValue());
    }

    @Override
    protected BundleTypeEnum getResponseBundleType() {
        return null;
    }
}

