/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.client.method;

import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.RuntimePrimitiveDatatypeDefinition;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.model.api.IQueryParameterAnd;
import ca.uhn.fhir.model.api.IQueryParameterOr;
import ca.uhn.fhir.model.api.IQueryParameterType;
import ca.uhn.fhir.model.base.composite.BaseIdentifierDt;
import ca.uhn.fhir.model.base.composite.BaseQuantityDt;
import ca.uhn.fhir.model.primitive.StringDt;
import ca.uhn.fhir.rest.api.QualifiedParamList;
import ca.uhn.fhir.rest.api.RestSearchParameterTypeEnum;
import ca.uhn.fhir.rest.client.method.BaseQueryParameter;
import ca.uhn.fhir.rest.param.CompositeAndListParam;
import ca.uhn.fhir.rest.param.CompositeOrListParam;
import ca.uhn.fhir.rest.param.CompositeParam;
import ca.uhn.fhir.rest.param.DateAndListParam;
import ca.uhn.fhir.rest.param.DateOrListParam;
import ca.uhn.fhir.rest.param.DateParam;
import ca.uhn.fhir.rest.param.DateRangeParam;
import ca.uhn.fhir.rest.param.HasAndListParam;
import ca.uhn.fhir.rest.param.HasOrListParam;
import ca.uhn.fhir.rest.param.HasParam;
import ca.uhn.fhir.rest.param.NumberAndListParam;
import ca.uhn.fhir.rest.param.NumberOrListParam;
import ca.uhn.fhir.rest.param.NumberParam;
import ca.uhn.fhir.rest.param.QuantityAndListParam;
import ca.uhn.fhir.rest.param.QuantityOrListParam;
import ca.uhn.fhir.rest.param.QuantityParam;
import ca.uhn.fhir.rest.param.ReferenceAndListParam;
import ca.uhn.fhir.rest.param.ReferenceOrListParam;
import ca.uhn.fhir.rest.param.ReferenceParam;
import ca.uhn.fhir.rest.param.StringAndListParam;
import ca.uhn.fhir.rest.param.StringOrListParam;
import ca.uhn.fhir.rest.param.StringParam;
import ca.uhn.fhir.rest.param.TokenAndListParam;
import ca.uhn.fhir.rest.param.TokenOrListParam;
import ca.uhn.fhir.rest.param.TokenParam;
import ca.uhn.fhir.rest.param.UriAndListParam;
import ca.uhn.fhir.rest.param.UriOrListParam;
import ca.uhn.fhir.rest.param.UriParam;
import ca.uhn.fhir.rest.param.binder.CalendarBinder;
import ca.uhn.fhir.rest.param.binder.DateBinder;
import ca.uhn.fhir.rest.param.binder.FhirPrimitiveBinder;
import ca.uhn.fhir.rest.param.binder.IParamBinder;
import ca.uhn.fhir.rest.param.binder.QueryParameterAndBinder;
import ca.uhn.fhir.rest.param.binder.QueryParameterOrBinder;
import ca.uhn.fhir.rest.param.binder.QueryParameterTypeBinder;
import ca.uhn.fhir.rest.param.binder.StringBinder;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.util.CollectionUtil;
import ca.uhn.fhir.util.ReflectionUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IPrimitiveType;

public class SearchParameter
extends BaseQueryParameter {
    private static final String EMPTY_STRING = "";
    private static HashMap<RestSearchParameterTypeEnum, Set<String>> ourParamQualifiers;
    private static HashMap<Class<?>, RestSearchParameterTypeEnum> ourParamTypes;
    static final String QUALIFIER_ANY_TYPE = ":*";
    private List<Class<? extends IQueryParameterType>> myCompositeTypes = Collections.emptyList();
    private List<Class<? extends IBaseResource>> myDeclaredTypes;
    private String myName;
    private IParamBinder<?> myParamBinder;
    private RestSearchParameterTypeEnum myParamType;
    private Set<String> myQualifierWhitelist;
    private boolean myRequired;
    private Class<?> myType;

    public SearchParameter() {
    }

    public SearchParameter(String theName, boolean theRequired) {
        this.myName = theName;
        this.myRequired = theRequired;
    }

    @Override
    public List<QualifiedParamList> encode(FhirContext theContext, Object theObject) throws InternalErrorException {
        ArrayList<QualifiedParamList> retVal = new ArrayList<QualifiedParamList>();
        IParamBinder<?> paramBinder = this.myParamBinder;
        List val = paramBinder.encode(theContext, theObject);
        for (IQueryParameterOr nextOr : val) {
            retVal.add(new QualifiedParamList(nextOr, theContext));
        }
        return retVal;
    }

    @Override
    public String getName() {
        return this.myName;
    }

    @Override
    public RestSearchParameterTypeEnum getParamType() {
        return this.myParamType;
    }

    public Class<?> getType() {
        return this.myType;
    }

    @Override
    public boolean isRequired() {
        return this.myRequired;
    }

    public void setChainlists(String[] theChainWhitelist) {
        this.myQualifierWhitelist = new HashSet<String>(theChainWhitelist.length);
        this.myQualifierWhitelist.add(QUALIFIER_ANY_TYPE);
        for (String chain : theChainWhitelist) {
            if (chain.equals("*")) {
                this.myQualifierWhitelist.add(".*");
                continue;
            }
            if (chain.equals(EMPTY_STRING)) {
                this.myQualifierWhitelist.add(".");
                continue;
            }
            this.myQualifierWhitelist.add("." + chain);
        }
    }

    public void setCompositeTypes(Class<? extends IQueryParameterType>[] theCompositeTypes) {
        this.myCompositeTypes = Arrays.asList(theCompositeTypes);
    }

    public void setDeclaredTypes(Class<? extends IBaseResource>[] theTypes) {
        this.myDeclaredTypes = Arrays.asList(theTypes);
    }

    public void setName(String name) {
        this.myName = name;
    }

    public void setRequired(boolean required) {
        this.myRequired = required;
    }

    public void setType(FhirContext theContext, Class<?> type, Class<? extends Collection<?>> theInnerCollectionType, Class<? extends Collection<?>> theOuterCollectionType) {
        Set<String> builtInQualifiers;
        this.myType = type;
        if (IQueryParameterType.class.isAssignableFrom(type)) {
            this.myParamBinder = new QueryParameterTypeBinder(type, this.myCompositeTypes);
        } else if (IQueryParameterOr.class.isAssignableFrom(type)) {
            this.myParamBinder = new QueryParameterOrBinder(type, this.myCompositeTypes);
        } else if (IQueryParameterAnd.class.isAssignableFrom(type)) {
            this.myParamBinder = new QueryParameterAndBinder(type, this.myCompositeTypes);
        } else if (String.class.equals(type)) {
            this.myParamBinder = new StringBinder();
            this.myParamType = RestSearchParameterTypeEnum.STRING;
        } else if (Date.class.equals(type)) {
            this.myParamBinder = new DateBinder();
            this.myParamType = RestSearchParameterTypeEnum.DATE;
        } else if (Calendar.class.equals(type)) {
            this.myParamBinder = new CalendarBinder();
            this.myParamType = RestSearchParameterTypeEnum.DATE;
        } else if (IPrimitiveType.class.isAssignableFrom(type) && ReflectionUtil.isInstantiable(type)) {
            RuntimePrimitiveDatatypeDefinition def = (RuntimePrimitiveDatatypeDefinition)theContext.getElementDefinition(type);
            if (def.getNativeType() != null) {
                if (def.getNativeType().equals(Date.class)) {
                    this.myParamBinder = new FhirPrimitiveBinder(type);
                    this.myParamType = RestSearchParameterTypeEnum.DATE;
                } else if (def.getNativeType().equals(String.class)) {
                    this.myParamBinder = new FhirPrimitiveBinder(type);
                    this.myParamType = RestSearchParameterTypeEnum.STRING;
                }
            }
        } else {
            throw new ConfigurationException(Msg.code((int)1406) + "Unsupported data type for parameter: " + type.getCanonicalName());
        }
        RestSearchParameterTypeEnum typeEnum = ourParamTypes.get(type);
        if (typeEnum != null && (builtInQualifiers = ourParamQualifiers.get(typeEnum)) != null) {
            if (this.myQualifierWhitelist != null) {
                HashSet<String> qualifierWhitelist = new HashSet<String>();
                qualifierWhitelist.addAll(this.myQualifierWhitelist);
                qualifierWhitelist.addAll(builtInQualifiers);
                this.myQualifierWhitelist = qualifierWhitelist;
            } else {
                this.myQualifierWhitelist = Collections.unmodifiableSet(builtInQualifiers);
            }
        }
        if (this.myParamType == null) {
            this.myParamType = typeEnum;
        }
        if (this.myParamType == null) {
            if (StringDt.class.isAssignableFrom(type)) {
                this.myParamType = RestSearchParameterTypeEnum.STRING;
            } else if (BaseIdentifierDt.class.isAssignableFrom(type)) {
                this.myParamType = RestSearchParameterTypeEnum.TOKEN;
            } else if (BaseQuantityDt.class.isAssignableFrom(type)) {
                this.myParamType = RestSearchParameterTypeEnum.QUANTITY;
            } else if (ReferenceParam.class.isAssignableFrom(type)) {
                this.myParamType = RestSearchParameterTypeEnum.REFERENCE;
            } else if (HasParam.class.isAssignableFrom(type)) {
                this.myParamType = RestSearchParameterTypeEnum.STRING;
            } else {
                throw new ConfigurationException(Msg.code((int)1407) + "Unknown search parameter type: " + type);
            }
        }
    }

    public String toString() {
        ToStringBuilder retVal = new ToStringBuilder((Object)this);
        retVal.append("name", (Object)this.myName);
        retVal.append("required", this.myRequired);
        return retVal.toString();
    }

    static {
        ourParamTypes = new HashMap();
        ourParamQualifiers = new HashMap();
        ourParamTypes.put(StringParam.class, RestSearchParameterTypeEnum.STRING);
        ourParamTypes.put(StringOrListParam.class, RestSearchParameterTypeEnum.STRING);
        ourParamTypes.put(StringAndListParam.class, RestSearchParameterTypeEnum.STRING);
        ourParamQualifiers.put(RestSearchParameterTypeEnum.STRING, CollectionUtil.newSet((Object[])new String[]{":exact", ":contains", ":missing", EMPTY_STRING}));
        ourParamTypes.put(UriParam.class, RestSearchParameterTypeEnum.URI);
        ourParamTypes.put(UriOrListParam.class, RestSearchParameterTypeEnum.URI);
        ourParamTypes.put(UriAndListParam.class, RestSearchParameterTypeEnum.URI);
        ourParamQualifiers.put(RestSearchParameterTypeEnum.URI, CollectionUtil.newSet((Object[])new String[]{":exact", ":missing", EMPTY_STRING}));
        ourParamTypes.put(TokenParam.class, RestSearchParameterTypeEnum.TOKEN);
        ourParamTypes.put(TokenOrListParam.class, RestSearchParameterTypeEnum.TOKEN);
        ourParamTypes.put(TokenAndListParam.class, RestSearchParameterTypeEnum.TOKEN);
        ourParamQualifiers.put(RestSearchParameterTypeEnum.TOKEN, CollectionUtil.newSet((Object[])new String[]{":text", ":missing", EMPTY_STRING}));
        ourParamTypes.put(DateParam.class, RestSearchParameterTypeEnum.DATE);
        ourParamTypes.put(DateOrListParam.class, RestSearchParameterTypeEnum.DATE);
        ourParamTypes.put(DateAndListParam.class, RestSearchParameterTypeEnum.DATE);
        ourParamTypes.put(DateRangeParam.class, RestSearchParameterTypeEnum.DATE);
        ourParamQualifiers.put(RestSearchParameterTypeEnum.DATE, CollectionUtil.newSet((Object[])new String[]{":missing", EMPTY_STRING}));
        ourParamTypes.put(QuantityParam.class, RestSearchParameterTypeEnum.QUANTITY);
        ourParamTypes.put(QuantityOrListParam.class, RestSearchParameterTypeEnum.QUANTITY);
        ourParamTypes.put(QuantityAndListParam.class, RestSearchParameterTypeEnum.QUANTITY);
        ourParamQualifiers.put(RestSearchParameterTypeEnum.QUANTITY, CollectionUtil.newSet((Object[])new String[]{":missing", EMPTY_STRING}));
        ourParamTypes.put(NumberParam.class, RestSearchParameterTypeEnum.NUMBER);
        ourParamTypes.put(NumberOrListParam.class, RestSearchParameterTypeEnum.NUMBER);
        ourParamTypes.put(NumberAndListParam.class, RestSearchParameterTypeEnum.NUMBER);
        ourParamQualifiers.put(RestSearchParameterTypeEnum.NUMBER, CollectionUtil.newSet((Object[])new String[]{":missing", EMPTY_STRING}));
        ourParamTypes.put(ReferenceParam.class, RestSearchParameterTypeEnum.REFERENCE);
        ourParamTypes.put(ReferenceOrListParam.class, RestSearchParameterTypeEnum.REFERENCE);
        ourParamTypes.put(ReferenceAndListParam.class, RestSearchParameterTypeEnum.REFERENCE);
        ourParamQualifiers.put(RestSearchParameterTypeEnum.REFERENCE, CollectionUtil.newSet((Object[])new String[]{":missing"}));
        ourParamTypes.put(CompositeParam.class, RestSearchParameterTypeEnum.COMPOSITE);
        ourParamTypes.put(CompositeOrListParam.class, RestSearchParameterTypeEnum.COMPOSITE);
        ourParamTypes.put(CompositeAndListParam.class, RestSearchParameterTypeEnum.COMPOSITE);
        ourParamQualifiers.put(RestSearchParameterTypeEnum.COMPOSITE, CollectionUtil.newSet((Object[])new String[]{":missing", EMPTY_STRING}));
        ourParamTypes.put(HasParam.class, RestSearchParameterTypeEnum.HAS);
        ourParamTypes.put(HasOrListParam.class, RestSearchParameterTypeEnum.HAS);
        ourParamTypes.put(HasAndListParam.class, RestSearchParameterTypeEnum.HAS);
    }
}

