/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.client.interceptor;

import ca.uhn.fhir.rest.client.api.IClientInterceptor;
import ca.uhn.fhir.rest.client.api.IHttpRequest;
import ca.uhn.fhir.rest.client.api.IHttpResponse;
import java.io.IOException;

public class UserInfoInterceptor
implements IClientInterceptor {
    public static final String HEADER_USER_ID = "fhir-user-id";
    public static final String HEADER_USER_NAME = "fhir-user-name";
    public static final String HEADER_APPLICATION_NAME = "fhir-app-name";
    private String myUserId;
    private String myUserName;
    private String myAppName;

    public UserInfoInterceptor(String theUserId, String theUserName, String theAppName) {
        this.myUserId = theUserId;
        this.myUserName = theUserName;
        this.myAppName = theAppName;
    }

    public void interceptRequest(IHttpRequest theRequest) {
        if (this.myUserId != null) {
            theRequest.addHeader(HEADER_USER_ID, this.myUserId);
        }
        if (this.myUserName != null) {
            theRequest.addHeader(HEADER_USER_NAME, this.myUserName);
        }
        if (this.myAppName != null) {
            theRequest.addHeader(HEADER_APPLICATION_NAME, this.myAppName);
        }
    }

    public void interceptResponse(IHttpResponse theResponse) throws IOException {
    }
}

