/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.client.apache;

import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.rest.client.api.IHttpResponse;
import ca.uhn.fhir.rest.client.impl.BaseHttpResponse;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.util.StopWatch;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModifiedStringApacheHttpResponse
extends BaseHttpResponse
implements IHttpResponse {
    private static final Logger ourLog = LoggerFactory.getLogger(ModifiedStringApacheHttpResponse.class);
    private boolean myEntityBuffered = false;
    private final String myNewContent;
    private final IHttpResponse myOrigHttpResponse;
    private byte[] myEntityBytes = null;

    public ModifiedStringApacheHttpResponse(IHttpResponse theOrigHttpResponse, String theNewContent, StopWatch theResponseStopWatch) {
        super(theResponseStopWatch);
        this.myOrigHttpResponse = theOrigHttpResponse;
        this.myNewContent = theNewContent;
    }

    public void bufferEntity() throws IOException {
        block9: {
            if (this.myEntityBuffered) {
                return;
            }
            try (InputStream respEntity = this.readEntity();){
                if (respEntity == null) break block9;
                try {
                    this.myEntityBytes = IOUtils.toByteArray((InputStream)respEntity);
                }
                catch (IllegalStateException exception) {
                    throw new InternalErrorException(Msg.code((int)2447) + exception);
                }
                this.myEntityBuffered = true;
            }
        }
    }

    public void close() {
        if (this.myOrigHttpResponse instanceof CloseableHttpResponse) {
            try {
                ((CloseableHttpResponse)this.myOrigHttpResponse).close();
            }
            catch (IOException exception) {
                ourLog.debug("Failed to close response", (Throwable)exception);
            }
        }
    }

    public Reader createReader() throws IOException {
        return new InputStreamReader(this.readEntity(), StandardCharsets.UTF_8);
    }

    public Map<String, List<String>> getAllHeaders() {
        return this.myOrigHttpResponse.getAllHeaders();
    }

    public List<String> getHeaders(String theName) {
        return this.myOrigHttpResponse.getHeaders(theName);
    }

    public String getMimeType() {
        return this.myOrigHttpResponse.getMimeType();
    }

    @Override
    public StopWatch getRequestStopWatch() {
        return this.myOrigHttpResponse.getRequestStopWatch();
    }

    public Object getResponse() {
        return null;
    }

    public int getStatus() {
        return this.myOrigHttpResponse.getStatus();
    }

    public String getStatusInfo() {
        return this.myOrigHttpResponse.getStatusInfo();
    }

    public InputStream readEntity() {
        if (this.myEntityBuffered) {
            return new ByteArrayInputStream(this.myEntityBytes);
        }
        return new ByteArrayInputStream(this.myNewContent.getBytes());
    }
}

