/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.client.apache;

import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.rest.client.api.IHttpResponse;
import ca.uhn.fhir.rest.client.impl.BaseHttpResponse;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.util.StopWatch;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.entity.ContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApacheHttpResponse
extends BaseHttpResponse
implements IHttpResponse {
    private static final Logger ourLog = LoggerFactory.getLogger(ApacheHttpResponse.class);
    private boolean myEntityBuffered = false;
    private byte[] myEntityBytes;
    private final HttpResponse myResponse;

    public ApacheHttpResponse(HttpResponse theResponse, StopWatch theResponseStopWatch) {
        super(theResponseStopWatch);
        this.myResponse = theResponse;
    }

    public void bufferEntity() throws IOException {
        block9: {
            if (this.myEntityBuffered) {
                return;
            }
            try (InputStream respEntity = this.readEntity();){
                if (respEntity == null) break block9;
                this.myEntityBuffered = true;
                try {
                    this.myEntityBytes = IOUtils.toByteArray((InputStream)respEntity);
                }
                catch (IllegalStateException e) {
                    throw new InternalErrorException(Msg.code((int)1478) + String.valueOf(e));
                }
            }
        }
    }

    public void close() {
        if (this.myResponse instanceof CloseableHttpResponse) {
            try {
                ((CloseableHttpResponse)this.myResponse).close();
            }
            catch (IOException e) {
                ourLog.debug("Failed to close response", (Throwable)e);
            }
        }
    }

    public Reader createReader() throws IOException {
        HttpEntity entity = this.myResponse.getEntity();
        if (entity == null) {
            return new StringReader("");
        }
        Charset charset = null;
        if (entity.getContentType() != null && entity.getContentType().getElements() != null && entity.getContentType().getElements().length > 0) {
            ContentType ct = ContentType.get((HttpEntity)entity);
            charset = ct.getCharset();
        }
        if (charset == null) {
            if (204 != this.myResponse.getStatusLine().getStatusCode()) {
                ourLog.debug("Response did not specify a charset, defaulting to utf-8");
            }
            charset = StandardCharsets.UTF_8;
        }
        return new InputStreamReader(this.readEntity(), charset);
    }

    public Map<String, List<String>> getAllHeaders() {
        HashMap<String, List<String>> headers = new HashMap<String, List<String>>();
        if (this.myResponse.getAllHeaders() != null) {
            for (Header next : this.myResponse.getAllHeaders()) {
                String name = next.getName().toLowerCase();
                List list = headers.computeIfAbsent(name, k -> new ArrayList());
                list.add(next.getValue());
            }
        }
        return headers;
    }

    public List<String> getHeaders(String theName) {
        Header[] headers = this.myResponse.getHeaders(theName);
        if (headers == null) {
            headers = new Header[]{};
        }
        ArrayList<String> retVal = new ArrayList<String>();
        for (Header next : headers) {
            retVal.add(next.getValue());
        }
        return retVal;
    }

    public String getMimeType() {
        ContentType ct = ContentType.get((HttpEntity)this.myResponse.getEntity());
        return ct != null ? ct.getMimeType() : null;
    }

    public HttpResponse getResponse() {
        return this.myResponse;
    }

    public int getStatus() {
        return this.myResponse.getStatusLine().getStatusCode();
    }

    public String getStatusInfo() {
        return this.myResponse.getStatusLine().getReasonPhrase();
    }

    public InputStream readEntity() throws IOException {
        if (this.myEntityBuffered) {
            return new ByteArrayInputStream(this.myEntityBytes);
        }
        if (this.myResponse.getEntity() != null) {
            return this.myResponse.getEntity().getContent();
        }
        return null;
    }
}

