/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.client.method;

import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.model.primitive.IntegerDt;
import ca.uhn.fhir.rest.annotation.Offset;
import ca.uhn.fhir.rest.client.method.IParameter;
import ca.uhn.fhir.rest.param.ParameterUtil;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.hl7.fhir.instance.model.api.IBaseResource;

public class OffsetParameter
implements IParameter {
    @Override
    public void translateClientArgumentIntoQueryArgument(FhirContext theContext, Object theSourceClientArgument, Map<String, List<String>> theTargetQueryArguments, IBaseResource theTargetResource) throws InternalErrorException {
        IntegerDt since;
        if (theSourceClientArgument != null && !(since = ParameterUtil.toInteger((Object)theSourceClientArgument)).isEmpty()) {
            theTargetQueryArguments.put("_offset", Collections.singletonList(since.getValueAsString()));
        }
    }

    @Override
    public void initializeTypes(Method theMethod, Class<? extends Collection<?>> theOuterCollectionType, Class<? extends Collection<?>> theInnerCollectionType, Class<?> theParameterType) {
        if (theOuterCollectionType != null) {
            throw new ConfigurationException(Msg.code((int)1476) + "Method '" + theMethod.getName() + "' in type '" + theMethod.getDeclaringClass().getCanonicalName() + "' is annotated with @" + Offset.class.getName() + " but can not be of collection type");
        }
        if (!ParameterUtil.isBindableIntegerType(theParameterType)) {
            throw new ConfigurationException(Msg.code((int)1477) + "Method '" + theMethod.getName() + "' in type '" + theMethod.getDeclaringClass().getCanonicalName() + "' is annotated with @" + Offset.class.getName() + " but type '" + String.valueOf(theParameterType) + "' is an invalid type, must be Integer or IntegerType");
        }
    }
}

