/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.client.method;

import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.model.valueset.BundleTypeEnum;
import ca.uhn.fhir.rest.annotation.Transaction;
import ca.uhn.fhir.rest.annotation.TransactionParam;
import ca.uhn.fhir.rest.api.RestOperationTypeEnum;
import ca.uhn.fhir.rest.client.impl.BaseHttpClientInvocation;
import ca.uhn.fhir.rest.client.method.BaseResourceReturningMethodBinding;
import ca.uhn.fhir.rest.client.method.HttpPostClientInvocation;
import ca.uhn.fhir.rest.client.method.IParameter;
import ca.uhn.fhir.rest.client.method.TransactionParameter;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import java.lang.reflect.Method;
import java.util.List;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseResource;

public class TransactionMethodBinding
extends BaseResourceReturningMethodBinding {
    private int myTransactionParamIndex = -1;

    public TransactionMethodBinding(Method theMethod, FhirContext theContext, Object theProvider) {
        super(null, theMethod, theContext, theProvider);
        int index = 0;
        for (IParameter next : this.getParameters()) {
            if (next instanceof TransactionParameter) {
                if (this.myTransactionParamIndex != -1) {
                    throw new ConfigurationException(Msg.code((int)1418) + "Method '" + theMethod.getName() + "' in type " + theMethod.getDeclaringClass().getCanonicalName() + " has multiple parameters annotated with the @" + String.valueOf(TransactionParam.class) + " annotation, exactly one is required for @" + String.valueOf(Transaction.class) + " methods");
                }
                this.myTransactionParamIndex = index;
            }
            ++index;
        }
        if (this.myTransactionParamIndex == -1) {
            throw new ConfigurationException(Msg.code((int)1419) + "Method '" + theMethod.getName() + "' in type " + theMethod.getDeclaringClass().getCanonicalName() + " does not have a parameter annotated with the @" + String.valueOf(TransactionParam.class) + " annotation");
        }
    }

    @Override
    public RestOperationTypeEnum getRestOperationType() {
        return RestOperationTypeEnum.TRANSACTION;
    }

    @Override
    protected BundleTypeEnum getResponseBundleType() {
        return BundleTypeEnum.TRANSACTION_RESPONSE;
    }

    @Override
    public BaseResourceReturningMethodBinding.ReturnTypeEnum getReturnType() {
        return BaseResourceReturningMethodBinding.ReturnTypeEnum.BUNDLE;
    }

    @Override
    public BaseHttpClientInvocation invokeClient(Object[] theArgs) throws InternalErrorException {
        FhirContext context = this.getContext();
        Object arg = theArgs[this.myTransactionParamIndex];
        if (arg instanceof IBaseBundle) {
            return TransactionMethodBinding.createTransactionInvocation((IBaseBundle)arg, context);
        }
        List resources = (List)arg;
        return TransactionMethodBinding.createTransactionInvocation(resources, context);
    }

    public static BaseHttpClientInvocation createTransactionInvocation(IBaseBundle theBundle, FhirContext theContext) {
        return new HttpPostClientInvocation(theContext, (IBaseResource)theBundle);
    }

    public static BaseHttpClientInvocation createTransactionInvocation(List<? extends IBaseResource> theResources, FhirContext theContext) {
        return new HttpPostClientInvocation(theContext, theResources, BundleTypeEnum.TRANSACTION);
    }

    public static BaseHttpClientInvocation createTransactionInvocation(String theRawBundle, FhirContext theContext) {
        return new HttpPostClientInvocation(theContext, theRawBundle, true, "");
    }
}

