/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.client.method;

import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.base.resource.BaseOperationOutcome;
import ca.uhn.fhir.parser.IParser;
import ca.uhn.fhir.rest.annotation.AddTags;
import ca.uhn.fhir.rest.annotation.Create;
import ca.uhn.fhir.rest.annotation.Delete;
import ca.uhn.fhir.rest.annotation.DeleteTags;
import ca.uhn.fhir.rest.annotation.GetPage;
import ca.uhn.fhir.rest.annotation.History;
import ca.uhn.fhir.rest.annotation.Metadata;
import ca.uhn.fhir.rest.annotation.Operation;
import ca.uhn.fhir.rest.annotation.Patch;
import ca.uhn.fhir.rest.annotation.Read;
import ca.uhn.fhir.rest.annotation.Search;
import ca.uhn.fhir.rest.annotation.Transaction;
import ca.uhn.fhir.rest.annotation.Update;
import ca.uhn.fhir.rest.annotation.Validate;
import ca.uhn.fhir.rest.api.EncodingEnum;
import ca.uhn.fhir.rest.api.MethodOutcome;
import ca.uhn.fhir.rest.api.RestOperationTypeEnum;
import ca.uhn.fhir.rest.client.exceptions.NonFhirResponseException;
import ca.uhn.fhir.rest.client.impl.BaseHttpClientInvocation;
import ca.uhn.fhir.rest.client.method.ConditionalParamBinder;
import ca.uhn.fhir.rest.client.method.ConformanceMethodBinding;
import ca.uhn.fhir.rest.client.method.CreateMethodBinding;
import ca.uhn.fhir.rest.client.method.DeleteMethodBinding;
import ca.uhn.fhir.rest.client.method.HistoryMethodBinding;
import ca.uhn.fhir.rest.client.method.IClientResponseHandler;
import ca.uhn.fhir.rest.client.method.IParameter;
import ca.uhn.fhir.rest.client.method.IncludeParameter;
import ca.uhn.fhir.rest.client.method.MethodUtil;
import ca.uhn.fhir.rest.client.method.OperationMethodBinding;
import ca.uhn.fhir.rest.client.method.PageMethodBinding;
import ca.uhn.fhir.rest.client.method.PatchMethodBinding;
import ca.uhn.fhir.rest.client.method.ReadMethodBinding;
import ca.uhn.fhir.rest.client.method.SearchMethodBinding;
import ca.uhn.fhir.rest.client.method.TransactionMethodBinding;
import ca.uhn.fhir.rest.client.method.UpdateMethodBinding;
import ca.uhn.fhir.rest.client.method.ValidateMethodBindingDstu2Plus;
import ca.uhn.fhir.rest.server.exceptions.BaseServerResponseException;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import ca.uhn.fhir.rest.server.exceptions.MethodNotAllowedException;
import ca.uhn.fhir.rest.server.exceptions.PreconditionFailedException;
import ca.uhn.fhir.rest.server.exceptions.ResourceNotFoundException;
import ca.uhn.fhir.rest.server.exceptions.ResourceVersionConflictException;
import ca.uhn.fhir.rest.server.exceptions.UnclassifiedServerFailureException;
import ca.uhn.fhir.rest.server.exceptions.UnprocessableEntityException;
import ca.uhn.fhir.util.ReflectionUtil;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.io.IOUtils;
import org.hl7.fhir.instance.model.api.IAnyResource;
import org.hl7.fhir.instance.model.api.IBaseOperationOutcome;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseMethodBinding<T>
implements IClientResponseHandler<T> {
    private static final Logger ourLog = LoggerFactory.getLogger(BaseMethodBinding.class);
    private final FhirContext myContext;
    private final Method myMethod;
    private List<IParameter> myParameters;
    private final Object myProvider;
    private boolean mySupportsConditional;
    private boolean mySupportsConditionalMultiple;

    public BaseMethodBinding(Method theMethod, FhirContext theContext, Object theProvider) {
        assert (theMethod != null);
        assert (theContext != null);
        this.myMethod = theMethod;
        this.myContext = theContext;
        this.myProvider = theProvider;
        this.myParameters = MethodUtil.getResourceParameters(theContext, theMethod, theProvider, this.getRestOperationType());
        for (IParameter next : this.myParameters) {
            if (!(next instanceof ConditionalParamBinder)) continue;
            this.mySupportsConditional = true;
            if (!((ConditionalParamBinder)next).isSupportsMultiple()) break;
            this.mySupportsConditionalMultiple = true;
            break;
        }
    }

    protected IParser createAppropriateParserForParsingResponse(String theResponseMimeType, InputStream theResponseInputStream, int theResponseStatusCode, List<Class<? extends IBaseResource>> thePreferTypes) {
        EncodingEnum encoding = EncodingEnum.forContentType((String)theResponseMimeType);
        if (encoding == null) {
            NonFhirResponseException ex = NonFhirResponseException.newInstance((int)theResponseStatusCode, (String)theResponseMimeType, (InputStream)theResponseInputStream);
            BaseMethodBinding.populateException((BaseServerResponseException)ex, theResponseInputStream);
            throw ex;
        }
        IParser parser = encoding.newParser(this.getContext());
        parser.setPreferTypes(thePreferTypes);
        return parser;
    }

    public List<Class<?>> getAllowableParamAnnotations() {
        return null;
    }

    public FhirContext getContext() {
        return this.myContext;
    }

    public Set<String> getIncludes() {
        TreeSet<String> retVal = new TreeSet<String>();
        for (IParameter next : this.myParameters) {
            if (!(next instanceof IncludeParameter)) continue;
            retVal.addAll(((IncludeParameter)next).getAllow());
        }
        return retVal;
    }

    public Method getMethod() {
        return this.myMethod;
    }

    public List<IParameter> getParameters() {
        return this.myParameters;
    }

    public Object getProvider() {
        return this.myProvider;
    }

    public abstract String getResourceName();

    public abstract RestOperationTypeEnum getRestOperationType();

    public abstract BaseHttpClientInvocation invokeClient(Object[] var1) throws InternalErrorException;

    public boolean isSupportsConditional() {
        return this.mySupportsConditional;
    }

    public boolean isSupportsConditionalMultiple() {
        return this.mySupportsConditionalMultiple;
    }

    protected BaseServerResponseException processNon2xxResponseAndReturnExceptionToThrow(int theStatusCode, String theResponseMimeType, InputStream theResponseInputStream) {
        InvalidRequestException ex = switch (theStatusCode) {
            case 400 -> new InvalidRequestException("Server responded with HTTP 400");
            case 404 -> new ResourceNotFoundException("Server responded with HTTP 404");
            case 405 -> new MethodNotAllowedException("Server responded with HTTP 405");
            case 409 -> new ResourceVersionConflictException("Server responded with HTTP 409");
            case 412 -> new PreconditionFailedException("Server responded with HTTP 412");
            case 422 -> {
                IParser parser = this.createAppropriateParserForParsingResponse(theResponseMimeType, theResponseInputStream, theStatusCode, null);
                BaseOperationOutcome operationOutcome = (BaseOperationOutcome)parser.parseResource(theResponseInputStream);
                yield new UnprocessableEntityException(this.myContext, (IBaseOperationOutcome)operationOutcome);
            }
            default -> new UnclassifiedServerFailureException(theStatusCode, "Server responded with HTTP " + theStatusCode);
        };
        BaseMethodBinding.populateException((BaseServerResponseException)ex, theResponseInputStream);
        return ex;
    }

    public void setParameters(List<IParameter> theParameters) {
        this.myParameters = theParameters;
    }

    public static BaseMethodBinding<?> bindMethod(Method theMethod, FhirContext theContext, Object theProvider) {
        Class returnType;
        Patch patch;
        GetPage getPage;
        Operation operation;
        Transaction transaction;
        DeleteTags deleteTags;
        AddTags addTags;
        Validate validate;
        History history;
        Delete delete;
        Update update;
        Create create;
        Metadata conformance;
        Search search;
        Read read = theMethod.getAnnotation(Read.class);
        if (!BaseMethodBinding.verifyMethodHasZeroOrOneOperationAnnotation(theMethod, read, search = theMethod.getAnnotation(Search.class), conformance = theMethod.getAnnotation(Metadata.class), create = theMethod.getAnnotation(Create.class), update = theMethod.getAnnotation(Update.class), delete = theMethod.getAnnotation(Delete.class), history = theMethod.getAnnotation(History.class), validate = theMethod.getAnnotation(Validate.class), addTags = theMethod.getAnnotation(AddTags.class), deleteTags = theMethod.getAnnotation(DeleteTags.class), transaction = theMethod.getAnnotation(Transaction.class), operation = theMethod.getAnnotation(Operation.class), getPage = theMethod.getAnnotation(GetPage.class), patch = theMethod.getAnnotation(Patch.class))) {
            return null;
        }
        if (getPage != null) {
            return new PageMethodBinding(theContext, theMethod);
        }
        Class<? extends IBaseResource> returnTypeFromRp = null;
        Class returnTypeFromMethod = theMethod.getReturnType();
        if (!MethodOutcome.class.isAssignableFrom(returnTypeFromMethod) && !Void.TYPE.equals(returnTypeFromMethod)) {
            if (Collection.class.isAssignableFrom(returnTypeFromMethod)) {
                returnTypeFromMethod = ReflectionUtil.getGenericCollectionTypeOfMethodReturnType((Method)theMethod);
                if (returnTypeFromMethod == null) {
                    ourLog.trace("Method {} returns a non-typed list, can't verify return type", (Object)theMethod);
                } else if (!BaseMethodBinding.verifyIsValidResourceReturnType(returnTypeFromMethod) && !BaseMethodBinding.isResourceInterface(returnTypeFromMethod)) {
                    throw new ConfigurationException(Msg.code((int)1427) + "Method '" + theMethod.getName() + "' from client type " + theMethod.getDeclaringClass().getCanonicalName() + " returns a collection with generic type " + BaseMethodBinding.toLogString(returnTypeFromMethod) + " - Must return a resource type or a collection (List, Set) with a resource type parameter (e.g. List<Patient> or List<IBaseResource> )");
                }
            } else if (!BaseMethodBinding.isResourceInterface(returnTypeFromMethod) && !BaseMethodBinding.verifyIsValidResourceReturnType(returnTypeFromMethod)) {
                throw new ConfigurationException(Msg.code((int)1428) + "Method '" + theMethod.getName() + "' from client type " + theMethod.getDeclaringClass().getCanonicalName() + " returns " + BaseMethodBinding.toLogString(returnTypeFromMethod) + " - Must return a resource type (eg Patient, Bundle, etc., see the documentation for more details)");
            }
        }
        Class returnTypeFromAnnotation = IBaseResource.class;
        if (read != null) {
            returnTypeFromAnnotation = read.type();
        } else if (search != null) {
            returnTypeFromAnnotation = search.type();
        } else if (history != null) {
            returnTypeFromAnnotation = history.type();
        } else if (delete != null) {
            returnTypeFromAnnotation = delete.type();
        } else if (patch != null) {
            returnTypeFromAnnotation = patch.type();
        } else if (create != null) {
            returnTypeFromAnnotation = create.type();
        } else if (update != null) {
            returnTypeFromAnnotation = update.type();
        } else if (validate != null) {
            returnTypeFromAnnotation = validate.type();
        } else if (addTags != null) {
            returnTypeFromAnnotation = addTags.type();
        } else if (deleteTags != null) {
            returnTypeFromAnnotation = deleteTags.type();
        }
        if (!BaseMethodBinding.isResourceInterface(returnTypeFromAnnotation)) {
            if (!BaseMethodBinding.verifyIsValidResourceReturnType(returnTypeFromAnnotation)) {
                throw new ConfigurationException(Msg.code((int)1429) + "Method '" + theMethod.getName() + "' from client type " + theMethod.getDeclaringClass().getCanonicalName() + " returns " + BaseMethodBinding.toLogString(returnTypeFromAnnotation) + " according to annotation - Must return a resource type");
            }
            returnType = returnTypeFromAnnotation;
        } else {
            returnType = returnTypeFromMethod;
        }
        if (read != null) {
            return new ReadMethodBinding(returnType, theMethod, theContext, theProvider);
        }
        if (search != null) {
            return new SearchMethodBinding(returnType, theMethod, theContext, theProvider);
        }
        if (conformance != null) {
            return new ConformanceMethodBinding(theMethod, theContext, theProvider);
        }
        if (create != null) {
            return new CreateMethodBinding(theMethod, theContext, theProvider);
        }
        if (update != null) {
            return new UpdateMethodBinding(theMethod, theContext, theProvider);
        }
        if (delete != null) {
            return new DeleteMethodBinding(theMethod, theContext, theProvider);
        }
        if (patch != null) {
            return new PatchMethodBinding(theMethod, theContext, theProvider);
        }
        if (history != null) {
            return new HistoryMethodBinding(theMethod, theContext, theProvider);
        }
        if (validate != null) {
            return new ValidateMethodBindingDstu2Plus(returnTypeFromRp, theMethod, theContext, theProvider, validate);
        }
        if (transaction != null) {
            return new TransactionMethodBinding(theMethod, theContext, theProvider);
        }
        if (operation != null) {
            return new OperationMethodBinding(returnType, returnTypeFromRp, theMethod, theContext, theProvider, operation);
        }
        throw new ConfigurationException(Msg.code((int)1430) + "Did not detect any FHIR annotations on method '" + theMethod.getName() + "' on type: " + theMethod.getDeclaringClass().getCanonicalName());
    }

    public static boolean isResourceInterface(Class<?> theReturnTypeFromMethod) {
        return theReturnTypeFromMethod.equals(IBaseResource.class) || theReturnTypeFromMethod.equals(IResource.class) || theReturnTypeFromMethod.equals(IAnyResource.class);
    }

    private static void populateException(BaseServerResponseException theEx, InputStream theResponseInputStream) {
        try {
            String responseText = IOUtils.toString((InputStream)theResponseInputStream);
            theEx.setResponseBody(responseText);
        }
        catch (IOException e) {
            ourLog.debug("Failed to read response", (Throwable)e);
        }
    }

    private static String toLogString(Class<?> theType) {
        if (theType == null) {
            return null;
        }
        return theType.getCanonicalName();
    }

    private static boolean verifyIsValidResourceReturnType(Class<?> theReturnType) {
        if (theReturnType == null) {
            return false;
        }
        return IBaseResource.class.isAssignableFrom(theReturnType);
    }

    public static boolean verifyMethodHasZeroOrOneOperationAnnotation(Method theNextMethod, Object ... theAnnotations) {
        Object obj1 = null;
        for (Object object : theAnnotations) {
            if (object == null) continue;
            if (obj1 == null) {
                obj1 = object;
                continue;
            }
            throw new ConfigurationException(Msg.code((int)1431) + "Method " + theNextMethod.getName() + " on type '" + theNextMethod.getDeclaringClass().getSimpleName() + " has annotations @" + obj1.getClass().getSimpleName() + " and @" + object.getClass().getSimpleName() + ". Can not have both.");
        }
        return obj1 != null;
    }
}

