/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.dstu2016may.model.Address;
import org.hl7.fhir.dstu2016may.model.Annotation;
import org.hl7.fhir.dstu2016may.model.BackboneElement;
import org.hl7.fhir.dstu2016may.model.Base64BinaryType;
import org.hl7.fhir.dstu2016may.model.Bundle;
import org.hl7.fhir.dstu2016may.model.CodeSystem;
import org.hl7.fhir.dstu2016may.model.CodeableConcept;
import org.hl7.fhir.dstu2016may.model.CompartmentDefinition;
import org.hl7.fhir.dstu2016may.model.ConceptMap;
import org.hl7.fhir.dstu2016may.model.Conformance;
import org.hl7.fhir.dstu2016may.model.ContactPoint;
import org.hl7.fhir.dstu2016may.model.Count;
import org.hl7.fhir.dstu2016may.model.DataElement;
import org.hl7.fhir.dstu2016may.model.DecimalType;
import org.hl7.fhir.dstu2016may.model.Distance;
import org.hl7.fhir.dstu2016may.model.DomainResource;
import org.hl7.fhir.dstu2016may.model.ElementDefinition;
import org.hl7.fhir.dstu2016may.model.Enumerations;
import org.hl7.fhir.dstu2016may.model.HumanName;
import org.hl7.fhir.dstu2016may.model.Identifier;
import org.hl7.fhir.dstu2016may.model.ImplementationGuide;
import org.hl7.fhir.dstu2016may.model.IntegerType;
import org.hl7.fhir.dstu2016may.model.MarkdownType;
import org.hl7.fhir.dstu2016may.model.Money;
import org.hl7.fhir.dstu2016may.model.NamingSystem;
import org.hl7.fhir.dstu2016may.model.Narrative;
import org.hl7.fhir.dstu2016may.model.OperationDefinition;
import org.hl7.fhir.dstu2016may.model.OperationOutcome;
import org.hl7.fhir.dstu2016may.model.Parameters;
import org.hl7.fhir.dstu2016may.model.Quantity;
import org.hl7.fhir.dstu2016may.model.Questionnaire;
import org.hl7.fhir.dstu2016may.model.QuestionnaireResponse;
import org.hl7.fhir.dstu2016may.model.Range;
import org.hl7.fhir.dstu2016may.model.Ratio;
import org.hl7.fhir.dstu2016may.model.SearchParameter;
import org.hl7.fhir.dstu2016may.model.SimpleQuantity;
import org.hl7.fhir.dstu2016may.model.StructureDefinition;
import org.hl7.fhir.dstu2016may.model.TestScript;
import org.hl7.fhir.dstu2016may.model.Timing;
import org.hl7.fhir.dstu2016may.model.UnsignedIntType;
import org.hl7.fhir.dstu2016may.model.ValueSet;
import org.hl7.fhir.dstu2016may.utils.ToolingExtensions;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.conformance.ProfileUtilities;
import org.hl7.fhir.r4.model.Address;
import org.hl7.fhir.r4.model.Age;
import org.hl7.fhir.r4.model.Attachment;
import org.hl7.fhir.r4.model.Binary;
import org.hl7.fhir.r4.model.BooleanType;
import org.hl7.fhir.r4.model.Bundle;
import org.hl7.fhir.r4.model.CanonicalType;
import org.hl7.fhir.r4.model.CapabilityStatement;
import org.hl7.fhir.r4.model.CodeSystem;
import org.hl7.fhir.r4.model.CodeType;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.CompartmentDefinition;
import org.hl7.fhir.r4.model.ConceptMap;
import org.hl7.fhir.r4.model.ContactDetail;
import org.hl7.fhir.r4.model.ContactPoint;
import org.hl7.fhir.r4.model.DateTimeType;
import org.hl7.fhir.r4.model.DateType;
import org.hl7.fhir.r4.model.Duration;
import org.hl7.fhir.r4.model.Element;
import org.hl7.fhir.r4.model.ElementDefinition;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.Enumerations;
import org.hl7.fhir.r4.model.Extension;
import org.hl7.fhir.r4.model.HumanName;
import org.hl7.fhir.r4.model.IdType;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.ImplementationGuide;
import org.hl7.fhir.r4.model.InstantType;
import org.hl7.fhir.r4.model.Meta;
import org.hl7.fhir.r4.model.NamingSystem;
import org.hl7.fhir.r4.model.Narrative;
import org.hl7.fhir.r4.model.OidType;
import org.hl7.fhir.r4.model.OperationDefinition;
import org.hl7.fhir.r4.model.OperationOutcome;
import org.hl7.fhir.r4.model.Parameters;
import org.hl7.fhir.r4.model.Period;
import org.hl7.fhir.r4.model.PositiveIntType;
import org.hl7.fhir.r4.model.Quantity;
import org.hl7.fhir.r4.model.Questionnaire;
import org.hl7.fhir.r4.model.QuestionnaireResponse;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r4.model.Resource;
import org.hl7.fhir.r4.model.SampledData;
import org.hl7.fhir.r4.model.SearchParameter;
import org.hl7.fhir.r4.model.Signature;
import org.hl7.fhir.r4.model.StringType;
import org.hl7.fhir.r4.model.StructureDefinition;
import org.hl7.fhir.r4.model.TestScript;
import org.hl7.fhir.r4.model.TimeType;
import org.hl7.fhir.r4.model.Timing;
import org.hl7.fhir.r4.model.Type;
import org.hl7.fhir.r4.model.UriType;
import org.hl7.fhir.r4.model.UrlType;
import org.hl7.fhir.r4.model.UsageContext;
import org.hl7.fhir.r4.model.UuidType;
import org.hl7.fhir.r4.model.ValueSet;
import org.hl7.fhir.utilities.Utilities;

public class VersionConvertor_14_40 {
    private static List<String> CANONICAL_URLS = new ArrayList<String>();

    private static void copyElement(org.hl7.fhir.dstu2016may.model.Element src, Element tgt) throws FHIRException {
        if (src.hasId()) {
            tgt.setId(src.getId());
        }
        for (org.hl7.fhir.dstu2016may.model.Extension e : src.getExtension()) {
            tgt.addExtension(VersionConvertor_14_40.convertExtension(e));
        }
    }

    private static void copyElement(Element src, org.hl7.fhir.dstu2016may.model.Element tgt) throws FHIRException {
        if (src.hasId()) {
            tgt.setId(src.getId());
        }
        for (Extension e : src.getExtension()) {
            tgt.addExtension(VersionConvertor_14_40.convertExtension(e));
        }
    }

    private static void copyBackboneElement(BackboneElement src, org.hl7.fhir.r4.model.BackboneElement tgt) throws FHIRException {
        VersionConvertor_14_40.copyElement((org.hl7.fhir.dstu2016may.model.Element)src, (Element)tgt);
        for (org.hl7.fhir.dstu2016may.model.Extension e : src.getModifierExtension()) {
            tgt.addModifierExtension(VersionConvertor_14_40.convertExtension(e));
        }
    }

    private static void copyBackboneElement(org.hl7.fhir.r4.model.BackboneElement src, BackboneElement tgt) throws FHIRException {
        VersionConvertor_14_40.copyElement((Element)src, (org.hl7.fhir.dstu2016may.model.Element)tgt);
        for (Extension e : src.getModifierExtension()) {
            tgt.addModifierExtension(VersionConvertor_14_40.convertExtension(e));
        }
    }

    public static org.hl7.fhir.r4.model.Base64BinaryType convertBase64Binary(Base64BinaryType src) throws FHIRException {
        org.hl7.fhir.r4.model.Base64BinaryType tgt = new org.hl7.fhir.r4.model.Base64BinaryType();
        if (src.hasValue()) {
            tgt.setValue(src.getValue());
        }
        VersionConvertor_14_40.copyElement((org.hl7.fhir.dstu2016may.model.Element)src, (Element)tgt);
        return tgt;
    }

    public static Base64BinaryType convertBase64Binary(org.hl7.fhir.r4.model.Base64BinaryType src) throws FHIRException {
        Base64BinaryType tgt = new Base64BinaryType();
        if (src.hasValue()) {
            tgt.setValue(src.getValue());
        }
        VersionConvertor_14_40.copyElement((Element)src, (org.hl7.fhir.dstu2016may.model.Element)tgt);
        return tgt;
    }

    public static BooleanType convertBoolean(org.hl7.fhir.dstu2016may.model.BooleanType src) throws FHIRException {
        BooleanType tgt = new BooleanType();
        if (src.hasValue()) {
            tgt.setValue(src.getValue());
        }
        VersionConvertor_14_40.copyElement((org.hl7.fhir.dstu2016may.model.Element)src, (Element)tgt);
        return tgt;
    }

    public static org.hl7.fhir.dstu2016may.model.BooleanType convertBoolean(BooleanType src) throws FHIRException {
        org.hl7.fhir.dstu2016may.model.BooleanType tgt = new org.hl7.fhir.dstu2016may.model.BooleanType();
        if (src.hasValue()) {
            tgt.setValue(src.getValue());
        }
        VersionConvertor_14_40.copyElement((Element)src, (org.hl7.fhir.dstu2016may.model.Element)tgt);
        return tgt;
    }

    public static CodeType convertCode(org.hl7.fhir.dstu2016may.model.CodeType src) throws FHIRException {
        CodeType tgt = new CodeType();
        if (src.hasValue()) {
            tgt.setValue(src.getValue());
        }
        VersionConvertor_14_40.copyElement((org.hl7.fhir.dstu2016may.model.Element)src, (Element)tgt);
        return tgt;
    }

    public static org.hl7.fhir.dstu2016may.model.CodeType convertCode(CodeType src) throws FHIRException {
        org.hl7.fhir.dstu2016may.model.CodeType tgt = new org.hl7.fhir.dstu2016may.model.CodeType();
        if (src.hasValue()) {
            tgt.setValue(src.getValue());
        }
        VersionConvertor_14_40.copyElement((Element)src, (org.hl7.fhir.dstu2016may.model.Element)tgt);
        return tgt;
    }

    public static DateType convertDate(org.hl7.fhir.dstu2016may.model.DateType src) throws FHIRException {
        DateType tgt = new DateType();
        if (src.hasValue()) {
            tgt.setValue((Date)src.getValue());
        }
        VersionConvertor_14_40.copyElement((org.hl7.fhir.dstu2016may.model.Element)src, (Element)tgt);
        return tgt;
    }

    public static org.hl7.fhir.dstu2016may.model.DateType convertDate(DateType src) throws FHIRException {
        org.hl7.fhir.dstu2016may.model.DateType tgt = new org.hl7.fhir.dstu2016may.model.DateType();
        if (src.hasValue()) {
            tgt.setValue((Date)src.getValue());
        }
        VersionConvertor_14_40.copyElement((Element)src, (org.hl7.fhir.dstu2016may.model.Element)tgt);
        return tgt;
    }

    public static DateTimeType convertDateTime(org.hl7.fhir.dstu2016may.model.DateTimeType src) throws FHIRException {
        DateTimeType tgt = new DateTimeType();
        if (src.hasValue()) {
            tgt.setValue((Date)src.getValue());
        }
        VersionConvertor_14_40.copyElement((org.hl7.fhir.dstu2016may.model.Element)src, (Element)tgt);
        return tgt;
    }

    public static org.hl7.fhir.dstu2016may.model.DateTimeType convertDateTime(DateTimeType src) throws FHIRException {
        org.hl7.fhir.dstu2016may.model.DateTimeType tgt = new org.hl7.fhir.dstu2016may.model.DateTimeType();
        if (src.hasValue()) {
            tgt.setValue((Date)src.getValue());
        }
        VersionConvertor_14_40.copyElement((Element)src, (org.hl7.fhir.dstu2016may.model.Element)tgt);
        return tgt;
    }

    public static org.hl7.fhir.r4.model.DecimalType convertDecimal(DecimalType src) throws FHIRException {
        org.hl7.fhir.r4.model.DecimalType tgt = new org.hl7.fhir.r4.model.DecimalType();
        if (src.hasValue()) {
            tgt.setValue(src.getValue());
        }
        VersionConvertor_14_40.copyElement((org.hl7.fhir.dstu2016may.model.Element)src, (Element)tgt);
        return tgt;
    }

    public static DecimalType convertDecimal(org.hl7.fhir.r4.model.DecimalType src) throws FHIRException {
        DecimalType tgt = new DecimalType();
        if (src.hasValue()) {
            tgt.setValue(src.getValue());
        }
        VersionConvertor_14_40.copyElement((Element)src, (org.hl7.fhir.dstu2016may.model.Element)tgt);
        return tgt;
    }

    public static IdType convertId(org.hl7.fhir.dstu2016may.model.IdType src) throws FHIRException {
        IdType tgt = new IdType();
        if (src.hasValue()) {
            tgt.setValue(src.getValue());
        }
        VersionConvertor_14_40.copyElement((org.hl7.fhir.dstu2016may.model.Element)src, (Element)tgt);
        return tgt;
    }

    public static org.hl7.fhir.dstu2016may.model.IdType convertId(IdType src) throws FHIRException {
        org.hl7.fhir.dstu2016may.model.IdType tgt = new org.hl7.fhir.dstu2016may.model.IdType();
        if (src.hasValue()) {
            tgt.setValue(src.getValue());
        }
        VersionConvertor_14_40.copyElement((Element)src, (org.hl7.fhir.dstu2016may.model.Element)tgt);
        return tgt;
    }

    public static InstantType convertInstant(org.hl7.fhir.dstu2016may.model.InstantType src) throws FHIRException {
        InstantType tgt = new InstantType();
        if (src.hasValue()) {
            tgt.setValue((Date)src.getValue());
        }
        VersionConvertor_14_40.copyElement((org.hl7.fhir.dstu2016may.model.Element)src, (Element)tgt);
        return tgt;
    }

    public static org.hl7.fhir.dstu2016may.model.InstantType convertInstant(InstantType src) throws FHIRException {
        org.hl7.fhir.dstu2016may.model.InstantType tgt = new org.hl7.fhir.dstu2016may.model.InstantType();
        if (src.hasValue()) {
            tgt.setValue((Date)src.getValue());
        }
        VersionConvertor_14_40.copyElement((Element)src, (org.hl7.fhir.dstu2016may.model.Element)tgt);
        return tgt;
    }

    public static org.hl7.fhir.r4.model.IntegerType convertInteger(IntegerType src) throws FHIRException {
        org.hl7.fhir.r4.model.IntegerType tgt = new org.hl7.fhir.r4.model.IntegerType();
        if (src.hasValue()) {
            tgt.setValue(src.getValue());
        }
        VersionConvertor_14_40.copyElement((org.hl7.fhir.dstu2016may.model.Element)src, (Element)tgt);
        return tgt;
    }

    public static IntegerType convertInteger(org.hl7.fhir.r4.model.IntegerType src) throws FHIRException {
        IntegerType tgt = new IntegerType();
        if (src.hasValue()) {
            tgt.setValue(src.getValue());
        }
        VersionConvertor_14_40.copyElement((Element)src, (org.hl7.fhir.dstu2016may.model.Element)tgt);
        return tgt;
    }

    public static org.hl7.fhir.r4.model.MarkdownType convertMarkdown(MarkdownType src) throws FHIRException {
        org.hl7.fhir.r4.model.MarkdownType tgt = new org.hl7.fhir.r4.model.MarkdownType();
        if (src.hasValue()) {
            tgt.setValue(src.getValue());
        }
        VersionConvertor_14_40.copyElement((org.hl7.fhir.dstu2016may.model.Element)src, (Element)tgt);
        return tgt;
    }

    public static MarkdownType convertMarkdown(org.hl7.fhir.r4.model.MarkdownType src) throws FHIRException {
        MarkdownType tgt = new MarkdownType();
        if (src.hasValue()) {
            tgt.setValue(src.getValue());
        }
        VersionConvertor_14_40.copyElement((Element)src, (org.hl7.fhir.dstu2016may.model.Element)tgt);
        return tgt;
    }

    public static OidType convertOid(org.hl7.fhir.dstu2016may.model.OidType src) throws FHIRException {
        OidType tgt = new OidType();
        if (src.hasValue()) {
            tgt.setValue(src.getValue());
        }
        VersionConvertor_14_40.copyElement((org.hl7.fhir.dstu2016may.model.Element)src, (Element)tgt);
        return tgt;
    }

    public static org.hl7.fhir.dstu2016may.model.OidType convertOid(OidType src) throws FHIRException {
        org.hl7.fhir.dstu2016may.model.OidType tgt = new org.hl7.fhir.dstu2016may.model.OidType();
        if (src.hasValue()) {
            tgt.setValue(src.getValue());
        }
        VersionConvertor_14_40.copyElement((Element)src, (org.hl7.fhir.dstu2016may.model.Element)tgt);
        return tgt;
    }

    public static PositiveIntType convertPositiveInt(org.hl7.fhir.dstu2016may.model.PositiveIntType src) throws FHIRException {
        PositiveIntType tgt = new PositiveIntType();
        if (src.hasValue()) {
            tgt.setValue(src.getValue());
        }
        VersionConvertor_14_40.copyElement((org.hl7.fhir.dstu2016may.model.Element)src, (Element)tgt);
        return tgt;
    }

    public static org.hl7.fhir.dstu2016may.model.PositiveIntType convertPositiveInt(PositiveIntType src) throws FHIRException {
        org.hl7.fhir.dstu2016may.model.PositiveIntType tgt = new org.hl7.fhir.dstu2016may.model.PositiveIntType();
        if (src.hasValue()) {
            tgt.setValue(src.getValue());
        }
        VersionConvertor_14_40.copyElement((Element)src, (org.hl7.fhir.dstu2016may.model.Element)tgt);
        return tgt;
    }

    public static StringType convertString(org.hl7.fhir.dstu2016may.model.StringType src) throws FHIRException {
        StringType tgt = new StringType();
        if (src.hasValue()) {
            tgt.setValue(src.getValue());
        }
        VersionConvertor_14_40.copyElement((org.hl7.fhir.dstu2016may.model.Element)src, (Element)tgt);
        return tgt;
    }

    public static org.hl7.fhir.dstu2016may.model.StringType convertString(StringType src) throws FHIRException {
        org.hl7.fhir.dstu2016may.model.StringType tgt = new org.hl7.fhir.dstu2016may.model.StringType();
        if (src.hasValue()) {
            tgt.setValue(src.getValue());
        }
        VersionConvertor_14_40.copyElement((Element)src, (org.hl7.fhir.dstu2016may.model.Element)tgt);
        return tgt;
    }

    public static TimeType convertTime(org.hl7.fhir.dstu2016may.model.TimeType src) throws FHIRException {
        TimeType tgt = new TimeType();
        if (src.hasValue()) {
            tgt.setValue(src.getValue());
        }
        VersionConvertor_14_40.copyElement((org.hl7.fhir.dstu2016may.model.Element)src, (Element)tgt);
        return tgt;
    }

    public static org.hl7.fhir.dstu2016may.model.TimeType convertTime(TimeType src) throws FHIRException {
        org.hl7.fhir.dstu2016may.model.TimeType tgt = new org.hl7.fhir.dstu2016may.model.TimeType();
        if (src.hasValue()) {
            tgt.setValue(src.getValue());
        }
        VersionConvertor_14_40.copyElement((Element)src, (org.hl7.fhir.dstu2016may.model.Element)tgt);
        return tgt;
    }

    public static org.hl7.fhir.r4.model.UnsignedIntType convertUnsignedInt(UnsignedIntType src) throws FHIRException {
        org.hl7.fhir.r4.model.UnsignedIntType tgt = new org.hl7.fhir.r4.model.UnsignedIntType();
        if (src.hasValue()) {
            tgt.setValue(src.getValue());
        }
        VersionConvertor_14_40.copyElement((org.hl7.fhir.dstu2016may.model.Element)src, (Element)tgt);
        return tgt;
    }

    public static UnsignedIntType convertUnsignedInt(org.hl7.fhir.r4.model.UnsignedIntType src) throws FHIRException {
        UnsignedIntType tgt = new UnsignedIntType();
        if (src.hasValue()) {
            tgt.setValue(src.getValue());
        }
        VersionConvertor_14_40.copyElement((Element)src, (org.hl7.fhir.dstu2016may.model.Element)tgt);
        return tgt;
    }

    public static UriType convertUri(org.hl7.fhir.dstu2016may.model.UriType src) throws FHIRException {
        UriType tgt = new UriType();
        if (src.hasValue()) {
            tgt.setValue(src.getValue());
        }
        VersionConvertor_14_40.copyElement((org.hl7.fhir.dstu2016may.model.Element)src, (Element)tgt);
        return tgt;
    }

    public static UrlType convertUriToUrl(org.hl7.fhir.dstu2016may.model.UriType src) throws FHIRException {
        UrlType tgt = new UrlType();
        if (src.hasValue()) {
            tgt.setValue(src.getValue());
        }
        VersionConvertor_14_40.copyElement((org.hl7.fhir.dstu2016may.model.Element)src, (Element)tgt);
        return tgt;
    }

    public static org.hl7.fhir.dstu2016may.model.UriType convertUri(UriType src) throws FHIRException {
        org.hl7.fhir.dstu2016may.model.UriType tgt = new org.hl7.fhir.dstu2016may.model.UriType();
        if (src.hasValue()) {
            tgt.setValue(src.getValue());
        }
        VersionConvertor_14_40.copyElement((Element)src, (org.hl7.fhir.dstu2016may.model.Element)tgt);
        return tgt;
    }

    public static UuidType convertUuid(org.hl7.fhir.dstu2016may.model.UuidType src) throws FHIRException {
        UuidType tgt = new UuidType();
        if (src.hasValue()) {
            tgt.setValue(src.getValue());
        }
        VersionConvertor_14_40.copyElement((org.hl7.fhir.dstu2016may.model.Element)src, (Element)tgt);
        return tgt;
    }

    public static org.hl7.fhir.dstu2016may.model.UuidType convertUuid(UuidType src) throws FHIRException {
        org.hl7.fhir.dstu2016may.model.UuidType tgt = new org.hl7.fhir.dstu2016may.model.UuidType();
        if (src.hasValue()) {
            tgt.setValue(src.getValue());
        }
        VersionConvertor_14_40.copyElement((Element)src, (org.hl7.fhir.dstu2016may.model.Element)tgt);
        return tgt;
    }

    public static Extension convertExtension(org.hl7.fhir.dstu2016may.model.Extension src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Extension tgt = new Extension();
        VersionConvertor_14_40.copyElement((org.hl7.fhir.dstu2016may.model.Element)src, (Element)tgt);
        tgt.setUrl(src.getUrl());
        if (src.hasValue()) {
            if (CANONICAL_URLS.contains(src.getUrl()) && src.getValue() instanceof org.hl7.fhir.dstu2016may.model.Reference) {
                tgt.setValue((Type)VersionConvertor_14_40.convertReferenceToCanonical((org.hl7.fhir.dstu2016may.model.Reference)src.getValue()));
            } else {
                tgt.setValue(VersionConvertor_14_40.convertType(src.getValue()));
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2016may.model.Extension convertExtension(Extension src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2016may.model.Extension tgt = new org.hl7.fhir.dstu2016may.model.Extension();
        VersionConvertor_14_40.copyElement((Element)src, (org.hl7.fhir.dstu2016may.model.Element)tgt);
        tgt.setUrl(src.getUrl());
        if (src.hasValue()) {
            if (CANONICAL_URLS.contains(src.getUrl()) && src.getValue() instanceof CanonicalType) {
                tgt.setValue((org.hl7.fhir.dstu2016may.model.Type)VersionConvertor_14_40.convertCanonicalToReference((CanonicalType)src.getValue()));
            } else {
                tgt.setValue(VersionConvertor_14_40.convertType(src.getValue()));
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.Narrative convertNarrative(Narrative src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r4.model.Narrative tgt = new org.hl7.fhir.r4.model.Narrative();
        VersionConvertor_14_40.copyElement((org.hl7.fhir.dstu2016may.model.Element)src, (Element)tgt);
        tgt.setStatus(VersionConvertor_14_40.convertNarrativeStatus(src.getStatus()));
        tgt.setDiv(src.getDiv());
        return tgt;
    }

    public static Narrative convertNarrative(org.hl7.fhir.r4.model.Narrative src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Narrative tgt = new Narrative();
        VersionConvertor_14_40.copyElement((Element)src, (org.hl7.fhir.dstu2016may.model.Element)tgt);
        tgt.setStatus(VersionConvertor_14_40.convertNarrativeStatus(src.getStatus()));
        tgt.setDiv(src.getDiv());
        return tgt;
    }

    private static Narrative.NarrativeStatus convertNarrativeStatus(Narrative.NarrativeStatus src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case GENERATED: {
                return Narrative.NarrativeStatus.GENERATED;
            }
            case EXTENSIONS: {
                return Narrative.NarrativeStatus.EXTENSIONS;
            }
            case ADDITIONAL: {
                return Narrative.NarrativeStatus.ADDITIONAL;
            }
            case EMPTY: {
                return Narrative.NarrativeStatus.EMPTY;
            }
        }
        return Narrative.NarrativeStatus.NULL;
    }

    private static Narrative.NarrativeStatus convertNarrativeStatus(Narrative.NarrativeStatus src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case GENERATED: {
                return Narrative.NarrativeStatus.GENERATED;
            }
            case EXTENSIONS: {
                return Narrative.NarrativeStatus.EXTENSIONS;
            }
            case ADDITIONAL: {
                return Narrative.NarrativeStatus.ADDITIONAL;
            }
            case EMPTY: {
                return Narrative.NarrativeStatus.EMPTY;
            }
        }
        return Narrative.NarrativeStatus.NULL;
    }

    public static Age convertAge(org.hl7.fhir.dstu2016may.model.Age src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Age tgt = new Age();
        VersionConvertor_14_40.copyElement((org.hl7.fhir.dstu2016may.model.Element)src, (Element)tgt);
        if (src.hasValue()) {
            tgt.setValue(src.getValue());
        }
        tgt.setComparator(VersionConvertor_14_40.convertQuantityComparator(src.getComparator()));
        if (src.hasUnit()) {
            tgt.setUnit(src.getUnit());
        }
        if (src.hasSystem()) {
            tgt.setSystem(src.getSystem());
        }
        if (src.hasCode()) {
            tgt.setCode(src.getCode());
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2016may.model.Age convertAge(Age src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2016may.model.Age tgt = new org.hl7.fhir.dstu2016may.model.Age();
        VersionConvertor_14_40.copyElement((Element)src, (org.hl7.fhir.dstu2016may.model.Element)tgt);
        if (src.hasValue()) {
            tgt.setValue(src.getValue());
        }
        tgt.setComparator(VersionConvertor_14_40.convertQuantityComparator(src.getComparator()));
        if (src.hasUnit()) {
            tgt.setUnit(src.getUnit());
        }
        if (src.hasSystem()) {
            tgt.setSystem(src.getSystem());
        }
        if (src.hasCode()) {
            tgt.setCode(src.getCode());
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.Annotation convertAnnotation(Annotation src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r4.model.Annotation tgt = new org.hl7.fhir.r4.model.Annotation();
        VersionConvertor_14_40.copyElement((org.hl7.fhir.dstu2016may.model.Element)src, (Element)tgt);
        tgt.setAuthor(VersionConvertor_14_40.convertType(src.getAuthor()));
        if (src.hasTime()) {
            tgt.setTime(src.getTime());
        }
        tgt.setText(src.getText());
        return tgt;
    }

    public static Annotation convertAnnotation(org.hl7.fhir.r4.model.Annotation src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Annotation tgt = new Annotation();
        VersionConvertor_14_40.copyElement((Element)src, (org.hl7.fhir.dstu2016may.model.Element)tgt);
        tgt.setAuthor(VersionConvertor_14_40.convertType(src.getAuthor()));
        if (src.hasTime()) {
            tgt.setTime(src.getTime());
        }
        tgt.setText(src.getText());
        return tgt;
    }

    public static Attachment convertAttachment(org.hl7.fhir.dstu2016may.model.Attachment src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Attachment tgt = new Attachment();
        VersionConvertor_14_40.copyElement((org.hl7.fhir.dstu2016may.model.Element)src, (Element)tgt);
        if (src.hasContentType()) {
            tgt.setContentType(src.getContentType());
        }
        if (src.hasLanguage()) {
            tgt.setLanguage(src.getLanguage());
        }
        if (src.hasData()) {
            tgt.setData(src.getData());
        }
        if (src.hasUrl()) {
            tgt.setUrl(src.getUrl());
        }
        if (src.hasSize()) {
            tgt.setSize(src.getSize());
        }
        if (src.hasHash()) {
            tgt.setHash(src.getHash());
        }
        if (src.hasTitle()) {
            tgt.setTitle(src.getTitle());
        }
        if (src.hasCreation()) {
            tgt.setCreation(src.getCreation());
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2016may.model.Attachment convertAttachment(Attachment src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2016may.model.Attachment tgt = new org.hl7.fhir.dstu2016may.model.Attachment();
        VersionConvertor_14_40.copyElement((Element)src, (org.hl7.fhir.dstu2016may.model.Element)tgt);
        if (src.hasContentType()) {
            tgt.setContentType(src.getContentType());
        }
        if (src.hasLanguage()) {
            tgt.setLanguage(src.getLanguage());
        }
        if (src.hasData()) {
            tgt.setData(src.getData());
        }
        if (src.hasUrl()) {
            tgt.setUrl(src.getUrl());
        }
        if (src.hasSize()) {
            tgt.setSize(src.getSize());
        }
        if (src.hasHash()) {
            tgt.setHash(src.getHash());
        }
        if (src.hasTitle()) {
            tgt.setTitle(src.getTitle());
        }
        if (src.hasCreation()) {
            tgt.setCreation(src.getCreation());
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.CodeableConcept convertCodeableConcept(CodeableConcept src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r4.model.CodeableConcept tgt = new org.hl7.fhir.r4.model.CodeableConcept();
        VersionConvertor_14_40.copyElement((org.hl7.fhir.dstu2016may.model.Element)src, (Element)tgt);
        for (org.hl7.fhir.dstu2016may.model.Coding t : src.getCoding()) {
            tgt.addCoding(VersionConvertor_14_40.convertCoding(t));
        }
        if (src.hasText()) {
            tgt.setText(src.getText());
        }
        return tgt;
    }

    public static CodeableConcept convertCodeableConcept(org.hl7.fhir.r4.model.CodeableConcept src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        CodeableConcept tgt = new CodeableConcept();
        VersionConvertor_14_40.copyElement((Element)src, (org.hl7.fhir.dstu2016may.model.Element)tgt);
        for (Coding t : src.getCoding()) {
            tgt.addCoding(VersionConvertor_14_40.convertCoding(t));
        }
        if (src.hasText()) {
            tgt.setText(src.getText());
        }
        return tgt;
    }

    public static Coding convertCoding(org.hl7.fhir.dstu2016may.model.Coding src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Coding tgt = new Coding();
        VersionConvertor_14_40.copyElement((org.hl7.fhir.dstu2016may.model.Element)src, (Element)tgt);
        if (src.hasSystem()) {
            tgt.setSystem(src.getSystem());
        }
        if (src.hasVersion()) {
            tgt.setVersion(src.getVersion());
        }
        if (src.hasCode()) {
            tgt.setCode(src.getCode());
        }
        if (src.hasDisplay()) {
            tgt.setDisplay(src.getDisplay());
        }
        if (src.hasUserSelected()) {
            tgt.setUserSelected(src.getUserSelected());
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2016may.model.Coding convertCoding(Coding src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2016may.model.Coding tgt = new org.hl7.fhir.dstu2016may.model.Coding();
        VersionConvertor_14_40.copyElement((Element)src, (org.hl7.fhir.dstu2016may.model.Element)tgt);
        if (src.hasSystem()) {
            tgt.setSystem(src.getSystem());
        }
        if (src.hasVersion()) {
            tgt.setVersion(src.getVersion());
        }
        if (src.hasCode()) {
            tgt.setCode(src.getCode());
        }
        if (src.hasDisplay()) {
            tgt.setDisplay(src.getDisplay());
        }
        if (src.hasUserSelected()) {
            tgt.setUserSelected(src.getUserSelected());
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.Count convertCount(Count src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r4.model.Count tgt = new org.hl7.fhir.r4.model.Count();
        VersionConvertor_14_40.copyElement((org.hl7.fhir.dstu2016may.model.Element)src, (Element)tgt);
        if (src.hasValue()) {
            tgt.setValue(src.getValue());
        }
        tgt.setComparator(VersionConvertor_14_40.convertQuantityComparator(src.getComparator()));
        if (src.hasUnit()) {
            tgt.setUnit(src.getUnit());
        }
        if (src.hasSystem()) {
            tgt.setSystem(src.getSystem());
        }
        if (src.hasCode()) {
            tgt.setCode(src.getCode());
        }
        return tgt;
    }

    public static Count convertCount(org.hl7.fhir.r4.model.Count src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Count tgt = new Count();
        VersionConvertor_14_40.copyElement((Element)src, (org.hl7.fhir.dstu2016may.model.Element)tgt);
        if (src.hasValue()) {
            tgt.setValue(src.getValue());
        }
        tgt.setComparator(VersionConvertor_14_40.convertQuantityComparator(src.getComparator()));
        if (src.hasUnit()) {
            tgt.setUnit(src.getUnit());
        }
        if (src.hasSystem()) {
            tgt.setSystem(src.getSystem());
        }
        if (src.hasCode()) {
            tgt.setCode(src.getCode());
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.Distance convertDistance(Distance src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r4.model.Distance tgt = new org.hl7.fhir.r4.model.Distance();
        VersionConvertor_14_40.copyElement((org.hl7.fhir.dstu2016may.model.Element)src, (Element)tgt);
        if (src.hasValue()) {
            tgt.setValue(src.getValue());
        }
        tgt.setComparator(VersionConvertor_14_40.convertQuantityComparator(src.getComparator()));
        if (src.hasUnit()) {
            tgt.setUnit(src.getUnit());
        }
        if (src.hasSystem()) {
            tgt.setSystem(src.getSystem());
        }
        if (src.hasCode()) {
            tgt.setCode(src.getCode());
        }
        return tgt;
    }

    public static Distance convertDistance(org.hl7.fhir.r4.model.Distance src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Distance tgt = new Distance();
        VersionConvertor_14_40.copyElement((Element)src, (org.hl7.fhir.dstu2016may.model.Element)tgt);
        if (src.hasValue()) {
            tgt.setValue(src.getValue());
        }
        tgt.setComparator(VersionConvertor_14_40.convertQuantityComparator(src.getComparator()));
        if (src.hasUnit()) {
            tgt.setUnit(src.getUnit());
        }
        if (src.hasSystem()) {
            tgt.setSystem(src.getSystem());
        }
        if (src.hasCode()) {
            tgt.setCode(src.getCode());
        }
        return tgt;
    }

    public static Duration convertDuration(org.hl7.fhir.dstu2016may.model.Duration src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Duration tgt = new Duration();
        VersionConvertor_14_40.copyElement((org.hl7.fhir.dstu2016may.model.Element)src, (Element)tgt);
        if (src.hasValue()) {
            tgt.setValue(src.getValue());
        }
        tgt.setComparator(VersionConvertor_14_40.convertQuantityComparator(src.getComparator()));
        if (src.hasUnit()) {
            tgt.setUnit(src.getUnit());
        }
        if (src.hasSystem()) {
            tgt.setSystem(src.getSystem());
        }
        if (src.hasCode()) {
            tgt.setCode(src.getCode());
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2016may.model.Duration convertDuration(Duration src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2016may.model.Duration tgt = new org.hl7.fhir.dstu2016may.model.Duration();
        VersionConvertor_14_40.copyElement((Element)src, (org.hl7.fhir.dstu2016may.model.Element)tgt);
        if (src.hasValue()) {
            tgt.setValue(src.getValue());
        }
        tgt.setComparator(VersionConvertor_14_40.convertQuantityComparator(src.getComparator()));
        if (src.hasUnit()) {
            tgt.setUnit(src.getUnit());
        }
        if (src.hasSystem()) {
            tgt.setSystem(src.getSystem());
        }
        if (src.hasCode()) {
            tgt.setCode(src.getCode());
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.Money convertMoney(Money src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r4.model.Money tgt = new org.hl7.fhir.r4.model.Money();
        VersionConvertor_14_40.copyElement((org.hl7.fhir.dstu2016may.model.Element)src, (Element)tgt);
        if (src.hasValue()) {
            tgt.setValue(src.getValue());
        }
        tgt.setComparator(VersionConvertor_14_40.convertQuantityComparator(src.getComparator()));
        if (src.hasUnit()) {
            tgt.setUnit(src.getUnit());
        }
        if (src.hasSystem()) {
            tgt.setSystem(src.getSystem());
        }
        if (src.hasCode()) {
            tgt.setCode(src.getCode());
        }
        return tgt;
    }

    public static Money convertMoney(org.hl7.fhir.r4.model.Money src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Money tgt = new Money();
        VersionConvertor_14_40.copyElement((Element)src, (org.hl7.fhir.dstu2016may.model.Element)tgt);
        if (src.hasValue()) {
            tgt.setValue(src.getValue());
        }
        tgt.setComparator(VersionConvertor_14_40.convertQuantityComparator(src.getComparator()));
        if (src.hasUnit()) {
            tgt.setUnit(src.getUnit());
        }
        if (src.hasSystem()) {
            tgt.setSystem(src.getSystem());
        }
        if (src.hasCode()) {
            tgt.setCode(src.getCode());
        }
        return tgt;
    }

    public static Identifier convertIdentifier(org.hl7.fhir.dstu2016may.model.Identifier src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Identifier tgt = new Identifier();
        VersionConvertor_14_40.copyElement((org.hl7.fhir.dstu2016may.model.Element)src, (Element)tgt);
        tgt.setUse(VersionConvertor_14_40.convertIdentifierUse(src.getUse()));
        tgt.setType(VersionConvertor_14_40.convertCodeableConcept(src.getType()));
        if (src.hasSystem()) {
            tgt.setSystem(src.getSystem());
        }
        if (src.hasValue()) {
            tgt.setValue(src.getValue());
        }
        tgt.setPeriod(VersionConvertor_14_40.convertPeriod(src.getPeriod()));
        tgt.setAssigner(VersionConvertor_14_40.convertReference(src.getAssigner()));
        return tgt;
    }

    public static org.hl7.fhir.dstu2016may.model.Identifier convertIdentifier(Identifier src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2016may.model.Identifier tgt = new org.hl7.fhir.dstu2016may.model.Identifier();
        VersionConvertor_14_40.copyElement((Element)src, (org.hl7.fhir.dstu2016may.model.Element)tgt);
        tgt.setUse(VersionConvertor_14_40.convertIdentifierUse(src.getUse()));
        tgt.setType(VersionConvertor_14_40.convertCodeableConcept(src.getType()));
        if (src.hasSystem()) {
            tgt.setSystem(src.getSystem());
        }
        if (src.hasValue()) {
            tgt.setValue(src.getValue());
        }
        tgt.setPeriod(VersionConvertor_14_40.convertPeriod(src.getPeriod()));
        tgt.setAssigner(VersionConvertor_14_40.convertReference(src.getAssigner()));
        return tgt;
    }

    private static Identifier.IdentifierUse convertIdentifierUse(Identifier.IdentifierUse src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case USUAL: {
                return Identifier.IdentifierUse.USUAL;
            }
            case OFFICIAL: {
                return Identifier.IdentifierUse.OFFICIAL;
            }
            case TEMP: {
                return Identifier.IdentifierUse.TEMP;
            }
            case SECONDARY: {
                return Identifier.IdentifierUse.SECONDARY;
            }
        }
        return Identifier.IdentifierUse.NULL;
    }

    private static Identifier.IdentifierUse convertIdentifierUse(Identifier.IdentifierUse src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case USUAL: {
                return Identifier.IdentifierUse.USUAL;
            }
            case OFFICIAL: {
                return Identifier.IdentifierUse.OFFICIAL;
            }
            case TEMP: {
                return Identifier.IdentifierUse.TEMP;
            }
            case SECONDARY: {
                return Identifier.IdentifierUse.SECONDARY;
            }
        }
        return Identifier.IdentifierUse.NULL;
    }

    public static Period convertPeriod(org.hl7.fhir.dstu2016may.model.Period src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Period tgt = new Period();
        VersionConvertor_14_40.copyElement((org.hl7.fhir.dstu2016may.model.Element)src, (Element)tgt);
        if (src.hasStart()) {
            tgt.setStart(src.getStart());
        }
        if (src.hasEnd()) {
            tgt.setEnd(src.getEnd());
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2016may.model.Period convertPeriod(Period src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2016may.model.Period tgt = new org.hl7.fhir.dstu2016may.model.Period();
        VersionConvertor_14_40.copyElement((Element)src, (org.hl7.fhir.dstu2016may.model.Element)tgt);
        if (src.hasStart()) {
            tgt.setStart(src.getStart());
        }
        if (src.hasEnd()) {
            tgt.setEnd(src.getEnd());
        }
        return tgt;
    }

    public static Quantity convertQuantity(org.hl7.fhir.dstu2016may.model.Quantity src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Quantity tgt = new Quantity();
        VersionConvertor_14_40.copyElement((org.hl7.fhir.dstu2016may.model.Element)src, (Element)tgt);
        if (src.hasValue()) {
            tgt.setValue(src.getValue());
        }
        tgt.setComparator(VersionConvertor_14_40.convertQuantityComparator(src.getComparator()));
        if (src.hasUnit()) {
            tgt.setUnit(src.getUnit());
        }
        if (src.hasSystem()) {
            tgt.setSystem(src.getSystem());
        }
        if (src.hasCode()) {
            tgt.setCode(src.getCode());
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2016may.model.Quantity convertQuantity(Quantity src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2016may.model.Quantity tgt = new org.hl7.fhir.dstu2016may.model.Quantity();
        VersionConvertor_14_40.copyElement((Element)src, (org.hl7.fhir.dstu2016may.model.Element)tgt);
        if (src.hasValue()) {
            tgt.setValue(src.getValue());
        }
        tgt.setComparator(VersionConvertor_14_40.convertQuantityComparator(src.getComparator()));
        if (src.hasUnit()) {
            tgt.setUnit(src.getUnit());
        }
        if (src.hasSystem()) {
            tgt.setSystem(src.getSystem());
        }
        if (src.hasCode()) {
            tgt.setCode(src.getCode());
        }
        return tgt;
    }

    private static Quantity.QuantityComparator convertQuantityComparator(Quantity.QuantityComparator src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case LESS_THAN: {
                return Quantity.QuantityComparator.LESS_THAN;
            }
            case LESS_OR_EQUAL: {
                return Quantity.QuantityComparator.LESS_OR_EQUAL;
            }
            case GREATER_OR_EQUAL: {
                return Quantity.QuantityComparator.GREATER_OR_EQUAL;
            }
            case GREATER_THAN: {
                return Quantity.QuantityComparator.GREATER_THAN;
            }
        }
        return Quantity.QuantityComparator.NULL;
    }

    private static Quantity.QuantityComparator convertQuantityComparator(Quantity.QuantityComparator src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case LESS_THAN: {
                return Quantity.QuantityComparator.LESS_THAN;
            }
            case LESS_OR_EQUAL: {
                return Quantity.QuantityComparator.LESS_OR_EQUAL;
            }
            case GREATER_OR_EQUAL: {
                return Quantity.QuantityComparator.GREATER_OR_EQUAL;
            }
            case GREATER_THAN: {
                return Quantity.QuantityComparator.GREATER_THAN;
            }
        }
        return Quantity.QuantityComparator.NULL;
    }

    public static org.hl7.fhir.r4.model.Range convertRange(Range src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r4.model.Range tgt = new org.hl7.fhir.r4.model.Range();
        VersionConvertor_14_40.copyElement((org.hl7.fhir.dstu2016may.model.Element)src, (Element)tgt);
        tgt.setLow(VersionConvertor_14_40.convertSimpleQuantity(src.getLow()));
        tgt.setHigh(VersionConvertor_14_40.convertSimpleQuantity(src.getHigh()));
        return tgt;
    }

    public static Range convertRange(org.hl7.fhir.r4.model.Range src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Range tgt = new Range();
        VersionConvertor_14_40.copyElement((Element)src, (org.hl7.fhir.dstu2016may.model.Element)tgt);
        tgt.setLow(VersionConvertor_14_40.convertSimpleQuantity(src.getLow()));
        tgt.setHigh(VersionConvertor_14_40.convertSimpleQuantity(src.getHigh()));
        return tgt;
    }

    public static org.hl7.fhir.r4.model.Ratio convertRatio(Ratio src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r4.model.Ratio tgt = new org.hl7.fhir.r4.model.Ratio();
        VersionConvertor_14_40.copyElement((org.hl7.fhir.dstu2016may.model.Element)src, (Element)tgt);
        tgt.setNumerator(VersionConvertor_14_40.convertQuantity(src.getNumerator()));
        tgt.setDenominator(VersionConvertor_14_40.convertQuantity(src.getDenominator()));
        return tgt;
    }

    public static Ratio convertRatio(org.hl7.fhir.r4.model.Ratio src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Ratio tgt = new Ratio();
        VersionConvertor_14_40.copyElement((Element)src, (org.hl7.fhir.dstu2016may.model.Element)tgt);
        tgt.setNumerator(VersionConvertor_14_40.convertQuantity(src.getNumerator()));
        tgt.setDenominator(VersionConvertor_14_40.convertQuantity(src.getDenominator()));
        return tgt;
    }

    public static Reference convertReference(org.hl7.fhir.dstu2016may.model.Reference src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Reference tgt = new Reference();
        VersionConvertor_14_40.copyElement((org.hl7.fhir.dstu2016may.model.Element)src, (Element)tgt);
        if (src.hasReference()) {
            tgt.setReference(src.getReference());
        }
        if (src.hasDisplay()) {
            tgt.setDisplay(src.getDisplay());
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2016may.model.Reference convertReference(Reference src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2016may.model.Reference tgt = new org.hl7.fhir.dstu2016may.model.Reference();
        VersionConvertor_14_40.copyElement((Element)src, (org.hl7.fhir.dstu2016may.model.Element)tgt);
        if (src.hasReference()) {
            tgt.setReference(src.getReference());
        }
        if (src.hasDisplay()) {
            tgt.setDisplay(src.getDisplay());
        }
        return tgt;
    }

    public static SampledData convertSampledData(org.hl7.fhir.dstu2016may.model.SampledData src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        SampledData tgt = new SampledData();
        VersionConvertor_14_40.copyElement((org.hl7.fhir.dstu2016may.model.Element)src, (Element)tgt);
        tgt.setOrigin(VersionConvertor_14_40.convertSimpleQuantity(src.getOrigin()));
        tgt.setPeriod(src.getPeriod());
        if (src.hasFactor()) {
            tgt.setFactor(src.getFactor());
        }
        if (src.hasLowerLimit()) {
            tgt.setLowerLimit(src.getLowerLimit());
        }
        if (src.hasUpperLimit()) {
            tgt.setUpperLimit(src.getUpperLimit());
        }
        tgt.setDimensions(src.getDimensions());
        tgt.setData(src.getData());
        return tgt;
    }

    public static org.hl7.fhir.dstu2016may.model.SampledData convertSampledData(SampledData src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2016may.model.SampledData tgt = new org.hl7.fhir.dstu2016may.model.SampledData();
        VersionConvertor_14_40.copyElement((Element)src, (org.hl7.fhir.dstu2016may.model.Element)tgt);
        tgt.setOrigin(VersionConvertor_14_40.convertSimpleQuantity(src.getOrigin()));
        tgt.setPeriod(src.getPeriod());
        if (src.hasFactor()) {
            tgt.setFactor(src.getFactor());
        }
        if (src.hasLowerLimit()) {
            tgt.setLowerLimit(src.getLowerLimit());
        }
        if (src.hasUpperLimit()) {
            tgt.setUpperLimit(src.getUpperLimit());
        }
        tgt.setDimensions(src.getDimensions());
        tgt.setData(src.getData());
        return tgt;
    }

    public static Signature convertSignature(org.hl7.fhir.dstu2016may.model.Signature src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Signature tgt = new Signature();
        VersionConvertor_14_40.copyElement((org.hl7.fhir.dstu2016may.model.Element)src, (Element)tgt);
        for (org.hl7.fhir.dstu2016may.model.Coding t : src.getType()) {
            tgt.addType(VersionConvertor_14_40.convertCoding(t));
        }
        tgt.setWhen(src.getWhen());
        tgt.setWho(VersionConvertor_14_40.convertType(src.getWho()));
        if (src.hasContentType()) {
            tgt.setSigFormat(src.getContentType());
        }
        if (src.hasBlob()) {
            tgt.setBlob(src.getBlob());
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2016may.model.Signature convertSignature(Signature src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2016may.model.Signature tgt = new org.hl7.fhir.dstu2016may.model.Signature();
        VersionConvertor_14_40.copyElement((Element)src, (org.hl7.fhir.dstu2016may.model.Element)tgt);
        for (Coding t : src.getType()) {
            tgt.addType(VersionConvertor_14_40.convertCoding(t));
        }
        tgt.setWhen(src.getWhen());
        tgt.setWho(VersionConvertor_14_40.convertType(src.getWho()));
        if (src.hasSigFormat()) {
            tgt.setContentType(src.getSigFormat());
        }
        if (src.hasBlob()) {
            tgt.setBlob(src.getBlob());
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.Address convertAddress(Address src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r4.model.Address tgt = new org.hl7.fhir.r4.model.Address();
        VersionConvertor_14_40.copyElement((org.hl7.fhir.dstu2016may.model.Element)src, (Element)tgt);
        tgt.setUse(VersionConvertor_14_40.convertAddressUse(src.getUse()));
        tgt.setType(VersionConvertor_14_40.convertAddressType(src.getType()));
        if (src.hasText()) {
            tgt.setText(src.getText());
        }
        for (org.hl7.fhir.dstu2016may.model.StringType t : src.getLine()) {
            tgt.addLine((String)t.getValue());
        }
        if (src.hasCity()) {
            tgt.setCity(src.getCity());
        }
        if (src.hasDistrict()) {
            tgt.setDistrict(src.getDistrict());
        }
        if (src.hasState()) {
            tgt.setState(src.getState());
        }
        if (src.hasPostalCode()) {
            tgt.setPostalCode(src.getPostalCode());
        }
        if (src.hasCountry()) {
            tgt.setCountry(src.getCountry());
        }
        tgt.setPeriod(VersionConvertor_14_40.convertPeriod(src.getPeriod()));
        return tgt;
    }

    public static Address convertAddress(org.hl7.fhir.r4.model.Address src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Address tgt = new Address();
        VersionConvertor_14_40.copyElement((Element)src, (org.hl7.fhir.dstu2016may.model.Element)tgt);
        tgt.setUse(VersionConvertor_14_40.convertAddressUse(src.getUse()));
        tgt.setType(VersionConvertor_14_40.convertAddressType(src.getType()));
        if (src.hasText()) {
            tgt.setText(src.getText());
        }
        for (StringType t : src.getLine()) {
            tgt.addLine((String)t.getValue());
        }
        if (src.hasCity()) {
            tgt.setCity(src.getCity());
        }
        if (src.hasDistrict()) {
            tgt.setDistrict(src.getDistrict());
        }
        if (src.hasState()) {
            tgt.setState(src.getState());
        }
        if (src.hasPostalCode()) {
            tgt.setPostalCode(src.getPostalCode());
        }
        if (src.hasCountry()) {
            tgt.setCountry(src.getCountry());
        }
        tgt.setPeriod(VersionConvertor_14_40.convertPeriod(src.getPeriod()));
        return tgt;
    }

    private static Address.AddressUse convertAddressUse(Address.AddressUse src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case HOME: {
                return Address.AddressUse.HOME;
            }
            case WORK: {
                return Address.AddressUse.WORK;
            }
            case TEMP: {
                return Address.AddressUse.TEMP;
            }
            case OLD: {
                return Address.AddressUse.OLD;
            }
        }
        return Address.AddressUse.NULL;
    }

    private static Address.AddressUse convertAddressUse(Address.AddressUse src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case HOME: {
                return Address.AddressUse.HOME;
            }
            case WORK: {
                return Address.AddressUse.WORK;
            }
            case TEMP: {
                return Address.AddressUse.TEMP;
            }
            case OLD: {
                return Address.AddressUse.OLD;
            }
        }
        return Address.AddressUse.NULL;
    }

    private static Address.AddressType convertAddressType(Address.AddressType src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case POSTAL: {
                return Address.AddressType.POSTAL;
            }
            case PHYSICAL: {
                return Address.AddressType.PHYSICAL;
            }
            case BOTH: {
                return Address.AddressType.BOTH;
            }
        }
        return Address.AddressType.NULL;
    }

    private static Address.AddressType convertAddressType(Address.AddressType src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case POSTAL: {
                return Address.AddressType.POSTAL;
            }
            case PHYSICAL: {
                return Address.AddressType.PHYSICAL;
            }
            case BOTH: {
                return Address.AddressType.BOTH;
            }
        }
        return Address.AddressType.NULL;
    }

    public static ContactPoint convertContactPoint(org.hl7.fhir.dstu2016may.model.ContactPoint src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ContactPoint tgt = new ContactPoint();
        VersionConvertor_14_40.copyElement((org.hl7.fhir.dstu2016may.model.Element)src, (Element)tgt);
        tgt.setSystem(VersionConvertor_14_40.convertContactPointSystem(src.getSystem()));
        if (src.hasValue()) {
            tgt.setValue(src.getValue());
        }
        tgt.setUse(VersionConvertor_14_40.convertContactPointUse(src.getUse()));
        if (src.hasRank()) {
            tgt.setRank(src.getRank());
        }
        tgt.setPeriod(VersionConvertor_14_40.convertPeriod(src.getPeriod()));
        return tgt;
    }

    public static org.hl7.fhir.dstu2016may.model.ContactPoint convertContactPoint(ContactPoint src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2016may.model.ContactPoint tgt = new org.hl7.fhir.dstu2016may.model.ContactPoint();
        VersionConvertor_14_40.copyElement((Element)src, (org.hl7.fhir.dstu2016may.model.Element)tgt);
        tgt.setSystem(VersionConvertor_14_40.convertContactPointSystem(src.getSystem()));
        if (src.hasValue()) {
            tgt.setValue(src.getValue());
        }
        tgt.setUse(VersionConvertor_14_40.convertContactPointUse(src.getUse()));
        if (src.hasRank()) {
            tgt.setRank(src.getRank());
        }
        tgt.setPeriod(VersionConvertor_14_40.convertPeriod(src.getPeriod()));
        return tgt;
    }

    private static ContactPoint.ContactPointSystem convertContactPointSystem(ContactPoint.ContactPointSystem src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case PHONE: {
                return ContactPoint.ContactPointSystem.PHONE;
            }
            case FAX: {
                return ContactPoint.ContactPointSystem.FAX;
            }
            case EMAIL: {
                return ContactPoint.ContactPointSystem.EMAIL;
            }
            case PAGER: {
                return ContactPoint.ContactPointSystem.PAGER;
            }
            case OTHER: {
                return ContactPoint.ContactPointSystem.URL;
            }
        }
        return ContactPoint.ContactPointSystem.NULL;
    }

    private static ContactPoint.ContactPointSystem convertContactPointSystem(ContactPoint.ContactPointSystem src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case PHONE: {
                return ContactPoint.ContactPointSystem.PHONE;
            }
            case FAX: {
                return ContactPoint.ContactPointSystem.FAX;
            }
            case EMAIL: {
                return ContactPoint.ContactPointSystem.EMAIL;
            }
            case PAGER: {
                return ContactPoint.ContactPointSystem.PAGER;
            }
            case URL: {
                return ContactPoint.ContactPointSystem.OTHER;
            }
        }
        return ContactPoint.ContactPointSystem.NULL;
    }

    private static ContactPoint.ContactPointUse convertContactPointUse(ContactPoint.ContactPointUse src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case HOME: {
                return ContactPoint.ContactPointUse.HOME;
            }
            case WORK: {
                return ContactPoint.ContactPointUse.WORK;
            }
            case TEMP: {
                return ContactPoint.ContactPointUse.TEMP;
            }
            case OLD: {
                return ContactPoint.ContactPointUse.OLD;
            }
            case MOBILE: {
                return ContactPoint.ContactPointUse.MOBILE;
            }
        }
        return ContactPoint.ContactPointUse.NULL;
    }

    private static ContactPoint.ContactPointUse convertContactPointUse(ContactPoint.ContactPointUse src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case HOME: {
                return ContactPoint.ContactPointUse.HOME;
            }
            case WORK: {
                return ContactPoint.ContactPointUse.WORK;
            }
            case TEMP: {
                return ContactPoint.ContactPointUse.TEMP;
            }
            case OLD: {
                return ContactPoint.ContactPointUse.OLD;
            }
            case MOBILE: {
                return ContactPoint.ContactPointUse.MOBILE;
            }
        }
        return ContactPoint.ContactPointUse.NULL;
    }

    public static ElementDefinition convertElementDefinition(org.hl7.fhir.dstu2016may.model.ElementDefinition src, List<org.hl7.fhir.dstu2016may.model.ElementDefinition> context, int pos) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ElementDefinition tgt = new ElementDefinition();
        VersionConvertor_14_40.copyElement((org.hl7.fhir.dstu2016may.model.Element)src, (Element)tgt);
        tgt.setPath(src.getPath());
        for (org.hl7.fhir.dstu2016may.model.Enumeration t : src.getRepresentation()) {
            tgt.addRepresentation(VersionConvertor_14_40.convertPropertyRepresentation((ElementDefinition.PropertyRepresentation)t.getValue()));
        }
        if (src.hasName()) {
            tgt.setSliceName(src.getName());
        }
        if (src.hasLabel()) {
            tgt.setLabel(src.getLabel());
        }
        for (org.hl7.fhir.dstu2016may.model.Enumeration t : src.getCode()) {
            tgt.addCode(VersionConvertor_14_40.convertCoding((org.hl7.fhir.dstu2016may.model.Coding)t));
        }
        tgt.setSlicing(VersionConvertor_14_40.convertElementDefinitionSlicingComponent(src.getSlicing(), context, pos));
        if (src.hasShort()) {
            tgt.setShort(src.getShort());
        }
        if (src.hasDefinition()) {
            tgt.setDefinition(src.getDefinition());
        }
        if (src.hasComments()) {
            tgt.setComment(src.getComments());
        }
        if (src.hasRequirements()) {
            tgt.setRequirements(src.getRequirements());
        }
        for (org.hl7.fhir.dstu2016may.model.Enumeration t : src.getAlias()) {
            tgt.addAlias((String)t.getValue());
        }
        if (src.hasMin()) {
            tgt.setMin(src.getMin());
        }
        if (src.hasMax()) {
            tgt.setMax(src.getMax());
        }
        tgt.setBase(VersionConvertor_14_40.convertElementDefinitionBaseComponent(src.getBase()));
        if (src.hasContentReference()) {
            tgt.setContentReference(src.getContentReference());
        }
        for (org.hl7.fhir.dstu2016may.model.Enumeration t : src.getType()) {
            VersionConvertor_14_40.convertTypeRefComponent((ElementDefinition.TypeRefComponent)t, tgt.getType());
        }
        tgt.setDefaultValue(VersionConvertor_14_40.convertType(src.getDefaultValue()));
        if (src.hasMeaningWhenMissing()) {
            tgt.setMeaningWhenMissing(src.getMeaningWhenMissing());
        }
        tgt.setFixed(VersionConvertor_14_40.convertType(src.getFixed()));
        tgt.setPattern(VersionConvertor_14_40.convertType(src.getPattern()));
        if (src.hasExample()) {
            tgt.addExample().setLabel("General").setValue(VersionConvertor_14_40.convertType(src.getExample()));
        }
        tgt.setMinValue(VersionConvertor_14_40.convertType(src.getMinValue()));
        tgt.setMaxValue(VersionConvertor_14_40.convertType(src.getMaxValue()));
        if (src.hasMaxLength()) {
            tgt.setMaxLength(src.getMaxLength());
        }
        for (org.hl7.fhir.dstu2016may.model.Enumeration t : src.getCondition()) {
            tgt.addCondition(t.getValue());
        }
        for (org.hl7.fhir.dstu2016may.model.Enumeration t : src.getConstraint()) {
            tgt.addConstraint(VersionConvertor_14_40.convertElementDefinitionConstraintComponent((ElementDefinition.ElementDefinitionConstraintComponent)t));
        }
        if (src.hasMustSupport()) {
            tgt.setMustSupport(src.getMustSupport());
        }
        if (src.hasIsModifier()) {
            tgt.setIsModifier(src.getIsModifier());
        }
        if (tgt.getIsModifier()) {
            String reason = ToolingExtensions.readStringExtension((org.hl7.fhir.dstu2016may.model.Element)src, (String)"http://hl7.org/fhir/tooling/StructureDefinition/r4ModifierReason");
            if (Utilities.noString((String)reason)) {
                reason = "No Modifier Reason provideed in previous versions of FHIR";
            }
            tgt.setIsModifierReason(reason);
        }
        if (src.hasIsSummary()) {
            tgt.setIsSummary(src.getIsSummary());
        }
        tgt.setBinding(VersionConvertor_14_40.convertElementDefinitionBindingComponent(src.getBinding()));
        for (org.hl7.fhir.dstu2016may.model.Enumeration t : src.getMapping()) {
            tgt.addMapping(VersionConvertor_14_40.convertElementDefinitionMappingComponent((ElementDefinition.ElementDefinitionMappingComponent)t));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2016may.model.ElementDefinition convertElementDefinition(ElementDefinition src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2016may.model.ElementDefinition tgt = new org.hl7.fhir.dstu2016may.model.ElementDefinition();
        VersionConvertor_14_40.copyElement((Element)src, (org.hl7.fhir.dstu2016may.model.Element)tgt);
        tgt.setPath(src.getPath());
        for (Enumeration t : src.getRepresentation()) {
            tgt.addRepresentation(VersionConvertor_14_40.convertPropertyRepresentation((ElementDefinition.PropertyRepresentation)t.getValue()));
        }
        if (src.hasSliceName()) {
            tgt.setName(src.getSliceName());
        }
        if (src.hasLabel()) {
            tgt.setLabel(src.getLabel());
        }
        for (Enumeration t : src.getCode()) {
            tgt.addCode(VersionConvertor_14_40.convertCoding((Coding)t));
        }
        if (src.hasSlicing()) {
            tgt.setSlicing(VersionConvertor_14_40.convertElementDefinitionSlicingComponent(src.getSlicing()));
        }
        if (src.hasShort()) {
            tgt.setShort(src.getShort());
        }
        if (src.hasDefinition()) {
            tgt.setDefinition(src.getDefinition());
        }
        if (src.hasComment()) {
            tgt.setComments(src.getComment());
        }
        if (src.hasRequirements()) {
            tgt.setRequirements(src.getRequirements());
        }
        for (Enumeration t : src.getAlias()) {
            tgt.addAlias((String)t.getValue());
        }
        if (src.hasMin()) {
            tgt.setMin(src.getMin());
        }
        if (src.hasMax()) {
            tgt.setMax(src.getMax());
        }
        if (src.hasBase()) {
            tgt.setBase(VersionConvertor_14_40.convertElementDefinitionBaseComponent(src.getBase()));
        }
        if (src.hasContentReference()) {
            tgt.setContentReference(src.getContentReference());
        }
        for (Enumeration t : src.getType()) {
            VersionConvertor_14_40.convertTypeRefComponent((ElementDefinition.TypeRefComponent)t, tgt.getType());
        }
        tgt.setDefaultValue(VersionConvertor_14_40.convertType(src.getDefaultValue()));
        if (src.hasMeaningWhenMissing()) {
            tgt.setMeaningWhenMissing(src.getMeaningWhenMissing());
        }
        tgt.setFixed(VersionConvertor_14_40.convertType(src.getFixed()));
        tgt.setPattern(VersionConvertor_14_40.convertType(src.getPattern()));
        if (src.hasExample()) {
            tgt.setExample(VersionConvertor_14_40.convertType(((ElementDefinition.ElementDefinitionExampleComponent)src.getExample().get(0)).getValue()));
        }
        tgt.setMinValue(VersionConvertor_14_40.convertType(src.getMinValue()));
        tgt.setMaxValue(VersionConvertor_14_40.convertType(src.getMaxValue()));
        if (src.hasMaxLength()) {
            tgt.setMaxLength(src.getMaxLength());
        }
        for (Enumeration t : src.getCondition()) {
            tgt.addCondition(t.getValue());
        }
        for (Enumeration t : src.getConstraint()) {
            tgt.addConstraint(VersionConvertor_14_40.convertElementDefinitionConstraintComponent((ElementDefinition.ElementDefinitionConstraintComponent)t));
        }
        if (src.hasMustSupport()) {
            tgt.setMustSupport(src.getMustSupport());
        }
        if (src.hasIsModifier()) {
            tgt.setIsModifier(src.getIsModifier());
        }
        if (src.hasIsModifierReason() && !"No Modifier Reason provideed in previous versions of FHIR".equals(src.getIsModifierReason())) {
            ToolingExtensions.setStringExtension((org.hl7.fhir.dstu2016may.model.Element)tgt, (String)"http://hl7.org/fhir/tooling/StructureDefinition/r4ModifierReason", (String)src.getIsModifierReason());
        }
        if (src.hasIsSummary()) {
            tgt.setIsSummary(src.getIsSummary());
        }
        if (src.hasBinding()) {
            tgt.setBinding(VersionConvertor_14_40.convertElementDefinitionBindingComponent(src.getBinding()));
        }
        for (Enumeration t : src.getMapping()) {
            tgt.addMapping(VersionConvertor_14_40.convertElementDefinitionMappingComponent((ElementDefinition.ElementDefinitionMappingComponent)t));
        }
        return tgt;
    }

    private static ElementDefinition.PropertyRepresentation convertPropertyRepresentation(ElementDefinition.PropertyRepresentation src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case XMLATTR: {
                return ElementDefinition.PropertyRepresentation.XMLATTR;
            }
            case XMLTEXT: {
                return ElementDefinition.PropertyRepresentation.XMLTEXT;
            }
            case TYPEATTR: {
                return ElementDefinition.PropertyRepresentation.TYPEATTR;
            }
            case CDATEXT: {
                return ElementDefinition.PropertyRepresentation.CDATEXT;
            }
        }
        return ElementDefinition.PropertyRepresentation.NULL;
    }

    private static ElementDefinition.PropertyRepresentation convertPropertyRepresentation(ElementDefinition.PropertyRepresentation src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case XMLATTR: {
                return ElementDefinition.PropertyRepresentation.XMLATTR;
            }
            case XMLTEXT: {
                return ElementDefinition.PropertyRepresentation.XMLTEXT;
            }
            case TYPEATTR: {
                return ElementDefinition.PropertyRepresentation.TYPEATTR;
            }
            case CDATEXT: {
                return ElementDefinition.PropertyRepresentation.CDATEXT;
            }
        }
        return ElementDefinition.PropertyRepresentation.NULL;
    }

    public static ElementDefinition.ElementDefinitionSlicingComponent convertElementDefinitionSlicingComponent(ElementDefinition.ElementDefinitionSlicingComponent src, List<org.hl7.fhir.dstu2016may.model.ElementDefinition> context, int pos) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ElementDefinition.ElementDefinitionSlicingComponent tgt = new ElementDefinition.ElementDefinitionSlicingComponent();
        VersionConvertor_14_40.copyElement((org.hl7.fhir.dstu2016may.model.Element)src, (Element)tgt);
        org.hl7.fhir.dstu2016may.model.ElementDefinition slicingElement = context.get(pos);
        for (org.hl7.fhir.dstu2016may.model.StringType t : src.getDiscriminator()) {
            boolean isExists = false;
            if (!t.asStringValue().contains("@")) {
                int slices = 0;
                boolean existsSlicePresent = false;
                boolean notExistsSlicePresent = false;
                String existsPath = slicingElement.getPath() + "." + t.asStringValue();
                for (int i = pos + 1; i < context.size(); ++i) {
                    org.hl7.fhir.dstu2016may.model.ElementDefinition e = context.get(i);
                    if (e.getPath().equals(slicingElement.getPath())) {
                        ++slices;
                        continue;
                    }
                    if (!e.getPath().startsWith(slicingElement.getPath() + ".")) break;
                    if (!e.getPath().equals(existsPath)) continue;
                    if (e.hasMin() && e.getMin() > 0 && !e.hasFixed()) {
                        existsSlicePresent = true;
                        continue;
                    }
                    if (!e.hasMax() || !e.getMax().equals("0")) continue;
                    notExistsSlicePresent = true;
                }
                isExists = slices == 2 && existsSlicePresent && notExistsSlicePresent || slices == 1 && existsSlicePresent != notExistsSlicePresent;
            }
            tgt.addDiscriminator(ProfileUtilities.interpretR2Discriminator((String)((String)t.getValue()), (boolean)isExists));
        }
        if (src.hasDescription()) {
            tgt.setDescription(src.getDescription());
        }
        if (src.hasOrdered()) {
            tgt.setOrdered(src.getOrdered());
        }
        tgt.setRules(VersionConvertor_14_40.convertSlicingRules(src.getRules()));
        return tgt;
    }

    public static ElementDefinition.ElementDefinitionSlicingComponent convertElementDefinitionSlicingComponent(ElementDefinition.ElementDefinitionSlicingComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ElementDefinition.ElementDefinitionSlicingComponent tgt = new ElementDefinition.ElementDefinitionSlicingComponent();
        VersionConvertor_14_40.copyElement((Element)src, (org.hl7.fhir.dstu2016may.model.Element)tgt);
        for (ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent t : src.getDiscriminator()) {
            tgt.addDiscriminator(ProfileUtilities.buildR2Discriminator((ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent)t));
        }
        if (src.hasDescription()) {
            tgt.setDescription(src.getDescription());
        }
        if (src.hasOrdered()) {
            tgt.setOrdered(src.getOrdered());
        }
        tgt.setRules(VersionConvertor_14_40.convertSlicingRules(src.getRules()));
        return tgt;
    }

    private static ElementDefinition.SlicingRules convertSlicingRules(ElementDefinition.SlicingRules src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case CLOSED: {
                return ElementDefinition.SlicingRules.CLOSED;
            }
            case OPEN: {
                return ElementDefinition.SlicingRules.OPEN;
            }
            case OPENATEND: {
                return ElementDefinition.SlicingRules.OPENATEND;
            }
        }
        return ElementDefinition.SlicingRules.NULL;
    }

    private static ElementDefinition.SlicingRules convertSlicingRules(ElementDefinition.SlicingRules src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case CLOSED: {
                return ElementDefinition.SlicingRules.CLOSED;
            }
            case OPEN: {
                return ElementDefinition.SlicingRules.OPEN;
            }
            case OPENATEND: {
                return ElementDefinition.SlicingRules.OPENATEND;
            }
        }
        return ElementDefinition.SlicingRules.NULL;
    }

    public static ElementDefinition.ElementDefinitionBaseComponent convertElementDefinitionBaseComponent(ElementDefinition.ElementDefinitionBaseComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ElementDefinition.ElementDefinitionBaseComponent tgt = new ElementDefinition.ElementDefinitionBaseComponent();
        VersionConvertor_14_40.copyElement((org.hl7.fhir.dstu2016may.model.Element)src, (Element)tgt);
        tgt.setPath(src.getPath());
        tgt.setMin(src.getMin());
        tgt.setMax(src.getMax());
        return tgt;
    }

    public static ElementDefinition.ElementDefinitionBaseComponent convertElementDefinitionBaseComponent(ElementDefinition.ElementDefinitionBaseComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ElementDefinition.ElementDefinitionBaseComponent tgt = new ElementDefinition.ElementDefinitionBaseComponent();
        VersionConvertor_14_40.copyElement((Element)src, (org.hl7.fhir.dstu2016may.model.Element)tgt);
        tgt.setPath(src.getPath());
        tgt.setMin(src.getMin());
        tgt.setMax(src.getMax());
        return tgt;
    }

    static void convertTypeRefComponent(ElementDefinition.TypeRefComponent src, List<ElementDefinition.TypeRefComponent> list) throws FHIRException {
        if (src == null) {
            return;
        }
        ElementDefinition.TypeRefComponent tgt = null;
        for (ElementDefinition.TypeRefComponent t : list) {
            if (!t.getCode().equals(src.getCode())) continue;
            tgt = t;
        }
        if (tgt == null) {
            tgt = new ElementDefinition.TypeRefComponent();
            list.add(tgt);
            VersionConvertor_14_40.copyElement((org.hl7.fhir.dstu2016may.model.Element)src, (Element)tgt);
            tgt.setCode(src.getCode());
        }
        if (tgt.hasTarget()) {
            for (org.hl7.fhir.dstu2016may.model.UriType u : src.getProfile()) {
                tgt.addTargetProfile((String)u.getValue());
            }
        } else {
            for (org.hl7.fhir.dstu2016may.model.UriType u : src.getProfile()) {
                tgt.addProfile((String)u.getValue());
            }
        }
        for (ElementDefinition.TypeRefComponent t : src.getAggregation()) {
            ElementDefinition.AggregationMode a = VersionConvertor_14_40.convertAggregationMode((ElementDefinition.AggregationMode)t.getValue());
            if (tgt.hasAggregation(a)) continue;
            tgt.addAggregation(a);
        }
        if (src.hasVersioning()) {
            tgt.setVersioning(VersionConvertor_14_40.convertReferenceVersionRules(src.getVersioning()));
        }
    }

    public static void convertTypeRefComponent(ElementDefinition.TypeRefComponent src, List<ElementDefinition.TypeRefComponent> list) throws FHIRException {
        if (src == null) {
            return;
        }
        ElementDefinition.TypeRefComponent tgt = new ElementDefinition.TypeRefComponent();
        VersionConvertor_14_40.copyElement((Element)src, (org.hl7.fhir.dstu2016may.model.Element)tgt);
        tgt.setCode(src.getCode());
        list.add(tgt);
        if (src.hasTarget()) {
            for (UriType u : src.getTargetProfile()) {
                tgt.addProfile((String)u.getValue());
            }
        } else {
            for (UriType u : src.getProfile()) {
                tgt.addProfile((String)u.getValue());
            }
        }
        for (Enumeration t : src.getAggregation()) {
            ElementDefinition.AggregationMode a = VersionConvertor_14_40.convertAggregationMode((ElementDefinition.AggregationMode)t.getValue());
            if (tgt.hasAggregation(a)) continue;
            tgt.addAggregation(a);
        }
        if (src.hasVersioning()) {
            tgt.setVersioning(VersionConvertor_14_40.convertReferenceVersionRules(src.getVersioning()));
        }
    }

    private static ElementDefinition.AggregationMode convertAggregationMode(ElementDefinition.AggregationMode src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case CONTAINED: {
                return ElementDefinition.AggregationMode.CONTAINED;
            }
            case REFERENCED: {
                return ElementDefinition.AggregationMode.REFERENCED;
            }
            case BUNDLED: {
                return ElementDefinition.AggregationMode.BUNDLED;
            }
        }
        return ElementDefinition.AggregationMode.NULL;
    }

    private static ElementDefinition.AggregationMode convertAggregationMode(ElementDefinition.AggregationMode src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case CONTAINED: {
                return ElementDefinition.AggregationMode.CONTAINED;
            }
            case REFERENCED: {
                return ElementDefinition.AggregationMode.REFERENCED;
            }
            case BUNDLED: {
                return ElementDefinition.AggregationMode.BUNDLED;
            }
        }
        return ElementDefinition.AggregationMode.NULL;
    }

    private static ElementDefinition.ReferenceVersionRules convertReferenceVersionRules(ElementDefinition.ReferenceVersionRules src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case EITHER: {
                return ElementDefinition.ReferenceVersionRules.EITHER;
            }
            case INDEPENDENT: {
                return ElementDefinition.ReferenceVersionRules.INDEPENDENT;
            }
            case SPECIFIC: {
                return ElementDefinition.ReferenceVersionRules.SPECIFIC;
            }
        }
        return ElementDefinition.ReferenceVersionRules.NULL;
    }

    private static ElementDefinition.ReferenceVersionRules convertReferenceVersionRules(ElementDefinition.ReferenceVersionRules src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case EITHER: {
                return ElementDefinition.ReferenceVersionRules.EITHER;
            }
            case INDEPENDENT: {
                return ElementDefinition.ReferenceVersionRules.INDEPENDENT;
            }
            case SPECIFIC: {
                return ElementDefinition.ReferenceVersionRules.SPECIFIC;
            }
        }
        return ElementDefinition.ReferenceVersionRules.NULL;
    }

    public static ElementDefinition.ElementDefinitionConstraintComponent convertElementDefinitionConstraintComponent(ElementDefinition.ElementDefinitionConstraintComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ElementDefinition.ElementDefinitionConstraintComponent tgt = new ElementDefinition.ElementDefinitionConstraintComponent();
        VersionConvertor_14_40.copyElement((org.hl7.fhir.dstu2016may.model.Element)src, (Element)tgt);
        tgt.setKey(src.getKey());
        if (src.hasRequirements()) {
            tgt.setRequirements(src.getRequirements());
        }
        tgt.setSeverity(VersionConvertor_14_40.convertConstraintSeverity(src.getSeverity()));
        tgt.setHuman(src.getHuman());
        if (src.hasExpression()) {
            tgt.setExpression(src.getExpression());
        }
        tgt.setXpath(src.getXpath());
        return tgt;
    }

    public static ElementDefinition.ElementDefinitionConstraintComponent convertElementDefinitionConstraintComponent(ElementDefinition.ElementDefinitionConstraintComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ElementDefinition.ElementDefinitionConstraintComponent tgt = new ElementDefinition.ElementDefinitionConstraintComponent();
        VersionConvertor_14_40.copyElement((Element)src, (org.hl7.fhir.dstu2016may.model.Element)tgt);
        tgt.setKey(src.getKey());
        if (src.hasRequirements()) {
            tgt.setRequirements(src.getRequirements());
        }
        tgt.setSeverity(VersionConvertor_14_40.convertConstraintSeverity(src.getSeverity()));
        tgt.setHuman(src.getHuman());
        if (src.hasExpression()) {
            tgt.setExpression(src.getExpression());
        }
        tgt.setXpath(src.getXpath());
        return tgt;
    }

    private static ElementDefinition.ConstraintSeverity convertConstraintSeverity(ElementDefinition.ConstraintSeverity src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case ERROR: {
                return ElementDefinition.ConstraintSeverity.ERROR;
            }
            case WARNING: {
                return ElementDefinition.ConstraintSeverity.WARNING;
            }
        }
        return ElementDefinition.ConstraintSeverity.NULL;
    }

    private static ElementDefinition.ConstraintSeverity convertConstraintSeverity(ElementDefinition.ConstraintSeverity src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case ERROR: {
                return ElementDefinition.ConstraintSeverity.ERROR;
            }
            case WARNING: {
                return ElementDefinition.ConstraintSeverity.WARNING;
            }
        }
        return ElementDefinition.ConstraintSeverity.NULL;
    }

    public static ElementDefinition.ElementDefinitionBindingComponent convertElementDefinitionBindingComponent(ElementDefinition.ElementDefinitionBindingComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ElementDefinition.ElementDefinitionBindingComponent tgt = new ElementDefinition.ElementDefinitionBindingComponent();
        VersionConvertor_14_40.copyElement((org.hl7.fhir.dstu2016may.model.Element)src, (Element)tgt);
        tgt.setStrength(VersionConvertor_14_40.convertBindingStrength(src.getStrength()));
        if (src.hasDescription()) {
            tgt.setDescription(src.getDescription());
        }
        if (src.hasValueSet()) {
            Type vs = VersionConvertor_14_40.convertType(src.getValueSet());
            tgt.setValueSet((Type)(vs instanceof Reference ? new CanonicalType(((Reference)vs).getReference()) : vs));
        }
        return tgt;
    }

    public static ElementDefinition.ElementDefinitionBindingComponent convertElementDefinitionBindingComponent(ElementDefinition.ElementDefinitionBindingComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ElementDefinition.ElementDefinitionBindingComponent tgt = new ElementDefinition.ElementDefinitionBindingComponent();
        VersionConvertor_14_40.copyElement((Element)src, (org.hl7.fhir.dstu2016may.model.Element)tgt);
        tgt.setStrength(VersionConvertor_14_40.convertBindingStrength(src.getStrength()));
        if (src.hasDescription()) {
            tgt.setDescription(src.getDescription());
        }
        tgt.setValueSet((org.hl7.fhir.dstu2016may.model.Type)(src.hasValueSetCanonicalType() ? new org.hl7.fhir.dstu2016may.model.Reference((String)src.getValueSetCanonicalType().getValue()) : VersionConvertor_14_40.convertType(src.getValueSet())));
        return tgt;
    }

    private static Enumerations.BindingStrength convertBindingStrength(Enumerations.BindingStrength src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case REQUIRED: {
                return Enumerations.BindingStrength.REQUIRED;
            }
            case EXTENSIBLE: {
                return Enumerations.BindingStrength.EXTENSIBLE;
            }
            case PREFERRED: {
                return Enumerations.BindingStrength.PREFERRED;
            }
            case EXAMPLE: {
                return Enumerations.BindingStrength.EXAMPLE;
            }
        }
        return Enumerations.BindingStrength.NULL;
    }

    private static Enumerations.BindingStrength convertBindingStrength(Enumerations.BindingStrength src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case REQUIRED: {
                return Enumerations.BindingStrength.REQUIRED;
            }
            case EXTENSIBLE: {
                return Enumerations.BindingStrength.EXTENSIBLE;
            }
            case PREFERRED: {
                return Enumerations.BindingStrength.PREFERRED;
            }
            case EXAMPLE: {
                return Enumerations.BindingStrength.EXAMPLE;
            }
        }
        return Enumerations.BindingStrength.NULL;
    }

    public static ElementDefinition.ElementDefinitionMappingComponent convertElementDefinitionMappingComponent(ElementDefinition.ElementDefinitionMappingComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ElementDefinition.ElementDefinitionMappingComponent tgt = new ElementDefinition.ElementDefinitionMappingComponent();
        VersionConvertor_14_40.copyElement((org.hl7.fhir.dstu2016may.model.Element)src, (Element)tgt);
        tgt.setIdentity(src.getIdentity());
        if (src.hasLanguage()) {
            tgt.setLanguage(src.getLanguage());
        }
        tgt.setMap(src.getMap());
        return tgt;
    }

    public static ElementDefinition.ElementDefinitionMappingComponent convertElementDefinitionMappingComponent(ElementDefinition.ElementDefinitionMappingComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ElementDefinition.ElementDefinitionMappingComponent tgt = new ElementDefinition.ElementDefinitionMappingComponent();
        VersionConvertor_14_40.copyElement((Element)src, (org.hl7.fhir.dstu2016may.model.Element)tgt);
        tgt.setIdentity(src.getIdentity());
        if (src.hasLanguage()) {
            tgt.setLanguage(src.getLanguage());
        }
        tgt.setMap(src.getMap());
        return tgt;
    }

    public static HumanName convertHumanName(org.hl7.fhir.dstu2016may.model.HumanName src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        HumanName tgt = new HumanName();
        VersionConvertor_14_40.copyElement((org.hl7.fhir.dstu2016may.model.Element)src, (Element)tgt);
        tgt.setUse(VersionConvertor_14_40.convertNameUse(src.getUse()));
        if (src.hasText()) {
            tgt.setText(src.getText());
        }
        for (org.hl7.fhir.dstu2016may.model.StringType t : src.getFamily()) {
            tgt.setFamily((String)t.getValue());
        }
        for (org.hl7.fhir.dstu2016may.model.StringType t : src.getGiven()) {
            tgt.addGiven((String)t.getValue());
        }
        for (org.hl7.fhir.dstu2016may.model.StringType t : src.getPrefix()) {
            tgt.addPrefix((String)t.getValue());
        }
        for (org.hl7.fhir.dstu2016may.model.StringType t : src.getSuffix()) {
            tgt.addSuffix((String)t.getValue());
        }
        tgt.setPeriod(VersionConvertor_14_40.convertPeriod(src.getPeriod()));
        return tgt;
    }

    public static org.hl7.fhir.dstu2016may.model.HumanName convertHumanName(HumanName src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2016may.model.HumanName tgt = new org.hl7.fhir.dstu2016may.model.HumanName();
        VersionConvertor_14_40.copyElement((Element)src, (org.hl7.fhir.dstu2016may.model.Element)tgt);
        tgt.setUse(VersionConvertor_14_40.convertNameUse(src.getUse()));
        if (src.hasText()) {
            tgt.setText(src.getText());
        }
        if (src.hasFamily()) {
            tgt.addFamily(src.getFamily());
        }
        for (StringType t : src.getGiven()) {
            tgt.addGiven((String)t.getValue());
        }
        for (StringType t : src.getPrefix()) {
            tgt.addPrefix((String)t.getValue());
        }
        for (StringType t : src.getSuffix()) {
            tgt.addSuffix((String)t.getValue());
        }
        tgt.setPeriod(VersionConvertor_14_40.convertPeriod(src.getPeriod()));
        return tgt;
    }

    private static HumanName.NameUse convertNameUse(HumanName.NameUse src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case USUAL: {
                return HumanName.NameUse.USUAL;
            }
            case OFFICIAL: {
                return HumanName.NameUse.OFFICIAL;
            }
            case TEMP: {
                return HumanName.NameUse.TEMP;
            }
            case NICKNAME: {
                return HumanName.NameUse.NICKNAME;
            }
            case ANONYMOUS: {
                return HumanName.NameUse.ANONYMOUS;
            }
            case OLD: {
                return HumanName.NameUse.OLD;
            }
            case MAIDEN: {
                return HumanName.NameUse.MAIDEN;
            }
        }
        return HumanName.NameUse.NULL;
    }

    private static HumanName.NameUse convertNameUse(HumanName.NameUse src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case USUAL: {
                return HumanName.NameUse.USUAL;
            }
            case OFFICIAL: {
                return HumanName.NameUse.OFFICIAL;
            }
            case TEMP: {
                return HumanName.NameUse.TEMP;
            }
            case NICKNAME: {
                return HumanName.NameUse.NICKNAME;
            }
            case ANONYMOUS: {
                return HumanName.NameUse.ANONYMOUS;
            }
            case OLD: {
                return HumanName.NameUse.OLD;
            }
            case MAIDEN: {
                return HumanName.NameUse.MAIDEN;
            }
        }
        return HumanName.NameUse.NULL;
    }

    public static Meta convertMeta(org.hl7.fhir.dstu2016may.model.Meta src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Meta tgt = new Meta();
        VersionConvertor_14_40.copyElement((org.hl7.fhir.dstu2016may.model.Element)src, (Element)tgt);
        if (src.hasVersionId()) {
            tgt.setVersionId(src.getVersionId());
        }
        if (src.hasLastUpdated()) {
            tgt.setLastUpdated(src.getLastUpdated());
        }
        for (org.hl7.fhir.dstu2016may.model.UriType t : src.getProfile()) {
            tgt.addProfile((String)t.getValue());
        }
        for (org.hl7.fhir.dstu2016may.model.UriType t : src.getSecurity()) {
            tgt.addSecurity(VersionConvertor_14_40.convertCoding((org.hl7.fhir.dstu2016may.model.Coding)t));
        }
        for (org.hl7.fhir.dstu2016may.model.UriType t : src.getTag()) {
            tgt.addTag(VersionConvertor_14_40.convertCoding((org.hl7.fhir.dstu2016may.model.Coding)t));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2016may.model.Meta convertMeta(Meta src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2016may.model.Meta tgt = new org.hl7.fhir.dstu2016may.model.Meta();
        VersionConvertor_14_40.copyElement((Element)src, (org.hl7.fhir.dstu2016may.model.Element)tgt);
        if (src.hasVersionId()) {
            tgt.setVersionId(src.getVersionId());
        }
        if (src.hasLastUpdated()) {
            tgt.setLastUpdated(src.getLastUpdated());
        }
        for (UriType t : src.getProfile()) {
            tgt.addProfile((String)t.getValue());
        }
        for (UriType t : src.getSecurity()) {
            tgt.addSecurity(VersionConvertor_14_40.convertCoding((Coding)t));
        }
        for (UriType t : src.getTag()) {
            tgt.addTag(VersionConvertor_14_40.convertCoding((Coding)t));
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.Timing convertTiming(Timing src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r4.model.Timing tgt = new org.hl7.fhir.r4.model.Timing();
        VersionConvertor_14_40.copyElement((org.hl7.fhir.dstu2016may.model.Element)src, (Element)tgt);
        for (org.hl7.fhir.dstu2016may.model.DateTimeType t : src.getEvent()) {
            tgt.addEvent((Date)t.getValue());
        }
        tgt.setRepeat(VersionConvertor_14_40.convertTimingRepeatComponent(src.getRepeat()));
        tgt.setCode(VersionConvertor_14_40.convertCodeableConcept(src.getCode()));
        return tgt;
    }

    public static Timing convertTiming(org.hl7.fhir.r4.model.Timing src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Timing tgt = new Timing();
        VersionConvertor_14_40.copyElement((Element)src, (org.hl7.fhir.dstu2016may.model.Element)tgt);
        for (DateTimeType t : src.getEvent()) {
            tgt.addEvent((Date)t.getValue());
        }
        tgt.setRepeat(VersionConvertor_14_40.convertTimingRepeatComponent(src.getRepeat()));
        tgt.setCode(VersionConvertor_14_40.convertCodeableConcept(src.getCode()));
        return tgt;
    }

    public static Timing.TimingRepeatComponent convertTimingRepeatComponent(Timing.TimingRepeatComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Timing.TimingRepeatComponent tgt = new Timing.TimingRepeatComponent();
        VersionConvertor_14_40.copyElement((org.hl7.fhir.dstu2016may.model.Element)src, (Element)tgt);
        tgt.setBounds(VersionConvertor_14_40.convertType(src.getBounds()));
        if (src.hasCount()) {
            tgt.setCount(src.getCount());
        }
        if (src.hasCountMax()) {
            tgt.setCountMax(src.getCountMax());
        }
        if (src.hasDuration()) {
            tgt.setDuration(src.getDuration());
        }
        if (src.hasDurationMax()) {
            tgt.setDurationMax(src.getDurationMax());
        }
        tgt.setDurationUnit(VersionConvertor_14_40.convertUnitsOfTime(src.getDurationUnit()));
        if (src.hasFrequency()) {
            tgt.setFrequency(src.getFrequency());
        }
        if (src.hasFrequencyMax()) {
            tgt.setFrequencyMax(src.getFrequencyMax());
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(src.getPeriod());
        }
        if (src.hasPeriodMax()) {
            tgt.setPeriodMax(src.getPeriodMax());
        }
        tgt.setPeriodUnit(VersionConvertor_14_40.convertUnitsOfTime(src.getPeriodUnit()));
        tgt.addWhen(VersionConvertor_14_40.convertEventTiming(src.getWhen()));
        if (src.hasOffset()) {
            tgt.setOffset(src.getOffset());
        }
        return tgt;
    }

    public static Timing.TimingRepeatComponent convertTimingRepeatComponent(Timing.TimingRepeatComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Timing.TimingRepeatComponent tgt = new Timing.TimingRepeatComponent();
        VersionConvertor_14_40.copyElement((Element)src, (org.hl7.fhir.dstu2016may.model.Element)tgt);
        tgt.setBounds(VersionConvertor_14_40.convertType(src.getBounds()));
        if (src.hasCount()) {
            tgt.setCount(src.getCount());
        }
        if (src.hasCountMax()) {
            tgt.setCountMax(src.getCountMax());
        }
        if (src.hasDuration()) {
            tgt.setDuration(src.getDuration());
        }
        if (src.hasDurationMax()) {
            tgt.setDurationMax(src.getDurationMax());
        }
        tgt.setDurationUnit(VersionConvertor_14_40.convertUnitsOfTime(src.getDurationUnit()));
        if (src.hasFrequency()) {
            tgt.setFrequency(src.getFrequency());
        }
        if (src.hasFrequencyMax()) {
            tgt.setFrequencyMax(src.getFrequencyMax());
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(src.getPeriod());
        }
        if (src.hasPeriodMax()) {
            tgt.setPeriodMax(src.getPeriodMax());
        }
        tgt.setPeriodUnit(VersionConvertor_14_40.convertUnitsOfTime(src.getPeriodUnit()));
        for (Enumeration t : src.getWhen()) {
            tgt.setWhen(VersionConvertor_14_40.convertEventTiming((Timing.EventTiming)t.getValue()));
        }
        if (src.hasOffset()) {
            tgt.setOffset(src.getOffset());
        }
        return tgt;
    }

    private static Timing.UnitsOfTime convertUnitsOfTime(Timing.UnitsOfTime src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case S: {
                return Timing.UnitsOfTime.S;
            }
            case MIN: {
                return Timing.UnitsOfTime.MIN;
            }
            case H: {
                return Timing.UnitsOfTime.H;
            }
            case D: {
                return Timing.UnitsOfTime.D;
            }
            case WK: {
                return Timing.UnitsOfTime.WK;
            }
            case MO: {
                return Timing.UnitsOfTime.MO;
            }
            case A: {
                return Timing.UnitsOfTime.A;
            }
        }
        return Timing.UnitsOfTime.NULL;
    }

    private static Timing.UnitsOfTime convertUnitsOfTime(Timing.UnitsOfTime src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case S: {
                return Timing.UnitsOfTime.S;
            }
            case MIN: {
                return Timing.UnitsOfTime.MIN;
            }
            case H: {
                return Timing.UnitsOfTime.H;
            }
            case D: {
                return Timing.UnitsOfTime.D;
            }
            case WK: {
                return Timing.UnitsOfTime.WK;
            }
            case MO: {
                return Timing.UnitsOfTime.MO;
            }
            case A: {
                return Timing.UnitsOfTime.A;
            }
        }
        return Timing.UnitsOfTime.NULL;
    }

    private static Timing.EventTiming convertEventTiming(Timing.EventTiming src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case HS: {
                return Timing.EventTiming.HS;
            }
            case WAKE: {
                return Timing.EventTiming.WAKE;
            }
            case C: {
                return Timing.EventTiming.C;
            }
            case CM: {
                return Timing.EventTiming.CM;
            }
            case CD: {
                return Timing.EventTiming.CD;
            }
            case CV: {
                return Timing.EventTiming.CV;
            }
            case AC: {
                return Timing.EventTiming.AC;
            }
            case ACM: {
                return Timing.EventTiming.ACM;
            }
            case ACD: {
                return Timing.EventTiming.ACD;
            }
            case ACV: {
                return Timing.EventTiming.ACV;
            }
            case PC: {
                return Timing.EventTiming.PC;
            }
            case PCM: {
                return Timing.EventTiming.PCM;
            }
            case PCD: {
                return Timing.EventTiming.PCD;
            }
            case PCV: {
                return Timing.EventTiming.PCV;
            }
        }
        return Timing.EventTiming.NULL;
    }

    private static Timing.EventTiming convertEventTiming(Timing.EventTiming src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case HS: {
                return Timing.EventTiming.HS;
            }
            case WAKE: {
                return Timing.EventTiming.WAKE;
            }
            case C: {
                return Timing.EventTiming.C;
            }
            case CM: {
                return Timing.EventTiming.CM;
            }
            case CD: {
                return Timing.EventTiming.CD;
            }
            case CV: {
                return Timing.EventTiming.CV;
            }
            case AC: {
                return Timing.EventTiming.AC;
            }
            case ACM: {
                return Timing.EventTiming.ACM;
            }
            case ACD: {
                return Timing.EventTiming.ACD;
            }
            case ACV: {
                return Timing.EventTiming.ACV;
            }
            case PC: {
                return Timing.EventTiming.PC;
            }
            case PCM: {
                return Timing.EventTiming.PCM;
            }
            case PCD: {
                return Timing.EventTiming.PCD;
            }
            case PCV: {
                return Timing.EventTiming.PCV;
            }
        }
        return Timing.EventTiming.NULL;
    }

    public static org.hl7.fhir.r4.model.SimpleQuantity convertSimpleQuantity(SimpleQuantity src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r4.model.SimpleQuantity tgt = new org.hl7.fhir.r4.model.SimpleQuantity();
        VersionConvertor_14_40.copyElement((org.hl7.fhir.dstu2016may.model.Element)src, (Element)tgt);
        if (src.hasValue()) {
            tgt.setValue(src.getValue());
        }
        tgt.setComparator(VersionConvertor_14_40.convertQuantityComparator(src.getComparator()));
        if (src.hasUnit()) {
            tgt.setUnit(src.getUnit());
        }
        if (src.hasSystem()) {
            tgt.setSystem(src.getSystem());
        }
        if (src.hasCode()) {
            tgt.setCode(src.getCode());
        }
        return tgt;
    }

    public static SimpleQuantity convertSimpleQuantity(org.hl7.fhir.r4.model.SimpleQuantity src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        SimpleQuantity tgt = new SimpleQuantity();
        VersionConvertor_14_40.copyElement((Element)src, (org.hl7.fhir.dstu2016may.model.Element)tgt);
        if (src.hasValue()) {
            tgt.setValue(src.getValue());
        }
        tgt.setComparator(VersionConvertor_14_40.convertQuantityComparator(src.getComparator()));
        if (src.hasUnit()) {
            tgt.setUnit(src.getUnit());
        }
        if (src.hasSystem()) {
            tgt.setSystem(src.getSystem());
        }
        if (src.hasCode()) {
            tgt.setCode(src.getCode());
        }
        return tgt;
    }

    public static Type convertType(org.hl7.fhir.dstu2016may.model.Type src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        if (src instanceof Base64BinaryType) {
            return VersionConvertor_14_40.convertBase64Binary((Base64BinaryType)src);
        }
        if (src instanceof org.hl7.fhir.dstu2016may.model.BooleanType) {
            return VersionConvertor_14_40.convertBoolean((org.hl7.fhir.dstu2016may.model.BooleanType)src);
        }
        if (src instanceof org.hl7.fhir.dstu2016may.model.CodeType) {
            return VersionConvertor_14_40.convertCode((org.hl7.fhir.dstu2016may.model.CodeType)src);
        }
        if (src instanceof org.hl7.fhir.dstu2016may.model.DateType) {
            return VersionConvertor_14_40.convertDate((org.hl7.fhir.dstu2016may.model.DateType)src);
        }
        if (src instanceof org.hl7.fhir.dstu2016may.model.DateTimeType) {
            return VersionConvertor_14_40.convertDateTime((org.hl7.fhir.dstu2016may.model.DateTimeType)src);
        }
        if (src instanceof DecimalType) {
            return VersionConvertor_14_40.convertDecimal((DecimalType)src);
        }
        if (src instanceof org.hl7.fhir.dstu2016may.model.IdType) {
            return VersionConvertor_14_40.convertId((org.hl7.fhir.dstu2016may.model.IdType)src);
        }
        if (src instanceof org.hl7.fhir.dstu2016may.model.InstantType) {
            return VersionConvertor_14_40.convertInstant((org.hl7.fhir.dstu2016may.model.InstantType)src);
        }
        if (src instanceof IntegerType) {
            return VersionConvertor_14_40.convertInteger((IntegerType)src);
        }
        if (src instanceof MarkdownType) {
            return VersionConvertor_14_40.convertMarkdown((MarkdownType)src);
        }
        if (src instanceof org.hl7.fhir.dstu2016may.model.OidType) {
            return VersionConvertor_14_40.convertOid((org.hl7.fhir.dstu2016may.model.OidType)src);
        }
        if (src instanceof org.hl7.fhir.dstu2016may.model.PositiveIntType) {
            return VersionConvertor_14_40.convertPositiveInt((org.hl7.fhir.dstu2016may.model.PositiveIntType)src);
        }
        if (src instanceof org.hl7.fhir.dstu2016may.model.StringType) {
            return VersionConvertor_14_40.convertString((org.hl7.fhir.dstu2016may.model.StringType)src);
        }
        if (src instanceof org.hl7.fhir.dstu2016may.model.TimeType) {
            return VersionConvertor_14_40.convertTime((org.hl7.fhir.dstu2016may.model.TimeType)src);
        }
        if (src instanceof UnsignedIntType) {
            return VersionConvertor_14_40.convertUnsignedInt((UnsignedIntType)src);
        }
        if (src instanceof org.hl7.fhir.dstu2016may.model.UriType) {
            return VersionConvertor_14_40.convertUri((org.hl7.fhir.dstu2016may.model.UriType)src);
        }
        if (src instanceof org.hl7.fhir.dstu2016may.model.UuidType) {
            return VersionConvertor_14_40.convertUuid((org.hl7.fhir.dstu2016may.model.UuidType)src);
        }
        if (src instanceof org.hl7.fhir.dstu2016may.model.Extension) {
            return VersionConvertor_14_40.convertExtension((org.hl7.fhir.dstu2016may.model.Extension)src);
        }
        if (src instanceof Narrative) {
            return VersionConvertor_14_40.convertNarrative((Narrative)src);
        }
        if (src instanceof org.hl7.fhir.dstu2016may.model.Age) {
            return VersionConvertor_14_40.convertAge((org.hl7.fhir.dstu2016may.model.Age)src);
        }
        if (src instanceof Annotation) {
            return VersionConvertor_14_40.convertAnnotation((Annotation)src);
        }
        if (src instanceof org.hl7.fhir.dstu2016may.model.Attachment) {
            return VersionConvertor_14_40.convertAttachment((org.hl7.fhir.dstu2016may.model.Attachment)src);
        }
        if (src instanceof CodeableConcept) {
            return VersionConvertor_14_40.convertCodeableConcept((CodeableConcept)src);
        }
        if (src instanceof org.hl7.fhir.dstu2016may.model.Coding) {
            return VersionConvertor_14_40.convertCoding((org.hl7.fhir.dstu2016may.model.Coding)src);
        }
        if (src instanceof Count) {
            return VersionConvertor_14_40.convertCount((Count)src);
        }
        if (src instanceof Distance) {
            return VersionConvertor_14_40.convertDistance((Distance)src);
        }
        if (src instanceof org.hl7.fhir.dstu2016may.model.Duration) {
            return VersionConvertor_14_40.convertDuration((org.hl7.fhir.dstu2016may.model.Duration)src);
        }
        if (src instanceof org.hl7.fhir.dstu2016may.model.Identifier) {
            return VersionConvertor_14_40.convertIdentifier((org.hl7.fhir.dstu2016may.model.Identifier)src);
        }
        if (src instanceof Money) {
            return VersionConvertor_14_40.convertMoney((Money)src);
        }
        if (src instanceof org.hl7.fhir.dstu2016may.model.Period) {
            return VersionConvertor_14_40.convertPeriod((org.hl7.fhir.dstu2016may.model.Period)src);
        }
        if (src instanceof org.hl7.fhir.dstu2016may.model.Quantity) {
            return VersionConvertor_14_40.convertQuantity((org.hl7.fhir.dstu2016may.model.Quantity)src);
        }
        if (src instanceof Range) {
            return VersionConvertor_14_40.convertRange((Range)src);
        }
        if (src instanceof Ratio) {
            return VersionConvertor_14_40.convertRatio((Ratio)src);
        }
        if (src instanceof org.hl7.fhir.dstu2016may.model.Reference) {
            return VersionConvertor_14_40.convertReference((org.hl7.fhir.dstu2016may.model.Reference)src);
        }
        if (src instanceof org.hl7.fhir.dstu2016may.model.SampledData) {
            return VersionConvertor_14_40.convertSampledData((org.hl7.fhir.dstu2016may.model.SampledData)src);
        }
        if (src instanceof org.hl7.fhir.dstu2016may.model.Signature) {
            return VersionConvertor_14_40.convertSignature((org.hl7.fhir.dstu2016may.model.Signature)src);
        }
        if (src instanceof Address) {
            return VersionConvertor_14_40.convertAddress((Address)src);
        }
        if (src instanceof org.hl7.fhir.dstu2016may.model.ContactPoint) {
            return VersionConvertor_14_40.convertContactPoint((org.hl7.fhir.dstu2016may.model.ContactPoint)src);
        }
        if (src instanceof org.hl7.fhir.dstu2016may.model.HumanName) {
            return VersionConvertor_14_40.convertHumanName((org.hl7.fhir.dstu2016may.model.HumanName)src);
        }
        if (src instanceof org.hl7.fhir.dstu2016may.model.Meta) {
            return VersionConvertor_14_40.convertMeta((org.hl7.fhir.dstu2016may.model.Meta)src);
        }
        if (src instanceof Timing) {
            return VersionConvertor_14_40.convertTiming((Timing)src);
        }
        throw new Error("Unknown type " + src.fhirType());
    }

    public static org.hl7.fhir.dstu2016may.model.Type convertType(Type src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        if (src instanceof org.hl7.fhir.r4.model.Base64BinaryType) {
            return VersionConvertor_14_40.convertBase64Binary((org.hl7.fhir.r4.model.Base64BinaryType)src);
        }
        if (src instanceof BooleanType) {
            return VersionConvertor_14_40.convertBoolean((BooleanType)src);
        }
        if (src instanceof CodeType) {
            return VersionConvertor_14_40.convertCode((CodeType)src);
        }
        if (src instanceof DateType) {
            return VersionConvertor_14_40.convertDate((DateType)src);
        }
        if (src instanceof DateTimeType) {
            return VersionConvertor_14_40.convertDateTime((DateTimeType)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.DecimalType) {
            return VersionConvertor_14_40.convertDecimal((org.hl7.fhir.r4.model.DecimalType)src);
        }
        if (src instanceof IdType) {
            return VersionConvertor_14_40.convertId((IdType)src);
        }
        if (src instanceof InstantType) {
            return VersionConvertor_14_40.convertInstant((InstantType)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.IntegerType) {
            return VersionConvertor_14_40.convertInteger((org.hl7.fhir.r4.model.IntegerType)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.MarkdownType) {
            return VersionConvertor_14_40.convertMarkdown((org.hl7.fhir.r4.model.MarkdownType)src);
        }
        if (src instanceof OidType) {
            return VersionConvertor_14_40.convertOid((OidType)src);
        }
        if (src instanceof PositiveIntType) {
            return VersionConvertor_14_40.convertPositiveInt((PositiveIntType)src);
        }
        if (src instanceof StringType) {
            return VersionConvertor_14_40.convertString((StringType)src);
        }
        if (src instanceof TimeType) {
            return VersionConvertor_14_40.convertTime((TimeType)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.UnsignedIntType) {
            return VersionConvertor_14_40.convertUnsignedInt((org.hl7.fhir.r4.model.UnsignedIntType)src);
        }
        if (src instanceof UriType) {
            return VersionConvertor_14_40.convertUri((UriType)src);
        }
        if (src instanceof UuidType) {
            return VersionConvertor_14_40.convertUuid((UuidType)src);
        }
        if (src instanceof Extension) {
            return VersionConvertor_14_40.convertExtension((Extension)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.Narrative) {
            return VersionConvertor_14_40.convertNarrative((org.hl7.fhir.r4.model.Narrative)src);
        }
        if (src instanceof Age) {
            return VersionConvertor_14_40.convertAge((Age)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.Annotation) {
            return VersionConvertor_14_40.convertAnnotation((org.hl7.fhir.r4.model.Annotation)src);
        }
        if (src instanceof Attachment) {
            return VersionConvertor_14_40.convertAttachment((Attachment)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.CodeableConcept) {
            return VersionConvertor_14_40.convertCodeableConcept((org.hl7.fhir.r4.model.CodeableConcept)src);
        }
        if (src instanceof Coding) {
            return VersionConvertor_14_40.convertCoding((Coding)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.Count) {
            return VersionConvertor_14_40.convertCount((org.hl7.fhir.r4.model.Count)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.Distance) {
            return VersionConvertor_14_40.convertDistance((org.hl7.fhir.r4.model.Distance)src);
        }
        if (src instanceof Duration) {
            return VersionConvertor_14_40.convertDuration((Duration)src);
        }
        if (src instanceof Identifier) {
            return VersionConvertor_14_40.convertIdentifier((Identifier)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.Money) {
            return VersionConvertor_14_40.convertMoney((org.hl7.fhir.r4.model.Money)src);
        }
        if (src instanceof Period) {
            return VersionConvertor_14_40.convertPeriod((Period)src);
        }
        if (src instanceof Quantity) {
            return VersionConvertor_14_40.convertQuantity((Quantity)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.Range) {
            return VersionConvertor_14_40.convertRange((org.hl7.fhir.r4.model.Range)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.Ratio) {
            return VersionConvertor_14_40.convertRatio((org.hl7.fhir.r4.model.Ratio)src);
        }
        if (src instanceof Reference) {
            return VersionConvertor_14_40.convertReference((Reference)src);
        }
        if (src instanceof SampledData) {
            return VersionConvertor_14_40.convertSampledData((SampledData)src);
        }
        if (src instanceof Signature) {
            return VersionConvertor_14_40.convertSignature((Signature)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.Address) {
            return VersionConvertor_14_40.convertAddress((org.hl7.fhir.r4.model.Address)src);
        }
        if (src instanceof ContactPoint) {
            return VersionConvertor_14_40.convertContactPoint((ContactPoint)src);
        }
        if (src instanceof HumanName) {
            return VersionConvertor_14_40.convertHumanName((HumanName)src);
        }
        if (src instanceof Meta) {
            return VersionConvertor_14_40.convertMeta((Meta)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.Timing) {
            return VersionConvertor_14_40.convertTiming((org.hl7.fhir.r4.model.Timing)src);
        }
        throw new Error("Unknown type " + src.fhirType());
    }

    private static void copyDomainResource(DomainResource src, org.hl7.fhir.r4.model.DomainResource tgt) throws FHIRException {
        VersionConvertor_14_40.copyResource((org.hl7.fhir.dstu2016may.model.Resource)src, (Resource)tgt);
        tgt.setText(VersionConvertor_14_40.convertNarrative(src.getText()));
        for (org.hl7.fhir.dstu2016may.model.Resource t : src.getContained()) {
            tgt.addContained(VersionConvertor_14_40.convertResource(t));
        }
        for (org.hl7.fhir.dstu2016may.model.Resource t : src.getExtension()) {
            tgt.addExtension(VersionConvertor_14_40.convertExtension((org.hl7.fhir.dstu2016may.model.Extension)t));
        }
        for (org.hl7.fhir.dstu2016may.model.Resource t : src.getModifierExtension()) {
            tgt.addModifierExtension(VersionConvertor_14_40.convertExtension((org.hl7.fhir.dstu2016may.model.Extension)t));
        }
    }

    private static void copyDomainResource(org.hl7.fhir.r4.model.DomainResource src, DomainResource tgt) throws FHIRException {
        VersionConvertor_14_40.copyResource((Resource)src, (org.hl7.fhir.dstu2016may.model.Resource)tgt);
        if (src.hasText()) {
            tgt.setText(VersionConvertor_14_40.convertNarrative(src.getText()));
        }
        for (Resource t : src.getContained()) {
            tgt.addContained(VersionConvertor_14_40.convertResource(t));
        }
        for (Resource t : src.getExtension()) {
            tgt.addExtension(VersionConvertor_14_40.convertExtension((Extension)t));
        }
        for (Resource t : src.getModifierExtension()) {
            tgt.addModifierExtension(VersionConvertor_14_40.convertExtension((Extension)t));
        }
    }

    public static Parameters convertParameters(org.hl7.fhir.dstu2016may.model.Parameters src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Parameters tgt = new Parameters();
        VersionConvertor_14_40.copyResource((org.hl7.fhir.dstu2016may.model.Resource)src, (Resource)tgt);
        for (Parameters.ParametersParameterComponent t : src.getParameter()) {
            tgt.addParameter(VersionConvertor_14_40.convertParametersParameterComponent(t));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2016may.model.Parameters convertParameters(Parameters src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2016may.model.Parameters tgt = new org.hl7.fhir.dstu2016may.model.Parameters();
        VersionConvertor_14_40.copyResource((Resource)src, (org.hl7.fhir.dstu2016may.model.Resource)tgt);
        for (Parameters.ParametersParameterComponent t : src.getParameter()) {
            tgt.addParameter(VersionConvertor_14_40.convertParametersParameterComponent(t));
        }
        return tgt;
    }

    public static Parameters.ParametersParameterComponent convertParametersParameterComponent(Parameters.ParametersParameterComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Parameters.ParametersParameterComponent tgt = new Parameters.ParametersParameterComponent();
        VersionConvertor_14_40.copyElement((org.hl7.fhir.dstu2016may.model.Element)src, (Element)tgt);
        tgt.setName(src.getName());
        tgt.setValue(VersionConvertor_14_40.convertType(src.getValue()));
        tgt.setResource(VersionConvertor_14_40.convertResource(src.getResource()));
        for (Parameters.ParametersParameterComponent t : src.getPart()) {
            tgt.addPart(VersionConvertor_14_40.convertParametersParameterComponent(t));
        }
        return tgt;
    }

    public static Parameters.ParametersParameterComponent convertParametersParameterComponent(Parameters.ParametersParameterComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Parameters.ParametersParameterComponent tgt = new Parameters.ParametersParameterComponent();
        VersionConvertor_14_40.copyElement((Element)src, (org.hl7.fhir.dstu2016may.model.Element)tgt);
        tgt.setName(src.getName());
        tgt.setValue(VersionConvertor_14_40.convertType(src.getValue()));
        tgt.setResource(VersionConvertor_14_40.convertResource(src.getResource()));
        for (Parameters.ParametersParameterComponent t : src.getPart()) {
            tgt.addPart(VersionConvertor_14_40.convertParametersParameterComponent(t));
        }
        return tgt;
    }

    private static void copyResource(org.hl7.fhir.dstu2016may.model.Resource src, Resource tgt) throws FHIRException {
        if (src.hasId()) {
            tgt.setId(src.getId());
        }
        tgt.setMeta(VersionConvertor_14_40.convertMeta(src.getMeta()));
        if (src.hasImplicitRules()) {
            tgt.setImplicitRules(src.getImplicitRules());
        }
        if (src.hasLanguage()) {
            tgt.setLanguage(src.getLanguage());
        }
    }

    private static void copyResource(Resource src, org.hl7.fhir.dstu2016may.model.Resource tgt) throws FHIRException {
        if (src.hasId()) {
            tgt.setId(src.getId());
        }
        if (src.hasMeta()) {
            tgt.setMeta(VersionConvertor_14_40.convertMeta(src.getMeta()));
        }
        if (src.hasImplicitRules()) {
            tgt.setImplicitRules(src.getImplicitRules());
        }
        if (src.hasLanguage()) {
            tgt.setLanguage(src.getLanguage());
        }
    }

    public static Binary convertBinary(org.hl7.fhir.dstu2016may.model.Binary src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Binary tgt = new Binary();
        VersionConvertor_14_40.copyResource((org.hl7.fhir.dstu2016may.model.Resource)src, (Resource)tgt);
        tgt.setContentType(src.getContentType());
        tgt.setContent(src.getContent());
        return tgt;
    }

    public static org.hl7.fhir.dstu2016may.model.Binary convertBinary(Binary src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2016may.model.Binary tgt = new org.hl7.fhir.dstu2016may.model.Binary();
        VersionConvertor_14_40.copyResource((Resource)src, (org.hl7.fhir.dstu2016may.model.Resource)tgt);
        tgt.setContentType(src.getContentType());
        tgt.setContent(src.getContent());
        return tgt;
    }

    public static Bundle convertBundle(org.hl7.fhir.dstu2016may.model.Bundle src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Bundle tgt = new Bundle();
        VersionConvertor_14_40.copyResource((org.hl7.fhir.dstu2016may.model.Resource)src, (Resource)tgt);
        tgt.setType(VersionConvertor_14_40.convertBundleType(src.getType()));
        if (src.hasTotal()) {
            tgt.setTotal(src.getTotal());
        }
        for (Bundle.BundleLinkComponent t : src.getLink()) {
            tgt.addLink(VersionConvertor_14_40.convertBundleLinkComponent(t));
        }
        for (Bundle.BundleLinkComponent t : src.getEntry()) {
            tgt.addEntry(VersionConvertor_14_40.convertBundleEntryComponent((Bundle.BundleEntryComponent)t));
        }
        tgt.setSignature(VersionConvertor_14_40.convertSignature(src.getSignature()));
        return tgt;
    }

    public static org.hl7.fhir.dstu2016may.model.Bundle convertBundle(Bundle src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2016may.model.Bundle tgt = new org.hl7.fhir.dstu2016may.model.Bundle();
        VersionConvertor_14_40.copyResource((Resource)src, (org.hl7.fhir.dstu2016may.model.Resource)tgt);
        tgt.setType(VersionConvertor_14_40.convertBundleType(src.getType()));
        if (src.hasTotal()) {
            tgt.setTotal(src.getTotal());
        }
        for (Bundle.BundleLinkComponent t : src.getLink()) {
            tgt.addLink(VersionConvertor_14_40.convertBundleLinkComponent(t));
        }
        for (Bundle.BundleLinkComponent t : src.getEntry()) {
            tgt.addEntry(VersionConvertor_14_40.convertBundleEntryComponent((Bundle.BundleEntryComponent)t));
        }
        tgt.setSignature(VersionConvertor_14_40.convertSignature(src.getSignature()));
        return tgt;
    }

    private static Bundle.BundleType convertBundleType(Bundle.BundleType src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case DOCUMENT: {
                return Bundle.BundleType.DOCUMENT;
            }
            case MESSAGE: {
                return Bundle.BundleType.MESSAGE;
            }
            case TRANSACTION: {
                return Bundle.BundleType.TRANSACTION;
            }
            case TRANSACTIONRESPONSE: {
                return Bundle.BundleType.TRANSACTIONRESPONSE;
            }
            case BATCH: {
                return Bundle.BundleType.BATCH;
            }
            case BATCHRESPONSE: {
                return Bundle.BundleType.BATCHRESPONSE;
            }
            case HISTORY: {
                return Bundle.BundleType.HISTORY;
            }
            case SEARCHSET: {
                return Bundle.BundleType.SEARCHSET;
            }
            case COLLECTION: {
                return Bundle.BundleType.COLLECTION;
            }
        }
        return Bundle.BundleType.NULL;
    }

    private static Bundle.BundleType convertBundleType(Bundle.BundleType src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case DOCUMENT: {
                return Bundle.BundleType.DOCUMENT;
            }
            case MESSAGE: {
                return Bundle.BundleType.MESSAGE;
            }
            case TRANSACTION: {
                return Bundle.BundleType.TRANSACTION;
            }
            case TRANSACTIONRESPONSE: {
                return Bundle.BundleType.TRANSACTIONRESPONSE;
            }
            case BATCH: {
                return Bundle.BundleType.BATCH;
            }
            case BATCHRESPONSE: {
                return Bundle.BundleType.BATCHRESPONSE;
            }
            case HISTORY: {
                return Bundle.BundleType.HISTORY;
            }
            case SEARCHSET: {
                return Bundle.BundleType.SEARCHSET;
            }
            case COLLECTION: {
                return Bundle.BundleType.COLLECTION;
            }
        }
        return Bundle.BundleType.NULL;
    }

    public static Bundle.BundleLinkComponent convertBundleLinkComponent(Bundle.BundleLinkComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Bundle.BundleLinkComponent tgt = new Bundle.BundleLinkComponent();
        VersionConvertor_14_40.copyElement((org.hl7.fhir.dstu2016may.model.Element)src, (Element)tgt);
        tgt.setRelation(src.getRelation());
        tgt.setUrl(src.getUrl());
        return tgt;
    }

    public static Bundle.BundleLinkComponent convertBundleLinkComponent(Bundle.BundleLinkComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Bundle.BundleLinkComponent tgt = new Bundle.BundleLinkComponent();
        VersionConvertor_14_40.copyElement((Element)src, (org.hl7.fhir.dstu2016may.model.Element)tgt);
        tgt.setRelation(src.getRelation());
        tgt.setUrl(src.getUrl());
        return tgt;
    }

    public static Bundle.BundleEntryComponent convertBundleEntryComponent(Bundle.BundleEntryComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Bundle.BundleEntryComponent tgt = new Bundle.BundleEntryComponent();
        VersionConvertor_14_40.copyElement((org.hl7.fhir.dstu2016may.model.Element)src, (Element)tgt);
        for (Bundle.BundleLinkComponent t : src.getLink()) {
            tgt.addLink(VersionConvertor_14_40.convertBundleLinkComponent(t));
        }
        if (src.hasFullUrl()) {
            tgt.setFullUrl(src.getFullUrl());
        }
        tgt.setResource(VersionConvertor_14_40.convertResource(src.getResource()));
        tgt.setSearch(VersionConvertor_14_40.convertBundleEntrySearchComponent(src.getSearch()));
        tgt.setRequest(VersionConvertor_14_40.convertBundleEntryRequestComponent(src.getRequest()));
        tgt.setResponse(VersionConvertor_14_40.convertBundleEntryResponseComponent(src.getResponse()));
        return tgt;
    }

    public static Bundle.BundleEntryComponent convertBundleEntryComponent(Bundle.BundleEntryComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Bundle.BundleEntryComponent tgt = new Bundle.BundleEntryComponent();
        VersionConvertor_14_40.copyElement((Element)src, (org.hl7.fhir.dstu2016may.model.Element)tgt);
        for (Bundle.BundleLinkComponent t : src.getLink()) {
            tgt.addLink(VersionConvertor_14_40.convertBundleLinkComponent(t));
        }
        if (src.hasFullUrl()) {
            tgt.setFullUrl(src.getFullUrl());
        }
        tgt.setResource(VersionConvertor_14_40.convertResource(src.getResource()));
        tgt.setSearch(VersionConvertor_14_40.convertBundleEntrySearchComponent(src.getSearch()));
        tgt.setRequest(VersionConvertor_14_40.convertBundleEntryRequestComponent(src.getRequest()));
        tgt.setResponse(VersionConvertor_14_40.convertBundleEntryResponseComponent(src.getResponse()));
        return tgt;
    }

    public static Bundle.BundleEntrySearchComponent convertBundleEntrySearchComponent(Bundle.BundleEntrySearchComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Bundle.BundleEntrySearchComponent tgt = new Bundle.BundleEntrySearchComponent();
        VersionConvertor_14_40.copyElement((org.hl7.fhir.dstu2016may.model.Element)src, (Element)tgt);
        tgt.setMode(VersionConvertor_14_40.convertSearchEntryMode(src.getMode()));
        if (src.hasScore()) {
            tgt.setScore(src.getScore());
        }
        return tgt;
    }

    public static Bundle.BundleEntrySearchComponent convertBundleEntrySearchComponent(Bundle.BundleEntrySearchComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Bundle.BundleEntrySearchComponent tgt = new Bundle.BundleEntrySearchComponent();
        VersionConvertor_14_40.copyElement((Element)src, (org.hl7.fhir.dstu2016may.model.Element)tgt);
        tgt.setMode(VersionConvertor_14_40.convertSearchEntryMode(src.getMode()));
        if (src.hasScore()) {
            tgt.setScore(src.getScore());
        }
        return tgt;
    }

    private static Bundle.SearchEntryMode convertSearchEntryMode(Bundle.SearchEntryMode src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case MATCH: {
                return Bundle.SearchEntryMode.MATCH;
            }
            case INCLUDE: {
                return Bundle.SearchEntryMode.INCLUDE;
            }
            case OUTCOME: {
                return Bundle.SearchEntryMode.OUTCOME;
            }
        }
        return Bundle.SearchEntryMode.NULL;
    }

    private static Bundle.SearchEntryMode convertSearchEntryMode(Bundle.SearchEntryMode src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case MATCH: {
                return Bundle.SearchEntryMode.MATCH;
            }
            case INCLUDE: {
                return Bundle.SearchEntryMode.INCLUDE;
            }
            case OUTCOME: {
                return Bundle.SearchEntryMode.OUTCOME;
            }
        }
        return Bundle.SearchEntryMode.NULL;
    }

    public static Bundle.BundleEntryRequestComponent convertBundleEntryRequestComponent(Bundle.BundleEntryRequestComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Bundle.BundleEntryRequestComponent tgt = new Bundle.BundleEntryRequestComponent();
        VersionConvertor_14_40.copyElement((org.hl7.fhir.dstu2016may.model.Element)src, (Element)tgt);
        tgt.setMethod(VersionConvertor_14_40.convertHTTPVerb(src.getMethod()));
        tgt.setUrl(src.getUrl());
        if (src.hasIfNoneMatch()) {
            tgt.setIfNoneMatch(src.getIfNoneMatch());
        }
        if (src.hasIfModifiedSince()) {
            tgt.setIfModifiedSince(src.getIfModifiedSince());
        }
        if (src.hasIfMatch()) {
            tgt.setIfMatch(src.getIfMatch());
        }
        if (src.hasIfNoneExist()) {
            tgt.setIfNoneExist(src.getIfNoneExist());
        }
        return tgt;
    }

    public static Bundle.BundleEntryRequestComponent convertBundleEntryRequestComponent(Bundle.BundleEntryRequestComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Bundle.BundleEntryRequestComponent tgt = new Bundle.BundleEntryRequestComponent();
        VersionConvertor_14_40.copyElement((Element)src, (org.hl7.fhir.dstu2016may.model.Element)tgt);
        tgt.setMethod(VersionConvertor_14_40.convertHTTPVerb(src.getMethod()));
        tgt.setUrl(src.getUrl());
        if (src.hasIfNoneMatch()) {
            tgt.setIfNoneMatch(src.getIfNoneMatch());
        }
        if (src.hasIfModifiedSince()) {
            tgt.setIfModifiedSince(src.getIfModifiedSince());
        }
        if (src.hasIfMatch()) {
            tgt.setIfMatch(src.getIfMatch());
        }
        if (src.hasIfNoneExist()) {
            tgt.setIfNoneExist(src.getIfNoneExist());
        }
        return tgt;
    }

    private static Bundle.HTTPVerb convertHTTPVerb(Bundle.HTTPVerb src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case GET: {
                return Bundle.HTTPVerb.GET;
            }
            case POST: {
                return Bundle.HTTPVerb.POST;
            }
            case PUT: {
                return Bundle.HTTPVerb.PUT;
            }
            case DELETE: {
                return Bundle.HTTPVerb.DELETE;
            }
        }
        return Bundle.HTTPVerb.NULL;
    }

    private static Bundle.HTTPVerb convertHTTPVerb(Bundle.HTTPVerb src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case GET: {
                return Bundle.HTTPVerb.GET;
            }
            case POST: {
                return Bundle.HTTPVerb.POST;
            }
            case PUT: {
                return Bundle.HTTPVerb.PUT;
            }
            case DELETE: {
                return Bundle.HTTPVerb.DELETE;
            }
        }
        return Bundle.HTTPVerb.NULL;
    }

    public static Bundle.BundleEntryResponseComponent convertBundleEntryResponseComponent(Bundle.BundleEntryResponseComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Bundle.BundleEntryResponseComponent tgt = new Bundle.BundleEntryResponseComponent();
        VersionConvertor_14_40.copyElement((org.hl7.fhir.dstu2016may.model.Element)src, (Element)tgt);
        tgt.setStatus(src.getStatus());
        if (src.hasLocation()) {
            tgt.setLocation(src.getLocation());
        }
        if (src.hasEtag()) {
            tgt.setEtag(src.getEtag());
        }
        if (src.hasLastModified()) {
            tgt.setLastModified(src.getLastModified());
        }
        return tgt;
    }

    public static Bundle.BundleEntryResponseComponent convertBundleEntryResponseComponent(Bundle.BundleEntryResponseComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Bundle.BundleEntryResponseComponent tgt = new Bundle.BundleEntryResponseComponent();
        VersionConvertor_14_40.copyElement((Element)src, (org.hl7.fhir.dstu2016may.model.Element)tgt);
        tgt.setStatus(src.getStatus());
        if (src.hasLocation()) {
            tgt.setLocation(src.getLocation());
        }
        if (src.hasEtag()) {
            tgt.setEtag(src.getEtag());
        }
        if (src.hasLastModified()) {
            tgt.setLastModified(src.getLastModified());
        }
        return tgt;
    }

    public static Enumerations.PublicationStatus convertConformanceResourceStatus(Enumerations.ConformanceResourceStatus src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case DRAFT: {
                return Enumerations.PublicationStatus.DRAFT;
            }
            case ACTIVE: {
                return Enumerations.PublicationStatus.ACTIVE;
            }
            case RETIRED: {
                return Enumerations.PublicationStatus.RETIRED;
            }
        }
        return Enumerations.PublicationStatus.NULL;
    }

    public static Enumerations.ConformanceResourceStatus convertConformanceResourceStatus(Enumerations.PublicationStatus src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case DRAFT: {
                return Enumerations.ConformanceResourceStatus.DRAFT;
            }
            case ACTIVE: {
                return Enumerations.ConformanceResourceStatus.ACTIVE;
            }
            case RETIRED: {
                return Enumerations.ConformanceResourceStatus.RETIRED;
            }
        }
        return Enumerations.ConformanceResourceStatus.NULL;
    }

    public static CodeSystem convertCodeSystem(org.hl7.fhir.dstu2016may.model.CodeSystem src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        CodeSystem tgt = new CodeSystem();
        VersionConvertor_14_40.copyDomainResource((DomainResource)src, (org.hl7.fhir.r4.model.DomainResource)tgt);
        if (src.hasUrl()) {
            tgt.setUrl(src.getUrl());
        }
        tgt.setIdentifier(VersionConvertor_14_40.convertIdentifier(src.getIdentifier()));
        if (src.hasVersion()) {
            tgt.setVersion(src.getVersion());
        }
        if (src.hasName()) {
            tgt.setName(src.getName());
        }
        tgt.setStatus(VersionConvertor_14_40.convertConformanceResourceStatus(src.getStatus()));
        if (src.hasExperimental()) {
            tgt.setExperimental(src.getExperimental());
        }
        if (src.hasPublisher()) {
            tgt.setPublisher(src.getPublisher());
        }
        for (CodeSystem.CodeSystemContactComponent t : src.getContact()) {
            tgt.addContact(VersionConvertor_14_40.convertCodeSystemContactComponent(t));
        }
        if (src.hasDate()) {
            tgt.setDate(src.getDate());
        }
        if (src.hasDescription()) {
            tgt.setDescription(src.getDescription());
        }
        for (CodeSystem.CodeSystemContactComponent t : src.getUseContext()) {
            if (VersionConvertor_14_40.isJurisdiction((CodeableConcept)t)) {
                tgt.addJurisdiction(VersionConvertor_14_40.convertCodeableConcept((CodeableConcept)t));
                continue;
            }
            tgt.addUseContext(VersionConvertor_14_40.convertCodeableConceptToUsageContext((CodeableConcept)t));
        }
        if (src.hasRequirements()) {
            tgt.setPurpose(src.getRequirements());
        }
        if (src.hasCopyright()) {
            tgt.setCopyright(src.getCopyright());
        }
        if (src.hasCaseSensitive()) {
            tgt.setCaseSensitive(src.getCaseSensitive());
        }
        if (src.hasValueSet()) {
            tgt.setValueSet(src.getValueSet());
        }
        if (src.hasCompositional()) {
            tgt.setCompositional(src.getCompositional());
        }
        if (src.hasVersionNeeded()) {
            tgt.setVersionNeeded(src.getVersionNeeded());
        }
        tgt.setContent(VersionConvertor_14_40.convertCodeSystemContentMode(src.getContent()));
        if (src.hasCount()) {
            tgt.setCount(src.getCount());
        }
        for (CodeSystem.CodeSystemContactComponent t : src.getFilter()) {
            tgt.addFilter(VersionConvertor_14_40.convertCodeSystemFilterComponent((CodeSystem.CodeSystemFilterComponent)t));
        }
        for (CodeSystem.CodeSystemContactComponent t : src.getProperty()) {
            tgt.addProperty(VersionConvertor_14_40.convertPropertyComponent((CodeSystem.CodeSystemPropertyComponent)t));
        }
        for (CodeSystem.CodeSystemContactComponent t : src.getConcept()) {
            tgt.addConcept(VersionConvertor_14_40.convertConceptDefinitionComponent((CodeSystem.ConceptDefinitionComponent)t));
        }
        return tgt;
    }

    private static boolean isJurisdiction(CodeableConcept t) {
        return t.hasCoding() && ("http://unstats.un.org/unsd/methods/m49/m49.htm".equals(((org.hl7.fhir.dstu2016may.model.Coding)t.getCoding().get(0)).getSystem()) || "urn:iso:std:iso:3166".equals(((org.hl7.fhir.dstu2016may.model.Coding)t.getCoding().get(0)).getSystem()) || "https://www.usps.com/".equals(((org.hl7.fhir.dstu2016may.model.Coding)t.getCoding().get(0)).getSystem()));
    }

    public static UsageContext convertCodeableConceptToUsageContext(CodeableConcept t) throws FHIRException {
        UsageContext result = new UsageContext();
        result.setValue((Type)VersionConvertor_14_40.convertCodeableConcept(t));
        return result;
    }

    public static org.hl7.fhir.dstu2016may.model.CodeSystem convertCodeSystem(CodeSystem src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2016may.model.CodeSystem tgt = new org.hl7.fhir.dstu2016may.model.CodeSystem();
        VersionConvertor_14_40.copyDomainResource((org.hl7.fhir.r4.model.DomainResource)src, (DomainResource)tgt);
        if (src.hasUrl()) {
            tgt.setUrl(src.getUrl());
        }
        tgt.setIdentifier(VersionConvertor_14_40.convertIdentifier(src.getIdentifier()));
        if (src.hasVersion()) {
            tgt.setVersion(src.getVersion());
        }
        if (src.hasName()) {
            tgt.setName(src.getName());
        }
        tgt.setStatus(VersionConvertor_14_40.convertConformanceResourceStatus(src.getStatus()));
        if (src.hasExperimental()) {
            tgt.setExperimental(src.getExperimental());
        }
        if (src.hasPublisher()) {
            tgt.setPublisher(src.getPublisher());
        }
        for (ContactDetail t : src.getContact()) {
            tgt.addContact(VersionConvertor_14_40.convertCodeSystemContactComponent(t));
        }
        if (src.hasDate()) {
            tgt.setDate(src.getDate());
        }
        if (src.hasDescription()) {
            tgt.setDescription(src.getDescription());
        }
        for (ContactDetail t : src.getUseContext()) {
            if (!t.hasValueCodeableConcept()) continue;
            tgt.addUseContext(VersionConvertor_14_40.convertCodeableConcept(t.getValueCodeableConcept()));
        }
        for (ContactDetail t : src.getJurisdiction()) {
            tgt.addUseContext(VersionConvertor_14_40.convertCodeableConcept((org.hl7.fhir.r4.model.CodeableConcept)t));
        }
        if (src.hasPurpose()) {
            tgt.setRequirements(src.getPurpose());
        }
        if (src.hasCopyright()) {
            tgt.setCopyright(src.getCopyright());
        }
        if (src.hasCaseSensitive()) {
            tgt.setCaseSensitive(src.getCaseSensitive());
        }
        if (src.hasValueSet()) {
            tgt.setValueSet(src.getValueSet());
        }
        if (src.hasCompositional()) {
            tgt.setCompositional(src.getCompositional());
        }
        if (src.hasVersionNeeded()) {
            tgt.setVersionNeeded(src.getVersionNeeded());
        }
        tgt.setContent(VersionConvertor_14_40.convertCodeSystemContentMode(src.getContent()));
        if (src.hasCount()) {
            tgt.setCount(src.getCount());
        }
        for (ContactDetail t : src.getFilter()) {
            tgt.addFilter(VersionConvertor_14_40.convertCodeSystemFilterComponent((CodeSystem.CodeSystemFilterComponent)t));
        }
        for (ContactDetail t : src.getProperty()) {
            tgt.addProperty(VersionConvertor_14_40.convertPropertyComponent((CodeSystem.PropertyComponent)t));
        }
        for (ContactDetail t : src.getConcept()) {
            tgt.addConcept(VersionConvertor_14_40.convertConceptDefinitionComponent((CodeSystem.ConceptDefinitionComponent)t));
        }
        return tgt;
    }

    private static CodeSystem.CodeSystemContentMode convertCodeSystemContentMode(CodeSystem.CodeSystemContentMode src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case NOTPRESENT: {
                return CodeSystem.CodeSystemContentMode.NOTPRESENT;
            }
            case EXAMPLAR: {
                return CodeSystem.CodeSystemContentMode.EXAMPLE;
            }
            case FRAGMENT: {
                return CodeSystem.CodeSystemContentMode.FRAGMENT;
            }
            case COMPLETE: {
                return CodeSystem.CodeSystemContentMode.COMPLETE;
            }
        }
        return CodeSystem.CodeSystemContentMode.NULL;
    }

    private static CodeSystem.CodeSystemContentMode convertCodeSystemContentMode(CodeSystem.CodeSystemContentMode src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case NOTPRESENT: {
                return CodeSystem.CodeSystemContentMode.NOTPRESENT;
            }
            case EXAMPLE: {
                return CodeSystem.CodeSystemContentMode.EXAMPLAR;
            }
            case FRAGMENT: {
                return CodeSystem.CodeSystemContentMode.FRAGMENT;
            }
            case COMPLETE: {
                return CodeSystem.CodeSystemContentMode.COMPLETE;
            }
        }
        return CodeSystem.CodeSystemContentMode.NULL;
    }

    public static ContactDetail convertCodeSystemContactComponent(CodeSystem.CodeSystemContactComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ContactDetail tgt = new ContactDetail();
        VersionConvertor_14_40.copyElement((org.hl7.fhir.dstu2016may.model.Element)src, (Element)tgt);
        if (src.hasName()) {
            tgt.setName(src.getName());
        }
        for (org.hl7.fhir.dstu2016may.model.ContactPoint t : src.getTelecom()) {
            tgt.addTelecom(VersionConvertor_14_40.convertContactPoint(t));
        }
        return tgt;
    }

    public static CodeSystem.CodeSystemContactComponent convertCodeSystemContactComponent(ContactDetail src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        CodeSystem.CodeSystemContactComponent tgt = new CodeSystem.CodeSystemContactComponent();
        VersionConvertor_14_40.copyElement((Element)src, (org.hl7.fhir.dstu2016may.model.Element)tgt);
        if (src.hasName()) {
            tgt.setName(src.getName());
        }
        for (ContactPoint t : src.getTelecom()) {
            tgt.addTelecom(VersionConvertor_14_40.convertContactPoint(t));
        }
        return tgt;
    }

    public static CodeSystem.CodeSystemFilterComponent convertCodeSystemFilterComponent(CodeSystem.CodeSystemFilterComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        CodeSystem.CodeSystemFilterComponent tgt = new CodeSystem.CodeSystemFilterComponent();
        VersionConvertor_14_40.copyElement((org.hl7.fhir.dstu2016may.model.Element)src, (Element)tgt);
        tgt.setCode(src.getCode());
        if (src.hasDescription()) {
            tgt.setDescription(src.getDescription());
        }
        for (org.hl7.fhir.dstu2016may.model.CodeType t : src.getOperator()) {
            try {
                tgt.addOperator(CodeSystem.FilterOperator.fromCode((String)((String)t.getValue())));
            }
            catch (FHIRException e) {
                throw new FHIRException((Throwable)e);
            }
        }
        tgt.setValue(src.getValue());
        return tgt;
    }

    public static CodeSystem.CodeSystemFilterComponent convertCodeSystemFilterComponent(CodeSystem.CodeSystemFilterComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        CodeSystem.CodeSystemFilterComponent tgt = new CodeSystem.CodeSystemFilterComponent();
        VersionConvertor_14_40.copyElement((Element)src, (org.hl7.fhir.dstu2016may.model.Element)tgt);
        tgt.setCode(src.getCode());
        if (src.hasDescription()) {
            tgt.setDescription(src.getDescription());
        }
        for (Enumeration t : src.getOperator()) {
            tgt.addOperator(((CodeSystem.FilterOperator)t.getValue()).toCode());
        }
        tgt.setValue(src.getValue());
        return tgt;
    }

    public static CodeSystem.PropertyComponent convertPropertyComponent(CodeSystem.CodeSystemPropertyComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        CodeSystem.PropertyComponent tgt = new CodeSystem.PropertyComponent();
        VersionConvertor_14_40.copyElement((org.hl7.fhir.dstu2016may.model.Element)src, (Element)tgt);
        tgt.setCode(src.getCode());
        if (src.hasDescription()) {
            tgt.setDescription(src.getDescription());
        }
        tgt.setType(VersionConvertor_14_40.convertPropertyType(src.getType()));
        return tgt;
    }

    public static CodeSystem.CodeSystemPropertyComponent convertPropertyComponent(CodeSystem.PropertyComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        CodeSystem.CodeSystemPropertyComponent tgt = new CodeSystem.CodeSystemPropertyComponent();
        VersionConvertor_14_40.copyElement((Element)src, (org.hl7.fhir.dstu2016may.model.Element)tgt);
        tgt.setCode(src.getCode());
        if (src.hasDescription()) {
            tgt.setDescription(src.getDescription());
        }
        tgt.setType(VersionConvertor_14_40.convertPropertyType(src.getType()));
        return tgt;
    }

    private static CodeSystem.PropertyType convertPropertyType(CodeSystem.PropertyType src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case CODE: {
                return CodeSystem.PropertyType.CODE;
            }
            case CODING: {
                return CodeSystem.PropertyType.CODING;
            }
            case STRING: {
                return CodeSystem.PropertyType.STRING;
            }
            case INTEGER: {
                return CodeSystem.PropertyType.INTEGER;
            }
            case BOOLEAN: {
                return CodeSystem.PropertyType.BOOLEAN;
            }
            case DATETIME: {
                return CodeSystem.PropertyType.DATETIME;
            }
        }
        return CodeSystem.PropertyType.NULL;
    }

    private static CodeSystem.PropertyType convertPropertyType(CodeSystem.PropertyType src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case CODE: {
                return CodeSystem.PropertyType.CODE;
            }
            case CODING: {
                return CodeSystem.PropertyType.CODING;
            }
            case STRING: {
                return CodeSystem.PropertyType.STRING;
            }
            case INTEGER: {
                return CodeSystem.PropertyType.INTEGER;
            }
            case BOOLEAN: {
                return CodeSystem.PropertyType.BOOLEAN;
            }
            case DATETIME: {
                return CodeSystem.PropertyType.DATETIME;
            }
        }
        return CodeSystem.PropertyType.NULL;
    }

    public static CodeSystem.ConceptDefinitionComponent convertConceptDefinitionComponent(CodeSystem.ConceptDefinitionComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        CodeSystem.ConceptDefinitionComponent tgt = new CodeSystem.ConceptDefinitionComponent();
        VersionConvertor_14_40.copyElement((org.hl7.fhir.dstu2016may.model.Element)src, (Element)tgt);
        tgt.setCode(src.getCode());
        if (src.hasDisplay()) {
            tgt.setDisplay(src.getDisplay());
        }
        if (src.hasDefinition()) {
            tgt.setDefinition(src.getDefinition());
        }
        for (CodeSystem.ConceptDefinitionDesignationComponent t : src.getDesignation()) {
            tgt.addDesignation(VersionConvertor_14_40.convertConceptDefinitionDesignationComponent(t));
        }
        for (CodeSystem.ConceptDefinitionDesignationComponent t : src.getProperty()) {
            tgt.addProperty(VersionConvertor_14_40.convertConceptPropertyComponent((CodeSystem.ConceptDefinitionPropertyComponent)t));
        }
        for (CodeSystem.ConceptDefinitionDesignationComponent t : src.getConcept()) {
            tgt.addConcept(VersionConvertor_14_40.convertConceptDefinitionComponent((CodeSystem.ConceptDefinitionComponent)t));
        }
        return tgt;
    }

    public static CodeSystem.ConceptDefinitionComponent convertConceptDefinitionComponent(CodeSystem.ConceptDefinitionComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        CodeSystem.ConceptDefinitionComponent tgt = new CodeSystem.ConceptDefinitionComponent();
        VersionConvertor_14_40.copyElement((Element)src, (org.hl7.fhir.dstu2016may.model.Element)tgt);
        tgt.setCode(src.getCode());
        if (src.hasDisplay()) {
            tgt.setDisplay(src.getDisplay());
        }
        if (src.hasDefinition()) {
            tgt.setDefinition(src.getDefinition());
        }
        for (CodeSystem.ConceptDefinitionDesignationComponent t : src.getDesignation()) {
            tgt.addDesignation(VersionConvertor_14_40.convertConceptDefinitionDesignationComponent(t));
        }
        for (CodeSystem.ConceptDefinitionDesignationComponent t : src.getProperty()) {
            tgt.addProperty(VersionConvertor_14_40.convertConceptPropertyComponent((CodeSystem.ConceptPropertyComponent)t));
        }
        for (CodeSystem.ConceptDefinitionDesignationComponent t : src.getConcept()) {
            tgt.addConcept(VersionConvertor_14_40.convertConceptDefinitionComponent((CodeSystem.ConceptDefinitionComponent)t));
        }
        return tgt;
    }

    public static CodeSystem.ConceptDefinitionDesignationComponent convertConceptDefinitionDesignationComponent(CodeSystem.ConceptDefinitionDesignationComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        CodeSystem.ConceptDefinitionDesignationComponent tgt = new CodeSystem.ConceptDefinitionDesignationComponent();
        VersionConvertor_14_40.copyElement((org.hl7.fhir.dstu2016may.model.Element)src, (Element)tgt);
        if (src.hasLanguage()) {
            tgt.setLanguage(src.getLanguage());
        }
        tgt.setUse(VersionConvertor_14_40.convertCoding(src.getUse()));
        tgt.setValue(src.getValue());
        return tgt;
    }

    public static CodeSystem.ConceptDefinitionDesignationComponent convertConceptDefinitionDesignationComponent(CodeSystem.ConceptDefinitionDesignationComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        CodeSystem.ConceptDefinitionDesignationComponent tgt = new CodeSystem.ConceptDefinitionDesignationComponent();
        VersionConvertor_14_40.copyElement((Element)src, (org.hl7.fhir.dstu2016may.model.Element)tgt);
        if (src.hasLanguage()) {
            tgt.setLanguage(src.getLanguage());
        }
        tgt.setUse(VersionConvertor_14_40.convertCoding(src.getUse()));
        tgt.setValue(src.getValue());
        return tgt;
    }

    public static CodeSystem.ConceptPropertyComponent convertConceptPropertyComponent(CodeSystem.ConceptDefinitionPropertyComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        CodeSystem.ConceptPropertyComponent tgt = new CodeSystem.ConceptPropertyComponent();
        VersionConvertor_14_40.copyElement((org.hl7.fhir.dstu2016may.model.Element)src, (Element)tgt);
        tgt.setCode(src.getCode());
        tgt.setValue(VersionConvertor_14_40.convertType(src.getValue()));
        return tgt;
    }

    public static CodeSystem.ConceptDefinitionPropertyComponent convertConceptPropertyComponent(CodeSystem.ConceptPropertyComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        CodeSystem.ConceptDefinitionPropertyComponent tgt = new CodeSystem.ConceptDefinitionPropertyComponent();
        VersionConvertor_14_40.copyElement((Element)src, (org.hl7.fhir.dstu2016may.model.Element)tgt);
        tgt.setCode(src.getCode());
        tgt.setValue(VersionConvertor_14_40.convertType(src.getValue()));
        return tgt;
    }

    public static CompartmentDefinition convertCompartmentDefinition(org.hl7.fhir.dstu2016may.model.CompartmentDefinition src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        CompartmentDefinition tgt = new CompartmentDefinition();
        VersionConvertor_14_40.copyDomainResource((DomainResource)src, (org.hl7.fhir.r4.model.DomainResource)tgt);
        tgt.setUrl(src.getUrl());
        tgt.setName(src.getName());
        tgt.setStatus(VersionConvertor_14_40.convertConformanceResourceStatus(src.getStatus()));
        if (src.hasExperimental()) {
            tgt.setExperimental(src.getExperimental());
        }
        if (src.hasPublisher()) {
            tgt.setPublisher(src.getPublisher());
        }
        for (CompartmentDefinition.CompartmentDefinitionContactComponent t : src.getContact()) {
            tgt.addContact(VersionConvertor_14_40.convertCompartmentDefinitionContactComponent(t));
        }
        if (src.hasDate()) {
            tgt.setDate(src.getDate());
        }
        if (src.hasDescription()) {
            tgt.setDescription(src.getDescription());
        }
        if (src.hasRequirements()) {
            tgt.setPurpose(src.getRequirements());
        }
        tgt.setCode(VersionConvertor_14_40.convertCompartmentType(src.getCode()));
        tgt.setSearch(src.getSearch());
        for (CompartmentDefinition.CompartmentDefinitionContactComponent t : src.getResource()) {
            tgt.addResource(VersionConvertor_14_40.convertCompartmentDefinitionResourceComponent((CompartmentDefinition.CompartmentDefinitionResourceComponent)t));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2016may.model.CompartmentDefinition convertCompartmentDefinition(CompartmentDefinition src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2016may.model.CompartmentDefinition tgt = new org.hl7.fhir.dstu2016may.model.CompartmentDefinition();
        VersionConvertor_14_40.copyDomainResource((org.hl7.fhir.r4.model.DomainResource)src, (DomainResource)tgt);
        tgt.setUrl(src.getUrl());
        tgt.setName(src.getName());
        tgt.setStatus(VersionConvertor_14_40.convertConformanceResourceStatus(src.getStatus()));
        if (src.hasExperimental()) {
            tgt.setExperimental(src.getExperimental());
        }
        if (src.hasPublisher()) {
            tgt.setPublisher(src.getPublisher());
        }
        for (ContactDetail t : src.getContact()) {
            tgt.addContact(VersionConvertor_14_40.convertCompartmentDefinitionContactComponent(t));
        }
        if (src.hasDate()) {
            tgt.setDate(src.getDate());
        }
        if (src.hasDescription()) {
            tgt.setDescription(src.getDescription());
        }
        if (src.hasPurpose()) {
            tgt.setRequirements(src.getPurpose());
        }
        tgt.setCode(VersionConvertor_14_40.convertCompartmentType(src.getCode()));
        tgt.setSearch(src.getSearch());
        for (ContactDetail t : src.getResource()) {
            tgt.addResource(VersionConvertor_14_40.convertCompartmentDefinitionResourceComponent((CompartmentDefinition.CompartmentDefinitionResourceComponent)t));
        }
        return tgt;
    }

    private static CompartmentDefinition.CompartmentType convertCompartmentType(CompartmentDefinition.CompartmentType src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case PATIENT: {
                return CompartmentDefinition.CompartmentType.PATIENT;
            }
            case ENCOUNTER: {
                return CompartmentDefinition.CompartmentType.ENCOUNTER;
            }
            case RELATEDPERSON: {
                return CompartmentDefinition.CompartmentType.RELATEDPERSON;
            }
            case PRACTITIONER: {
                return CompartmentDefinition.CompartmentType.PRACTITIONER;
            }
            case DEVICE: {
                return CompartmentDefinition.CompartmentType.DEVICE;
            }
        }
        return CompartmentDefinition.CompartmentType.NULL;
    }

    private static CompartmentDefinition.CompartmentType convertCompartmentType(CompartmentDefinition.CompartmentType src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case PATIENT: {
                return CompartmentDefinition.CompartmentType.PATIENT;
            }
            case ENCOUNTER: {
                return CompartmentDefinition.CompartmentType.ENCOUNTER;
            }
            case RELATEDPERSON: {
                return CompartmentDefinition.CompartmentType.RELATEDPERSON;
            }
            case PRACTITIONER: {
                return CompartmentDefinition.CompartmentType.PRACTITIONER;
            }
            case DEVICE: {
                return CompartmentDefinition.CompartmentType.DEVICE;
            }
        }
        return CompartmentDefinition.CompartmentType.NULL;
    }

    public static ContactDetail convertCompartmentDefinitionContactComponent(CompartmentDefinition.CompartmentDefinitionContactComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ContactDetail tgt = new ContactDetail();
        VersionConvertor_14_40.copyElement((org.hl7.fhir.dstu2016may.model.Element)src, (Element)tgt);
        if (src.hasName()) {
            tgt.setName(src.getName());
        }
        for (org.hl7.fhir.dstu2016may.model.ContactPoint t : src.getTelecom()) {
            tgt.addTelecom(VersionConvertor_14_40.convertContactPoint(t));
        }
        return tgt;
    }

    public static CompartmentDefinition.CompartmentDefinitionContactComponent convertCompartmentDefinitionContactComponent(ContactDetail src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        CompartmentDefinition.CompartmentDefinitionContactComponent tgt = new CompartmentDefinition.CompartmentDefinitionContactComponent();
        VersionConvertor_14_40.copyElement((Element)src, (org.hl7.fhir.dstu2016may.model.Element)tgt);
        if (src.hasName()) {
            tgt.setName(src.getName());
        }
        for (ContactPoint t : src.getTelecom()) {
            tgt.addTelecom(VersionConvertor_14_40.convertContactPoint(t));
        }
        return tgt;
    }

    public static CompartmentDefinition.CompartmentDefinitionResourceComponent convertCompartmentDefinitionResourceComponent(CompartmentDefinition.CompartmentDefinitionResourceComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        CompartmentDefinition.CompartmentDefinitionResourceComponent tgt = new CompartmentDefinition.CompartmentDefinitionResourceComponent();
        VersionConvertor_14_40.copyElement((org.hl7.fhir.dstu2016may.model.Element)src, (Element)tgt);
        tgt.setCode(src.getCode());
        for (org.hl7.fhir.dstu2016may.model.StringType t : src.getParam()) {
            tgt.addParam((String)t.getValue());
        }
        if (src.hasDocumentation()) {
            tgt.setDocumentation(src.getDocumentation());
        }
        return tgt;
    }

    public static CompartmentDefinition.CompartmentDefinitionResourceComponent convertCompartmentDefinitionResourceComponent(CompartmentDefinition.CompartmentDefinitionResourceComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        CompartmentDefinition.CompartmentDefinitionResourceComponent tgt = new CompartmentDefinition.CompartmentDefinitionResourceComponent();
        VersionConvertor_14_40.copyElement((Element)src, (org.hl7.fhir.dstu2016may.model.Element)tgt);
        tgt.setCode(src.getCode());
        for (StringType t : src.getParam()) {
            tgt.addParam((String)t.getValue());
        }
        if (src.hasDocumentation()) {
            tgt.setDocumentation(src.getDocumentation());
        }
        return tgt;
    }

    public static ConceptMap convertConceptMap(org.hl7.fhir.dstu2016may.model.ConceptMap src) throws FHIRException {
        Type tt;
        if (src == null || src.isEmpty()) {
            return null;
        }
        ConceptMap tgt = new ConceptMap();
        VersionConvertor_14_40.copyDomainResource((DomainResource)src, (org.hl7.fhir.r4.model.DomainResource)tgt);
        if (src.hasUrl()) {
            tgt.setUrl(src.getUrl());
        }
        tgt.setIdentifier(VersionConvertor_14_40.convertIdentifier(src.getIdentifier()));
        if (src.hasVersion()) {
            tgt.setVersion(src.getVersion());
        }
        if (src.hasName()) {
            tgt.setName(src.getName());
        }
        tgt.setStatus(VersionConvertor_14_40.convertConformanceResourceStatus(src.getStatus()));
        if (src.hasExperimental()) {
            tgt.setExperimental(src.getExperimental());
        }
        if (src.hasPublisher()) {
            tgt.setPublisher(src.getPublisher());
        }
        for (ConceptMap.ConceptMapContactComponent t : src.getContact()) {
            tgt.addContact(VersionConvertor_14_40.convertConceptMapContactComponent(t));
        }
        if (src.hasDate()) {
            tgt.setDate(src.getDate());
        }
        if (src.hasDescription()) {
            tgt.setDescription(src.getDescription());
        }
        for (ConceptMap.ConceptMapContactComponent t : src.getUseContext()) {
            if (VersionConvertor_14_40.isJurisdiction((CodeableConcept)t)) {
                tgt.addJurisdiction(VersionConvertor_14_40.convertCodeableConcept((CodeableConcept)t));
                continue;
            }
            tgt.addUseContext(VersionConvertor_14_40.convertCodeableConceptToUsageContext((CodeableConcept)t));
        }
        if (src.hasRequirements()) {
            tgt.setPurpose(src.getRequirements());
        }
        if (src.hasCopyright()) {
            tgt.setCopyright(src.getCopyright());
        }
        tgt.setSource((Type)((tt = VersionConvertor_14_40.convertType(src.getSource())) instanceof Reference ? new CanonicalType(((Reference)tt).getReference()) : tt));
        tt = VersionConvertor_14_40.convertType(src.getTarget());
        tgt.setTarget((Type)(tt instanceof Reference ? new CanonicalType(((Reference)tt).getReference()) : tt));
        for (ConceptMap.SourceElementComponent t : src.getElement()) {
            List<SourceElementComponentWrapper> ws = VersionConvertor_14_40.convertSourceElementComponent(t);
            for (SourceElementComponentWrapper w : ws) {
                VersionConvertor_14_40.getGroup(tgt, w.source, w.target).addElement(w.comp);
            }
        }
        return tgt;
    }

    private static ConceptMap.ConceptMapGroupComponent getGroup(ConceptMap map, String srcs, String tgts) {
        for (ConceptMap.ConceptMapGroupComponent grp : map.getGroup()) {
            if (!grp.getSource().equals(srcs) || !grp.getTarget().equals(tgts)) continue;
            return grp;
        }
        ConceptMap.ConceptMapGroupComponent grp = map.addGroup();
        grp.setSource(srcs);
        grp.setTarget(tgts);
        return grp;
    }

    public static org.hl7.fhir.dstu2016may.model.ConceptMap convertConceptMap(ConceptMap src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2016may.model.ConceptMap tgt = new org.hl7.fhir.dstu2016may.model.ConceptMap();
        VersionConvertor_14_40.copyDomainResource((org.hl7.fhir.r4.model.DomainResource)src, (DomainResource)tgt);
        if (src.hasUrl()) {
            tgt.setUrl(src.getUrl());
        }
        tgt.setIdentifier(VersionConvertor_14_40.convertIdentifier(src.getIdentifier()));
        if (src.hasVersion()) {
            tgt.setVersion(src.getVersion());
        }
        if (src.hasName()) {
            tgt.setName(src.getName());
        }
        tgt.setStatus(VersionConvertor_14_40.convertConformanceResourceStatus(src.getStatus()));
        if (src.hasExperimental()) {
            tgt.setExperimental(src.getExperimental());
        }
        if (src.hasPublisher()) {
            tgt.setPublisher(src.getPublisher());
        }
        for (ContactDetail t : src.getContact()) {
            tgt.addContact(VersionConvertor_14_40.convertConceptMapContactComponent(t));
        }
        if (src.hasDate()) {
            tgt.setDate(src.getDate());
        }
        if (src.hasDescription()) {
            tgt.setDescription(src.getDescription());
        }
        for (ContactDetail t : src.getUseContext()) {
            if (!t.hasValueCodeableConcept()) continue;
            tgt.addUseContext(VersionConvertor_14_40.convertCodeableConcept(t.getValueCodeableConcept()));
        }
        for (ContactDetail t : src.getJurisdiction()) {
            tgt.addUseContext(VersionConvertor_14_40.convertCodeableConcept((org.hl7.fhir.r4.model.CodeableConcept)t));
        }
        if (src.hasPurpose()) {
            tgt.setRequirements(src.getPurpose());
        }
        if (src.hasCopyright()) {
            tgt.setCopyright(src.getCopyright());
        }
        if (src.getSource() instanceof CanonicalType) {
            tgt.setSource((org.hl7.fhir.dstu2016may.model.Type)VersionConvertor_14_40.convertCanonicalToReference((CanonicalType)src.getSource()));
        } else {
            tgt.setSource(VersionConvertor_14_40.convertType(src.getSource()));
        }
        if (src.getTarget() instanceof CanonicalType) {
            tgt.setTarget((org.hl7.fhir.dstu2016may.model.Type)VersionConvertor_14_40.convertCanonicalToReference((CanonicalType)src.getTarget()));
        } else {
            tgt.setTarget(VersionConvertor_14_40.convertType(src.getTarget()));
        }
        tgt.setSource(VersionConvertor_14_40.convertType(src.getSource()));
        tgt.setTarget(VersionConvertor_14_40.convertType(src.getTarget()));
        for (ConceptMap.ConceptMapGroupComponent g : src.getGroup()) {
            for (ConceptMap.SourceElementComponent t : g.getElement()) {
                tgt.addElement(VersionConvertor_14_40.convertSourceElementComponent(t, g));
            }
        }
        return tgt;
    }

    public static ContactDetail convertConceptMapContactComponent(ConceptMap.ConceptMapContactComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ContactDetail tgt = new ContactDetail();
        VersionConvertor_14_40.copyElement((org.hl7.fhir.dstu2016may.model.Element)src, (Element)tgt);
        if (src.hasName()) {
            tgt.setName(src.getName());
        }
        for (org.hl7.fhir.dstu2016may.model.ContactPoint t : src.getTelecom()) {
            tgt.addTelecom(VersionConvertor_14_40.convertContactPoint(t));
        }
        return tgt;
    }

    public static ConceptMap.ConceptMapContactComponent convertConceptMapContactComponent(ContactDetail src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ConceptMap.ConceptMapContactComponent tgt = new ConceptMap.ConceptMapContactComponent();
        VersionConvertor_14_40.copyElement((Element)src, (org.hl7.fhir.dstu2016may.model.Element)tgt);
        if (src.hasName()) {
            tgt.setName(src.getName());
        }
        for (ContactPoint t : src.getTelecom()) {
            tgt.addTelecom(VersionConvertor_14_40.convertContactPoint(t));
        }
        return tgt;
    }

    public static List<SourceElementComponentWrapper> convertSourceElementComponent(ConceptMap.SourceElementComponent src) throws FHIRException {
        ArrayList<SourceElementComponentWrapper> res = new ArrayList<SourceElementComponentWrapper>();
        if (src == null || src.isEmpty()) {
            return res;
        }
        for (ConceptMap.TargetElementComponent t : src.getTarget()) {
            ConceptMap.SourceElementComponent tgt = new ConceptMap.SourceElementComponent();
            VersionConvertor_14_40.copyElement((org.hl7.fhir.dstu2016may.model.Element)src, (Element)tgt);
            if (src.hasCode()) {
                tgt.setCode(src.getCode());
            }
            tgt.addTarget(VersionConvertor_14_40.convertTargetElementComponent(t));
            res.add(new SourceElementComponentWrapper(tgt, src.getSystem(), t.getSystem()));
        }
        return res;
    }

    public static ConceptMap.SourceElementComponent convertSourceElementComponent(ConceptMap.SourceElementComponent src, ConceptMap.ConceptMapGroupComponent g) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ConceptMap.SourceElementComponent tgt = new ConceptMap.SourceElementComponent();
        VersionConvertor_14_40.copyElement((Element)src, (org.hl7.fhir.dstu2016may.model.Element)tgt);
        if (g.hasSource()) {
            tgt.setSystem(g.getSource());
        }
        if (src.hasCode()) {
            tgt.setCode(src.getCode());
        }
        for (ConceptMap.TargetElementComponent t : src.getTarget()) {
            tgt.addTarget(VersionConvertor_14_40.convertTargetElementComponent(t, g));
        }
        return tgt;
    }

    public static ConceptMap.TargetElementComponent convertTargetElementComponent(ConceptMap.TargetElementComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ConceptMap.TargetElementComponent tgt = new ConceptMap.TargetElementComponent();
        VersionConvertor_14_40.copyElement((org.hl7.fhir.dstu2016may.model.Element)src, (Element)tgt);
        if (src.hasCode()) {
            tgt.setCode(src.getCode());
        }
        tgt.setEquivalence(VersionConvertor_14_40.convertConceptMapEquivalence(src.getEquivalence()));
        if (src.hasComments()) {
            tgt.setComment(src.getComments());
        }
        for (ConceptMap.OtherElementComponent t : src.getDependsOn()) {
            tgt.addDependsOn(VersionConvertor_14_40.convertOtherElementComponent(t));
        }
        for (ConceptMap.OtherElementComponent t : src.getProduct()) {
            tgt.addProduct(VersionConvertor_14_40.convertOtherElementComponent(t));
        }
        return tgt;
    }

    public static ConceptMap.TargetElementComponent convertTargetElementComponent(ConceptMap.TargetElementComponent src, ConceptMap.ConceptMapGroupComponent g) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ConceptMap.TargetElementComponent tgt = new ConceptMap.TargetElementComponent();
        VersionConvertor_14_40.copyElement((Element)src, (org.hl7.fhir.dstu2016may.model.Element)tgt);
        if (g.hasTarget()) {
            tgt.setSystem(g.getTarget());
        }
        if (src.hasCode()) {
            tgt.setCode(src.getCode());
        }
        tgt.setEquivalence(VersionConvertor_14_40.convertConceptMapEquivalence(src.getEquivalence()));
        if (src.hasComment()) {
            tgt.setComments(src.getComment());
        }
        for (ConceptMap.OtherElementComponent t : src.getDependsOn()) {
            tgt.addDependsOn(VersionConvertor_14_40.convertOtherElementComponent(t));
        }
        for (ConceptMap.OtherElementComponent t : src.getProduct()) {
            tgt.addProduct(VersionConvertor_14_40.convertOtherElementComponent(t));
        }
        return tgt;
    }

    public static Enumerations.ConceptMapEquivalence convertConceptMapEquivalence(Enumerations.ConceptMapEquivalence src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case EQUIVALENT: {
                return Enumerations.ConceptMapEquivalence.EQUIVALENT;
            }
            case EQUAL: {
                return Enumerations.ConceptMapEquivalence.EQUAL;
            }
            case WIDER: {
                return Enumerations.ConceptMapEquivalence.WIDER;
            }
            case SUBSUMES: {
                return Enumerations.ConceptMapEquivalence.SUBSUMES;
            }
            case NARROWER: {
                return Enumerations.ConceptMapEquivalence.NARROWER;
            }
            case SPECIALIZES: {
                return Enumerations.ConceptMapEquivalence.SPECIALIZES;
            }
            case INEXACT: {
                return Enumerations.ConceptMapEquivalence.INEXACT;
            }
            case UNMATCHED: {
                return Enumerations.ConceptMapEquivalence.UNMATCHED;
            }
            case DISJOINT: {
                return Enumerations.ConceptMapEquivalence.DISJOINT;
            }
        }
        return Enumerations.ConceptMapEquivalence.NULL;
    }

    public static Enumerations.ConceptMapEquivalence convertConceptMapEquivalence(Enumerations.ConceptMapEquivalence src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case EQUIVALENT: {
                return Enumerations.ConceptMapEquivalence.EQUIVALENT;
            }
            case EQUAL: {
                return Enumerations.ConceptMapEquivalence.EQUAL;
            }
            case WIDER: {
                return Enumerations.ConceptMapEquivalence.WIDER;
            }
            case SUBSUMES: {
                return Enumerations.ConceptMapEquivalence.SUBSUMES;
            }
            case NARROWER: {
                return Enumerations.ConceptMapEquivalence.NARROWER;
            }
            case SPECIALIZES: {
                return Enumerations.ConceptMapEquivalence.SPECIALIZES;
            }
            case INEXACT: {
                return Enumerations.ConceptMapEquivalence.INEXACT;
            }
            case UNMATCHED: {
                return Enumerations.ConceptMapEquivalence.UNMATCHED;
            }
            case DISJOINT: {
                return Enumerations.ConceptMapEquivalence.DISJOINT;
            }
        }
        return Enumerations.ConceptMapEquivalence.NULL;
    }

    public static ConceptMap.OtherElementComponent convertOtherElementComponent(ConceptMap.OtherElementComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ConceptMap.OtherElementComponent tgt = new ConceptMap.OtherElementComponent();
        VersionConvertor_14_40.copyElement((org.hl7.fhir.dstu2016may.model.Element)src, (Element)tgt);
        tgt.setProperty(src.getElement());
        tgt.setSystem(src.getSystem());
        tgt.setValue(src.getCode());
        return tgt;
    }

    public static ConceptMap.OtherElementComponent convertOtherElementComponent(ConceptMap.OtherElementComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ConceptMap.OtherElementComponent tgt = new ConceptMap.OtherElementComponent();
        VersionConvertor_14_40.copyElement((Element)src, (org.hl7.fhir.dstu2016may.model.Element)tgt);
        tgt.setElement(src.getProperty());
        tgt.setSystem(src.getSystem());
        tgt.setCode(src.getValue());
        return tgt;
    }

    public static CapabilityStatement convertConformance(Conformance src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        CapabilityStatement tgt = new CapabilityStatement();
        VersionConvertor_14_40.copyDomainResource((DomainResource)src, (org.hl7.fhir.r4.model.DomainResource)tgt);
        if (src.hasUrl()) {
            tgt.setUrl(src.getUrl());
        }
        if (src.hasVersion()) {
            tgt.setVersion(src.getVersion());
        }
        if (src.hasName()) {
            tgt.setName(src.getName());
        }
        tgt.setStatus(VersionConvertor_14_40.convertConformanceResourceStatus(src.getStatus()));
        if (src.hasExperimental()) {
            tgt.setExperimental(src.getExperimental());
        }
        if (src.hasDate()) {
            tgt.setDate(src.getDate());
        }
        if (src.hasPublisher()) {
            tgt.setPublisher(src.getPublisher());
        }
        for (Conformance.ConformanceContactComponent t : src.getContact()) {
            tgt.addContact(VersionConvertor_14_40.convertConformanceContactComponent(t));
        }
        if (src.hasDescription()) {
            tgt.setDescription(src.getDescription());
        }
        for (Conformance.ConformanceContactComponent t : src.getUseContext()) {
            if (VersionConvertor_14_40.isJurisdiction((CodeableConcept)t)) {
                tgt.addJurisdiction(VersionConvertor_14_40.convertCodeableConcept((CodeableConcept)t));
                continue;
            }
            tgt.addUseContext(VersionConvertor_14_40.convertCodeableConceptToUsageContext((CodeableConcept)t));
        }
        if (src.hasRequirements()) {
            tgt.setPurpose(src.getRequirements());
        }
        if (src.hasCopyright()) {
            tgt.setCopyright(src.getCopyright());
        }
        tgt.setKind(VersionConvertor_14_40.convertConformanceStatementKind(src.getKind()));
        tgt.setSoftware(VersionConvertor_14_40.convertConformanceSoftwareComponent(src.getSoftware()));
        tgt.setImplementation(VersionConvertor_14_40.convertConformanceImplementationComponent(src.getImplementation()));
        tgt.setFhirVersion(src.getFhirVersion());
        for (Conformance.ConformanceContactComponent t : src.getFormat()) {
            tgt.addFormat((String)t.getValue());
        }
        for (Conformance.ConformanceContactComponent t : src.getRest()) {
            tgt.addRest(VersionConvertor_14_40.convertConformanceRestComponent((Conformance.ConformanceRestComponent)t));
        }
        for (Conformance.ConformanceContactComponent t : src.getMessaging()) {
            tgt.addMessaging(VersionConvertor_14_40.convertConformanceMessagingComponent((Conformance.ConformanceMessagingComponent)t));
        }
        for (Conformance.ConformanceContactComponent t : src.getDocument()) {
            tgt.addDocument(VersionConvertor_14_40.convertConformanceDocumentComponent((Conformance.ConformanceDocumentComponent)t));
        }
        return tgt;
    }

    private static CanonicalType convertReferenceToCanonical(org.hl7.fhir.dstu2016may.model.Reference src) throws FHIRException {
        CanonicalType dst = new CanonicalType(src.getReference());
        VersionConvertor_14_40.copyElement((org.hl7.fhir.dstu2016may.model.Element)src, (Element)dst);
        return dst;
    }

    private static org.hl7.fhir.dstu2016may.model.Reference convertCanonicalToReference(CanonicalType src) throws FHIRException {
        org.hl7.fhir.dstu2016may.model.Reference dst = new org.hl7.fhir.dstu2016may.model.Reference((String)src.getValue());
        VersionConvertor_14_40.copyElement((Element)src, (org.hl7.fhir.dstu2016may.model.Element)dst);
        return dst;
    }

    public static Conformance convertConformance(CapabilityStatement src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Conformance tgt = new Conformance();
        VersionConvertor_14_40.copyDomainResource((org.hl7.fhir.r4.model.DomainResource)src, (DomainResource)tgt);
        if (src.hasUrl()) {
            tgt.setUrl(src.getUrl());
        }
        if (src.hasVersion()) {
            tgt.setVersion(src.getVersion());
        }
        if (src.hasName()) {
            tgt.setName(src.getName());
        }
        tgt.setStatus(VersionConvertor_14_40.convertConformanceResourceStatus(src.getStatus()));
        if (src.hasExperimental()) {
            tgt.setExperimental(src.getExperimental());
        }
        if (src.hasDate()) {
            tgt.setDate(src.getDate());
        }
        if (src.hasPublisher()) {
            tgt.setPublisher(src.getPublisher());
        }
        for (ContactDetail t : src.getContact()) {
            tgt.addContact(VersionConvertor_14_40.convertConformanceContactComponent(t));
        }
        if (src.hasDescription()) {
            tgt.setDescription(src.getDescription());
        }
        for (ContactDetail t : src.getUseContext()) {
            if (!t.hasValueCodeableConcept()) continue;
            tgt.addUseContext(VersionConvertor_14_40.convertCodeableConcept(t.getValueCodeableConcept()));
        }
        for (ContactDetail t : src.getJurisdiction()) {
            tgt.addUseContext(VersionConvertor_14_40.convertCodeableConcept((org.hl7.fhir.r4.model.CodeableConcept)t));
        }
        if (src.hasPurpose()) {
            tgt.setRequirements(src.getPurpose());
        }
        if (src.hasCopyright()) {
            tgt.setCopyright(src.getCopyright());
        }
        tgt.setKind(VersionConvertor_14_40.convertConformanceStatementKind(src.getKind()));
        tgt.setSoftware(VersionConvertor_14_40.convertConformanceSoftwareComponent(src.getSoftware()));
        tgt.setImplementation(VersionConvertor_14_40.convertConformanceImplementationComponent(src.getImplementation()));
        tgt.setFhirVersion(src.getFhirVersion());
        for (ContactDetail t : src.getFormat()) {
            tgt.addFormat((String)t.getValue());
        }
        for (CapabilityStatement.CapabilityStatementRestComponent r : src.getRest()) {
            for (CapabilityStatement.CapabilityStatementRestResourceComponent rr : r.getResource()) {
                for (CanonicalType t : rr.getSupportedProfile()) {
                    tgt.addProfile(VersionConvertor_14_40.convertCanonicalToReference(t));
                }
            }
        }
        for (ContactDetail t : src.getRest()) {
            tgt.addRest(VersionConvertor_14_40.convertConformanceRestComponent((CapabilityStatement.CapabilityStatementRestComponent)t));
        }
        for (ContactDetail t : src.getMessaging()) {
            tgt.addMessaging(VersionConvertor_14_40.convertConformanceMessagingComponent((CapabilityStatement.CapabilityStatementMessagingComponent)t));
        }
        for (ContactDetail t : src.getDocument()) {
            tgt.addDocument(VersionConvertor_14_40.convertConformanceDocumentComponent((CapabilityStatement.CapabilityStatementDocumentComponent)t));
        }
        return tgt;
    }

    private static CapabilityStatement.CapabilityStatementKind convertConformanceStatementKind(Conformance.ConformanceStatementKind src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case INSTANCE: {
                return CapabilityStatement.CapabilityStatementKind.INSTANCE;
            }
            case CAPABILITY: {
                return CapabilityStatement.CapabilityStatementKind.CAPABILITY;
            }
            case REQUIREMENTS: {
                return CapabilityStatement.CapabilityStatementKind.REQUIREMENTS;
            }
        }
        return CapabilityStatement.CapabilityStatementKind.NULL;
    }

    private static Conformance.ConformanceStatementKind convertConformanceStatementKind(CapabilityStatement.CapabilityStatementKind src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case INSTANCE: {
                return Conformance.ConformanceStatementKind.INSTANCE;
            }
            case CAPABILITY: {
                return Conformance.ConformanceStatementKind.CAPABILITY;
            }
            case REQUIREMENTS: {
                return Conformance.ConformanceStatementKind.REQUIREMENTS;
            }
        }
        return Conformance.ConformanceStatementKind.NULL;
    }

    public static ContactDetail convertConformanceContactComponent(Conformance.ConformanceContactComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ContactDetail tgt = new ContactDetail();
        VersionConvertor_14_40.copyElement((org.hl7.fhir.dstu2016may.model.Element)src, (Element)tgt);
        if (src.hasName()) {
            tgt.setName(src.getName());
        }
        for (org.hl7.fhir.dstu2016may.model.ContactPoint t : src.getTelecom()) {
            tgt.addTelecom(VersionConvertor_14_40.convertContactPoint(t));
        }
        return tgt;
    }

    public static Conformance.ConformanceContactComponent convertConformanceContactComponent(ContactDetail src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Conformance.ConformanceContactComponent tgt = new Conformance.ConformanceContactComponent();
        VersionConvertor_14_40.copyElement((Element)src, (org.hl7.fhir.dstu2016may.model.Element)tgt);
        if (src.hasName()) {
            tgt.setName(src.getName());
        }
        for (ContactPoint t : src.getTelecom()) {
            tgt.addTelecom(VersionConvertor_14_40.convertContactPoint(t));
        }
        return tgt;
    }

    public static CapabilityStatement.CapabilityStatementSoftwareComponent convertConformanceSoftwareComponent(Conformance.ConformanceSoftwareComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        CapabilityStatement.CapabilityStatementSoftwareComponent tgt = new CapabilityStatement.CapabilityStatementSoftwareComponent();
        VersionConvertor_14_40.copyElement((org.hl7.fhir.dstu2016may.model.Element)src, (Element)tgt);
        tgt.setName(src.getName());
        if (src.hasVersion()) {
            tgt.setVersion(src.getVersion());
        }
        if (src.hasReleaseDate()) {
            tgt.setReleaseDate(src.getReleaseDate());
        }
        return tgt;
    }

    public static Conformance.ConformanceSoftwareComponent convertConformanceSoftwareComponent(CapabilityStatement.CapabilityStatementSoftwareComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Conformance.ConformanceSoftwareComponent tgt = new Conformance.ConformanceSoftwareComponent();
        VersionConvertor_14_40.copyElement((Element)src, (org.hl7.fhir.dstu2016may.model.Element)tgt);
        tgt.setName(src.getName());
        if (src.hasVersion()) {
            tgt.setVersion(src.getVersion());
        }
        if (src.hasReleaseDate()) {
            tgt.setReleaseDate(src.getReleaseDate());
        }
        return tgt;
    }

    public static CapabilityStatement.CapabilityStatementImplementationComponent convertConformanceImplementationComponent(Conformance.ConformanceImplementationComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        CapabilityStatement.CapabilityStatementImplementationComponent tgt = new CapabilityStatement.CapabilityStatementImplementationComponent();
        VersionConvertor_14_40.copyElement((org.hl7.fhir.dstu2016may.model.Element)src, (Element)tgt);
        tgt.setDescription(src.getDescription());
        if (src.hasUrl()) {
            tgt.setUrl(src.getUrl());
        }
        return tgt;
    }

    public static Conformance.ConformanceImplementationComponent convertConformanceImplementationComponent(CapabilityStatement.CapabilityStatementImplementationComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Conformance.ConformanceImplementationComponent tgt = new Conformance.ConformanceImplementationComponent();
        VersionConvertor_14_40.copyElement((Element)src, (org.hl7.fhir.dstu2016may.model.Element)tgt);
        tgt.setDescription(src.getDescription());
        if (src.hasUrl()) {
            tgt.setUrl(src.getUrl());
        }
        return tgt;
    }

    public static CapabilityStatement.CapabilityStatementRestComponent convertConformanceRestComponent(Conformance.ConformanceRestComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        CapabilityStatement.CapabilityStatementRestComponent tgt = new CapabilityStatement.CapabilityStatementRestComponent();
        VersionConvertor_14_40.copyElement((org.hl7.fhir.dstu2016may.model.Element)src, (Element)tgt);
        tgt.setMode(VersionConvertor_14_40.convertRestfulConformanceMode(src.getMode()));
        if (src.hasDocumentation()) {
            tgt.setDocumentation(src.getDocumentation());
        }
        tgt.setSecurity(VersionConvertor_14_40.convertConformanceRestSecurityComponent(src.getSecurity()));
        for (Conformance.ConformanceRestResourceComponent t : src.getResource()) {
            tgt.addResource(VersionConvertor_14_40.convertConformanceRestResourceComponent(t));
        }
        for (Conformance.ConformanceRestResourceComponent t : src.getInteraction()) {
            tgt.addInteraction(VersionConvertor_14_40.convertSystemInteractionComponent((Conformance.SystemInteractionComponent)t));
        }
        for (Conformance.ConformanceRestResourceComponent t : src.getSearchParam()) {
            tgt.addSearchParam(VersionConvertor_14_40.convertConformanceRestResourceSearchParamComponent((Conformance.ConformanceRestResourceSearchParamComponent)t));
        }
        for (Conformance.ConformanceRestResourceComponent t : src.getOperation()) {
            tgt.addOperation(VersionConvertor_14_40.convertConformanceRestOperationComponent((Conformance.ConformanceRestOperationComponent)t));
        }
        for (Conformance.ConformanceRestResourceComponent t : src.getCompartment()) {
            tgt.addCompartment((String)t.getValue());
        }
        return tgt;
    }

    public static Conformance.ConformanceRestComponent convertConformanceRestComponent(CapabilityStatement.CapabilityStatementRestComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Conformance.ConformanceRestComponent tgt = new Conformance.ConformanceRestComponent();
        VersionConvertor_14_40.copyElement((Element)src, (org.hl7.fhir.dstu2016may.model.Element)tgt);
        tgt.setMode(VersionConvertor_14_40.convertRestfulConformanceMode(src.getMode()));
        if (src.hasDocumentation()) {
            tgt.setDocumentation(src.getDocumentation());
        }
        tgt.setSecurity(VersionConvertor_14_40.convertConformanceRestSecurityComponent(src.getSecurity()));
        for (CapabilityStatement.CapabilityStatementRestResourceComponent t : src.getResource()) {
            tgt.addResource(VersionConvertor_14_40.convertConformanceRestResourceComponent(t));
        }
        for (CapabilityStatement.CapabilityStatementRestResourceComponent t : src.getInteraction()) {
            tgt.addInteraction(VersionConvertor_14_40.convertSystemInteractionComponent((CapabilityStatement.SystemInteractionComponent)t));
        }
        for (CapabilityStatement.CapabilityStatementRestResourceComponent t : src.getSearchParam()) {
            tgt.addSearchParam(VersionConvertor_14_40.convertConformanceRestResourceSearchParamComponent((CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent)t));
        }
        for (CapabilityStatement.CapabilityStatementRestResourceComponent t : src.getOperation()) {
            tgt.addOperation(VersionConvertor_14_40.convertConformanceRestOperationComponent((CapabilityStatement.CapabilityStatementRestResourceOperationComponent)t));
        }
        for (CapabilityStatement.CapabilityStatementRestResourceComponent t : src.getCompartment()) {
            tgt.addCompartment((String)t.getValue());
        }
        return tgt;
    }

    private static CapabilityStatement.RestfulCapabilityMode convertRestfulConformanceMode(Conformance.RestfulConformanceMode src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case CLIENT: {
                return CapabilityStatement.RestfulCapabilityMode.CLIENT;
            }
            case SERVER: {
                return CapabilityStatement.RestfulCapabilityMode.SERVER;
            }
        }
        return CapabilityStatement.RestfulCapabilityMode.NULL;
    }

    private static Conformance.RestfulConformanceMode convertRestfulConformanceMode(CapabilityStatement.RestfulCapabilityMode src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case CLIENT: {
                return Conformance.RestfulConformanceMode.CLIENT;
            }
            case SERVER: {
                return Conformance.RestfulConformanceMode.SERVER;
            }
        }
        return Conformance.RestfulConformanceMode.NULL;
    }

    public static CapabilityStatement.CapabilityStatementRestSecurityComponent convertConformanceRestSecurityComponent(Conformance.ConformanceRestSecurityComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        CapabilityStatement.CapabilityStatementRestSecurityComponent tgt = new CapabilityStatement.CapabilityStatementRestSecurityComponent();
        VersionConvertor_14_40.copyElement((org.hl7.fhir.dstu2016may.model.Element)src, (Element)tgt);
        if (src.hasCors()) {
            tgt.setCors(src.getCors());
        }
        for (CodeableConcept t : src.getService()) {
            tgt.addService(VersionConvertor_14_40.convertCodeableConcept(t));
        }
        if (src.hasDescription()) {
            tgt.setDescription(src.getDescription());
        }
        return tgt;
    }

    public static Conformance.ConformanceRestSecurityComponent convertConformanceRestSecurityComponent(CapabilityStatement.CapabilityStatementRestSecurityComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Conformance.ConformanceRestSecurityComponent tgt = new Conformance.ConformanceRestSecurityComponent();
        VersionConvertor_14_40.copyElement((Element)src, (org.hl7.fhir.dstu2016may.model.Element)tgt);
        if (src.hasCors()) {
            tgt.setCors(src.getCors());
        }
        for (org.hl7.fhir.r4.model.CodeableConcept t : src.getService()) {
            tgt.addService(VersionConvertor_14_40.convertCodeableConcept(t));
        }
        if (src.hasDescription()) {
            tgt.setDescription(src.getDescription());
        }
        return tgt;
    }

    public static CapabilityStatement.CapabilityStatementRestResourceComponent convertConformanceRestResourceComponent(Conformance.ConformanceRestResourceComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        CapabilityStatement.CapabilityStatementRestResourceComponent tgt = new CapabilityStatement.CapabilityStatementRestResourceComponent();
        VersionConvertor_14_40.copyElement((org.hl7.fhir.dstu2016may.model.Element)src, (Element)tgt);
        tgt.setType(src.getType());
        tgt.setProfileElement(VersionConvertor_14_40.convertReferenceToCanonical(src.getProfile()));
        for (Conformance.ResourceInteractionComponent t : src.getInteraction()) {
            tgt.addInteraction(VersionConvertor_14_40.convertResourceInteractionComponent(t));
        }
        tgt.setVersioning(VersionConvertor_14_40.convertResourceVersionPolicy(src.getVersioning()));
        if (src.hasReadHistory()) {
            tgt.setReadHistory(src.getReadHistory());
        }
        if (src.hasUpdateCreate()) {
            tgt.setUpdateCreate(src.getUpdateCreate());
        }
        if (src.hasConditionalCreate()) {
            tgt.setConditionalCreate(src.getConditionalCreate());
        }
        if (src.hasConditionalUpdate()) {
            tgt.setConditionalUpdate(src.getConditionalUpdate());
        }
        tgt.setConditionalDelete(VersionConvertor_14_40.convertConditionalDeleteStatus(src.getConditionalDelete()));
        for (Conformance.ResourceInteractionComponent t : src.getSearchInclude()) {
            tgt.addSearchInclude((String)t.getValue());
        }
        for (Conformance.ResourceInteractionComponent t : src.getSearchRevInclude()) {
            tgt.addSearchRevInclude((String)t.getValue());
        }
        for (Conformance.ResourceInteractionComponent t : src.getSearchParam()) {
            tgt.addSearchParam(VersionConvertor_14_40.convertConformanceRestResourceSearchParamComponent((Conformance.ConformanceRestResourceSearchParamComponent)t));
        }
        return tgt;
    }

    public static Conformance.ConformanceRestResourceComponent convertConformanceRestResourceComponent(CapabilityStatement.CapabilityStatementRestResourceComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Conformance.ConformanceRestResourceComponent tgt = new Conformance.ConformanceRestResourceComponent();
        VersionConvertor_14_40.copyElement((Element)src, (org.hl7.fhir.dstu2016may.model.Element)tgt);
        tgt.setType(src.getType());
        tgt.setProfile(VersionConvertor_14_40.convertCanonicalToReference(src.getProfileElement()));
        for (CapabilityStatement.ResourceInteractionComponent t : src.getInteraction()) {
            tgt.addInteraction(VersionConvertor_14_40.convertResourceInteractionComponent(t));
        }
        tgt.setVersioning(VersionConvertor_14_40.convertResourceVersionPolicy(src.getVersioning()));
        if (src.hasReadHistory()) {
            tgt.setReadHistory(src.getReadHistory());
        }
        if (src.hasUpdateCreate()) {
            tgt.setUpdateCreate(src.getUpdateCreate());
        }
        if (src.hasConditionalCreate()) {
            tgt.setConditionalCreate(src.getConditionalCreate());
        }
        if (src.hasConditionalUpdate()) {
            tgt.setConditionalUpdate(src.getConditionalUpdate());
        }
        tgt.setConditionalDelete(VersionConvertor_14_40.convertConditionalDeleteStatus(src.getConditionalDelete()));
        for (CapabilityStatement.ResourceInteractionComponent t : src.getSearchInclude()) {
            tgt.addSearchInclude((String)t.getValue());
        }
        for (CapabilityStatement.ResourceInteractionComponent t : src.getSearchRevInclude()) {
            tgt.addSearchRevInclude((String)t.getValue());
        }
        for (CapabilityStatement.ResourceInteractionComponent t : src.getSearchParam()) {
            tgt.addSearchParam(VersionConvertor_14_40.convertConformanceRestResourceSearchParamComponent((CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent)t));
        }
        return tgt;
    }

    private static CapabilityStatement.ResourceVersionPolicy convertResourceVersionPolicy(Conformance.ResourceVersionPolicy src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case NOVERSION: {
                return CapabilityStatement.ResourceVersionPolicy.NOVERSION;
            }
            case VERSIONED: {
                return CapabilityStatement.ResourceVersionPolicy.VERSIONED;
            }
            case VERSIONEDUPDATE: {
                return CapabilityStatement.ResourceVersionPolicy.VERSIONEDUPDATE;
            }
        }
        return CapabilityStatement.ResourceVersionPolicy.NULL;
    }

    private static Conformance.ResourceVersionPolicy convertResourceVersionPolicy(CapabilityStatement.ResourceVersionPolicy src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case NOVERSION: {
                return Conformance.ResourceVersionPolicy.NOVERSION;
            }
            case VERSIONED: {
                return Conformance.ResourceVersionPolicy.VERSIONED;
            }
            case VERSIONEDUPDATE: {
                return Conformance.ResourceVersionPolicy.VERSIONEDUPDATE;
            }
        }
        return Conformance.ResourceVersionPolicy.NULL;
    }

    private static CapabilityStatement.ConditionalDeleteStatus convertConditionalDeleteStatus(Conformance.ConditionalDeleteStatus src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case NOTSUPPORTED: {
                return CapabilityStatement.ConditionalDeleteStatus.NOTSUPPORTED;
            }
            case SINGLE: {
                return CapabilityStatement.ConditionalDeleteStatus.SINGLE;
            }
            case MULTIPLE: {
                return CapabilityStatement.ConditionalDeleteStatus.MULTIPLE;
            }
        }
        return CapabilityStatement.ConditionalDeleteStatus.NULL;
    }

    private static Conformance.ConditionalDeleteStatus convertConditionalDeleteStatus(CapabilityStatement.ConditionalDeleteStatus src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case NOTSUPPORTED: {
                return Conformance.ConditionalDeleteStatus.NOTSUPPORTED;
            }
            case SINGLE: {
                return Conformance.ConditionalDeleteStatus.SINGLE;
            }
            case MULTIPLE: {
                return Conformance.ConditionalDeleteStatus.MULTIPLE;
            }
        }
        return Conformance.ConditionalDeleteStatus.NULL;
    }

    public static CapabilityStatement.ResourceInteractionComponent convertResourceInteractionComponent(Conformance.ResourceInteractionComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        CapabilityStatement.ResourceInteractionComponent tgt = new CapabilityStatement.ResourceInteractionComponent();
        VersionConvertor_14_40.copyElement((org.hl7.fhir.dstu2016may.model.Element)src, (Element)tgt);
        tgt.setCode(VersionConvertor_14_40.convertTypeRestfulInteraction(src.getCode()));
        if (src.hasDocumentation()) {
            tgt.setDocumentation(src.getDocumentation());
        }
        return tgt;
    }

    public static Conformance.ResourceInteractionComponent convertResourceInteractionComponent(CapabilityStatement.ResourceInteractionComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Conformance.ResourceInteractionComponent tgt = new Conformance.ResourceInteractionComponent();
        VersionConvertor_14_40.copyElement((Element)src, (org.hl7.fhir.dstu2016may.model.Element)tgt);
        tgt.setCode(VersionConvertor_14_40.convertTypeRestfulInteraction(src.getCode()));
        if (src.hasDocumentation()) {
            tgt.setDocumentation(src.getDocumentation());
        }
        return tgt;
    }

    private static CapabilityStatement.TypeRestfulInteraction convertTypeRestfulInteraction(Conformance.TypeRestfulInteraction src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case READ: {
                return CapabilityStatement.TypeRestfulInteraction.READ;
            }
            case VREAD: {
                return CapabilityStatement.TypeRestfulInteraction.VREAD;
            }
            case UPDATE: {
                return CapabilityStatement.TypeRestfulInteraction.UPDATE;
            }
            case DELETE: {
                return CapabilityStatement.TypeRestfulInteraction.DELETE;
            }
            case HISTORYINSTANCE: {
                return CapabilityStatement.TypeRestfulInteraction.HISTORYINSTANCE;
            }
            case HISTORYTYPE: {
                return CapabilityStatement.TypeRestfulInteraction.HISTORYTYPE;
            }
            case CREATE: {
                return CapabilityStatement.TypeRestfulInteraction.CREATE;
            }
            case SEARCHTYPE: {
                return CapabilityStatement.TypeRestfulInteraction.SEARCHTYPE;
            }
        }
        return CapabilityStatement.TypeRestfulInteraction.NULL;
    }

    private static Conformance.TypeRestfulInteraction convertTypeRestfulInteraction(CapabilityStatement.TypeRestfulInteraction src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case READ: {
                return Conformance.TypeRestfulInteraction.READ;
            }
            case VREAD: {
                return Conformance.TypeRestfulInteraction.VREAD;
            }
            case UPDATE: {
                return Conformance.TypeRestfulInteraction.UPDATE;
            }
            case DELETE: {
                return Conformance.TypeRestfulInteraction.DELETE;
            }
            case HISTORYINSTANCE: {
                return Conformance.TypeRestfulInteraction.HISTORYINSTANCE;
            }
            case HISTORYTYPE: {
                return Conformance.TypeRestfulInteraction.HISTORYTYPE;
            }
            case CREATE: {
                return Conformance.TypeRestfulInteraction.CREATE;
            }
            case SEARCHTYPE: {
                return Conformance.TypeRestfulInteraction.SEARCHTYPE;
            }
        }
        return Conformance.TypeRestfulInteraction.NULL;
    }

    public static Enumerations.SearchParamType convertSearchParamType(Enumerations.SearchParamType src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case NUMBER: {
                return Enumerations.SearchParamType.NUMBER;
            }
            case DATE: {
                return Enumerations.SearchParamType.DATE;
            }
            case STRING: {
                return Enumerations.SearchParamType.STRING;
            }
            case TOKEN: {
                return Enumerations.SearchParamType.TOKEN;
            }
            case REFERENCE: {
                return Enumerations.SearchParamType.REFERENCE;
            }
            case COMPOSITE: {
                return Enumerations.SearchParamType.COMPOSITE;
            }
            case QUANTITY: {
                return Enumerations.SearchParamType.QUANTITY;
            }
            case URI: {
                return Enumerations.SearchParamType.URI;
            }
        }
        return Enumerations.SearchParamType.NULL;
    }

    public static Enumerations.SearchParamType convertSearchParamType(Enumerations.SearchParamType src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case NUMBER: {
                return Enumerations.SearchParamType.NUMBER;
            }
            case DATE: {
                return Enumerations.SearchParamType.DATE;
            }
            case STRING: {
                return Enumerations.SearchParamType.STRING;
            }
            case TOKEN: {
                return Enumerations.SearchParamType.TOKEN;
            }
            case REFERENCE: {
                return Enumerations.SearchParamType.REFERENCE;
            }
            case COMPOSITE: {
                return Enumerations.SearchParamType.COMPOSITE;
            }
            case QUANTITY: {
                return Enumerations.SearchParamType.QUANTITY;
            }
            case URI: {
                return Enumerations.SearchParamType.URI;
            }
        }
        return Enumerations.SearchParamType.NULL;
    }

    public static CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent convertConformanceRestResourceSearchParamComponent(Conformance.ConformanceRestResourceSearchParamComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent tgt = new CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent();
        VersionConvertor_14_40.copyElement((org.hl7.fhir.dstu2016may.model.Element)src, (Element)tgt);
        tgt.setName(src.getName());
        if (src.hasDefinition()) {
            tgt.setDefinition(src.getDefinition());
        }
        tgt.setType(VersionConvertor_14_40.convertSearchParamType(src.getType()));
        if (src.hasDocumentation()) {
            tgt.setDocumentation(src.getDocumentation());
        }
        return tgt;
    }

    public static Conformance.ConformanceRestResourceSearchParamComponent convertConformanceRestResourceSearchParamComponent(CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Conformance.ConformanceRestResourceSearchParamComponent tgt = new Conformance.ConformanceRestResourceSearchParamComponent();
        VersionConvertor_14_40.copyElement((Element)src, (org.hl7.fhir.dstu2016may.model.Element)tgt);
        tgt.setName(src.getName());
        if (src.hasDefinition()) {
            tgt.setDefinition(src.getDefinition());
        }
        tgt.setType(VersionConvertor_14_40.convertSearchParamType(src.getType()));
        if (src.hasDocumentation()) {
            tgt.setDocumentation(src.getDocumentation());
        }
        return tgt;
    }

    public static CapabilityStatement.SystemInteractionComponent convertSystemInteractionComponent(Conformance.SystemInteractionComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        CapabilityStatement.SystemInteractionComponent tgt = new CapabilityStatement.SystemInteractionComponent();
        VersionConvertor_14_40.copyElement((org.hl7.fhir.dstu2016may.model.Element)src, (Element)tgt);
        tgt.setCode(VersionConvertor_14_40.convertSystemRestfulInteraction(src.getCode()));
        if (src.hasDocumentation()) {
            tgt.setDocumentation(src.getDocumentation());
        }
        return tgt;
    }

    public static Conformance.SystemInteractionComponent convertSystemInteractionComponent(CapabilityStatement.SystemInteractionComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Conformance.SystemInteractionComponent tgt = new Conformance.SystemInteractionComponent();
        VersionConvertor_14_40.copyElement((Element)src, (org.hl7.fhir.dstu2016may.model.Element)tgt);
        tgt.setCode(VersionConvertor_14_40.convertSystemRestfulInteraction(src.getCode()));
        if (src.hasDocumentation()) {
            tgt.setDocumentation(src.getDocumentation());
        }
        return tgt;
    }

    private static CapabilityStatement.SystemRestfulInteraction convertSystemRestfulInteraction(Conformance.SystemRestfulInteraction src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case TRANSACTION: {
                return CapabilityStatement.SystemRestfulInteraction.TRANSACTION;
            }
            case SEARCHSYSTEM: {
                return CapabilityStatement.SystemRestfulInteraction.SEARCHSYSTEM;
            }
            case HISTORYSYSTEM: {
                return CapabilityStatement.SystemRestfulInteraction.HISTORYSYSTEM;
            }
        }
        return CapabilityStatement.SystemRestfulInteraction.NULL;
    }

    private static Conformance.SystemRestfulInteraction convertSystemRestfulInteraction(CapabilityStatement.SystemRestfulInteraction src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case TRANSACTION: {
                return Conformance.SystemRestfulInteraction.TRANSACTION;
            }
            case SEARCHSYSTEM: {
                return Conformance.SystemRestfulInteraction.SEARCHSYSTEM;
            }
            case HISTORYSYSTEM: {
                return Conformance.SystemRestfulInteraction.HISTORYSYSTEM;
            }
        }
        return Conformance.SystemRestfulInteraction.NULL;
    }

    public static CapabilityStatement.CapabilityStatementRestResourceOperationComponent convertConformanceRestOperationComponent(Conformance.ConformanceRestOperationComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        CapabilityStatement.CapabilityStatementRestResourceOperationComponent tgt = new CapabilityStatement.CapabilityStatementRestResourceOperationComponent();
        VersionConvertor_14_40.copyElement((org.hl7.fhir.dstu2016may.model.Element)src, (Element)tgt);
        tgt.setName(src.getName());
        tgt.setDefinitionElement(VersionConvertor_14_40.convertReferenceToCanonical(src.getDefinition()));
        return tgt;
    }

    public static Conformance.ConformanceRestOperationComponent convertConformanceRestOperationComponent(CapabilityStatement.CapabilityStatementRestResourceOperationComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Conformance.ConformanceRestOperationComponent tgt = new Conformance.ConformanceRestOperationComponent();
        VersionConvertor_14_40.copyElement((Element)src, (org.hl7.fhir.dstu2016may.model.Element)tgt);
        tgt.setName(src.getName());
        tgt.setDefinition(VersionConvertor_14_40.convertCanonicalToReference(src.getDefinitionElement()));
        return tgt;
    }

    public static CapabilityStatement.CapabilityStatementMessagingComponent convertConformanceMessagingComponent(Conformance.ConformanceMessagingComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        CapabilityStatement.CapabilityStatementMessagingComponent tgt = new CapabilityStatement.CapabilityStatementMessagingComponent();
        VersionConvertor_14_40.copyElement((org.hl7.fhir.dstu2016may.model.Element)src, (Element)tgt);
        for (Conformance.ConformanceMessagingEndpointComponent t : src.getEndpoint()) {
            tgt.addEndpoint(VersionConvertor_14_40.convertConformanceMessagingEndpointComponent(t));
        }
        if (src.hasReliableCache()) {
            tgt.setReliableCache(src.getReliableCache());
        }
        if (src.hasDocumentation()) {
            tgt.setDocumentation(src.getDocumentation());
        }
        return tgt;
    }

    public static Conformance.ConformanceMessagingComponent convertConformanceMessagingComponent(CapabilityStatement.CapabilityStatementMessagingComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Conformance.ConformanceMessagingComponent tgt = new Conformance.ConformanceMessagingComponent();
        VersionConvertor_14_40.copyElement((Element)src, (org.hl7.fhir.dstu2016may.model.Element)tgt);
        for (CapabilityStatement.CapabilityStatementMessagingEndpointComponent t : src.getEndpoint()) {
            tgt.addEndpoint(VersionConvertor_14_40.convertConformanceMessagingEndpointComponent(t));
        }
        if (src.hasReliableCache()) {
            tgt.setReliableCache(src.getReliableCache());
        }
        if (src.hasDocumentation()) {
            tgt.setDocumentation(src.getDocumentation());
        }
        return tgt;
    }

    public static CapabilityStatement.CapabilityStatementMessagingEndpointComponent convertConformanceMessagingEndpointComponent(Conformance.ConformanceMessagingEndpointComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        CapabilityStatement.CapabilityStatementMessagingEndpointComponent tgt = new CapabilityStatement.CapabilityStatementMessagingEndpointComponent();
        VersionConvertor_14_40.copyElement((org.hl7.fhir.dstu2016may.model.Element)src, (Element)tgt);
        tgt.setProtocol(VersionConvertor_14_40.convertCoding(src.getProtocol()));
        tgt.setAddress(src.getAddress());
        return tgt;
    }

    public static Conformance.ConformanceMessagingEndpointComponent convertConformanceMessagingEndpointComponent(CapabilityStatement.CapabilityStatementMessagingEndpointComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Conformance.ConformanceMessagingEndpointComponent tgt = new Conformance.ConformanceMessagingEndpointComponent();
        VersionConvertor_14_40.copyElement((Element)src, (org.hl7.fhir.dstu2016may.model.Element)tgt);
        tgt.setProtocol(VersionConvertor_14_40.convertCoding(src.getProtocol()));
        tgt.setAddress(src.getAddress());
        return tgt;
    }

    private static CapabilityStatement.EventCapabilityMode convertConformanceEventMode(Conformance.ConformanceEventMode src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case SENDER: {
                return CapabilityStatement.EventCapabilityMode.SENDER;
            }
            case RECEIVER: {
                return CapabilityStatement.EventCapabilityMode.RECEIVER;
            }
        }
        return CapabilityStatement.EventCapabilityMode.NULL;
    }

    private static Conformance.ConformanceEventMode convertConformanceEventMode(CapabilityStatement.EventCapabilityMode src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case SENDER: {
                return Conformance.ConformanceEventMode.SENDER;
            }
            case RECEIVER: {
                return Conformance.ConformanceEventMode.RECEIVER;
            }
        }
        return Conformance.ConformanceEventMode.NULL;
    }

    public static CapabilityStatement.CapabilityStatementDocumentComponent convertConformanceDocumentComponent(Conformance.ConformanceDocumentComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        CapabilityStatement.CapabilityStatementDocumentComponent tgt = new CapabilityStatement.CapabilityStatementDocumentComponent();
        VersionConvertor_14_40.copyElement((org.hl7.fhir.dstu2016may.model.Element)src, (Element)tgt);
        tgt.setMode(VersionConvertor_14_40.convertDocumentMode(src.getMode()));
        if (src.hasDocumentation()) {
            tgt.setDocumentation(src.getDocumentation());
        }
        tgt.setProfileElement(VersionConvertor_14_40.convertReferenceToCanonical(src.getProfile()));
        return tgt;
    }

    public static Conformance.ConformanceDocumentComponent convertConformanceDocumentComponent(CapabilityStatement.CapabilityStatementDocumentComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Conformance.ConformanceDocumentComponent tgt = new Conformance.ConformanceDocumentComponent();
        VersionConvertor_14_40.copyElement((Element)src, (org.hl7.fhir.dstu2016may.model.Element)tgt);
        tgt.setMode(VersionConvertor_14_40.convertDocumentMode(src.getMode()));
        if (src.hasDocumentation()) {
            tgt.setDocumentation(src.getDocumentation());
        }
        tgt.setProfile(VersionConvertor_14_40.convertCanonicalToReference(src.getProfileElement()));
        return tgt;
    }

    private static CapabilityStatement.DocumentMode convertDocumentMode(Conformance.DocumentMode src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case PRODUCER: {
                return CapabilityStatement.DocumentMode.PRODUCER;
            }
            case CONSUMER: {
                return CapabilityStatement.DocumentMode.CONSUMER;
            }
        }
        return CapabilityStatement.DocumentMode.NULL;
    }

    private static Conformance.DocumentMode convertDocumentMode(CapabilityStatement.DocumentMode src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case PRODUCER: {
                return Conformance.DocumentMode.PRODUCER;
            }
            case CONSUMER: {
                return Conformance.DocumentMode.CONSUMER;
            }
        }
        return Conformance.DocumentMode.NULL;
    }

    public static org.hl7.fhir.r4.model.StructureDefinition convertDataElement(DataElement src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r4.model.StructureDefinition tgt = new org.hl7.fhir.r4.model.StructureDefinition();
        VersionConvertor_14_40.copyDomainResource((DomainResource)src, (org.hl7.fhir.r4.model.DomainResource)tgt);
        if (src.hasUrl()) {
            tgt.setUrl(src.getUrl());
        }
        for (org.hl7.fhir.dstu2016may.model.Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_14_40.convertIdentifier(t));
        }
        if (src.hasVersion()) {
            tgt.setVersion(src.getVersion());
        }
        tgt.setStatus(VersionConvertor_14_40.convertConformanceResourceStatus(src.getStatus()));
        if (src.hasExperimental()) {
            tgt.setExperimental(src.getExperimental());
        }
        if (src.hasPublisher()) {
            tgt.setPublisher(src.getPublisher());
        }
        if (src.hasDate()) {
            tgt.setDate(src.getDate());
        }
        if (src.hasName()) {
            tgt.setName(src.getName());
        }
        for (org.hl7.fhir.dstu2016may.model.Identifier t : src.getContact()) {
            tgt.addContact(VersionConvertor_14_40.convertDataElementContactComponent((DataElement.DataElementContactComponent)t));
        }
        for (org.hl7.fhir.dstu2016may.model.Identifier t : src.getUseContext()) {
            if (VersionConvertor_14_40.isJurisdiction((CodeableConcept)t)) {
                tgt.addJurisdiction(VersionConvertor_14_40.convertCodeableConcept((CodeableConcept)t));
                continue;
            }
            tgt.addUseContext(VersionConvertor_14_40.convertCodeableConceptToUsageContext((CodeableConcept)t));
        }
        if (src.hasCopyright()) {
            tgt.setCopyright(src.getCopyright());
        }
        for (org.hl7.fhir.dstu2016may.model.Identifier t : src.getMapping()) {
            tgt.addMapping(VersionConvertor_14_40.convertDataElementMappingComponent((DataElement.DataElementMappingComponent)t));
        }
        for (org.hl7.fhir.dstu2016may.model.Identifier t : src.getElement()) {
            tgt.getSnapshot().addElement(VersionConvertor_14_40.convertElementDefinition((org.hl7.fhir.dstu2016may.model.ElementDefinition)t, src.getElement(), src.getElement().indexOf(t)));
        }
        tgt.setKind(StructureDefinition.StructureDefinitionKind.LOGICAL);
        tgt.setAbstract(false);
        tgt.setType(tgt.getName());
        tgt.setBaseDefinition("http://hl7.org/fhir/StructureDefinition/Element");
        tgt.setDerivation(StructureDefinition.TypeDerivationRule.SPECIALIZATION);
        return tgt;
    }

    public static ContactDetail convertDataElementContactComponent(DataElement.DataElementContactComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ContactDetail tgt = new ContactDetail();
        VersionConvertor_14_40.copyElement((org.hl7.fhir.dstu2016may.model.Element)src, (Element)tgt);
        if (src.hasName()) {
            tgt.setName(src.getName());
        }
        for (org.hl7.fhir.dstu2016may.model.ContactPoint t : src.getTelecom()) {
            tgt.addTelecom(VersionConvertor_14_40.convertContactPoint(t));
        }
        return tgt;
    }

    public static DataElement.DataElementContactComponent convertDataElementContactComponent(ContactDetail src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        DataElement.DataElementContactComponent tgt = new DataElement.DataElementContactComponent();
        VersionConvertor_14_40.copyElement((Element)src, (org.hl7.fhir.dstu2016may.model.Element)tgt);
        if (src.hasName()) {
            tgt.setName(src.getName());
        }
        for (ContactPoint t : src.getTelecom()) {
            tgt.addTelecom(VersionConvertor_14_40.convertContactPoint(t));
        }
        return tgt;
    }

    public static StructureDefinition.StructureDefinitionMappingComponent convertDataElementMappingComponent(DataElement.DataElementMappingComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        StructureDefinition.StructureDefinitionMappingComponent tgt = new StructureDefinition.StructureDefinitionMappingComponent();
        VersionConvertor_14_40.copyElement((org.hl7.fhir.dstu2016may.model.Element)src, (Element)tgt);
        tgt.setIdentity(src.getIdentity());
        if (src.hasUri()) {
            tgt.setUri(src.getUri());
        }
        if (src.hasName()) {
            tgt.setName(src.getName());
        }
        if (src.hasComment()) {
            tgt.setComment(src.getComment());
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.ImplementationGuide convertImplementationGuide(ImplementationGuide src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r4.model.ImplementationGuide tgt = new org.hl7.fhir.r4.model.ImplementationGuide();
        VersionConvertor_14_40.copyDomainResource((DomainResource)src, (org.hl7.fhir.r4.model.DomainResource)tgt);
        tgt.setUrl(src.getUrl());
        if (src.hasVersion()) {
            tgt.setVersion(src.getVersion());
        }
        tgt.setName(src.getName());
        tgt.setStatus(VersionConvertor_14_40.convertConformanceResourceStatus(src.getStatus()));
        if (src.hasExperimental()) {
            tgt.setExperimental(src.getExperimental());
        }
        if (src.hasPublisher()) {
            tgt.setPublisher(src.getPublisher());
        }
        for (ImplementationGuide.ImplementationGuideContactComponent t : src.getContact()) {
            tgt.addContact(VersionConvertor_14_40.convertImplementationGuideContactComponent(t));
        }
        if (src.hasDate()) {
            tgt.setDate(src.getDate());
        }
        if (src.hasDescription()) {
            tgt.setDescription(src.getDescription());
        }
        for (ImplementationGuide.ImplementationGuideContactComponent t : src.getUseContext()) {
            if (VersionConvertor_14_40.isJurisdiction((CodeableConcept)t)) {
                tgt.addJurisdiction(VersionConvertor_14_40.convertCodeableConcept((CodeableConcept)t));
                continue;
            }
            tgt.addUseContext(VersionConvertor_14_40.convertCodeableConceptToUsageContext((CodeableConcept)t));
        }
        if (src.hasCopyright()) {
            tgt.setCopyright(src.getCopyright());
        }
        if (src.hasFhirVersion()) {
            tgt.setFhirVersion(src.getFhirVersion());
        }
        for (ImplementationGuide.ImplementationGuideContactComponent t : src.getDependency()) {
            tgt.addDependsOn(VersionConvertor_14_40.convertImplementationGuideDependencyComponent((ImplementationGuide.ImplementationGuideDependencyComponent)t));
        }
        for (ImplementationGuide.ImplementationGuideContactComponent t : src.getPackage()) {
            tgt.getDefinition().addPackage(VersionConvertor_14_40.convertImplementationGuidePackageComponent(tgt.getDefinition(), (ImplementationGuide.ImplementationGuidePackageComponent)t));
        }
        for (ImplementationGuide.ImplementationGuideContactComponent t : src.getGlobal()) {
            tgt.addGlobal(VersionConvertor_14_40.convertImplementationGuideGlobalComponent((ImplementationGuide.ImplementationGuideGlobalComponent)t));
        }
        tgt.getDefinition().setPage(VersionConvertor_14_40.convertImplementationGuidePageComponent(src.getPage()));
        return tgt;
    }

    public static ImplementationGuide convertImplementationGuide(org.hl7.fhir.r4.model.ImplementationGuide src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ImplementationGuide tgt = new ImplementationGuide();
        VersionConvertor_14_40.copyDomainResource((org.hl7.fhir.r4.model.DomainResource)src, (DomainResource)tgt);
        tgt.setUrl(src.getUrl());
        if (src.hasVersion()) {
            tgt.setVersion(src.getVersion());
        }
        tgt.setName(src.getName());
        tgt.setStatus(VersionConvertor_14_40.convertConformanceResourceStatus(src.getStatus()));
        if (src.hasExperimental()) {
            tgt.setExperimental(src.getExperimental());
        }
        if (src.hasPublisher()) {
            tgt.setPublisher(src.getPublisher());
        }
        for (ContactDetail t : src.getContact()) {
            tgt.addContact(VersionConvertor_14_40.convertImplementationGuideContactComponent(t));
        }
        if (src.hasDate()) {
            tgt.setDate(src.getDate());
        }
        if (src.hasDescription()) {
            tgt.setDescription(src.getDescription());
        }
        for (ContactDetail t : src.getUseContext()) {
            if (!t.hasValueCodeableConcept()) continue;
            tgt.addUseContext(VersionConvertor_14_40.convertCodeableConcept(t.getValueCodeableConcept()));
        }
        for (ContactDetail t : src.getJurisdiction()) {
            tgt.addUseContext(VersionConvertor_14_40.convertCodeableConcept((org.hl7.fhir.r4.model.CodeableConcept)t));
        }
        if (src.hasCopyright()) {
            tgt.setCopyright(src.getCopyright());
        }
        if (src.hasFhirVersion()) {
            tgt.setFhirVersion(src.getFhirVersion());
        }
        for (ContactDetail t : src.getDependsOn()) {
            tgt.addDependency(VersionConvertor_14_40.convertImplementationGuideDependencyComponent((ImplementationGuide.ImplementationGuideDependsOnComponent)t));
        }
        for (ContactDetail t : src.getDefinition().getPackage()) {
            tgt.addPackage(VersionConvertor_14_40.convertImplementationGuidePackageComponent((ImplementationGuide.ImplementationGuideDefinitionPackageComponent)t));
        }
        for (ContactDetail t : src.getDefinition().getResource()) {
            VersionConvertor_14_40.findPackage(tgt.getPackage(), t.getPackage()).addResource(VersionConvertor_14_40.convertImplementationGuidePackageResourceComponent((ImplementationGuide.ImplementationGuideDefinitionResourceComponent)t));
        }
        for (ContactDetail t : src.getGlobal()) {
            tgt.addGlobal(VersionConvertor_14_40.convertImplementationGuideGlobalComponent((ImplementationGuide.ImplementationGuideGlobalComponent)t));
        }
        tgt.setPage(VersionConvertor_14_40.convertImplementationGuidePageComponent(src.getDefinition().getPage()));
        return tgt;
    }

    private static ImplementationGuide.ImplementationGuidePackageComponent findPackage(List<ImplementationGuide.ImplementationGuidePackageComponent> definition, String id) {
        for (ImplementationGuide.ImplementationGuidePackageComponent t : definition) {
            if (!t.getId().equals(id)) continue;
            return t;
        }
        ImplementationGuide.ImplementationGuidePackageComponent t = new ImplementationGuide.ImplementationGuidePackageComponent();
        t.setName("Default Package");
        t.setId(id);
        return t;
    }

    public static ContactDetail convertImplementationGuideContactComponent(ImplementationGuide.ImplementationGuideContactComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ContactDetail tgt = new ContactDetail();
        VersionConvertor_14_40.copyElement((org.hl7.fhir.dstu2016may.model.Element)src, (Element)tgt);
        if (src.hasName()) {
            tgt.setName(src.getName());
        }
        for (org.hl7.fhir.dstu2016may.model.ContactPoint t : src.getTelecom()) {
            tgt.addTelecom(VersionConvertor_14_40.convertContactPoint(t));
        }
        return tgt;
    }

    public static ImplementationGuide.ImplementationGuideContactComponent convertImplementationGuideContactComponent(ContactDetail src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ImplementationGuide.ImplementationGuideContactComponent tgt = new ImplementationGuide.ImplementationGuideContactComponent();
        VersionConvertor_14_40.copyElement((Element)src, (org.hl7.fhir.dstu2016may.model.Element)tgt);
        if (src.hasName()) {
            tgt.setName(src.getName());
        }
        for (ContactPoint t : src.getTelecom()) {
            tgt.addTelecom(VersionConvertor_14_40.convertContactPoint(t));
        }
        return tgt;
    }

    public static ImplementationGuide.ImplementationGuideDependsOnComponent convertImplementationGuideDependencyComponent(ImplementationGuide.ImplementationGuideDependencyComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ImplementationGuide.ImplementationGuideDependsOnComponent tgt = new ImplementationGuide.ImplementationGuideDependsOnComponent();
        VersionConvertor_14_40.copyElement((org.hl7.fhir.dstu2016may.model.Element)src, (Element)tgt);
        tgt.setUri(src.getUri());
        return tgt;
    }

    public static ImplementationGuide.ImplementationGuideDependencyComponent convertImplementationGuideDependencyComponent(ImplementationGuide.ImplementationGuideDependsOnComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ImplementationGuide.ImplementationGuideDependencyComponent tgt = new ImplementationGuide.ImplementationGuideDependencyComponent();
        VersionConvertor_14_40.copyElement((Element)src, (org.hl7.fhir.dstu2016may.model.Element)tgt);
        tgt.setType(ImplementationGuide.GuideDependencyType.REFERENCE);
        tgt.setUri(src.getUri());
        return tgt;
    }

    public static ImplementationGuide.ImplementationGuideDefinitionPackageComponent convertImplementationGuidePackageComponent(ImplementationGuide.ImplementationGuideDefinitionComponent context, ImplementationGuide.ImplementationGuidePackageComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ImplementationGuide.ImplementationGuideDefinitionPackageComponent tgt = new ImplementationGuide.ImplementationGuideDefinitionPackageComponent();
        tgt.setId("p" + (context.getPackage().size() + 1));
        VersionConvertor_14_40.copyElement((org.hl7.fhir.dstu2016may.model.Element)src, (Element)tgt);
        if (src.hasName()) {
            tgt.setName(src.getName());
        }
        if (src.hasDescription()) {
            tgt.setDescription(src.getDescription());
        }
        for (ImplementationGuide.ImplementationGuidePackageResourceComponent t : src.getResource()) {
            ImplementationGuide.ImplementationGuideDefinitionResourceComponent tn = VersionConvertor_14_40.convertImplementationGuidePackageResourceComponent(t);
            tn.setPackage(tgt.getId());
            context.addResource(tn);
        }
        return tgt;
    }

    public static ImplementationGuide.ImplementationGuidePackageComponent convertImplementationGuidePackageComponent(ImplementationGuide.ImplementationGuideDefinitionPackageComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ImplementationGuide.ImplementationGuidePackageComponent tgt = new ImplementationGuide.ImplementationGuidePackageComponent();
        VersionConvertor_14_40.copyElement((Element)src, (org.hl7.fhir.dstu2016may.model.Element)tgt);
        tgt.setId(src.getId());
        tgt.setName(src.getName());
        if (src.hasDescription()) {
            tgt.setDescription(src.getDescription());
        }
        return tgt;
    }

    public static ImplementationGuide.ImplementationGuideDefinitionResourceComponent convertImplementationGuidePackageResourceComponent(ImplementationGuide.ImplementationGuidePackageResourceComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ImplementationGuide.ImplementationGuideDefinitionResourceComponent tgt = new ImplementationGuide.ImplementationGuideDefinitionResourceComponent();
        VersionConvertor_14_40.copyElement((org.hl7.fhir.dstu2016may.model.Element)src, (Element)tgt);
        if (src.hasExampleFor()) {
            Type t = VersionConvertor_14_40.convertType((org.hl7.fhir.dstu2016may.model.Type)src.getExampleFor());
            tgt.setExample((Type)(t instanceof Reference ? new CanonicalType(((Reference)t).getReference()) : t));
        } else if (src.hasExample()) {
            tgt.setExample((Type)new BooleanType(src.getExample()));
        }
        if (src.hasName()) {
            tgt.setName(src.getName());
        }
        if (src.hasDescription()) {
            tgt.setDescription(src.getDescription());
        }
        if (src.hasSourceReference()) {
            tgt.setReference(VersionConvertor_14_40.convertReference(src.getSourceReference()));
        } else if (src.hasSourceUriType()) {
            tgt.setReference(new Reference((String)src.getSourceUriType().getValue()));
        }
        return tgt;
    }

    public static ImplementationGuide.ImplementationGuidePackageResourceComponent convertImplementationGuidePackageResourceComponent(ImplementationGuide.ImplementationGuideDefinitionResourceComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ImplementationGuide.ImplementationGuidePackageResourceComponent tgt = new ImplementationGuide.ImplementationGuidePackageResourceComponent();
        VersionConvertor_14_40.copyElement((Element)src, (org.hl7.fhir.dstu2016may.model.Element)tgt);
        if (src.hasExampleCanonicalType()) {
            tgt.setExampleFor(VersionConvertor_14_40.convertCanonicalToReference(src.getExampleCanonicalType()));
            tgt.setExample(true);
        } else if (src.hasExampleBooleanType()) {
            tgt.setExample(((Boolean)src.getExampleBooleanType().getValue()).booleanValue());
        }
        if (src.hasName()) {
            tgt.setName(src.getName());
        }
        if (src.hasDescription()) {
            tgt.setDescription(src.getDescription());
        }
        if (src.hasReference()) {
            tgt.setSource((org.hl7.fhir.dstu2016may.model.Type)VersionConvertor_14_40.convertReference(src.getReference()));
        }
        return tgt;
    }

    public static ImplementationGuide.ImplementationGuideGlobalComponent convertImplementationGuideGlobalComponent(ImplementationGuide.ImplementationGuideGlobalComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ImplementationGuide.ImplementationGuideGlobalComponent tgt = new ImplementationGuide.ImplementationGuideGlobalComponent();
        VersionConvertor_14_40.copyElement((org.hl7.fhir.dstu2016may.model.Element)src, (Element)tgt);
        tgt.setType(src.getType());
        tgt.setProfileElement(VersionConvertor_14_40.convertReferenceToCanonical(src.getProfile()));
        return tgt;
    }

    public static ImplementationGuide.ImplementationGuideGlobalComponent convertImplementationGuideGlobalComponent(ImplementationGuide.ImplementationGuideGlobalComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ImplementationGuide.ImplementationGuideGlobalComponent tgt = new ImplementationGuide.ImplementationGuideGlobalComponent();
        VersionConvertor_14_40.copyElement((Element)src, (org.hl7.fhir.dstu2016may.model.Element)tgt);
        tgt.setType(src.getType());
        tgt.setProfile(VersionConvertor_14_40.convertCanonicalToReference(src.getProfileElement()));
        return tgt;
    }

    public static ImplementationGuide.ImplementationGuideDefinitionPageComponent convertImplementationGuidePageComponent(ImplementationGuide.ImplementationGuidePageComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ImplementationGuide.ImplementationGuideDefinitionPageComponent tgt = new ImplementationGuide.ImplementationGuideDefinitionPageComponent();
        VersionConvertor_14_40.copyElement((org.hl7.fhir.dstu2016may.model.Element)src, (Element)tgt);
        if (src.hasSource()) {
            tgt.setName((Type)VersionConvertor_14_40.convertUriToUrl(src.getSourceElement()));
        }
        tgt.setTitle(src.getName());
        if (src.hasKind()) {
            tgt.setGeneration(VersionConvertor_14_40.convertPageGeneration(src.getKind()));
        }
        for (ImplementationGuide.ImplementationGuidePageComponent t : src.getPage()) {
            tgt.addPage(VersionConvertor_14_40.convertImplementationGuidePageComponent(t));
        }
        return tgt;
    }

    private static ImplementationGuide.GuidePageGeneration convertPageGeneration(ImplementationGuide.GuidePageKind kind) {
        switch (kind) {
            case PAGE: {
                return ImplementationGuide.GuidePageGeneration.HTML;
            }
        }
        return ImplementationGuide.GuidePageGeneration.GENERATED;
    }

    private static ImplementationGuide.GuidePageKind convertPageGeneration(ImplementationGuide.GuidePageGeneration generation) {
        switch (generation) {
            case HTML: {
                return ImplementationGuide.GuidePageKind.PAGE;
            }
        }
        return ImplementationGuide.GuidePageKind.RESOURCE;
    }

    public static ImplementationGuide.ImplementationGuidePageComponent convertImplementationGuidePageComponent(ImplementationGuide.ImplementationGuideDefinitionPageComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ImplementationGuide.ImplementationGuidePageComponent tgt = new ImplementationGuide.ImplementationGuidePageComponent();
        VersionConvertor_14_40.copyElement((Element)src, (org.hl7.fhir.dstu2016may.model.Element)tgt);
        if (src.hasNameUrlType()) {
            tgt.setSource((String)src.getNameUrlType().getValue());
        }
        tgt.setName(src.getTitle());
        if (src.hasGeneration()) {
            tgt.setKind(VersionConvertor_14_40.convertPageGeneration(src.getGeneration()));
        }
        for (ImplementationGuide.ImplementationGuideDefinitionPageComponent t : src.getPage()) {
            tgt.addPage(VersionConvertor_14_40.convertImplementationGuidePageComponent(t));
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.NamingSystem convertNamingSystem(NamingSystem src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r4.model.NamingSystem tgt = new org.hl7.fhir.r4.model.NamingSystem();
        VersionConvertor_14_40.copyDomainResource((DomainResource)src, (org.hl7.fhir.r4.model.DomainResource)tgt);
        tgt.setName(src.getName());
        tgt.setStatus(VersionConvertor_14_40.convertConformanceResourceStatus(src.getStatus()));
        tgt.setKind(VersionConvertor_14_40.convertNamingSystemType(src.getKind()));
        tgt.setDate(src.getDate());
        if (src.hasPublisher()) {
            tgt.setPublisher(src.getPublisher());
        }
        for (NamingSystem.NamingSystemContactComponent t : src.getContact()) {
            tgt.addContact(VersionConvertor_14_40.convertNamingSystemContactComponent(t));
        }
        if (src.hasResponsible()) {
            tgt.setResponsible(src.getResponsible());
        }
        tgt.setType(VersionConvertor_14_40.convertCodeableConcept(src.getType()));
        if (src.hasDescription()) {
            tgt.setDescription(src.getDescription());
        }
        for (NamingSystem.NamingSystemContactComponent t : src.getUseContext()) {
            if (VersionConvertor_14_40.isJurisdiction((CodeableConcept)t)) {
                tgt.addJurisdiction(VersionConvertor_14_40.convertCodeableConcept((CodeableConcept)t));
                continue;
            }
            tgt.addUseContext(VersionConvertor_14_40.convertCodeableConceptToUsageContext((CodeableConcept)t));
        }
        if (src.hasUsage()) {
            tgt.setUsage(src.getUsage());
        }
        for (NamingSystem.NamingSystemContactComponent t : src.getUniqueId()) {
            tgt.addUniqueId(VersionConvertor_14_40.convertNamingSystemUniqueIdComponent((NamingSystem.NamingSystemUniqueIdComponent)t));
        }
        return tgt;
    }

    public static NamingSystem convertNamingSystem(org.hl7.fhir.r4.model.NamingSystem src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        NamingSystem tgt = new NamingSystem();
        VersionConvertor_14_40.copyDomainResource((org.hl7.fhir.r4.model.DomainResource)src, (DomainResource)tgt);
        tgt.setName(src.getName());
        tgt.setStatus(VersionConvertor_14_40.convertConformanceResourceStatus(src.getStatus()));
        tgt.setKind(VersionConvertor_14_40.convertNamingSystemType(src.getKind()));
        tgt.setDate(src.getDate());
        if (src.hasPublisher()) {
            tgt.setPublisher(src.getPublisher());
        }
        for (ContactDetail t : src.getContact()) {
            tgt.addContact(VersionConvertor_14_40.convertNamingSystemContactComponent(t));
        }
        if (src.hasResponsible()) {
            tgt.setResponsible(src.getResponsible());
        }
        tgt.setType(VersionConvertor_14_40.convertCodeableConcept(src.getType()));
        if (src.hasDescription()) {
            tgt.setDescription(src.getDescription());
        }
        for (ContactDetail t : src.getUseContext()) {
            if (!t.hasValueCodeableConcept()) continue;
            tgt.addUseContext(VersionConvertor_14_40.convertCodeableConcept(t.getValueCodeableConcept()));
        }
        for (ContactDetail t : src.getJurisdiction()) {
            tgt.addUseContext(VersionConvertor_14_40.convertCodeableConcept((org.hl7.fhir.r4.model.CodeableConcept)t));
        }
        if (src.hasUsage()) {
            tgt.setUsage(src.getUsage());
        }
        for (ContactDetail t : src.getUniqueId()) {
            tgt.addUniqueId(VersionConvertor_14_40.convertNamingSystemUniqueIdComponent((NamingSystem.NamingSystemUniqueIdComponent)t));
        }
        return tgt;
    }

    private static NamingSystem.NamingSystemType convertNamingSystemType(NamingSystem.NamingSystemType src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case CODESYSTEM: {
                return NamingSystem.NamingSystemType.CODESYSTEM;
            }
            case IDENTIFIER: {
                return NamingSystem.NamingSystemType.IDENTIFIER;
            }
            case ROOT: {
                return NamingSystem.NamingSystemType.ROOT;
            }
        }
        return NamingSystem.NamingSystemType.NULL;
    }

    private static NamingSystem.NamingSystemType convertNamingSystemType(NamingSystem.NamingSystemType src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case CODESYSTEM: {
                return NamingSystem.NamingSystemType.CODESYSTEM;
            }
            case IDENTIFIER: {
                return NamingSystem.NamingSystemType.IDENTIFIER;
            }
            case ROOT: {
                return NamingSystem.NamingSystemType.ROOT;
            }
        }
        return NamingSystem.NamingSystemType.NULL;
    }

    public static ContactDetail convertNamingSystemContactComponent(NamingSystem.NamingSystemContactComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ContactDetail tgt = new ContactDetail();
        VersionConvertor_14_40.copyElement((org.hl7.fhir.dstu2016may.model.Element)src, (Element)tgt);
        if (src.hasName()) {
            tgt.setName(src.getName());
        }
        for (org.hl7.fhir.dstu2016may.model.ContactPoint t : src.getTelecom()) {
            tgt.addTelecom(VersionConvertor_14_40.convertContactPoint(t));
        }
        return tgt;
    }

    public static NamingSystem.NamingSystemContactComponent convertNamingSystemContactComponent(ContactDetail src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        NamingSystem.NamingSystemContactComponent tgt = new NamingSystem.NamingSystemContactComponent();
        VersionConvertor_14_40.copyElement((Element)src, (org.hl7.fhir.dstu2016may.model.Element)tgt);
        if (src.hasName()) {
            tgt.setName(src.getName());
        }
        for (ContactPoint t : src.getTelecom()) {
            tgt.addTelecom(VersionConvertor_14_40.convertContactPoint(t));
        }
        return tgt;
    }

    public static NamingSystem.NamingSystemUniqueIdComponent convertNamingSystemUniqueIdComponent(NamingSystem.NamingSystemUniqueIdComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        NamingSystem.NamingSystemUniqueIdComponent tgt = new NamingSystem.NamingSystemUniqueIdComponent();
        VersionConvertor_14_40.copyElement((org.hl7.fhir.dstu2016may.model.Element)src, (Element)tgt);
        tgt.setType(VersionConvertor_14_40.convertNamingSystemIdentifierType(src.getType()));
        tgt.setValue(src.getValue());
        if (src.hasPreferred()) {
            tgt.setPreferred(src.getPreferred());
        }
        tgt.setPeriod(VersionConvertor_14_40.convertPeriod(src.getPeriod()));
        return tgt;
    }

    public static NamingSystem.NamingSystemUniqueIdComponent convertNamingSystemUniqueIdComponent(NamingSystem.NamingSystemUniqueIdComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        NamingSystem.NamingSystemUniqueIdComponent tgt = new NamingSystem.NamingSystemUniqueIdComponent();
        VersionConvertor_14_40.copyElement((Element)src, (org.hl7.fhir.dstu2016may.model.Element)tgt);
        tgt.setType(VersionConvertor_14_40.convertNamingSystemIdentifierType(src.getType()));
        tgt.setValue(src.getValue());
        if (src.hasPreferred()) {
            tgt.setPreferred(src.getPreferred());
        }
        tgt.setPeriod(VersionConvertor_14_40.convertPeriod(src.getPeriod()));
        return tgt;
    }

    private static NamingSystem.NamingSystemIdentifierType convertNamingSystemIdentifierType(NamingSystem.NamingSystemIdentifierType src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case OID: {
                return NamingSystem.NamingSystemIdentifierType.OID;
            }
            case UUID: {
                return NamingSystem.NamingSystemIdentifierType.UUID;
            }
            case URI: {
                return NamingSystem.NamingSystemIdentifierType.URI;
            }
            case OTHER: {
                return NamingSystem.NamingSystemIdentifierType.OTHER;
            }
        }
        return NamingSystem.NamingSystemIdentifierType.NULL;
    }

    private static NamingSystem.NamingSystemIdentifierType convertNamingSystemIdentifierType(NamingSystem.NamingSystemIdentifierType src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case OID: {
                return NamingSystem.NamingSystemIdentifierType.OID;
            }
            case UUID: {
                return NamingSystem.NamingSystemIdentifierType.UUID;
            }
            case URI: {
                return NamingSystem.NamingSystemIdentifierType.URI;
            }
            case OTHER: {
                return NamingSystem.NamingSystemIdentifierType.OTHER;
            }
        }
        return NamingSystem.NamingSystemIdentifierType.NULL;
    }

    public static org.hl7.fhir.r4.model.OperationDefinition convertOperationDefinition(OperationDefinition src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r4.model.OperationDefinition tgt = new org.hl7.fhir.r4.model.OperationDefinition();
        VersionConvertor_14_40.copyDomainResource((DomainResource)src, (org.hl7.fhir.r4.model.DomainResource)tgt);
        if (src.hasUrl()) {
            tgt.setUrl(src.getUrl());
        }
        if (src.hasVersion()) {
            tgt.setVersion(src.getVersion());
        }
        tgt.setName(src.getName());
        tgt.setStatus(VersionConvertor_14_40.convertConformanceResourceStatus(src.getStatus()));
        tgt.setKind(VersionConvertor_14_40.convertOperationKind(src.getKind()));
        if (src.hasExperimental()) {
            tgt.setExperimental(src.getExperimental());
        }
        if (src.hasDate()) {
            tgt.setDate(src.getDate());
        }
        if (src.hasPublisher()) {
            tgt.setPublisher(src.getPublisher());
        }
        for (OperationDefinition.OperationDefinitionContactComponent t : src.getContact()) {
            tgt.addContact(VersionConvertor_14_40.convertOperationDefinitionContactComponent(t));
        }
        if (src.hasDescription()) {
            tgt.setDescription(src.getDescription());
        }
        for (OperationDefinition.OperationDefinitionContactComponent t : src.getUseContext()) {
            if (VersionConvertor_14_40.isJurisdiction((CodeableConcept)t)) {
                tgt.addJurisdiction(VersionConvertor_14_40.convertCodeableConcept((CodeableConcept)t));
                continue;
            }
            tgt.addUseContext(VersionConvertor_14_40.convertCodeableConceptToUsageContext((CodeableConcept)t));
        }
        if (src.hasRequirements()) {
            tgt.setPurpose(src.getRequirements());
        }
        if (src.hasIdempotent()) {
            tgt.setAffectsState(!src.getIdempotent());
        }
        tgt.setCode(src.getCode());
        if (src.hasComment()) {
            tgt.setComment(src.getComment());
        }
        tgt.setBaseElement(VersionConvertor_14_40.convertReferenceToCanonical(src.getBase()));
        tgt.setSystem(src.getSystem());
        for (OperationDefinition.OperationDefinitionContactComponent t : src.getType()) {
            tgt.addResource((String)t.getValue());
        }
        tgt.setType(tgt.hasResource());
        tgt.setInstance(src.getInstance());
        for (OperationDefinition.OperationDefinitionContactComponent t : src.getParameter()) {
            tgt.addParameter(VersionConvertor_14_40.convertOperationDefinitionParameterComponent((OperationDefinition.OperationDefinitionParameterComponent)t));
        }
        return tgt;
    }

    public static OperationDefinition convertOperationDefinition(org.hl7.fhir.r4.model.OperationDefinition src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        OperationDefinition tgt = new OperationDefinition();
        VersionConvertor_14_40.copyDomainResource((org.hl7.fhir.r4.model.DomainResource)src, (DomainResource)tgt);
        if (src.hasUrl()) {
            tgt.setUrl(src.getUrl());
        }
        if (src.hasVersion()) {
            tgt.setVersion(src.getVersion());
        }
        tgt.setName(src.getName());
        tgt.setStatus(VersionConvertor_14_40.convertConformanceResourceStatus(src.getStatus()));
        tgt.setKind(VersionConvertor_14_40.convertOperationKind(src.getKind()));
        if (src.hasExperimental()) {
            tgt.setExperimental(src.getExperimental());
        }
        if (src.hasDate()) {
            tgt.setDate(src.getDate());
        }
        if (src.hasPublisher()) {
            tgt.setPublisher(src.getPublisher());
        }
        for (ContactDetail t : src.getContact()) {
            tgt.addContact(VersionConvertor_14_40.convertOperationDefinitionContactComponent(t));
        }
        if (src.hasDescription()) {
            tgt.setDescription(src.getDescription());
        }
        for (ContactDetail t : src.getUseContext()) {
            if (!t.hasValueCodeableConcept()) continue;
            tgt.addUseContext(VersionConvertor_14_40.convertCodeableConcept(t.getValueCodeableConcept()));
        }
        for (ContactDetail t : src.getJurisdiction()) {
            tgt.addUseContext(VersionConvertor_14_40.convertCodeableConcept((org.hl7.fhir.r4.model.CodeableConcept)t));
        }
        if (src.hasPurpose()) {
            tgt.setRequirements(src.getPurpose());
        }
        if (src.hasAffectsState()) {
            tgt.setIdempotent(!src.getAffectsState());
        }
        tgt.setCode(src.getCode());
        if (src.hasComment()) {
            tgt.setComment(src.getComment());
        }
        tgt.setBase(VersionConvertor_14_40.convertCanonicalToReference(src.getBaseElement()));
        tgt.setSystem(src.getSystem());
        if (src.getType()) {
            for (ContactDetail t : src.getResource()) {
                tgt.addType((String)t.getValue());
            }
        }
        tgt.setInstance(src.getInstance());
        for (ContactDetail t : src.getParameter()) {
            tgt.addParameter(VersionConvertor_14_40.convertOperationDefinitionParameterComponent((OperationDefinition.OperationDefinitionParameterComponent)t));
        }
        return tgt;
    }

    private static OperationDefinition.OperationKind convertOperationKind(OperationDefinition.OperationKind src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case OPERATION: {
                return OperationDefinition.OperationKind.OPERATION;
            }
            case QUERY: {
                return OperationDefinition.OperationKind.QUERY;
            }
        }
        return OperationDefinition.OperationKind.NULL;
    }

    private static OperationDefinition.OperationKind convertOperationKind(OperationDefinition.OperationKind src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case OPERATION: {
                return OperationDefinition.OperationKind.OPERATION;
            }
            case QUERY: {
                return OperationDefinition.OperationKind.QUERY;
            }
        }
        return OperationDefinition.OperationKind.NULL;
    }

    public static ContactDetail convertOperationDefinitionContactComponent(OperationDefinition.OperationDefinitionContactComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ContactDetail tgt = new ContactDetail();
        VersionConvertor_14_40.copyElement((org.hl7.fhir.dstu2016may.model.Element)src, (Element)tgt);
        if (src.hasName()) {
            tgt.setName(src.getName());
        }
        for (org.hl7.fhir.dstu2016may.model.ContactPoint t : src.getTelecom()) {
            tgt.addTelecom(VersionConvertor_14_40.convertContactPoint(t));
        }
        return tgt;
    }

    public static OperationDefinition.OperationDefinitionContactComponent convertOperationDefinitionContactComponent(ContactDetail src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        OperationDefinition.OperationDefinitionContactComponent tgt = new OperationDefinition.OperationDefinitionContactComponent();
        VersionConvertor_14_40.copyElement((Element)src, (org.hl7.fhir.dstu2016may.model.Element)tgt);
        if (src.hasName()) {
            tgt.setName(src.getName());
        }
        for (ContactPoint t : src.getTelecom()) {
            tgt.addTelecom(VersionConvertor_14_40.convertContactPoint(t));
        }
        return tgt;
    }

    public static OperationDefinition.OperationDefinitionParameterComponent convertOperationDefinitionParameterComponent(OperationDefinition.OperationDefinitionParameterComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        OperationDefinition.OperationDefinitionParameterComponent tgt = new OperationDefinition.OperationDefinitionParameterComponent();
        VersionConvertor_14_40.copyElement((org.hl7.fhir.dstu2016may.model.Element)src, (Element)tgt);
        tgt.setName(src.getName());
        tgt.setUse(VersionConvertor_14_40.convertOperationParameterUse(src.getUse()));
        tgt.setMin(src.getMin());
        tgt.setMax(src.getMax());
        if (src.hasDocumentation()) {
            tgt.setDocumentation(src.getDocumentation());
        }
        if (src.hasType()) {
            tgt.setType(src.getType());
        }
        tgt.setSearchType(VersionConvertor_14_40.convertSearchParamType(src.getSearchType()));
        tgt.addTargetProfile(src.getProfile().getReference());
        tgt.setBinding(VersionConvertor_14_40.convertOperationDefinitionParameterBindingComponent(src.getBinding()));
        for (OperationDefinition.OperationDefinitionParameterComponent t : src.getPart()) {
            tgt.addPart(VersionConvertor_14_40.convertOperationDefinitionParameterComponent(t));
        }
        return tgt;
    }

    public static OperationDefinition.OperationDefinitionParameterComponent convertOperationDefinitionParameterComponent(OperationDefinition.OperationDefinitionParameterComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        OperationDefinition.OperationDefinitionParameterComponent tgt = new OperationDefinition.OperationDefinitionParameterComponent();
        VersionConvertor_14_40.copyElement((Element)src, (org.hl7.fhir.dstu2016may.model.Element)tgt);
        tgt.setName(src.getName());
        tgt.setUse(VersionConvertor_14_40.convertOperationParameterUse(src.getUse()));
        tgt.setMin(src.getMin());
        tgt.setMax(src.getMax());
        if (src.hasDocumentation()) {
            tgt.setDocumentation(src.getDocumentation());
        }
        if (src.hasType()) {
            tgt.setType(src.getType());
        }
        tgt.setSearchType(VersionConvertor_14_40.convertSearchParamType(src.getSearchType()));
        for (UriType t : src.getTargetProfile()) {
            tgt.setProfile(new org.hl7.fhir.dstu2016may.model.Reference((String)t.getValue()));
        }
        tgt.setBinding(VersionConvertor_14_40.convertOperationDefinitionParameterBindingComponent(src.getBinding()));
        for (UriType t : src.getPart()) {
            tgt.addPart(VersionConvertor_14_40.convertOperationDefinitionParameterComponent((OperationDefinition.OperationDefinitionParameterComponent)t));
        }
        return tgt;
    }

    private static OperationDefinition.OperationParameterUse convertOperationParameterUse(OperationDefinition.OperationParameterUse src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case IN: {
                return OperationDefinition.OperationParameterUse.IN;
            }
            case OUT: {
                return OperationDefinition.OperationParameterUse.OUT;
            }
        }
        return OperationDefinition.OperationParameterUse.NULL;
    }

    private static OperationDefinition.OperationParameterUse convertOperationParameterUse(OperationDefinition.OperationParameterUse src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case IN: {
                return OperationDefinition.OperationParameterUse.IN;
            }
            case OUT: {
                return OperationDefinition.OperationParameterUse.OUT;
            }
        }
        return OperationDefinition.OperationParameterUse.NULL;
    }

    public static OperationDefinition.OperationDefinitionParameterBindingComponent convertOperationDefinitionParameterBindingComponent(OperationDefinition.OperationDefinitionParameterBindingComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        OperationDefinition.OperationDefinitionParameterBindingComponent tgt = new OperationDefinition.OperationDefinitionParameterBindingComponent();
        VersionConvertor_14_40.copyElement((org.hl7.fhir.dstu2016may.model.Element)src, (Element)tgt);
        tgt.setStrength(VersionConvertor_14_40.convertBindingStrength(src.getStrength()));
        tgt.setValueSet((Type)(src.getValueSet() instanceof org.hl7.fhir.dstu2016may.model.Reference ? VersionConvertor_14_40.convertReferenceToCanonical((org.hl7.fhir.dstu2016may.model.Reference)src.getValueSet()) : VersionConvertor_14_40.convertType(src.getValueSet())));
        return tgt;
    }

    public static OperationDefinition.OperationDefinitionParameterBindingComponent convertOperationDefinitionParameterBindingComponent(OperationDefinition.OperationDefinitionParameterBindingComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        OperationDefinition.OperationDefinitionParameterBindingComponent tgt = new OperationDefinition.OperationDefinitionParameterBindingComponent();
        VersionConvertor_14_40.copyElement((Element)src, (org.hl7.fhir.dstu2016may.model.Element)tgt);
        tgt.setStrength(VersionConvertor_14_40.convertBindingStrength(src.getStrength()));
        tgt.setValueSet((org.hl7.fhir.dstu2016may.model.Type)(src.getValueSet() instanceof CanonicalType ? VersionConvertor_14_40.convertCanonicalToReference((CanonicalType)src.getValueSet()) : VersionConvertor_14_40.convertType(src.getValueSet())));
        return tgt;
    }

    public static org.hl7.fhir.r4.model.OperationOutcome convertOperationOutcome(OperationOutcome src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r4.model.OperationOutcome tgt = new org.hl7.fhir.r4.model.OperationOutcome();
        VersionConvertor_14_40.copyDomainResource((DomainResource)src, (org.hl7.fhir.r4.model.DomainResource)tgt);
        for (OperationOutcome.OperationOutcomeIssueComponent t : src.getIssue()) {
            tgt.addIssue(VersionConvertor_14_40.convertOperationOutcomeIssueComponent(t));
        }
        return tgt;
    }

    public static OperationOutcome convertOperationOutcome(org.hl7.fhir.r4.model.OperationOutcome src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        OperationOutcome tgt = new OperationOutcome();
        VersionConvertor_14_40.copyDomainResource((org.hl7.fhir.r4.model.DomainResource)src, (DomainResource)tgt);
        for (OperationOutcome.OperationOutcomeIssueComponent t : src.getIssue()) {
            tgt.addIssue(VersionConvertor_14_40.convertOperationOutcomeIssueComponent(t));
        }
        return tgt;
    }

    public static OperationOutcome.OperationOutcomeIssueComponent convertOperationOutcomeIssueComponent(OperationOutcome.OperationOutcomeIssueComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        OperationOutcome.OperationOutcomeIssueComponent tgt = new OperationOutcome.OperationOutcomeIssueComponent();
        VersionConvertor_14_40.copyElement((org.hl7.fhir.dstu2016may.model.Element)src, (Element)tgt);
        tgt.setSeverity(VersionConvertor_14_40.convertIssueSeverity(src.getSeverity()));
        tgt.setCode(VersionConvertor_14_40.convertIssueType(src.getCode()));
        tgt.setDetails(VersionConvertor_14_40.convertCodeableConcept(src.getDetails()));
        if (src.hasDiagnostics()) {
            tgt.setDiagnostics(src.getDiagnostics());
        }
        for (org.hl7.fhir.dstu2016may.model.StringType t : src.getLocation()) {
            tgt.addLocation((String)t.getValue());
        }
        for (org.hl7.fhir.dstu2016may.model.StringType t : src.getExpression()) {
            tgt.addExpression((String)t.getValue());
        }
        return tgt;
    }

    public static OperationOutcome.OperationOutcomeIssueComponent convertOperationOutcomeIssueComponent(OperationOutcome.OperationOutcomeIssueComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        OperationOutcome.OperationOutcomeIssueComponent tgt = new OperationOutcome.OperationOutcomeIssueComponent();
        VersionConvertor_14_40.copyElement((Element)src, (org.hl7.fhir.dstu2016may.model.Element)tgt);
        tgt.setSeverity(VersionConvertor_14_40.convertIssueSeverity(src.getSeverity()));
        tgt.setCode(VersionConvertor_14_40.convertIssueType(src.getCode()));
        tgt.setDetails(VersionConvertor_14_40.convertCodeableConcept(src.getDetails()));
        if (src.hasDiagnostics()) {
            tgt.setDiagnostics(src.getDiagnostics());
        }
        for (StringType t : src.getLocation()) {
            tgt.addLocation((String)t.getValue());
        }
        for (StringType t : src.getExpression()) {
            tgt.addExpression((String)t.getValue());
        }
        return tgt;
    }

    private static OperationOutcome.IssueSeverity convertIssueSeverity(OperationOutcome.IssueSeverity src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case FATAL: {
                return OperationOutcome.IssueSeverity.FATAL;
            }
            case ERROR: {
                return OperationOutcome.IssueSeverity.ERROR;
            }
            case WARNING: {
                return OperationOutcome.IssueSeverity.WARNING;
            }
            case INFORMATION: {
                return OperationOutcome.IssueSeverity.INFORMATION;
            }
        }
        return OperationOutcome.IssueSeverity.NULL;
    }

    private static OperationOutcome.IssueSeverity convertIssueSeverity(OperationOutcome.IssueSeverity src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case FATAL: {
                return OperationOutcome.IssueSeverity.FATAL;
            }
            case ERROR: {
                return OperationOutcome.IssueSeverity.ERROR;
            }
            case WARNING: {
                return OperationOutcome.IssueSeverity.WARNING;
            }
            case INFORMATION: {
                return OperationOutcome.IssueSeverity.INFORMATION;
            }
        }
        return OperationOutcome.IssueSeverity.NULL;
    }

    private static OperationOutcome.IssueType convertIssueType(OperationOutcome.IssueType src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case INVALID: {
                return OperationOutcome.IssueType.INVALID;
            }
            case STRUCTURE: {
                return OperationOutcome.IssueType.STRUCTURE;
            }
            case REQUIRED: {
                return OperationOutcome.IssueType.REQUIRED;
            }
            case VALUE: {
                return OperationOutcome.IssueType.VALUE;
            }
            case INVARIANT: {
                return OperationOutcome.IssueType.INVARIANT;
            }
            case SECURITY: {
                return OperationOutcome.IssueType.SECURITY;
            }
            case LOGIN: {
                return OperationOutcome.IssueType.LOGIN;
            }
            case UNKNOWN: {
                return OperationOutcome.IssueType.UNKNOWN;
            }
            case EXPIRED: {
                return OperationOutcome.IssueType.EXPIRED;
            }
            case FORBIDDEN: {
                return OperationOutcome.IssueType.FORBIDDEN;
            }
            case SUPPRESSED: {
                return OperationOutcome.IssueType.SUPPRESSED;
            }
            case PROCESSING: {
                return OperationOutcome.IssueType.PROCESSING;
            }
            case NOTSUPPORTED: {
                return OperationOutcome.IssueType.NOTSUPPORTED;
            }
            case DUPLICATE: {
                return OperationOutcome.IssueType.DUPLICATE;
            }
            case NOTFOUND: {
                return OperationOutcome.IssueType.NOTFOUND;
            }
            case TOOLONG: {
                return OperationOutcome.IssueType.TOOLONG;
            }
            case CODEINVALID: {
                return OperationOutcome.IssueType.CODEINVALID;
            }
            case EXTENSION: {
                return OperationOutcome.IssueType.EXTENSION;
            }
            case TOOCOSTLY: {
                return OperationOutcome.IssueType.TOOCOSTLY;
            }
            case BUSINESSRULE: {
                return OperationOutcome.IssueType.BUSINESSRULE;
            }
            case CONFLICT: {
                return OperationOutcome.IssueType.CONFLICT;
            }
            case INCOMPLETE: {
                return OperationOutcome.IssueType.INCOMPLETE;
            }
            case TRANSIENT: {
                return OperationOutcome.IssueType.TRANSIENT;
            }
            case LOCKERROR: {
                return OperationOutcome.IssueType.LOCKERROR;
            }
            case NOSTORE: {
                return OperationOutcome.IssueType.NOSTORE;
            }
            case EXCEPTION: {
                return OperationOutcome.IssueType.EXCEPTION;
            }
            case TIMEOUT: {
                return OperationOutcome.IssueType.TIMEOUT;
            }
            case THROTTLED: {
                return OperationOutcome.IssueType.THROTTLED;
            }
            case INFORMATIONAL: {
                return OperationOutcome.IssueType.INFORMATIONAL;
            }
        }
        return OperationOutcome.IssueType.NULL;
    }

    private static OperationOutcome.IssueType convertIssueType(OperationOutcome.IssueType src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case INVALID: {
                return OperationOutcome.IssueType.INVALID;
            }
            case STRUCTURE: {
                return OperationOutcome.IssueType.STRUCTURE;
            }
            case REQUIRED: {
                return OperationOutcome.IssueType.REQUIRED;
            }
            case VALUE: {
                return OperationOutcome.IssueType.VALUE;
            }
            case INVARIANT: {
                return OperationOutcome.IssueType.INVARIANT;
            }
            case SECURITY: {
                return OperationOutcome.IssueType.SECURITY;
            }
            case LOGIN: {
                return OperationOutcome.IssueType.LOGIN;
            }
            case UNKNOWN: {
                return OperationOutcome.IssueType.UNKNOWN;
            }
            case EXPIRED: {
                return OperationOutcome.IssueType.EXPIRED;
            }
            case FORBIDDEN: {
                return OperationOutcome.IssueType.FORBIDDEN;
            }
            case SUPPRESSED: {
                return OperationOutcome.IssueType.SUPPRESSED;
            }
            case PROCESSING: {
                return OperationOutcome.IssueType.PROCESSING;
            }
            case NOTSUPPORTED: {
                return OperationOutcome.IssueType.NOTSUPPORTED;
            }
            case DUPLICATE: {
                return OperationOutcome.IssueType.DUPLICATE;
            }
            case NOTFOUND: {
                return OperationOutcome.IssueType.NOTFOUND;
            }
            case TOOLONG: {
                return OperationOutcome.IssueType.TOOLONG;
            }
            case CODEINVALID: {
                return OperationOutcome.IssueType.CODEINVALID;
            }
            case EXTENSION: {
                return OperationOutcome.IssueType.EXTENSION;
            }
            case TOOCOSTLY: {
                return OperationOutcome.IssueType.TOOCOSTLY;
            }
            case BUSINESSRULE: {
                return OperationOutcome.IssueType.BUSINESSRULE;
            }
            case CONFLICT: {
                return OperationOutcome.IssueType.CONFLICT;
            }
            case INCOMPLETE: {
                return OperationOutcome.IssueType.INCOMPLETE;
            }
            case TRANSIENT: {
                return OperationOutcome.IssueType.TRANSIENT;
            }
            case LOCKERROR: {
                return OperationOutcome.IssueType.LOCKERROR;
            }
            case NOSTORE: {
                return OperationOutcome.IssueType.NOSTORE;
            }
            case EXCEPTION: {
                return OperationOutcome.IssueType.EXCEPTION;
            }
            case TIMEOUT: {
                return OperationOutcome.IssueType.TIMEOUT;
            }
            case THROTTLED: {
                return OperationOutcome.IssueType.THROTTLED;
            }
            case INFORMATIONAL: {
                return OperationOutcome.IssueType.INFORMATIONAL;
            }
        }
        return OperationOutcome.IssueType.NULL;
    }

    public static org.hl7.fhir.r4.model.Questionnaire convertQuestionnaire(Questionnaire src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r4.model.Questionnaire tgt = new org.hl7.fhir.r4.model.Questionnaire();
        VersionConvertor_14_40.copyDomainResource((DomainResource)src, (org.hl7.fhir.r4.model.DomainResource)tgt);
        if (src.hasUrl()) {
            tgt.setUrl(src.getUrl());
        }
        for (org.hl7.fhir.dstu2016may.model.Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_14_40.convertIdentifier(t));
        }
        if (src.hasVersion()) {
            tgt.setVersion(src.getVersion());
        }
        tgt.setStatus(VersionConvertor_14_40.convertQuestionnaireStatus(src.getStatus()));
        if (src.hasDate()) {
            tgt.setDate(src.getDate());
        }
        if (src.hasPublisher()) {
            tgt.setPublisher(src.getPublisher());
        }
        for (org.hl7.fhir.dstu2016may.model.Identifier t : src.getTelecom()) {
            tgt.addContact(VersionConvertor_14_40.convertQuestionnaireContactComponent((org.hl7.fhir.dstu2016may.model.ContactPoint)t));
        }
        for (org.hl7.fhir.dstu2016may.model.Identifier t : src.getUseContext()) {
            if (VersionConvertor_14_40.isJurisdiction((CodeableConcept)t)) {
                tgt.addJurisdiction(VersionConvertor_14_40.convertCodeableConcept((CodeableConcept)t));
                continue;
            }
            tgt.addUseContext(VersionConvertor_14_40.convertCodeableConceptToUsageContext((CodeableConcept)t));
        }
        if (src.hasTitle()) {
            tgt.setTitle(src.getTitle());
        }
        for (org.hl7.fhir.dstu2016may.model.Identifier t : src.getConcept()) {
            tgt.addCode(VersionConvertor_14_40.convertCoding((org.hl7.fhir.dstu2016may.model.Coding)t));
        }
        for (org.hl7.fhir.dstu2016may.model.Identifier t : src.getSubjectType()) {
            tgt.addSubjectType((String)t.getValue());
        }
        for (org.hl7.fhir.dstu2016may.model.Identifier t : src.getItem()) {
            tgt.addItem(VersionConvertor_14_40.convertQuestionnaireItemComponent((Questionnaire.QuestionnaireItemComponent)t));
        }
        return tgt;
    }

    public static Questionnaire convertQuestionnaire(org.hl7.fhir.r4.model.Questionnaire src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Questionnaire tgt = new Questionnaire();
        VersionConvertor_14_40.copyDomainResource((org.hl7.fhir.r4.model.DomainResource)src, (DomainResource)tgt);
        if (src.hasUrl()) {
            tgt.setUrl(src.getUrl());
        }
        for (Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_14_40.convertIdentifier(t));
        }
        if (src.hasVersion()) {
            tgt.setVersion(src.getVersion());
        }
        tgt.setStatus(VersionConvertor_14_40.convertQuestionnaireStatus(src.getStatus()));
        if (src.hasDate()) {
            tgt.setDate(src.getDate());
        }
        if (src.hasPublisher()) {
            tgt.setPublisher(src.getPublisher());
        }
        for (Identifier t : src.getContact()) {
            for (ContactPoint t1 : t.getTelecom()) {
                tgt.addTelecom(VersionConvertor_14_40.convertContactPoint(t1));
            }
        }
        for (Identifier t : src.getUseContext()) {
            tgt.addUseContext(VersionConvertor_14_40.convertCodeableConcept(t.getValueCodeableConcept()));
        }
        for (Identifier t : src.getJurisdiction()) {
            tgt.addUseContext(VersionConvertor_14_40.convertCodeableConcept((org.hl7.fhir.r4.model.CodeableConcept)t));
        }
        if (src.hasTitle()) {
            tgt.setTitle(src.getTitle());
        }
        for (Identifier t : src.getCode()) {
            tgt.addConcept(VersionConvertor_14_40.convertCoding((Coding)t));
        }
        for (Identifier t : src.getSubjectType()) {
            tgt.addSubjectType((String)t.getValue());
        }
        for (Identifier t : src.getItem()) {
            tgt.addItem(VersionConvertor_14_40.convertQuestionnaireItemComponent((Questionnaire.QuestionnaireItemComponent)t));
        }
        return tgt;
    }

    public static ContactDetail convertQuestionnaireContactComponent(org.hl7.fhir.dstu2016may.model.ContactPoint src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ContactDetail tgt = new ContactDetail();
        VersionConvertor_14_40.copyElement((org.hl7.fhir.dstu2016may.model.Element)src, (Element)tgt);
        tgt.addTelecom(VersionConvertor_14_40.convertContactPoint(src));
        return tgt;
    }

    private static Enumerations.PublicationStatus convertQuestionnaireStatus(Questionnaire.QuestionnaireStatus src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case DRAFT: {
                return Enumerations.PublicationStatus.DRAFT;
            }
            case PUBLISHED: {
                return Enumerations.PublicationStatus.ACTIVE;
            }
            case RETIRED: {
                return Enumerations.PublicationStatus.RETIRED;
            }
        }
        return Enumerations.PublicationStatus.NULL;
    }

    private static Questionnaire.QuestionnaireStatus convertQuestionnaireStatus(Enumerations.PublicationStatus src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case DRAFT: {
                return Questionnaire.QuestionnaireStatus.DRAFT;
            }
            case ACTIVE: {
                return Questionnaire.QuestionnaireStatus.PUBLISHED;
            }
            case RETIRED: {
                return Questionnaire.QuestionnaireStatus.RETIRED;
            }
        }
        return Questionnaire.QuestionnaireStatus.NULL;
    }

    public static Questionnaire.QuestionnaireItemComponent convertQuestionnaireItemComponent(Questionnaire.QuestionnaireItemComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Questionnaire.QuestionnaireItemComponent tgt = new Questionnaire.QuestionnaireItemComponent();
        VersionConvertor_14_40.copyElement((org.hl7.fhir.dstu2016may.model.Element)src, (Element)tgt);
        if (src.hasLinkId()) {
            tgt.setLinkId(src.getLinkId());
        }
        for (org.hl7.fhir.dstu2016may.model.Coding t : src.getConcept()) {
            tgt.addCode(VersionConvertor_14_40.convertCoding(t));
        }
        if (src.hasPrefix()) {
            tgt.setPrefix(src.getPrefix());
        }
        if (src.hasText()) {
            tgt.setText(src.getText());
        }
        tgt.setType(VersionConvertor_14_40.convertQuestionnaireItemType(src.getType()));
        for (org.hl7.fhir.dstu2016may.model.Coding t : src.getEnableWhen()) {
            tgt.addEnableWhen(VersionConvertor_14_40.convertQuestionnaireItemEnableWhenComponent((Questionnaire.QuestionnaireItemEnableWhenComponent)t));
        }
        if (src.hasRequired()) {
            tgt.setRequired(src.getRequired());
        }
        if (src.hasRepeats()) {
            tgt.setRepeats(src.getRepeats());
        }
        if (src.hasReadOnly()) {
            tgt.setReadOnly(src.getReadOnly());
        }
        if (src.hasMaxLength()) {
            tgt.setMaxLength(src.getMaxLength());
        }
        tgt.setOptionsElement(VersionConvertor_14_40.convertReferenceToCanonical(src.getOptions()));
        for (org.hl7.fhir.dstu2016may.model.Coding t : src.getOption()) {
            tgt.addOption(VersionConvertor_14_40.convertQuestionnaireItemOptionComponent((Questionnaire.QuestionnaireItemOptionComponent)t));
        }
        tgt.addInitial().setValue(VersionConvertor_14_40.convertType(src.getInitial()));
        for (org.hl7.fhir.dstu2016may.model.Coding t : src.getItem()) {
            tgt.addItem(VersionConvertor_14_40.convertQuestionnaireItemComponent((Questionnaire.QuestionnaireItemComponent)t));
        }
        return tgt;
    }

    public static Questionnaire.QuestionnaireItemComponent convertQuestionnaireItemComponent(Questionnaire.QuestionnaireItemComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Questionnaire.QuestionnaireItemComponent tgt = new Questionnaire.QuestionnaireItemComponent();
        VersionConvertor_14_40.copyElement((Element)src, (org.hl7.fhir.dstu2016may.model.Element)tgt);
        if (src.hasLinkId()) {
            tgt.setLinkId(src.getLinkId());
        }
        for (Coding t : src.getCode()) {
            tgt.addConcept(VersionConvertor_14_40.convertCoding(t));
        }
        if (src.hasPrefix()) {
            tgt.setPrefix(src.getPrefix());
        }
        if (src.hasText()) {
            tgt.setText(src.getText());
        }
        tgt.setType(VersionConvertor_14_40.convertQuestionnaireItemType(src.getType()));
        for (Coding t : src.getEnableWhen()) {
            tgt.addEnableWhen(VersionConvertor_14_40.convertQuestionnaireItemEnableWhenComponent((Questionnaire.QuestionnaireItemEnableWhenComponent)t));
        }
        if (src.hasRequired()) {
            tgt.setRequired(src.getRequired());
        }
        if (src.hasRepeats()) {
            tgt.setRepeats(src.getRepeats());
        }
        if (src.hasReadOnly()) {
            tgt.setReadOnly(src.getReadOnly());
        }
        if (src.hasMaxLength()) {
            tgt.setMaxLength(src.getMaxLength());
        }
        tgt.setOptions(VersionConvertor_14_40.convertCanonicalToReference(src.getOptionsElement()));
        for (Coding t : src.getOption()) {
            tgt.addOption(VersionConvertor_14_40.convertQuestionnaireItemOptionComponent((Questionnaire.QuestionnaireItemOptionComponent)t));
        }
        if (src.hasInitial()) {
            tgt.setInitial(VersionConvertor_14_40.convertType(src.getInitialFirstRep().getValue()));
        }
        for (Coding t : src.getItem()) {
            tgt.addItem(VersionConvertor_14_40.convertQuestionnaireItemComponent((Questionnaire.QuestionnaireItemComponent)t));
        }
        return tgt;
    }

    private static Questionnaire.QuestionnaireItemType convertQuestionnaireItemType(Questionnaire.QuestionnaireItemType src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case GROUP: {
                return Questionnaire.QuestionnaireItemType.GROUP;
            }
            case DISPLAY: {
                return Questionnaire.QuestionnaireItemType.DISPLAY;
            }
            case QUESTION: {
                return Questionnaire.QuestionnaireItemType.QUESTION;
            }
            case BOOLEAN: {
                return Questionnaire.QuestionnaireItemType.BOOLEAN;
            }
            case DECIMAL: {
                return Questionnaire.QuestionnaireItemType.DECIMAL;
            }
            case INTEGER: {
                return Questionnaire.QuestionnaireItemType.INTEGER;
            }
            case DATE: {
                return Questionnaire.QuestionnaireItemType.DATE;
            }
            case DATETIME: {
                return Questionnaire.QuestionnaireItemType.DATETIME;
            }
            case INSTANT: {
                return Questionnaire.QuestionnaireItemType.DATETIME;
            }
            case TIME: {
                return Questionnaire.QuestionnaireItemType.TIME;
            }
            case STRING: {
                return Questionnaire.QuestionnaireItemType.STRING;
            }
            case TEXT: {
                return Questionnaire.QuestionnaireItemType.TEXT;
            }
            case URL: {
                return Questionnaire.QuestionnaireItemType.URL;
            }
            case CHOICE: {
                return Questionnaire.QuestionnaireItemType.CHOICE;
            }
            case OPENCHOICE: {
                return Questionnaire.QuestionnaireItemType.OPENCHOICE;
            }
            case ATTACHMENT: {
                return Questionnaire.QuestionnaireItemType.ATTACHMENT;
            }
            case REFERENCE: {
                return Questionnaire.QuestionnaireItemType.REFERENCE;
            }
            case QUANTITY: {
                return Questionnaire.QuestionnaireItemType.QUANTITY;
            }
        }
        return Questionnaire.QuestionnaireItemType.NULL;
    }

    private static Questionnaire.QuestionnaireItemType convertQuestionnaireItemType(Questionnaire.QuestionnaireItemType src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case GROUP: {
                return Questionnaire.QuestionnaireItemType.GROUP;
            }
            case DISPLAY: {
                return Questionnaire.QuestionnaireItemType.DISPLAY;
            }
            case QUESTION: {
                return Questionnaire.QuestionnaireItemType.QUESTION;
            }
            case BOOLEAN: {
                return Questionnaire.QuestionnaireItemType.BOOLEAN;
            }
            case DECIMAL: {
                return Questionnaire.QuestionnaireItemType.DECIMAL;
            }
            case INTEGER: {
                return Questionnaire.QuestionnaireItemType.INTEGER;
            }
            case DATE: {
                return Questionnaire.QuestionnaireItemType.DATE;
            }
            case DATETIME: {
                return Questionnaire.QuestionnaireItemType.DATETIME;
            }
            case TIME: {
                return Questionnaire.QuestionnaireItemType.TIME;
            }
            case STRING: {
                return Questionnaire.QuestionnaireItemType.STRING;
            }
            case TEXT: {
                return Questionnaire.QuestionnaireItemType.TEXT;
            }
            case URL: {
                return Questionnaire.QuestionnaireItemType.URL;
            }
            case CHOICE: {
                return Questionnaire.QuestionnaireItemType.CHOICE;
            }
            case OPENCHOICE: {
                return Questionnaire.QuestionnaireItemType.OPENCHOICE;
            }
            case ATTACHMENT: {
                return Questionnaire.QuestionnaireItemType.ATTACHMENT;
            }
            case REFERENCE: {
                return Questionnaire.QuestionnaireItemType.REFERENCE;
            }
            case QUANTITY: {
                return Questionnaire.QuestionnaireItemType.QUANTITY;
            }
        }
        return Questionnaire.QuestionnaireItemType.NULL;
    }

    public static Questionnaire.QuestionnaireItemEnableWhenComponent convertQuestionnaireItemEnableWhenComponent(Questionnaire.QuestionnaireItemEnableWhenComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Questionnaire.QuestionnaireItemEnableWhenComponent tgt = new Questionnaire.QuestionnaireItemEnableWhenComponent();
        VersionConvertor_14_40.copyElement((org.hl7.fhir.dstu2016may.model.Element)src, (Element)tgt);
        tgt.setQuestion(src.getQuestion());
        if (src.hasAnswered()) {
            tgt.setOperator(Questionnaire.QuestionnaireItemOperator.EXISTS);
            tgt.setAnswer(VersionConvertor_14_40.convertType((org.hl7.fhir.dstu2016may.model.Type)src.getAnsweredElement()));
        }
        tgt.setAnswer(VersionConvertor_14_40.convertType(src.getAnswer()));
        return tgt;
    }

    public static Questionnaire.QuestionnaireItemEnableWhenComponent convertQuestionnaireItemEnableWhenComponent(Questionnaire.QuestionnaireItemEnableWhenComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Questionnaire.QuestionnaireItemEnableWhenComponent tgt = new Questionnaire.QuestionnaireItemEnableWhenComponent();
        VersionConvertor_14_40.copyElement((Element)src, (org.hl7.fhir.dstu2016may.model.Element)tgt);
        tgt.setQuestion(src.getQuestion());
        if (src.hasOperator() && src.getOperator() == Questionnaire.QuestionnaireItemOperator.EXISTS) {
            tgt.setAnswered(((Boolean)src.getAnswerBooleanType().getValue()).booleanValue());
        } else {
            tgt.setAnswer(VersionConvertor_14_40.convertType(src.getAnswer()));
        }
        return tgt;
    }

    public static Questionnaire.QuestionnaireItemOptionComponent convertQuestionnaireItemOptionComponent(Questionnaire.QuestionnaireItemOptionComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Questionnaire.QuestionnaireItemOptionComponent tgt = new Questionnaire.QuestionnaireItemOptionComponent();
        VersionConvertor_14_40.copyElement((org.hl7.fhir.dstu2016may.model.Element)src, (Element)tgt);
        tgt.setValue(VersionConvertor_14_40.convertType(src.getValue()));
        return tgt;
    }

    public static Questionnaire.QuestionnaireItemOptionComponent convertQuestionnaireItemOptionComponent(Questionnaire.QuestionnaireItemOptionComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Questionnaire.QuestionnaireItemOptionComponent tgt = new Questionnaire.QuestionnaireItemOptionComponent();
        VersionConvertor_14_40.copyElement((Element)src, (org.hl7.fhir.dstu2016may.model.Element)tgt);
        tgt.setValue(VersionConvertor_14_40.convertType(src.getValue()));
        return tgt;
    }

    public static QuestionnaireResponse convertQuestionnaireResponse(org.hl7.fhir.dstu2016may.model.QuestionnaireResponse src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        QuestionnaireResponse tgt = new QuestionnaireResponse();
        VersionConvertor_14_40.copyDomainResource((DomainResource)src, (org.hl7.fhir.r4.model.DomainResource)tgt);
        tgt.setIdentifier(VersionConvertor_14_40.convertIdentifier(src.getIdentifier()));
        tgt.setQuestionnaireElement(VersionConvertor_14_40.convertReferenceToCanonical(src.getQuestionnaire()));
        tgt.setStatus(VersionConvertor_14_40.convertQuestionnaireResponseStatus(src.getStatus()));
        tgt.setSubject(VersionConvertor_14_40.convertReference(src.getSubject()));
        tgt.setContext(VersionConvertor_14_40.convertReference(src.getEncounter()));
        tgt.setAuthor(VersionConvertor_14_40.convertReference(src.getAuthor()));
        if (src.hasAuthored()) {
            tgt.setAuthored(src.getAuthored());
        }
        tgt.setSource(VersionConvertor_14_40.convertReference(src.getSource()));
        for (QuestionnaireResponse.QuestionnaireResponseItemComponent t : src.getItem()) {
            tgt.addItem(VersionConvertor_14_40.convertQuestionnaireResponseItemComponent(t));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu2016may.model.QuestionnaireResponse convertQuestionnaireResponse(QuestionnaireResponse src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2016may.model.QuestionnaireResponse tgt = new org.hl7.fhir.dstu2016may.model.QuestionnaireResponse();
        VersionConvertor_14_40.copyDomainResource((org.hl7.fhir.r4.model.DomainResource)src, (DomainResource)tgt);
        tgt.setIdentifier(VersionConvertor_14_40.convertIdentifier(src.getIdentifier()));
        tgt.setQuestionnaire(VersionConvertor_14_40.convertCanonicalToReference(src.getQuestionnaireElement()));
        tgt.setStatus(VersionConvertor_14_40.convertQuestionnaireResponseStatus(src.getStatus()));
        tgt.setSubject(VersionConvertor_14_40.convertReference(src.getSubject()));
        tgt.setEncounter(VersionConvertor_14_40.convertReference(src.getContext()));
        tgt.setAuthor(VersionConvertor_14_40.convertReference(src.getAuthor()));
        if (src.hasAuthored()) {
            tgt.setAuthored(src.getAuthored());
        }
        tgt.setSource(VersionConvertor_14_40.convertReference(src.getSource()));
        for (QuestionnaireResponse.QuestionnaireResponseItemComponent t : src.getItem()) {
            tgt.addItem(VersionConvertor_14_40.convertQuestionnaireResponseItemComponent(t));
        }
        return tgt;
    }

    private static QuestionnaireResponse.QuestionnaireResponseStatus convertQuestionnaireResponseStatus(QuestionnaireResponse.QuestionnaireResponseStatus src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case INPROGRESS: {
                return QuestionnaireResponse.QuestionnaireResponseStatus.INPROGRESS;
            }
            case COMPLETED: {
                return QuestionnaireResponse.QuestionnaireResponseStatus.COMPLETED;
            }
            case AMENDED: {
                return QuestionnaireResponse.QuestionnaireResponseStatus.AMENDED;
            }
        }
        return QuestionnaireResponse.QuestionnaireResponseStatus.NULL;
    }

    private static QuestionnaireResponse.QuestionnaireResponseStatus convertQuestionnaireResponseStatus(QuestionnaireResponse.QuestionnaireResponseStatus src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case INPROGRESS: {
                return QuestionnaireResponse.QuestionnaireResponseStatus.INPROGRESS;
            }
            case COMPLETED: {
                return QuestionnaireResponse.QuestionnaireResponseStatus.COMPLETED;
            }
            case AMENDED: {
                return QuestionnaireResponse.QuestionnaireResponseStatus.AMENDED;
            }
        }
        return QuestionnaireResponse.QuestionnaireResponseStatus.NULL;
    }

    public static QuestionnaireResponse.QuestionnaireResponseItemComponent convertQuestionnaireResponseItemComponent(QuestionnaireResponse.QuestionnaireResponseItemComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        QuestionnaireResponse.QuestionnaireResponseItemComponent tgt = new QuestionnaireResponse.QuestionnaireResponseItemComponent();
        VersionConvertor_14_40.copyElement((org.hl7.fhir.dstu2016may.model.Element)src, (Element)tgt);
        if (src.hasLinkId()) {
            tgt.setLinkId(src.getLinkId());
        }
        if (src.hasText()) {
            tgt.setText(src.getText());
        }
        tgt.setSubject(VersionConvertor_14_40.convertReference(src.getSubject()));
        for (QuestionnaireResponse.QuestionnaireResponseItemAnswerComponent t : src.getAnswer()) {
            tgt.addAnswer(VersionConvertor_14_40.convertQuestionnaireResponseItemAnswerComponent(t));
        }
        for (QuestionnaireResponse.QuestionnaireResponseItemAnswerComponent t : src.getItem()) {
            tgt.addItem(VersionConvertor_14_40.convertQuestionnaireResponseItemComponent((QuestionnaireResponse.QuestionnaireResponseItemComponent)t));
        }
        return tgt;
    }

    public static QuestionnaireResponse.QuestionnaireResponseItemComponent convertQuestionnaireResponseItemComponent(QuestionnaireResponse.QuestionnaireResponseItemComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        QuestionnaireResponse.QuestionnaireResponseItemComponent tgt = new QuestionnaireResponse.QuestionnaireResponseItemComponent();
        VersionConvertor_14_40.copyElement((Element)src, (org.hl7.fhir.dstu2016may.model.Element)tgt);
        if (src.hasLinkId()) {
            tgt.setLinkId(src.getLinkId());
        }
        if (src.hasText()) {
            tgt.setText(src.getText());
        }
        tgt.setSubject(VersionConvertor_14_40.convertReference(src.getSubject()));
        for (QuestionnaireResponse.QuestionnaireResponseItemAnswerComponent t : src.getAnswer()) {
            tgt.addAnswer(VersionConvertor_14_40.convertQuestionnaireResponseItemAnswerComponent(t));
        }
        for (QuestionnaireResponse.QuestionnaireResponseItemAnswerComponent t : src.getItem()) {
            tgt.addItem(VersionConvertor_14_40.convertQuestionnaireResponseItemComponent((QuestionnaireResponse.QuestionnaireResponseItemComponent)t));
        }
        return tgt;
    }

    public static QuestionnaireResponse.QuestionnaireResponseItemAnswerComponent convertQuestionnaireResponseItemAnswerComponent(QuestionnaireResponse.QuestionnaireResponseItemAnswerComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        QuestionnaireResponse.QuestionnaireResponseItemAnswerComponent tgt = new QuestionnaireResponse.QuestionnaireResponseItemAnswerComponent();
        VersionConvertor_14_40.copyElement((org.hl7.fhir.dstu2016may.model.Element)src, (Element)tgt);
        tgt.setValue(VersionConvertor_14_40.convertType(src.getValue()));
        for (QuestionnaireResponse.QuestionnaireResponseItemComponent t : src.getItem()) {
            tgt.addItem(VersionConvertor_14_40.convertQuestionnaireResponseItemComponent(t));
        }
        return tgt;
    }

    public static QuestionnaireResponse.QuestionnaireResponseItemAnswerComponent convertQuestionnaireResponseItemAnswerComponent(QuestionnaireResponse.QuestionnaireResponseItemAnswerComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        QuestionnaireResponse.QuestionnaireResponseItemAnswerComponent tgt = new QuestionnaireResponse.QuestionnaireResponseItemAnswerComponent();
        VersionConvertor_14_40.copyElement((Element)src, (org.hl7.fhir.dstu2016may.model.Element)tgt);
        tgt.setValue(VersionConvertor_14_40.convertType(src.getValue()));
        for (QuestionnaireResponse.QuestionnaireResponseItemComponent t : src.getItem()) {
            tgt.addItem(VersionConvertor_14_40.convertQuestionnaireResponseItemComponent(t));
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.SearchParameter convertSearchParameter(SearchParameter src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r4.model.SearchParameter tgt = new org.hl7.fhir.r4.model.SearchParameter();
        VersionConvertor_14_40.copyDomainResource((DomainResource)src, (org.hl7.fhir.r4.model.DomainResource)tgt);
        tgt.setUrl(src.getUrl());
        tgt.setName(src.getName());
        tgt.setStatus(VersionConvertor_14_40.convertConformanceResourceStatus(src.getStatus()));
        if (src.hasExperimental()) {
            tgt.setExperimental(src.getExperimental());
        }
        if (src.hasDate()) {
            tgt.setDate(src.getDate());
        }
        if (src.hasPublisher()) {
            tgt.setPublisher(src.getPublisher());
        }
        for (SearchParameter.SearchParameterContactComponent t : src.getContact()) {
            tgt.addContact(VersionConvertor_14_40.convertSearchParameterContactComponent(t));
        }
        for (SearchParameter.SearchParameterContactComponent t : src.getUseContext()) {
            if (VersionConvertor_14_40.isJurisdiction((CodeableConcept)t)) {
                tgt.addJurisdiction(VersionConvertor_14_40.convertCodeableConcept((CodeableConcept)t));
                continue;
            }
            tgt.addUseContext(VersionConvertor_14_40.convertCodeableConceptToUsageContext((CodeableConcept)t));
        }
        if (src.hasRequirements()) {
            tgt.setPurpose(src.getRequirements());
        }
        tgt.setCode(src.getCode());
        tgt.addBase(src.getBase());
        tgt.setType(VersionConvertor_14_40.convertSearchParamType(src.getType()));
        tgt.setDescription(src.getDescription());
        if (src.hasExpression()) {
            tgt.setExpression(src.getExpression());
        }
        if (src.hasXpath()) {
            tgt.setXpath(src.getXpath());
        }
        tgt.setXpathUsage(VersionConvertor_14_40.convertXPathUsageType(src.getXpathUsage()));
        for (SearchParameter.SearchParameterContactComponent t : src.getTarget()) {
            tgt.addTarget((String)t.getValue());
        }
        return tgt;
    }

    public static SearchParameter convertSearchParameter(org.hl7.fhir.r4.model.SearchParameter src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        SearchParameter tgt = new SearchParameter();
        VersionConvertor_14_40.copyDomainResource((org.hl7.fhir.r4.model.DomainResource)src, (DomainResource)tgt);
        tgt.setUrl(src.getUrl());
        tgt.setName(src.getName());
        tgt.setStatus(VersionConvertor_14_40.convertConformanceResourceStatus(src.getStatus()));
        if (src.hasExperimental()) {
            tgt.setExperimental(src.getExperimental());
        }
        if (src.hasDate()) {
            tgt.setDate(src.getDate());
        }
        if (src.hasPublisher()) {
            tgt.setPublisher(src.getPublisher());
        }
        for (ContactDetail t : src.getContact()) {
            tgt.addContact(VersionConvertor_14_40.convertSearchParameterContactComponent(t));
        }
        for (ContactDetail t : src.getUseContext()) {
            if (!t.hasValueCodeableConcept()) continue;
            tgt.addUseContext(VersionConvertor_14_40.convertCodeableConcept(t.getValueCodeableConcept()));
        }
        for (ContactDetail t : src.getJurisdiction()) {
            tgt.addUseContext(VersionConvertor_14_40.convertCodeableConcept((org.hl7.fhir.r4.model.CodeableConcept)t));
        }
        if (src.hasPurpose()) {
            tgt.setRequirements(src.getPurpose());
        }
        tgt.setCode(src.getCode());
        for (ContactDetail t : src.getBase()) {
            tgt.setBase(t.asStringValue());
        }
        tgt.setType(VersionConvertor_14_40.convertSearchParamType(src.getType()));
        tgt.setDescription(src.getDescription());
        if (src.hasExpression()) {
            tgt.setExpression(src.getExpression());
        }
        if (src.hasXpath()) {
            tgt.setXpath(src.getXpath());
        }
        tgt.setXpathUsage(VersionConvertor_14_40.convertXPathUsageType(src.getXpathUsage()));
        for (ContactDetail t : src.getTarget()) {
            tgt.addTarget((String)t.getValue());
        }
        return tgt;
    }

    private static SearchParameter.XPathUsageType convertXPathUsageType(SearchParameter.XPathUsageType src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case NORMAL: {
                return SearchParameter.XPathUsageType.NORMAL;
            }
            case PHONETIC: {
                return SearchParameter.XPathUsageType.PHONETIC;
            }
            case NEARBY: {
                return SearchParameter.XPathUsageType.NEARBY;
            }
            case DISTANCE: {
                return SearchParameter.XPathUsageType.DISTANCE;
            }
            case OTHER: {
                return SearchParameter.XPathUsageType.OTHER;
            }
        }
        return SearchParameter.XPathUsageType.NULL;
    }

    private static SearchParameter.XPathUsageType convertXPathUsageType(SearchParameter.XPathUsageType src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case NORMAL: {
                return SearchParameter.XPathUsageType.NORMAL;
            }
            case PHONETIC: {
                return SearchParameter.XPathUsageType.PHONETIC;
            }
            case NEARBY: {
                return SearchParameter.XPathUsageType.NEARBY;
            }
            case DISTANCE: {
                return SearchParameter.XPathUsageType.DISTANCE;
            }
            case OTHER: {
                return SearchParameter.XPathUsageType.OTHER;
            }
        }
        return SearchParameter.XPathUsageType.NULL;
    }

    public static ContactDetail convertSearchParameterContactComponent(SearchParameter.SearchParameterContactComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ContactDetail tgt = new ContactDetail();
        VersionConvertor_14_40.copyElement((org.hl7.fhir.dstu2016may.model.Element)src, (Element)tgt);
        if (src.hasName()) {
            tgt.setName(src.getName());
        }
        for (org.hl7.fhir.dstu2016may.model.ContactPoint t : src.getTelecom()) {
            tgt.addTelecom(VersionConvertor_14_40.convertContactPoint(t));
        }
        return tgt;
    }

    public static SearchParameter.SearchParameterContactComponent convertSearchParameterContactComponent(ContactDetail src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        SearchParameter.SearchParameterContactComponent tgt = new SearchParameter.SearchParameterContactComponent();
        VersionConvertor_14_40.copyElement((Element)src, (org.hl7.fhir.dstu2016may.model.Element)tgt);
        if (src.hasName()) {
            tgt.setName(src.getName());
        }
        for (ContactPoint t : src.getTelecom()) {
            tgt.addTelecom(VersionConvertor_14_40.convertContactPoint(t));
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.StructureDefinition convertStructureDefinition(StructureDefinition src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r4.model.StructureDefinition tgt = new org.hl7.fhir.r4.model.StructureDefinition();
        VersionConvertor_14_40.copyDomainResource((DomainResource)src, (org.hl7.fhir.r4.model.DomainResource)tgt);
        if (src.hasUrl()) {
            tgt.setUrl(src.getUrl());
        }
        for (org.hl7.fhir.dstu2016may.model.Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_14_40.convertIdentifier(t));
        }
        if (src.hasVersion()) {
            tgt.setVersion(src.getVersion());
        }
        tgt.setName(src.getName());
        if (src.hasDisplay()) {
            tgt.setTitle(src.getDisplay());
        }
        tgt.setStatus(VersionConvertor_14_40.convertConformanceResourceStatus(src.getStatus()));
        if (src.hasExperimental()) {
            tgt.setExperimental(src.getExperimental());
        }
        if (src.hasPublisher()) {
            tgt.setPublisher(src.getPublisher());
        }
        for (org.hl7.fhir.dstu2016may.model.Identifier t : src.getContact()) {
            tgt.addContact(VersionConvertor_14_40.convertStructureDefinitionContactComponent((StructureDefinition.StructureDefinitionContactComponent)t));
        }
        if (src.hasDate()) {
            tgt.setDate(src.getDate());
        }
        if (src.hasDescription()) {
            tgt.setDescription(src.getDescription());
        }
        for (org.hl7.fhir.dstu2016may.model.Identifier t : src.getUseContext()) {
            if (VersionConvertor_14_40.isJurisdiction((CodeableConcept)t)) {
                tgt.addJurisdiction(VersionConvertor_14_40.convertCodeableConcept((CodeableConcept)t));
                continue;
            }
            tgt.addUseContext(VersionConvertor_14_40.convertCodeableConceptToUsageContext((CodeableConcept)t));
        }
        if (src.hasRequirements()) {
            tgt.setPurpose(src.getRequirements());
        }
        if (src.hasCopyright()) {
            tgt.setCopyright(src.getCopyright());
        }
        for (org.hl7.fhir.dstu2016may.model.Identifier t : src.getCode()) {
            tgt.addKeyword(VersionConvertor_14_40.convertCoding((org.hl7.fhir.dstu2016may.model.Coding)t));
        }
        if (src.hasFhirVersion()) {
            tgt.setFhirVersion(src.getFhirVersion());
        }
        for (org.hl7.fhir.dstu2016may.model.Identifier t : src.getMapping()) {
            tgt.addMapping(VersionConvertor_14_40.convertStructureDefinitionMappingComponent((StructureDefinition.StructureDefinitionMappingComponent)t));
        }
        tgt.setKind(VersionConvertor_14_40.convertStructureDefinitionKind(src.getKind(), src.getName()));
        tgt.setAbstract(src.getAbstract());
        for (org.hl7.fhir.dstu2016may.model.Identifier t : src.getContext()) {
            StructureDefinition.StructureDefinitionContextComponent ec = tgt.addContext();
            ec.setType(VersionConvertor_14_40.convertExtensionContext(src.getContextType()));
            ec.setExpression((String)t.getValue());
        }
        if (src.getDerivation() == StructureDefinition.TypeDerivationRule.CONSTRAINT) {
            tgt.setType(src.getBaseType());
        } else {
            tgt.setType(src.getId());
        }
        if (src.hasBaseDefinition()) {
            tgt.setBaseDefinition(src.getBaseDefinition());
        }
        tgt.setDerivation(VersionConvertor_14_40.convertTypeDerivationRule(src.getDerivation()));
        if (src.hasSnapshot()) {
            tgt.setSnapshot(VersionConvertor_14_40.convertStructureDefinitionSnapshotComponent(src.getSnapshot()));
            tgt.getSnapshot().getElementFirstRep().getType().clear();
        }
        if (src.hasDifferential()) {
            tgt.setDifferential(VersionConvertor_14_40.convertStructureDefinitionDifferentialComponent(src.getDifferential()));
            tgt.getDifferential().getElementFirstRep().getType().clear();
        }
        if (tgt.getDerivation() == StructureDefinition.TypeDerivationRule.SPECIALIZATION) {
            for (ElementDefinition ed : tgt.getSnapshot().getElement()) {
                if (ed.hasBase()) continue;
                ed.getBase().setPath(ed.getPath()).setMin(ed.getMin()).setMax(ed.getMax());
            }
        }
        return tgt;
    }

    public static StructureDefinition convertStructureDefinition(org.hl7.fhir.r4.model.StructureDefinition src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        StructureDefinition tgt = new StructureDefinition();
        VersionConvertor_14_40.copyDomainResource((org.hl7.fhir.r4.model.DomainResource)src, (DomainResource)tgt);
        if (src.hasUrl()) {
            tgt.setUrl(src.getUrl());
        }
        for (Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_14_40.convertIdentifier(t));
        }
        if (src.hasVersion()) {
            tgt.setVersion(src.getVersion());
        }
        tgt.setName(src.getName());
        if (src.hasTitle()) {
            tgt.setDisplay(src.getTitle());
        }
        tgt.setStatus(VersionConvertor_14_40.convertConformanceResourceStatus(src.getStatus()));
        if (src.hasExperimental()) {
            tgt.setExperimental(src.getExperimental());
        }
        if (src.hasPublisher()) {
            tgt.setPublisher(src.getPublisher());
        }
        for (Identifier t : src.getContact()) {
            tgt.addContact(VersionConvertor_14_40.convertStructureDefinitionContactComponent((ContactDetail)t));
        }
        if (src.hasDate()) {
            tgt.setDate(src.getDate());
        }
        if (src.hasDescription()) {
            tgt.setDescription(src.getDescription());
        }
        for (Identifier t : src.getUseContext()) {
            if (!t.hasValueCodeableConcept()) continue;
            tgt.addUseContext(VersionConvertor_14_40.convertCodeableConcept(t.getValueCodeableConcept()));
        }
        for (Identifier t : src.getJurisdiction()) {
            tgt.addUseContext(VersionConvertor_14_40.convertCodeableConcept((org.hl7.fhir.r4.model.CodeableConcept)t));
        }
        if (src.hasPurpose()) {
            tgt.setRequirements(src.getPurpose());
        }
        if (src.hasCopyright()) {
            tgt.setCopyright(src.getCopyright());
        }
        for (Identifier t : src.getKeyword()) {
            tgt.addCode(VersionConvertor_14_40.convertCoding((Coding)t));
        }
        if (src.hasFhirVersion()) {
            tgt.setFhirVersion(src.getFhirVersion());
        }
        for (Identifier t : src.getMapping()) {
            tgt.addMapping(VersionConvertor_14_40.convertStructureDefinitionMappingComponent((StructureDefinition.StructureDefinitionMappingComponent)t));
        }
        tgt.setKind(VersionConvertor_14_40.convertStructureDefinitionKind(src.getKind()));
        tgt.setAbstract(src.getAbstract());
        for (Identifier t : src.getContext()) {
            if (!tgt.hasContextType()) {
                tgt.setContextType(VersionConvertor_14_40.convertExtensionContext(t.getType()));
            }
            tgt.addContext(t.getExpression());
        }
        if (src.hasBaseDefinition()) {
            tgt.setBaseDefinition(src.getBaseDefinition());
        }
        if (src.hasType() && src.getDerivation() == StructureDefinition.TypeDerivationRule.CONSTRAINT) {
            tgt.setBaseType(src.getType());
        }
        tgt.setDerivation(VersionConvertor_14_40.convertTypeDerivationRule(src.getDerivation()));
        if (src.hasSnapshot()) {
            tgt.setSnapshot(VersionConvertor_14_40.convertStructureDefinitionSnapshotComponent(src.getSnapshot()));
        }
        tgt.setDifferential(VersionConvertor_14_40.convertStructureDefinitionDifferentialComponent(src.getDifferential()));
        return tgt;
    }

    private static StructureDefinition.StructureDefinitionKind convertStructureDefinitionKind(StructureDefinition.StructureDefinitionKind src, String name) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case DATATYPE: {
                if (name.substring(0, 1).toLowerCase().equals(name.substring(0, 1))) {
                    return StructureDefinition.StructureDefinitionKind.PRIMITIVETYPE;
                }
                return StructureDefinition.StructureDefinitionKind.COMPLEXTYPE;
            }
            case RESOURCE: {
                return StructureDefinition.StructureDefinitionKind.RESOURCE;
            }
            case LOGICAL: {
                return StructureDefinition.StructureDefinitionKind.LOGICAL;
            }
        }
        return StructureDefinition.StructureDefinitionKind.NULL;
    }

    private static StructureDefinition.StructureDefinitionKind convertStructureDefinitionKind(StructureDefinition.StructureDefinitionKind src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case PRIMITIVETYPE: {
                return StructureDefinition.StructureDefinitionKind.DATATYPE;
            }
            case COMPLEXTYPE: {
                return StructureDefinition.StructureDefinitionKind.DATATYPE;
            }
            case RESOURCE: {
                return StructureDefinition.StructureDefinitionKind.RESOURCE;
            }
            case LOGICAL: {
                return StructureDefinition.StructureDefinitionKind.LOGICAL;
            }
        }
        return StructureDefinition.StructureDefinitionKind.NULL;
    }

    private static StructureDefinition.ExtensionContextType convertExtensionContext(StructureDefinition.ExtensionContext src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case RESOURCE: {
                return StructureDefinition.ExtensionContextType.FHIRPATH;
            }
            case DATATYPE: {
                return StructureDefinition.ExtensionContextType.ELEMENT;
            }
            case EXTENSION: {
                return StructureDefinition.ExtensionContextType.EXTENSION;
            }
        }
        return StructureDefinition.ExtensionContextType.NULL;
    }

    private static StructureDefinition.ExtensionContext convertExtensionContext(StructureDefinition.ExtensionContextType src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case FHIRPATH: {
                return StructureDefinition.ExtensionContext.RESOURCE;
            }
            case ELEMENT: {
                return StructureDefinition.ExtensionContext.DATATYPE;
            }
            case EXTENSION: {
                return StructureDefinition.ExtensionContext.EXTENSION;
            }
        }
        return StructureDefinition.ExtensionContext.NULL;
    }

    private static StructureDefinition.TypeDerivationRule convertTypeDerivationRule(StructureDefinition.TypeDerivationRule src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case SPECIALIZATION: {
                return StructureDefinition.TypeDerivationRule.SPECIALIZATION;
            }
            case CONSTRAINT: {
                return StructureDefinition.TypeDerivationRule.CONSTRAINT;
            }
        }
        return StructureDefinition.TypeDerivationRule.NULL;
    }

    private static StructureDefinition.TypeDerivationRule convertTypeDerivationRule(StructureDefinition.TypeDerivationRule src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case SPECIALIZATION: {
                return StructureDefinition.TypeDerivationRule.SPECIALIZATION;
            }
            case CONSTRAINT: {
                return StructureDefinition.TypeDerivationRule.CONSTRAINT;
            }
        }
        return StructureDefinition.TypeDerivationRule.NULL;
    }

    public static ContactDetail convertStructureDefinitionContactComponent(StructureDefinition.StructureDefinitionContactComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ContactDetail tgt = new ContactDetail();
        VersionConvertor_14_40.copyElement((org.hl7.fhir.dstu2016may.model.Element)src, (Element)tgt);
        if (src.hasName()) {
            tgt.setName(src.getName());
        }
        for (org.hl7.fhir.dstu2016may.model.ContactPoint t : src.getTelecom()) {
            tgt.addTelecom(VersionConvertor_14_40.convertContactPoint(t));
        }
        return tgt;
    }

    public static StructureDefinition.StructureDefinitionContactComponent convertStructureDefinitionContactComponent(ContactDetail src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        StructureDefinition.StructureDefinitionContactComponent tgt = new StructureDefinition.StructureDefinitionContactComponent();
        VersionConvertor_14_40.copyElement((Element)src, (org.hl7.fhir.dstu2016may.model.Element)tgt);
        if (src.hasName()) {
            tgt.setName(src.getName());
        }
        for (ContactPoint t : src.getTelecom()) {
            tgt.addTelecom(VersionConvertor_14_40.convertContactPoint(t));
        }
        return tgt;
    }

    public static StructureDefinition.StructureDefinitionMappingComponent convertStructureDefinitionMappingComponent(StructureDefinition.StructureDefinitionMappingComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        StructureDefinition.StructureDefinitionMappingComponent tgt = new StructureDefinition.StructureDefinitionMappingComponent();
        VersionConvertor_14_40.copyElement((org.hl7.fhir.dstu2016may.model.Element)src, (Element)tgt);
        tgt.setIdentity(src.getIdentity());
        if (src.hasUri()) {
            tgt.setUri(src.getUri());
        }
        if (src.hasName()) {
            tgt.setName(src.getName());
        }
        if (src.hasComments()) {
            tgt.setComment(src.getComments());
        }
        return tgt;
    }

    public static StructureDefinition.StructureDefinitionMappingComponent convertStructureDefinitionMappingComponent(StructureDefinition.StructureDefinitionMappingComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        StructureDefinition.StructureDefinitionMappingComponent tgt = new StructureDefinition.StructureDefinitionMappingComponent();
        VersionConvertor_14_40.copyElement((Element)src, (org.hl7.fhir.dstu2016may.model.Element)tgt);
        tgt.setIdentity(src.getIdentity());
        if (src.hasUri()) {
            tgt.setUri(src.getUri());
        }
        if (src.hasName()) {
            tgt.setName(src.getName());
        }
        if (src.hasComment()) {
            tgt.setComments(src.getComment());
        }
        return tgt;
    }

    public static StructureDefinition.StructureDefinitionSnapshotComponent convertStructureDefinitionSnapshotComponent(StructureDefinition.StructureDefinitionSnapshotComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        StructureDefinition.StructureDefinitionSnapshotComponent tgt = new StructureDefinition.StructureDefinitionSnapshotComponent();
        VersionConvertor_14_40.copyElement((org.hl7.fhir.dstu2016may.model.Element)src, (Element)tgt);
        for (org.hl7.fhir.dstu2016may.model.ElementDefinition t : src.getElement()) {
            tgt.addElement(VersionConvertor_14_40.convertElementDefinition(t, src.getElement(), src.getElement().indexOf(t)));
        }
        return tgt;
    }

    public static StructureDefinition.StructureDefinitionSnapshotComponent convertStructureDefinitionSnapshotComponent(StructureDefinition.StructureDefinitionSnapshotComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        StructureDefinition.StructureDefinitionSnapshotComponent tgt = new StructureDefinition.StructureDefinitionSnapshotComponent();
        VersionConvertor_14_40.copyElement((Element)src, (org.hl7.fhir.dstu2016may.model.Element)tgt);
        for (ElementDefinition t : src.getElement()) {
            tgt.addElement(VersionConvertor_14_40.convertElementDefinition(t));
        }
        return tgt;
    }

    public static StructureDefinition.StructureDefinitionDifferentialComponent convertStructureDefinitionDifferentialComponent(StructureDefinition.StructureDefinitionDifferentialComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        StructureDefinition.StructureDefinitionDifferentialComponent tgt = new StructureDefinition.StructureDefinitionDifferentialComponent();
        VersionConvertor_14_40.copyElement((org.hl7.fhir.dstu2016may.model.Element)src, (Element)tgt);
        for (org.hl7.fhir.dstu2016may.model.ElementDefinition t : src.getElement()) {
            tgt.addElement(VersionConvertor_14_40.convertElementDefinition(t, src.getElement(), src.getElement().indexOf(t)));
        }
        return tgt;
    }

    public static StructureDefinition.StructureDefinitionDifferentialComponent convertStructureDefinitionDifferentialComponent(StructureDefinition.StructureDefinitionDifferentialComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        StructureDefinition.StructureDefinitionDifferentialComponent tgt = new StructureDefinition.StructureDefinitionDifferentialComponent();
        VersionConvertor_14_40.copyElement((Element)src, (org.hl7.fhir.dstu2016may.model.Element)tgt);
        for (ElementDefinition t : src.getElement()) {
            tgt.addElement(VersionConvertor_14_40.convertElementDefinition(t));
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.TestScript convertTestScript(TestScript src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r4.model.TestScript tgt = new org.hl7.fhir.r4.model.TestScript();
        VersionConvertor_14_40.copyDomainResource((DomainResource)src, (org.hl7.fhir.r4.model.DomainResource)tgt);
        tgt.setUrl(src.getUrl());
        if (src.hasVersion()) {
            tgt.setVersion(src.getVersion());
        }
        tgt.setName(src.getName());
        tgt.setStatus(VersionConvertor_14_40.convertConformanceResourceStatus(src.getStatus()));
        tgt.setIdentifier(VersionConvertor_14_40.convertIdentifier(src.getIdentifier()));
        if (src.hasExperimental()) {
            tgt.setExperimental(src.getExperimental());
        }
        if (src.hasPublisher()) {
            tgt.setPublisher(src.getPublisher());
        }
        for (TestScript.TestScriptContactComponent t : src.getContact()) {
            tgt.addContact(VersionConvertor_14_40.convertTestScriptContactComponent(t));
        }
        if (src.hasDate()) {
            tgt.setDate(src.getDate());
        }
        if (src.hasDescription()) {
            tgt.setDescription(src.getDescription());
        }
        for (TestScript.TestScriptContactComponent t : src.getUseContext()) {
            if (VersionConvertor_14_40.isJurisdiction((CodeableConcept)t)) {
                tgt.addJurisdiction(VersionConvertor_14_40.convertCodeableConcept((CodeableConcept)t));
                continue;
            }
            tgt.addUseContext(VersionConvertor_14_40.convertCodeableConceptToUsageContext((CodeableConcept)t));
        }
        if (src.hasRequirements()) {
            tgt.setPurpose(src.getRequirements());
        }
        if (src.hasCopyright()) {
            tgt.setCopyright(src.getCopyright());
        }
        for (TestScript.TestScriptContactComponent t : src.getOrigin()) {
            tgt.addOrigin(VersionConvertor_14_40.convertTestScriptOriginComponent((TestScript.TestScriptOriginComponent)t));
        }
        for (TestScript.TestScriptContactComponent t : src.getDestination()) {
            tgt.addDestination(VersionConvertor_14_40.convertTestScriptDestinationComponent((TestScript.TestScriptDestinationComponent)t));
        }
        tgt.setMetadata(VersionConvertor_14_40.convertTestScriptMetadataComponent(src.getMetadata()));
        for (TestScript.TestScriptContactComponent t : src.getFixture()) {
            tgt.addFixture(VersionConvertor_14_40.convertTestScriptFixtureComponent((TestScript.TestScriptFixtureComponent)t));
        }
        for (TestScript.TestScriptContactComponent t : src.getProfile()) {
            tgt.addProfile(VersionConvertor_14_40.convertReference((org.hl7.fhir.dstu2016may.model.Reference)t));
        }
        for (TestScript.TestScriptContactComponent t : src.getVariable()) {
            tgt.addVariable(VersionConvertor_14_40.convertTestScriptVariableComponent((TestScript.TestScriptVariableComponent)t));
        }
        for (TestScript.TestScriptContactComponent t : src.getRule()) {
            tgt.addRule(VersionConvertor_14_40.convertTestScriptRuleComponent((TestScript.TestScriptRuleComponent)t));
        }
        for (TestScript.TestScriptContactComponent t : src.getRuleset()) {
            tgt.addRuleset(VersionConvertor_14_40.convertTestScriptRulesetComponent((TestScript.TestScriptRulesetComponent)t));
        }
        tgt.setSetup(VersionConvertor_14_40.convertTestScriptSetupComponent(src.getSetup()));
        for (TestScript.TestScriptContactComponent t : src.getTest()) {
            tgt.addTest(VersionConvertor_14_40.convertTestScriptTestComponent((TestScript.TestScriptTestComponent)t));
        }
        tgt.setTeardown(VersionConvertor_14_40.convertTestScriptTeardownComponent(src.getTeardown()));
        return tgt;
    }

    public static TestScript convertTestScript(org.hl7.fhir.r4.model.TestScript src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript tgt = new TestScript();
        VersionConvertor_14_40.copyDomainResource((org.hl7.fhir.r4.model.DomainResource)src, (DomainResource)tgt);
        tgt.setUrl(src.getUrl());
        if (src.hasVersion()) {
            tgt.setVersion(src.getVersion());
        }
        tgt.setName(src.getName());
        tgt.setStatus(VersionConvertor_14_40.convertConformanceResourceStatus(src.getStatus()));
        tgt.setIdentifier(VersionConvertor_14_40.convertIdentifier(src.getIdentifier()));
        if (src.hasExperimental()) {
            tgt.setExperimental(src.getExperimental());
        }
        if (src.hasPublisher()) {
            tgt.setPublisher(src.getPublisher());
        }
        for (ContactDetail t : src.getContact()) {
            tgt.addContact(VersionConvertor_14_40.convertTestScriptContactComponent(t));
        }
        if (src.hasDate()) {
            tgt.setDate(src.getDate());
        }
        if (src.hasDescription()) {
            tgt.setDescription(src.getDescription());
        }
        for (ContactDetail t : src.getUseContext()) {
            if (!t.hasValueCodeableConcept()) continue;
            tgt.addUseContext(VersionConvertor_14_40.convertCodeableConcept(t.getValueCodeableConcept()));
        }
        for (ContactDetail t : src.getJurisdiction()) {
            tgt.addUseContext(VersionConvertor_14_40.convertCodeableConcept((org.hl7.fhir.r4.model.CodeableConcept)t));
        }
        if (src.hasPurpose()) {
            tgt.setRequirements(src.getPurpose());
        }
        if (src.hasCopyright()) {
            tgt.setCopyright(src.getCopyright());
        }
        for (ContactDetail t : src.getOrigin()) {
            tgt.addOrigin(VersionConvertor_14_40.convertTestScriptOriginComponent((TestScript.TestScriptOriginComponent)t));
        }
        for (ContactDetail t : src.getDestination()) {
            tgt.addDestination(VersionConvertor_14_40.convertTestScriptDestinationComponent((TestScript.TestScriptDestinationComponent)t));
        }
        tgt.setMetadata(VersionConvertor_14_40.convertTestScriptMetadataComponent(src.getMetadata()));
        for (ContactDetail t : src.getFixture()) {
            tgt.addFixture(VersionConvertor_14_40.convertTestScriptFixtureComponent((TestScript.TestScriptFixtureComponent)t));
        }
        for (ContactDetail t : src.getProfile()) {
            tgt.addProfile(VersionConvertor_14_40.convertReference((Reference)t));
        }
        for (ContactDetail t : src.getVariable()) {
            tgt.addVariable(VersionConvertor_14_40.convertTestScriptVariableComponent((TestScript.TestScriptVariableComponent)t));
        }
        for (ContactDetail t : src.getRule()) {
            tgt.addRule(VersionConvertor_14_40.convertTestScriptRuleComponent((TestScript.TestScriptRuleComponent)t));
        }
        for (ContactDetail t : src.getRuleset()) {
            tgt.addRuleset(VersionConvertor_14_40.convertTestScriptRulesetComponent((TestScript.TestScriptRulesetComponent)t));
        }
        tgt.setSetup(VersionConvertor_14_40.convertTestScriptSetupComponent(src.getSetup()));
        for (ContactDetail t : src.getTest()) {
            tgt.addTest(VersionConvertor_14_40.convertTestScriptTestComponent((TestScript.TestScriptTestComponent)t));
        }
        tgt.setTeardown(VersionConvertor_14_40.convertTestScriptTeardownComponent(src.getTeardown()));
        return tgt;
    }

    public static ContactDetail convertTestScriptContactComponent(TestScript.TestScriptContactComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ContactDetail tgt = new ContactDetail();
        VersionConvertor_14_40.copyElement((org.hl7.fhir.dstu2016may.model.Element)src, (Element)tgt);
        if (src.hasName()) {
            tgt.setName(src.getName());
        }
        for (org.hl7.fhir.dstu2016may.model.ContactPoint t : src.getTelecom()) {
            tgt.addTelecom(VersionConvertor_14_40.convertContactPoint(t));
        }
        return tgt;
    }

    public static TestScript.TestScriptContactComponent convertTestScriptContactComponent(ContactDetail src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.TestScriptContactComponent tgt = new TestScript.TestScriptContactComponent();
        VersionConvertor_14_40.copyElement((Element)src, (org.hl7.fhir.dstu2016may.model.Element)tgt);
        if (src.hasName()) {
            tgt.setName(src.getName());
        }
        for (ContactPoint t : src.getTelecom()) {
            tgt.addTelecom(VersionConvertor_14_40.convertContactPoint(t));
        }
        return tgt;
    }

    public static TestScript.TestScriptOriginComponent convertTestScriptOriginComponent(TestScript.TestScriptOriginComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.TestScriptOriginComponent tgt = new TestScript.TestScriptOriginComponent();
        VersionConvertor_14_40.copyElement((org.hl7.fhir.dstu2016may.model.Element)src, (Element)tgt);
        tgt.setIndex(src.getIndex());
        tgt.setProfile(VersionConvertor_14_40.convertCoding(src.getProfile()));
        return tgt;
    }

    public static TestScript.TestScriptOriginComponent convertTestScriptOriginComponent(TestScript.TestScriptOriginComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.TestScriptOriginComponent tgt = new TestScript.TestScriptOriginComponent();
        VersionConvertor_14_40.copyElement((Element)src, (org.hl7.fhir.dstu2016may.model.Element)tgt);
        tgt.setIndex(src.getIndex());
        tgt.setProfile(VersionConvertor_14_40.convertCoding(src.getProfile()));
        return tgt;
    }

    public static TestScript.TestScriptDestinationComponent convertTestScriptDestinationComponent(TestScript.TestScriptDestinationComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.TestScriptDestinationComponent tgt = new TestScript.TestScriptDestinationComponent();
        VersionConvertor_14_40.copyElement((org.hl7.fhir.dstu2016may.model.Element)src, (Element)tgt);
        tgt.setIndex(src.getIndex());
        tgt.setProfile(VersionConvertor_14_40.convertCoding(src.getProfile()));
        return tgt;
    }

    public static TestScript.TestScriptDestinationComponent convertTestScriptDestinationComponent(TestScript.TestScriptDestinationComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.TestScriptDestinationComponent tgt = new TestScript.TestScriptDestinationComponent();
        VersionConvertor_14_40.copyElement((Element)src, (org.hl7.fhir.dstu2016may.model.Element)tgt);
        tgt.setIndex(src.getIndex());
        tgt.setProfile(VersionConvertor_14_40.convertCoding(src.getProfile()));
        return tgt;
    }

    public static TestScript.TestScriptMetadataComponent convertTestScriptMetadataComponent(TestScript.TestScriptMetadataComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.TestScriptMetadataComponent tgt = new TestScript.TestScriptMetadataComponent();
        VersionConvertor_14_40.copyElement((org.hl7.fhir.dstu2016may.model.Element)src, (Element)tgt);
        for (TestScript.TestScriptMetadataLinkComponent t : src.getLink()) {
            tgt.addLink(VersionConvertor_14_40.convertTestScriptMetadataLinkComponent(t));
        }
        for (TestScript.TestScriptMetadataLinkComponent t : src.getCapability()) {
            tgt.addCapability(VersionConvertor_14_40.convertTestScriptMetadataCapabilityComponent((TestScript.TestScriptMetadataCapabilityComponent)t));
        }
        return tgt;
    }

    public static TestScript.TestScriptMetadataComponent convertTestScriptMetadataComponent(TestScript.TestScriptMetadataComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.TestScriptMetadataComponent tgt = new TestScript.TestScriptMetadataComponent();
        VersionConvertor_14_40.copyElement((Element)src, (org.hl7.fhir.dstu2016may.model.Element)tgt);
        for (TestScript.TestScriptMetadataLinkComponent t : src.getLink()) {
            tgt.addLink(VersionConvertor_14_40.convertTestScriptMetadataLinkComponent(t));
        }
        for (TestScript.TestScriptMetadataLinkComponent t : src.getCapability()) {
            tgt.addCapability(VersionConvertor_14_40.convertTestScriptMetadataCapabilityComponent((TestScript.TestScriptMetadataCapabilityComponent)t));
        }
        return tgt;
    }

    public static TestScript.TestScriptMetadataLinkComponent convertTestScriptMetadataLinkComponent(TestScript.TestScriptMetadataLinkComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.TestScriptMetadataLinkComponent tgt = new TestScript.TestScriptMetadataLinkComponent();
        VersionConvertor_14_40.copyElement((org.hl7.fhir.dstu2016may.model.Element)src, (Element)tgt);
        tgt.setUrl(src.getUrl());
        if (src.hasDescription()) {
            tgt.setDescription(src.getDescription());
        }
        return tgt;
    }

    public static TestScript.TestScriptMetadataLinkComponent convertTestScriptMetadataLinkComponent(TestScript.TestScriptMetadataLinkComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.TestScriptMetadataLinkComponent tgt = new TestScript.TestScriptMetadataLinkComponent();
        VersionConvertor_14_40.copyElement((Element)src, (org.hl7.fhir.dstu2016may.model.Element)tgt);
        tgt.setUrl(src.getUrl());
        if (src.hasDescription()) {
            tgt.setDescription(src.getDescription());
        }
        return tgt;
    }

    public static TestScript.TestScriptMetadataCapabilityComponent convertTestScriptMetadataCapabilityComponent(TestScript.TestScriptMetadataCapabilityComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.TestScriptMetadataCapabilityComponent tgt = new TestScript.TestScriptMetadataCapabilityComponent();
        VersionConvertor_14_40.copyElement((org.hl7.fhir.dstu2016may.model.Element)src, (Element)tgt);
        if (src.hasRequired()) {
            tgt.setRequired(src.getRequired());
        }
        if (src.hasValidated()) {
            tgt.setValidated(src.getValidated());
        }
        if (src.hasDescription()) {
            tgt.setDescription(src.getDescription());
        }
        for (IntegerType t : src.getOrigin()) {
            tgt.addOrigin(((Integer)t.getValue()).intValue());
        }
        if (src.hasDestination()) {
            tgt.setDestination(src.getDestination());
        }
        for (IntegerType t : src.getLink()) {
            tgt.addLink((String)t.getValue());
        }
        tgt.setCapabilitiesElement(VersionConvertor_14_40.convertReferenceToCanonical(src.getConformance()));
        return tgt;
    }

    public static TestScript.TestScriptMetadataCapabilityComponent convertTestScriptMetadataCapabilityComponent(TestScript.TestScriptMetadataCapabilityComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.TestScriptMetadataCapabilityComponent tgt = new TestScript.TestScriptMetadataCapabilityComponent();
        VersionConvertor_14_40.copyElement((Element)src, (org.hl7.fhir.dstu2016may.model.Element)tgt);
        if (src.hasRequired()) {
            tgt.setRequired(src.getRequired());
        }
        if (src.hasValidated()) {
            tgt.setValidated(src.getValidated());
        }
        if (src.hasDescription()) {
            tgt.setDescription(src.getDescription());
        }
        for (org.hl7.fhir.r4.model.IntegerType t : src.getOrigin()) {
            tgt.addOrigin(((Integer)t.getValue()).intValue());
        }
        if (src.hasDestination()) {
            tgt.setDestination(src.getDestination());
        }
        for (org.hl7.fhir.r4.model.IntegerType t : src.getLink()) {
            tgt.addLink((String)t.getValue());
        }
        tgt.setConformance(VersionConvertor_14_40.convertCanonicalToReference(src.getCapabilitiesElement()));
        return tgt;
    }

    public static TestScript.TestScriptFixtureComponent convertTestScriptFixtureComponent(TestScript.TestScriptFixtureComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.TestScriptFixtureComponent tgt = new TestScript.TestScriptFixtureComponent();
        VersionConvertor_14_40.copyElement((org.hl7.fhir.dstu2016may.model.Element)src, (Element)tgt);
        if (src.hasAutocreate()) {
            tgt.setAutocreate(src.getAutocreate());
        }
        if (src.hasAutodelete()) {
            tgt.setAutodelete(src.getAutodelete());
        }
        if (src.hasResource()) {
            tgt.setResource(VersionConvertor_14_40.convertReference(src.getResource()));
        }
        return tgt;
    }

    public static TestScript.TestScriptFixtureComponent convertTestScriptFixtureComponent(TestScript.TestScriptFixtureComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.TestScriptFixtureComponent tgt = new TestScript.TestScriptFixtureComponent();
        VersionConvertor_14_40.copyElement((Element)src, (org.hl7.fhir.dstu2016may.model.Element)tgt);
        if (src.hasAutocreate()) {
            tgt.setAutocreate(src.getAutocreate());
        }
        if (src.hasAutodelete()) {
            tgt.setAutodelete(src.getAutodelete());
        }
        if (src.hasResource()) {
            tgt.setResource(VersionConvertor_14_40.convertReference(src.getResource()));
        }
        return tgt;
    }

    public static TestScript.TestScriptVariableComponent convertTestScriptVariableComponent(TestScript.TestScriptVariableComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.TestScriptVariableComponent tgt = new TestScript.TestScriptVariableComponent();
        VersionConvertor_14_40.copyElement((org.hl7.fhir.dstu2016may.model.Element)src, (Element)tgt);
        tgt.setName(src.getName());
        if (src.hasDefaultValue()) {
            tgt.setDefaultValue(src.getDefaultValue());
        }
        if (src.hasHeaderField()) {
            tgt.setHeaderField(src.getHeaderField());
        }
        if (src.hasPath()) {
            tgt.setPath(src.getPath());
        }
        if (src.hasSourceId()) {
            tgt.setSourceId(src.getSourceId());
        }
        return tgt;
    }

    public static TestScript.TestScriptVariableComponent convertTestScriptVariableComponent(TestScript.TestScriptVariableComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.TestScriptVariableComponent tgt = new TestScript.TestScriptVariableComponent();
        VersionConvertor_14_40.copyElement((Element)src, (org.hl7.fhir.dstu2016may.model.Element)tgt);
        tgt.setName(src.getName());
        if (src.hasDefaultValue()) {
            tgt.setDefaultValue(src.getDefaultValue());
        }
        if (src.hasHeaderField()) {
            tgt.setHeaderField(src.getHeaderField());
        }
        if (src.hasPath()) {
            tgt.setPath(src.getPath());
        }
        if (src.hasSourceId()) {
            tgt.setSourceId(src.getSourceId());
        }
        return tgt;
    }

    public static TestScript.TestScriptRuleComponent convertTestScriptRuleComponent(TestScript.TestScriptRuleComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.TestScriptRuleComponent tgt = new TestScript.TestScriptRuleComponent();
        VersionConvertor_14_40.copyElement((org.hl7.fhir.dstu2016may.model.Element)src, (Element)tgt);
        tgt.setResource(VersionConvertor_14_40.convertReference(src.getResource()));
        for (TestScript.TestScriptRuleParamComponent t : src.getParam()) {
            tgt.addParam(VersionConvertor_14_40.convertTestScriptRuleParamComponent(t));
        }
        return tgt;
    }

    public static TestScript.TestScriptRuleComponent convertTestScriptRuleComponent(TestScript.TestScriptRuleComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.TestScriptRuleComponent tgt = new TestScript.TestScriptRuleComponent();
        VersionConvertor_14_40.copyElement((Element)src, (org.hl7.fhir.dstu2016may.model.Element)tgt);
        tgt.setResource(VersionConvertor_14_40.convertReference(src.getResource()));
        for (TestScript.RuleParamComponent t : src.getParam()) {
            tgt.addParam(VersionConvertor_14_40.convertTestScriptRuleParamComponent(t));
        }
        return tgt;
    }

    public static TestScript.RuleParamComponent convertTestScriptRuleParamComponent(TestScript.TestScriptRuleParamComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.RuleParamComponent tgt = new TestScript.RuleParamComponent();
        VersionConvertor_14_40.copyElement((org.hl7.fhir.dstu2016may.model.Element)src, (Element)tgt);
        tgt.setName(src.getName());
        if (src.hasValue()) {
            tgt.setValue(src.getValue());
        }
        return tgt;
    }

    public static TestScript.TestScriptRuleParamComponent convertTestScriptRuleParamComponent(TestScript.RuleParamComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.TestScriptRuleParamComponent tgt = new TestScript.TestScriptRuleParamComponent();
        VersionConvertor_14_40.copyElement((Element)src, (org.hl7.fhir.dstu2016may.model.Element)tgt);
        tgt.setName(src.getName());
        if (src.hasValue()) {
            tgt.setValue(src.getValue());
        }
        return tgt;
    }

    public static TestScript.TestScriptRulesetComponent convertTestScriptRulesetComponent(TestScript.TestScriptRulesetComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.TestScriptRulesetComponent tgt = new TestScript.TestScriptRulesetComponent();
        VersionConvertor_14_40.copyElement((org.hl7.fhir.dstu2016may.model.Element)src, (Element)tgt);
        tgt.setResource(VersionConvertor_14_40.convertReference(src.getResource()));
        for (TestScript.TestScriptRulesetRuleComponent t : src.getRule()) {
            tgt.addRule(VersionConvertor_14_40.convertTestScriptRulesetRuleComponent(t));
        }
        return tgt;
    }

    public static TestScript.TestScriptRulesetComponent convertTestScriptRulesetComponent(TestScript.TestScriptRulesetComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.TestScriptRulesetComponent tgt = new TestScript.TestScriptRulesetComponent();
        VersionConvertor_14_40.copyElement((Element)src, (org.hl7.fhir.dstu2016may.model.Element)tgt);
        tgt.setResource(VersionConvertor_14_40.convertReference(src.getResource()));
        for (TestScript.RulesetRuleComponent t : src.getRule()) {
            tgt.addRule(VersionConvertor_14_40.convertTestScriptRulesetRuleComponent(t));
        }
        return tgt;
    }

    public static TestScript.RulesetRuleComponent convertTestScriptRulesetRuleComponent(TestScript.TestScriptRulesetRuleComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.RulesetRuleComponent tgt = new TestScript.RulesetRuleComponent();
        VersionConvertor_14_40.copyElement((org.hl7.fhir.dstu2016may.model.Element)src, (Element)tgt);
        for (TestScript.TestScriptRulesetRuleParamComponent t : src.getParam()) {
            tgt.addParam(VersionConvertor_14_40.convertTestScriptRulesetRuleParamComponent(t));
        }
        return tgt;
    }

    public static TestScript.TestScriptRulesetRuleComponent convertTestScriptRulesetRuleComponent(TestScript.RulesetRuleComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.TestScriptRulesetRuleComponent tgt = new TestScript.TestScriptRulesetRuleComponent();
        VersionConvertor_14_40.copyElement((Element)src, (org.hl7.fhir.dstu2016may.model.Element)tgt);
        for (TestScript.RulesetRuleParamComponent t : src.getParam()) {
            tgt.addParam(VersionConvertor_14_40.convertTestScriptRulesetRuleParamComponent(t));
        }
        return tgt;
    }

    public static TestScript.RulesetRuleParamComponent convertTestScriptRulesetRuleParamComponent(TestScript.TestScriptRulesetRuleParamComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.RulesetRuleParamComponent tgt = new TestScript.RulesetRuleParamComponent();
        VersionConvertor_14_40.copyElement((org.hl7.fhir.dstu2016may.model.Element)src, (Element)tgt);
        tgt.setName(src.getName());
        if (src.hasValue()) {
            tgt.setValue(src.getValue());
        }
        return tgt;
    }

    public static TestScript.TestScriptRulesetRuleParamComponent convertTestScriptRulesetRuleParamComponent(TestScript.RulesetRuleParamComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.TestScriptRulesetRuleParamComponent tgt = new TestScript.TestScriptRulesetRuleParamComponent();
        VersionConvertor_14_40.copyElement((Element)src, (org.hl7.fhir.dstu2016may.model.Element)tgt);
        tgt.setName(src.getName());
        if (src.hasValue()) {
            tgt.setValue(src.getValue());
        }
        return tgt;
    }

    public static TestScript.TestScriptSetupComponent convertTestScriptSetupComponent(TestScript.TestScriptSetupComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.TestScriptSetupComponent tgt = new TestScript.TestScriptSetupComponent();
        VersionConvertor_14_40.copyElement((org.hl7.fhir.dstu2016may.model.Element)src, (Element)tgt);
        for (TestScript.SetupActionComponent t : src.getAction()) {
            tgt.addAction(VersionConvertor_14_40.convertSetupActionComponent(t));
        }
        return tgt;
    }

    public static TestScript.TestScriptSetupComponent convertTestScriptSetupComponent(TestScript.TestScriptSetupComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.TestScriptSetupComponent tgt = new TestScript.TestScriptSetupComponent();
        VersionConvertor_14_40.copyElement((Element)src, (org.hl7.fhir.dstu2016may.model.Element)tgt);
        for (TestScript.SetupActionComponent t : src.getAction()) {
            tgt.addAction(VersionConvertor_14_40.convertSetupActionComponent(t));
        }
        return tgt;
    }

    public static TestScript.SetupActionComponent convertSetupActionComponent(TestScript.SetupActionComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.SetupActionComponent tgt = new TestScript.SetupActionComponent();
        VersionConvertor_14_40.copyElement((org.hl7.fhir.dstu2016may.model.Element)src, (Element)tgt);
        tgt.setOperation(VersionConvertor_14_40.convertSetupActionOperationComponent(src.getOperation()));
        tgt.setAssert(VersionConvertor_14_40.convertSetupActionAssertComponent(src.getAssert()));
        return tgt;
    }

    public static TestScript.SetupActionComponent convertSetupActionComponent(TestScript.SetupActionComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.SetupActionComponent tgt = new TestScript.SetupActionComponent();
        VersionConvertor_14_40.copyElement((Element)src, (org.hl7.fhir.dstu2016may.model.Element)tgt);
        tgt.setOperation(VersionConvertor_14_40.convertSetupActionOperationComponent(src.getOperation()));
        tgt.setAssert(VersionConvertor_14_40.convertSetupActionAssertComponent(src.getAssert()));
        return tgt;
    }

    public static TestScript.SetupActionOperationComponent convertSetupActionOperationComponent(TestScript.SetupActionOperationComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.SetupActionOperationComponent tgt = new TestScript.SetupActionOperationComponent();
        VersionConvertor_14_40.copyElement((org.hl7.fhir.dstu2016may.model.Element)src, (Element)tgt);
        tgt.setType(VersionConvertor_14_40.convertCoding(src.getType()));
        if (src.hasResource()) {
            tgt.setResource(src.getResource());
        }
        if (src.hasLabel()) {
            tgt.setLabel(src.getLabel());
        }
        if (src.hasDescription()) {
            tgt.setDescription(src.getDescription());
        }
        tgt.setAccept(VersionConvertor_14_40.convertContentType(src.getAccept()));
        tgt.setContentType(VersionConvertor_14_40.convertContentType(src.getContentType()));
        if (src.hasDestination()) {
            tgt.setDestination(src.getDestination());
        }
        if (src.hasEncodeRequestUrl()) {
            tgt.setEncodeRequestUrl(src.getEncodeRequestUrl());
        }
        if (src.hasOrigin()) {
            tgt.setOrigin(src.getOrigin());
        }
        if (src.hasParams()) {
            tgt.setParams(src.getParams());
        }
        for (TestScript.SetupActionOperationRequestHeaderComponent t : src.getRequestHeader()) {
            tgt.addRequestHeader(VersionConvertor_14_40.convertSetupActionOperationRequestHeaderComponent(t));
        }
        if (src.hasResponseId()) {
            tgt.setResponseId(src.getResponseId());
        }
        if (src.hasSourceId()) {
            tgt.setSourceId(src.getSourceId());
        }
        if (src.hasTargetId()) {
            tgt.setTargetId(src.getTargetId());
        }
        if (src.hasUrl()) {
            tgt.setUrl(src.getUrl());
        }
        return tgt;
    }

    public static TestScript.SetupActionOperationComponent convertSetupActionOperationComponent(TestScript.SetupActionOperationComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.SetupActionOperationComponent tgt = new TestScript.SetupActionOperationComponent();
        VersionConvertor_14_40.copyElement((Element)src, (org.hl7.fhir.dstu2016may.model.Element)tgt);
        if (src.hasResource()) {
            tgt.setResource(src.getResource());
        }
        if (src.hasLabel()) {
            tgt.setLabel(src.getLabel());
        }
        if (src.hasDescription()) {
            tgt.setDescription(src.getDescription());
        }
        tgt.setAccept(VersionConvertor_14_40.convertContentType(src.getAccept()));
        tgt.setContentType(VersionConvertor_14_40.convertContentType(src.getContentType()));
        if (src.hasDestination()) {
            tgt.setDestination(src.getDestination());
        }
        if (src.hasEncodeRequestUrl()) {
            tgt.setEncodeRequestUrl(src.getEncodeRequestUrl());
        }
        if (src.hasOrigin()) {
            tgt.setOrigin(src.getOrigin());
        }
        if (src.hasParams()) {
            tgt.setParams(src.getParams());
        }
        for (TestScript.SetupActionOperationRequestHeaderComponent t : src.getRequestHeader()) {
            tgt.addRequestHeader(VersionConvertor_14_40.convertSetupActionOperationRequestHeaderComponent(t));
        }
        if (src.hasResponseId()) {
            tgt.setResponseId(src.getResponseId());
        }
        if (src.hasSourceId()) {
            tgt.setSourceId(src.getSourceId());
        }
        if (src.hasTargetId()) {
            tgt.setTargetId(src.getTargetId());
        }
        if (src.hasUrl()) {
            tgt.setUrl(src.getUrl());
        }
        return tgt;
    }

    private static String convertContentType(TestScript.ContentType src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case XML: {
                return "application/fhir+xml";
            }
            case JSON: {
                return "application/fhir+json";
            }
        }
        return null;
    }

    private static TestScript.ContentType convertContentType(String src) throws FHIRException {
        if (src == null) {
            return null;
        }
        if (src.contains("xml")) {
            return TestScript.ContentType.XML;
        }
        if (src.contains("json")) {
            return TestScript.ContentType.JSON;
        }
        return TestScript.ContentType.NULL;
    }

    public static TestScript.SetupActionOperationRequestHeaderComponent convertSetupActionOperationRequestHeaderComponent(TestScript.SetupActionOperationRequestHeaderComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.SetupActionOperationRequestHeaderComponent tgt = new TestScript.SetupActionOperationRequestHeaderComponent();
        VersionConvertor_14_40.copyElement((org.hl7.fhir.dstu2016may.model.Element)src, (Element)tgt);
        tgt.setField(src.getField());
        tgt.setValue(src.getValue());
        return tgt;
    }

    public static TestScript.SetupActionOperationRequestHeaderComponent convertSetupActionOperationRequestHeaderComponent(TestScript.SetupActionOperationRequestHeaderComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.SetupActionOperationRequestHeaderComponent tgt = new TestScript.SetupActionOperationRequestHeaderComponent();
        VersionConvertor_14_40.copyElement((Element)src, (org.hl7.fhir.dstu2016may.model.Element)tgt);
        tgt.setField(src.getField());
        tgt.setValue(src.getValue());
        return tgt;
    }

    public static TestScript.SetupActionAssertComponent convertSetupActionAssertComponent(TestScript.SetupActionAssertComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.SetupActionAssertComponent tgt = new TestScript.SetupActionAssertComponent();
        VersionConvertor_14_40.copyElement((org.hl7.fhir.dstu2016may.model.Element)src, (Element)tgt);
        if (src.hasLabel()) {
            tgt.setLabel(src.getLabel());
        }
        if (src.hasDescription()) {
            tgt.setDescription(src.getDescription());
        }
        tgt.setDirection(VersionConvertor_14_40.convertAssertionDirectionType(src.getDirection()));
        if (src.hasCompareToSourceId()) {
            tgt.setCompareToSourceId(src.getCompareToSourceId());
        }
        if (src.hasCompareToSourcePath()) {
            tgt.setCompareToSourcePath(src.getCompareToSourcePath());
        }
        tgt.setContentType(VersionConvertor_14_40.convertContentType(src.getContentType()));
        if (src.hasHeaderField()) {
            tgt.setHeaderField(src.getHeaderField());
        }
        if (src.hasMinimumId()) {
            tgt.setMinimumId(src.getMinimumId());
        }
        if (src.hasNavigationLinks()) {
            tgt.setNavigationLinks(src.getNavigationLinks());
        }
        tgt.setOperator(VersionConvertor_14_40.convertAssertionOperatorType(src.getOperator()));
        if (src.hasPath()) {
            tgt.setPath(src.getPath());
        }
        if (src.hasResource()) {
            tgt.setResource(src.getResource());
        }
        tgt.setResponse(VersionConvertor_14_40.convertAssertionResponseTypes(src.getResponse()));
        if (src.hasResponseCode()) {
            tgt.setResponseCode(src.getResponseCode());
        }
        tgt.setRule(VersionConvertor_14_40.convertSetupActionAssertRuleComponent(src.getRule()));
        tgt.setRuleset(VersionConvertor_14_40.convertSetupActionAssertRulesetComponent(src.getRuleset()));
        if (src.hasSourceId()) {
            tgt.setSourceId(src.getSourceId());
        }
        if (src.hasValidateProfileId()) {
            tgt.setValidateProfileId(src.getValidateProfileId());
        }
        if (src.hasValue()) {
            tgt.setValue(src.getValue());
        }
        if (src.hasWarningOnly()) {
            tgt.setWarningOnly(src.getWarningOnly());
        }
        return tgt;
    }

    public static TestScript.SetupActionAssertComponent convertSetupActionAssertComponent(TestScript.SetupActionAssertComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.SetupActionAssertComponent tgt = new TestScript.SetupActionAssertComponent();
        VersionConvertor_14_40.copyElement((Element)src, (org.hl7.fhir.dstu2016may.model.Element)tgt);
        if (src.hasLabel()) {
            tgt.setLabel(src.getLabel());
        }
        if (src.hasDescription()) {
            tgt.setDescription(src.getDescription());
        }
        tgt.setDirection(VersionConvertor_14_40.convertAssertionDirectionType(src.getDirection()));
        if (src.hasCompareToSourceId()) {
            tgt.setCompareToSourceId(src.getCompareToSourceId());
        }
        if (src.hasCompareToSourcePath()) {
            tgt.setCompareToSourcePath(src.getCompareToSourcePath());
        }
        tgt.setContentType(VersionConvertor_14_40.convertContentType(src.getContentType()));
        if (src.hasHeaderField()) {
            tgt.setHeaderField(src.getHeaderField());
        }
        if (src.hasMinimumId()) {
            tgt.setMinimumId(src.getMinimumId());
        }
        if (src.hasNavigationLinks()) {
            tgt.setNavigationLinks(src.getNavigationLinks());
        }
        tgt.setOperator(VersionConvertor_14_40.convertAssertionOperatorType(src.getOperator()));
        if (src.hasPath()) {
            tgt.setPath(src.getPath());
        }
        if (src.hasResource()) {
            tgt.setResource(src.getResource());
        }
        tgt.setResponse(VersionConvertor_14_40.convertAssertionResponseTypes(src.getResponse()));
        if (src.hasResponseCode()) {
            tgt.setResponseCode(src.getResponseCode());
        }
        tgt.setRule(VersionConvertor_14_40.convertSetupActionAssertRuleComponent(src.getRule()));
        tgt.setRuleset(VersionConvertor_14_40.convertSetupActionAssertRulesetComponent(src.getRuleset()));
        if (src.hasSourceId()) {
            tgt.setSourceId(src.getSourceId());
        }
        if (src.hasValidateProfileId()) {
            tgt.setValidateProfileId(src.getValidateProfileId());
        }
        if (src.hasValue()) {
            tgt.setValue(src.getValue());
        }
        if (src.hasWarningOnly()) {
            tgt.setWarningOnly(src.getWarningOnly());
        }
        return tgt;
    }

    public static TestScript.ActionAssertRuleComponent convertSetupActionAssertRuleComponent(TestScript.SetupActionAssertRuleComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.ActionAssertRuleComponent tgt = new TestScript.ActionAssertRuleComponent();
        VersionConvertor_14_40.copyElement((org.hl7.fhir.dstu2016may.model.Element)src, (Element)tgt);
        for (TestScript.SetupActionAssertRuleParamComponent t : src.getParam()) {
            tgt.addParam(VersionConvertor_14_40.convertSetupActionAssertRuleParamComponent(t));
        }
        return tgt;
    }

    public static TestScript.SetupActionAssertRuleComponent convertSetupActionAssertRuleComponent(TestScript.ActionAssertRuleComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.SetupActionAssertRuleComponent tgt = new TestScript.SetupActionAssertRuleComponent();
        VersionConvertor_14_40.copyElement((Element)src, (org.hl7.fhir.dstu2016may.model.Element)tgt);
        for (TestScript.ActionAssertRuleParamComponent t : src.getParam()) {
            tgt.addParam(VersionConvertor_14_40.convertSetupActionAssertRuleParamComponent(t));
        }
        return tgt;
    }

    public static TestScript.ActionAssertRuleParamComponent convertSetupActionAssertRuleParamComponent(TestScript.SetupActionAssertRuleParamComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.ActionAssertRuleParamComponent tgt = new TestScript.ActionAssertRuleParamComponent();
        VersionConvertor_14_40.copyElement((org.hl7.fhir.dstu2016may.model.Element)src, (Element)tgt);
        tgt.setName(src.getName());
        if (src.hasValue()) {
            tgt.setValue(src.getValue());
        }
        return tgt;
    }

    public static TestScript.SetupActionAssertRuleParamComponent convertSetupActionAssertRuleParamComponent(TestScript.ActionAssertRuleParamComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.SetupActionAssertRuleParamComponent tgt = new TestScript.SetupActionAssertRuleParamComponent();
        VersionConvertor_14_40.copyElement((Element)src, (org.hl7.fhir.dstu2016may.model.Element)tgt);
        tgt.setName(src.getName());
        if (src.hasValue()) {
            tgt.setValue(src.getValue());
        }
        return tgt;
    }

    public static TestScript.ActionAssertRulesetComponent convertSetupActionAssertRulesetComponent(TestScript.SetupActionAssertRulesetComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.ActionAssertRulesetComponent tgt = new TestScript.ActionAssertRulesetComponent();
        VersionConvertor_14_40.copyElement((org.hl7.fhir.dstu2016may.model.Element)src, (Element)tgt);
        for (TestScript.SetupActionAssertRulesetRuleComponent t : src.getRule()) {
            tgt.addRule(VersionConvertor_14_40.convertSetupActionAssertRulesetRuleComponent(t));
        }
        return tgt;
    }

    public static TestScript.SetupActionAssertRulesetComponent convertSetupActionAssertRulesetComponent(TestScript.ActionAssertRulesetComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.SetupActionAssertRulesetComponent tgt = new TestScript.SetupActionAssertRulesetComponent();
        VersionConvertor_14_40.copyElement((Element)src, (org.hl7.fhir.dstu2016may.model.Element)tgt);
        for (TestScript.ActionAssertRulesetRuleComponent t : src.getRule()) {
            tgt.addRule(VersionConvertor_14_40.convertSetupActionAssertRulesetRuleComponent(t));
        }
        return tgt;
    }

    public static TestScript.ActionAssertRulesetRuleComponent convertSetupActionAssertRulesetRuleComponent(TestScript.SetupActionAssertRulesetRuleComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.ActionAssertRulesetRuleComponent tgt = new TestScript.ActionAssertRulesetRuleComponent();
        VersionConvertor_14_40.copyElement((org.hl7.fhir.dstu2016may.model.Element)src, (Element)tgt);
        for (TestScript.SetupActionAssertRulesetRuleParamComponent t : src.getParam()) {
            tgt.addParam(VersionConvertor_14_40.convertSetupActionAssertRulesetRuleParamComponent(t));
        }
        return tgt;
    }

    public static TestScript.SetupActionAssertRulesetRuleComponent convertSetupActionAssertRulesetRuleComponent(TestScript.ActionAssertRulesetRuleComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.SetupActionAssertRulesetRuleComponent tgt = new TestScript.SetupActionAssertRulesetRuleComponent();
        VersionConvertor_14_40.copyElement((Element)src, (org.hl7.fhir.dstu2016may.model.Element)tgt);
        for (TestScript.ActionAssertRulesetRuleParamComponent t : src.getParam()) {
            tgt.addParam(VersionConvertor_14_40.convertSetupActionAssertRulesetRuleParamComponent(t));
        }
        return tgt;
    }

    public static TestScript.ActionAssertRulesetRuleParamComponent convertSetupActionAssertRulesetRuleParamComponent(TestScript.SetupActionAssertRulesetRuleParamComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.ActionAssertRulesetRuleParamComponent tgt = new TestScript.ActionAssertRulesetRuleParamComponent();
        VersionConvertor_14_40.copyElement((org.hl7.fhir.dstu2016may.model.Element)src, (Element)tgt);
        tgt.setName(src.getName());
        if (src.hasValue()) {
            tgt.setValue(src.getValue());
        }
        return tgt;
    }

    public static TestScript.SetupActionAssertRulesetRuleParamComponent convertSetupActionAssertRulesetRuleParamComponent(TestScript.ActionAssertRulesetRuleParamComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.SetupActionAssertRulesetRuleParamComponent tgt = new TestScript.SetupActionAssertRulesetRuleParamComponent();
        VersionConvertor_14_40.copyElement((Element)src, (org.hl7.fhir.dstu2016may.model.Element)tgt);
        tgt.setName(src.getName());
        if (src.hasValue()) {
            tgt.setValue(src.getValue());
        }
        return tgt;
    }

    private static TestScript.AssertionDirectionType convertAssertionDirectionType(TestScript.AssertionDirectionType src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case RESPONSE: {
                return TestScript.AssertionDirectionType.RESPONSE;
            }
            case REQUEST: {
                return TestScript.AssertionDirectionType.REQUEST;
            }
        }
        return TestScript.AssertionDirectionType.NULL;
    }

    private static TestScript.AssertionDirectionType convertAssertionDirectionType(TestScript.AssertionDirectionType src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case RESPONSE: {
                return TestScript.AssertionDirectionType.RESPONSE;
            }
            case REQUEST: {
                return TestScript.AssertionDirectionType.REQUEST;
            }
        }
        return TestScript.AssertionDirectionType.NULL;
    }

    private static TestScript.AssertionOperatorType convertAssertionOperatorType(TestScript.AssertionOperatorType src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case EQUALS: {
                return TestScript.AssertionOperatorType.EQUALS;
            }
            case NOTEQUALS: {
                return TestScript.AssertionOperatorType.NOTEQUALS;
            }
            case IN: {
                return TestScript.AssertionOperatorType.IN;
            }
            case NOTIN: {
                return TestScript.AssertionOperatorType.NOTIN;
            }
            case GREATERTHAN: {
                return TestScript.AssertionOperatorType.GREATERTHAN;
            }
            case LESSTHAN: {
                return TestScript.AssertionOperatorType.LESSTHAN;
            }
            case EMPTY: {
                return TestScript.AssertionOperatorType.EMPTY;
            }
            case NOTEMPTY: {
                return TestScript.AssertionOperatorType.NOTEMPTY;
            }
            case CONTAINS: {
                return TestScript.AssertionOperatorType.CONTAINS;
            }
            case NOTCONTAINS: {
                return TestScript.AssertionOperatorType.NOTCONTAINS;
            }
        }
        return TestScript.AssertionOperatorType.NULL;
    }

    private static TestScript.AssertionOperatorType convertAssertionOperatorType(TestScript.AssertionOperatorType src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case EQUALS: {
                return TestScript.AssertionOperatorType.EQUALS;
            }
            case NOTEQUALS: {
                return TestScript.AssertionOperatorType.NOTEQUALS;
            }
            case IN: {
                return TestScript.AssertionOperatorType.IN;
            }
            case NOTIN: {
                return TestScript.AssertionOperatorType.NOTIN;
            }
            case GREATERTHAN: {
                return TestScript.AssertionOperatorType.GREATERTHAN;
            }
            case LESSTHAN: {
                return TestScript.AssertionOperatorType.LESSTHAN;
            }
            case EMPTY: {
                return TestScript.AssertionOperatorType.EMPTY;
            }
            case NOTEMPTY: {
                return TestScript.AssertionOperatorType.NOTEMPTY;
            }
            case CONTAINS: {
                return TestScript.AssertionOperatorType.CONTAINS;
            }
            case NOTCONTAINS: {
                return TestScript.AssertionOperatorType.NOTCONTAINS;
            }
        }
        return TestScript.AssertionOperatorType.NULL;
    }

    private static TestScript.AssertionResponseTypes convertAssertionResponseTypes(TestScript.AssertionResponseTypes src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case OKAY: {
                return TestScript.AssertionResponseTypes.OKAY;
            }
            case CREATED: {
                return TestScript.AssertionResponseTypes.CREATED;
            }
            case NOCONTENT: {
                return TestScript.AssertionResponseTypes.NOCONTENT;
            }
            case NOTMODIFIED: {
                return TestScript.AssertionResponseTypes.NOTMODIFIED;
            }
            case BAD: {
                return TestScript.AssertionResponseTypes.BAD;
            }
            case FORBIDDEN: {
                return TestScript.AssertionResponseTypes.FORBIDDEN;
            }
            case NOTFOUND: {
                return TestScript.AssertionResponseTypes.NOTFOUND;
            }
            case METHODNOTALLOWED: {
                return TestScript.AssertionResponseTypes.METHODNOTALLOWED;
            }
            case CONFLICT: {
                return TestScript.AssertionResponseTypes.CONFLICT;
            }
            case GONE: {
                return TestScript.AssertionResponseTypes.GONE;
            }
            case PRECONDITIONFAILED: {
                return TestScript.AssertionResponseTypes.PRECONDITIONFAILED;
            }
            case UNPROCESSABLE: {
                return TestScript.AssertionResponseTypes.UNPROCESSABLE;
            }
        }
        return TestScript.AssertionResponseTypes.NULL;
    }

    private static TestScript.AssertionResponseTypes convertAssertionResponseTypes(TestScript.AssertionResponseTypes src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case OKAY: {
                return TestScript.AssertionResponseTypes.OKAY;
            }
            case CREATED: {
                return TestScript.AssertionResponseTypes.CREATED;
            }
            case NOCONTENT: {
                return TestScript.AssertionResponseTypes.NOCONTENT;
            }
            case NOTMODIFIED: {
                return TestScript.AssertionResponseTypes.NOTMODIFIED;
            }
            case BAD: {
                return TestScript.AssertionResponseTypes.BAD;
            }
            case FORBIDDEN: {
                return TestScript.AssertionResponseTypes.FORBIDDEN;
            }
            case NOTFOUND: {
                return TestScript.AssertionResponseTypes.NOTFOUND;
            }
            case METHODNOTALLOWED: {
                return TestScript.AssertionResponseTypes.METHODNOTALLOWED;
            }
            case CONFLICT: {
                return TestScript.AssertionResponseTypes.CONFLICT;
            }
            case GONE: {
                return TestScript.AssertionResponseTypes.GONE;
            }
            case PRECONDITIONFAILED: {
                return TestScript.AssertionResponseTypes.PRECONDITIONFAILED;
            }
            case UNPROCESSABLE: {
                return TestScript.AssertionResponseTypes.UNPROCESSABLE;
            }
        }
        return TestScript.AssertionResponseTypes.NULL;
    }

    public static TestScript.TestScriptTestComponent convertTestScriptTestComponent(TestScript.TestScriptTestComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.TestScriptTestComponent tgt = new TestScript.TestScriptTestComponent();
        VersionConvertor_14_40.copyElement((org.hl7.fhir.dstu2016may.model.Element)src, (Element)tgt);
        if (src.hasName()) {
            tgt.setName(src.getName());
        }
        if (src.hasDescription()) {
            tgt.setDescription(src.getDescription());
        }
        for (TestScript.TestActionComponent t : src.getAction()) {
            tgt.addAction(VersionConvertor_14_40.convertTestActionComponent(t));
        }
        return tgt;
    }

    public static TestScript.TestScriptTestComponent convertTestScriptTestComponent(TestScript.TestScriptTestComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.TestScriptTestComponent tgt = new TestScript.TestScriptTestComponent();
        VersionConvertor_14_40.copyElement((Element)src, (org.hl7.fhir.dstu2016may.model.Element)tgt);
        if (src.hasName()) {
            tgt.setName(src.getName());
        }
        if (src.hasDescription()) {
            tgt.setDescription(src.getDescription());
        }
        for (TestScript.TestActionComponent t : src.getAction()) {
            tgt.addAction(VersionConvertor_14_40.convertTestActionComponent(t));
        }
        return tgt;
    }

    public static TestScript.TestActionComponent convertTestActionComponent(TestScript.TestActionComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.TestActionComponent tgt = new TestScript.TestActionComponent();
        VersionConvertor_14_40.copyElement((org.hl7.fhir.dstu2016may.model.Element)src, (Element)tgt);
        tgt.setOperation(VersionConvertor_14_40.convertSetupActionOperationComponent(src.getOperation()));
        tgt.setAssert(VersionConvertor_14_40.convertSetupActionAssertComponent(src.getAssert()));
        return tgt;
    }

    public static TestScript.TestActionComponent convertTestActionComponent(TestScript.TestActionComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.TestActionComponent tgt = new TestScript.TestActionComponent();
        VersionConvertor_14_40.copyElement((Element)src, (org.hl7.fhir.dstu2016may.model.Element)tgt);
        tgt.setOperation(VersionConvertor_14_40.convertSetupActionOperationComponent(src.getOperation()));
        tgt.setAssert(VersionConvertor_14_40.convertSetupActionAssertComponent(src.getAssert()));
        return tgt;
    }

    public static TestScript.TestScriptTeardownComponent convertTestScriptTeardownComponent(TestScript.TestScriptTeardownComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.TestScriptTeardownComponent tgt = new TestScript.TestScriptTeardownComponent();
        VersionConvertor_14_40.copyElement((org.hl7.fhir.dstu2016may.model.Element)src, (Element)tgt);
        for (TestScript.TeardownActionComponent t : src.getAction()) {
            tgt.addAction(VersionConvertor_14_40.convertTeardownActionComponent(t));
        }
        return tgt;
    }

    public static TestScript.TestScriptTeardownComponent convertTestScriptTeardownComponent(TestScript.TestScriptTeardownComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.TestScriptTeardownComponent tgt = new TestScript.TestScriptTeardownComponent();
        VersionConvertor_14_40.copyElement((Element)src, (org.hl7.fhir.dstu2016may.model.Element)tgt);
        for (TestScript.TeardownActionComponent t : src.getAction()) {
            tgt.addAction(VersionConvertor_14_40.convertTeardownActionComponent(t));
        }
        return tgt;
    }

    public static TestScript.TeardownActionComponent convertTeardownActionComponent(TestScript.TeardownActionComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.TeardownActionComponent tgt = new TestScript.TeardownActionComponent();
        VersionConvertor_14_40.copyElement((org.hl7.fhir.dstu2016may.model.Element)src, (Element)tgt);
        tgt.setOperation(VersionConvertor_14_40.convertSetupActionOperationComponent(src.getOperation()));
        return tgt;
    }

    public static TestScript.TeardownActionComponent convertTeardownActionComponent(TestScript.TeardownActionComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.TeardownActionComponent tgt = new TestScript.TeardownActionComponent();
        VersionConvertor_14_40.copyElement((Element)src, (org.hl7.fhir.dstu2016may.model.Element)tgt);
        tgt.setOperation(VersionConvertor_14_40.convertSetupActionOperationComponent(src.getOperation()));
        return tgt;
    }

    public static org.hl7.fhir.r4.model.ValueSet convertValueSet(ValueSet src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r4.model.ValueSet tgt = new org.hl7.fhir.r4.model.ValueSet();
        VersionConvertor_14_40.copyDomainResource((DomainResource)src, (org.hl7.fhir.r4.model.DomainResource)tgt);
        if (src.hasUrl()) {
            tgt.setUrl(src.getUrl());
        }
        if (src.hasIdentifier()) {
            tgt.addIdentifier(VersionConvertor_14_40.convertIdentifier(src.getIdentifier()));
        }
        if (src.hasVersion()) {
            tgt.setVersion(src.getVersion());
        }
        if (src.hasName()) {
            tgt.setName(src.getName());
        }
        tgt.setStatus(VersionConvertor_14_40.convertConformanceResourceStatus(src.getStatus()));
        if (src.hasExperimental()) {
            tgt.setExperimental(src.getExperimental());
        }
        if (src.hasPublisher()) {
            tgt.setPublisher(src.getPublisher());
        }
        for (ValueSet.ValueSetContactComponent t : src.getContact()) {
            tgt.addContact(VersionConvertor_14_40.convertValueSetContactComponent(t));
        }
        if (src.hasDate()) {
            tgt.setDate(src.getDate());
        }
        if (src.hasDescription()) {
            tgt.setDescription(src.getDescription());
        }
        for (ValueSet.ValueSetContactComponent t : src.getUseContext()) {
            if (VersionConvertor_14_40.isJurisdiction((CodeableConcept)t)) {
                tgt.addJurisdiction(VersionConvertor_14_40.convertCodeableConcept((CodeableConcept)t));
                continue;
            }
            tgt.addUseContext(VersionConvertor_14_40.convertCodeableConceptToUsageContext((CodeableConcept)t));
        }
        if (src.hasImmutable()) {
            tgt.setImmutable(src.getImmutable());
        }
        if (src.hasRequirements()) {
            tgt.setPurpose(src.getRequirements());
        }
        if (src.hasCopyright()) {
            tgt.setCopyright(src.getCopyright());
        }
        if (src.hasExtensible()) {
            tgt.setExtensible(src.getExtensible());
        }
        tgt.setCompose(VersionConvertor_14_40.convertValueSetComposeComponent(src.getCompose()));
        if (src.hasLockedDate()) {
            tgt.getCompose().setLockedDate(src.getLockedDate());
        }
        tgt.setExpansion(VersionConvertor_14_40.convertValueSetExpansionComponent(src.getExpansion()));
        return tgt;
    }

    public static ValueSet convertValueSet(org.hl7.fhir.r4.model.ValueSet src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ValueSet tgt = new ValueSet();
        VersionConvertor_14_40.copyDomainResource((org.hl7.fhir.r4.model.DomainResource)src, (DomainResource)tgt);
        if (src.hasUrl()) {
            tgt.setUrl(src.getUrl());
        }
        for (Identifier t : src.getIdentifier()) {
            tgt.setIdentifier(VersionConvertor_14_40.convertIdentifier(t));
        }
        if (src.hasVersion()) {
            tgt.setVersion(src.getVersion());
        }
        if (src.hasName()) {
            tgt.setName(src.getName());
        }
        tgt.setStatus(VersionConvertor_14_40.convertConformanceResourceStatus(src.getStatus()));
        if (src.hasExperimental()) {
            tgt.setExperimental(src.getExperimental());
        }
        if (src.hasPublisher()) {
            tgt.setPublisher(src.getPublisher());
        }
        for (Identifier t : src.getContact()) {
            tgt.addContact(VersionConvertor_14_40.convertValueSetContactComponent((ContactDetail)t));
        }
        if (src.hasDate()) {
            tgt.setDate(src.getDate());
        }
        if (src.getCompose().hasLockedDate()) {
            tgt.setLockedDate(src.getCompose().getLockedDate());
        }
        if (src.hasDescription()) {
            tgt.setDescription(src.getDescription());
        }
        for (Identifier t : src.getUseContext()) {
            if (!t.hasValueCodeableConcept()) continue;
            tgt.addUseContext(VersionConvertor_14_40.convertCodeableConcept(t.getValueCodeableConcept()));
        }
        for (Identifier t : src.getJurisdiction()) {
            tgt.addUseContext(VersionConvertor_14_40.convertCodeableConcept((org.hl7.fhir.r4.model.CodeableConcept)t));
        }
        if (src.hasImmutable()) {
            tgt.setImmutable(src.getImmutable());
        }
        if (src.hasPurpose()) {
            tgt.setRequirements(src.getPurpose());
        }
        if (src.hasCopyright()) {
            tgt.setCopyright(src.getCopyright());
        }
        if (src.hasExtensible()) {
            tgt.setExtensible(src.getExtensible());
        }
        tgt.setCompose(VersionConvertor_14_40.convertValueSetComposeComponent(src.getCompose()));
        if (src.hasExpansion()) {
            tgt.setExpansion(VersionConvertor_14_40.convertValueSetExpansionComponent(src.getExpansion()));
        }
        return tgt;
    }

    public static ContactDetail convertValueSetContactComponent(ValueSet.ValueSetContactComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ContactDetail tgt = new ContactDetail();
        VersionConvertor_14_40.copyElement((org.hl7.fhir.dstu2016may.model.Element)src, (Element)tgt);
        if (src.hasName()) {
            tgt.setName(src.getName());
        }
        for (org.hl7.fhir.dstu2016may.model.ContactPoint t : src.getTelecom()) {
            tgt.addTelecom(VersionConvertor_14_40.convertContactPoint(t));
        }
        return tgt;
    }

    public static ValueSet.ValueSetContactComponent convertValueSetContactComponent(ContactDetail src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ValueSet.ValueSetContactComponent tgt = new ValueSet.ValueSetContactComponent();
        VersionConvertor_14_40.copyElement((Element)src, (org.hl7.fhir.dstu2016may.model.Element)tgt);
        if (src.hasName()) {
            tgt.setName(src.getName());
        }
        for (ContactPoint t : src.getTelecom()) {
            tgt.addTelecom(VersionConvertor_14_40.convertContactPoint(t));
        }
        return tgt;
    }

    public static ValueSet.ValueSetComposeComponent convertValueSetComposeComponent(ValueSet.ValueSetComposeComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ValueSet.ValueSetComposeComponent tgt = new ValueSet.ValueSetComposeComponent();
        VersionConvertor_14_40.copyElement((org.hl7.fhir.dstu2016may.model.Element)src, (Element)tgt);
        for (org.hl7.fhir.dstu2016may.model.UriType t : src.getImport()) {
            tgt.addInclude().addValueSet((String)t.getValue());
        }
        for (org.hl7.fhir.dstu2016may.model.UriType t : src.getInclude()) {
            tgt.addInclude(VersionConvertor_14_40.convertConceptSetComponent((ValueSet.ConceptSetComponent)t));
        }
        for (org.hl7.fhir.dstu2016may.model.UriType t : src.getExclude()) {
            tgt.addExclude(VersionConvertor_14_40.convertConceptSetComponent((ValueSet.ConceptSetComponent)t));
        }
        return tgt;
    }

    public static ValueSet.ValueSetComposeComponent convertValueSetComposeComponent(ValueSet.ValueSetComposeComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ValueSet.ValueSetComposeComponent tgt = new ValueSet.ValueSetComposeComponent();
        VersionConvertor_14_40.copyElement((Element)src, (org.hl7.fhir.dstu2016may.model.Element)tgt);
        for (ValueSet.ConceptSetComponent t : src.getInclude()) {
            for (UriType ti : t.getValueSet()) {
                tgt.addImport((String)ti.getValue());
            }
            tgt.addInclude(VersionConvertor_14_40.convertConceptSetComponent(t));
        }
        for (ValueSet.ConceptSetComponent t : src.getExclude()) {
            tgt.addExclude(VersionConvertor_14_40.convertConceptSetComponent(t));
        }
        return tgt;
    }

    public static ValueSet.ConceptSetComponent convertConceptSetComponent(ValueSet.ConceptSetComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ValueSet.ConceptSetComponent tgt = new ValueSet.ConceptSetComponent();
        VersionConvertor_14_40.copyElement((org.hl7.fhir.dstu2016may.model.Element)src, (Element)tgt);
        tgt.setSystem(src.getSystem());
        if (src.hasVersion()) {
            tgt.setVersion(src.getVersion());
        }
        for (ValueSet.ConceptReferenceComponent t : src.getConcept()) {
            tgt.addConcept(VersionConvertor_14_40.convertConceptReferenceComponent(t));
        }
        for (ValueSet.ConceptReferenceComponent t : src.getFilter()) {
            tgt.addFilter(VersionConvertor_14_40.convertConceptSetFilterComponent((ValueSet.ConceptSetFilterComponent)t));
        }
        return tgt;
    }

    public static ValueSet.ConceptSetComponent convertConceptSetComponent(ValueSet.ConceptSetComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ValueSet.ConceptSetComponent tgt = new ValueSet.ConceptSetComponent();
        VersionConvertor_14_40.copyElement((Element)src, (org.hl7.fhir.dstu2016may.model.Element)tgt);
        tgt.setSystem(src.getSystem());
        if (src.hasVersion()) {
            tgt.setVersion(src.getVersion());
        }
        for (ValueSet.ConceptReferenceComponent t : src.getConcept()) {
            tgt.addConcept(VersionConvertor_14_40.convertConceptReferenceComponent(t));
        }
        for (ValueSet.ConceptReferenceComponent t : src.getFilter()) {
            tgt.addFilter(VersionConvertor_14_40.convertConceptSetFilterComponent((ValueSet.ConceptSetFilterComponent)t));
        }
        return tgt;
    }

    public static ValueSet.ConceptReferenceComponent convertConceptReferenceComponent(ValueSet.ConceptReferenceComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ValueSet.ConceptReferenceComponent tgt = new ValueSet.ConceptReferenceComponent();
        VersionConvertor_14_40.copyElement((org.hl7.fhir.dstu2016may.model.Element)src, (Element)tgt);
        tgt.setCode(src.getCode());
        if (src.hasDisplay()) {
            tgt.setDisplay(src.getDisplay());
        }
        for (ValueSet.ConceptReferenceDesignationComponent t : src.getDesignation()) {
            tgt.addDesignation(VersionConvertor_14_40.convertConceptReferenceDesignationComponent(t));
        }
        return tgt;
    }

    public static ValueSet.ConceptReferenceComponent convertConceptReferenceComponent(ValueSet.ConceptReferenceComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ValueSet.ConceptReferenceComponent tgt = new ValueSet.ConceptReferenceComponent();
        VersionConvertor_14_40.copyElement((Element)src, (org.hl7.fhir.dstu2016may.model.Element)tgt);
        tgt.setCode(src.getCode());
        if (src.hasDisplay()) {
            tgt.setDisplay(src.getDisplay());
        }
        for (ValueSet.ConceptReferenceDesignationComponent t : src.getDesignation()) {
            tgt.addDesignation(VersionConvertor_14_40.convertConceptReferenceDesignationComponent(t));
        }
        return tgt;
    }

    public static ValueSet.ConceptReferenceDesignationComponent convertConceptReferenceDesignationComponent(ValueSet.ConceptReferenceDesignationComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ValueSet.ConceptReferenceDesignationComponent tgt = new ValueSet.ConceptReferenceDesignationComponent();
        VersionConvertor_14_40.copyElement((org.hl7.fhir.dstu2016may.model.Element)src, (Element)tgt);
        if (src.hasLanguage()) {
            tgt.setLanguage(src.getLanguage());
        }
        tgt.setUse(VersionConvertor_14_40.convertCoding(src.getUse()));
        tgt.setValue(src.getValue());
        return tgt;
    }

    public static ValueSet.ConceptReferenceDesignationComponent convertConceptReferenceDesignationComponent(ValueSet.ConceptReferenceDesignationComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ValueSet.ConceptReferenceDesignationComponent tgt = new ValueSet.ConceptReferenceDesignationComponent();
        VersionConvertor_14_40.copyElement((Element)src, (org.hl7.fhir.dstu2016may.model.Element)tgt);
        if (src.hasLanguage()) {
            tgt.setLanguage(src.getLanguage());
        }
        tgt.setUse(VersionConvertor_14_40.convertCoding(src.getUse()));
        tgt.setValue(src.getValue());
        return tgt;
    }

    public static ValueSet.ConceptSetFilterComponent convertConceptSetFilterComponent(ValueSet.ConceptSetFilterComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ValueSet.ConceptSetFilterComponent tgt = new ValueSet.ConceptSetFilterComponent();
        VersionConvertor_14_40.copyElement((org.hl7.fhir.dstu2016may.model.Element)src, (Element)tgt);
        tgt.setProperty(src.getProperty());
        tgt.setOp(VersionConvertor_14_40.convertFilterOperator(src.getOp()));
        tgt.setValue(src.getValue());
        return tgt;
    }

    public static ValueSet.ConceptSetFilterComponent convertConceptSetFilterComponent(ValueSet.ConceptSetFilterComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ValueSet.ConceptSetFilterComponent tgt = new ValueSet.ConceptSetFilterComponent();
        VersionConvertor_14_40.copyElement((Element)src, (org.hl7.fhir.dstu2016may.model.Element)tgt);
        tgt.setProperty(src.getProperty());
        tgt.setOp(VersionConvertor_14_40.convertFilterOperator(src.getOp()));
        tgt.setValue(src.getValue());
        return tgt;
    }

    private static ValueSet.FilterOperator convertFilterOperator(ValueSet.FilterOperator src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case EQUAL: {
                return ValueSet.FilterOperator.EQUAL;
            }
            case ISA: {
                return ValueSet.FilterOperator.ISA;
            }
            case ISNOTA: {
                return ValueSet.FilterOperator.ISNOTA;
            }
            case REGEX: {
                return ValueSet.FilterOperator.REGEX;
            }
            case IN: {
                return ValueSet.FilterOperator.IN;
            }
            case NOTIN: {
                return ValueSet.FilterOperator.NOTIN;
            }
        }
        return ValueSet.FilterOperator.NULL;
    }

    private static ValueSet.FilterOperator convertFilterOperator(ValueSet.FilterOperator src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case EQUAL: {
                return ValueSet.FilterOperator.EQUAL;
            }
            case ISA: {
                return ValueSet.FilterOperator.ISA;
            }
            case ISNOTA: {
                return ValueSet.FilterOperator.ISNOTA;
            }
            case REGEX: {
                return ValueSet.FilterOperator.REGEX;
            }
            case IN: {
                return ValueSet.FilterOperator.IN;
            }
            case NOTIN: {
                return ValueSet.FilterOperator.NOTIN;
            }
        }
        return ValueSet.FilterOperator.NULL;
    }

    public static ValueSet.ValueSetExpansionComponent convertValueSetExpansionComponent(ValueSet.ValueSetExpansionComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ValueSet.ValueSetExpansionComponent tgt = new ValueSet.ValueSetExpansionComponent();
        VersionConvertor_14_40.copyElement((org.hl7.fhir.dstu2016may.model.Element)src, (Element)tgt);
        tgt.setIdentifier(src.getIdentifier());
        tgt.setTimestamp(src.getTimestamp());
        if (src.hasTotal()) {
            tgt.setTotal(src.getTotal());
        }
        if (src.hasOffset()) {
            tgt.setOffset(src.getOffset());
        }
        for (ValueSet.ValueSetExpansionParameterComponent t : src.getParameter()) {
            tgt.addParameter(VersionConvertor_14_40.convertValueSetExpansionParameterComponent(t));
        }
        for (ValueSet.ValueSetExpansionParameterComponent t : src.getContains()) {
            tgt.addContains(VersionConvertor_14_40.convertValueSetExpansionContainsComponent((ValueSet.ValueSetExpansionContainsComponent)t));
        }
        return tgt;
    }

    public static ValueSet.ValueSetExpansionComponent convertValueSetExpansionComponent(ValueSet.ValueSetExpansionComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ValueSet.ValueSetExpansionComponent tgt = new ValueSet.ValueSetExpansionComponent();
        VersionConvertor_14_40.copyElement((Element)src, (org.hl7.fhir.dstu2016may.model.Element)tgt);
        tgt.setIdentifier(src.getIdentifier());
        tgt.setTimestamp(src.getTimestamp());
        if (src.hasTotal()) {
            tgt.setTotal(src.getTotal());
        }
        if (src.hasOffset()) {
            tgt.setOffset(src.getOffset());
        }
        for (ValueSet.ValueSetExpansionParameterComponent t : src.getParameter()) {
            tgt.addParameter(VersionConvertor_14_40.convertValueSetExpansionParameterComponent(t));
        }
        for (ValueSet.ValueSetExpansionParameterComponent t : src.getContains()) {
            tgt.addContains(VersionConvertor_14_40.convertValueSetExpansionContainsComponent((ValueSet.ValueSetExpansionContainsComponent)t));
        }
        return tgt;
    }

    public static ValueSet.ValueSetExpansionParameterComponent convertValueSetExpansionParameterComponent(ValueSet.ValueSetExpansionParameterComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ValueSet.ValueSetExpansionParameterComponent tgt = new ValueSet.ValueSetExpansionParameterComponent();
        VersionConvertor_14_40.copyElement((org.hl7.fhir.dstu2016may.model.Element)src, (Element)tgt);
        tgt.setName(src.getName());
        tgt.setValue(VersionConvertor_14_40.convertType(src.getValue()));
        return tgt;
    }

    public static ValueSet.ValueSetExpansionParameterComponent convertValueSetExpansionParameterComponent(ValueSet.ValueSetExpansionParameterComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ValueSet.ValueSetExpansionParameterComponent tgt = new ValueSet.ValueSetExpansionParameterComponent();
        VersionConvertor_14_40.copyElement((Element)src, (org.hl7.fhir.dstu2016may.model.Element)tgt);
        tgt.setName(src.getName());
        tgt.setValue(VersionConvertor_14_40.convertType(src.getValue()));
        return tgt;
    }

    public static ValueSet.ValueSetExpansionContainsComponent convertValueSetExpansionContainsComponent(ValueSet.ValueSetExpansionContainsComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ValueSet.ValueSetExpansionContainsComponent tgt = new ValueSet.ValueSetExpansionContainsComponent();
        VersionConvertor_14_40.copyElement((org.hl7.fhir.dstu2016may.model.Element)src, (Element)tgt);
        if (src.hasSystem()) {
            tgt.setSystem(src.getSystem());
        }
        if (src.hasAbstract()) {
            tgt.setAbstract(src.getAbstract());
        }
        if (src.hasVersion()) {
            tgt.setVersion(src.getVersion());
        }
        if (src.hasCode()) {
            tgt.setCode(src.getCode());
        }
        if (src.hasDisplay()) {
            tgt.setDisplay(src.getDisplay());
        }
        for (ValueSet.ValueSetExpansionContainsComponent t : src.getContains()) {
            tgt.addContains(VersionConvertor_14_40.convertValueSetExpansionContainsComponent(t));
        }
        return tgt;
    }

    public static ValueSet.ValueSetExpansionContainsComponent convertValueSetExpansionContainsComponent(ValueSet.ValueSetExpansionContainsComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ValueSet.ValueSetExpansionContainsComponent tgt = new ValueSet.ValueSetExpansionContainsComponent();
        VersionConvertor_14_40.copyElement((Element)src, (org.hl7.fhir.dstu2016may.model.Element)tgt);
        if (src.hasSystem()) {
            tgt.setSystem(src.getSystem());
        }
        if (src.hasAbstract()) {
            tgt.setAbstract(src.getAbstract());
        }
        if (src.hasVersion()) {
            tgt.setVersion(src.getVersion());
        }
        if (src.hasCode()) {
            tgt.setCode(src.getCode());
        }
        if (src.hasDisplay()) {
            tgt.setDisplay(src.getDisplay());
        }
        for (ValueSet.ValueSetExpansionContainsComponent t : src.getContains()) {
            tgt.addContains(VersionConvertor_14_40.convertValueSetExpansionContainsComponent(t));
        }
        return tgt;
    }

    public static Resource convertResource(org.hl7.fhir.dstu2016may.model.Resource src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        if (src instanceof org.hl7.fhir.dstu2016may.model.Parameters) {
            return VersionConvertor_14_40.convertParameters((org.hl7.fhir.dstu2016may.model.Parameters)src);
        }
        if (src instanceof org.hl7.fhir.dstu2016may.model.Bundle) {
            return VersionConvertor_14_40.convertBundle((org.hl7.fhir.dstu2016may.model.Bundle)src);
        }
        if (src instanceof org.hl7.fhir.dstu2016may.model.CodeSystem) {
            return VersionConvertor_14_40.convertCodeSystem((org.hl7.fhir.dstu2016may.model.CodeSystem)src);
        }
        if (src instanceof org.hl7.fhir.dstu2016may.model.CompartmentDefinition) {
            return VersionConvertor_14_40.convertCompartmentDefinition((org.hl7.fhir.dstu2016may.model.CompartmentDefinition)src);
        }
        if (src instanceof org.hl7.fhir.dstu2016may.model.ConceptMap) {
            return VersionConvertor_14_40.convertConceptMap((org.hl7.fhir.dstu2016may.model.ConceptMap)src);
        }
        if (src instanceof Conformance) {
            return VersionConvertor_14_40.convertConformance((Conformance)src);
        }
        if (src instanceof DataElement) {
            return VersionConvertor_14_40.convertDataElement((DataElement)src);
        }
        if (src instanceof ImplementationGuide) {
            return VersionConvertor_14_40.convertImplementationGuide((ImplementationGuide)src);
        }
        if (src instanceof NamingSystem) {
            return VersionConvertor_14_40.convertNamingSystem((NamingSystem)src);
        }
        if (src instanceof OperationDefinition) {
            return VersionConvertor_14_40.convertOperationDefinition((OperationDefinition)src);
        }
        if (src instanceof OperationOutcome) {
            return VersionConvertor_14_40.convertOperationOutcome((OperationOutcome)src);
        }
        if (src instanceof Questionnaire) {
            return VersionConvertor_14_40.convertQuestionnaire((Questionnaire)src);
        }
        if (src instanceof org.hl7.fhir.dstu2016may.model.QuestionnaireResponse) {
            return VersionConvertor_14_40.convertQuestionnaireResponse((org.hl7.fhir.dstu2016may.model.QuestionnaireResponse)src);
        }
        if (src instanceof SearchParameter) {
            return VersionConvertor_14_40.convertSearchParameter((SearchParameter)src);
        }
        if (src instanceof StructureDefinition) {
            return VersionConvertor_14_40.convertStructureDefinition((StructureDefinition)src);
        }
        if (src instanceof TestScript) {
            return VersionConvertor_14_40.convertTestScript((TestScript)src);
        }
        if (src instanceof ValueSet) {
            return VersionConvertor_14_40.convertValueSet((ValueSet)src);
        }
        throw new Error("Unknown resource " + src.fhirType());
    }

    public static org.hl7.fhir.dstu2016may.model.Resource convertResource(Resource src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        if (src instanceof Parameters) {
            return VersionConvertor_14_40.convertParameters((Parameters)src);
        }
        if (src instanceof Bundle) {
            return VersionConvertor_14_40.convertBundle((Bundle)src);
        }
        if (src instanceof CodeSystem) {
            return VersionConvertor_14_40.convertCodeSystem((CodeSystem)src);
        }
        if (src instanceof CompartmentDefinition) {
            return VersionConvertor_14_40.convertCompartmentDefinition((CompartmentDefinition)src);
        }
        if (src instanceof ConceptMap) {
            return VersionConvertor_14_40.convertConceptMap((ConceptMap)src);
        }
        if (src instanceof CapabilityStatement) {
            return VersionConvertor_14_40.convertConformance((CapabilityStatement)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.ImplementationGuide) {
            return VersionConvertor_14_40.convertImplementationGuide((org.hl7.fhir.r4.model.ImplementationGuide)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.NamingSystem) {
            return VersionConvertor_14_40.convertNamingSystem((org.hl7.fhir.r4.model.NamingSystem)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.OperationDefinition) {
            return VersionConvertor_14_40.convertOperationDefinition((org.hl7.fhir.r4.model.OperationDefinition)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.OperationOutcome) {
            return VersionConvertor_14_40.convertOperationOutcome((org.hl7.fhir.r4.model.OperationOutcome)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.Questionnaire) {
            return VersionConvertor_14_40.convertQuestionnaire((org.hl7.fhir.r4.model.Questionnaire)src);
        }
        if (src instanceof QuestionnaireResponse) {
            return VersionConvertor_14_40.convertQuestionnaireResponse((QuestionnaireResponse)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.SearchParameter) {
            return VersionConvertor_14_40.convertSearchParameter((org.hl7.fhir.r4.model.SearchParameter)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.StructureDefinition) {
            return VersionConvertor_14_40.convertStructureDefinition((org.hl7.fhir.r4.model.StructureDefinition)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.TestScript) {
            return VersionConvertor_14_40.convertTestScript((org.hl7.fhir.r4.model.TestScript)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.ValueSet) {
            return VersionConvertor_14_40.convertValueSet((org.hl7.fhir.r4.model.ValueSet)src);
        }
        throw new Error("Unknown resource " + src.fhirType());
    }

    static {
        CANONICAL_URLS.add("http://hl7.org/fhir/StructureDefinition/11179-permitted-value-conceptmap");
        CANONICAL_URLS.add("http://hl7.org/fhir/StructureDefinition/11179-permitted-value-valueset");
        CANONICAL_URLS.add("http://hl7.org/fhir/StructureDefinition/codesystem-map");
        CANONICAL_URLS.add("http://hl7.org/fhir/StructureDefinition/cqif-library");
        CANONICAL_URLS.add("http://hl7.org/fhir/StructureDefinition/elementdefinition-allowedUnits");
        CANONICAL_URLS.add("http://hl7.org/fhir/StructureDefinition/elementdefinition-inheritedExtensibleValueSet");
        CANONICAL_URLS.add("http://hl7.org/fhir/StructureDefinition/elementdefinition-maxValueSet");
        CANONICAL_URLS.add("http://hl7.org/fhir/StructureDefinition/elementdefinition-minValueSet");
        CANONICAL_URLS.add("http://hl7.org/fhir/StructureDefinition/event-instantiatesCanonical");
        CANONICAL_URLS.add("http://hl7.org/fhir/StructureDefinition/questionnaire-allowedProfile");
        CANONICAL_URLS.add("http://hl7.org/fhir/StructureDefinition/questionnaire-deMap");
        CANONICAL_URLS.add("http://hl7.org/fhir/StructureDefinition/questionnaire-sourceStructureMap");
        CANONICAL_URLS.add("http://hl7.org/fhir/StructureDefinition/questionnaire-targetStructureMap");
        CANONICAL_URLS.add("http://hl7.org/fhir/StructureDefinition/questionnaire-unit-valueSet");
        CANONICAL_URLS.add("http://hl7.org/fhir/StructureDefinition/valueset-map");
        CANONICAL_URLS.add("http://hl7.org/fhir/StructureDefinition/valueset-supplement");
        CANONICAL_URLS.add("http://hl7.org/fhir/StructureDefinition/valueset-system");
    }

    private static class SourceElementComponentWrapper {
        private String source;
        private String target;
        private ConceptMap.SourceElementComponent comp;

        public SourceElementComponentWrapper(ConceptMap.SourceElementComponent comp, String source, String target) {
            this.source = source;
            this.target = target;
            this.comp = comp;
        }
    }
}

