/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.hapi.validation;

import ca.uhn.fhir.context.FhirContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.dstu2016may.hapi.validation.IValidationSupport;
import org.hl7.fhir.dstu2016may.model.CodeSystem;
import org.hl7.fhir.dstu2016may.model.StructureDefinition;
import org.hl7.fhir.dstu2016may.model.ValueSet;
import org.hl7.fhir.instance.model.api.IBaseResource;

public class PrePopulatedValidationSupport
implements IValidationSupport {
    private Map<String, StructureDefinition> myStructureDefinitions;
    private Map<String, ValueSet> myValueSets;
    private Map<String, CodeSystem> myCodeSystems;

    public PrePopulatedValidationSupport() {
        this.myStructureDefinitions = new HashMap<String, StructureDefinition>();
        this.myValueSets = new HashMap<String, ValueSet>();
        this.myCodeSystems = new HashMap<String, CodeSystem>();
    }

    public PrePopulatedValidationSupport(Map<String, StructureDefinition> theStructureDefinitions, Map<String, ValueSet> theValueSets, Map<String, CodeSystem> theCodeSystems) {
        this.myStructureDefinitions = theStructureDefinitions;
        this.myValueSets = theValueSets;
        this.myCodeSystems = theCodeSystems;
    }

    public void addCodeSystem(CodeSystem theCodeSystem) {
        Validate.notBlank((CharSequence)theCodeSystem.getUrl(), (String)"theCodeSystem.getUrl() must not return a value", (Object[])new Object[0]);
        this.myCodeSystems.put(theCodeSystem.getUrl(), theCodeSystem);
    }

    public void addStructureDefinition(StructureDefinition theStructureDefinition) {
        Validate.notBlank((CharSequence)theStructureDefinition.getUrl(), (String)"theStructureDefinition.getUrl() must not return a value", (Object[])new Object[0]);
        this.myStructureDefinitions.put(theStructureDefinition.getUrl(), theStructureDefinition);
    }

    public void addValueSet(ValueSet theValueSet) {
        Validate.notBlank((CharSequence)theValueSet.getUrl(), (String)"theValueSet.getUrl() must not return a value", (Object[])new Object[0]);
        this.myValueSets.put(theValueSet.getUrl(), theValueSet);
    }

    @Override
    public ValueSet.ValueSetExpansionComponent expandValueSet(FhirContext theContext, ValueSet.ConceptSetComponent theInclude) {
        return null;
    }

    public List<IBaseResource> fetchAllConformanceResources(FhirContext theContext) {
        ArrayList<IBaseResource> retVal = new ArrayList<IBaseResource>();
        retVal.addAll(this.myCodeSystems.values());
        retVal.addAll(this.myStructureDefinitions.values());
        retVal.addAll(this.myValueSets.values());
        return retVal;
    }

    @Override
    public List<StructureDefinition> fetchAllStructureDefinitions(FhirContext theContext) {
        return new ArrayList<StructureDefinition>(this.myStructureDefinitions.values());
    }

    @Override
    public CodeSystem fetchCodeSystem(FhirContext theContext, String theSystem) {
        return this.myCodeSystems.get(theSystem);
    }

    @Override
    public <T extends IBaseResource> T fetchResource(FhirContext theContext, Class<T> theClass, String theUri) {
        if (theClass.equals(StructureDefinition.class)) {
            return (T)((IBaseResource)this.myStructureDefinitions.get(theUri));
        }
        if (theClass.equals(ValueSet.class)) {
            return (T)((IBaseResource)this.myValueSets.get(theUri));
        }
        if (theClass.equals(CodeSystem.class)) {
            return (T)((IBaseResource)this.myCodeSystems.get(theUri));
        }
        return null;
    }

    @Override
    public StructureDefinition fetchStructureDefinition(FhirContext theCtx, String theUrl) {
        return this.myStructureDefinitions.get(theUrl);
    }

    @Override
    public boolean isCodeSystemSupported(FhirContext theContext, String theSystem) {
        return false;
    }

    @Override
    public IValidationSupport.CodeValidationResult validateCode(FhirContext theContext, String theCodeSystem, String theCode, String theDisplay) {
        return null;
    }
}

