/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.metamodel;

import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.dstu2016may.metamodel.ParserBase;
import org.hl7.fhir.dstu2016may.metamodel.Property;
import org.hl7.fhir.dstu2016may.model.Base;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.xhtml.XhtmlNode;

public class Element
extends Base {
    private List<String> comments;
    private String name;
    private String type;
    private String value;
    private int index = -1;
    private List<Element> children;
    private Property property;
    private int line;
    private int col;
    private SpecialElement special;
    private XhtmlNode xhtml;

    public Element(String name) {
        this.name = name;
    }

    public Element(String name, Property property) {
        this.name = name;
        this.property = property;
    }

    public Element(String name, Property property, String type, String value) {
        this.name = name;
        this.property = property;
        this.type = type;
        this.value = value;
    }

    public void updateProperty(Property property, SpecialElement special) {
        this.property = property;
        this.special = special;
    }

    public SpecialElement getSpecial() {
        return this.special;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        if (this.type == null) {
            return this.property.getType(this.name);
        }
        return this.type;
    }

    public String getValue() {
        return this.value;
    }

    public boolean hasChildren() {
        return this.children != null && !this.children.isEmpty();
    }

    public List<Element> getChildren() {
        if (this.children == null) {
            this.children = new ArrayList<Element>();
        }
        return this.children;
    }

    public boolean hasComments() {
        return this.comments != null && !this.comments.isEmpty();
    }

    public List<String> getComments() {
        if (this.comments == null) {
            this.comments = new ArrayList<String>();
        }
        return this.comments;
    }

    public Property getProperty() {
        return this.property;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean hasValue() {
        return this.value != null;
    }

    public List<Element> getChildrenByName(String name) {
        ArrayList<Element> res = new ArrayList<Element>();
        if (this.hasChildren()) {
            for (Element child : this.children) {
                if (!name.equals(child.getName())) continue;
                res.add(child);
            }
        }
        return res;
    }

    public void numberChildren() {
        if (this.children == null) {
            return;
        }
        String last = "";
        int index = 0;
        for (Element child : this.children) {
            if (child.getProperty().isList()) {
                if (!last.equals(child.getName())) {
                    last = child.getName();
                    index = 0;
                }
                child.index = ++index;
            } else {
                child.index = -1;
            }
            child.numberChildren();
        }
    }

    public int getIndex() {
        return this.index;
    }

    public boolean hasIndex() {
        return this.index > -1;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public String getChildValue(String name) {
        if (this.children == null) {
            return null;
        }
        for (Element child : this.children) {
            if (!name.equals(child.getName())) continue;
            return child.getValue();
        }
        return null;
    }

    public List<Element> getChildren(String name) {
        ArrayList<Element> res = new ArrayList<Element>();
        for (Element child : this.children) {
            if (!name.equals(child.getName())) continue;
            res.add(child);
        }
        return res;
    }

    public boolean hasType() {
        if (this.type == null) {
            return this.property.hasType(this.name);
        }
        return true;
    }

    @Override
    public String fhirType() {
        return this.getType();
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        if (this.isPrimitive() && hash == "value".hashCode() && !Utilities.noString((String)this.value)) {
            String tn = this.getType();
            throw new Error("not done yet");
        }
        ArrayList<Element> result = new ArrayList<Element>();
        for (Element child : this.children) {
            if (child.getName().equals(name)) {
                result.add(child);
            }
            if (!child.getName().startsWith(name) || !child.getProperty().isChoice() || !child.getProperty().getName().equals(name + "[x]")) continue;
            result.add(child);
        }
        if (!result.isEmpty() || checkValid) {
            // empty if block
        }
        return result.toArray(new Base[result.size()]);
    }

    @Override
    protected void listChildren(List<org.hl7.fhir.dstu2016may.model.Property> result) {
    }

    @Override
    public boolean isPrimitive() {
        return this.type != null ? ParserBase.isPrimitive(this.type) : this.property.isPrimitive(this.name);
    }

    @Override
    public boolean hasPrimitiveValue() {
        return this.property.isPrimitive(this.name) || this.property.IsLogicalAndHasPrimitiveValue(this.name);
    }

    @Override
    public String primitiveValue() {
        if (this.isPrimitive()) {
            return this.value;
        }
        if (this.hasPrimitiveValue()) {
            for (Element c : this.children) {
                if (!c.getName().equals("value")) continue;
                return c.primitiveValue();
            }
        }
        return null;
    }

    public int line() {
        return this.line;
    }

    public int col() {
        return this.col;
    }

    public Element markLocation(int line, int col) {
        this.line = line;
        this.col = col;
        return this;
    }

    public Element getNamedChild(String name) {
        if (this.children == null) {
            return null;
        }
        Element result = null;
        for (Element child : this.children) {
            if (!child.getName().equals(name)) continue;
            if (result == null) {
                result = child;
                continue;
            }
            throw new Error("Attempt to read a single element when there is more than one present (" + name + ")");
        }
        return result;
    }

    public void getNamedChildren(String name, List<Element> list) {
        if (this.children != null) {
            for (Element child : this.children) {
                if (!child.getName().equals(name)) continue;
                list.add(child);
            }
        }
    }

    public String getNamedChildValue(String name) {
        Element child = this.getNamedChild(name);
        return child == null ? null : child.value;
    }

    public void getNamedChildrenWithWildcard(String string, List<Element> values) {
        throw new Error("not done yet");
    }

    public XhtmlNode getXhtml() {
        return this.xhtml;
    }

    public Element setXhtml(XhtmlNode xhtml) {
        this.xhtml = xhtml;
        return this;
    }

    public static enum SpecialElement {
        CONTAINED,
        BUNDLE_ENTRY;

    }
}

