/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.metamodel;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.dstu2016may.formats.IParser;
import org.hl7.fhir.dstu2016may.metamodel.Element;
import org.hl7.fhir.dstu2016may.metamodel.Property;
import org.hl7.fhir.dstu2016may.model.ElementDefinition;
import org.hl7.fhir.dstu2016may.model.StructureDefinition;
import org.hl7.fhir.dstu2016may.utils.IWorkerContext;
import org.hl7.fhir.dstu2016may.utils.ProfileUtilities;
import org.hl7.fhir.dstu2016may.utils.ToolingExtensions;
import org.hl7.fhir.exceptions.DefinitionException;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.validation.ValidationMessage;

public abstract class ParserBase {
    protected IWorkerContext context;
    protected ValidationPolicy policy;
    protected List<ValidationMessage> errors;

    public ParserBase(IWorkerContext context) {
        this.context = context;
        this.policy = ValidationPolicy.NONE;
    }

    public abstract void compose(Element var1, OutputStream var2, IParser.OutputStyle var3, String var4) throws Exception;

    protected List<Property> getChildProperties(Property property, String elementName, String statedType) throws DefinitionException {
        ElementDefinition ed = property.getDefinition();
        StructureDefinition sd = property.getStructure();
        List<ElementDefinition> children = ProfileUtilities.getChildMap(sd, ed);
        if (children.isEmpty()) {
            String t = null;
            if (ed.getType().size() == 1) {
                t = ed.getType().get(0).getCode();
            } else {
                if (ed.getType().size() == 0) {
                    throw new Error("types == 0, and no children found");
                }
                t = ed.getType().get(0).getCode();
                boolean all = true;
                for (ElementDefinition.TypeRefComponent tr : ed.getType()) {
                    if (tr.getCode().equals(t)) continue;
                    all = false;
                    break;
                }
                if (!all) {
                    if (ed.hasRepresentation(ElementDefinition.PropertyRepresentation.TYPEATTR)) {
                        t = statedType;
                        if (t == null && ToolingExtensions.hasExtension(ed, "http://hl7.org/fhir/StructureDefinition/elementdefinition-defaultype")) {
                            t = ToolingExtensions.readStringExtension(ed, "http://hl7.org/fhir/StructureDefinition/elementdefinition-defaultype");
                        }
                        boolean ok = false;
                        for (ElementDefinition.TypeRefComponent tr : ed.getType()) {
                            if (!tr.getCode().equals(t)) continue;
                            ok = true;
                        }
                        if (!ok) {
                            throw new DefinitionException("Type '" + t + "' is not an acceptable type for '" + elementName + "' on property " + property.getDefinition().getPath());
                        }
                    } else {
                        t = elementName.substring(this.tail(ed.getPath()).length() - 3);
                        if (ParserBase.isPrimitive(this.lowFirst(t))) {
                            t = this.lowFirst(t);
                        }
                    }
                }
            }
            if (!"xhtml".equals(t)) {
                sd = this.context.fetchResource(StructureDefinition.class, "http://hl7.org/fhir/StructureDefinition/" + t);
                if (sd == null) {
                    throw new DefinitionException("Unable to find class '" + t + "' for name '" + elementName + "' on property " + property.getDefinition().getPath());
                }
                children = ProfileUtilities.getChildMap(sd, sd.getSnapshot().getElement().get(0));
            }
        }
        ArrayList<Property> properties = new ArrayList<Property>();
        for (ElementDefinition child : children) {
            properties.add(new Property(this.context, child, sd));
        }
        return properties;
    }

    protected StructureDefinition getDefinition(int line, int col, String name) throws FHIRFormatError {
        if (name == null) {
            this.logError(line, col, name, ValidationMessage.IssueType.STRUCTURE, "This cannot be parsed as a FHIR object (no name)", ValidationMessage.IssueSeverity.FATAL);
            return null;
        }
        for (StructureDefinition sd : this.context.allStructures()) {
            if (!name.equals(sd.getIdElement().getIdPart())) continue;
            return sd;
        }
        this.logError(line, col, name, ValidationMessage.IssueType.STRUCTURE, "This does not appear to be a FHIR resource (unknown name '" + name + "')", ValidationMessage.IssueSeverity.FATAL);
        return null;
    }

    protected StructureDefinition getDefinition(int line, int col, String ns, String name) throws FHIRFormatError {
        if (ns == null) {
            this.logError(line, col, name, ValidationMessage.IssueType.STRUCTURE, "This cannot be parsed as a FHIR object (no namespace)", ValidationMessage.IssueSeverity.FATAL);
            return null;
        }
        if (name == null) {
            this.logError(line, col, name, ValidationMessage.IssueType.STRUCTURE, "This cannot be parsed as a FHIR object (no name)", ValidationMessage.IssueSeverity.FATAL);
            return null;
        }
        for (StructureDefinition sd : this.context.allStructures()) {
            if (!name.equals(sd.getIdElement().getIdPart())) continue;
            if ((ns == null || ns.equals("http://hl7.org/fhir")) && !ToolingExtensions.hasExtension(sd, "http://hl7.org/fhir/StructureDefinition/elementdefinition-namespace")) {
                return sd;
            }
            String sns = ToolingExtensions.readStringExtension(sd, "http://hl7.org/fhir/StructureDefinition/elementdefinition-namespace");
            if (ns == null || !ns.equals(sns)) continue;
            return sd;
        }
        this.logError(line, col, name, ValidationMessage.IssueType.STRUCTURE, "This does not appear to be a FHIR resource (unknown namespace/name '" + ns + "::" + name + "')", ValidationMessage.IssueSeverity.FATAL);
        return null;
    }

    public void logError(int line, int col, String path, ValidationMessage.IssueType type, String message, ValidationMessage.IssueSeverity level) throws FHIRFormatError {
        if (this.policy == ValidationPolicy.EVERYTHING) {
            ValidationMessage msg = new ValidationMessage(ValidationMessage.Source.InstanceValidator, type, line, col, path, message, level);
            this.errors.add(msg);
        } else if (level == ValidationMessage.IssueSeverity.FATAL || level == ValidationMessage.IssueSeverity.ERROR && this.policy == ValidationPolicy.QUICK) {
            throw new FHIRFormatError(message + String.format(" at line %d col %d", line, col));
        }
    }

    private String lowFirst(String t) {
        return t.substring(0, 1).toLowerCase() + t.substring(1);
    }

    public abstract Element parse(InputStream var1) throws Exception;

    public void setupValidation(ValidationPolicy policy, List<ValidationMessage> errors) {
        this.policy = policy;
        this.errors = errors;
    }

    private String tail(String path) {
        return path.contains(".") ? path.substring(path.lastIndexOf(".") + 1) : path;
    }

    public static boolean isPrimitive(String code) {
        return Utilities.existsInList((String)code, (String[])new String[]{"xhtml", "boolean", "integer", "string", "decimal", "uri", "base64Binary", "instant", "date", "dateTime", "time", "code", "oid", "id", "markdown", "unsignedInt", "positiveInt", "xhtml", "base64Binary"});
    }

    public static enum ValidationPolicy {
        NONE,
        QUICK,
        EVERYTHING;

    }

    static interface IErrorNotifier {
    }
}

