/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model;

import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import org.apache.commons.codec.binary.Base64;
import org.hl7.fhir.dstu2016may.model.PrimitiveType;

@DatatypeDef(name="base64binary")
public class Base64BinaryType
extends PrimitiveType<byte[]> {
    private static final long serialVersionUID = 3L;

    public Base64BinaryType() {
    }

    public Base64BinaryType(byte[] theBytes) {
        this.setValue(theBytes);
    }

    public Base64BinaryType(String theValue) {
        this.setValueAsString(theValue);
    }

    @Override
    protected byte[] parse(String theValue) {
        return Base64.decodeBase64((String)theValue);
    }

    @Override
    protected String encode(byte[] theValue) {
        return Base64.encodeBase64String((byte[])theValue);
    }

    @Override
    public Base64BinaryType copy() {
        return new Base64BinaryType((byte[])this.getValue());
    }

    @Override
    public String fhirType() {
        return "base64Binary";
    }
}

