/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.validation;

import ca.uhn.fhir.util.ObjectUtil;
import com.google.gson.JsonObject;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.dstu2016may.metamodel.Element;
import org.hl7.fhir.dstu2016may.metamodel.JsonParser;
import org.hl7.fhir.dstu2016may.metamodel.Manager;
import org.hl7.fhir.dstu2016may.metamodel.ParserBase;
import org.hl7.fhir.dstu2016may.metamodel.XmlParser;
import org.hl7.fhir.dstu2016may.model.Address;
import org.hl7.fhir.dstu2016may.model.Attachment;
import org.hl7.fhir.dstu2016may.model.Base;
import org.hl7.fhir.dstu2016may.model.Base64BinaryType;
import org.hl7.fhir.dstu2016may.model.BooleanType;
import org.hl7.fhir.dstu2016may.model.Bundle;
import org.hl7.fhir.dstu2016may.model.CodeSystem;
import org.hl7.fhir.dstu2016may.model.CodeType;
import org.hl7.fhir.dstu2016may.model.CodeableConcept;
import org.hl7.fhir.dstu2016may.model.Coding;
import org.hl7.fhir.dstu2016may.model.ContactPoint;
import org.hl7.fhir.dstu2016may.model.DateTimeType;
import org.hl7.fhir.dstu2016may.model.DateType;
import org.hl7.fhir.dstu2016may.model.DecimalType;
import org.hl7.fhir.dstu2016may.model.DomainResource;
import org.hl7.fhir.dstu2016may.model.Element;
import org.hl7.fhir.dstu2016may.model.ElementDefinition;
import org.hl7.fhir.dstu2016may.model.Enumerations;
import org.hl7.fhir.dstu2016may.model.ExpressionNode;
import org.hl7.fhir.dstu2016may.model.Extension;
import org.hl7.fhir.dstu2016may.model.HumanName;
import org.hl7.fhir.dstu2016may.model.IdType;
import org.hl7.fhir.dstu2016may.model.Identifier;
import org.hl7.fhir.dstu2016may.model.InstantType;
import org.hl7.fhir.dstu2016may.model.IntegerType;
import org.hl7.fhir.dstu2016may.model.OidType;
import org.hl7.fhir.dstu2016may.model.Period;
import org.hl7.fhir.dstu2016may.model.Quantity;
import org.hl7.fhir.dstu2016may.model.Questionnaire;
import org.hl7.fhir.dstu2016may.model.Range;
import org.hl7.fhir.dstu2016may.model.Ratio;
import org.hl7.fhir.dstu2016may.model.Reference;
import org.hl7.fhir.dstu2016may.model.Resource;
import org.hl7.fhir.dstu2016may.model.SampledData;
import org.hl7.fhir.dstu2016may.model.StringType;
import org.hl7.fhir.dstu2016may.model.StructureDefinition;
import org.hl7.fhir.dstu2016may.model.TimeType;
import org.hl7.fhir.dstu2016may.model.Timing;
import org.hl7.fhir.dstu2016may.model.Type;
import org.hl7.fhir.dstu2016may.model.UriType;
import org.hl7.fhir.dstu2016may.model.UuidType;
import org.hl7.fhir.dstu2016may.model.ValueSet;
import org.hl7.fhir.dstu2016may.utils.FHIRPathEngine;
import org.hl7.fhir.dstu2016may.utils.IWorkerContext;
import org.hl7.fhir.dstu2016may.utils.ProfileUtilities;
import org.hl7.fhir.dstu2016may.validation.BaseValidator;
import org.hl7.fhir.dstu2016may.validation.IResourceValidator;
import org.hl7.fhir.exceptions.DefinitionException;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.utilities.CommaSeparatedStringBuilder;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.validation.ValidationMessage;
import org.hl7.fhir.utilities.xhtml.NodeType;
import org.hl7.fhir.utilities.xhtml.XhtmlNode;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class InstanceValidator
extends BaseValidator
implements IResourceValidator {
    private boolean anyExtensionsAllowed;
    private IResourceValidator.BestPracticeWarningLevel bpWarnings;
    private IResourceValidator.CheckDisplayOption checkDisplay;
    private IWorkerContext context;
    private FHIRPathEngine fpe;
    private List<String> extensionDomains = new ArrayList<String>();
    private IResourceValidator.IdStatus resourceIdRule;
    private boolean suppressLoincSnomedMessages;
    private Bundle logical;
    private long overall = 0L;
    private long txTime = 0L;
    private long sdTime = 0L;
    private long loadTime = 0L;
    private long fpeTime = 0L;
    long time = 0L;

    public InstanceValidator(IWorkerContext theContext) {
        this.context = theContext;
        this.fpe = new FHIRPathEngine(this.context);
        this.source = ValidationMessage.Source.InstanceValidator;
    }

    private boolean allowUnknownExtension(String url) {
        if (url.contains("example.org") || url.contains("acme.com") || url.contains("nema.org")) {
            return true;
        }
        for (String s : this.extensionDomains) {
            if (!url.startsWith(s)) continue;
            return true;
        }
        return this.anyExtensionsAllowed;
    }

    private void bpCheck(List<ValidationMessage> errors, ValidationMessage.IssueType invalid, int line, int col, String literalPath, boolean test, String message) {
        if (this.bpWarnings != null) {
            switch (this.bpWarnings) {
                case Error: {
                    this.rule(errors, invalid, line, col, literalPath, test, message, new Object[0]);
                    break;
                }
                case Warning: {
                    this.warning(errors, invalid, line, col, literalPath, test, message, new Object[0]);
                    break;
                }
                case Hint: {
                    this.hint(errors, invalid, line, col, literalPath, test, message);
                    break;
                }
            }
        }
    }

    @Override
    public void validate(List<ValidationMessage> errors, InputStream stream, Manager.FhirFormat format) throws Exception {
        this.validate(errors, stream, format, (StructureDefinition)null);
    }

    @Override
    public void validate(List<ValidationMessage> errors, InputStream stream, Manager.FhirFormat format, String profile) throws Exception {
        long t = System.nanoTime();
        StructureDefinition p = this.context.fetchResource(StructureDefinition.class, profile);
        this.sdTime += System.nanoTime() - t;
        if (p == null) {
            throw new DefinitionException("StructureDefinition '" + profile + "' not found");
        }
        this.validate(errors, stream, format, p);
    }

    @Override
    public void validate(List<ValidationMessage> errors, InputStream stream, Manager.FhirFormat format, StructureDefinition profile) throws Exception {
        ParserBase parser = Manager.makeParser(this.context, format);
        parser.setupValidation(ParserBase.ValidationPolicy.EVERYTHING, errors);
        long t = System.nanoTime();
        org.hl7.fhir.dstu2016may.metamodel.Element e = parser.parse(stream);
        this.loadTime = System.nanoTime() - t;
        if (e != null) {
            this.validate(errors, e, profile);
        }
    }

    @Override
    public void validate(List<ValidationMessage> errors, Resource resource) throws Exception {
        this.validate(errors, resource, (StructureDefinition)null);
    }

    @Override
    public void validate(List<ValidationMessage> errors, Resource resource, String profile) throws Exception {
        long t = System.nanoTime();
        StructureDefinition p = this.context.fetchResource(StructureDefinition.class, profile);
        this.sdTime += System.nanoTime() - t;
        if (p == null) {
            throw new DefinitionException("StructureDefinition '" + profile + "' not found");
        }
        this.validate(errors, resource, p);
    }

    @Override
    public void validate(List<ValidationMessage> errors, Resource resource, StructureDefinition profile) throws Exception {
        throw new Exception("Not done yet");
    }

    @Override
    public void validate(List<ValidationMessage> errors, org.hl7.fhir.dstu2016may.metamodel.Element element) throws Exception {
        this.validate(errors, element, (StructureDefinition)null);
    }

    @Override
    public void validate(List<ValidationMessage> errors, org.w3c.dom.Element element) throws Exception {
        this.validate(errors, element, (StructureDefinition)null);
    }

    @Override
    public void validate(List<ValidationMessage> errors, org.hl7.fhir.dstu2016may.metamodel.Element element, String profile) throws Exception {
        long t = System.nanoTime();
        StructureDefinition p = this.context.fetchResource(StructureDefinition.class, profile);
        this.sdTime += System.nanoTime() - t;
        if (p == null) {
            throw new DefinitionException("StructureDefinition '" + profile + "' not found");
        }
        this.validate(errors, element, p);
    }

    @Override
    public void validate(List<ValidationMessage> errors, org.w3c.dom.Element element, String profile) throws Exception {
        long t = System.nanoTime();
        StructureDefinition p = this.context.fetchResource(StructureDefinition.class, profile);
        this.sdTime += System.nanoTime() - t;
        if (p == null) {
            throw new DefinitionException("StructureDefinition '" + profile + "' not found");
        }
        this.validate(errors, element, p);
    }

    @Override
    public void validate(List<ValidationMessage> errors, org.w3c.dom.Element element, StructureDefinition profile) throws Exception {
        XmlParser parser = new XmlParser(this.context);
        parser.setupValidation(ParserBase.ValidationPolicy.EVERYTHING, errors);
        long t = System.nanoTime();
        org.hl7.fhir.dstu2016may.metamodel.Element e = parser.parse(element);
        this.loadTime = System.nanoTime() - t;
        this.validate(errors, e, profile);
    }

    @Override
    public void validate(List<ValidationMessage> errors, Document document) throws Exception {
        this.validate(errors, document, (StructureDefinition)null);
    }

    @Override
    public void validate(List<ValidationMessage> errors, Document document, String profile) throws Exception {
        long t = System.nanoTime();
        StructureDefinition p = this.context.fetchResource(StructureDefinition.class, profile);
        this.sdTime += System.nanoTime() - t;
        if (p == null) {
            throw new DefinitionException("StructureDefinition '" + profile + "' not found");
        }
        this.validate(errors, document, p);
    }

    @Override
    public void validate(List<ValidationMessage> errors, Document document, StructureDefinition profile) throws Exception {
        XmlParser parser = new XmlParser(this.context);
        parser.setupValidation(ParserBase.ValidationPolicy.EVERYTHING, errors);
        long t = System.nanoTime();
        org.hl7.fhir.dstu2016may.metamodel.Element e = parser.parse(document);
        this.loadTime = System.nanoTime() - t;
        this.validate(errors, e, profile);
    }

    @Override
    public void validate(List<ValidationMessage> errors, JsonObject object) throws Exception {
    }

    @Override
    public void validate(List<ValidationMessage> errors, JsonObject object, String profile) throws Exception {
        long t = System.nanoTime();
        StructureDefinition p = this.context.fetchResource(StructureDefinition.class, profile);
        this.sdTime += System.nanoTime() - t;
        if (p == null) {
            throw new DefinitionException("StructureDefinition '" + profile + "' not found");
        }
        this.validate(errors, object, p);
    }

    @Override
    public void validate(List<ValidationMessage> errors, JsonObject object, StructureDefinition profile) throws Exception {
        JsonParser parser = new JsonParser(this.context);
        parser.setupValidation(ParserBase.ValidationPolicy.EVERYTHING, errors);
        long t = System.nanoTime();
        org.hl7.fhir.dstu2016may.metamodel.Element e = parser.parse(object);
        this.loadTime = System.nanoTime() - t;
        this.validate(errors, e, profile);
    }

    @Override
    public void validate(List<ValidationMessage> errors, org.hl7.fhir.dstu2016may.metamodel.Element element, StructureDefinition profile) throws Exception {
        long t = System.nanoTime();
        this.validateResource(errors, element, element, profile, this.resourceIdRule, new NodeStack(element));
        this.overall = System.nanoTime() - t;
    }

    private boolean check(String v1, String v2) {
        return v1 == null ? Utilities.noString((String)v1) : v1.equals(v2);
    }

    private void checkAddress(List<ValidationMessage> errors, String path, org.hl7.fhir.dstu2016may.metamodel.Element focus, Address fixed) {
        this.checkFixedValue(errors, path + ".use", focus.getNamedChild("use"), fixed.getUseElement(), "use");
        this.checkFixedValue(errors, path + ".text", focus.getNamedChild("text"), fixed.getTextElement(), "text");
        this.checkFixedValue(errors, path + ".city", focus.getNamedChild("city"), fixed.getCityElement(), "city");
        this.checkFixedValue(errors, path + ".state", focus.getNamedChild("state"), fixed.getStateElement(), "state");
        this.checkFixedValue(errors, path + ".country", focus.getNamedChild("country"), fixed.getCountryElement(), "country");
        this.checkFixedValue(errors, path + ".zip", focus.getNamedChild("zip"), fixed.getPostalCodeElement(), "postalCode");
        ArrayList<org.hl7.fhir.dstu2016may.metamodel.Element> lines = new ArrayList<org.hl7.fhir.dstu2016may.metamodel.Element>();
        focus.getNamedChildren("line", lines);
        if (this.rule(errors, ValidationMessage.IssueType.VALUE, focus.line(), focus.col(), path, lines.size() == fixed.getLine().size(), "Expected " + Integer.toString(fixed.getLine().size()) + " but found " + Integer.toString(lines.size()) + " line elements", new Object[0])) {
            for (int i = 0; i < lines.size(); ++i) {
                this.checkFixedValue(errors, path + ".coding", (org.hl7.fhir.dstu2016may.metamodel.Element)lines.get(i), fixed.getLine().get(i), "coding");
            }
        }
    }

    private void checkAttachment(List<ValidationMessage> errors, String path, org.hl7.fhir.dstu2016may.metamodel.Element focus, Attachment fixed) {
        this.checkFixedValue(errors, path + ".contentType", focus.getNamedChild("contentType"), fixed.getContentTypeElement(), "contentType");
        this.checkFixedValue(errors, path + ".language", focus.getNamedChild("language"), fixed.getLanguageElement(), "language");
        this.checkFixedValue(errors, path + ".data", focus.getNamedChild("data"), fixed.getDataElement(), "data");
        this.checkFixedValue(errors, path + ".url", focus.getNamedChild("url"), fixed.getUrlElement(), "url");
        this.checkFixedValue(errors, path + ".size", focus.getNamedChild("size"), fixed.getSizeElement(), "size");
        this.checkFixedValue(errors, path + ".hash", focus.getNamedChild("hash"), fixed.getHashElement(), "hash");
        this.checkFixedValue(errors, path + ".title", focus.getNamedChild("title"), fixed.getTitleElement(), "title");
    }

    private boolean checkCode(List<ValidationMessage> errors, org.hl7.fhir.dstu2016may.metamodel.Element element, String path, String code, String system, String display) {
        long t = System.nanoTime();
        boolean ss = this.context.supportsSystem(system);
        this.txTime += System.nanoTime() - t;
        if (ss) {
            t = System.nanoTime();
            IWorkerContext.ValidationResult s = this.context.validateCode(system, code, display);
            this.txTime += System.nanoTime() - t;
            if (s == null || s.isOk()) {
                return true;
            }
            if (s.getSeverity() == ValidationMessage.IssueSeverity.INFORMATION) {
                this.hint(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, s == null, s.getMessage());
            } else if (s.getSeverity() == ValidationMessage.IssueSeverity.WARNING) {
                this.warning(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, s == null, s.getMessage(), new Object[0]);
            } else {
                return this.rule(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, s == null, s.getMessage(), new Object[0]);
            }
            return true;
        }
        if (system.startsWith("http://hl7.org/fhir")) {
            if (system.equals("http://hl7.org/fhir/sid/icd-10")) {
                return true;
            }
            CodeSystem cs = this.getCodeSystem(system);
            if (this.warning(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, cs != null, "Unknown Code System " + system, new Object[0])) {
                CodeSystem.ConceptDefinitionComponent def = this.getCodeDefinition(cs, code);
                if (this.warning(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, def != null, "Unknown Code (" + system + "#" + code + ")", new Object[0])) {
                    return this.warning(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, display == null || display.equals(def.getDisplay()), "Display should be '" + def.getDisplay() + "'", new Object[0]);
                }
            }
            return false;
        }
        if (system.startsWith("http://loinc.org")) {
            return true;
        }
        if (system.startsWith("http://unitsofmeasure.org")) {
            return true;
        }
        return true;
    }

    private void checkCodeableConcept(List<ValidationMessage> errors, String path, org.hl7.fhir.dstu2016may.metamodel.Element focus, CodeableConcept fixed) {
        this.checkFixedValue(errors, path + ".text", focus.getNamedChild("text"), fixed.getTextElement(), "text");
        ArrayList<org.hl7.fhir.dstu2016may.metamodel.Element> codings = new ArrayList<org.hl7.fhir.dstu2016may.metamodel.Element>();
        focus.getNamedChildren("coding", codings);
        if (this.rule(errors, ValidationMessage.IssueType.VALUE, focus.line(), focus.col(), path, codings.size() == fixed.getCoding().size(), "Expected " + Integer.toString(fixed.getCoding().size()) + " but found " + Integer.toString(codings.size()) + " coding elements", new Object[0])) {
            for (int i = 0; i < codings.size(); ++i) {
                this.checkFixedValue(errors, path + ".coding", (org.hl7.fhir.dstu2016may.metamodel.Element)codings.get(i), fixed.getCoding().get(i), "coding");
            }
        }
    }

    private void checkCodeableConcept(List<ValidationMessage> errors, String path, org.hl7.fhir.dstu2016may.metamodel.Element element, StructureDefinition profile, ElementDefinition theElementCntext) {
        if (theElementCntext != null && theElementCntext.hasBinding()) {
            ElementDefinition.ElementDefinitionBindingComponent binding = theElementCntext.getBinding();
            if (this.warning(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, binding != null, "Binding for " + path + " missing (cc)", new Object[0])) {
                if (binding.hasValueSet() && binding.getValueSet() instanceof Reference) {
                    ValueSet valueset = this.resolveBindingReference(profile, binding.getValueSet());
                    if (this.warning(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, valueset != null, "ValueSet " + this.describeReference(binding.getValueSet()) + " not found", new Object[0])) {
                        try {
                            CodeableConcept cc = this.readAsCodeableConcept(element);
                            if (!cc.hasCoding()) {
                                if (binding.getStrength() == Enumerations.BindingStrength.REQUIRED) {
                                    this.rule(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "No code provided, and a code is required from the value set " + this.describeReference(binding.getValueSet()) + " (" + valueset.getUrl(), new Object[0]);
                                } else if (binding.getStrength() == Enumerations.BindingStrength.EXTENSIBLE) {
                                    this.warning(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "No code provided, and a code should be provided from the value set " + this.describeReference(binding.getValueSet()) + " (" + valueset.getUrl(), new Object[0]);
                                }
                            } else {
                                long t = System.nanoTime();
                                IWorkerContext.ValidationResult vr = this.context.validateCode(cc, valueset);
                                this.txTime += System.nanoTime() - t;
                                if (!vr.isOk()) {
                                    if (binding.getStrength() == Enumerations.BindingStrength.REQUIRED) {
                                        this.rule(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "None of the codes provided are in the value set " + this.describeReference(binding.getValueSet()) + " (" + valueset.getUrl() + ", and a code from this value set is required", new Object[0]);
                                    } else if (binding.getStrength() == Enumerations.BindingStrength.EXTENSIBLE) {
                                        this.warning(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "None of the codes provided are in the value set " + this.describeReference(binding.getValueSet()) + " (" + valueset.getUrl() + ", and a code should come from this value set unless it has no suitable code", new Object[0]);
                                    } else if (binding.getStrength() == Enumerations.BindingStrength.PREFERRED) {
                                        this.hint(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "None of the codes provided are in the value set " + this.describeReference(binding.getValueSet()) + " (" + valueset.getUrl() + ", and a code is recommended to come from this value set");
                                    }
                                }
                            }
                        }
                        catch (Exception e) {
                            this.warning(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Error " + e.getMessage() + " validating CodeableConcept", new Object[0]);
                        }
                    }
                } else if (binding.hasValueSet()) {
                    this.hint(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Binding by URI reference cannot be checked");
                } else {
                    this.hint(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Binding for path " + path + " has no source, so can't be checked");
                }
            }
        }
    }

    private CodeableConcept readAsCodeableConcept(org.hl7.fhir.dstu2016may.metamodel.Element element) {
        CodeableConcept cc = new CodeableConcept();
        ArrayList<org.hl7.fhir.dstu2016may.metamodel.Element> list = new ArrayList<org.hl7.fhir.dstu2016may.metamodel.Element>();
        element.getNamedChildren("coding", list);
        for (org.hl7.fhir.dstu2016may.metamodel.Element item : list) {
            cc.addCoding(this.readAsCoding(item));
        }
        cc.setText(element.getNamedChildValue("text"));
        return cc;
    }

    private Coding readAsCoding(org.hl7.fhir.dstu2016may.metamodel.Element item) {
        Coding c = new Coding();
        c.setSystem(item.getNamedChildValue("system"));
        c.setVersion(item.getNamedChildValue("version"));
        c.setCode(item.getNamedChildValue("code"));
        c.setDisplay(item.getNamedChildValue("display"));
        return c;
    }

    private void checkCoding(List<ValidationMessage> errors, String path, org.hl7.fhir.dstu2016may.metamodel.Element focus, Coding fixed) {
        this.checkFixedValue(errors, path + ".system", focus.getNamedChild("system"), fixed.getSystemElement(), "system");
        this.checkFixedValue(errors, path + ".code", focus.getNamedChild("code"), fixed.getCodeElement(), "code");
        this.checkFixedValue(errors, path + ".display", focus.getNamedChild("display"), fixed.getDisplayElement(), "display");
        this.checkFixedValue(errors, path + ".userSelected", focus.getNamedChild("userSelected"), fixed.getUserSelectedElement(), "userSelected");
    }

    private void checkCoding(List<ValidationMessage> errors, String path, org.hl7.fhir.dstu2016may.metamodel.Element element, StructureDefinition profile, ElementDefinition theElementCntext, boolean inCodeableConcept) {
        String code = element.getNamedChildValue("code");
        String system = element.getNamedChildValue("system");
        String display = element.getNamedChildValue("display");
        this.rule(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, this.isAbsolute(system), "Coding.system must be an absolute reference, not a local reference", new Object[0]);
        if (system != null && code != null && this.checkCode(errors, element, path, code, system, display) && theElementCntext != null && theElementCntext.getBinding() != null) {
            ElementDefinition.ElementDefinitionBindingComponent binding = theElementCntext.getBinding();
            if (this.warning(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, binding != null, "Binding for " + path + " missing", new Object[0])) {
                if (binding.hasValueSet() && binding.getValueSet() instanceof Reference) {
                    ValueSet valueset = this.resolveBindingReference(profile, binding.getValueSet());
                    if (this.warning(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, valueset != null, "ValueSet " + this.describeReference(binding.getValueSet()) + " not found", new Object[0])) {
                        try {
                            Coding c = this.readAsCoding(element);
                            long t = System.nanoTime();
                            IWorkerContext.ValidationResult vr = this.context.validateCode(c, valueset);
                            this.txTime += System.nanoTime() - t;
                            if (!vr.isOk()) {
                                if (binding.getStrength() == Enumerations.BindingStrength.REQUIRED) {
                                    this.rule(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "The value provided is not in the value set " + this.describeReference(binding.getValueSet()) + " (" + valueset.getUrl() + ", and a code is required from this value set", new Object[0]);
                                } else if (binding.getStrength() == Enumerations.BindingStrength.EXTENSIBLE) {
                                    this.warning(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "The value provided is not in the value set " + this.describeReference(binding.getValueSet()) + " (" + valueset.getUrl() + ", and a code should come from this value set unless it has no suitable code", new Object[0]);
                                } else if (binding.getStrength() == Enumerations.BindingStrength.PREFERRED) {
                                    this.hint(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "The value provided is not in the value set " + this.describeReference(binding.getValueSet()) + " (" + valueset.getUrl() + ", and a code is recommended to come from this value set");
                                }
                            }
                        }
                        catch (Exception e) {
                            this.warning(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Error " + e.getMessage() + " validating CodeableConcept", new Object[0]);
                        }
                    }
                } else if (binding.hasValueSet()) {
                    this.hint(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Binding by URI reference cannot be checked");
                } else if (!inCodeableConcept) {
                    this.hint(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "Binding for path " + path + " has no source, so can't be checked");
                }
            }
        }
    }

    private void checkContactPoint(List<ValidationMessage> errors, String path, org.hl7.fhir.dstu2016may.metamodel.Element focus, ContactPoint fixed) {
        this.checkFixedValue(errors, path + ".system", focus.getNamedChild("system"), fixed.getSystemElement(), "system");
        this.checkFixedValue(errors, path + ".value", focus.getNamedChild("value"), fixed.getValueElement(), "value");
        this.checkFixedValue(errors, path + ".use", focus.getNamedChild("use"), fixed.getUseElement(), "use");
        this.checkFixedValue(errors, path + ".period", focus.getNamedChild("period"), fixed.getPeriod(), "period");
    }

    private void checkDeclaredProfiles(List<ValidationMessage> errors, org.hl7.fhir.dstu2016may.metamodel.Element resource, org.hl7.fhir.dstu2016may.metamodel.Element element, NodeStack stack) throws FHIRException {
        org.hl7.fhir.dstu2016may.metamodel.Element meta = element.getNamedChild("meta");
        if (meta != null) {
            ArrayList<org.hl7.fhir.dstu2016may.metamodel.Element> profiles = new ArrayList<org.hl7.fhir.dstu2016may.metamodel.Element>();
            meta.getNamedChildren("profile", profiles);
            int i = 0;
            for (org.hl7.fhir.dstu2016may.metamodel.Element profile : profiles) {
                String ref = profile.primitiveValue();
                String p = stack.addToLiteralPath("meta", "profile", ":" + Integer.toString(i));
                if (!this.rule(errors, ValidationMessage.IssueType.INVALID, element.line(), element.col(), p, !Utilities.noString((String)ref), "StructureDefinition reference invalid", new Object[0])) continue;
                long t = System.nanoTime();
                StructureDefinition pr = this.context.fetchResource(StructureDefinition.class, ref);
                this.sdTime += System.nanoTime() - t;
                if (this.warning(errors, ValidationMessage.IssueType.INVALID, element.line(), element.col(), p, pr != null, "StructureDefinition reference \"{0}\" could not be resolved", ref) && this.rule(errors, ValidationMessage.IssueType.STRUCTURE, element.line(), element.col(), p, pr.hasSnapshot(), "StructureDefinition has no snapshot - validation is against the snapshot, so it must be provided", new Object[0])) {
                    this.validateElement(errors, pr, pr.getSnapshot().getElement().get(0), null, null, resource, element, element.getName(), stack, false);
                }
                ++i;
            }
        }
    }

    private StructureDefinition checkExtension(List<ValidationMessage> errors, String path, org.hl7.fhir.dstu2016may.metamodel.Element element, ElementDefinition def, StructureDefinition profile, NodeStack stack) {
        String url = element.getNamedChildValue("url");
        boolean isModifier = element.getName().equals("modifierExtension");
        long t = System.nanoTime();
        StructureDefinition ex = this.context.fetchResource(StructureDefinition.class, url);
        this.sdTime += System.nanoTime() - t;
        if (ex == null) {
            if (!this.rule(errors, ValidationMessage.IssueType.STRUCTURE, element.line(), element.col(), path, this.allowUnknownExtension(url), "The extension " + url + " is unknown, and not allowed here", new Object[0])) {
                this.warning(errors, ValidationMessage.IssueType.STRUCTURE, element.line(), element.col(), path, this.allowUnknownExtension(url), "Unknown extension " + url, new Object[0]);
            }
        } else {
            if (def.getIsModifier()) {
                this.rule(errors, ValidationMessage.IssueType.STRUCTURE, element.line(), element.col(), path + "[url='" + url + "']", ex.getSnapshot().getElement().get(0).getIsModifier(), "Extension modifier mismatch: the extension element is labelled as a modifier, but the underlying extension is not", new Object[0]);
            } else {
                this.rule(errors, ValidationMessage.IssueType.STRUCTURE, element.line(), element.col(), path + "[url='" + url + "']", !ex.getSnapshot().getElement().get(0).getIsModifier(), "Extension modifier mismatch: the extension element is not labelled as a modifier, but the underlying extension is", new Object[0]);
            }
            this.checkExtensionContext(errors, element, ex, stack, ex.getUrl());
            if (isModifier) {
                this.rule(errors, ValidationMessage.IssueType.STRUCTURE, element.line(), element.col(), path + "[url='" + url + "']", ex.getSnapshot().getElement().get(0).getIsModifier(), "The Extension '" + url + "' must be used as a modifierExtension", new Object[0]);
            } else {
                this.rule(errors, ValidationMessage.IssueType.STRUCTURE, element.line(), element.col(), path + "[url='" + url + "']", !ex.getSnapshot().getElement().get(0).getIsModifier(), "The Extension '" + url + "' must not be used as an extension (it's a modifierExtension)", new Object[0]);
            }
        }
        return ex;
    }

    private boolean checkExtensionContext(List<ValidationMessage> errors, org.hl7.fhir.dstu2016may.metamodel.Element element, StructureDefinition definition, NodeStack stack, String extensionParent) {
        Object b;
        String extUrl = definition.getUrl();
        CommaSeparatedStringBuilder p = new CommaSeparatedStringBuilder();
        for (String lp : stack.getLogicalPaths()) {
            p.append(lp);
        }
        if (definition.getContextType() == StructureDefinition.ExtensionContext.DATATYPE) {
            boolean ok = false;
            b = new CommaSeparatedStringBuilder();
            for (StringType ct : definition.getContext()) {
                b.append((String)ct.getValue());
                if (!((String)ct.getValue()).equals("*") && !stack.getLogicalPaths().contains((String)ct.getValue() + ".extension")) continue;
                ok = true;
            }
            return this.rule(errors, ValidationMessage.IssueType.STRUCTURE, element.line(), element.col(), stack.getLiteralPath(), ok, "The extension " + extUrl + " is not allowed to be used on the logical path set [" + p.toString() + "] (allowed: datatype=" + b.toString() + ")", new Object[0]);
        }
        if (definition.getContextType() == StructureDefinition.ExtensionContext.EXTENSION) {
            boolean ok = false;
            for (StringType ct : definition.getContext()) {
                if (!((String)ct.getValue()).equals("*") && !((String)ct.getValue()).equals(extensionParent)) continue;
                ok = true;
            }
            return this.rule(errors, ValidationMessage.IssueType.STRUCTURE, element.line(), element.col(), stack.getLiteralPath(), ok, "The extension " + extUrl + " is not allowed to be used with the extension '" + extensionParent + "'", new Object[0]);
        }
        if (definition.getContextType() == StructureDefinition.ExtensionContext.RESOURCE) {
            boolean ok = false;
            b = new CommaSeparatedStringBuilder();
            for (StringType ct : definition.getContext()) {
                String c = (String)ct.getValue();
                b.append(c);
                if (c.equals("*") || stack.getLogicalPaths().contains(c + ".extension") || !c.startsWith("@") || stack.getLogicalPaths().contains(c.substring(1) + ".extension")) {
                    // empty if block
                }
                ok = true;
            }
            return this.rule(errors, ValidationMessage.IssueType.STRUCTURE, element.line(), element.col(), stack.getLiteralPath(), ok, "The extension " + extUrl + " is not allowed to be used on the logical path set " + p.toString() + " (allowed: resource=" + b.toString() + ")", new Object[0]);
        }
        throw new Error("Unknown context type");
    }

    private void checkFixedValue(List<ValidationMessage> errors, String path, org.hl7.fhir.dstu2016may.metamodel.Element focus, Element fixed, String propName) {
        if (fixed != null || focus != null) {
            if (fixed == null && focus != null) {
                this.rule(errors, ValidationMessage.IssueType.VALUE, focus.line(), focus.col(), path, false, "Unexpected element " + focus.getName(), new Object[0]);
            } else if (fixed != null && focus == null) {
                this.rule(errors, ValidationMessage.IssueType.VALUE, focus.line(), focus.col(), path, false, "Mising element " + propName, new Object[0]);
            } else {
                String value = focus.primitiveValue();
                if (fixed instanceof BooleanType) {
                    this.rule(errors, ValidationMessage.IssueType.VALUE, focus.line(), focus.col(), path, this.check(((BooleanType)fixed).asStringValue(), value), "Value is '" + value + "' but must be '" + ((BooleanType)fixed).asStringValue() + "'", new Object[0]);
                } else if (fixed instanceof IntegerType) {
                    this.rule(errors, ValidationMessage.IssueType.VALUE, focus.line(), focus.col(), path, this.check(((IntegerType)fixed).asStringValue(), value), "Value is '" + value + "' but must be '" + ((IntegerType)fixed).asStringValue() + "'", new Object[0]);
                } else if (fixed instanceof DecimalType) {
                    this.rule(errors, ValidationMessage.IssueType.VALUE, focus.line(), focus.col(), path, this.check(((DecimalType)fixed).asStringValue(), value), "Value is '" + value + "' but must be '" + ((DecimalType)fixed).asStringValue() + "'", new Object[0]);
                } else if (fixed instanceof Base64BinaryType) {
                    this.rule(errors, ValidationMessage.IssueType.VALUE, focus.line(), focus.col(), path, this.check(((Base64BinaryType)fixed).asStringValue(), value), "Value is '" + value + "' but must be '" + ((Base64BinaryType)fixed).asStringValue() + "'", new Object[0]);
                } else if (fixed instanceof InstantType) {
                    this.rule(errors, ValidationMessage.IssueType.VALUE, focus.line(), focus.col(), path, this.check(((Date)((InstantType)fixed).getValue()).toString(), value), "Value is '" + value + "' but must be '" + ((InstantType)fixed).asStringValue() + "'", new Object[0]);
                } else if (fixed instanceof StringType) {
                    this.rule(errors, ValidationMessage.IssueType.VALUE, focus.line(), focus.col(), path, this.check((String)((StringType)fixed).getValue(), value), "Value is '" + value + "' but must be '" + (String)((StringType)fixed).getValue() + "'", new Object[0]);
                } else if (fixed instanceof UriType) {
                    this.rule(errors, ValidationMessage.IssueType.VALUE, focus.line(), focus.col(), path, this.check((String)((UriType)fixed).getValue(), value), "Value is '" + value + "' but must be '" + (String)((UriType)fixed).getValue() + "'", new Object[0]);
                } else if (fixed instanceof DateType) {
                    this.rule(errors, ValidationMessage.IssueType.VALUE, focus.line(), focus.col(), path, this.check(((Date)((DateType)fixed).getValue()).toString(), value), "Value is '" + value + "' but must be '" + ((DateType)fixed).getValue() + "'", new Object[0]);
                } else if (fixed instanceof DateTimeType) {
                    this.rule(errors, ValidationMessage.IssueType.VALUE, focus.line(), focus.col(), path, this.check(((Date)((DateTimeType)fixed).getValue()).toString(), value), "Value is '" + value + "' but must be '" + ((DateTimeType)fixed).getValue() + "'", new Object[0]);
                } else if (fixed instanceof OidType) {
                    this.rule(errors, ValidationMessage.IssueType.VALUE, focus.line(), focus.col(), path, this.check((String)((OidType)fixed).getValue(), value), "Value is '" + value + "' but must be '" + (String)((OidType)fixed).getValue() + "'", new Object[0]);
                } else if (fixed instanceof UuidType) {
                    this.rule(errors, ValidationMessage.IssueType.VALUE, focus.line(), focus.col(), path, this.check((String)((UuidType)fixed).getValue(), value), "Value is '" + value + "' but must be '" + (String)((UuidType)fixed).getValue() + "'", new Object[0]);
                } else if (fixed instanceof CodeType) {
                    this.rule(errors, ValidationMessage.IssueType.VALUE, focus.line(), focus.col(), path, this.check((String)((CodeType)fixed).getValue(), value), "Value is '" + value + "' but must be '" + (String)((CodeType)fixed).getValue() + "'", new Object[0]);
                } else if (fixed instanceof IdType) {
                    this.rule(errors, ValidationMessage.IssueType.VALUE, focus.line(), focus.col(), path, this.check(((IdType)fixed).getValue(), value), "Value is '" + value + "' but must be '" + ((IdType)fixed).getValue() + "'", new Object[0]);
                } else if (fixed instanceof Quantity) {
                    this.checkQuantity(errors, path, focus, (Quantity)fixed);
                } else if (fixed instanceof Address) {
                    this.checkAddress(errors, path, focus, (Address)fixed);
                } else if (fixed instanceof ContactPoint) {
                    this.checkContactPoint(errors, path, focus, (ContactPoint)fixed);
                } else if (fixed instanceof Attachment) {
                    this.checkAttachment(errors, path, focus, (Attachment)fixed);
                } else if (fixed instanceof Identifier) {
                    this.checkIdentifier(errors, path, focus, (Identifier)fixed);
                } else if (fixed instanceof Coding) {
                    this.checkCoding(errors, path, focus, (Coding)fixed);
                } else if (fixed instanceof HumanName) {
                    this.checkHumanName(errors, path, focus, (HumanName)fixed);
                } else if (fixed instanceof CodeableConcept) {
                    this.checkCodeableConcept(errors, path, focus, (CodeableConcept)fixed);
                } else if (fixed instanceof Timing) {
                    this.checkTiming(errors, path, focus, (Timing)fixed);
                } else if (fixed instanceof Period) {
                    this.checkPeriod(errors, path, focus, (Period)fixed);
                } else if (fixed instanceof Range) {
                    this.checkRange(errors, path, focus, (Range)fixed);
                } else if (fixed instanceof Ratio) {
                    this.checkRatio(errors, path, focus, (Ratio)fixed);
                } else if (fixed instanceof SampledData) {
                    this.checkSampledData(errors, path, focus, (SampledData)fixed);
                } else {
                    this.rule(errors, ValidationMessage.IssueType.EXCEPTION, focus.line(), focus.col(), path, false, "Unhandled fixed value type " + fixed.getClass().getName(), new Object[0]);
                }
                ArrayList<org.hl7.fhir.dstu2016may.metamodel.Element> extensions = new ArrayList<org.hl7.fhir.dstu2016may.metamodel.Element>();
                focus.getNamedChildren("extension", extensions);
                if (fixed.getExtension().size() == 0) {
                    this.rule(errors, ValidationMessage.IssueType.VALUE, focus.line(), focus.col(), path, extensions.size() == 0, "No extensions allowed", new Object[0]);
                } else if (this.rule(errors, ValidationMessage.IssueType.VALUE, focus.line(), focus.col(), path, extensions.size() == fixed.getExtension().size(), "Extensions count mismatch: expected " + Integer.toString(fixed.getExtension().size()) + " but found " + Integer.toString(extensions.size()), new Object[0])) {
                    for (Extension e : fixed.getExtension()) {
                        org.hl7.fhir.dstu2016may.metamodel.Element ex = this.getExtensionByUrl(extensions, e.getUrl());
                        if (!this.rule(errors, ValidationMessage.IssueType.VALUE, focus.line(), focus.col(), path, ex != null, "Extension count mismatch: unable to find extension: " + e.getUrl(), new Object[0])) continue;
                        this.checkFixedValue(errors, path, ex.getNamedChild("extension").getNamedChild("value"), e.getValue(), "extension.value");
                    }
                }
            }
        }
    }

    private void checkHumanName(List<ValidationMessage> errors, String path, org.hl7.fhir.dstu2016may.metamodel.Element focus, HumanName fixed) {
        int i;
        this.checkFixedValue(errors, path + ".use", focus.getNamedChild("use"), fixed.getUseElement(), "use");
        this.checkFixedValue(errors, path + ".text", focus.getNamedChild("text"), fixed.getTextElement(), "text");
        this.checkFixedValue(errors, path + ".period", focus.getNamedChild("period"), fixed.getPeriod(), "period");
        ArrayList<org.hl7.fhir.dstu2016may.metamodel.Element> parts = new ArrayList<org.hl7.fhir.dstu2016may.metamodel.Element>();
        focus.getNamedChildren("family", parts);
        if (this.rule(errors, ValidationMessage.IssueType.VALUE, focus.line(), focus.col(), path, parts.size() == fixed.getFamily().size(), "Expected " + Integer.toString(fixed.getFamily().size()) + " but found " + Integer.toString(parts.size()) + " family elements", new Object[0])) {
            for (i = 0; i < parts.size(); ++i) {
                this.checkFixedValue(errors, path + ".family", (org.hl7.fhir.dstu2016may.metamodel.Element)parts.get(i), fixed.getFamily().get(i), "family");
            }
        }
        focus.getNamedChildren("given", parts);
        if (this.rule(errors, ValidationMessage.IssueType.VALUE, focus.line(), focus.col(), path, parts.size() == fixed.getGiven().size(), "Expected " + Integer.toString(fixed.getGiven().size()) + " but found " + Integer.toString(parts.size()) + " given elements", new Object[0])) {
            for (i = 0; i < parts.size(); ++i) {
                this.checkFixedValue(errors, path + ".given", (org.hl7.fhir.dstu2016may.metamodel.Element)parts.get(i), fixed.getGiven().get(i), "given");
            }
        }
        focus.getNamedChildren("prefix", parts);
        if (this.rule(errors, ValidationMessage.IssueType.VALUE, focus.line(), focus.col(), path, parts.size() == fixed.getPrefix().size(), "Expected " + Integer.toString(fixed.getPrefix().size()) + " but found " + Integer.toString(parts.size()) + " prefix elements", new Object[0])) {
            for (i = 0; i < parts.size(); ++i) {
                this.checkFixedValue(errors, path + ".prefix", (org.hl7.fhir.dstu2016may.metamodel.Element)parts.get(i), fixed.getPrefix().get(i), "prefix");
            }
        }
        focus.getNamedChildren("suffix", parts);
        if (this.rule(errors, ValidationMessage.IssueType.VALUE, focus.line(), focus.col(), path, parts.size() == fixed.getSuffix().size(), "Expected " + Integer.toString(fixed.getSuffix().size()) + " but found " + Integer.toString(parts.size()) + " suffix elements", new Object[0])) {
            for (i = 0; i < parts.size(); ++i) {
                this.checkFixedValue(errors, path + ".suffix", (org.hl7.fhir.dstu2016may.metamodel.Element)parts.get(i), fixed.getSuffix().get(i), "suffix");
            }
        }
    }

    private void checkIdentifier(List<ValidationMessage> errors, String path, org.hl7.fhir.dstu2016may.metamodel.Element element, ElementDefinition context) {
        String system = element.getNamedChildValue("system");
        this.rule(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, this.isAbsolute(system), "Identifier.system must be an absolute reference, not a local reference", new Object[0]);
    }

    private void checkIdentifier(List<ValidationMessage> errors, String path, org.hl7.fhir.dstu2016may.metamodel.Element focus, Identifier fixed) {
        this.checkFixedValue(errors, path + ".use", focus.getNamedChild("use"), fixed.getUseElement(), "use");
        this.checkFixedValue(errors, path + ".type", focus.getNamedChild("type"), fixed.getType(), "type");
        this.checkFixedValue(errors, path + ".system", focus.getNamedChild("system"), fixed.getSystemElement(), "system");
        this.checkFixedValue(errors, path + ".value", focus.getNamedChild("value"), fixed.getValueElement(), "value");
        this.checkFixedValue(errors, path + ".period", focus.getNamedChild("period"), fixed.getPeriod(), "period");
        this.checkFixedValue(errors, path + ".assigner", focus.getNamedChild("assigner"), fixed.getAssigner(), "assigner");
    }

    private void checkPeriod(List<ValidationMessage> errors, String path, org.hl7.fhir.dstu2016may.metamodel.Element focus, Period fixed) {
        this.checkFixedValue(errors, path + ".start", focus.getNamedChild("start"), fixed.getStartElement(), "start");
        this.checkFixedValue(errors, path + ".end", focus.getNamedChild("end"), fixed.getEndElement(), "end");
    }

    private void checkPrimitive(List<ValidationMessage> errors, String path, String type, ElementDefinition context, org.hl7.fhir.dstu2016may.metamodel.Element e, StructureDefinition profile) {
        XhtmlNode xhtml;
        if (type.equals("boolean")) {
            this.rule(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, "true".equals(e.primitiveValue()) || "false".equals(e.primitiveValue()), "boolean values must be 'true' or 'false'", new Object[0]);
        }
        if (type.equals("uri")) {
            this.rule(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, !e.primitiveValue().startsWith("oid:"), "URI values cannot start with oid:", new Object[0]);
            this.rule(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, !e.primitiveValue().startsWith("uuid:"), "URI values cannot start with uuid:", new Object[0]);
            this.rule(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, e.primitiveValue().equals(e.primitiveValue().trim()), "URI values cannot have leading or trailing whitespace", new Object[0]);
        }
        if (!type.equalsIgnoreCase("string") && e.hasPrimitiveValue() && this.rule(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, e.primitiveValue() == null || e.primitiveValue().length() > 0, "@value cannot be empty", new Object[0])) {
            this.warning(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, e.primitiveValue() == null || e.primitiveValue().trim().equals(e.primitiveValue()), "value should not start or finish with whitespace", new Object[0]);
        }
        if (type.equals("dateTime")) {
            this.rule(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, this.yearIsValid(e.primitiveValue()), "The value '" + e.primitiveValue() + "' does not have a valid year", new Object[0]);
            this.rule(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, e.primitiveValue().matches("-?[0-9]{4}(-(0[1-9]|1[0-2])(-(0[0-9]|[1-2][0-9]|3[0-1])(T([01][0-9]|2[0-3]):[0-5][0-9]:[0-5][0-9](\\.[0-9]+)?(Z|(\\+|-)((0[0-9]|1[0-3]):[0-5][0-9]|14:00))?)?)?)?"), "Not a valid date time", new Object[0]);
            this.rule(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, !this.hasTime(e.primitiveValue()) || this.hasTimeZone(e.primitiveValue()), "if a date has a time, it must have a timezone", new Object[0]);
        }
        if (type.equals("instant")) {
            this.rule(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, e.primitiveValue().matches("-?[0-9]{4}-(0[1-9]|1[0-2])-(0[0-9]|[1-2][0-9]|3[0-1])T([01][0-9]|2[0-3]):[0-5][0-9]:[0-5][0-9](\\.[0-9]+)?(Z|(\\+|-)((0[0-9]|1[0-3]):[0-5][0-9]|14:00))"), "The instant '" + e.primitiveValue() + "' is not valid (by regex)", new Object[0]);
            this.rule(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, this.yearIsValid(e.primitiveValue()), "The value '" + e.primitiveValue() + "' does not have a valid year", new Object[0]);
        }
        if (type.equals("code") && e.primitiveValue() != null) {
            this.rule(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, this.passesCodeWhitespaceRules(e.primitiveValue()), "The code '" + e.primitiveValue() + "' is not valid (whitespace rules)", new Object[0]);
        }
        if (context.hasBinding() && e.primitiveValue() != null) {
            this.checkPrimitiveBinding(errors, path, type, context, e, profile);
        }
        if (type.equals("xhtml") && (xhtml = e.getXhtml()) != null) {
            String ns = xhtml.getNsDecl();
            this.rule(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, "http://www.w3.org/1999/xhtml".equals(ns), "Wrong namespace on the XHTML ('" + ns + "')", new Object[0]);
            this.checkInnerNS(errors, e, path, xhtml.getChildNodes());
            this.rule(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, "div".equals(xhtml.getName()), "Wrong name on the XHTML ('" + ns + "') - must start with div", new Object[0]);
            this.checkInnerNames(errors, e, path, xhtml.getChildNodes());
        }
    }

    private void checkInnerNames(List<ValidationMessage> errors, org.hl7.fhir.dstu2016may.metamodel.Element e, String path, List<XhtmlNode> list) {
        for (XhtmlNode node : list) {
            if (node.getNodeType() != NodeType.Element) continue;
            this.rule(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, Utilities.existsInList((String)node.getName(), (String[])new String[]{"p", "br", "div", "h1", "h2", "h3", "h4", "h5", "h6", "a", "span", "b", "em", "i", "strong", "small", "big", "tt", "small", "dfn", "q", "var", "abbr", "acronym", "cite", "blockquote", "hr", "address", "bdo", "kbd", "q", "sub", "sup", "ul", "ol", "li", "dl", "dt", "dd", "pre", "table", "caption", "colgroup", "col", "thead", "tr", "tfoot", "tbody", "th", "td", "code", "samp", "img", "map", "area"}), "Illegal element name in the XHTML ('" + node.getName() + "')", new Object[0]);
            for (String an : node.getAttributes().keySet()) {
                boolean ok = an.startsWith("xmlns") || Utilities.existsInList((String)an, (String[])new String[]{"title", "style", "class", "id", "lang", "xml:lang", "dir", "accesskey", "tabindex", "span", "width", "align", "valign", "char", "charoff", "abbr", "axis", "headers", "scope", "rowspan", "colspan"}) || Utilities.existsInList((String)(node.getName() + "." + an), (String[])new String[]{"a.href", "a.name", "img.src", "img.border", "div.xmlns", "blockquote.cite", "q.cite", "a.charset", "a.type", "a.name", "a.href", "a.hreflang", "a.rel", "a.rev", "a.shape", "a.coords", "img.src", "img.alt", "img.longdesc", "img.height", "img.width", "img.usemap", "img.ismap", "map.name", "area.shape", "area.coords", "area.href", "area.nohref", "area.alt", "table.summary", "table.width", "table.border", "table.frame", "table.rules", "table.cellspacing", "table.cellpadding", "pre.space"});
                if (ok) continue;
                this.rule(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, false, "Illegal attribute name in the XHTML ('" + an + "' on '" + node.getName() + "')", new Object[0]);
            }
            this.checkInnerNames(errors, e, path, node.getChildNodes());
        }
    }

    private void checkInnerNS(List<ValidationMessage> errors, org.hl7.fhir.dstu2016may.metamodel.Element e, String path, List<XhtmlNode> list) {
        for (XhtmlNode node : list) {
            if (node.getNodeType() != NodeType.Element) continue;
            String ns = node.getNsDecl();
            this.rule(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), path, ns == null || "http://www.w3.org/1999/xhtml".equals(ns), "Wrong namespace on the XHTML ('" + ns + "')", new Object[0]);
            this.checkInnerNS(errors, e, path, node.getChildNodes());
        }
    }

    private void checkPrimitiveBinding(List<ValidationMessage> errors, String path, String type, ElementDefinition elementContext, org.hl7.fhir.dstu2016may.metamodel.Element element, StructureDefinition profile) {
        if (!element.hasPrimitiveValue()) {
            return;
        }
        String value = element.primitiveValue();
        ElementDefinition.ElementDefinitionBindingComponent binding = elementContext.getBinding();
        if (binding.hasValueSet() && binding.getValueSet() instanceof Reference) {
            ValueSet vs = this.resolveBindingReference(profile, binding.getValueSet());
            if (this.warning(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, vs != null, "ValueSet {0} not found", this.describeReference(binding.getValueSet()))) {
                long t = System.nanoTime();
                IWorkerContext.ValidationResult vr = this.context.validateCode(null, value, null, vs);
                this.txTime += System.nanoTime() - t;
                if (vr != null && !vr.isOk()) {
                    if (binding.getStrength() == Enumerations.BindingStrength.REQUIRED) {
                        this.rule(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "The value provided ('" + value + "') is not in the value set " + this.describeReference(binding.getValueSet()) + " (" + vs.getUrl() + ", and a code is required from this value set", new Object[0]);
                    } else if (binding.getStrength() == Enumerations.BindingStrength.EXTENSIBLE) {
                        this.warning(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "The value provided ('" + value + "') is not in the value set " + this.describeReference(binding.getValueSet()) + " (" + vs.getUrl() + ", and a code should come from this value set unless it has no suitable code", new Object[0]);
                    } else if (binding.getStrength() == Enumerations.BindingStrength.PREFERRED) {
                        this.hint(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, false, "The value provided ('" + value + "') is not in the value set " + this.describeReference(binding.getValueSet()) + " (" + vs.getUrl() + ", and a code is recommended to come from this value set");
                    }
                }
            }
        } else {
            this.hint(errors, ValidationMessage.IssueType.CODEINVALID, element.line(), element.col(), path, !type.equals("code"), "Binding has no source, so can't be checked");
        }
    }

    private void checkQuantity(List<ValidationMessage> errors, String path, org.hl7.fhir.dstu2016may.metamodel.Element focus, Quantity fixed) {
        this.checkFixedValue(errors, path + ".value", focus.getNamedChild("value"), fixed.getValueElement(), "value");
        this.checkFixedValue(errors, path + ".comparator", focus.getNamedChild("comparator"), fixed.getComparatorElement(), "comparator");
        this.checkFixedValue(errors, path + ".units", focus.getNamedChild("unit"), fixed.getUnitElement(), "units");
        this.checkFixedValue(errors, path + ".system", focus.getNamedChild("system"), fixed.getSystemElement(), "system");
        this.checkFixedValue(errors, path + ".code", focus.getNamedChild("code"), fixed.getCodeElement(), "code");
    }

    private void checkRange(List<ValidationMessage> errors, String path, org.hl7.fhir.dstu2016may.metamodel.Element focus, Range fixed) {
        this.checkFixedValue(errors, path + ".low", focus.getNamedChild("low"), fixed.getLow(), "low");
        this.checkFixedValue(errors, path + ".high", focus.getNamedChild("high"), fixed.getHigh(), "high");
    }

    private void checkRatio(List<ValidationMessage> errors, String path, org.hl7.fhir.dstu2016may.metamodel.Element focus, Ratio fixed) {
        this.checkFixedValue(errors, path + ".numerator", focus.getNamedChild("numerator"), fixed.getNumerator(), "numerator");
        this.checkFixedValue(errors, path + ".denominator", focus.getNamedChild("denominator"), fixed.getDenominator(), "denominator");
    }

    private void checkReference(List<ValidationMessage> errors, String path, org.hl7.fhir.dstu2016may.metamodel.Element element, StructureDefinition profile, ElementDefinition container, String parentType, NodeStack stack) {
        String ref = element.getNamedChildValue("reference");
        if (Utilities.noString((String)ref)) {
            this.warning(errors, ValidationMessage.IssueType.STRUCTURE, element.line(), element.col(), path, !Utilities.noString((String)element.getNamedChildValue("display")), "A Reference without an actual reference should have a display", new Object[0]);
            return;
        }
        org.hl7.fhir.dstu2016may.metamodel.Element we = this.resolve(ref, stack);
        String ft = we != null ? we.getType() : this.tryParse(ref);
        if (this.hint(errors, ValidationMessage.IssueType.STRUCTURE, element.line(), element.col(), path, ft != null, "Unable to determine type of target resource")) {
            boolean ok = false;
            CommaSeparatedStringBuilder b = new CommaSeparatedStringBuilder();
            for (ElementDefinition.TypeRefComponent type : container.getType()) {
                if (!ok && type.getCode().equals("Reference")) {
                    if (!type.hasProfile() || ((String)type.getProfile().get(0).getValue()).equals("http://hl7.org/fhir/StructureDefinition/Resource")) {
                        ok = true;
                    } else {
                        String pr = (String)type.getProfile().get(0).getValue();
                        String bt = this.getBaseType(profile, pr);
                        if (this.rule(errors, ValidationMessage.IssueType.STRUCTURE, element.line(), element.col(), path, bt != null, "Unable to resolve the profile reference '" + pr + "'", new Object[0])) {
                            b.append(bt);
                            ok = bt.equals(ft);
                        } else {
                            ok = true;
                        }
                    }
                }
                if (ok || !type.getCode().equals("*")) continue;
                ok = true;
            }
            this.rule(errors, ValidationMessage.IssueType.STRUCTURE, element.line(), element.col(), path, ok, "Invalid Resource target type. Found " + ft + ", but expected one of (" + b.toString() + ")", new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String checkResourceType(String type) {
        long t = System.nanoTime();
        try {
            if (this.context.fetchResource(StructureDefinition.class, "http://hl7.org/fhir/StructureDefinition/" + type) != null) {
                String string = type;
                return string;
            }
            String string = null;
            return string;
        }
        finally {
            this.sdTime += System.nanoTime() - t;
        }
    }

    private void checkSampledData(List<ValidationMessage> errors, String path, org.hl7.fhir.dstu2016may.metamodel.Element focus, SampledData fixed) {
        this.checkFixedValue(errors, path + ".origin", focus.getNamedChild("origin"), fixed.getOrigin(), "origin");
        this.checkFixedValue(errors, path + ".period", focus.getNamedChild("period"), fixed.getPeriodElement(), "period");
        this.checkFixedValue(errors, path + ".factor", focus.getNamedChild("factor"), fixed.getFactorElement(), "factor");
        this.checkFixedValue(errors, path + ".lowerLimit", focus.getNamedChild("lowerLimit"), fixed.getLowerLimitElement(), "lowerLimit");
        this.checkFixedValue(errors, path + ".upperLimit", focus.getNamedChild("upperLimit"), fixed.getUpperLimitElement(), "upperLimit");
        this.checkFixedValue(errors, path + ".dimensions", focus.getNamedChild("dimensions"), fixed.getDimensionsElement(), "dimensions");
        this.checkFixedValue(errors, path + ".data", focus.getNamedChild("data"), fixed.getDataElement(), "data");
    }

    private void checkTiming(List<ValidationMessage> errors, String path, org.hl7.fhir.dstu2016may.metamodel.Element focus, Timing fixed) {
        this.checkFixedValue(errors, path + ".repeat", focus.getNamedChild("repeat"), fixed.getRepeat(), "value");
        ArrayList<org.hl7.fhir.dstu2016may.metamodel.Element> events = new ArrayList<org.hl7.fhir.dstu2016may.metamodel.Element>();
        focus.getNamedChildren("event", events);
        if (this.rule(errors, ValidationMessage.IssueType.VALUE, focus.line(), focus.col(), path, events.size() == fixed.getEvent().size(), "Expected " + Integer.toString(fixed.getEvent().size()) + " but found " + Integer.toString(events.size()) + " event elements", new Object[0])) {
            for (int i = 0; i < events.size(); ++i) {
                this.checkFixedValue(errors, path + ".event", (org.hl7.fhir.dstu2016may.metamodel.Element)events.get(i), fixed.getEvent().get(i), "event");
            }
        }
    }

    private boolean codeinExpansion(ValueSet.ValueSetExpansionContainsComponent cnt, String system, String code) {
        for (ValueSet.ValueSetExpansionContainsComponent c : cnt.getContains()) {
            if (code.equals(c.getCode()) && system.equals(c.getSystem().toString())) {
                return true;
            }
            if (!this.codeinExpansion(c, system, code)) continue;
            return true;
        }
        return false;
    }

    private boolean codeInExpansion(ValueSet vs, String system, String code) {
        for (ValueSet.ValueSetExpansionContainsComponent c : vs.getExpansion().getContains()) {
            if (code.equals(c.getCode()) && (system == null || system.equals(c.getSystem()))) {
                return true;
            }
            if (!this.codeinExpansion(c, system, code)) continue;
            return true;
        }
        return false;
    }

    private String describeReference(Type reference) {
        if (reference == null) {
            return "null";
        }
        if (reference instanceof UriType) {
            return (String)((UriType)reference).getValue();
        }
        if (reference instanceof Reference) {
            return ((Reference)reference).getReference();
        }
        return "??";
    }

    private String describeTypes(List<ElementDefinition.TypeRefComponent> types) {
        CommaSeparatedStringBuilder b = new CommaSeparatedStringBuilder();
        for (ElementDefinition.TypeRefComponent t : types) {
            b.append(t.getCode());
        }
        return b.toString();
    }

    private ElementDefinition findElement(StructureDefinition profile, String name) {
        for (ElementDefinition c : profile.getSnapshot().getElement()) {
            if (!c.getPath().equals(name)) continue;
            return c;
        }
        return null;
    }

    private String genFullUrl(String bundleBase, String entryBase, String type, String id) {
        String base;
        String string = base = Utilities.noString((String)entryBase) ? bundleBase : entryBase;
        if (Utilities.noString((String)base)) {
            return type + "/" + id;
        }
        if ("urn:uuid".equals(base) || "urn:oid".equals(base)) {
            return base + id;
        }
        return Utilities.appendSlash((String)base) + type + "/" + id;
    }

    @Override
    public IResourceValidator.BestPracticeWarningLevel getBasePracticeWarningLevel() {
        return this.bpWarnings;
    }

    private String getBaseType(StructureDefinition profile, String pr) {
        StructureDefinition p = this.resolveProfile(profile, pr);
        if (p == null) {
            return null;
        }
        if (p.getKind() == StructureDefinition.StructureDefinitionKind.RESOURCE) {
            return p.getSnapshot().getElement().get(0).getPath();
        }
        return p.getSnapshot().getElement().get(0).getType().get(0).getCode();
    }

    @Override
    public IResourceValidator.CheckDisplayOption getCheckDisplay() {
        return this.checkDisplay;
    }

    private CodeSystem.ConceptDefinitionComponent getCodeDefinition(CodeSystem.ConceptDefinitionComponent c, String code) {
        if (code.equals(c.getCode())) {
            return c;
        }
        for (CodeSystem.ConceptDefinitionComponent g : c.getConcept()) {
            CodeSystem.ConceptDefinitionComponent r = this.getCodeDefinition(g, code);
            if (r == null) continue;
            return r;
        }
        return null;
    }

    private CodeSystem.ConceptDefinitionComponent getCodeDefinition(CodeSystem cs, String code) {
        for (CodeSystem.ConceptDefinitionComponent c : cs.getConcept()) {
            CodeSystem.ConceptDefinitionComponent r = this.getCodeDefinition(c, code);
            if (r == null) continue;
            return r;
        }
        return null;
    }

    private org.hl7.fhir.dstu2016may.metamodel.Element getContainedById(org.hl7.fhir.dstu2016may.metamodel.Element container, String id) {
        ArrayList<org.hl7.fhir.dstu2016may.metamodel.Element> contained = new ArrayList<org.hl7.fhir.dstu2016may.metamodel.Element>();
        container.getNamedChildren("contained", contained);
        for (org.hl7.fhir.dstu2016may.metamodel.Element we : contained) {
            if (!id.equals(we.getNamedChildValue("id"))) continue;
            return we;
        }
        return null;
    }

    public IWorkerContext getContext() {
        return this.context;
    }

    private ElementDefinition getCriteriaForDiscriminator(String path, ElementDefinition ed, String discriminator, StructureDefinition profile) throws DefinitionException, DefinitionException {
        int index;
        List<ElementDefinition> childDefinitions = ProfileUtilities.getChildMap(profile, ed);
        List<ElementDefinition> snapshot = null;
        if (childDefinitions.isEmpty()) {
            StructureDefinition type;
            long t;
            if (ed.getType().size() == 0) {
                throw new DefinitionException("Error in profile for " + path + " no children, no type");
            }
            if (ed.getType().size() > 1) {
                throw new DefinitionException("Error in profile for " + path + " multiple types defined in slice discriminator");
            }
            if (ed.getType().get(0).hasProfile()) {
                if (ed.getType().get(0).getCode().equals("Reference")) {
                    discriminator = discriminator.substring(discriminator.indexOf(".") + 1);
                }
                t = System.nanoTime();
                type = this.context.fetchResource(StructureDefinition.class, (String)ed.getType().get(0).getProfile().get(0).getValue());
                this.sdTime += System.nanoTime() - t;
            } else {
                t = System.nanoTime();
                type = this.context.fetchResource(StructureDefinition.class, "http://hl7.org/fhir/StructureDefinition/" + ed.getType().get(0).getCode());
                this.sdTime += System.nanoTime() - t;
            }
            snapshot = type.getSnapshot().getElement();
            ed = snapshot.get(0);
            index = 0;
        } else {
            snapshot = childDefinitions;
            index = -1;
        }
        String originalPath = ed.getPath();
        String goal = originalPath + "." + discriminator;
        ++index;
        while (index < snapshot.size() && !snapshot.get(index).getPath().equals(originalPath)) {
            if (snapshot.get(index).getPath().equals(goal)) {
                return snapshot.get(index);
            }
            ++index;
        }
        throw new Error("Unable to find discriminator definition for " + goal + " in " + discriminator + " at " + path);
    }

    private org.hl7.fhir.dstu2016may.metamodel.Element getExtensionByUrl(List<org.hl7.fhir.dstu2016may.metamodel.Element> extensions, String urlSimple) {
        for (org.hl7.fhir.dstu2016may.metamodel.Element e : extensions) {
            if (!urlSimple.equals(e.getNamedChildValue("url"))) continue;
            return e;
        }
        return null;
    }

    public List<String> getExtensionDomains() {
        return this.extensionDomains;
    }

    private org.hl7.fhir.dstu2016may.metamodel.Element getFromBundle(org.hl7.fhir.dstu2016may.metamodel.Element bundle, String ref, String fullUrl) {
        ArrayList<org.hl7.fhir.dstu2016may.metamodel.Element> entries = new ArrayList<org.hl7.fhir.dstu2016may.metamodel.Element>();
        bundle.getNamedChildren("entry", entries);
        for (org.hl7.fhir.dstu2016may.metamodel.Element we : entries) {
            String url;
            org.hl7.fhir.dstu2016may.metamodel.Element res = we.getNamedChild("resource");
            if (res == null || !(url = this.genFullUrl(bundle.getNamedChildValue("base"), we.getNamedChildValue("base"), res.getName(), res.getNamedChildValue("id"))).endsWith(ref)) continue;
            return res;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StructureDefinition getProfileForType(String type) {
        if (this.logical != null) {
            for (Bundle.BundleEntryComponent be : this.logical.getEntry()) {
                StructureDefinition sd;
                if (!be.hasResource() || !(be.getResource() instanceof StructureDefinition) || !(sd = (StructureDefinition)be.getResource()).getId().equals(type)) continue;
                return sd;
            }
        }
        long t = System.nanoTime();
        try {
            StructureDefinition structureDefinition = this.context.fetchResource(StructureDefinition.class, "http://hl7.org/fhir/StructureDefinition/" + type);
            return structureDefinition;
        }
        finally {
            this.sdTime += System.nanoTime() - t;
        }
    }

    private org.hl7.fhir.dstu2016may.metamodel.Element getValueForDiscriminator(org.hl7.fhir.dstu2016may.metamodel.Element element, String discriminator, ElementDefinition criteria) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CodeSystem getCodeSystem(String system) {
        long t = System.nanoTime();
        try {
            CodeSystem codeSystem = this.context.fetchCodeSystem(system);
            return codeSystem;
        }
        finally {
            this.txTime += System.nanoTime() - t;
        }
    }

    private boolean hasTime(String fmt) {
        return fmt.contains("T");
    }

    private boolean hasTimeZone(String fmt) {
        return fmt.length() > 10 && (fmt.substring(10).contains("-") || fmt.substring(10).contains("+") || fmt.substring(10).contains("Z"));
    }

    private boolean isAbsolute(String uri) {
        return Utilities.noString((String)uri) || uri.startsWith("http:") || uri.startsWith("https:") || uri.startsWith("urn:uuid:") || uri.startsWith("urn:oid:") || uri.startsWith("urn:ietf:") || uri.startsWith("urn:iso:") || this.isValidFHIRUrn(uri);
    }

    private boolean isValidFHIRUrn(String uri) {
        return uri.equals("urn:x-fhir:uk:id:nhs-number");
    }

    public boolean isAnyExtensionsAllowed() {
        return this.anyExtensionsAllowed;
    }

    private boolean isParametersEntry(String path) {
        String[] parts = path.split("\\.");
        return parts.length > 2 && parts[parts.length - 1].equals("resource") && (parts[parts.length - 2].startsWith("parameter[") || parts[parts.length - 2].startsWith("part["));
    }

    private boolean isBundleEntry(String path) {
        String[] parts = path.split("\\.");
        return parts.length > 2 && parts[parts.length - 1].equals("resource") && parts[parts.length - 2].startsWith("entry[");
    }

    private boolean isPrimitiveType(String type) {
        return type.equalsIgnoreCase("boolean") || type.equalsIgnoreCase("integer") || type.equalsIgnoreCase("string") || type.equalsIgnoreCase("decimal") || type.equalsIgnoreCase("uri") || type.equalsIgnoreCase("base64Binary") || type.equalsIgnoreCase("instant") || type.equalsIgnoreCase("date") || type.equalsIgnoreCase("uuid") || type.equalsIgnoreCase("id") || type.equalsIgnoreCase("xhtml") || type.equalsIgnoreCase("markdown") || type.equalsIgnoreCase("dateTime") || type.equalsIgnoreCase("time") || type.equalsIgnoreCase("code") || type.equalsIgnoreCase("oid") || type.equalsIgnoreCase("id");
    }

    public boolean isSuppressLoincSnomedMessages() {
        return this.suppressLoincSnomedMessages;
    }

    private boolean nameMatches(String name, String tail) {
        if (tail.endsWith("[x]")) {
            return name.startsWith(tail.substring(0, tail.length() - 3));
        }
        return name.equals(tail);
    }

    private boolean passesCodeWhitespaceRules(String v) {
        if (!v.trim().equals(v)) {
            return false;
        }
        boolean lastWasSpace = true;
        for (char c : v.toCharArray()) {
            if (c == ' ') {
                if (lastWasSpace) {
                    return false;
                }
                lastWasSpace = true;
                continue;
            }
            if (Character.isWhitespace(c)) {
                return false;
            }
            lastWasSpace = false;
        }
        return true;
    }

    private org.hl7.fhir.dstu2016may.metamodel.Element resolve(String ref, NodeStack stack) {
        if (ref.startsWith("#")) {
            while (stack != null && stack.getElement() != null) {
                org.hl7.fhir.dstu2016may.metamodel.Element res;
                if (stack.getElement().getProperty().isResource() && (res = this.getContainedById(stack.getElement(), ref.substring(1))) != null) {
                    return res;
                }
                if (stack.getElement().getSpecial() == Element.SpecialElement.BUNDLE_ENTRY) {
                    return null;
                }
                stack = stack.parent;
            }
            return null;
        }
        String fullUrl = null;
        while (stack != null && stack.getElement() != null) {
            if (stack.getElement().getSpecial() == Element.SpecialElement.BUNDLE_ENTRY) {
                fullUrl = "test";
            }
            if ("Bundle".equals(stack.getElement().getType())) {
                org.hl7.fhir.dstu2016may.metamodel.Element res = this.getFromBundle(stack.getElement(), ref, fullUrl);
                return res;
            }
            stack = stack.parent;
        }
        return null;
    }

    private ValueSet resolveBindingReference(DomainResource ctxt, Type reference) {
        if (reference instanceof UriType) {
            long t = System.nanoTime();
            ValueSet fr = this.context.fetchResource(ValueSet.class, ((String)((UriType)reference).getValue()).toString());
            this.txTime += System.nanoTime() - t;
            return fr;
        }
        if (reference instanceof Reference) {
            String s = ((Reference)reference).getReference();
            if (s.startsWith("#")) {
                for (Resource c : ctxt.getContained()) {
                    if (!c.getId().equals(s.substring(1)) || !(c instanceof ValueSet)) continue;
                    return (ValueSet)c;
                }
                return null;
            }
            long t = System.nanoTime();
            ValueSet fr = this.context.fetchResource(ValueSet.class, ((Reference)reference).getReference());
            this.txTime += System.nanoTime() - t;
            return fr;
        }
        return null;
    }

    private org.hl7.fhir.dstu2016may.metamodel.Element resolveInBundle(List<org.hl7.fhir.dstu2016may.metamodel.Element> entries, String ref, String fullUrl, String type, String id) {
        String[] parts;
        if (Utilities.isAbsoluteUrl((String)ref)) {
            for (org.hl7.fhir.dstu2016may.metamodel.Element entry : entries) {
                String fu = entry.getNamedChildValue("fullUrl");
                if (!ref.equals(fu)) continue;
                return entry;
            }
            return null;
        }
        String u = null;
        if (fullUrl != null && fullUrl.endsWith(type + "/" + id)) {
            u = fullUrl.substring((type + "/" + id).length()) + ref;
        }
        if ((parts = ref.split("\\/")).length >= 2) {
            String t = parts[0];
            String i = parts[1];
            for (org.hl7.fhir.dstu2016may.metamodel.Element entry : entries) {
                String fu = entry.getNamedChildValue("fullUrl");
                if (u != null && fullUrl.equals(u)) {
                    return entry;
                }
                if (u != null) continue;
                org.hl7.fhir.dstu2016may.metamodel.Element resource = entry.getNamedChild("resource");
                String et = resource.getType();
                String eid = resource.getNamedChildValue("id");
                if (!t.equals(et) || !i.equals(eid)) continue;
                return entry;
            }
        }
        return null;
    }

    private ElementDefinition resolveNameReference(StructureDefinition.StructureDefinitionSnapshotComponent snapshot, String contentReference) {
        for (ElementDefinition ed : snapshot.getElement()) {
            if (!contentReference.equals("#" + ed.getId())) continue;
            return ed;
        }
        return null;
    }

    private StructureDefinition resolveProfile(StructureDefinition profile, String pr) {
        if (pr.startsWith("#")) {
            for (Resource r : profile.getContained()) {
                if (!r.getId().equals(pr.substring(1)) || !(r instanceof StructureDefinition)) continue;
                return (StructureDefinition)r;
            }
            return null;
        }
        long t = System.nanoTime();
        StructureDefinition fr = this.context.fetchResource(StructureDefinition.class, pr);
        this.sdTime += System.nanoTime() - t;
        return fr;
    }

    private ElementDefinition resolveType(String type) {
        if (this.logical != null) {
            for (Bundle.BundleEntryComponent be : this.logical.getEntry()) {
                StructureDefinition sd;
                if (!be.hasResource() || !(be.getResource() instanceof StructureDefinition) || !(sd = (StructureDefinition)be.getResource()).getId().equals(type)) continue;
                return sd.getSnapshot().getElement().get(0);
            }
        }
        String url = "http://hl7.org/fhir/StructureDefinition/" + type;
        long t = System.nanoTime();
        StructureDefinition sd = this.context.fetchResource(StructureDefinition.class, url);
        this.sdTime += System.nanoTime() - t;
        if (sd == null || !sd.hasSnapshot()) {
            return null;
        }
        return sd.getSnapshot().getElement().get(0);
    }

    public void setAnyExtensionsAllowed(boolean anyExtensionsAllowed) {
        this.anyExtensionsAllowed = anyExtensionsAllowed;
    }

    @Override
    public void setBestPracticeWarningLevel(IResourceValidator.BestPracticeWarningLevel value) {
        this.bpWarnings = value;
    }

    @Override
    public void setCheckDisplay(IResourceValidator.CheckDisplayOption checkDisplay) {
        this.checkDisplay = checkDisplay;
    }

    public void setSuppressLoincSnomedMessages(boolean suppressLoincSnomedMessages) {
        this.suppressLoincSnomedMessages = suppressLoincSnomedMessages;
    }

    @Override
    public IResourceValidator.IdStatus getResourceIdRule() {
        return this.resourceIdRule;
    }

    @Override
    public void setResourceIdRule(IResourceValidator.IdStatus resourceIdRule) {
        this.resourceIdRule = resourceIdRule;
    }

    private boolean sliceMatches(org.hl7.fhir.dstu2016may.metamodel.Element element, String path, ElementDefinition slice, ElementDefinition ed, StructureDefinition profile) throws DefinitionException, DefinitionException {
        if (!slice.getSlicing().hasDiscriminator()) {
            return false;
        }
        for (StringType s : slice.getSlicing().getDiscriminator()) {
            org.hl7.fhir.dstu2016may.metamodel.Element value;
            String discriminator = (String)s.getValue();
            ElementDefinition criteria = this.getCriteriaForDiscriminator(path, ed, discriminator, profile);
            if (!(discriminator.equals("url") && criteria.getPath().equals("Extension.url") ? !element.getNamedChildValue("url").equals(((UriType)criteria.getFixed()).asStringValue()) : !this.valueMatchesCriteria(value = this.getValueForDiscriminator(element, discriminator, criteria), criteria))) continue;
            return false;
        }
        return true;
    }

    private void start(List<ValidationMessage> errors, org.hl7.fhir.dstu2016may.metamodel.Element resource, org.hl7.fhir.dstu2016may.metamodel.Element element, StructureDefinition profile, NodeStack stack) throws FHIRException, FHIRException {
        if (this.rule(errors, ValidationMessage.IssueType.STRUCTURE, element.line(), element.col(), stack.getLiteralPath(), profile.hasSnapshot(), "StructureDefinition has no snapshot - validation is against the snapshot, so it must be provided", new Object[0])) {
            this.validateElement(errors, profile, profile.getSnapshot().getElement().get(0), null, null, resource, element, element.getName(), stack, false);
            this.checkDeclaredProfiles(errors, resource, element, stack);
            if (element.getType().equals("Bundle")) {
                this.validateBundle(errors, element, stack);
            }
            if (element.getType().equals("Observation")) {
                this.validateObservation(errors, element, stack);
            }
            if (element.getType().equals("QuestionnaireResponse")) {
                this.validateQuestionannaireResponse(errors, element, stack);
            }
        }
    }

    private void validateQuestionannaireResponse(List<ValidationMessage> errors, org.hl7.fhir.dstu2016may.metamodel.Element element, NodeStack stack) {
        org.hl7.fhir.dstu2016may.metamodel.Element q = element.getNamedChild("questionnaire");
        if (this.hint(errors, ValidationMessage.IssueType.REQUIRED, element.line(), element.col(), stack.getLiteralPath(), q != null, "No questionnaire is identified, so no validation can be performed against the base questionnaire")) {
            long t = System.nanoTime();
            Questionnaire qsrc = this.context.fetchResource(Questionnaire.class, q.getNamedChildValue("reference"));
            this.sdTime += System.nanoTime() - t;
            if (this.warning(errors, ValidationMessage.IssueType.REQUIRED, q.line(), q.col(), stack.getLiteralPath(), qsrc != null, "The questionnaire could not be resolved, so no validation can be performed against the base questionnaire", new Object[0])) {
                boolean inProgress = "in-progress".equals(element.getNamedChildValue("status"));
                this.validateQuestionannaireResponseItems(qsrc, qsrc.getItem(), errors, element, stack, inProgress);
            }
        }
    }

    private void validateQuestionannaireResponseItem(Questionnaire qsrc, Questionnaire.QuestionnaireItemComponent qItem, List<ValidationMessage> errors, org.hl7.fhir.dstu2016may.metamodel.Element element, NodeStack stack, boolean inProgress) {
        String text = element.getNamedChildValue("text");
        this.rule(errors, ValidationMessage.IssueType.INVALID, element.line(), element.col(), stack.getLiteralPath(), Utilities.noString((String)text) || text.equals(qItem.getText()), "If text exists, it must match the questionnaire definition for linkId " + qItem.getLinkId(), new Object[0]);
        ArrayList<org.hl7.fhir.dstu2016may.metamodel.Element> answers = new ArrayList<org.hl7.fhir.dstu2016may.metamodel.Element>();
        element.getNamedChildren("answer", answers);
        if (inProgress) {
            this.warning(errors, ValidationMessage.IssueType.REQUIRED, element.line(), element.col(), stack.getLiteralPath(), answers.size() > 0 || !qItem.getRequired(), "No response answer found for required item " + qItem.getLinkId(), new Object[0]);
        } else {
            this.rule(errors, ValidationMessage.IssueType.REQUIRED, element.line(), element.col(), stack.getLiteralPath(), answers.size() > 0 || !qItem.getRequired(), "No response answer found for required item " + qItem.getLinkId(), new Object[0]);
        }
        if (answers.size() > 1) {
            this.rule(errors, ValidationMessage.IssueType.INVALID, ((org.hl7.fhir.dstu2016may.metamodel.Element)answers.get(1)).line(), ((org.hl7.fhir.dstu2016may.metamodel.Element)answers.get(1)).col(), stack.getLiteralPath(), qItem.getRepeats(), "Only one response answer item with this linkId allowed", new Object[0]);
        }
        for (org.hl7.fhir.dstu2016may.metamodel.Element answer : answers) {
            NodeStack ns = stack.push(answer, -1, null, null);
            switch (qItem.getType()) {
                case GROUP: {
                    this.rule(errors, ValidationMessage.IssueType.STRUCTURE, answer.line(), answer.col(), stack.getLiteralPath(), false, "Items of type group should not have answers", new Object[0]);
                    break;
                }
                case DISPLAY: {
                    break;
                }
                case BOOLEAN: {
                    this.validateQuestionnaireResponseItemType(errors, answer, ns, "boolean");
                    break;
                }
                case DECIMAL: {
                    this.validateQuestionnaireResponseItemType(errors, answer, ns, "decimal");
                    break;
                }
                case INTEGER: {
                    this.validateQuestionnaireResponseItemType(errors, answer, ns, "integer");
                    break;
                }
                case DATE: {
                    this.validateQuestionnaireResponseItemType(errors, answer, ns, "date");
                    break;
                }
                case DATETIME: {
                    this.validateQuestionnaireResponseItemType(errors, answer, ns, "dateTime");
                    break;
                }
                case INSTANT: {
                    this.validateQuestionnaireResponseItemType(errors, answer, ns, "instant");
                    break;
                }
                case TIME: {
                    this.validateQuestionnaireResponseItemType(errors, answer, ns, "time");
                    break;
                }
                case STRING: {
                    this.validateQuestionnaireResponseItemType(errors, answer, ns, "string");
                    break;
                }
                case TEXT: {
                    this.validateQuestionnaireResponseItemType(errors, answer, ns, "text");
                    break;
                }
                case URL: {
                    this.validateQuestionnaireResponseItemType(errors, answer, ns, "uri");
                    break;
                }
                case ATTACHMENT: {
                    this.validateQuestionnaireResponseItemType(errors, answer, ns, "Attachment");
                    break;
                }
                case REFERENCE: {
                    this.validateQuestionnaireResponseItemType(errors, answer, ns, "Reference");
                    break;
                }
                case QUANTITY: {
                    if (!this.validateQuestionnaireResponseItemType(errors, answer, ns, "Quantity").equals("Quantity") || !qItem.hasExtension("???")) break;
                    this.validateQuestionnaireResponseItemQuantity(errors, answer, ns);
                    break;
                }
                case CHOICE: {
                    String itemType = this.validateQuestionnaireResponseItemType(errors, answer, ns, "Coding", "date", "time", "integer", "string");
                    if (itemType.equals("Coding")) {
                        this.validateAnswerCode(errors, answer, ns, qsrc, qItem, false);
                        break;
                    }
                    if (itemType.equals("date")) {
                        this.checkOption(errors, answer, ns, qsrc, qItem, "date");
                        break;
                    }
                    if (itemType.equals("time")) {
                        this.checkOption(errors, answer, ns, qsrc, qItem, "time");
                        break;
                    }
                    if (itemType.equals("integer")) {
                        this.checkOption(errors, answer, ns, qsrc, qItem, "integer");
                        break;
                    }
                    if (!itemType.equals("string")) break;
                    this.checkOption(errors, answer, ns, qsrc, qItem, "string");
                    break;
                }
                case OPENCHOICE: {
                    String itemType = this.validateQuestionnaireResponseItemType(errors, answer, ns, "Coding", "date", "time", "integer", "string");
                    if (itemType.equals("Coding")) {
                        this.validateAnswerCode(errors, answer, ns, qsrc, qItem, true);
                        break;
                    }
                    if (itemType.equals("date")) {
                        this.checkOption(errors, answer, ns, qsrc, qItem, "date");
                        break;
                    }
                    if (itemType.equals("time")) {
                        this.checkOption(errors, answer, ns, qsrc, qItem, "time");
                        break;
                    }
                    if (itemType.equals("integer")) {
                        this.checkOption(errors, answer, ns, qsrc, qItem, "integer");
                        break;
                    }
                    if (!itemType.equals("string")) break;
                    this.checkOption(errors, answer, ns, qsrc, qItem, "string", true);
                    break;
                }
            }
            this.validateQuestionannaireResponseItems(qsrc, qItem.getItem(), errors, answer, stack, inProgress);
        }
        if (qItem.getType() == null) {
            this.fail(errors, ValidationMessage.IssueType.REQUIRED, element.line(), element.col(), stack.getLiteralPath(), false, "Definition for item " + qItem.getLinkId() + " does not contain a type");
        } else if (qItem.getType() == Questionnaire.QuestionnaireItemType.GROUP) {
            this.validateQuestionannaireResponseItems(qsrc, qItem.getItem(), errors, element, stack, inProgress);
        } else {
            ArrayList<org.hl7.fhir.dstu2016may.metamodel.Element> items = new ArrayList<org.hl7.fhir.dstu2016may.metamodel.Element>();
            element.getNamedChildren("item", items);
            for (org.hl7.fhir.dstu2016may.metamodel.Element item : items) {
                NodeStack ns = stack.push(item, -1, null, null);
                this.rule(errors, ValidationMessage.IssueType.STRUCTURE, ((org.hl7.fhir.dstu2016may.metamodel.Element)answers.get(0)).line(), ((org.hl7.fhir.dstu2016may.metamodel.Element)answers.get(0)).col(), stack.getLiteralPath(), false, "Items not of type group should not have items - Item with linkId {0} of type {1} has {2} item(s)", new Object[]{qItem.getLinkId(), qItem.getType(), items.size()});
            }
        }
    }

    private void validateQuestionannaireResponseItem(Questionnaire qsrc, Questionnaire.QuestionnaireItemComponent qItem, List<ValidationMessage> errors, List<org.hl7.fhir.dstu2016may.metamodel.Element> elements, NodeStack stack, boolean inProgress) {
        if (elements.size() > 1) {
            this.rule(errors, ValidationMessage.IssueType.INVALID, elements.get(1).line(), elements.get(1).col(), stack.getLiteralPath(), qItem.getRepeats(), "Only one response item with this linkId allowed", new Object[0]);
        }
        for (org.hl7.fhir.dstu2016may.metamodel.Element element : elements) {
            NodeStack ns = stack.push(element, -1, null, null);
            this.validateQuestionannaireResponseItem(qsrc, qItem, errors, element, ns, inProgress);
        }
    }

    private int getLinkIdIndex(List<Questionnaire.QuestionnaireItemComponent> qItems, String linkId) {
        for (int i = 0; i < qItems.size(); ++i) {
            if (!linkId.equals(qItems.get(i).getLinkId())) continue;
            return i;
        }
        return -1;
    }

    private void validateQuestionannaireResponseItems(Questionnaire qsrc, List<Questionnaire.QuestionnaireItemComponent> qItems, List<ValidationMessage> errors, org.hl7.fhir.dstu2016may.metamodel.Element element, NodeStack stack, boolean inProgress) {
        ArrayList<org.hl7.fhir.dstu2016may.metamodel.Element> items = new ArrayList<org.hl7.fhir.dstu2016may.metamodel.Element>();
        element.getNamedChildren("item", items);
        HashMap<String, ArrayList<org.hl7.fhir.dstu2016may.metamodel.Element>> map = new HashMap<String, ArrayList<org.hl7.fhir.dstu2016may.metamodel.Element>>();
        int lastIndex = -1;
        for (org.hl7.fhir.dstu2016may.metamodel.Element item : items) {
            String linkId = item.getNamedChildValue("linkId");
            if (!this.rule(errors, ValidationMessage.IssueType.REQUIRED, item.line(), item.col(), stack.getLiteralPath(), !Utilities.noString((String)linkId), "No LinkId, so can't be validated", new Object[0])) continue;
            int index = this.getLinkIdIndex(qItems, linkId);
            if (index == -1) {
                Questionnaire.QuestionnaireItemComponent qItem = this.findQuestionnaireItem(qsrc, linkId);
                if (qItem != null) {
                    this.rule(errors, ValidationMessage.IssueType.STRUCTURE, item.line(), item.col(), stack.getLiteralPath(), index > -1, "Structural Error: item is in the wrong place", new Object[0]);
                    NodeStack ns = stack.push(item, -1, null, null);
                    this.validateQuestionannaireResponseItem(qsrc, qItem, errors, element, ns, inProgress);
                    continue;
                }
                this.rule(errors, ValidationMessage.IssueType.NOTFOUND, item.line(), item.col(), stack.getLiteralPath(), index > -1, "LinkId \"" + linkId + "\" not found in questionnaire", new Object[0]);
                continue;
            }
            this.rule(errors, ValidationMessage.IssueType.STRUCTURE, item.line(), item.col(), stack.getLiteralPath(), index >= lastIndex, "Structural Error: items are out of order", new Object[0]);
            lastIndex = index;
            ArrayList<org.hl7.fhir.dstu2016may.metamodel.Element> mapItem = (ArrayList<org.hl7.fhir.dstu2016may.metamodel.Element>)map.get(linkId);
            if (mapItem == null) {
                mapItem = new ArrayList<org.hl7.fhir.dstu2016may.metamodel.Element>();
                map.put(linkId, mapItem);
            }
            mapItem.add(item);
        }
        for (Questionnaire.QuestionnaireItemComponent qItem : qItems) {
            List mapItem = (List)map.get(qItem.getLinkId());
            if (mapItem != null) {
                this.validateQuestionannaireResponseItem(qsrc, qItem, errors, mapItem, stack, inProgress);
                continue;
            }
            this.rule(errors, ValidationMessage.IssueType.REQUIRED, element.line(), element.col(), stack.getLiteralPath(), !qItem.getRequired(), "No response found for required item " + qItem.getLinkId(), new Object[0]);
        }
    }

    private void validateQuestionnaireResponseItemQuantity(List<ValidationMessage> errors, org.hl7.fhir.dstu2016may.metamodel.Element answer, NodeStack stack) {
    }

    private String validateQuestionnaireResponseItemType(List<ValidationMessage> errors, org.hl7.fhir.dstu2016may.metamodel.Element element, NodeStack stack, String ... types) {
        ArrayList<org.hl7.fhir.dstu2016may.metamodel.Element> values = new ArrayList<org.hl7.fhir.dstu2016may.metamodel.Element>();
        element.getNamedChildrenWithWildcard("value[x]", values);
        if (values.size() > 0) {
            NodeStack ns = stack.push((org.hl7.fhir.dstu2016may.metamodel.Element)values.get(0), -1, null, null);
            CommaSeparatedStringBuilder l = new CommaSeparatedStringBuilder();
            for (String s : types) {
                l.append(s);
                if (!((org.hl7.fhir.dstu2016may.metamodel.Element)values.get(0)).getName().equals("value" + Utilities.capitalize((String)s))) continue;
                return s;
            }
            if (types.length == 1) {
                this.rule(errors, ValidationMessage.IssueType.STRUCTURE, ((org.hl7.fhir.dstu2016may.metamodel.Element)values.get(0)).line(), ((org.hl7.fhir.dstu2016may.metamodel.Element)values.get(0)).col(), ns.getLiteralPath(), false, "Answer value must be of type " + types[0], new Object[0]);
            } else {
                this.rule(errors, ValidationMessage.IssueType.STRUCTURE, ((org.hl7.fhir.dstu2016may.metamodel.Element)values.get(0)).line(), ((org.hl7.fhir.dstu2016may.metamodel.Element)values.get(0)).col(), ns.getLiteralPath(), false, "Answer value must be one of the types " + l.toString(), new Object[0]);
            }
        }
        return null;
    }

    private Questionnaire.QuestionnaireItemComponent findQuestionnaireItem(Questionnaire qSrc, String linkId) {
        return this.findItem(qSrc.getItem(), linkId);
    }

    private Questionnaire.QuestionnaireItemComponent findItem(List<Questionnaire.QuestionnaireItemComponent> list, String linkId) {
        for (Questionnaire.QuestionnaireItemComponent item : list) {
            if (linkId.equals(item.getLinkId())) {
                return item;
            }
            Questionnaire.QuestionnaireItemComponent result = this.findItem(item.getItem(), linkId);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private void validateAnswerCode(List<ValidationMessage> errors, org.hl7.fhir.dstu2016may.metamodel.Element value, NodeStack stack, Questionnaire qSrc, Reference ref, boolean theOpenChoice) {
        ValueSet vs = this.resolveBindingReference(qSrc, ref);
        if (this.warning(errors, ValidationMessage.IssueType.CODEINVALID, value.line(), value.col(), stack.getLiteralPath(), vs != null, "ValueSet " + this.describeReference(ref) + " not found", new Object[0])) {
            try {
                Coding c = this.readAsCoding(value);
                if (StringUtils.isBlank((CharSequence)c.getCode()) && StringUtils.isBlank((CharSequence)c.getSystem()) && StringUtils.isNotBlank((CharSequence)c.getDisplay()) && theOpenChoice) {
                    return;
                }
                long t = System.nanoTime();
                IWorkerContext.ValidationResult res = this.context.validateCode(c, vs);
                this.txTime += System.nanoTime() - t;
                if (!res.isOk()) {
                    this.rule(errors, ValidationMessage.IssueType.CODEINVALID, value.line(), value.col(), stack.getLiteralPath(), false, "The value provided (" + c.getSystem() + "::" + c.getCode() + ") is not in the options value set in the questionnaire", new Object[0]);
                }
            }
            catch (Exception e) {
                this.warning(errors, ValidationMessage.IssueType.CODEINVALID, value.line(), value.col(), stack.getLiteralPath(), false, "Error " + e.getMessage() + " validating Coding against Questionnaire Options", new Object[0]);
            }
        }
    }

    private void validateAnswerCode(List<ValidationMessage> errors, org.hl7.fhir.dstu2016may.metamodel.Element answer, NodeStack stack, Questionnaire qSrc, Questionnaire.QuestionnaireItemComponent qItem, boolean theOpenChoice) {
        org.hl7.fhir.dstu2016may.metamodel.Element v = answer.getNamedChild("valueCoding");
        NodeStack ns = stack.push(v, -1, null, null);
        if (qItem.getOption().size() > 0) {
            this.checkCodingOption(errors, answer, stack, qSrc, qItem, theOpenChoice);
        } else if (qItem.hasOptions()) {
            this.validateAnswerCode(errors, v, stack, qSrc, qItem.getOptions(), theOpenChoice);
        } else {
            this.hint(errors, ValidationMessage.IssueType.STRUCTURE, v.line(), v.col(), stack.getLiteralPath(), false, "Cannot validate options because no option or options are provided");
        }
    }

    private void checkOption(List<ValidationMessage> errors, org.hl7.fhir.dstu2016may.metamodel.Element answer, NodeStack stack, Questionnaire qSrc, Questionnaire.QuestionnaireItemComponent qItem, String type) {
        this.checkOption(errors, answer, stack, qSrc, qItem, type, false);
    }

    private void checkOption(List<ValidationMessage> errors, org.hl7.fhir.dstu2016may.metamodel.Element answer, NodeStack stack, Questionnaire qSrc, Questionnaire.QuestionnaireItemComponent qItem, String type, boolean openChoice) {
        if (type.equals("integer")) {
            this.checkIntegerOption(errors, answer, stack, qSrc, qItem, openChoice);
        } else if (type.equals("date")) {
            this.checkDateOption(errors, answer, stack, qSrc, qItem, openChoice);
        } else if (type.equals("time")) {
            this.checkTimeOption(errors, answer, stack, qSrc, qItem, openChoice);
        } else if (type.equals("string")) {
            this.checkStringOption(errors, answer, stack, qSrc, qItem, openChoice);
        } else if (type.equals("Coding")) {
            this.checkCodingOption(errors, answer, stack, qSrc, qItem, openChoice);
        }
    }

    private void checkIntegerOption(List<ValidationMessage> errors, org.hl7.fhir.dstu2016may.metamodel.Element answer, NodeStack stack, Questionnaire qSrc, Questionnaire.QuestionnaireItemComponent qItem, boolean openChoice) {
        org.hl7.fhir.dstu2016may.metamodel.Element v = answer.getNamedChild("valueInteger");
        NodeStack ns = stack.push(v, -1, null, null);
        if (qItem.getOption().size() > 0) {
            ArrayList<IntegerType> list = new ArrayList<IntegerType>();
            for (Questionnaire.QuestionnaireItemOptionComponent components : qItem.getOption()) {
                try {
                    list.add(components.getValueIntegerType());
                }
                catch (FHIRException fHIRException) {}
            }
            if (list.isEmpty() && !openChoice) {
                this.rule(errors, ValidationMessage.IssueType.STRUCTURE, v.line(), v.col(), stack.getLiteralPath(), false, "Option list has no option values of type integer", new Object[0]);
            } else {
                boolean found = false;
                for (IntegerType item : list) {
                    if ((Integer)item.getValue() != Integer.parseInt(v.primitiveValue())) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    this.rule(errors, ValidationMessage.IssueType.STRUCTURE, v.line(), v.col(), stack.getLiteralPath(), found, "The integer " + v.primitiveValue() + " is not a valid option", new Object[0]);
                }
            }
        } else {
            this.hint(errors, ValidationMessage.IssueType.STRUCTURE, v.line(), v.col(), stack.getLiteralPath(), false, "Cannot validate integer answer option because no option list is provided");
        }
    }

    private void checkDateOption(List<ValidationMessage> errors, org.hl7.fhir.dstu2016may.metamodel.Element answer, NodeStack stack, Questionnaire qSrc, Questionnaire.QuestionnaireItemComponent qItem, boolean openChoice) {
        org.hl7.fhir.dstu2016may.metamodel.Element v = answer.getNamedChild("valueDate");
        NodeStack ns = stack.push(v, -1, null, null);
        if (qItem.getOption().size() > 0) {
            ArrayList<DateType> list = new ArrayList<DateType>();
            for (Questionnaire.QuestionnaireItemOptionComponent components : qItem.getOption()) {
                try {
                    list.add(components.getValueDateType());
                }
                catch (FHIRException fHIRException) {}
            }
            if (list.isEmpty() && !openChoice) {
                this.rule(errors, ValidationMessage.IssueType.STRUCTURE, v.line(), v.col(), stack.getLiteralPath(), false, "Option list has no option values of type date", new Object[0]);
            } else {
                boolean found = false;
                for (DateType item : list) {
                    if (!((Date)item.getValue()).equals(v.primitiveValue())) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    this.rule(errors, ValidationMessage.IssueType.STRUCTURE, v.line(), v.col(), stack.getLiteralPath(), found, "The date " + v.primitiveValue() + " is not a valid option", new Object[0]);
                }
            }
        } else {
            this.hint(errors, ValidationMessage.IssueType.STRUCTURE, v.line(), v.col(), stack.getLiteralPath(), false, "Cannot validate date answer option because no option list is provided");
        }
    }

    private void checkTimeOption(List<ValidationMessage> errors, org.hl7.fhir.dstu2016may.metamodel.Element answer, NodeStack stack, Questionnaire qSrc, Questionnaire.QuestionnaireItemComponent qItem, boolean openChoice) {
        org.hl7.fhir.dstu2016may.metamodel.Element v = answer.getNamedChild("valueTime");
        NodeStack ns = stack.push(v, -1, null, null);
        if (qItem.getOption().size() > 0) {
            ArrayList<TimeType> list = new ArrayList<TimeType>();
            for (Questionnaire.QuestionnaireItemOptionComponent components : qItem.getOption()) {
                try {
                    list.add(components.getValueTimeType());
                }
                catch (FHIRException fHIRException) {}
            }
            if (list.isEmpty() && !openChoice) {
                this.rule(errors, ValidationMessage.IssueType.STRUCTURE, v.line(), v.col(), stack.getLiteralPath(), false, "Option list has no option values of type time", new Object[0]);
            } else {
                boolean found = false;
                for (TimeType item : list) {
                    if (!((String)item.getValue()).equals(v.primitiveValue())) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    this.rule(errors, ValidationMessage.IssueType.STRUCTURE, v.line(), v.col(), stack.getLiteralPath(), found, "The time " + v.primitiveValue() + " is not a valid option", new Object[0]);
                }
            }
        } else {
            this.hint(errors, ValidationMessage.IssueType.STRUCTURE, v.line(), v.col(), stack.getLiteralPath(), false, "Cannot validate time answer option because no option list is provided");
        }
    }

    private void checkStringOption(List<ValidationMessage> errors, org.hl7.fhir.dstu2016may.metamodel.Element answer, NodeStack stack, Questionnaire qSrc, Questionnaire.QuestionnaireItemComponent qItem, boolean openChoice) {
        org.hl7.fhir.dstu2016may.metamodel.Element v = answer.getNamedChild("valueString");
        NodeStack ns = stack.push(v, -1, null, null);
        if (qItem.getOption().size() > 0) {
            ArrayList<StringType> list = new ArrayList<StringType>();
            for (Questionnaire.QuestionnaireItemOptionComponent components : qItem.getOption()) {
                try {
                    if (components.getValue() == null) continue;
                    list.add(components.getValueStringType());
                }
                catch (FHIRException fHIRException) {}
            }
            if (list.isEmpty() && !openChoice) {
                this.rule(errors, ValidationMessage.IssueType.STRUCTURE, v.line(), v.col(), stack.getLiteralPath(), false, "Option list has no option values of type string", new Object[0]);
            } else {
                boolean found = false;
                for (StringType item : list) {
                    if (!((String)item.getValue()).equals(v.primitiveValue())) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    this.rule(errors, ValidationMessage.IssueType.STRUCTURE, v.line(), v.col(), stack.getLiteralPath(), found, "The string " + v.primitiveValue() + " is not a valid option", new Object[0]);
                }
            }
        } else {
            this.hint(errors, ValidationMessage.IssueType.STRUCTURE, v.line(), v.col(), stack.getLiteralPath(), false, "Cannot validate string answer option because no option list is provided");
        }
    }

    private void checkCodingOption(List<ValidationMessage> errors, org.hl7.fhir.dstu2016may.metamodel.Element answer, NodeStack stack, Questionnaire qSrc, Questionnaire.QuestionnaireItemComponent qItem, boolean openChoice) {
        org.hl7.fhir.dstu2016may.metamodel.Element v = answer.getNamedChild("valueCoding");
        String system = v.getNamedChildValue("system");
        String code = v.getNamedChildValue("code");
        NodeStack ns = stack.push(v, -1, null, null);
        if (qItem.getOption().size() > 0) {
            ArrayList<Coding> list = new ArrayList<Coding>();
            for (Questionnaire.QuestionnaireItemOptionComponent components : qItem.getOption()) {
                try {
                    if (components.getValue() == null) continue;
                    list.add(components.getValueCoding());
                }
                catch (FHIRException fHIRException) {}
            }
            if (list.isEmpty() && !openChoice) {
                this.rule(errors, ValidationMessage.IssueType.STRUCTURE, v.line(), v.col(), stack.getLiteralPath(), false, "Option list has no option values of type coding", new Object[0]);
            } else {
                boolean found = false;
                for (Coding item : list) {
                    if (!ObjectUtil.equals((Object)item.getSystem(), (Object)system) || !ObjectUtil.equals((Object)item.getCode(), (Object)code)) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    this.rule(errors, ValidationMessage.IssueType.STRUCTURE, v.line(), v.col(), stack.getLiteralPath(), found, "The code " + system + "::" + code + " is not a valid option", new Object[0]);
                }
            }
        } else {
            this.hint(errors, ValidationMessage.IssueType.STRUCTURE, v.line(), v.col(), stack.getLiteralPath(), false, "Cannot validate Coding option because no option list is provided");
        }
    }

    private String tail(String path) {
        return path.substring(path.lastIndexOf(".") + 1);
    }

    private String tryParse(String ref) {
        String[] parts = ref.split("\\/");
        switch (parts.length) {
            case 1: {
                return null;
            }
            case 2: {
                return this.checkResourceType(parts[0]);
            }
        }
        if (parts[parts.length - 2].equals("_history")) {
            return this.checkResourceType(parts[parts.length - 4]);
        }
        return this.checkResourceType(parts[parts.length - 2]);
    }

    private boolean typesAreAllReference(List<ElementDefinition.TypeRefComponent> theType) {
        for (ElementDefinition.TypeRefComponent typeRefComponent : theType) {
            if (typeRefComponent.getCode().equals("Reference")) continue;
            return false;
        }
        return true;
    }

    private void validateBundle(List<ValidationMessage> errors, org.hl7.fhir.dstu2016may.metamodel.Element bundle, NodeStack stack) {
        ArrayList<org.hl7.fhir.dstu2016may.metamodel.Element> entries = new ArrayList<org.hl7.fhir.dstu2016may.metamodel.Element>();
        bundle.getNamedChildren("entry", entries);
        String type = bundle.getNamedChildValue("type");
        if (entries.size() == 0) {
            this.rule(errors, ValidationMessage.IssueType.INVALID, stack.getLiteralPath(), !type.equals("document") && !type.equals("message"), "Documents or Messages must contain at least one entry");
        } else {
            org.hl7.fhir.dstu2016may.metamodel.Element firstEntry = (org.hl7.fhir.dstu2016may.metamodel.Element)entries.get(0);
            NodeStack firstStack = stack.push(firstEntry, 0, null, null);
            String fullUrl = firstEntry.getNamedChildValue("fullUrl");
            if (type.equals("document")) {
                org.hl7.fhir.dstu2016may.metamodel.Element resource = firstEntry.getNamedChild("resource");
                NodeStack localStack = firstStack.push(resource, -1, null, null);
                String id = resource.getNamedChildValue("id");
                if (this.rule(errors, ValidationMessage.IssueType.INVALID, firstEntry.line(), firstEntry.col(), stack.addToLiteralPath("entry", ":0"), resource != null, "No resource on first entry", new Object[0])) {
                    this.validateDocument(errors, entries, resource, localStack.push(resource, -1, null, null), fullUrl, id);
                }
            }
            if (type.equals("message")) {
                this.validateMessage(errors, bundle);
            }
        }
    }

    private void validateBundleReference(List<ValidationMessage> errors, List<org.hl7.fhir.dstu2016may.metamodel.Element> entries, org.hl7.fhir.dstu2016may.metamodel.Element ref, String name, NodeStack stack, String fullUrl, String type, String id) {
        if (ref != null && !Utilities.noString((String)ref.getNamedChildValue("reference"))) {
            org.hl7.fhir.dstu2016may.metamodel.Element target = this.resolveInBundle(entries, ref.getNamedChildValue("reference"), fullUrl, type, id);
            this.rule(errors, ValidationMessage.IssueType.INVALID, target.line(), target.col(), stack.addToLiteralPath("reference"), target != null, "Unable to resolve the target of the reference in the bundle (" + name + ")", new Object[0]);
        }
    }

    private void validateContains(List<ValidationMessage> errors, String path, ElementDefinition child, ElementDefinition context, org.hl7.fhir.dstu2016may.metamodel.Element resource, org.hl7.fhir.dstu2016may.metamodel.Element element, NodeStack stack, IResourceValidator.IdStatus idstatus) throws FHIRException, FHIRException {
        String resourceName = element.getType();
        long t = System.nanoTime();
        StructureDefinition profile = this.context.fetchResource(StructureDefinition.class, "http://hl7.org/fhir/StructureDefinition/" + resourceName);
        this.sdTime += System.nanoTime() - t;
        if (element.getSpecial() == Element.SpecialElement.BUNDLE_ENTRY) {
            resource = element;
        }
        if (this.rule(errors, ValidationMessage.IssueType.INVALID, element.line(), element.col(), stack.getLiteralPath(), profile != null, "No profile found for contained resource of type '" + resourceName + "'", new Object[0])) {
            this.validateResource(errors, resource, element, profile, idstatus, stack);
        }
    }

    private void validateDocument(List<ValidationMessage> errors, List<org.hl7.fhir.dstu2016may.metamodel.Element> entries, org.hl7.fhir.dstu2016may.metamodel.Element composition, NodeStack stack, String fullUrl, String id) {
        if (this.rule(errors, ValidationMessage.IssueType.INVALID, composition.line(), composition.col(), stack.getLiteralPath(), composition.getType().equals("Composition"), "The first entry in a document must be a composition", new Object[0])) {
            org.hl7.fhir.dstu2016may.metamodel.Element elem = composition.getNamedChild("subject");
            if (this.rule(errors, ValidationMessage.IssueType.INVALID, composition.line(), composition.col(), stack.getLiteralPath(), elem != null, "A document composition must have a subject", new Object[0])) {
                this.validateBundleReference(errors, entries, elem, "Composition Subject", stack.push(elem, -1, null, null), fullUrl, "Composition", id);
            }
            this.validateSections(errors, entries, composition, stack, fullUrl, id);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void validateElement(List<ValidationMessage> errors, StructureDefinition profile, ElementDefinition definition, StructureDefinition cprofile, ElementDefinition context, org.hl7.fhir.dstu2016may.metamodel.Element resource, org.hl7.fhir.dstu2016may.metamodel.Element element, String actualType, NodeStack stack, boolean inCodeableConcept) throws FHIRException, FHIRException {
        this.checkInvariants(errors, stack.getLiteralPath(), profile, definition, null, null, resource, element);
        List<ElementDefinition> childDefinitions = ProfileUtilities.getChildMap(profile, definition.getName(), definition.getPath(), definition.getContentReference());
        ArrayList<ElementInfo> children = new ArrayList<ElementInfo>();
        ChildIterator iter = new ChildIterator(stack.getLiteralPath(), element);
        while (iter.next()) {
            children.add(new ElementInfo(iter.name(), iter.element(), iter.path(), iter.count()));
        }
        ElementDefinition slice = null;
        for (int i = 0; i < childDefinitions.size(); ++i) {
            ElementDefinition ed = childDefinitions.get(i);
            boolean process = true;
            if (ed.hasSlicing()) {
                if (slice != null && slice.getPath().equals(ed.getPath())) {
                    throw new DefinitionException("Slice encountered midway through path on " + slice.getPath());
                }
                slice = ed;
                process = false;
            } else if (slice != null && !slice.getPath().equals(ed.getPath())) {
                slice = null;
            }
            if (!process) continue;
            for (ElementInfo elementInfo : children) {
                boolean match = false;
                if (slice == null) {
                    match = this.nameMatches(elementInfo.name, this.tail(ed.getPath()));
                } else if (this.nameMatches(elementInfo.name, this.tail(ed.getPath()))) {
                    match = this.sliceMatches(elementInfo.element, elementInfo.path, slice, ed, profile);
                }
                if (!match || !this.rule(errors, ValidationMessage.IssueType.INVALID, elementInfo.line(), elementInfo.col(), elementInfo.path, elementInfo.definition == null, "Element matches more than one slice", new Object[0])) continue;
                elementInfo.definition = ed;
                elementInfo.index = i;
            }
        }
        int last = -1;
        for (ElementInfo ei : children) {
            if (ei.path.endsWith(".extension")) {
                this.rule(errors, ValidationMessage.IssueType.INVALID, ei.line(), ei.col(), ei.path, ei.definition != null, "Element is unknown or does not match any slice (url=\"" + ei.element.getNamedChildValue("url") + "\")", new Object[0]);
            } else {
                this.rule(errors, ValidationMessage.IssueType.INVALID, ei.line(), ei.col(), ei.path, ei.definition != null, "Element is unknown or does not match any slice", new Object[0]);
            }
            this.rule(errors, ValidationMessage.IssueType.INVALID, ei.line(), ei.col(), ei.path, ei.definition == null || ei.index >= last, "Element is out of order", new Object[0]);
            last = ei.index;
        }
        for (ElementDefinition ed : childDefinitions) {
            if (!ed.getRepresentation().isEmpty()) continue;
            int count = 0;
            for (ElementInfo ei : children) {
                if (ei.definition != ed) continue;
                ++count;
            }
            if (ed.getMin() > 0) {
                this.rule(errors, ValidationMessage.IssueType.STRUCTURE, element.line(), element.col(), stack.getLiteralPath(), count >= ed.getMin(), "Element '" + stack.getLiteralPath() + "." + this.tail(ed.getPath()) + "': minimum required = " + Integer.toString(ed.getMin()) + ", but only found " + Integer.toString(count), new Object[0]);
            }
            if (!ed.hasMax() || ed.getMax().equals("*")) continue;
            this.rule(errors, ValidationMessage.IssueType.STRUCTURE, element.line(), element.col(), stack.getLiteralPath(), count <= Integer.parseInt(ed.getMax()), "Element " + this.tail(ed.getPath()) + " @ " + stack.getLiteralPath() + ": max allowed = " + ed.getMax() + ", but found " + Integer.toString(count), new Object[0]);
        }
        for (ElementInfo ei : children) {
            void var19_31;
            String prefix;
            if (ei.definition == null) continue;
            String type = null;
            Object var19_29 = null;
            if (!(ei.definition.getType().size() != 1 || ei.definition.getType().get(0).getCode().equals("*") || ei.definition.getType().get(0).getCode().equals("Element") || ei.definition.getType().get(0).getCode().equals("BackboneElement"))) {
                type = ei.definition.getType().get(0).getCode();
            } else if (ei.definition.getType().size() == 1 && ei.definition.getType().get(0).getCode().equals("*")) {
                prefix = this.tail(ei.definition.getPath());
                assert (prefix.endsWith("[x]"));
                type = ei.name.substring(prefix.length() - 3);
                if (this.isPrimitiveType(type)) {
                    type = Utilities.uncapitalize((String)type);
                }
            } else if (ei.definition.getType().size() > 1) {
                prefix = this.tail(ei.definition.getPath());
                assert (this.typesAreAllReference(ei.definition.getType()) || prefix.endsWith("[x]")) : prefix;
                prefix = prefix.substring(0, prefix.length() - 3);
                for (ElementDefinition.TypeRefComponent t : ei.definition.getType()) {
                    if (!(prefix + Utilities.capitalize((String)t.getCode())).equals(ei.name)) continue;
                    type = t.getCode();
                }
                if (type == null) {
                    ElementDefinition.TypeRefComponent trc = ei.definition.getType().get(0);
                    if (trc.getCode().equals("Reference")) {
                        type = "Reference";
                    } else {
                        this.rule(errors, ValidationMessage.IssueType.STRUCTURE, ei.line(), ei.col(), stack.getLiteralPath(), false, "The element " + ei.name + " is illegal. Valid types at this point are " + this.describeTypes(ei.definition.getType()), new Object[0]);
                    }
                }
            } else if (ei.definition.getContentReference() != null) {
                ElementDefinition elementDefinition = this.resolveNameReference(profile.getSnapshot(), ei.definition.getContentReference());
            }
            if (type != null && type.startsWith("@")) {
                ei.definition = this.findElement(profile, type.substring(1));
                type = null;
            }
            NodeStack localStack = stack.push(ei.element, ei.count, ei.definition, (ElementDefinition)(type == null ? var19_31 : this.resolveType(type)));
            String localStackLiterapPath = localStack.getLiteralPath();
            String eiPath = ei.path;
            assert (eiPath.equals(localStackLiterapPath)) : "ei.path: " + ElementInfo.access$700(ei) + "  -  localStack.getLiteralPath: " + localStackLiterapPath;
            boolean thisIsCodeableConcept = false;
            if (type != null) {
                if (this.isPrimitiveType(type)) {
                    this.checkPrimitive(errors, ei.path, type, ei.definition, ei.element, profile);
                    continue;
                }
                if (type.equals("Identifier")) {
                    this.checkIdentifier(errors, ei.path, ei.element, ei.definition);
                } else if (type.equals("Coding")) {
                    this.checkCoding(errors, ei.path, ei.element, profile, ei.definition, inCodeableConcept);
                } else if (type.equals("CodeableConcept")) {
                    this.checkCodeableConcept(errors, ei.path, ei.element, profile, ei.definition);
                    thisIsCodeableConcept = true;
                } else if (type.equals("Reference")) {
                    this.checkReference(errors, ei.path, ei.element, profile, ei.definition, actualType, localStack);
                }
                if (type.equals("Extension")) {
                    this.checkExtension(errors, ei.path, ei.element, ei.definition, profile, localStack);
                    continue;
                }
                if (type.equals("Resource")) {
                    this.validateContains(errors, ei.path, ei.definition, definition, resource, ei.element, localStack, this.idStatusForEntry(element, ei));
                    continue;
                }
                StructureDefinition p = this.getProfileForType(type);
                if (!this.rule(errors, ValidationMessage.IssueType.STRUCTURE, ei.line(), ei.col(), ei.path, p != null, "Unknown type " + type, new Object[0])) continue;
                this.validateElement(errors, p, p.getSnapshot().getElement().get(0), profile, ei.definition, resource, ei.element, type, localStack, thisIsCodeableConcept);
                continue;
            }
            if (!this.rule(errors, ValidationMessage.IssueType.STRUCTURE, ei.line(), ei.col(), stack.getLiteralPath(), ei.definition != null, "Unrecognised Content " + ei.name, new Object[0])) continue;
            this.validateElement(errors, profile, ei.definition, null, null, resource, ei.element, type, localStack, false);
        }
    }

    private IResourceValidator.IdStatus idStatusForEntry(org.hl7.fhir.dstu2016may.metamodel.Element ep, ElementInfo ei) {
        if (this.isBundleEntry(ei.path)) {
            org.hl7.fhir.dstu2016may.metamodel.Element req = ep.getNamedChild("request");
            org.hl7.fhir.dstu2016may.metamodel.Element resp = ep.getNamedChild("response");
            org.hl7.fhir.dstu2016may.metamodel.Element fullUrl = ep.getNamedChild("fullUrl");
            org.hl7.fhir.dstu2016may.metamodel.Element method = null;
            org.hl7.fhir.dstu2016may.metamodel.Element url = null;
            if (req != null) {
                method = req.getNamedChild("method");
                url = req.getNamedChild("url");
            }
            if (resp != null) {
                return IResourceValidator.IdStatus.OPTIONAL;
            }
            if (method == null) {
                if (fullUrl == null) {
                    return IResourceValidator.IdStatus.REQUIRED;
                }
                if (fullUrl.primitiveValue().startsWith("urn:uuid:")) {
                    return IResourceValidator.IdStatus.OPTIONAL;
                }
                return IResourceValidator.IdStatus.REQUIRED;
            }
            String s = method.primitiveValue();
            if (s.equals("PUT")) {
                if (url == null) {
                    return IResourceValidator.IdStatus.REQUIRED;
                }
                return IResourceValidator.IdStatus.OPTIONAL;
            }
            if (s.equals("POST")) {
                return IResourceValidator.IdStatus.OPTIONAL;
            }
            return IResourceValidator.IdStatus.OPTIONAL;
        }
        if (this.isParametersEntry(ei.path)) {
            return IResourceValidator.IdStatus.OPTIONAL;
        }
        return IResourceValidator.IdStatus.REQUIRED;
    }

    private void checkInvariants(List<ValidationMessage> errors, String path, StructureDefinition profile, ElementDefinition ed, String typename, String typeProfile, org.hl7.fhir.dstu2016may.metamodel.Element resource, org.hl7.fhir.dstu2016may.metamodel.Element element) throws FHIRException, FHIRException {
        for (ElementDefinition.ElementDefinitionConstraintComponent inv : ed.getConstraint()) {
            String msg;
            boolean ok;
            if (!inv.hasExpression()) continue;
            ExpressionNode n = (ExpressionNode)inv.getUserData("validator.expression.cache");
            if (n == null) {
                long t = System.nanoTime();
                n = this.fpe.parse(inv.getExpression());
                this.fpeTime += System.nanoTime() - t;
                inv.setUserData("validator.expression.cache", n);
            }
            try {
                long t = System.nanoTime();
                ok = this.fpe.evaluateToBoolean(resource, (Base)element, n);
                this.fpeTime += System.nanoTime() - t;
                msg = this.fpe.forLog();
            }
            catch (Exception ex) {
                ok = false;
                msg = ex.getMessage();
            }
            if (ok) continue;
            if (inv.getSeverity() == ElementDefinition.ConstraintSeverity.ERROR) {
                this.rule(errors, ValidationMessage.IssueType.INVARIANT, element.line(), element.col(), path, ok, inv.getHuman() + " (" + msg + ") [" + inv.getExpression() + "]", new Object[0]);
                continue;
            }
            if (inv.getSeverity() != ElementDefinition.ConstraintSeverity.WARNING) continue;
            this.warning(errors, ValidationMessage.IssueType.INVARIANT, element.line(), element.line(), path, ok, inv.getHuman() + " (" + msg + ") [" + inv.getExpression() + "]", new Object[0]);
        }
    }

    private void validateMessage(List<ValidationMessage> errors, org.hl7.fhir.dstu2016may.metamodel.Element bundle) {
    }

    private void validateObservation(List<ValidationMessage> errors, org.hl7.fhir.dstu2016may.metamodel.Element element, NodeStack stack) {
        this.bpCheck(errors, ValidationMessage.IssueType.INVALID, element.line(), element.col(), stack.getLiteralPath(), element.getNamedChild("subject") != null, "All observations should have a subject");
        this.bpCheck(errors, ValidationMessage.IssueType.INVALID, element.line(), element.col(), stack.getLiteralPath(), element.getNamedChild("performer") != null, "All observations should have a performer");
        this.bpCheck(errors, ValidationMessage.IssueType.INVALID, element.line(), element.col(), stack.getLiteralPath(), element.getNamedChild("effectiveDateTime") != null || element.getNamedChild("effectivePeriod") != null, "All observations should have an effectiveDateTime or an effectivePeriod");
    }

    private void validateResource(List<ValidationMessage> errors, org.hl7.fhir.dstu2016may.metamodel.Element resource, org.hl7.fhir.dstu2016may.metamodel.Element element, StructureDefinition profile, IResourceValidator.IdStatus idstatus, NodeStack stack) throws FHIRException, FHIRException {
        assert (stack != null);
        assert (resource != null);
        boolean ok = true;
        if (ok) {
            String resourceName = element.getType();
            if (profile == null) {
                long t = System.nanoTime();
                profile = this.context.fetchResource(StructureDefinition.class, "http://hl7.org/fhir/StructureDefinition/" + resourceName);
                this.sdTime += System.nanoTime() - t;
                ok = this.rule(errors, ValidationMessage.IssueType.INVALID, element.line(), element.col(), stack.addToLiteralPath(resourceName), profile != null, "No profile found for resource type '" + resourceName + "'", new Object[0]);
            } else {
                org.hl7.fhir.dstu2016may.metamodel.Element first;
                String type;
                String string = profile.getKind() == StructureDefinition.StructureDefinitionKind.LOGICAL ? profile.getId() : (type = profile.hasBaseType() && profile.getDerivation() == StructureDefinition.TypeDerivationRule.CONSTRAINT ? profile.getBaseType() : profile.getName());
                if (!type.equals(resourceName) && resourceName.equals("Bundle") && (first = this.getFirstEntry(element)) != null && first.getType().equals(type)) {
                    element = first;
                    resourceName = element.getType();
                    idstatus = IResourceValidator.IdStatus.OPTIONAL;
                }
                ok = this.rule(errors, ValidationMessage.IssueType.INVALID, -1, -1, stack.getLiteralPath(), type.equals(resourceName), "Specified profile type was '" + type + "', but found type '" + resourceName + "'", new Object[0]);
            }
        }
        if (ok) {
            if (idstatus == IResourceValidator.IdStatus.REQUIRED && element.getNamedChild("id") == null) {
                this.rule(errors, ValidationMessage.IssueType.INVALID, element.line(), element.col(), stack.getLiteralPath(), false, "Resource requires an id, but none is present", new Object[0]);
            } else if (idstatus == IResourceValidator.IdStatus.PROHIBITED && element.getNamedChild("id") != null) {
                this.rule(errors, ValidationMessage.IssueType.INVALID, element.line(), element.col(), stack.getLiteralPath(), false, "Resource has an id, but none is allowed", new Object[0]);
            }
            this.start(errors, resource, element, profile, stack);
        }
    }

    private org.hl7.fhir.dstu2016may.metamodel.Element getFirstEntry(org.hl7.fhir.dstu2016may.metamodel.Element bundle) {
        ArrayList<org.hl7.fhir.dstu2016may.metamodel.Element> list = new ArrayList<org.hl7.fhir.dstu2016may.metamodel.Element>();
        bundle.getNamedChildren("entry", list);
        if (list.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu2016may.metamodel.Element resource = ((org.hl7.fhir.dstu2016may.metamodel.Element)list.get(0)).getNamedChild("resource");
        if (resource == null) {
            return null;
        }
        return resource;
    }

    private void validateSections(List<ValidationMessage> errors, List<org.hl7.fhir.dstu2016may.metamodel.Element> entries, org.hl7.fhir.dstu2016may.metamodel.Element focus, NodeStack stack, String fullUrl, String id) {
        ArrayList<org.hl7.fhir.dstu2016may.metamodel.Element> sections = new ArrayList<org.hl7.fhir.dstu2016may.metamodel.Element>();
        focus.getNamedChildren("entry", sections);
        int i = 0;
        for (org.hl7.fhir.dstu2016may.metamodel.Element section : sections) {
            NodeStack localStack = stack.push(section, 1, null, null);
            this.validateBundleReference(errors, entries, section.getNamedChild("content"), "Section Content", localStack, fullUrl, "Composition", id);
            this.validateSections(errors, entries, section, localStack, fullUrl, id);
            ++i;
        }
    }

    private boolean valueMatchesCriteria(org.hl7.fhir.dstu2016may.metamodel.Element value, ElementDefinition criteria) {
        return false;
    }

    private boolean yearIsValid(String v) {
        if (v == null) {
            return false;
        }
        try {
            int i = Integer.parseInt(v.substring(0, Math.min(4, v.length())));
            return i >= 1800 && i <= 2100;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private void checkForProcessingInstruction(List<ValidationMessage> errors, Document document) {
        for (Node node = document.getFirstChild(); node != null; node = node.getNextSibling()) {
            this.rule(errors, ValidationMessage.IssueType.INVALID, -1, -1, "(document)", node.getNodeType() != 7, "No processing instructions allowed in resources", new Object[0]);
        }
    }

    public String reportTimes() {
        String s = String.format("Times: overall = %d, tx = %d, sd = %d, load = %d, fpe = %d", this.overall, this.txTime, this.sdTime, this.loadTime, this.fpeTime);
        this.overall = 0L;
        this.txTime = 0L;
        this.sdTime = 0L;
        this.loadTime = 0L;
        this.fpeTime = 0L;
        return s;
    }

    public class ElementInfo {
        public int index;
        public int count;
        public ElementDefinition definition;
        private org.hl7.fhir.dstu2016may.metamodel.Element element;
        private String name;
        private String path;

        public ElementInfo(String name, org.hl7.fhir.dstu2016may.metamodel.Element element, String path, int count) {
            this.name = name;
            this.element = element;
            this.path = path;
            this.count = count;
        }

        public int col() {
            return this.element.col();
        }

        public int line() {
            return this.element.line();
        }
    }

    private class NodeStack {
        private ElementDefinition definition;
        private org.hl7.fhir.dstu2016may.metamodel.Element element;
        private ElementDefinition extension;
        private String literalPath;
        private List<String> logicalPaths;
        private NodeStack parent;
        private ElementDefinition type;

        public NodeStack() {
        }

        public NodeStack(org.hl7.fhir.dstu2016may.metamodel.Element element) {
            this.element = element;
            this.literalPath = element.getName();
        }

        public String addToLiteralPath(String ... path) {
            StringBuilder b = new StringBuilder();
            b.append(this.getLiteralPath());
            for (String p : path) {
                if (p.startsWith(":")) {
                    b.append("[");
                    b.append(p.substring(1));
                    b.append("]");
                    continue;
                }
                b.append(".");
                b.append(p);
            }
            return b.toString();
        }

        private ElementDefinition getDefinition() {
            return this.definition;
        }

        private org.hl7.fhir.dstu2016may.metamodel.Element getElement() {
            return this.element;
        }

        private String getLiteralPath() {
            return this.literalPath == null ? "" : this.literalPath;
        }

        private List<String> getLogicalPaths() {
            return this.logicalPaths == null ? new ArrayList() : this.logicalPaths;
        }

        private ElementDefinition getType() {
            return this.type;
        }

        private NodeStack push(org.hl7.fhir.dstu2016may.metamodel.Element element, int count, ElementDefinition definition, ElementDefinition type) {
            NodeStack res = new NodeStack();
            res.parent = this;
            res.element = element;
            res.definition = definition;
            res.literalPath = this.getLiteralPath() + "." + element.getName();
            if (count > -1) {
                res.literalPath = res.literalPath + "[" + Integer.toString(count) + "]";
            }
            res.logicalPaths = new ArrayList<String>();
            if (type != null) {
                res.type = type;
                String t = InstanceValidator.this.tail(definition.getPath());
                for (String lp : this.getLogicalPaths()) {
                    res.logicalPaths.add(lp + "." + t);
                    if (!t.endsWith("[x]")) continue;
                    res.logicalPaths.add(lp + "." + t.substring(0, t.length() - 3) + type.getPath());
                }
                res.logicalPaths.add(type.getPath());
            } else if (definition != null) {
                for (String lp : this.getLogicalPaths()) {
                    res.logicalPaths.add(lp + "." + element.getName());
                }
            } else {
                res.logicalPaths.addAll(this.getLogicalPaths());
            }
            return res;
        }

        private void setType(ElementDefinition type) {
            this.type = type;
        }
    }

    public class ChildIterator {
        private String basePath;
        private org.hl7.fhir.dstu2016may.metamodel.Element parent;
        private int cursor;
        private int lastCount;

        public ChildIterator(String path, org.hl7.fhir.dstu2016may.metamodel.Element element) {
            this.parent = element;
            this.basePath = path;
            this.cursor = -1;
        }

        public int count() {
            String na;
            String nb = this.cursor == 0 ? "--" : this.parent.getChildren().get(this.cursor - 1).getName();
            String string = na = this.cursor >= this.parent.getChildren().size() - 1 ? "--" : this.parent.getChildren().get(this.cursor + 1).getName();
            if (this.name().equals(nb) || this.name().equals(na)) {
                return this.lastCount + 1;
            }
            return -1;
        }

        public org.hl7.fhir.dstu2016may.metamodel.Element element() {
            return this.parent.getChildren().get(this.cursor);
        }

        public String name() {
            return this.element().getName();
        }

        public boolean next() {
            if (this.cursor == -1) {
                ++this.cursor;
                this.lastCount = 0;
            } else {
                String lastName = this.name();
                ++this.cursor;
                this.lastCount = this.cursor < this.parent.getChildren().size() && this.name().equals(lastName) ? ++this.lastCount : 0;
            }
            return this.cursor < this.parent.getChildren().size();
        }

        public String path() {
            int i = this.count();
            String sfx = "";
            if (i > -1) {
                sfx = "[" + Integer.toString(this.lastCount + 1) + "]";
            }
            return this.basePath + "." + this.name() + sfx;
        }
    }
}

