/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu2.valueset;

import ca.uhn.fhir.model.api.IValueSetEnumBinder;
import java.util.HashMap;
import java.util.Map;

public enum SignatureTypeCodesEnum {
    AUTHORID("1.2.840.10065.1.12.1.1", "http://hl7.org/fhir/valueset-signature-type"),
    CO_AUTHORID("1.2.840.10065.1.12.1.2", "http://hl7.org/fhir/valueset-signature-type"),
    CO_PARTICIPATED("1.2.840.10065.1.12.1.3", "http://hl7.org/fhir/valueset-signature-type"),
    TRANSCRIPTIONIST("1.2.840.10065.1.12.1.4", "http://hl7.org/fhir/valueset-signature-type"),
    VERIFICATION("1.2.840.10065.1.12.1.5", "http://hl7.org/fhir/valueset-signature-type"),
    VALIDATION("1.2.840.10065.1.12.1.6", "http://hl7.org/fhir/valueset-signature-type"),
    CONSENT("1.2.840.10065.1.12.1.7", "http://hl7.org/fhir/valueset-signature-type"),
    WITNESS("1.2.840.10065.1.12.1.8", "http://hl7.org/fhir/valueset-signature-type"),
    EVENT_WITNESS("1.2.840.10065.1.12.1.9", "http://hl7.org/fhir/valueset-signature-type"),
    IDENTITY_WITNESS("1.2.840.10065.1.12.1.10", "http://hl7.org/fhir/valueset-signature-type"),
    CONSENT_WITNESS("1.2.840.10065.1.12.1.11", "http://hl7.org/fhir/valueset-signature-type"),
    INTERPRETER("1.2.840.10065.1.12.1.12", "http://hl7.org/fhir/valueset-signature-type"),
    REVIEW("1.2.840.10065.1.12.1.13", "http://hl7.org/fhir/valueset-signature-type"),
    SOURCE("1.2.840.10065.1.12.1.14", "http://hl7.org/fhir/valueset-signature-type"),
    ADDENDUM("1.2.840.10065.1.12.1.15", "http://hl7.org/fhir/valueset-signature-type"),
    ADMINISTRATIVE("1.2.840.10065.1.12.1.16", "http://hl7.org/fhir/valueset-signature-type"),
    TIMESTAMP("1.2.840.10065.1.12.1.17", "http://hl7.org/fhir/valueset-signature-type");

    public static final String VALUESET_IDENTIFIER = "";
    public static final String VALUESET_NAME = "Signature Type Codes";
    private static Map<String, SignatureTypeCodesEnum> CODE_TO_ENUM;
    private static Map<String, Map<String, SignatureTypeCodesEnum>> SYSTEM_TO_CODE_TO_ENUM;
    private final String myCode;
    private final String mySystem;
    public static final IValueSetEnumBinder<SignatureTypeCodesEnum> VALUESET_BINDER;

    public String getCode() {
        return this.myCode;
    }

    public String getSystem() {
        return this.mySystem;
    }

    public static SignatureTypeCodesEnum forCode(String theCode) {
        SignatureTypeCodesEnum retVal = CODE_TO_ENUM.get(theCode);
        return retVal;
    }

    private SignatureTypeCodesEnum(String theCode, String theSystem) {
        this.myCode = theCode;
        this.mySystem = theSystem;
    }

    static {
        CODE_TO_ENUM = new HashMap<String, SignatureTypeCodesEnum>();
        SYSTEM_TO_CODE_TO_ENUM = new HashMap<String, Map<String, SignatureTypeCodesEnum>>();
        for (SignatureTypeCodesEnum next : SignatureTypeCodesEnum.values()) {
            CODE_TO_ENUM.put(next.getCode(), next);
            if (!SYSTEM_TO_CODE_TO_ENUM.containsKey(next.getSystem())) {
                SYSTEM_TO_CODE_TO_ENUM.put(next.getSystem(), new HashMap());
            }
            SYSTEM_TO_CODE_TO_ENUM.get(next.getSystem()).put(next.getCode(), next);
        }
        VALUESET_BINDER = new IValueSetEnumBinder<SignatureTypeCodesEnum>(){

            public String toCodeString(SignatureTypeCodesEnum theEnum) {
                return theEnum.getCode();
            }

            public String toSystemString(SignatureTypeCodesEnum theEnum) {
                return theEnum.getSystem();
            }

            public SignatureTypeCodesEnum fromCodeString(String theCodeString) {
                return (SignatureTypeCodesEnum)((Object)CODE_TO_ENUM.get(theCodeString));
            }

            public SignatureTypeCodesEnum fromCodeString(String theCodeString, String theSystemString) {
                Map map = (Map)SYSTEM_TO_CODE_TO_ENUM.get(theSystemString);
                if (map == null) {
                    return null;
                }
                return (SignatureTypeCodesEnum)((Object)map.get(theCodeString));
            }
        };
    }
}

