/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu2.resource;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.model.api.BaseIdentifiableElement;
import ca.uhn.fhir.model.api.IDatatype;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.IResourceBlock;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.TemporalPrecisionEnum;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Compartment;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.model.dstu2.composite.AttachmentDt;
import ca.uhn.fhir.model.dstu2.composite.CodeableConceptDt;
import ca.uhn.fhir.model.dstu2.composite.IdentifierDt;
import ca.uhn.fhir.model.dstu2.composite.PeriodDt;
import ca.uhn.fhir.model.dstu2.composite.QuantityDt;
import ca.uhn.fhir.model.dstu2.composite.RangeDt;
import ca.uhn.fhir.model.dstu2.composite.RatioDt;
import ca.uhn.fhir.model.dstu2.composite.ResourceReferenceDt;
import ca.uhn.fhir.model.dstu2.composite.SampledDataDt;
import ca.uhn.fhir.model.dstu2.composite.SimpleQuantityDt;
import ca.uhn.fhir.model.dstu2.resource.BaseResource;
import ca.uhn.fhir.model.dstu2.resource.Device;
import ca.uhn.fhir.model.dstu2.resource.DeviceMetric;
import ca.uhn.fhir.model.dstu2.resource.Encounter;
import ca.uhn.fhir.model.dstu2.resource.Group;
import ca.uhn.fhir.model.dstu2.resource.Location;
import ca.uhn.fhir.model.dstu2.resource.Organization;
import ca.uhn.fhir.model.dstu2.resource.Patient;
import ca.uhn.fhir.model.dstu2.resource.Practitioner;
import ca.uhn.fhir.model.dstu2.resource.QuestionnaireResponse;
import ca.uhn.fhir.model.dstu2.resource.RelatedPerson;
import ca.uhn.fhir.model.dstu2.resource.Specimen;
import ca.uhn.fhir.model.dstu2.valueset.ObservationRelationshipTypeEnum;
import ca.uhn.fhir.model.dstu2.valueset.ObservationStatusEnum;
import ca.uhn.fhir.model.primitive.BoundCodeDt;
import ca.uhn.fhir.model.primitive.CodeDt;
import ca.uhn.fhir.model.primitive.DateTimeDt;
import ca.uhn.fhir.model.primitive.InstantDt;
import ca.uhn.fhir.model.primitive.StringDt;
import ca.uhn.fhir.model.primitive.TimeDt;
import ca.uhn.fhir.rest.gclient.CompositeClientParam;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.QuantityClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@ResourceDef(name="Observation", profile="http://hl7.org/fhir/profiles/Observation", id="observation")
public class Observation
extends BaseResource
implements IResource {
    @SearchParamDefinition(name="code", path="Observation.code", description="The code of the observation type", type="token")
    public static final String SP_CODE = "code";
    public static final TokenClientParam CODE = new TokenClientParam("code");
    @SearchParamDefinition(name="component-code", path="Observation.component.code", description="The component code of the observation type", type="token")
    public static final String SP_COMPONENT_CODE = "component-code";
    public static final TokenClientParam COMPONENT_CODE = new TokenClientParam("component-code");
    @SearchParamDefinition(name="value-quantity", path="Observation.valueQuantity", description="The value of the observation, if the value is a Quantity, or a SampledData (just search on the bounds of the values in sampled data)", type="quantity")
    public static final String SP_VALUE_QUANTITY = "value-quantity";
    public static final QuantityClientParam VALUE_QUANTITY = new QuantityClientParam("value-quantity");
    @SearchParamDefinition(name="component-value-quantity", path="Observation.component.valueQuantity", description="The value of the component observation, if the value is a Quantity, or a SampledData (just search on the bounds of the values in sampled data)", type="quantity")
    public static final String SP_COMPONENT_VALUE_QUANTITY = "component-value-quantity";
    public static final QuantityClientParam COMPONENT_VALUE_QUANTITY = new QuantityClientParam("component-value-quantity");
    @SearchParamDefinition(name="value-concept", path="Observation.valueCodeableConcept", description="The value of the observation, if the value is a CodeableConcept", type="token")
    public static final String SP_VALUE_CONCEPT = "value-concept";
    public static final TokenClientParam VALUE_CONCEPT = new TokenClientParam("value-concept");
    @SearchParamDefinition(name="component-value-concept", path="Observation.component.valueCodeableConcept", description="The value of the component observation, if the value is a CodeableConcept", type="token")
    public static final String SP_COMPONENT_VALUE_CONCEPT = "component-value-concept";
    public static final TokenClientParam COMPONENT_VALUE_CONCEPT = new TokenClientParam("component-value-concept");
    @SearchParamDefinition(name="value-date", path="Observation.valueDateTime | Observation.valuePeriod", description="The value of the observation, if the value is a date or period of time", type="date")
    public static final String SP_VALUE_DATE = "value-date";
    public static final DateClientParam VALUE_DATE = new DateClientParam("value-date");
    @SearchParamDefinition(name="value-string", path="Observation.valueString", description="The value of the observation, if the value is a string, and also searches in CodeableConcept.text", type="string")
    public static final String SP_VALUE_STRING = "value-string";
    public static final StringClientParam VALUE_STRING = new StringClientParam("value-string");
    @SearchParamDefinition(name="component-value-string", path="Observation.component.valueString", description="The value of the component observation, if the value is a string, and also searches in CodeableConcept.text", type="string")
    public static final String SP_COMPONENT_VALUE_STRING = "component-value-string";
    public static final StringClientParam COMPONENT_VALUE_STRING = new StringClientParam("component-value-string");
    @SearchParamDefinition(name="date", path="Observation.effective[x]", description="Obtained date/time. If the obtained element is a period, a date that falls in the period", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="status", path="Observation.status", description="The status of the observation", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");
    @SearchParamDefinition(name="subject", path="Observation.subject", description="The subject that the observation is about", type="reference", providesMembershipIn={@Compartment(name="Patient"), @Compartment(name="Device")})
    public static final String SP_SUBJECT = "subject";
    public static final ReferenceClientParam SUBJECT = new ReferenceClientParam("subject");
    @SearchParamDefinition(name="performer", path="Observation.performer", description="Who performed the observation", type="reference", providesMembershipIn={@Compartment(name="Patient"), @Compartment(name="RelatedPerson"), @Compartment(name="Practitioner")})
    public static final String SP_PERFORMER = "performer";
    public static final ReferenceClientParam PERFORMER = new ReferenceClientParam("performer");
    @SearchParamDefinition(name="specimen", path="Observation.specimen", description="", type="reference")
    public static final String SP_SPECIMEN = "specimen";
    public static final ReferenceClientParam SPECIMEN = new ReferenceClientParam("specimen");
    @SearchParamDefinition(name="related-type", path="Observation.related.type", description="", type="token")
    public static final String SP_RELATED_TYPE = "related-type";
    public static final TokenClientParam RELATED_TYPE = new TokenClientParam("related-type");
    @SearchParamDefinition(name="related-target", path="Observation.related.target", description="", type="reference")
    public static final String SP_RELATED_TARGET = "related-target";
    public static final ReferenceClientParam RELATED_TARGET = new ReferenceClientParam("related-target");
    @SearchParamDefinition(name="encounter", path="Observation.encounter", description="Healthcare event related to the observation", type="reference", providesMembershipIn={@Compartment(name="Encounter")})
    public static final String SP_ENCOUNTER = "encounter";
    public static final ReferenceClientParam ENCOUNTER = new ReferenceClientParam("encounter");
    @SearchParamDefinition(name="data-absent-reason", path="Observation.dataAbsentReason", description="The reason why the expected value in the element Observation.value[x] is missing.", type="token")
    public static final String SP_DATA_ABSENT_REASON = "data-absent-reason";
    public static final TokenClientParam DATA_ABSENT_REASON = new TokenClientParam("data-absent-reason");
    @SearchParamDefinition(name="component-data-absent-reason", path="Observation.component.dataAbsentReason", description="The reason why the expected value in the element Observation.component.value[x] is missing.", type="token")
    public static final String SP_COMPONENT_DATA_ABSENT_REASON = "component-data-absent-reason";
    public static final TokenClientParam COMPONENT_DATA_ABSENT_REASON = new TokenClientParam("component-data-absent-reason");
    @SearchParamDefinition(name="patient", path="Observation.subject", description="The subject that the observation is about (if patient)", type="reference", target={Patient.class})
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    @SearchParamDefinition(name="identifier", path="Observation.identifier", description="The unique id for a particular observation", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="device", path="Observation.device", description="The Device that generated the observation data.", type="reference", providesMembershipIn={@Compartment(name="Device")})
    public static final String SP_DEVICE = "device";
    public static final ReferenceClientParam DEVICE = new ReferenceClientParam("device");
    @SearchParamDefinition(name="category", path="Observation.category", description="The classification of the type of observation", type="token")
    public static final String SP_CATEGORY = "category";
    public static final TokenClientParam CATEGORY = new TokenClientParam("category");
    @SearchParamDefinition(name="code-value-quantity", path="code & value[x]", description="Both code and one of the value parameters", type="composite", compositeOf={"code", "value-quantity"})
    public static final String SP_CODE_VALUE_QUANTITY = "code-value-quantity";
    public static final CompositeClientParam<TokenClientParam, QuantityClientParam> CODE_VALUE_QUANTITY = new CompositeClientParam("code-value-quantity");
    @SearchParamDefinition(name="code-value-concept", path="code & value[x]", description="Both code and one of the value parameters", type="composite", compositeOf={"code", "value-concept"})
    public static final String SP_CODE_VALUE_CONCEPT = "code-value-concept";
    public static final CompositeClientParam<TokenClientParam, TokenClientParam> CODE_VALUE_CONCEPT = new CompositeClientParam("code-value-concept");
    @SearchParamDefinition(name="code-value-date", path="code & value[x]", description="Both code and one of the value parameters", type="composite", compositeOf={"code", "value-date"})
    public static final String SP_CODE_VALUE_DATE = "code-value-date";
    public static final CompositeClientParam<TokenClientParam, DateClientParam> CODE_VALUE_DATE = new CompositeClientParam("code-value-date");
    @SearchParamDefinition(name="code-value-string", path="code & value[x]", description="Both code and one of the value parameters", type="composite", compositeOf={"code", "value-string"})
    public static final String SP_CODE_VALUE_STRING = "code-value-string";
    public static final CompositeClientParam<TokenClientParam, StringClientParam> CODE_VALUE_STRING = new CompositeClientParam("code-value-string");
    @SearchParamDefinition(name="component-code-component-value-quantity", path="component-code & component-value[x]", description="Both component code and one of the component value parameters", type="composite", compositeOf={"component-code", "component-value-quantity"})
    public static final String SP_COMPONENT_CODE_COMPONENT_VALUE_QUANTITY = "component-code-component-value-quantity";
    public static final CompositeClientParam<TokenClientParam, QuantityClientParam> COMPONENT_CODE_COMPONENT_VALUE_QUANTITY = new CompositeClientParam("component-code-component-value-quantity");
    @SearchParamDefinition(name="component-code-component-value-concept", path="component-code & component-value[x]", description="Both component code and one of the component value parameters", type="composite", compositeOf={"component-code", "component-value-concept"})
    public static final String SP_COMPONENT_CODE_COMPONENT_VALUE_CONCEPT = "component-code-component-value-concept";
    public static final CompositeClientParam<TokenClientParam, TokenClientParam> COMPONENT_CODE_COMPONENT_VALUE_CONCEPT = new CompositeClientParam("component-code-component-value-concept");
    @SearchParamDefinition(name="component-code-component-value-string", path="component-code & component-value[x]", description="Both component code and one of the component value parameters", type="composite", compositeOf={"component-code", "component-value-string"})
    public static final String SP_COMPONENT_CODE_COMPONENT_VALUE_STRING = "component-code-component-value-string";
    public static final CompositeClientParam<TokenClientParam, StringClientParam> COMPONENT_CODE_COMPONENT_VALUE_STRING = new CompositeClientParam("component-code-component-value-string");
    @SearchParamDefinition(name="related-target-related-type", path="related-target & related-type", description="Related Observations - search on related-type and related-target together", type="composite", compositeOf={"related-target", "related-type"})
    public static final String SP_RELATED_TARGET_RELATED_TYPE = "related-target-related-type";
    public static final CompositeClientParam<ReferenceClientParam, TokenClientParam> RELATED_TARGET_RELATED_TYPE = new CompositeClientParam("related-target-related-type");
    public static final Include INCLUDE_DEVICE = new Include("Observation:device");
    public static final Include INCLUDE_ENCOUNTER = new Include("Observation:encounter");
    public static final Include INCLUDE_PATIENT = new Include("Observation:patient");
    public static final Include INCLUDE_PERFORMER = new Include("Observation:performer");
    public static final Include INCLUDE_RELATED_TARGET = new Include("Observation:related-target");
    public static final Include INCLUDE_SPECIMEN = new Include("Observation:specimen");
    public static final Include INCLUDE_SUBJECT = new Include("Observation:subject");
    @Child(name="identifier", type={IdentifierDt.class}, order=0, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="id", formalDefinition="A unique identifier for the simple observation instance.")
    private List<IdentifierDt> myIdentifier;
    @Child(name="status", type={CodeDt.class}, order=1, min=1, max=1, summary=true, modifier=true)
    @Description(shortDefinition="status", formalDefinition="The status of the result value")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/observation-status")
    private BoundCodeDt<ObservationStatusEnum> myStatus;
    @Child(name="category", type={CodeableConceptDt.class}, order=2, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="class", formalDefinition="A code that classifies the general type of observation being made.  This is used  for searching, sorting and display purposes.")
    private CodeableConceptDt myCategory;
    @Child(name="code", type={CodeableConceptDt.class}, order=3, min=1, max=1, summary=true, modifier=false)
    @Description(shortDefinition="what", formalDefinition="Describes what was observed. Sometimes this is called the observation \"name\"")
    private CodeableConceptDt myCode;
    @Child(name="subject", order=4, min=0, max=1, summary=true, modifier=false, type={Patient.class, Group.class, Device.class, Location.class})
    @Description(shortDefinition="who.focus", formalDefinition="The patient, or group of patients, location, or device whose characteristics (direct or indirect) are described by the observation and into whose record the observation is placed.  Comments: Indirect characteristics may be those of a specimen, fetus, donor,  other observer (for example a relative or EMT), or any observation made about the subject.")
    private ResourceReferenceDt mySubject;
    @Child(name="encounter", order=5, min=0, max=1, summary=false, modifier=false, type={Encounter.class})
    @Description(shortDefinition="context", formalDefinition="The healthcare event  (e.g. a patient and healthcare provider interaction) during which this observation is made")
    private ResourceReferenceDt myEncounter;
    @Child(name="effective", order=6, min=0, max=1, summary=true, modifier=false, type={DateTimeDt.class, PeriodDt.class})
    @Description(shortDefinition="when.done", formalDefinition="The time or time-period the observed value is asserted as being true. For biological subjects - e.g. human patients - this is usually called the \"physiologically relevant time\". This is usually either the time of the procedure or of specimen collection, but very often the source of the date/time is not known, only the date/time itself")
    private IDatatype myEffective;
    @Child(name="issued", type={InstantDt.class}, order=7, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="when.recorded", formalDefinition="The date and time this observation was made available to providers, typically after the results have been reviewed and verified.")
    private InstantDt myIssued;
    @Child(name="performer", order=8, min=0, max=-1, summary=true, modifier=false, type={Practitioner.class, Organization.class, Patient.class, RelatedPerson.class})
    @Description(shortDefinition="who.actor", formalDefinition="Who was responsible for asserting the observed value as \"true\"")
    private List<ResourceReferenceDt> myPerformer;
    @Child(name="value", order=9, min=0, max=1, summary=true, modifier=false, type={QuantityDt.class, CodeableConceptDt.class, StringDt.class, RangeDt.class, RatioDt.class, SampledDataDt.class, AttachmentDt.class, TimeDt.class, DateTimeDt.class, PeriodDt.class})
    @Description(shortDefinition="", formalDefinition="The information determined as a result of making the observation, if the information has a simple value")
    private IDatatype myValue;
    @Child(name="dataAbsentReason", type={CodeableConceptDt.class}, order=10, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="Provides a reason why the expected value in the element Observation.value[x] is missing.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/valueset-observation-valueabsentreason")
    private CodeableConceptDt myDataAbsentReason;
    @Child(name="interpretation", type={CodeableConceptDt.class}, order=11, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="The assessment made based on the result of the observation.  Intended as a simple compact code often placed adjacent to the result value in reports and flow sheets to signal the meaning/normalcy status of the result. Otherwise known as abnormal flag.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/valueset-observation-interpretation")
    private CodeableConceptDt myInterpretation;
    @Child(name="comments", type={StringDt.class}, order=12, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="May include statements about significant, unexpected or unreliable values, or information about the source of the value where this may be relevant to the interpretation of the result.")
    private StringDt myComments;
    @Child(name="bodySite", type={CodeableConceptDt.class}, order=13, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="Indicates the site on the subject's body where the observation was made (i.e. the target site).")
    private CodeableConceptDt myBodySite;
    @Child(name="method", type={CodeableConceptDt.class}, order=14, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="Indicates the mechanism used to perform the observation")
    private CodeableConceptDt myMethod;
    @Child(name="specimen", order=15, min=0, max=1, summary=false, modifier=false, type={Specimen.class})
    @Description(shortDefinition="", formalDefinition="The specimen that was used when this observation was made")
    private ResourceReferenceDt mySpecimen;
    @Child(name="device", order=16, min=0, max=1, summary=false, modifier=false, type={Device.class, DeviceMetric.class})
    @Description(shortDefinition="", formalDefinition="The device used to generate the observation data.")
    private ResourceReferenceDt myDevice;
    @Child(name="referenceRange", order=17, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="Guidance on how to interpret the value by comparison to a normal or recommended range")
    private List<ReferenceRange> myReferenceRange;
    @Child(name="related", order=18, min=0, max=-1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="A  reference to another resource (usually another Observation but could  also be a QuestionnaireAnswer) whose relationship is defined by the relationship type code.")
    private List<Related> myRelated;
    @Child(name="component", order=19, min=0, max=-1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="Some observations have multiple component observations.  These component observations are expressed as separate code value pairs that share the same attributes.  Examples include systolic and diastolic component observations for blood pressure measurement and multiple component observations for genetics observations.")
    private List<Component> myComponent;

    public boolean isEmpty() {
        return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myIdentifier, this.myStatus, this.myCategory, this.myCode, this.mySubject, this.myEncounter, this.myEffective, this.myIssued, this.myPerformer, this.myValue, this.myDataAbsentReason, this.myInterpretation, this.myComments, this.myBodySite, this.myMethod, this.mySpecimen, this.myDevice, this.myReferenceRange, this.myRelated, this.myComponent});
    }

    public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
        return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myIdentifier, this.myStatus, this.myCategory, this.myCode, this.mySubject, this.myEncounter, this.myEffective, this.myIssued, this.myPerformer, this.myValue, this.myDataAbsentReason, this.myInterpretation, this.myComments, this.myBodySite, this.myMethod, this.mySpecimen, this.myDevice, this.myReferenceRange, this.myRelated, this.myComponent});
    }

    public List<IdentifierDt> getIdentifier() {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        return this.myIdentifier;
    }

    public Observation setIdentifier(List<IdentifierDt> theValue) {
        this.myIdentifier = theValue;
        return this;
    }

    public IdentifierDt addIdentifier() {
        IdentifierDt newType = new IdentifierDt();
        this.getIdentifier().add(newType);
        return newType;
    }

    public Observation addIdentifier(IdentifierDt theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getIdentifier().add(theValue);
        return this;
    }

    public IdentifierDt getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            return this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public BoundCodeDt<ObservationStatusEnum> getStatusElement() {
        if (this.myStatus == null) {
            this.myStatus = new BoundCodeDt(ObservationStatusEnum.VALUESET_BINDER);
        }
        return this.myStatus;
    }

    public String getStatus() {
        return (String)this.getStatusElement().getValue();
    }

    public Observation setStatus(BoundCodeDt<ObservationStatusEnum> theValue) {
        this.myStatus = theValue;
        return this;
    }

    public Observation setStatus(ObservationStatusEnum theValue) {
        this.setStatus((BoundCodeDt<ObservationStatusEnum>)new BoundCodeDt(ObservationStatusEnum.VALUESET_BINDER, (Enum)theValue));
        return this;
    }

    public CodeableConceptDt getCategory() {
        if (this.myCategory == null) {
            this.myCategory = new CodeableConceptDt();
        }
        return this.myCategory;
    }

    public Observation setCategory(CodeableConceptDt theValue) {
        this.myCategory = theValue;
        return this;
    }

    public CodeableConceptDt getCode() {
        if (this.myCode == null) {
            this.myCode = new CodeableConceptDt();
        }
        return this.myCode;
    }

    public Observation setCode(CodeableConceptDt theValue) {
        this.myCode = theValue;
        return this;
    }

    public ResourceReferenceDt getSubject() {
        if (this.mySubject == null) {
            this.mySubject = new ResourceReferenceDt();
        }
        return this.mySubject;
    }

    public Observation setSubject(ResourceReferenceDt theValue) {
        this.mySubject = theValue;
        return this;
    }

    public ResourceReferenceDt getEncounter() {
        if (this.myEncounter == null) {
            this.myEncounter = new ResourceReferenceDt();
        }
        return this.myEncounter;
    }

    public Observation setEncounter(ResourceReferenceDt theValue) {
        this.myEncounter = theValue;
        return this;
    }

    public IDatatype getEffective() {
        return this.myEffective;
    }

    public Observation setEffective(IDatatype theValue) {
        this.myEffective = theValue;
        return this;
    }

    public InstantDt getIssuedElement() {
        if (this.myIssued == null) {
            this.myIssued = new InstantDt();
        }
        return this.myIssued;
    }

    public Date getIssued() {
        return (Date)this.getIssuedElement().getValue();
    }

    public Observation setIssued(InstantDt theValue) {
        this.myIssued = theValue;
        return this;
    }

    public Observation setIssuedWithMillisPrecision(Date theDate) {
        this.myIssued = new InstantDt(theDate);
        return this;
    }

    public Observation setIssued(Date theDate, TemporalPrecisionEnum thePrecision) {
        this.myIssued = new InstantDt(theDate, thePrecision);
        return this;
    }

    public List<ResourceReferenceDt> getPerformer() {
        if (this.myPerformer == null) {
            this.myPerformer = new ArrayList<ResourceReferenceDt>();
        }
        return this.myPerformer;
    }

    public Observation setPerformer(List<ResourceReferenceDt> theValue) {
        this.myPerformer = theValue;
        return this;
    }

    public ResourceReferenceDt addPerformer() {
        ResourceReferenceDt newType = new ResourceReferenceDt();
        this.getPerformer().add(newType);
        return newType;
    }

    public IDatatype getValue() {
        return this.myValue;
    }

    public Observation setValue(IDatatype theValue) {
        this.myValue = theValue;
        return this;
    }

    public CodeableConceptDt getDataAbsentReason() {
        if (this.myDataAbsentReason == null) {
            this.myDataAbsentReason = new CodeableConceptDt();
        }
        return this.myDataAbsentReason;
    }

    public Observation setDataAbsentReason(CodeableConceptDt theValue) {
        this.myDataAbsentReason = theValue;
        return this;
    }

    public CodeableConceptDt getInterpretation() {
        if (this.myInterpretation == null) {
            this.myInterpretation = new CodeableConceptDt();
        }
        return this.myInterpretation;
    }

    public Observation setInterpretation(CodeableConceptDt theValue) {
        this.myInterpretation = theValue;
        return this;
    }

    public StringDt getCommentsElement() {
        if (this.myComments == null) {
            this.myComments = new StringDt();
        }
        return this.myComments;
    }

    public String getComments() {
        return (String)this.getCommentsElement().getValue();
    }

    public Observation setComments(StringDt theValue) {
        this.myComments = theValue;
        return this;
    }

    public Observation setComments(String theString) {
        this.myComments = new StringDt(theString);
        return this;
    }

    public CodeableConceptDt getBodySite() {
        if (this.myBodySite == null) {
            this.myBodySite = new CodeableConceptDt();
        }
        return this.myBodySite;
    }

    public Observation setBodySite(CodeableConceptDt theValue) {
        this.myBodySite = theValue;
        return this;
    }

    public CodeableConceptDt getMethod() {
        if (this.myMethod == null) {
            this.myMethod = new CodeableConceptDt();
        }
        return this.myMethod;
    }

    public Observation setMethod(CodeableConceptDt theValue) {
        this.myMethod = theValue;
        return this;
    }

    public ResourceReferenceDt getSpecimen() {
        if (this.mySpecimen == null) {
            this.mySpecimen = new ResourceReferenceDt();
        }
        return this.mySpecimen;
    }

    public Observation setSpecimen(ResourceReferenceDt theValue) {
        this.mySpecimen = theValue;
        return this;
    }

    public ResourceReferenceDt getDevice() {
        if (this.myDevice == null) {
            this.myDevice = new ResourceReferenceDt();
        }
        return this.myDevice;
    }

    public Observation setDevice(ResourceReferenceDt theValue) {
        this.myDevice = theValue;
        return this;
    }

    public List<ReferenceRange> getReferenceRange() {
        if (this.myReferenceRange == null) {
            this.myReferenceRange = new ArrayList<ReferenceRange>();
        }
        return this.myReferenceRange;
    }

    public Observation setReferenceRange(List<ReferenceRange> theValue) {
        this.myReferenceRange = theValue;
        return this;
    }

    public ReferenceRange addReferenceRange() {
        ReferenceRange newType = new ReferenceRange();
        this.getReferenceRange().add(newType);
        return newType;
    }

    public Observation addReferenceRange(ReferenceRange theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getReferenceRange().add(theValue);
        return this;
    }

    public ReferenceRange getReferenceRangeFirstRep() {
        if (this.getReferenceRange().isEmpty()) {
            return this.addReferenceRange();
        }
        return this.getReferenceRange().get(0);
    }

    public List<Related> getRelated() {
        if (this.myRelated == null) {
            this.myRelated = new ArrayList<Related>();
        }
        return this.myRelated;
    }

    public Observation setRelated(List<Related> theValue) {
        this.myRelated = theValue;
        return this;
    }

    public Related addRelated() {
        Related newType = new Related();
        this.getRelated().add(newType);
        return newType;
    }

    public Observation addRelated(Related theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getRelated().add(theValue);
        return this;
    }

    public Related getRelatedFirstRep() {
        if (this.getRelated().isEmpty()) {
            return this.addRelated();
        }
        return this.getRelated().get(0);
    }

    public List<Component> getComponent() {
        if (this.myComponent == null) {
            this.myComponent = new ArrayList<Component>();
        }
        return this.myComponent;
    }

    public Observation setComponent(List<Component> theValue) {
        this.myComponent = theValue;
        return this;
    }

    public Component addComponent() {
        Component newType = new Component();
        this.getComponent().add(newType);
        return newType;
    }

    public Observation addComponent(Component theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getComponent().add(theValue);
        return this;
    }

    public Component getComponentFirstRep() {
        if (this.getComponent().isEmpty()) {
            return this.addComponent();
        }
        return this.getComponent().get(0);
    }

    public String getResourceName() {
        return "Observation";
    }

    public FhirVersionEnum getStructureFhirVersionEnum() {
        return FhirVersionEnum.DSTU2;
    }

    @Block
    public static class Component
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="code", type={CodeableConceptDt.class}, order=0, min=1, max=1, summary=true, modifier=false)
        @Description(shortDefinition="what", formalDefinition="Describes what was observed. Sometimes this is called the observation \"code\"")
        private CodeableConceptDt myCode;
        @Child(name="value", order=1, min=0, max=1, summary=true, modifier=false, type={QuantityDt.class, CodeableConceptDt.class, StringDt.class, RangeDt.class, RatioDt.class, SampledDataDt.class, AttachmentDt.class, TimeDt.class, DateTimeDt.class, PeriodDt.class})
        @Description(shortDefinition="", formalDefinition="The information determined as a result of making the observation, if the information has a simple value")
        private IDatatype myValue;
        @Child(name="dataAbsentReason", type={CodeableConceptDt.class}, order=2, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Provides a reason why the expected value in the element Observation.value[x] is missing.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/valueset-observation-valueabsentreason")
        private CodeableConceptDt myDataAbsentReason;
        @Child(name="referenceRange", type={ReferenceRange.class}, order=3, min=0, max=-1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Guidance on how to interpret the value by comparison to a normal or recommended range")
        private List<ReferenceRange> myReferenceRange;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myCode, this.myValue, this.myDataAbsentReason, this.myReferenceRange});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myCode, this.myValue, this.myDataAbsentReason, this.myReferenceRange});
        }

        public CodeableConceptDt getCode() {
            if (this.myCode == null) {
                this.myCode = new CodeableConceptDt();
            }
            return this.myCode;
        }

        public Component setCode(CodeableConceptDt theValue) {
            this.myCode = theValue;
            return this;
        }

        public IDatatype getValue() {
            return this.myValue;
        }

        public Component setValue(IDatatype theValue) {
            this.myValue = theValue;
            return this;
        }

        public CodeableConceptDt getDataAbsentReason() {
            if (this.myDataAbsentReason == null) {
                this.myDataAbsentReason = new CodeableConceptDt();
            }
            return this.myDataAbsentReason;
        }

        public Component setDataAbsentReason(CodeableConceptDt theValue) {
            this.myDataAbsentReason = theValue;
            return this;
        }

        public List<ReferenceRange> getReferenceRange() {
            if (this.myReferenceRange == null) {
                this.myReferenceRange = new ArrayList<ReferenceRange>();
            }
            return this.myReferenceRange;
        }

        public Component setReferenceRange(List<ReferenceRange> theValue) {
            this.myReferenceRange = theValue;
            return this;
        }

        public ReferenceRange addReferenceRange() {
            ReferenceRange newType = new ReferenceRange();
            this.getReferenceRange().add(newType);
            return newType;
        }

        public Component addReferenceRange(ReferenceRange theValue) {
            if (theValue == null) {
                throw new NullPointerException("theValue must not be null");
            }
            this.getReferenceRange().add(theValue);
            return this;
        }

        public ReferenceRange getReferenceRangeFirstRep() {
            if (this.getReferenceRange().isEmpty()) {
                return this.addReferenceRange();
            }
            return this.getReferenceRange().get(0);
        }
    }

    @Block
    public static class Related
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="type", type={CodeDt.class}, order=0, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="A code specifying the kind of relationship that exists with the target resource")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/observation-relationshiptypes")
        private BoundCodeDt<ObservationRelationshipTypeEnum> myType;
        @Child(name="target", order=1, min=1, max=1, summary=false, modifier=false, type={Observation.class, QuestionnaireResponse.class})
        @Description(shortDefinition="", formalDefinition="A reference to the observation or [[[QuestionnaireResponse]]] resource that is related to this observation")
        private ResourceReferenceDt myTarget;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myType, this.myTarget});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myType, this.myTarget});
        }

        public BoundCodeDt<ObservationRelationshipTypeEnum> getTypeElement() {
            if (this.myType == null) {
                this.myType = new BoundCodeDt(ObservationRelationshipTypeEnum.VALUESET_BINDER);
            }
            return this.myType;
        }

        public String getType() {
            return (String)this.getTypeElement().getValue();
        }

        public Related setType(BoundCodeDt<ObservationRelationshipTypeEnum> theValue) {
            this.myType = theValue;
            return this;
        }

        public Related setType(ObservationRelationshipTypeEnum theValue) {
            this.setType((BoundCodeDt<ObservationRelationshipTypeEnum>)new BoundCodeDt(ObservationRelationshipTypeEnum.VALUESET_BINDER, (Enum)theValue));
            return this;
        }

        public ResourceReferenceDt getTarget() {
            if (this.myTarget == null) {
                this.myTarget = new ResourceReferenceDt();
            }
            return this.myTarget;
        }

        public Related setTarget(ResourceReferenceDt theValue) {
            this.myTarget = theValue;
            return this;
        }
    }

    @Block
    public static class ReferenceRange
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="low", type={SimpleQuantityDt.class}, order=0, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="The value of the low bound of the reference range.  The low bound of the reference range endpoint is inclusive of the value (e.g.  reference range is >=5 - <=9).   If the low bound is omitted,  it is assumed to be meaningless (e.g. reference range is <=2.3).")
        private SimpleQuantityDt myLow;
        @Child(name="high", type={SimpleQuantityDt.class}, order=1, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="The value of the high bound of the reference range.  The high bound of the reference range endpoint is inclusive of the value (e.g.  reference range is >=5 - <=9).   If the high bound is omitted,  it is assumed to be meaningless (e.g. reference range is >= 2.3).")
        private SimpleQuantityDt myHigh;
        @Child(name="meaning", type={CodeableConceptDt.class}, order=2, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Code for the meaning of the reference range")
        private CodeableConceptDt myMeaning;
        @Child(name="age", type={RangeDt.class}, order=3, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="The age at which this reference range is applicable. This is a neonatal age (e.g. number of weeks at term) if the meaning says so")
        private RangeDt myAge;
        @Child(name="text", type={StringDt.class}, order=4, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Text based reference range in an observation which may be used when a quantitative range is not appropriate for an observation.  An example would be a reference value of \"Negative\" or a list or table of 'normals'.")
        private StringDt myText;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myLow, this.myHigh, this.myMeaning, this.myAge, this.myText});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myLow, this.myHigh, this.myMeaning, this.myAge, this.myText});
        }

        public SimpleQuantityDt getLow() {
            if (this.myLow == null) {
                this.myLow = new SimpleQuantityDt();
            }
            return this.myLow;
        }

        public ReferenceRange setLow(SimpleQuantityDt theValue) {
            this.myLow = theValue;
            return this;
        }

        public SimpleQuantityDt getHigh() {
            if (this.myHigh == null) {
                this.myHigh = new SimpleQuantityDt();
            }
            return this.myHigh;
        }

        public ReferenceRange setHigh(SimpleQuantityDt theValue) {
            this.myHigh = theValue;
            return this;
        }

        public CodeableConceptDt getMeaning() {
            if (this.myMeaning == null) {
                this.myMeaning = new CodeableConceptDt();
            }
            return this.myMeaning;
        }

        public ReferenceRange setMeaning(CodeableConceptDt theValue) {
            this.myMeaning = theValue;
            return this;
        }

        public RangeDt getAge() {
            if (this.myAge == null) {
                this.myAge = new RangeDt();
            }
            return this.myAge;
        }

        public ReferenceRange setAge(RangeDt theValue) {
            this.myAge = theValue;
            return this;
        }

        public StringDt getTextElement() {
            if (this.myText == null) {
                this.myText = new StringDt();
            }
            return this.myText;
        }

        public String getText() {
            return (String)this.getTextElement().getValue();
        }

        public ReferenceRange setText(StringDt theValue) {
            this.myText = theValue;
            return this;
        }

        public ReferenceRange setText(String theString) {
            this.myText = new StringDt(theString);
            return this;
        }
    }
}

