/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu2.valueset;

import ca.uhn.fhir.model.api.IValueSetEnumBinder;
import java.util.HashMap;
import java.util.Map;

public enum ResourceTypeEnum {
    ACCOUNT("Account", "http://hl7.org/fhir/resource-types"),
    ALLERGYINTOLERANCE("AllergyIntolerance", "http://hl7.org/fhir/resource-types"),
    APPOINTMENT("Appointment", "http://hl7.org/fhir/resource-types"),
    APPOINTMENTRESPONSE("AppointmentResponse", "http://hl7.org/fhir/resource-types"),
    AUDITEVENT("AuditEvent", "http://hl7.org/fhir/resource-types"),
    BASIC("Basic", "http://hl7.org/fhir/resource-types"),
    BINARY("Binary", "http://hl7.org/fhir/resource-types"),
    BODYSITE("BodySite", "http://hl7.org/fhir/resource-types"),
    BUNDLE("Bundle", "http://hl7.org/fhir/resource-types"),
    CAREPLAN("CarePlan", "http://hl7.org/fhir/resource-types"),
    CLAIM("Claim", "http://hl7.org/fhir/resource-types"),
    CLAIMRESPONSE("ClaimResponse", "http://hl7.org/fhir/resource-types"),
    CLINICALIMPRESSION("ClinicalImpression", "http://hl7.org/fhir/resource-types"),
    COMMUNICATION("Communication", "http://hl7.org/fhir/resource-types"),
    COMMUNICATIONREQUEST("CommunicationRequest", "http://hl7.org/fhir/resource-types"),
    COMPOSITION("Composition", "http://hl7.org/fhir/resource-types"),
    CONCEPTMAP("ConceptMap", "http://hl7.org/fhir/resource-types"),
    CONDITION("Condition", "http://hl7.org/fhir/resource-types"),
    CONFORMANCE("Conformance", "http://hl7.org/fhir/resource-types"),
    CONTRACT("Contract", "http://hl7.org/fhir/resource-types"),
    COVERAGE("Coverage", "http://hl7.org/fhir/resource-types"),
    DATAELEMENT("DataElement", "http://hl7.org/fhir/resource-types"),
    DETECTEDISSUE("DetectedIssue", "http://hl7.org/fhir/resource-types"),
    DEVICE("Device", "http://hl7.org/fhir/resource-types"),
    DEVICECOMPONENT("DeviceComponent", "http://hl7.org/fhir/resource-types"),
    DEVICEMETRIC("DeviceMetric", "http://hl7.org/fhir/resource-types"),
    DEVICEUSEREQUEST("DeviceUseRequest", "http://hl7.org/fhir/resource-types"),
    DEVICEUSESTATEMENT("DeviceUseStatement", "http://hl7.org/fhir/resource-types"),
    DIAGNOSTICORDER("DiagnosticOrder", "http://hl7.org/fhir/resource-types"),
    DIAGNOSTICREPORT("DiagnosticReport", "http://hl7.org/fhir/resource-types"),
    DOCUMENTMANIFEST("DocumentManifest", "http://hl7.org/fhir/resource-types"),
    DOCUMENTREFERENCE("DocumentReference", "http://hl7.org/fhir/resource-types"),
    DOMAINRESOURCE("DomainResource", "http://hl7.org/fhir/resource-types"),
    ELIGIBILITYREQUEST("EligibilityRequest", "http://hl7.org/fhir/resource-types"),
    ELIGIBILITYRESPONSE("EligibilityResponse", "http://hl7.org/fhir/resource-types"),
    ENCOUNTER("Encounter", "http://hl7.org/fhir/resource-types"),
    ENROLLMENTREQUEST("EnrollmentRequest", "http://hl7.org/fhir/resource-types"),
    ENROLLMENTRESPONSE("EnrollmentResponse", "http://hl7.org/fhir/resource-types"),
    EPISODEOFCARE("EpisodeOfCare", "http://hl7.org/fhir/resource-types"),
    EXPLANATIONOFBENEFIT("ExplanationOfBenefit", "http://hl7.org/fhir/resource-types"),
    FAMILYMEMBERHISTORY("FamilyMemberHistory", "http://hl7.org/fhir/resource-types"),
    FLAG("Flag", "http://hl7.org/fhir/resource-types"),
    GOAL("Goal", "http://hl7.org/fhir/resource-types"),
    GROUP("Group", "http://hl7.org/fhir/resource-types"),
    HEALTHCARESERVICE("HealthcareService", "http://hl7.org/fhir/resource-types"),
    IMAGINGOBJECTSELECTION("ImagingObjectSelection", "http://hl7.org/fhir/resource-types"),
    IMAGINGSTUDY("ImagingStudy", "http://hl7.org/fhir/resource-types"),
    IMMUNIZATION("Immunization", "http://hl7.org/fhir/resource-types"),
    IMMUNIZATIONRECOMMENDATION("ImmunizationRecommendation", "http://hl7.org/fhir/resource-types"),
    IMPLEMENTATIONGUIDE("ImplementationGuide", "http://hl7.org/fhir/resource-types"),
    LIST("List", "http://hl7.org/fhir/resource-types"),
    LOCATION("Location", "http://hl7.org/fhir/resource-types"),
    MEDIA("Media", "http://hl7.org/fhir/resource-types"),
    MEDICATION("Medication", "http://hl7.org/fhir/resource-types"),
    MEDICATIONADMINISTRATION("MedicationAdministration", "http://hl7.org/fhir/resource-types"),
    MEDICATIONDISPENSE("MedicationDispense", "http://hl7.org/fhir/resource-types"),
    MEDICATIONORDER("MedicationOrder", "http://hl7.org/fhir/resource-types"),
    MEDICATIONSTATEMENT("MedicationStatement", "http://hl7.org/fhir/resource-types"),
    MESSAGEHEADER("MessageHeader", "http://hl7.org/fhir/resource-types"),
    NAMINGSYSTEM("NamingSystem", "http://hl7.org/fhir/resource-types"),
    NUTRITIONORDER("NutritionOrder", "http://hl7.org/fhir/resource-types"),
    OBSERVATION("Observation", "http://hl7.org/fhir/resource-types"),
    OPERATIONDEFINITION("OperationDefinition", "http://hl7.org/fhir/resource-types"),
    OPERATIONOUTCOME("OperationOutcome", "http://hl7.org/fhir/resource-types"),
    ORDER("Order", "http://hl7.org/fhir/resource-types"),
    ORDERRESPONSE("OrderResponse", "http://hl7.org/fhir/resource-types"),
    ORGANIZATION("Organization", "http://hl7.org/fhir/resource-types"),
    PARAMETERS("Parameters", "http://hl7.org/fhir/resource-types"),
    PATIENT("Patient", "http://hl7.org/fhir/resource-types"),
    PAYMENTNOTICE("PaymentNotice", "http://hl7.org/fhir/resource-types"),
    PAYMENTRECONCILIATION("PaymentReconciliation", "http://hl7.org/fhir/resource-types"),
    PERSON("Person", "http://hl7.org/fhir/resource-types"),
    PRACTITIONER("Practitioner", "http://hl7.org/fhir/resource-types"),
    PROCEDURE("Procedure", "http://hl7.org/fhir/resource-types"),
    PROCEDUREREQUEST("ProcedureRequest", "http://hl7.org/fhir/resource-types"),
    PROCESSREQUEST("ProcessRequest", "http://hl7.org/fhir/resource-types"),
    PROCESSRESPONSE("ProcessResponse", "http://hl7.org/fhir/resource-types"),
    PROVENANCE("Provenance", "http://hl7.org/fhir/resource-types"),
    QUESTIONNAIRE("Questionnaire", "http://hl7.org/fhir/resource-types"),
    QUESTIONNAIRERESPONSE("QuestionnaireResponse", "http://hl7.org/fhir/resource-types"),
    REFERRALREQUEST("ReferralRequest", "http://hl7.org/fhir/resource-types"),
    RELATEDPERSON("RelatedPerson", "http://hl7.org/fhir/resource-types"),
    RESOURCE("Resource", "http://hl7.org/fhir/resource-types"),
    RISKASSESSMENT("RiskAssessment", "http://hl7.org/fhir/resource-types"),
    SCHEDULE("Schedule", "http://hl7.org/fhir/resource-types"),
    SEARCHPARAMETER("SearchParameter", "http://hl7.org/fhir/resource-types"),
    SLOT("Slot", "http://hl7.org/fhir/resource-types"),
    SPECIMEN("Specimen", "http://hl7.org/fhir/resource-types"),
    STRUCTUREDEFINITION("StructureDefinition", "http://hl7.org/fhir/resource-types"),
    SUBSCRIPTION("Subscription", "http://hl7.org/fhir/resource-types"),
    SUBSTANCE("Substance", "http://hl7.org/fhir/resource-types"),
    SUPPLYDELIVERY("SupplyDelivery", "http://hl7.org/fhir/resource-types"),
    SUPPLYREQUEST("SupplyRequest", "http://hl7.org/fhir/resource-types"),
    TESTSCRIPT("TestScript", "http://hl7.org/fhir/resource-types"),
    VALUESET("ValueSet", "http://hl7.org/fhir/resource-types"),
    VISIONPRESCRIPTION("VisionPrescription", "http://hl7.org/fhir/resource-types");

    public static final String VALUESET_IDENTIFIER = "";
    public static final String VALUESET_NAME = "ResourceType";
    private static Map<String, ResourceTypeEnum> CODE_TO_ENUM;
    private static Map<String, Map<String, ResourceTypeEnum>> SYSTEM_TO_CODE_TO_ENUM;
    private final String myCode;
    private final String mySystem;
    public static final IValueSetEnumBinder<ResourceTypeEnum> VALUESET_BINDER;

    public String getCode() {
        return this.myCode;
    }

    public String getSystem() {
        return this.mySystem;
    }

    public static ResourceTypeEnum forCode(String theCode) {
        ResourceTypeEnum retVal = CODE_TO_ENUM.get(theCode);
        return retVal;
    }

    private ResourceTypeEnum(String theCode, String theSystem) {
        this.myCode = theCode;
        this.mySystem = theSystem;
    }

    static {
        CODE_TO_ENUM = new HashMap<String, ResourceTypeEnum>();
        SYSTEM_TO_CODE_TO_ENUM = new HashMap<String, Map<String, ResourceTypeEnum>>();
        for (ResourceTypeEnum next : ResourceTypeEnum.values()) {
            CODE_TO_ENUM.put(next.getCode(), next);
            if (!SYSTEM_TO_CODE_TO_ENUM.containsKey(next.getSystem())) {
                SYSTEM_TO_CODE_TO_ENUM.put(next.getSystem(), new HashMap());
            }
            SYSTEM_TO_CODE_TO_ENUM.get(next.getSystem()).put(next.getCode(), next);
        }
        VALUESET_BINDER = new IValueSetEnumBinder<ResourceTypeEnum>(){

            public String toCodeString(ResourceTypeEnum theEnum) {
                return theEnum.getCode();
            }

            public String toSystemString(ResourceTypeEnum theEnum) {
                return theEnum.getSystem();
            }

            public ResourceTypeEnum fromCodeString(String theCodeString) {
                return (ResourceTypeEnum)((Object)CODE_TO_ENUM.get(theCodeString));
            }

            public ResourceTypeEnum fromCodeString(String theCodeString, String theSystemString) {
                Map map = (Map)SYSTEM_TO_CODE_TO_ENUM.get(theSystemString);
                if (map == null) {
                    return null;
                }
                return (ResourceTypeEnum)((Object)map.get(theCodeString));
            }
        };
    }
}

