/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu2.resource;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.TemporalPrecisionEnum;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Compartment;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.model.dstu2.composite.CodeableConceptDt;
import ca.uhn.fhir.model.dstu2.composite.IdentifierDt;
import ca.uhn.fhir.model.dstu2.composite.PeriodDt;
import ca.uhn.fhir.model.dstu2.composite.ResourceReferenceDt;
import ca.uhn.fhir.model.dstu2.resource.BaseResource;
import ca.uhn.fhir.model.dstu2.resource.Encounter;
import ca.uhn.fhir.model.dstu2.resource.Organization;
import ca.uhn.fhir.model.dstu2.resource.Patient;
import ca.uhn.fhir.model.dstu2.resource.Practitioner;
import ca.uhn.fhir.model.dstu2.valueset.ReferralStatusEnum;
import ca.uhn.fhir.model.primitive.BoundCodeDt;
import ca.uhn.fhir.model.primitive.CodeDt;
import ca.uhn.fhir.model.primitive.DateTimeDt;
import ca.uhn.fhir.model.primitive.StringDt;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@ResourceDef(name="ReferralRequest", profile="http://hl7.org/fhir/profiles/ReferralRequest", id="referralrequest")
public class ReferralRequest
extends BaseResource
implements IResource {
    @SearchParamDefinition(name="status", path="ReferralRequest.status", description="The status of the referral", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");
    @SearchParamDefinition(name="date", path="ReferralRequest.date", description="Creation or activation date", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="type", path="ReferralRequest.type", description="The type of the referral", type="token")
    public static final String SP_TYPE = "type";
    public static final TokenClientParam TYPE = new TokenClientParam("type");
    @SearchParamDefinition(name="specialty", path="ReferralRequest.specialty", description="The specialty that the referral is for", type="token")
    public static final String SP_SPECIALTY = "specialty";
    public static final TokenClientParam SPECIALTY = new TokenClientParam("specialty");
    @SearchParamDefinition(name="priority", path="ReferralRequest.priority", description="The priority assigned to the referral", type="token")
    public static final String SP_PRIORITY = "priority";
    public static final TokenClientParam PRIORITY = new TokenClientParam("priority");
    @SearchParamDefinition(name="recipient", path="ReferralRequest.recipient", description="The person that the referral was sent to", type="reference", providesMembershipIn={@Compartment(name="Encounter")})
    public static final String SP_RECIPIENT = "recipient";
    public static final ReferenceClientParam RECIPIENT = new ReferenceClientParam("recipient");
    @SearchParamDefinition(name="patient", path="ReferralRequest.patient", description="Who the referral is about", type="reference", providesMembershipIn={@Compartment(name="Patient")})
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    @SearchParamDefinition(name="requester", path="ReferralRequest.requester", description="", type="reference", providesMembershipIn={@Compartment(name="Patient"), @Compartment(name="Encounter")})
    public static final String SP_REQUESTER = "requester";
    public static final ReferenceClientParam REQUESTER = new ReferenceClientParam("requester");
    public static final Include INCLUDE_PATIENT = new Include("ReferralRequest:patient");
    public static final Include INCLUDE_RECIPIENT = new Include("ReferralRequest:recipient");
    public static final Include INCLUDE_REQUESTER = new Include("ReferralRequest:requester");
    @Child(name="status", type={CodeDt.class}, order=0, min=1, max=1, summary=true, modifier=true)
    @Description(shortDefinition="status", formalDefinition="The workflow status of the referral or transfer of care request")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/referralstatus")
    private BoundCodeDt<ReferralStatusEnum> myStatus;
    @Child(name="identifier", type={IdentifierDt.class}, order=1, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="id", formalDefinition="Business identifier that uniquely identifies the referral/care transfer request instance")
    private List<IdentifierDt> myIdentifier;
    @Child(name="date", type={DateTimeDt.class}, order=2, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="when.init", formalDefinition="Date/DateTime of creation for draft requests and date of activation for active requests")
    private DateTimeDt myDate;
    @Child(name="type", type={CodeableConceptDt.class}, order=3, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="class", formalDefinition="An indication of the type of referral (or where applicable the type of transfer of care) request")
    private CodeableConceptDt myType;
    @Child(name="specialty", type={CodeableConceptDt.class}, order=4, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="Indication of the clinical domain or discipline to which the referral or transfer of care request is sent.  For example: Cardiology Gastroenterology Diabetology")
    private CodeableConceptDt mySpecialty;
    @Child(name="priority", type={CodeableConceptDt.class}, order=5, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="grade", formalDefinition="An indication of the urgency of referral (or where applicable the type of transfer of care) request")
    private CodeableConceptDt myPriority;
    @Child(name="patient", order=6, min=0, max=1, summary=true, modifier=false, type={Patient.class})
    @Description(shortDefinition="who.focus", formalDefinition="The patient who is the subject of a referral or transfer of care request")
    private ResourceReferenceDt myPatient;
    @Child(name="requester", order=7, min=0, max=1, summary=true, modifier=false, type={Practitioner.class, Organization.class, Patient.class})
    @Description(shortDefinition="who.author", formalDefinition="The healthcare provider or provider organization who/which initiated the referral/transfer of care request. Can also be  Patient (a self referral)")
    private ResourceReferenceDt myRequester;
    @Child(name="recipient", order=8, min=0, max=-1, summary=true, modifier=false, type={Practitioner.class, Organization.class})
    @Description(shortDefinition="who.actor", formalDefinition="The healthcare provider(s) or provider organization(s) who/which is to receive the referral/transfer of care request")
    private List<ResourceReferenceDt> myRecipient;
    @Child(name="encounter", order=9, min=0, max=1, summary=false, modifier=false, type={Encounter.class})
    @Description(shortDefinition="context", formalDefinition="The encounter at which the request for referral or transfer of care is initiated")
    private ResourceReferenceDt myEncounter;
    @Child(name="dateSent", type={DateTimeDt.class}, order=10, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="when.init", formalDefinition="Date/DateTime the request for referral or transfer of care is sent by the author")
    private DateTimeDt myDateSent;
    @Child(name="reason", type={CodeableConceptDt.class}, order=11, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="why", formalDefinition="Description of clinical condition indicating why referral/transfer of care is requested.  For example:  Pathological Anomalies, Disabled (physical or mental),  Behavioral Management")
    private CodeableConceptDt myReason;
    @Child(name="description", type={StringDt.class}, order=12, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="The reason element gives a short description of why the referral is being made, the description expands on this to support a more complete clinical summary")
    private StringDt myDescription;
    @Child(name="serviceRequested", type={CodeableConceptDt.class}, order=13, min=0, max=-1, summary=true, modifier=false)
    @Description(shortDefinition="what", formalDefinition="The service(s) that is/are requested to be provided to the patient.  For example: cardiac pacemaker insertion")
    private List<CodeableConceptDt> myServiceRequested;
    @Child(name="supportingInformation", order=14, min=0, max=-1, summary=true, modifier=false, type={IResource.class})
    @Description(shortDefinition="", formalDefinition="Any additional (administrative, financial or clinical) information required to support request for referral or transfer of care.  For example: Presenting problems/chief complaints Medical History Family History Alerts Allergy/Intolerance and Adverse Reactions Medications Observations/Assessments (may include cognitive and fundtional assessments) Diagnostic Reports Care Plan")
    private List<ResourceReferenceDt> mySupportingInformation;
    @Child(name="fulfillmentTime", type={PeriodDt.class}, order=15, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="when.planned", formalDefinition="The period of time within which the services identified in the referral/transfer of care is specified or required to occur")
    private PeriodDt myFulfillmentTime;

    public boolean isEmpty() {
        return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myStatus, this.myIdentifier, this.myDate, this.myType, this.mySpecialty, this.myPriority, this.myPatient, this.myRequester, this.myRecipient, this.myEncounter, this.myDateSent, this.myReason, this.myDescription, this.myServiceRequested, this.mySupportingInformation, this.myFulfillmentTime});
    }

    public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
        return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myStatus, this.myIdentifier, this.myDate, this.myType, this.mySpecialty, this.myPriority, this.myPatient, this.myRequester, this.myRecipient, this.myEncounter, this.myDateSent, this.myReason, this.myDescription, this.myServiceRequested, this.mySupportingInformation, this.myFulfillmentTime});
    }

    public BoundCodeDt<ReferralStatusEnum> getStatusElement() {
        if (this.myStatus == null) {
            this.myStatus = new BoundCodeDt(ReferralStatusEnum.VALUESET_BINDER);
        }
        return this.myStatus;
    }

    public String getStatus() {
        return (String)this.getStatusElement().getValue();
    }

    public ReferralRequest setStatus(BoundCodeDt<ReferralStatusEnum> theValue) {
        this.myStatus = theValue;
        return this;
    }

    public ReferralRequest setStatus(ReferralStatusEnum theValue) {
        this.setStatus((BoundCodeDt<ReferralStatusEnum>)new BoundCodeDt(ReferralStatusEnum.VALUESET_BINDER, (Enum)theValue));
        return this;
    }

    public List<IdentifierDt> getIdentifier() {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        return this.myIdentifier;
    }

    public ReferralRequest setIdentifier(List<IdentifierDt> theValue) {
        this.myIdentifier = theValue;
        return this;
    }

    public IdentifierDt addIdentifier() {
        IdentifierDt newType = new IdentifierDt();
        this.getIdentifier().add(newType);
        return newType;
    }

    public ReferralRequest addIdentifier(IdentifierDt theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getIdentifier().add(theValue);
        return this;
    }

    public IdentifierDt getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            return this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public DateTimeDt getDateElement() {
        if (this.myDate == null) {
            this.myDate = new DateTimeDt();
        }
        return this.myDate;
    }

    public Date getDate() {
        return (Date)this.getDateElement().getValue();
    }

    public ReferralRequest setDate(DateTimeDt theValue) {
        this.myDate = theValue;
        return this;
    }

    public ReferralRequest setDate(Date theDate, TemporalPrecisionEnum thePrecision) {
        this.myDate = new DateTimeDt(theDate, thePrecision);
        return this;
    }

    public ReferralRequest setDateWithSecondsPrecision(Date theDate) {
        this.myDate = new DateTimeDt(theDate);
        return this;
    }

    public CodeableConceptDt getType() {
        if (this.myType == null) {
            this.myType = new CodeableConceptDt();
        }
        return this.myType;
    }

    public ReferralRequest setType(CodeableConceptDt theValue) {
        this.myType = theValue;
        return this;
    }

    public CodeableConceptDt getSpecialty() {
        if (this.mySpecialty == null) {
            this.mySpecialty = new CodeableConceptDt();
        }
        return this.mySpecialty;
    }

    public ReferralRequest setSpecialty(CodeableConceptDt theValue) {
        this.mySpecialty = theValue;
        return this;
    }

    public CodeableConceptDt getPriority() {
        if (this.myPriority == null) {
            this.myPriority = new CodeableConceptDt();
        }
        return this.myPriority;
    }

    public ReferralRequest setPriority(CodeableConceptDt theValue) {
        this.myPriority = theValue;
        return this;
    }

    public ResourceReferenceDt getPatient() {
        if (this.myPatient == null) {
            this.myPatient = new ResourceReferenceDt();
        }
        return this.myPatient;
    }

    public ReferralRequest setPatient(ResourceReferenceDt theValue) {
        this.myPatient = theValue;
        return this;
    }

    public ResourceReferenceDt getRequester() {
        if (this.myRequester == null) {
            this.myRequester = new ResourceReferenceDt();
        }
        return this.myRequester;
    }

    public ReferralRequest setRequester(ResourceReferenceDt theValue) {
        this.myRequester = theValue;
        return this;
    }

    public List<ResourceReferenceDt> getRecipient() {
        if (this.myRecipient == null) {
            this.myRecipient = new ArrayList<ResourceReferenceDt>();
        }
        return this.myRecipient;
    }

    public ReferralRequest setRecipient(List<ResourceReferenceDt> theValue) {
        this.myRecipient = theValue;
        return this;
    }

    public ResourceReferenceDt addRecipient() {
        ResourceReferenceDt newType = new ResourceReferenceDt();
        this.getRecipient().add(newType);
        return newType;
    }

    public ResourceReferenceDt getEncounter() {
        if (this.myEncounter == null) {
            this.myEncounter = new ResourceReferenceDt();
        }
        return this.myEncounter;
    }

    public ReferralRequest setEncounter(ResourceReferenceDt theValue) {
        this.myEncounter = theValue;
        return this;
    }

    public DateTimeDt getDateSentElement() {
        if (this.myDateSent == null) {
            this.myDateSent = new DateTimeDt();
        }
        return this.myDateSent;
    }

    public Date getDateSent() {
        return (Date)this.getDateSentElement().getValue();
    }

    public ReferralRequest setDateSent(DateTimeDt theValue) {
        this.myDateSent = theValue;
        return this;
    }

    public ReferralRequest setDateSent(Date theDate, TemporalPrecisionEnum thePrecision) {
        this.myDateSent = new DateTimeDt(theDate, thePrecision);
        return this;
    }

    public ReferralRequest setDateSentWithSecondsPrecision(Date theDate) {
        this.myDateSent = new DateTimeDt(theDate);
        return this;
    }

    public CodeableConceptDt getReason() {
        if (this.myReason == null) {
            this.myReason = new CodeableConceptDt();
        }
        return this.myReason;
    }

    public ReferralRequest setReason(CodeableConceptDt theValue) {
        this.myReason = theValue;
        return this;
    }

    public StringDt getDescriptionElement() {
        if (this.myDescription == null) {
            this.myDescription = new StringDt();
        }
        return this.myDescription;
    }

    public String getDescription() {
        return (String)this.getDescriptionElement().getValue();
    }

    public ReferralRequest setDescription(StringDt theValue) {
        this.myDescription = theValue;
        return this;
    }

    public ReferralRequest setDescription(String theString) {
        this.myDescription = new StringDt(theString);
        return this;
    }

    public List<CodeableConceptDt> getServiceRequested() {
        if (this.myServiceRequested == null) {
            this.myServiceRequested = new ArrayList<CodeableConceptDt>();
        }
        return this.myServiceRequested;
    }

    public ReferralRequest setServiceRequested(List<CodeableConceptDt> theValue) {
        this.myServiceRequested = theValue;
        return this;
    }

    public CodeableConceptDt addServiceRequested() {
        CodeableConceptDt newType = new CodeableConceptDt();
        this.getServiceRequested().add(newType);
        return newType;
    }

    public ReferralRequest addServiceRequested(CodeableConceptDt theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getServiceRequested().add(theValue);
        return this;
    }

    public CodeableConceptDt getServiceRequestedFirstRep() {
        if (this.getServiceRequested().isEmpty()) {
            return this.addServiceRequested();
        }
        return this.getServiceRequested().get(0);
    }

    public List<ResourceReferenceDt> getSupportingInformation() {
        if (this.mySupportingInformation == null) {
            this.mySupportingInformation = new ArrayList<ResourceReferenceDt>();
        }
        return this.mySupportingInformation;
    }

    public ReferralRequest setSupportingInformation(List<ResourceReferenceDt> theValue) {
        this.mySupportingInformation = theValue;
        return this;
    }

    public ResourceReferenceDt addSupportingInformation() {
        ResourceReferenceDt newType = new ResourceReferenceDt();
        this.getSupportingInformation().add(newType);
        return newType;
    }

    public PeriodDt getFulfillmentTime() {
        if (this.myFulfillmentTime == null) {
            this.myFulfillmentTime = new PeriodDt();
        }
        return this.myFulfillmentTime;
    }

    public ReferralRequest setFulfillmentTime(PeriodDt theValue) {
        this.myFulfillmentTime = theValue;
        return this;
    }

    public String getResourceName() {
        return "ReferralRequest";
    }

    public FhirVersionEnum getStructureFhirVersionEnum() {
        return FhirVersionEnum.DSTU2;
    }
}

