/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu2.valueset;

import ca.uhn.fhir.model.api.IValueSetEnumBinder;
import java.util.HashMap;
import java.util.Map;

public enum SystemRestfulInteractionEnum {
    TRANSACTION("transaction", "http://hl7.org/fhir/restful-interaction"),
    SEARCH_SYSTEM("search-system", "http://hl7.org/fhir/restful-interaction"),
    HISTORY_SYSTEM("history-system", "http://hl7.org/fhir/restful-interaction");

    public static final String VALUESET_IDENTIFIER = "";
    public static final String VALUESET_NAME = "SystemRestfulInteraction";
    private static Map<String, SystemRestfulInteractionEnum> CODE_TO_ENUM;
    private static Map<String, Map<String, SystemRestfulInteractionEnum>> SYSTEM_TO_CODE_TO_ENUM;
    private final String myCode;
    private final String mySystem;
    public static final IValueSetEnumBinder<SystemRestfulInteractionEnum> VALUESET_BINDER;

    public String getCode() {
        return this.myCode;
    }

    public String getSystem() {
        return this.mySystem;
    }

    public static SystemRestfulInteractionEnum forCode(String theCode) {
        SystemRestfulInteractionEnum retVal = CODE_TO_ENUM.get(theCode);
        return retVal;
    }

    private SystemRestfulInteractionEnum(String theCode, String theSystem) {
        this.myCode = theCode;
        this.mySystem = theSystem;
    }

    static {
        CODE_TO_ENUM = new HashMap<String, SystemRestfulInteractionEnum>();
        SYSTEM_TO_CODE_TO_ENUM = new HashMap<String, Map<String, SystemRestfulInteractionEnum>>();
        for (SystemRestfulInteractionEnum next : SystemRestfulInteractionEnum.values()) {
            CODE_TO_ENUM.put(next.getCode(), next);
            if (!SYSTEM_TO_CODE_TO_ENUM.containsKey(next.getSystem())) {
                SYSTEM_TO_CODE_TO_ENUM.put(next.getSystem(), new HashMap());
            }
            SYSTEM_TO_CODE_TO_ENUM.get(next.getSystem()).put(next.getCode(), next);
        }
        VALUESET_BINDER = new IValueSetEnumBinder<SystemRestfulInteractionEnum>(){

            public String toCodeString(SystemRestfulInteractionEnum theEnum) {
                return theEnum.getCode();
            }

            public String toSystemString(SystemRestfulInteractionEnum theEnum) {
                return theEnum.getSystem();
            }

            public SystemRestfulInteractionEnum fromCodeString(String theCodeString) {
                return (SystemRestfulInteractionEnum)((Object)CODE_TO_ENUM.get(theCodeString));
            }

            public SystemRestfulInteractionEnum fromCodeString(String theCodeString, String theSystemString) {
                Map map = (Map)SYSTEM_TO_CODE_TO_ENUM.get(theSystemString);
                if (map == null) {
                    return null;
                }
                return (SystemRestfulInteractionEnum)((Object)map.get(theCodeString));
            }
        };
    }
}

