/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu2.composite;

import ca.uhn.fhir.model.api.IBoundCodeableConcept;
import ca.uhn.fhir.model.api.IValueSetEnumBinder;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.dstu2.composite.CodeableConceptDt;
import ca.uhn.fhir.model.dstu2.composite.CodingDt;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

@DatatypeDef(name="CodeableConcept", isSpecialization=true)
public class BoundCodeableConceptDt<T extends Enum<?>>
extends CodeableConceptDt
implements IBoundCodeableConcept {
    private IValueSetEnumBinder<T> myBinder;

    @Deprecated
    public BoundCodeableConceptDt() {
    }

    public BoundCodeableConceptDt(IValueSetEnumBinder<T> theBinder) {
        Validate.notNull(theBinder, (String)"theBinder must not be null", (Object[])new Object[0]);
        this.myBinder = theBinder;
    }

    public BoundCodeableConceptDt(IValueSetEnumBinder<T> theBinder, T theValue) {
        Validate.notNull(theBinder, (String)"theBinder must not be null", (Object[])new Object[0]);
        this.myBinder = theBinder;
        this.setValueAsEnum(theValue);
    }

    public BoundCodeableConceptDt(IValueSetEnumBinder<T> theBinder, Collection<T> theValues) {
        Validate.notNull(theBinder, (String)"theBinder must not be null", (Object[])new Object[0]);
        this.myBinder = theBinder;
        this.setValueAsEnum((T)theValues);
    }

    public void setValueAsEnum(Collection<T> theValues) {
        Validate.notNull(this.myBinder, (String)"This object does not have a binder. Constructor BoundCodeableConceptDt() should not be called!", (Object[])new Object[0]);
        this.getCoding().clear();
        if (theValues != null) {
            for (Enum next : theValues) {
                this.getCoding().add(new CodingDt(this.myBinder.toSystemString(next), this.myBinder.toCodeString(next)));
            }
        }
    }

    public void setValueAsEnum(T theValue) {
        Validate.notNull(this.myBinder, (String)"This object does not have a binder. Constructor BoundCodeableConceptDt() should not be called!", (Object[])new Object[0]);
        this.getCoding().clear();
        if (theValue == null) {
            return;
        }
        this.getCoding().add(new CodingDt(this.myBinder.toSystemString(theValue), this.myBinder.toCodeString(theValue)));
    }

    public Set<T> getValueAsEnum() {
        Validate.notNull(this.myBinder, (String)"This object does not have a binder. Constructor BoundCodeableConceptDt() should not be called!", (Object[])new Object[0]);
        HashSet<Enum> retVal = new HashSet<Enum>();
        for (CodingDt next : this.getCoding()) {
            Enum nextT;
            if (next == null || (nextT = this.myBinder.fromCodeString(StringUtils.defaultString((String)((String)next.getCodeElement().getValue())), StringUtils.defaultString((String)next.getSystemElement().getValueAsString()))) == null) continue;
            retVal.add(nextT);
        }
        return retVal;
    }
}

