/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu2.resource;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.model.api.BaseIdentifiableElement;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.IResourceBlock;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.TemporalPrecisionEnum;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Compartment;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.model.dstu2.composite.AnnotationDt;
import ca.uhn.fhir.model.dstu2.composite.CodeableConceptDt;
import ca.uhn.fhir.model.dstu2.composite.IdentifierDt;
import ca.uhn.fhir.model.dstu2.composite.ResourceReferenceDt;
import ca.uhn.fhir.model.dstu2.composite.SimpleQuantityDt;
import ca.uhn.fhir.model.dstu2.resource.BaseResource;
import ca.uhn.fhir.model.dstu2.resource.Encounter;
import ca.uhn.fhir.model.dstu2.resource.Location;
import ca.uhn.fhir.model.dstu2.resource.Observation;
import ca.uhn.fhir.model.dstu2.resource.Organization;
import ca.uhn.fhir.model.dstu2.resource.Patient;
import ca.uhn.fhir.model.dstu2.resource.Practitioner;
import ca.uhn.fhir.model.primitive.BooleanDt;
import ca.uhn.fhir.model.primitive.CodeDt;
import ca.uhn.fhir.model.primitive.DateDt;
import ca.uhn.fhir.model.primitive.DateTimeDt;
import ca.uhn.fhir.model.primitive.PositiveIntDt;
import ca.uhn.fhir.model.primitive.StringDt;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.NumberClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@ResourceDef(name="Immunization", profile="http://hl7.org/fhir/profiles/Immunization", id="immunization")
public class Immunization
extends BaseResource
implements IResource {
    @SearchParamDefinition(name="date", path="Immunization.date", description="Vaccination  (non)-Administration Date", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="dose-sequence", path="Immunization.vaccinationProtocol.doseSequence", description="", type="number")
    public static final String SP_DOSE_SEQUENCE = "dose-sequence";
    public static final NumberClientParam DOSE_SEQUENCE = new NumberClientParam("dose-sequence");
    @SearchParamDefinition(name="identifier", path="Immunization.identifier", description="", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="location", path="Immunization.location", description="The service delivery location or facility in which the vaccine was / was to be administered", type="reference")
    public static final String SP_LOCATION = "location";
    public static final ReferenceClientParam LOCATION = new ReferenceClientParam("location");
    @SearchParamDefinition(name="lot-number", path="Immunization.lotNumber", description="Vaccine Lot Number", type="string")
    public static final String SP_LOT_NUMBER = "lot-number";
    public static final StringClientParam LOT_NUMBER = new StringClientParam("lot-number");
    @SearchParamDefinition(name="manufacturer", path="Immunization.manufacturer", description="Vaccine Manufacturer", type="reference")
    public static final String SP_MANUFACTURER = "manufacturer";
    public static final ReferenceClientParam MANUFACTURER = new ReferenceClientParam("manufacturer");
    @SearchParamDefinition(name="performer", path="Immunization.performer", description="The practitioner who administered the vaccination", type="reference", providesMembershipIn={@Compartment(name="Encounter")})
    public static final String SP_PERFORMER = "performer";
    public static final ReferenceClientParam PERFORMER = new ReferenceClientParam("performer");
    @SearchParamDefinition(name="reaction", path="Immunization.reaction.detail", description="", type="reference")
    public static final String SP_REACTION = "reaction";
    public static final ReferenceClientParam REACTION = new ReferenceClientParam("reaction");
    @SearchParamDefinition(name="reaction-date", path="Immunization.reaction.date", description="", type="date")
    public static final String SP_REACTION_DATE = "reaction-date";
    public static final DateClientParam REACTION_DATE = new DateClientParam("reaction-date");
    @SearchParamDefinition(name="reason", path="Immunization.explanation.reason", description="", type="token")
    public static final String SP_REASON = "reason";
    public static final TokenClientParam REASON = new TokenClientParam("reason");
    @SearchParamDefinition(name="reason-not-given", path="Immunization.explanation.reasonNotGiven", description="Explanation of reason vaccination was not administered", type="token")
    public static final String SP_REASON_NOT_GIVEN = "reason-not-given";
    public static final TokenClientParam REASON_NOT_GIVEN = new TokenClientParam("reason-not-given");
    @SearchParamDefinition(name="notgiven", path="Immunization.wasNotGiven", description="Administrations which were not given", type="token")
    public static final String SP_NOTGIVEN = "notgiven";
    public static final TokenClientParam NOTGIVEN = new TokenClientParam("notgiven");
    @SearchParamDefinition(name="requester", path="Immunization.requester", description="The practitioner who ordered the vaccination", type="reference", providesMembershipIn={@Compartment(name="Encounter")})
    public static final String SP_REQUESTER = "requester";
    public static final ReferenceClientParam REQUESTER = new ReferenceClientParam("requester");
    @SearchParamDefinition(name="patient", path="Immunization.patient", description="The patient for the vaccination record", type="reference", providesMembershipIn={@Compartment(name="Patient")})
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    @SearchParamDefinition(name="vaccine-code", path="Immunization.vaccineCode", description="Vaccine Product Administered", type="token")
    public static final String SP_VACCINE_CODE = "vaccine-code";
    public static final TokenClientParam VACCINE_CODE = new TokenClientParam("vaccine-code");
    @SearchParamDefinition(name="status", path="Immunization.status", description="Immunization event status", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");
    public static final Include INCLUDE_LOCATION = new Include("Immunization:location");
    public static final Include INCLUDE_MANUFACTURER = new Include("Immunization:manufacturer");
    public static final Include INCLUDE_PATIENT = new Include("Immunization:patient");
    public static final Include INCLUDE_PERFORMER = new Include("Immunization:performer");
    public static final Include INCLUDE_REACTION = new Include("Immunization:reaction");
    public static final Include INCLUDE_REQUESTER = new Include("Immunization:requester");
    @Child(name="identifier", type={IdentifierDt.class}, order=0, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="id", formalDefinition="A unique identifier assigned to this immunization record.")
    private List<IdentifierDt> myIdentifier;
    @Child(name="status", type={CodeDt.class}, order=1, min=1, max=1, summary=true, modifier=true)
    @Description(shortDefinition="status", formalDefinition="Indicates the current status of the vaccination event")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/medication-admin-status")
    private CodeDt myStatus;
    @Child(name="date", type={DateTimeDt.class}, order=2, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="when.init", formalDefinition="Date vaccine administered or was to be administered")
    private DateTimeDt myDate;
    @Child(name="vaccineCode", type={CodeableConceptDt.class}, order=3, min=1, max=1, summary=false, modifier=false)
    @Description(shortDefinition="what", formalDefinition="Vaccine that was administered or was to be administered")
    private CodeableConceptDt myVaccineCode;
    @Child(name="patient", order=4, min=1, max=1, summary=false, modifier=false, type={Patient.class})
    @Description(shortDefinition="who.focus", formalDefinition="The patient who either received or did not receive the immunization.")
    private ResourceReferenceDt myPatient;
    @Child(name="wasNotGiven", type={BooleanDt.class}, order=5, min=1, max=1, summary=false, modifier=true)
    @Description(shortDefinition="status", formalDefinition="Indicates if the vaccination was or was not given")
    private BooleanDt myWasNotGiven;
    @Child(name="reported", type={BooleanDt.class}, order=6, min=1, max=1, summary=false, modifier=false)
    @Description(shortDefinition="who.source", formalDefinition="True if this administration was reported rather than directly administered.")
    private BooleanDt myReported;
    @Child(name="performer", order=7, min=0, max=1, summary=false, modifier=false, type={Practitioner.class})
    @Description(shortDefinition="who.actor", formalDefinition="Clinician who administered the vaccine")
    private ResourceReferenceDt myPerformer;
    @Child(name="requester", order=8, min=0, max=1, summary=false, modifier=false, type={Practitioner.class})
    @Description(shortDefinition="who.cause", formalDefinition="Clinician who ordered the vaccination")
    private ResourceReferenceDt myRequester;
    @Child(name="encounter", order=9, min=0, max=1, summary=false, modifier=false, type={Encounter.class})
    @Description(shortDefinition="context", formalDefinition="The visit or admission or other contact between patient and health care provider the immunization was performed as part of.")
    private ResourceReferenceDt myEncounter;
    @Child(name="manufacturer", order=10, min=0, max=1, summary=false, modifier=false, type={Organization.class})
    @Description(shortDefinition="", formalDefinition="Name of vaccine manufacturer")
    private ResourceReferenceDt myManufacturer;
    @Child(name="location", order=11, min=0, max=1, summary=false, modifier=false, type={Location.class})
    @Description(shortDefinition="where", formalDefinition="The service delivery location where the vaccine administration occurred.")
    private ResourceReferenceDt myLocation;
    @Child(name="lotNumber", type={StringDt.class}, order=12, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="Lot number of the  vaccine product")
    private StringDt myLotNumber;
    @Child(name="expirationDate", type={DateDt.class}, order=13, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="Date vaccine batch expires")
    private DateDt myExpirationDate;
    @Child(name="site", type={CodeableConceptDt.class}, order=14, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="Body site where vaccine was administered")
    private CodeableConceptDt mySite;
    @Child(name="route", type={CodeableConceptDt.class}, order=15, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="The path by which the vaccine product is taken into the body.")
    private CodeableConceptDt myRoute;
    @Child(name="doseQuantity", type={SimpleQuantityDt.class}, order=16, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="The quantity of vaccine product that was administered")
    private SimpleQuantityDt myDoseQuantity;
    @Child(name="note", type={AnnotationDt.class}, order=17, min=0, max=-1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="Extra information about the immunization that is not conveyed by the other attributes.")
    private List<AnnotationDt> myNote;
    @Child(name="explanation", order=18, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="Reasons why a vaccine was or was not administered")
    private Explanation myExplanation;
    @Child(name="reaction", order=19, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="Categorical data indicating that an adverse event is associated in time to an immunization")
    private List<Reaction> myReaction;
    @Child(name="vaccinationProtocol", order=20, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="Contains information about the protocol(s) under which the vaccine was administered")
    private List<VaccinationProtocol> myVaccinationProtocol;

    public boolean isEmpty() {
        return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myIdentifier, this.myStatus, this.myDate, this.myVaccineCode, this.myPatient, this.myWasNotGiven, this.myReported, this.myPerformer, this.myRequester, this.myEncounter, this.myManufacturer, this.myLocation, this.myLotNumber, this.myExpirationDate, this.mySite, this.myRoute, this.myDoseQuantity, this.myNote, this.myExplanation, this.myReaction, this.myVaccinationProtocol});
    }

    public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
        return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myIdentifier, this.myStatus, this.myDate, this.myVaccineCode, this.myPatient, this.myWasNotGiven, this.myReported, this.myPerformer, this.myRequester, this.myEncounter, this.myManufacturer, this.myLocation, this.myLotNumber, this.myExpirationDate, this.mySite, this.myRoute, this.myDoseQuantity, this.myNote, this.myExplanation, this.myReaction, this.myVaccinationProtocol});
    }

    public List<IdentifierDt> getIdentifier() {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        return this.myIdentifier;
    }

    public Immunization setIdentifier(List<IdentifierDt> theValue) {
        this.myIdentifier = theValue;
        return this;
    }

    public IdentifierDt addIdentifier() {
        IdentifierDt newType = new IdentifierDt();
        this.getIdentifier().add(newType);
        return newType;
    }

    public Immunization addIdentifier(IdentifierDt theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getIdentifier().add(theValue);
        return this;
    }

    public IdentifierDt getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            return this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public CodeDt getStatusElement() {
        if (this.myStatus == null) {
            this.myStatus = new CodeDt();
        }
        return this.myStatus;
    }

    public String getStatus() {
        return (String)this.getStatusElement().getValue();
    }

    public Immunization setStatus(CodeDt theValue) {
        this.myStatus = theValue;
        return this;
    }

    public Immunization setStatus(String theCode) {
        this.myStatus = new CodeDt(theCode);
        return this;
    }

    public DateTimeDt getDateElement() {
        if (this.myDate == null) {
            this.myDate = new DateTimeDt();
        }
        return this.myDate;
    }

    public Date getDate() {
        return (Date)this.getDateElement().getValue();
    }

    public Immunization setDate(DateTimeDt theValue) {
        this.myDate = theValue;
        return this;
    }

    public Immunization setDateWithSecondsPrecision(Date theDate) {
        this.myDate = new DateTimeDt(theDate);
        return this;
    }

    public Immunization setDate(Date theDate, TemporalPrecisionEnum thePrecision) {
        this.myDate = new DateTimeDt(theDate, thePrecision);
        return this;
    }

    public CodeableConceptDt getVaccineCode() {
        if (this.myVaccineCode == null) {
            this.myVaccineCode = new CodeableConceptDt();
        }
        return this.myVaccineCode;
    }

    public Immunization setVaccineCode(CodeableConceptDt theValue) {
        this.myVaccineCode = theValue;
        return this;
    }

    public ResourceReferenceDt getPatient() {
        if (this.myPatient == null) {
            this.myPatient = new ResourceReferenceDt();
        }
        return this.myPatient;
    }

    public Immunization setPatient(ResourceReferenceDt theValue) {
        this.myPatient = theValue;
        return this;
    }

    public BooleanDt getWasNotGivenElement() {
        if (this.myWasNotGiven == null) {
            this.myWasNotGiven = new BooleanDt();
        }
        return this.myWasNotGiven;
    }

    public Boolean getWasNotGiven() {
        return (Boolean)this.getWasNotGivenElement().getValue();
    }

    public Immunization setWasNotGiven(BooleanDt theValue) {
        this.myWasNotGiven = theValue;
        return this;
    }

    public Immunization setWasNotGiven(boolean theBoolean) {
        this.myWasNotGiven = new BooleanDt(theBoolean);
        return this;
    }

    public BooleanDt getReportedElement() {
        if (this.myReported == null) {
            this.myReported = new BooleanDt();
        }
        return this.myReported;
    }

    public Boolean getReported() {
        return (Boolean)this.getReportedElement().getValue();
    }

    public Immunization setReported(BooleanDt theValue) {
        this.myReported = theValue;
        return this;
    }

    public Immunization setReported(boolean theBoolean) {
        this.myReported = new BooleanDt(theBoolean);
        return this;
    }

    public ResourceReferenceDt getPerformer() {
        if (this.myPerformer == null) {
            this.myPerformer = new ResourceReferenceDt();
        }
        return this.myPerformer;
    }

    public Immunization setPerformer(ResourceReferenceDt theValue) {
        this.myPerformer = theValue;
        return this;
    }

    public ResourceReferenceDt getRequester() {
        if (this.myRequester == null) {
            this.myRequester = new ResourceReferenceDt();
        }
        return this.myRequester;
    }

    public Immunization setRequester(ResourceReferenceDt theValue) {
        this.myRequester = theValue;
        return this;
    }

    public ResourceReferenceDt getEncounter() {
        if (this.myEncounter == null) {
            this.myEncounter = new ResourceReferenceDt();
        }
        return this.myEncounter;
    }

    public Immunization setEncounter(ResourceReferenceDt theValue) {
        this.myEncounter = theValue;
        return this;
    }

    public ResourceReferenceDt getManufacturer() {
        if (this.myManufacturer == null) {
            this.myManufacturer = new ResourceReferenceDt();
        }
        return this.myManufacturer;
    }

    public Immunization setManufacturer(ResourceReferenceDt theValue) {
        this.myManufacturer = theValue;
        return this;
    }

    public ResourceReferenceDt getLocation() {
        if (this.myLocation == null) {
            this.myLocation = new ResourceReferenceDt();
        }
        return this.myLocation;
    }

    public Immunization setLocation(ResourceReferenceDt theValue) {
        this.myLocation = theValue;
        return this;
    }

    public StringDt getLotNumberElement() {
        if (this.myLotNumber == null) {
            this.myLotNumber = new StringDt();
        }
        return this.myLotNumber;
    }

    public String getLotNumber() {
        return (String)this.getLotNumberElement().getValue();
    }

    public Immunization setLotNumber(StringDt theValue) {
        this.myLotNumber = theValue;
        return this;
    }

    public Immunization setLotNumber(String theString) {
        this.myLotNumber = new StringDt(theString);
        return this;
    }

    public DateDt getExpirationDateElement() {
        if (this.myExpirationDate == null) {
            this.myExpirationDate = new DateDt();
        }
        return this.myExpirationDate;
    }

    public Date getExpirationDate() {
        return (Date)this.getExpirationDateElement().getValue();
    }

    public Immunization setExpirationDate(DateDt theValue) {
        this.myExpirationDate = theValue;
        return this;
    }

    public Immunization setExpirationDateWithDayPrecision(Date theDate) {
        this.myExpirationDate = new DateDt(theDate);
        return this;
    }

    public Immunization setExpirationDate(Date theDate, TemporalPrecisionEnum thePrecision) {
        this.myExpirationDate = new DateDt(theDate, thePrecision);
        return this;
    }

    public CodeableConceptDt getSite() {
        if (this.mySite == null) {
            this.mySite = new CodeableConceptDt();
        }
        return this.mySite;
    }

    public Immunization setSite(CodeableConceptDt theValue) {
        this.mySite = theValue;
        return this;
    }

    public CodeableConceptDt getRoute() {
        if (this.myRoute == null) {
            this.myRoute = new CodeableConceptDt();
        }
        return this.myRoute;
    }

    public Immunization setRoute(CodeableConceptDt theValue) {
        this.myRoute = theValue;
        return this;
    }

    public SimpleQuantityDt getDoseQuantity() {
        if (this.myDoseQuantity == null) {
            this.myDoseQuantity = new SimpleQuantityDt();
        }
        return this.myDoseQuantity;
    }

    public Immunization setDoseQuantity(SimpleQuantityDt theValue) {
        this.myDoseQuantity = theValue;
        return this;
    }

    public List<AnnotationDt> getNote() {
        if (this.myNote == null) {
            this.myNote = new ArrayList<AnnotationDt>();
        }
        return this.myNote;
    }

    public Immunization setNote(List<AnnotationDt> theValue) {
        this.myNote = theValue;
        return this;
    }

    public AnnotationDt addNote() {
        AnnotationDt newType = new AnnotationDt();
        this.getNote().add(newType);
        return newType;
    }

    public Immunization addNote(AnnotationDt theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getNote().add(theValue);
        return this;
    }

    public AnnotationDt getNoteFirstRep() {
        if (this.getNote().isEmpty()) {
            return this.addNote();
        }
        return this.getNote().get(0);
    }

    public Explanation getExplanation() {
        if (this.myExplanation == null) {
            this.myExplanation = new Explanation();
        }
        return this.myExplanation;
    }

    public Immunization setExplanation(Explanation theValue) {
        this.myExplanation = theValue;
        return this;
    }

    public List<Reaction> getReaction() {
        if (this.myReaction == null) {
            this.myReaction = new ArrayList<Reaction>();
        }
        return this.myReaction;
    }

    public Immunization setReaction(List<Reaction> theValue) {
        this.myReaction = theValue;
        return this;
    }

    public Reaction addReaction() {
        Reaction newType = new Reaction();
        this.getReaction().add(newType);
        return newType;
    }

    public Immunization addReaction(Reaction theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getReaction().add(theValue);
        return this;
    }

    public Reaction getReactionFirstRep() {
        if (this.getReaction().isEmpty()) {
            return this.addReaction();
        }
        return this.getReaction().get(0);
    }

    public List<VaccinationProtocol> getVaccinationProtocol() {
        if (this.myVaccinationProtocol == null) {
            this.myVaccinationProtocol = new ArrayList<VaccinationProtocol>();
        }
        return this.myVaccinationProtocol;
    }

    public Immunization setVaccinationProtocol(List<VaccinationProtocol> theValue) {
        this.myVaccinationProtocol = theValue;
        return this;
    }

    public VaccinationProtocol addVaccinationProtocol() {
        VaccinationProtocol newType = new VaccinationProtocol();
        this.getVaccinationProtocol().add(newType);
        return newType;
    }

    public Immunization addVaccinationProtocol(VaccinationProtocol theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getVaccinationProtocol().add(theValue);
        return this;
    }

    public VaccinationProtocol getVaccinationProtocolFirstRep() {
        if (this.getVaccinationProtocol().isEmpty()) {
            return this.addVaccinationProtocol();
        }
        return this.getVaccinationProtocol().get(0);
    }

    public String getResourceName() {
        return "Immunization";
    }

    public FhirVersionEnum getStructureFhirVersionEnum() {
        return FhirVersionEnum.DSTU2;
    }

    @Block
    public static class Explanation
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="reason", type={CodeableConceptDt.class}, order=0, min=0, max=-1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Reasons why a vaccine was administered")
        private List<CodeableConceptDt> myReason;
        @Child(name="reasonNotGiven", type={CodeableConceptDt.class}, order=1, min=0, max=-1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Reason why a vaccine was not administered")
        private List<CodeableConceptDt> myReasonNotGiven;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myReason, this.myReasonNotGiven});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myReason, this.myReasonNotGiven});
        }

        public List<CodeableConceptDt> getReason() {
            if (this.myReason == null) {
                this.myReason = new ArrayList<CodeableConceptDt>();
            }
            return this.myReason;
        }

        public Explanation setReason(List<CodeableConceptDt> theValue) {
            this.myReason = theValue;
            return this;
        }

        public CodeableConceptDt addReason() {
            CodeableConceptDt newType = new CodeableConceptDt();
            this.getReason().add(newType);
            return newType;
        }

        public Explanation addReason(CodeableConceptDt theValue) {
            if (theValue == null) {
                throw new NullPointerException("theValue must not be null");
            }
            this.getReason().add(theValue);
            return this;
        }

        public CodeableConceptDt getReasonFirstRep() {
            if (this.getReason().isEmpty()) {
                return this.addReason();
            }
            return this.getReason().get(0);
        }

        public List<CodeableConceptDt> getReasonNotGiven() {
            if (this.myReasonNotGiven == null) {
                this.myReasonNotGiven = new ArrayList<CodeableConceptDt>();
            }
            return this.myReasonNotGiven;
        }

        public Explanation setReasonNotGiven(List<CodeableConceptDt> theValue) {
            this.myReasonNotGiven = theValue;
            return this;
        }

        public CodeableConceptDt addReasonNotGiven() {
            CodeableConceptDt newType = new CodeableConceptDt();
            this.getReasonNotGiven().add(newType);
            return newType;
        }

        public Explanation addReasonNotGiven(CodeableConceptDt theValue) {
            if (theValue == null) {
                throw new NullPointerException("theValue must not be null");
            }
            this.getReasonNotGiven().add(theValue);
            return this;
        }

        public CodeableConceptDt getReasonNotGivenFirstRep() {
            if (this.getReasonNotGiven().isEmpty()) {
                return this.addReasonNotGiven();
            }
            return this.getReasonNotGiven().get(0);
        }
    }

    @Block
    public static class Reaction
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="date", type={DateTimeDt.class}, order=0, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Date of reaction to the immunization")
        private DateTimeDt myDate;
        @Child(name="detail", order=1, min=0, max=1, summary=false, modifier=false, type={Observation.class})
        @Description(shortDefinition="", formalDefinition="Details of the reaction")
        private ResourceReferenceDt myDetail;
        @Child(name="reported", type={BooleanDt.class}, order=2, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Self-reported indicator")
        private BooleanDt myReported;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myDate, this.myDetail, this.myReported});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myDate, this.myDetail, this.myReported});
        }

        public DateTimeDt getDateElement() {
            if (this.myDate == null) {
                this.myDate = new DateTimeDt();
            }
            return this.myDate;
        }

        public Date getDate() {
            return (Date)this.getDateElement().getValue();
        }

        public Reaction setDate(DateTimeDt theValue) {
            this.myDate = theValue;
            return this;
        }

        public Reaction setDateWithSecondsPrecision(Date theDate) {
            this.myDate = new DateTimeDt(theDate);
            return this;
        }

        public Reaction setDate(Date theDate, TemporalPrecisionEnum thePrecision) {
            this.myDate = new DateTimeDt(theDate, thePrecision);
            return this;
        }

        public ResourceReferenceDt getDetail() {
            if (this.myDetail == null) {
                this.myDetail = new ResourceReferenceDt();
            }
            return this.myDetail;
        }

        public Reaction setDetail(ResourceReferenceDt theValue) {
            this.myDetail = theValue;
            return this;
        }

        public BooleanDt getReportedElement() {
            if (this.myReported == null) {
                this.myReported = new BooleanDt();
            }
            return this.myReported;
        }

        public Boolean getReported() {
            return (Boolean)this.getReportedElement().getValue();
        }

        public Reaction setReported(BooleanDt theValue) {
            this.myReported = theValue;
            return this;
        }

        public Reaction setReported(boolean theBoolean) {
            this.myReported = new BooleanDt(theBoolean);
            return this;
        }
    }

    @Block
    public static class VaccinationProtocol
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="doseSequence", type={PositiveIntDt.class}, order=0, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Nominal position in a series")
        private PositiveIntDt myDoseSequence;
        @Child(name="description", type={StringDt.class}, order=1, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Contains the description about the protocol under which the vaccine was administered")
        private StringDt myDescription;
        @Child(name="authority", order=2, min=0, max=1, summary=false, modifier=false, type={Organization.class})
        @Description(shortDefinition="", formalDefinition="Indicates the authority who published the protocol.  E.g. ACIP")
        private ResourceReferenceDt myAuthority;
        @Child(name="series", type={StringDt.class}, order=3, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="One possible path to achieve presumed immunity against a disease - within the context of an authority")
        private StringDt mySeries;
        @Child(name="seriesDoses", type={PositiveIntDt.class}, order=4, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="The recommended number of doses to achieve immunity.")
        private PositiveIntDt mySeriesDoses;
        @Child(name="targetDisease", type={CodeableConceptDt.class}, order=5, min=1, max=-1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="The targeted disease")
        private List<CodeableConceptDt> myTargetDisease;
        @Child(name="doseStatus", type={CodeableConceptDt.class}, order=6, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Indicates if the immunization event should \"count\" against  the protocol.")
        private CodeableConceptDt myDoseStatus;
        @Child(name="doseStatusReason", type={CodeableConceptDt.class}, order=7, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Provides an explanation as to why an immunization event should or should not count against the protocol.")
        private CodeableConceptDt myDoseStatusReason;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myDoseSequence, this.myDescription, this.myAuthority, this.mySeries, this.mySeriesDoses, this.myTargetDisease, this.myDoseStatus, this.myDoseStatusReason});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myDoseSequence, this.myDescription, this.myAuthority, this.mySeries, this.mySeriesDoses, this.myTargetDisease, this.myDoseStatus, this.myDoseStatusReason});
        }

        public PositiveIntDt getDoseSequenceElement() {
            if (this.myDoseSequence == null) {
                this.myDoseSequence = new PositiveIntDt();
            }
            return this.myDoseSequence;
        }

        public Integer getDoseSequence() {
            return (Integer)this.getDoseSequenceElement().getValue();
        }

        public VaccinationProtocol setDoseSequence(PositiveIntDt theValue) {
            this.myDoseSequence = theValue;
            return this;
        }

        public VaccinationProtocol setDoseSequence(int theInteger) {
            this.myDoseSequence = new PositiveIntDt(theInteger);
            return this;
        }

        public StringDt getDescriptionElement() {
            if (this.myDescription == null) {
                this.myDescription = new StringDt();
            }
            return this.myDescription;
        }

        public String getDescription() {
            return (String)this.getDescriptionElement().getValue();
        }

        public VaccinationProtocol setDescription(StringDt theValue) {
            this.myDescription = theValue;
            return this;
        }

        public VaccinationProtocol setDescription(String theString) {
            this.myDescription = new StringDt(theString);
            return this;
        }

        public ResourceReferenceDt getAuthority() {
            if (this.myAuthority == null) {
                this.myAuthority = new ResourceReferenceDt();
            }
            return this.myAuthority;
        }

        public VaccinationProtocol setAuthority(ResourceReferenceDt theValue) {
            this.myAuthority = theValue;
            return this;
        }

        public StringDt getSeriesElement() {
            if (this.mySeries == null) {
                this.mySeries = new StringDt();
            }
            return this.mySeries;
        }

        public String getSeries() {
            return (String)this.getSeriesElement().getValue();
        }

        public VaccinationProtocol setSeries(StringDt theValue) {
            this.mySeries = theValue;
            return this;
        }

        public VaccinationProtocol setSeries(String theString) {
            this.mySeries = new StringDt(theString);
            return this;
        }

        public PositiveIntDt getSeriesDosesElement() {
            if (this.mySeriesDoses == null) {
                this.mySeriesDoses = new PositiveIntDt();
            }
            return this.mySeriesDoses;
        }

        public Integer getSeriesDoses() {
            return (Integer)this.getSeriesDosesElement().getValue();
        }

        public VaccinationProtocol setSeriesDoses(PositiveIntDt theValue) {
            this.mySeriesDoses = theValue;
            return this;
        }

        public VaccinationProtocol setSeriesDoses(int theInteger) {
            this.mySeriesDoses = new PositiveIntDt(theInteger);
            return this;
        }

        public List<CodeableConceptDt> getTargetDisease() {
            if (this.myTargetDisease == null) {
                this.myTargetDisease = new ArrayList<CodeableConceptDt>();
            }
            return this.myTargetDisease;
        }

        public VaccinationProtocol setTargetDisease(List<CodeableConceptDt> theValue) {
            this.myTargetDisease = theValue;
            return this;
        }

        public CodeableConceptDt addTargetDisease() {
            CodeableConceptDt newType = new CodeableConceptDt();
            this.getTargetDisease().add(newType);
            return newType;
        }

        public VaccinationProtocol addTargetDisease(CodeableConceptDt theValue) {
            if (theValue == null) {
                throw new NullPointerException("theValue must not be null");
            }
            this.getTargetDisease().add(theValue);
            return this;
        }

        public CodeableConceptDt getTargetDiseaseFirstRep() {
            if (this.getTargetDisease().isEmpty()) {
                return this.addTargetDisease();
            }
            return this.getTargetDisease().get(0);
        }

        public CodeableConceptDt getDoseStatus() {
            if (this.myDoseStatus == null) {
                this.myDoseStatus = new CodeableConceptDt();
            }
            return this.myDoseStatus;
        }

        public VaccinationProtocol setDoseStatus(CodeableConceptDt theValue) {
            this.myDoseStatus = theValue;
            return this;
        }

        public CodeableConceptDt getDoseStatusReason() {
            if (this.myDoseStatusReason == null) {
                this.myDoseStatusReason = new CodeableConceptDt();
            }
            return this.myDoseStatusReason;
        }

        public VaccinationProtocol setDoseStatusReason(CodeableConceptDt theValue) {
            this.myDoseStatusReason = theValue;
            return this;
        }
    }
}

