/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu2.resource;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.model.api.BaseIdentifiableElement;
import ca.uhn.fhir.model.api.IDatatype;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.IResourceBlock;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.TemporalPrecisionEnum;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.model.dstu2.composite.ContactPointDt;
import ca.uhn.fhir.model.dstu2.composite.ResourceReferenceDt;
import ca.uhn.fhir.model.dstu2.resource.BaseResource;
import ca.uhn.fhir.model.dstu2.resource.StructureDefinition;
import ca.uhn.fhir.model.dstu2.resource.ValueSet;
import ca.uhn.fhir.model.dstu2.valueset.BindingStrengthEnum;
import ca.uhn.fhir.model.dstu2.valueset.ConformanceResourceStatusEnum;
import ca.uhn.fhir.model.dstu2.valueset.OperationKindEnum;
import ca.uhn.fhir.model.dstu2.valueset.OperationParameterUseEnum;
import ca.uhn.fhir.model.dstu2.valueset.ResourceTypeEnum;
import ca.uhn.fhir.model.primitive.BooleanDt;
import ca.uhn.fhir.model.primitive.BoundCodeDt;
import ca.uhn.fhir.model.primitive.CodeDt;
import ca.uhn.fhir.model.primitive.DateTimeDt;
import ca.uhn.fhir.model.primitive.IntegerDt;
import ca.uhn.fhir.model.primitive.StringDt;
import ca.uhn.fhir.model.primitive.UriDt;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.rest.gclient.UriClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@ResourceDef(name="OperationDefinition", profile="http://hl7.org/fhir/profiles/OperationDefinition", id="operationdefinition")
public class OperationDefinition
extends BaseResource
implements IResource {
    @SearchParamDefinition(name="url", path="OperationDefinition.url", description="", type="uri")
    public static final String SP_URL = "url";
    public static final UriClientParam URL = new UriClientParam("url");
    @SearchParamDefinition(name="version", path="OperationDefinition.version", description="", type="token")
    public static final String SP_VERSION = "version";
    public static final TokenClientParam VERSION = new TokenClientParam("version");
    @SearchParamDefinition(name="name", path="OperationDefinition.name", description="", type="string")
    public static final String SP_NAME = "name";
    public static final StringClientParam NAME = new StringClientParam("name");
    @SearchParamDefinition(name="publisher", path="OperationDefinition.publisher", description="", type="string")
    public static final String SP_PUBLISHER = "publisher";
    public static final StringClientParam PUBLISHER = new StringClientParam("publisher");
    @SearchParamDefinition(name="code", path="OperationDefinition.code", description="", type="token")
    public static final String SP_CODE = "code";
    public static final TokenClientParam CODE = new TokenClientParam("code");
    @SearchParamDefinition(name="status", path="OperationDefinition.status", description="", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");
    @SearchParamDefinition(name="date", path="OperationDefinition.date", description="", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="kind", path="OperationDefinition.kind", description="", type="token")
    public static final String SP_KIND = "kind";
    public static final TokenClientParam KIND = new TokenClientParam("kind");
    @SearchParamDefinition(name="base", path="OperationDefinition.base", description="", type="reference")
    public static final String SP_BASE = "base";
    public static final ReferenceClientParam BASE = new ReferenceClientParam("base");
    @SearchParamDefinition(name="system", path="OperationDefinition.system", description="", type="token")
    public static final String SP_SYSTEM = "system";
    public static final TokenClientParam SYSTEM = new TokenClientParam("system");
    @SearchParamDefinition(name="type", path="OperationDefinition.type", description="", type="token")
    public static final String SP_TYPE = "type";
    public static final TokenClientParam TYPE = new TokenClientParam("type");
    @SearchParamDefinition(name="instance", path="OperationDefinition.instance", description="", type="token")
    public static final String SP_INSTANCE = "instance";
    public static final TokenClientParam INSTANCE = new TokenClientParam("instance");
    @SearchParamDefinition(name="profile", path="OperationDefinition.parameter.profile", description="", type="reference")
    public static final String SP_PROFILE = "profile";
    public static final ReferenceClientParam PROFILE = new ReferenceClientParam("profile");
    public static final Include INCLUDE_BASE = new Include("OperationDefinition:base");
    public static final Include INCLUDE_PROFILE = new Include("OperationDefinition:profile");
    @Child(name="url", type={UriDt.class}, order=0, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="id", formalDefinition="An absolute URL that is used to identify this operation definition when it is referenced in a specification, model, design or an instance. This SHALL be a URL, SHOULD be globally unique, and SHOULD be an address at which this operation definition is (or will be) published")
    private UriDt myUrl;
    @Child(name="version", type={StringDt.class}, order=1, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="id.version", formalDefinition="The identifier that is used to identify this version of the profile when it is referenced in a specification, model, design or instance. This is an arbitrary value managed by the profile author manually and the value should be a timestamp")
    private StringDt myVersion;
    @Child(name="name", type={StringDt.class}, order=2, min=1, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="A free text natural language name identifying the operation")
    private StringDt myName;
    @Child(name="status", type={CodeDt.class}, order=3, min=1, max=1, summary=false, modifier=false)
    @Description(shortDefinition="status", formalDefinition="The status of the profile")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/conformance-resource-status")
    private BoundCodeDt<ConformanceResourceStatusEnum> myStatus;
    @Child(name="kind", type={CodeDt.class}, order=4, min=1, max=1, summary=false, modifier=false)
    @Description(shortDefinition="class", formalDefinition="Whether this is an operation or a named query")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/operation-kind")
    private BoundCodeDt<OperationKindEnum> myKind;
    @Child(name="experimental", type={BooleanDt.class}, order=5, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="This profile was authored for testing purposes (or education/evaluation/marketing), and is not intended to be used for genuine usage")
    private BooleanDt myExperimental;
    @Child(name="publisher", type={StringDt.class}, order=6, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="who.witness", formalDefinition="The name of the individual or organization that published the operation definition")
    private StringDt myPublisher;
    @Child(name="contact", order=7, min=0, max=-1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="Contacts to assist a user in finding and communicating with the publisher")
    private List<Contact> myContact;
    @Child(name="date", type={DateTimeDt.class}, order=8, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="when.recorded", formalDefinition="The date this version of the operation definition was published. The date must change when the business version changes, if it does, and it must change if the status code changes. In addition, it should change when the substantive content of the Operation Definition changes")
    private DateTimeDt myDate;
    @Child(name="description", type={StringDt.class}, order=9, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="A free text natural language description of the profile and its use")
    private StringDt myDescription;
    @Child(name="requirements", type={StringDt.class}, order=10, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="Explains why this operation definition is needed and why it's been constrained as it has")
    private StringDt myRequirements;
    @Child(name="idempotent", type={BooleanDt.class}, order=11, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="Operations that are idempotent (see [HTTP specification definition of idempotent](http://www.w3.org/Protocols/rfc2616/rfc2616-sec9.html)) may be invoked by performing an HTTP GET operation instead of a POST")
    private BooleanDt myIdempotent;
    @Child(name="code", type={CodeDt.class}, order=12, min=1, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="The name used to invoke the operation")
    private CodeDt myCode;
    @Child(name="notes", type={StringDt.class}, order=13, min=0, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="Additional information about how to use this operation or named query")
    private StringDt myNotes;
    @Child(name="base", order=14, min=0, max=1, summary=false, modifier=false, type={OperationDefinition.class})
    @Description(shortDefinition="", formalDefinition="Indicates that this operation definition is a constraining profile on the base")
    private ResourceReferenceDt myBase;
    @Child(name="system", type={BooleanDt.class}, order=15, min=1, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="Indicates whether this operation or named query can be invoked at the system level (e.g. without needing to choose a resource type for the context)")
    private BooleanDt mySystem;
    @Child(name="type", type={CodeDt.class}, order=16, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="Indicates whether this operation or named query can be invoked at the resource type level for any given resource type level (e.g. without needing to choose a resource type for the context)")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/resource-types")
    private List<BoundCodeDt<ResourceTypeEnum>> myType;
    @Child(name="instance", type={BooleanDt.class}, order=17, min=1, max=1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="Indicates whether this operation can be invoked on a particular instance of one of the given types")
    private BooleanDt myInstance;
    @Child(name="parameter", order=18, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="The parameters for the operation/query")
    private List<Parameter> myParameter;

    public boolean isEmpty() {
        return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myUrl, this.myVersion, this.myName, this.myStatus, this.myKind, this.myExperimental, this.myPublisher, this.myContact, this.myDate, this.myDescription, this.myRequirements, this.myIdempotent, this.myCode, this.myNotes, this.myBase, this.mySystem, this.myType, this.myInstance, this.myParameter});
    }

    public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
        return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myUrl, this.myVersion, this.myName, this.myStatus, this.myKind, this.myExperimental, this.myPublisher, this.myContact, this.myDate, this.myDescription, this.myRequirements, this.myIdempotent, this.myCode, this.myNotes, this.myBase, this.mySystem, this.myType, this.myInstance, this.myParameter});
    }

    public UriDt getUrlElement() {
        if (this.myUrl == null) {
            this.myUrl = new UriDt();
        }
        return this.myUrl;
    }

    public String getUrl() {
        return (String)this.getUrlElement().getValue();
    }

    public OperationDefinition setUrl(UriDt theValue) {
        this.myUrl = theValue;
        return this;
    }

    public OperationDefinition setUrl(String theUri) {
        this.myUrl = new UriDt(theUri);
        return this;
    }

    public StringDt getVersionElement() {
        if (this.myVersion == null) {
            this.myVersion = new StringDt();
        }
        return this.myVersion;
    }

    public String getVersion() {
        return (String)this.getVersionElement().getValue();
    }

    public OperationDefinition setVersion(StringDt theValue) {
        this.myVersion = theValue;
        return this;
    }

    public OperationDefinition setVersion(String theString) {
        this.myVersion = new StringDt(theString);
        return this;
    }

    public StringDt getNameElement() {
        if (this.myName == null) {
            this.myName = new StringDt();
        }
        return this.myName;
    }

    public String getName() {
        return (String)this.getNameElement().getValue();
    }

    public OperationDefinition setName(StringDt theValue) {
        this.myName = theValue;
        return this;
    }

    public OperationDefinition setName(String theString) {
        this.myName = new StringDt(theString);
        return this;
    }

    public BoundCodeDt<ConformanceResourceStatusEnum> getStatusElement() {
        if (this.myStatus == null) {
            this.myStatus = new BoundCodeDt(ConformanceResourceStatusEnum.VALUESET_BINDER);
        }
        return this.myStatus;
    }

    public String getStatus() {
        return (String)this.getStatusElement().getValue();
    }

    public OperationDefinition setStatus(BoundCodeDt<ConformanceResourceStatusEnum> theValue) {
        this.myStatus = theValue;
        return this;
    }

    public OperationDefinition setStatus(ConformanceResourceStatusEnum theValue) {
        this.setStatus((BoundCodeDt<ConformanceResourceStatusEnum>)new BoundCodeDt(ConformanceResourceStatusEnum.VALUESET_BINDER, (Enum)theValue));
        return this;
    }

    public BoundCodeDt<OperationKindEnum> getKindElement() {
        if (this.myKind == null) {
            this.myKind = new BoundCodeDt(OperationKindEnum.VALUESET_BINDER);
        }
        return this.myKind;
    }

    public String getKind() {
        return (String)this.getKindElement().getValue();
    }

    public OperationDefinition setKind(BoundCodeDt<OperationKindEnum> theValue) {
        this.myKind = theValue;
        return this;
    }

    public OperationDefinition setKind(OperationKindEnum theValue) {
        this.setKind((BoundCodeDt<OperationKindEnum>)new BoundCodeDt(OperationKindEnum.VALUESET_BINDER, (Enum)theValue));
        return this;
    }

    public BooleanDt getExperimentalElement() {
        if (this.myExperimental == null) {
            this.myExperimental = new BooleanDt();
        }
        return this.myExperimental;
    }

    public Boolean getExperimental() {
        return (Boolean)this.getExperimentalElement().getValue();
    }

    public OperationDefinition setExperimental(BooleanDt theValue) {
        this.myExperimental = theValue;
        return this;
    }

    public OperationDefinition setExperimental(boolean theBoolean) {
        this.myExperimental = new BooleanDt(theBoolean);
        return this;
    }

    public StringDt getPublisherElement() {
        if (this.myPublisher == null) {
            this.myPublisher = new StringDt();
        }
        return this.myPublisher;
    }

    public String getPublisher() {
        return (String)this.getPublisherElement().getValue();
    }

    public OperationDefinition setPublisher(StringDt theValue) {
        this.myPublisher = theValue;
        return this;
    }

    public OperationDefinition setPublisher(String theString) {
        this.myPublisher = new StringDt(theString);
        return this;
    }

    public List<Contact> getContact() {
        if (this.myContact == null) {
            this.myContact = new ArrayList<Contact>();
        }
        return this.myContact;
    }

    public OperationDefinition setContact(List<Contact> theValue) {
        this.myContact = theValue;
        return this;
    }

    public Contact addContact() {
        Contact newType = new Contact();
        this.getContact().add(newType);
        return newType;
    }

    public OperationDefinition addContact(Contact theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getContact().add(theValue);
        return this;
    }

    public Contact getContactFirstRep() {
        if (this.getContact().isEmpty()) {
            return this.addContact();
        }
        return this.getContact().get(0);
    }

    public DateTimeDt getDateElement() {
        if (this.myDate == null) {
            this.myDate = new DateTimeDt();
        }
        return this.myDate;
    }

    public Date getDate() {
        return (Date)this.getDateElement().getValue();
    }

    public OperationDefinition setDate(DateTimeDt theValue) {
        this.myDate = theValue;
        return this;
    }

    public OperationDefinition setDateWithSecondsPrecision(Date theDate) {
        this.myDate = new DateTimeDt(theDate);
        return this;
    }

    public OperationDefinition setDate(Date theDate, TemporalPrecisionEnum thePrecision) {
        this.myDate = new DateTimeDt(theDate, thePrecision);
        return this;
    }

    public StringDt getDescriptionElement() {
        if (this.myDescription == null) {
            this.myDescription = new StringDt();
        }
        return this.myDescription;
    }

    public String getDescription() {
        return (String)this.getDescriptionElement().getValue();
    }

    public OperationDefinition setDescription(StringDt theValue) {
        this.myDescription = theValue;
        return this;
    }

    public OperationDefinition setDescription(String theString) {
        this.myDescription = new StringDt(theString);
        return this;
    }

    public StringDt getRequirementsElement() {
        if (this.myRequirements == null) {
            this.myRequirements = new StringDt();
        }
        return this.myRequirements;
    }

    public String getRequirements() {
        return (String)this.getRequirementsElement().getValue();
    }

    public OperationDefinition setRequirements(StringDt theValue) {
        this.myRequirements = theValue;
        return this;
    }

    public OperationDefinition setRequirements(String theString) {
        this.myRequirements = new StringDt(theString);
        return this;
    }

    public BooleanDt getIdempotentElement() {
        if (this.myIdempotent == null) {
            this.myIdempotent = new BooleanDt();
        }
        return this.myIdempotent;
    }

    public Boolean getIdempotent() {
        return (Boolean)this.getIdempotentElement().getValue();
    }

    public OperationDefinition setIdempotent(BooleanDt theValue) {
        this.myIdempotent = theValue;
        return this;
    }

    public OperationDefinition setIdempotent(boolean theBoolean) {
        this.myIdempotent = new BooleanDt(theBoolean);
        return this;
    }

    public CodeDt getCodeElement() {
        if (this.myCode == null) {
            this.myCode = new CodeDt();
        }
        return this.myCode;
    }

    public String getCode() {
        return (String)this.getCodeElement().getValue();
    }

    public OperationDefinition setCode(CodeDt theValue) {
        this.myCode = theValue;
        return this;
    }

    public OperationDefinition setCode(String theCode) {
        this.myCode = new CodeDt(theCode);
        return this;
    }

    public StringDt getNotesElement() {
        if (this.myNotes == null) {
            this.myNotes = new StringDt();
        }
        return this.myNotes;
    }

    public String getNotes() {
        return (String)this.getNotesElement().getValue();
    }

    public OperationDefinition setNotes(StringDt theValue) {
        this.myNotes = theValue;
        return this;
    }

    public OperationDefinition setNotes(String theString) {
        this.myNotes = new StringDt(theString);
        return this;
    }

    public ResourceReferenceDt getBase() {
        if (this.myBase == null) {
            this.myBase = new ResourceReferenceDt();
        }
        return this.myBase;
    }

    public OperationDefinition setBase(ResourceReferenceDt theValue) {
        this.myBase = theValue;
        return this;
    }

    public BooleanDt getSystemElement() {
        if (this.mySystem == null) {
            this.mySystem = new BooleanDt();
        }
        return this.mySystem;
    }

    public Boolean getSystem() {
        return (Boolean)this.getSystemElement().getValue();
    }

    public OperationDefinition setSystem(BooleanDt theValue) {
        this.mySystem = theValue;
        return this;
    }

    public OperationDefinition setSystem(boolean theBoolean) {
        this.mySystem = new BooleanDt(theBoolean);
        return this;
    }

    public List<BoundCodeDt<ResourceTypeEnum>> getType() {
        if (this.myType == null) {
            this.myType = new ArrayList<BoundCodeDt<ResourceTypeEnum>>();
        }
        return this.myType;
    }

    public OperationDefinition setType(List<BoundCodeDt<ResourceTypeEnum>> theValue) {
        this.myType = theValue;
        return this;
    }

    public BoundCodeDt<ResourceTypeEnum> addType(ResourceTypeEnum theValue) {
        BoundCodeDt retVal = new BoundCodeDt(ResourceTypeEnum.VALUESET_BINDER, (Enum)theValue);
        this.getType().add((BoundCodeDt<ResourceTypeEnum>)retVal);
        return retVal;
    }

    public BoundCodeDt<ResourceTypeEnum> getTypeFirstRep() {
        if (this.getType().size() == 0) {
            this.addType();
        }
        return this.getType().get(0);
    }

    public BoundCodeDt<ResourceTypeEnum> addType() {
        BoundCodeDt retVal = new BoundCodeDt(ResourceTypeEnum.VALUESET_BINDER);
        this.getType().add((BoundCodeDt<ResourceTypeEnum>)retVal);
        return retVal;
    }

    public OperationDefinition setType(ResourceTypeEnum theValue) {
        this.getType().clear();
        this.addType(theValue);
        return this;
    }

    public BooleanDt getInstanceElement() {
        if (this.myInstance == null) {
            this.myInstance = new BooleanDt();
        }
        return this.myInstance;
    }

    public Boolean getInstance() {
        return (Boolean)this.getInstanceElement().getValue();
    }

    public OperationDefinition setInstance(BooleanDt theValue) {
        this.myInstance = theValue;
        return this;
    }

    public OperationDefinition setInstance(boolean theBoolean) {
        this.myInstance = new BooleanDt(theBoolean);
        return this;
    }

    public List<Parameter> getParameter() {
        if (this.myParameter == null) {
            this.myParameter = new ArrayList<Parameter>();
        }
        return this.myParameter;
    }

    public OperationDefinition setParameter(List<Parameter> theValue) {
        this.myParameter = theValue;
        return this;
    }

    public Parameter addParameter() {
        Parameter newType = new Parameter();
        this.getParameter().add(newType);
        return newType;
    }

    public OperationDefinition addParameter(Parameter theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getParameter().add(theValue);
        return this;
    }

    public Parameter getParameterFirstRep() {
        if (this.getParameter().isEmpty()) {
            return this.addParameter();
        }
        return this.getParameter().get(0);
    }

    public String getResourceName() {
        return "OperationDefinition";
    }

    public FhirVersionEnum getStructureFhirVersionEnum() {
        return FhirVersionEnum.DSTU2;
    }

    @Block
    public static class Contact
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="name", type={StringDt.class}, order=0, min=0, max=1, summary=true, modifier=false)
        @Description(shortDefinition="", formalDefinition="The name of an individual to contact regarding the operation definition")
        private StringDt myName;
        @Child(name="telecom", type={ContactPointDt.class}, order=1, min=0, max=-1, summary=true, modifier=false)
        @Description(shortDefinition="", formalDefinition="Contact details for individual (if a name was provided) or the publisher")
        private List<ContactPointDt> myTelecom;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myName, this.myTelecom});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myName, this.myTelecom});
        }

        public StringDt getNameElement() {
            if (this.myName == null) {
                this.myName = new StringDt();
            }
            return this.myName;
        }

        public String getName() {
            return (String)this.getNameElement().getValue();
        }

        public Contact setName(StringDt theValue) {
            this.myName = theValue;
            return this;
        }

        public Contact setName(String theString) {
            this.myName = new StringDt(theString);
            return this;
        }

        public List<ContactPointDt> getTelecom() {
            if (this.myTelecom == null) {
                this.myTelecom = new ArrayList<ContactPointDt>();
            }
            return this.myTelecom;
        }

        public Contact setTelecom(List<ContactPointDt> theValue) {
            this.myTelecom = theValue;
            return this;
        }

        public ContactPointDt addTelecom() {
            ContactPointDt newType = new ContactPointDt();
            this.getTelecom().add(newType);
            return newType;
        }

        public Contact addTelecom(ContactPointDt theValue) {
            if (theValue == null) {
                throw new NullPointerException("theValue must not be null");
            }
            this.getTelecom().add(theValue);
            return this;
        }

        public ContactPointDt getTelecomFirstRep() {
            if (this.getTelecom().isEmpty()) {
                return this.addTelecom();
            }
            return this.getTelecom().get(0);
        }
    }

    @Block
    public static class Parameter
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="name", type={CodeDt.class}, order=0, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="The name of used to identify the parameter")
        private CodeDt myName;
        @Child(name="use", type={CodeDt.class}, order=1, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Whether this is an input or an output parameter")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/operation-parameter-use")
        private BoundCodeDt<OperationParameterUseEnum> myUse;
        @Child(name="min", type={IntegerDt.class}, order=2, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="The minimum number of times this parameter SHALL appear in the request or response")
        private IntegerDt myMin;
        @Child(name="max", type={StringDt.class}, order=3, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="The maximum number of times this element is permitted to appear in the request or response")
        private StringDt myMax;
        @Child(name="documentation", type={StringDt.class}, order=4, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Describes the meaning or use of this parameter")
        private StringDt myDocumentation;
        @Child(name="type", type={CodeDt.class}, order=5, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="The type for this parameter")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/valueset-operation-parameter-type")
        private CodeDt myType;
        @Child(name="profile", order=6, min=0, max=1, summary=false, modifier=false, type={StructureDefinition.class})
        @Description(shortDefinition="", formalDefinition="A profile the specifies the rules that this parameter must conform to")
        private ResourceReferenceDt myProfile;
        @Child(name="binding", order=7, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Binds to a value set if this parameter is coded (code, Coding, CodeableConcept)")
        private ParameterBinding myBinding;
        @Child(name="part", type={Parameter.class}, order=8, min=0, max=-1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="The parts of a Tuple Parameter")
        private List<Parameter> myPart;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myName, this.myUse, this.myMin, this.myMax, this.myDocumentation, this.myType, this.myProfile, this.myBinding, this.myPart});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myName, this.myUse, this.myMin, this.myMax, this.myDocumentation, this.myType, this.myProfile, this.myBinding, this.myPart});
        }

        public CodeDt getNameElement() {
            if (this.myName == null) {
                this.myName = new CodeDt();
            }
            return this.myName;
        }

        public String getName() {
            return (String)this.getNameElement().getValue();
        }

        public Parameter setName(CodeDt theValue) {
            this.myName = theValue;
            return this;
        }

        public Parameter setName(String theCode) {
            this.myName = new CodeDt(theCode);
            return this;
        }

        public BoundCodeDt<OperationParameterUseEnum> getUseElement() {
            if (this.myUse == null) {
                this.myUse = new BoundCodeDt(OperationParameterUseEnum.VALUESET_BINDER);
            }
            return this.myUse;
        }

        public String getUse() {
            return (String)this.getUseElement().getValue();
        }

        public Parameter setUse(BoundCodeDt<OperationParameterUseEnum> theValue) {
            this.myUse = theValue;
            return this;
        }

        public Parameter setUse(OperationParameterUseEnum theValue) {
            this.setUse((BoundCodeDt<OperationParameterUseEnum>)new BoundCodeDt(OperationParameterUseEnum.VALUESET_BINDER, (Enum)theValue));
            return this;
        }

        public IntegerDt getMinElement() {
            if (this.myMin == null) {
                this.myMin = new IntegerDt();
            }
            return this.myMin;
        }

        public Integer getMin() {
            return (Integer)this.getMinElement().getValue();
        }

        public Parameter setMin(IntegerDt theValue) {
            this.myMin = theValue;
            return this;
        }

        public Parameter setMin(int theInteger) {
            this.myMin = new IntegerDt(theInteger);
            return this;
        }

        public StringDt getMaxElement() {
            if (this.myMax == null) {
                this.myMax = new StringDt();
            }
            return this.myMax;
        }

        public String getMax() {
            return (String)this.getMaxElement().getValue();
        }

        public Parameter setMax(StringDt theValue) {
            this.myMax = theValue;
            return this;
        }

        public Parameter setMax(String theString) {
            this.myMax = new StringDt(theString);
            return this;
        }

        public StringDt getDocumentationElement() {
            if (this.myDocumentation == null) {
                this.myDocumentation = new StringDt();
            }
            return this.myDocumentation;
        }

        public String getDocumentation() {
            return (String)this.getDocumentationElement().getValue();
        }

        public Parameter setDocumentation(StringDt theValue) {
            this.myDocumentation = theValue;
            return this;
        }

        public Parameter setDocumentation(String theString) {
            this.myDocumentation = new StringDt(theString);
            return this;
        }

        public CodeDt getTypeElement() {
            if (this.myType == null) {
                this.myType = new CodeDt();
            }
            return this.myType;
        }

        public String getType() {
            return (String)this.getTypeElement().getValue();
        }

        public Parameter setType(CodeDt theValue) {
            this.myType = theValue;
            return this;
        }

        public Parameter setType(String theCode) {
            this.myType = new CodeDt(theCode);
            return this;
        }

        public ResourceReferenceDt getProfile() {
            if (this.myProfile == null) {
                this.myProfile = new ResourceReferenceDt();
            }
            return this.myProfile;
        }

        public Parameter setProfile(ResourceReferenceDt theValue) {
            this.myProfile = theValue;
            return this;
        }

        public ParameterBinding getBinding() {
            if (this.myBinding == null) {
                this.myBinding = new ParameterBinding();
            }
            return this.myBinding;
        }

        public Parameter setBinding(ParameterBinding theValue) {
            this.myBinding = theValue;
            return this;
        }

        public List<Parameter> getPart() {
            if (this.myPart == null) {
                this.myPart = new ArrayList<Parameter>();
            }
            return this.myPart;
        }

        public Parameter setPart(List<Parameter> theValue) {
            this.myPart = theValue;
            return this;
        }

        public Parameter addPart() {
            Parameter newType = new Parameter();
            this.getPart().add(newType);
            return newType;
        }

        public Parameter addPart(Parameter theValue) {
            if (theValue == null) {
                throw new NullPointerException("theValue must not be null");
            }
            this.getPart().add(theValue);
            return this;
        }

        public Parameter getPartFirstRep() {
            if (this.getPart().isEmpty()) {
                return this.addPart();
            }
            return this.getPart().get(0);
        }
    }

    @Block
    public static class ParameterBinding
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="strength", type={CodeDt.class}, order=0, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Indicates the degree of conformance expectations associated with this binding - that is, the degree to which the provided value set must be adhered to in the instances")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/binding-strength")
        private BoundCodeDt<BindingStrengthEnum> myStrength;
        @Child(name="valueSet", order=1, min=1, max=1, summary=false, modifier=false, type={UriDt.class, ValueSet.class})
        @Description(shortDefinition="", formalDefinition="Points to the value set or external definition (e.g. implicit value set) that identifies the set of codes to be used")
        private IDatatype myValueSet;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myStrength, this.myValueSet});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myStrength, this.myValueSet});
        }

        public BoundCodeDt<BindingStrengthEnum> getStrengthElement() {
            if (this.myStrength == null) {
                this.myStrength = new BoundCodeDt(BindingStrengthEnum.VALUESET_BINDER);
            }
            return this.myStrength;
        }

        public String getStrength() {
            return (String)this.getStrengthElement().getValue();
        }

        public ParameterBinding setStrength(BoundCodeDt<BindingStrengthEnum> theValue) {
            this.myStrength = theValue;
            return this;
        }

        public ParameterBinding setStrength(BindingStrengthEnum theValue) {
            this.setStrength((BoundCodeDt<BindingStrengthEnum>)new BoundCodeDt(BindingStrengthEnum.VALUESET_BINDER, (Enum)theValue));
            return this;
        }

        public IDatatype getValueSet() {
            return this.myValueSet;
        }

        public ParameterBinding setValueSet(IDatatype theValue) {
            this.myValueSet = theValue;
            return this;
        }
    }
}

