/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu2.valueset;

import ca.uhn.fhir.model.api.IValueSetEnumBinder;
import java.util.HashMap;
import java.util.Map;

public enum MessageEventEnum {
    MEDICATIONADMINISTRATION_COMPLETE("MedicationAdministration-Complete", "http://hl7.org/fhir/message-events"),
    MEDICATIONADMINISTRATION_NULLIFICATION("MedicationAdministration-Nullification", "http://hl7.org/fhir/message-events"),
    MEDICATIONADMINISTRATION_RECORDING("MedicationAdministration-Recording", "http://hl7.org/fhir/message-events"),
    MEDICATIONADMINISTRATION_UPDATE("MedicationAdministration-Update", "http://hl7.org/fhir/message-events"),
    ADMIN_NOTIFY("admin-notify", "http://hl7.org/fhir/message-events"),
    DIAGNOSTICREPORT_PROVIDE("diagnosticreport-provide", "http://hl7.org/fhir/message-events"),
    OBSERVATION_PROVIDE("observation-provide", "http://hl7.org/fhir/message-events"),
    PATIENT_LINK("patient-link", "http://hl7.org/fhir/message-events"),
    PATIENT_UNLINK("patient-unlink", "http://hl7.org/fhir/message-events"),
    VALUESET_EXPAND("valueset-expand", "http://hl7.org/fhir/message-events");

    public static final String VALUESET_IDENTIFIER = "";
    public static final String VALUESET_NAME = "MessageEvent";
    private static Map<String, MessageEventEnum> CODE_TO_ENUM;
    private static Map<String, Map<String, MessageEventEnum>> SYSTEM_TO_CODE_TO_ENUM;
    private final String myCode;
    private final String mySystem;
    public static final IValueSetEnumBinder<MessageEventEnum> VALUESET_BINDER;

    public String getCode() {
        return this.myCode;
    }

    public String getSystem() {
        return this.mySystem;
    }

    public static MessageEventEnum forCode(String theCode) {
        MessageEventEnum retVal = CODE_TO_ENUM.get(theCode);
        return retVal;
    }

    private MessageEventEnum(String theCode, String theSystem) {
        this.myCode = theCode;
        this.mySystem = theSystem;
    }

    static {
        CODE_TO_ENUM = new HashMap<String, MessageEventEnum>();
        SYSTEM_TO_CODE_TO_ENUM = new HashMap<String, Map<String, MessageEventEnum>>();
        for (MessageEventEnum next : MessageEventEnum.values()) {
            CODE_TO_ENUM.put(next.getCode(), next);
            if (!SYSTEM_TO_CODE_TO_ENUM.containsKey(next.getSystem())) {
                SYSTEM_TO_CODE_TO_ENUM.put(next.getSystem(), new HashMap());
            }
            SYSTEM_TO_CODE_TO_ENUM.get(next.getSystem()).put(next.getCode(), next);
        }
        VALUESET_BINDER = new IValueSetEnumBinder<MessageEventEnum>(){

            public String toCodeString(MessageEventEnum theEnum) {
                return theEnum.getCode();
            }

            public String toSystemString(MessageEventEnum theEnum) {
                return theEnum.getSystem();
            }

            public MessageEventEnum fromCodeString(String theCodeString) {
                return CODE_TO_ENUM.get(theCodeString);
            }

            public MessageEventEnum fromCodeString(String theCodeString, String theSystemString) {
                Map<String, MessageEventEnum> map = SYSTEM_TO_CODE_TO_ENUM.get(theSystemString);
                if (map == null) {
                    return null;
                }
                return map.get(theCodeString);
            }
        };
    }
}

