/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu2.valueset;

import ca.uhn.fhir.model.api.IValueSetEnumBinder;
import java.util.HashMap;
import java.util.Map;

public enum IdentifierUseEnum {
    USUAL("usual", "http://hl7.org/fhir/identifier-use"),
    OFFICIAL("official", "http://hl7.org/fhir/identifier-use"),
    TEMP("temp", "http://hl7.org/fhir/identifier-use"),
    SECONDARY("secondary", "http://hl7.org/fhir/identifier-use");

    public static final String VALUESET_IDENTIFIER = "";
    public static final String VALUESET_NAME = "IdentifierUse";
    private static Map<String, IdentifierUseEnum> CODE_TO_ENUM;
    private static Map<String, Map<String, IdentifierUseEnum>> SYSTEM_TO_CODE_TO_ENUM;
    private final String myCode;
    private final String mySystem;
    public static final IValueSetEnumBinder<IdentifierUseEnum> VALUESET_BINDER;

    public String getCode() {
        return this.myCode;
    }

    public String getSystem() {
        return this.mySystem;
    }

    public static IdentifierUseEnum forCode(String theCode) {
        IdentifierUseEnum retVal = CODE_TO_ENUM.get(theCode);
        return retVal;
    }

    private IdentifierUseEnum(String theCode, String theSystem) {
        this.myCode = theCode;
        this.mySystem = theSystem;
    }

    static {
        CODE_TO_ENUM = new HashMap<String, IdentifierUseEnum>();
        SYSTEM_TO_CODE_TO_ENUM = new HashMap<String, Map<String, IdentifierUseEnum>>();
        for (IdentifierUseEnum next : IdentifierUseEnum.values()) {
            CODE_TO_ENUM.put(next.getCode(), next);
            if (!SYSTEM_TO_CODE_TO_ENUM.containsKey(next.getSystem())) {
                SYSTEM_TO_CODE_TO_ENUM.put(next.getSystem(), new HashMap());
            }
            SYSTEM_TO_CODE_TO_ENUM.get(next.getSystem()).put(next.getCode(), next);
        }
        VALUESET_BINDER = new IValueSetEnumBinder<IdentifierUseEnum>(){

            public String toCodeString(IdentifierUseEnum theEnum) {
                return theEnum.getCode();
            }

            public String toSystemString(IdentifierUseEnum theEnum) {
                return theEnum.getSystem();
            }

            public IdentifierUseEnum fromCodeString(String theCodeString) {
                return CODE_TO_ENUM.get(theCodeString);
            }

            public IdentifierUseEnum fromCodeString(String theCodeString, String theSystemString) {
                Map<String, IdentifierUseEnum> map = SYSTEM_TO_CODE_TO_ENUM.get(theSystemString);
                if (map == null) {
                    return null;
                }
                return map.get(theCodeString);
            }
        };
    }
}

