/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu2.resource;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.model.api.BaseIdentifiableElement;
import ca.uhn.fhir.model.api.IDatatype;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.IResourceBlock;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.dstu2.resource.BaseResource;
import ca.uhn.fhir.model.primitive.StringDt;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.instance.model.api.IBaseParameters;

@ResourceDef(name="Parameters", profile="http://hl7.org/fhir/profiles/Parameters", id="parameters")
public class Parameters
extends BaseResource
implements IResource,
IBaseParameters {
    @Child(name="parameter", order=0, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="A parameter passed to or received from the operation")
    private List<Parameter> myParameter;

    public boolean isEmpty() {
        return super.isBaseEmpty() && ElementUtil.isEmpty(this.myParameter);
    }

    public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
        return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myParameter});
    }

    public List<Parameter> getParameter() {
        if (this.myParameter == null) {
            this.myParameter = new ArrayList<Parameter>();
        }
        return this.myParameter;
    }

    public Parameters setParameter(List<Parameter> theValue) {
        this.myParameter = theValue;
        return this;
    }

    public Parameter addParameter() {
        Parameter newType = new Parameter();
        this.getParameter().add(newType);
        return newType;
    }

    public Parameters addParameter(Parameter theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getParameter().add(theValue);
        return this;
    }

    public Parameter getParameterFirstRep() {
        if (this.getParameter().isEmpty()) {
            return this.addParameter();
        }
        return this.getParameter().get(0);
    }

    public String getResourceName() {
        return "Parameters";
    }

    public FhirVersionEnum getStructureFhirVersionEnum() {
        return FhirVersionEnum.DSTU2;
    }

    @Block
    public static class Parameter
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="name", type={StringDt.class}, order=0, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="The name of the parameter (reference to the operation definition)")
        private StringDt myName;
        @Child(name="value", type={IDatatype.class}, order=1, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="If the parameter is a data type")
        private IDatatype myValue;
        @Child(name="resource", type={IResource.class}, order=2, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="If the parameter is a whole resource")
        private IResource myResource;
        @Child(name="part", type={Parameter.class}, order=3, min=0, max=-1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="A named part of a parameter. In many implementation context, a set of named parts is known as a \"Tuple\"")
        private List<Parameter> myPart;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myName, this.myValue, this.myResource, this.myPart});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myName, this.myValue, this.myResource, this.myPart});
        }

        public StringDt getNameElement() {
            if (this.myName == null) {
                this.myName = new StringDt();
            }
            return this.myName;
        }

        public String getName() {
            return (String)this.getNameElement().getValue();
        }

        public Parameter setName(StringDt theValue) {
            this.myName = theValue;
            return this;
        }

        public Parameter setName(String theString) {
            this.myName = new StringDt(theString);
            return this;
        }

        public IDatatype getValue() {
            return this.myValue;
        }

        public Parameter setValue(IDatatype theValue) {
            this.myValue = theValue;
            return this;
        }

        public IResource getResource() {
            return this.myResource;
        }

        public Parameter setResource(IResource theValue) {
            this.myResource = theValue;
            return this;
        }

        public List<Parameter> getPart() {
            if (this.myPart == null) {
                this.myPart = new ArrayList<Parameter>();
            }
            return this.myPart;
        }

        public Parameter setPart(List<Parameter> theValue) {
            this.myPart = theValue;
            return this;
        }

        public Parameter addPart() {
            Parameter newType = new Parameter();
            this.getPart().add(newType);
            return newType;
        }

        public Parameter addPart(Parameter theValue) {
            if (theValue == null) {
                throw new NullPointerException("theValue must not be null");
            }
            this.getPart().add(theValue);
            return this;
        }

        public Parameter getPartFirstRep() {
            if (this.getPart().isEmpty()) {
                return this.addPart();
            }
            return this.getPart().get(0);
        }
    }
}

