/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu2.valueset;

import ca.uhn.fhir.model.api.IValueSetEnumBinder;
import java.util.HashMap;
import java.util.Map;

public enum ConstraintSeverityEnum {
    ERROR("error", "http://hl7.org/fhir/constraint-severity"),
    WARNING("warning", "http://hl7.org/fhir/constraint-severity");

    public static final String VALUESET_IDENTIFIER = "";
    public static final String VALUESET_NAME = "ConstraintSeverity";
    private static Map<String, ConstraintSeverityEnum> CODE_TO_ENUM;
    private static Map<String, Map<String, ConstraintSeverityEnum>> SYSTEM_TO_CODE_TO_ENUM;
    private final String myCode;
    private final String mySystem;
    public static final IValueSetEnumBinder<ConstraintSeverityEnum> VALUESET_BINDER;

    public String getCode() {
        return this.myCode;
    }

    public String getSystem() {
        return this.mySystem;
    }

    public static ConstraintSeverityEnum forCode(String theCode) {
        ConstraintSeverityEnum retVal = CODE_TO_ENUM.get(theCode);
        return retVal;
    }

    private ConstraintSeverityEnum(String theCode, String theSystem) {
        this.myCode = theCode;
        this.mySystem = theSystem;
    }

    static {
        CODE_TO_ENUM = new HashMap<String, ConstraintSeverityEnum>();
        SYSTEM_TO_CODE_TO_ENUM = new HashMap<String, Map<String, ConstraintSeverityEnum>>();
        for (ConstraintSeverityEnum next : ConstraintSeverityEnum.values()) {
            CODE_TO_ENUM.put(next.getCode(), next);
            if (!SYSTEM_TO_CODE_TO_ENUM.containsKey(next.getSystem())) {
                SYSTEM_TO_CODE_TO_ENUM.put(next.getSystem(), new HashMap());
            }
            SYSTEM_TO_CODE_TO_ENUM.get(next.getSystem()).put(next.getCode(), next);
        }
        VALUESET_BINDER = new IValueSetEnumBinder<ConstraintSeverityEnum>(){

            public String toCodeString(ConstraintSeverityEnum theEnum) {
                return theEnum.getCode();
            }

            public String toSystemString(ConstraintSeverityEnum theEnum) {
                return theEnum.getSystem();
            }

            public ConstraintSeverityEnum fromCodeString(String theCodeString) {
                return CODE_TO_ENUM.get(theCodeString);
            }

            public ConstraintSeverityEnum fromCodeString(String theCodeString, String theSystemString) {
                Map<String, ConstraintSeverityEnum> map = SYSTEM_TO_CODE_TO_ENUM.get(theSystemString);
                if (map == null) {
                    return null;
                }
                return map.get(theCodeString);
            }
        };
    }
}

