/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu2.resource;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.model.api.BaseIdentifiableElement;
import ca.uhn.fhir.model.api.IDatatype;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.IResourceBlock;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.TemporalPrecisionEnum;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.model.dstu2.composite.AttachmentDt;
import ca.uhn.fhir.model.dstu2.composite.CodeableConceptDt;
import ca.uhn.fhir.model.dstu2.composite.CodingDt;
import ca.uhn.fhir.model.dstu2.composite.IdentifierDt;
import ca.uhn.fhir.model.dstu2.composite.MoneyDt;
import ca.uhn.fhir.model.dstu2.composite.PeriodDt;
import ca.uhn.fhir.model.dstu2.composite.ResourceReferenceDt;
import ca.uhn.fhir.model.dstu2.composite.SimpleQuantityDt;
import ca.uhn.fhir.model.dstu2.resource.BaseResource;
import ca.uhn.fhir.model.dstu2.resource.Composition;
import ca.uhn.fhir.model.dstu2.resource.Device;
import ca.uhn.fhir.model.dstu2.resource.DocumentReference;
import ca.uhn.fhir.model.dstu2.resource.Group;
import ca.uhn.fhir.model.dstu2.resource.Location;
import ca.uhn.fhir.model.dstu2.resource.Organization;
import ca.uhn.fhir.model.dstu2.resource.Patient;
import ca.uhn.fhir.model.dstu2.resource.Practitioner;
import ca.uhn.fhir.model.dstu2.resource.QuestionnaireResponse;
import ca.uhn.fhir.model.dstu2.resource.RelatedPerson;
import ca.uhn.fhir.model.dstu2.resource.Substance;
import ca.uhn.fhir.model.primitive.DateTimeDt;
import ca.uhn.fhir.model.primitive.DecimalDt;
import ca.uhn.fhir.model.primitive.StringDt;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@ResourceDef(name="Contract", profile="http://hl7.org/fhir/profiles/Contract", id="contract")
public class Contract
extends BaseResource
implements IResource {
    @SearchParamDefinition(name="subject", path="Contract.subject", description="The identity of the target of the contract", type="reference", target={Patient.class})
    public static final String SP_SUBJECT = "subject";
    public static final ReferenceClientParam SUBJECT = new ReferenceClientParam("subject");
    @SearchParamDefinition(name="patient", path="Contract.subject", description="The identity of the target of the contract (if a patient)", type="reference", target={Patient.class})
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    @SearchParamDefinition(name="identifier", path="Contract.identifier", description="The identity of the contract", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="actor", path="Contract.actor.entity", description="", type="reference")
    public static final String SP_ACTOR = "actor";
    public static final ReferenceClientParam ACTOR = new ReferenceClientParam("actor");
    @SearchParamDefinition(name="signer", path="Contract.signer.party", description="", type="reference")
    public static final String SP_SIGNER = "signer";
    public static final ReferenceClientParam SIGNER = new ReferenceClientParam("signer");
    public static final Include INCLUDE_ACTOR = new Include("Contract:actor");
    public static final Include INCLUDE_PATIENT = new Include("Contract:patient");
    public static final Include INCLUDE_SIGNER = new Include("Contract:signer");
    public static final Include INCLUDE_SUBJECT = new Include("Contract:subject");
    @Child(name="identifier", type={IdentifierDt.class}, order=0, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="Unique identifier for this Contract.")
    private IdentifierDt myIdentifier;
    @Child(name="issued", type={DateTimeDt.class}, order=1, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="When this  Contract was issued.")
    private DateTimeDt myIssued;
    @Child(name="applies", type={PeriodDt.class}, order=2, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="Relevant time or time-period when this Contract is applicable")
    private PeriodDt myApplies;
    @Child(name="subject", order=3, min=0, max=-1, summary=true, modifier=false, type={IResource.class})
    @Description(shortDefinition="", formalDefinition="Who and/or what this Contract is about: typically a Patient, Organization, or valued items such as goods and services.")
    private List<ResourceReferenceDt> mySubject;
    @Child(name="authority", order=4, min=0, max=-1, summary=false, modifier=false, type={Organization.class})
    @Description(shortDefinition="", formalDefinition="A formally or informally recognized grouping of people, principals, organizations, or jurisdictions formed for the purpose of achieving some form of collective action such as the promulgation, administration and enforcement of contracts and policies.")
    private List<ResourceReferenceDt> myAuthority;
    @Child(name="domain", order=5, min=0, max=-1, summary=false, modifier=false, type={Location.class})
    @Description(shortDefinition="", formalDefinition="Recognized governance framework or system operating with a circumscribed scope in accordance with specified principles, policies, processes or procedures for managing rights, actions, or behaviors of parties or principals relative to resources.")
    private List<ResourceReferenceDt> myDomain;
    @Child(name="type", type={CodeableConceptDt.class}, order=6, min=0, max=1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="Type of Contract such as an insurance policy, real estate contract, a will, power of attorny, Privacy or Security policy , trust framework agreement, etc.")
    private CodeableConceptDt myType;
    @Child(name="subType", type={CodeableConceptDt.class}, order=7, min=0, max=-1, summary=true, modifier=false)
    @Description(shortDefinition="", formalDefinition="More specific type or specialization of an overarching or more general contract such as auto insurance, home owner  insurance, prenupial agreement, Advanced-Directive, or privacy consent.")
    private List<CodeableConceptDt> mySubType;
    @Child(name="action", type={CodeableConceptDt.class}, order=8, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="Action stipulated by this Contract.")
    private List<CodeableConceptDt> myAction;
    @Child(name="actionReason", type={CodeableConceptDt.class}, order=9, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="Reason for action stipulated by this Contract.")
    private List<CodeableConceptDt> myActionReason;
    @Child(name="actor", order=10, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="List of Contract actors")
    private List<Actor> myActor;
    @Child(name="valuedItem", order=11, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="Contract Valued Item List")
    private List<ValuedItem> myValuedItem;
    @Child(name="signer", order=12, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="Party signing this Contract.")
    private List<Signer> mySigner;
    @Child(name="term", order=13, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="One or more Contract Provisions, which may be related and conveyed as a group, and may contain nested groups.")
    private List<Term> myTerm;
    @Child(name="binding", order=14, min=0, max=1, summary=false, modifier=false, type={AttachmentDt.class, Composition.class, DocumentReference.class, QuestionnaireResponse.class})
    @Description(shortDefinition="", formalDefinition="Legally binding Contract: This is the signed and legally recognized representation of the Contract, which is considered the \"source of truth\" and which would be the basis for legal action related to enforcement of this Contract.")
    private IDatatype myBinding;
    @Child(name="friendly", order=15, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="The \"patient friendly language\" versionof the Contract in whole or in parts. \"Patient friendly language\" means the representation of the Contract and Contract Provisions in a manner that is readily accessible and understandable by a layperson in accordance with best practices for communication styles that ensure that those agreeing to or signing the Contract understand the roles, actions, obligations, responsibilities, and implication of the agreement.")
    private List<Friendly> myFriendly;
    @Child(name="legal", order=16, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="List of Legal expressions or representations of this Contract.")
    private List<Legal> myLegal;
    @Child(name="rule", order=17, min=0, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="List of Computable Policy Rule Language Representations of this Contract.")
    private List<Rule> myRule;

    public boolean isEmpty() {
        return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myIdentifier, this.myIssued, this.myApplies, this.mySubject, this.myAuthority, this.myDomain, this.myType, this.mySubType, this.myAction, this.myActionReason, this.myActor, this.myValuedItem, this.mySigner, this.myTerm, this.myBinding, this.myFriendly, this.myLegal, this.myRule});
    }

    public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
        return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myIdentifier, this.myIssued, this.myApplies, this.mySubject, this.myAuthority, this.myDomain, this.myType, this.mySubType, this.myAction, this.myActionReason, this.myActor, this.myValuedItem, this.mySigner, this.myTerm, this.myBinding, this.myFriendly, this.myLegal, this.myRule});
    }

    public IdentifierDt getIdentifier() {
        if (this.myIdentifier == null) {
            this.myIdentifier = new IdentifierDt();
        }
        return this.myIdentifier;
    }

    public Contract setIdentifier(IdentifierDt theValue) {
        this.myIdentifier = theValue;
        return this;
    }

    public DateTimeDt getIssuedElement() {
        if (this.myIssued == null) {
            this.myIssued = new DateTimeDt();
        }
        return this.myIssued;
    }

    public Date getIssued() {
        return (Date)this.getIssuedElement().getValue();
    }

    public Contract setIssued(DateTimeDt theValue) {
        this.myIssued = theValue;
        return this;
    }

    public Contract setIssuedWithSecondsPrecision(Date theDate) {
        this.myIssued = new DateTimeDt(theDate);
        return this;
    }

    public Contract setIssued(Date theDate, TemporalPrecisionEnum thePrecision) {
        this.myIssued = new DateTimeDt(theDate, thePrecision);
        return this;
    }

    public PeriodDt getApplies() {
        if (this.myApplies == null) {
            this.myApplies = new PeriodDt();
        }
        return this.myApplies;
    }

    public Contract setApplies(PeriodDt theValue) {
        this.myApplies = theValue;
        return this;
    }

    public List<ResourceReferenceDt> getSubject() {
        if (this.mySubject == null) {
            this.mySubject = new ArrayList<ResourceReferenceDt>();
        }
        return this.mySubject;
    }

    public Contract setSubject(List<ResourceReferenceDt> theValue) {
        this.mySubject = theValue;
        return this;
    }

    public ResourceReferenceDt addSubject() {
        ResourceReferenceDt newType = new ResourceReferenceDt();
        this.getSubject().add(newType);
        return newType;
    }

    public List<ResourceReferenceDt> getAuthority() {
        if (this.myAuthority == null) {
            this.myAuthority = new ArrayList<ResourceReferenceDt>();
        }
        return this.myAuthority;
    }

    public Contract setAuthority(List<ResourceReferenceDt> theValue) {
        this.myAuthority = theValue;
        return this;
    }

    public ResourceReferenceDt addAuthority() {
        ResourceReferenceDt newType = new ResourceReferenceDt();
        this.getAuthority().add(newType);
        return newType;
    }

    public List<ResourceReferenceDt> getDomain() {
        if (this.myDomain == null) {
            this.myDomain = new ArrayList<ResourceReferenceDt>();
        }
        return this.myDomain;
    }

    public Contract setDomain(List<ResourceReferenceDt> theValue) {
        this.myDomain = theValue;
        return this;
    }

    public ResourceReferenceDt addDomain() {
        ResourceReferenceDt newType = new ResourceReferenceDt();
        this.getDomain().add(newType);
        return newType;
    }

    public CodeableConceptDt getType() {
        if (this.myType == null) {
            this.myType = new CodeableConceptDt();
        }
        return this.myType;
    }

    public Contract setType(CodeableConceptDt theValue) {
        this.myType = theValue;
        return this;
    }

    public List<CodeableConceptDt> getSubType() {
        if (this.mySubType == null) {
            this.mySubType = new ArrayList<CodeableConceptDt>();
        }
        return this.mySubType;
    }

    public Contract setSubType(List<CodeableConceptDt> theValue) {
        this.mySubType = theValue;
        return this;
    }

    public CodeableConceptDt addSubType() {
        CodeableConceptDt newType = new CodeableConceptDt();
        this.getSubType().add(newType);
        return newType;
    }

    public Contract addSubType(CodeableConceptDt theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getSubType().add(theValue);
        return this;
    }

    public CodeableConceptDt getSubTypeFirstRep() {
        if (this.getSubType().isEmpty()) {
            return this.addSubType();
        }
        return this.getSubType().get(0);
    }

    public List<CodeableConceptDt> getAction() {
        if (this.myAction == null) {
            this.myAction = new ArrayList<CodeableConceptDt>();
        }
        return this.myAction;
    }

    public Contract setAction(List<CodeableConceptDt> theValue) {
        this.myAction = theValue;
        return this;
    }

    public CodeableConceptDt addAction() {
        CodeableConceptDt newType = new CodeableConceptDt();
        this.getAction().add(newType);
        return newType;
    }

    public Contract addAction(CodeableConceptDt theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getAction().add(theValue);
        return this;
    }

    public CodeableConceptDt getActionFirstRep() {
        if (this.getAction().isEmpty()) {
            return this.addAction();
        }
        return this.getAction().get(0);
    }

    public List<CodeableConceptDt> getActionReason() {
        if (this.myActionReason == null) {
            this.myActionReason = new ArrayList<CodeableConceptDt>();
        }
        return this.myActionReason;
    }

    public Contract setActionReason(List<CodeableConceptDt> theValue) {
        this.myActionReason = theValue;
        return this;
    }

    public CodeableConceptDt addActionReason() {
        CodeableConceptDt newType = new CodeableConceptDt();
        this.getActionReason().add(newType);
        return newType;
    }

    public Contract addActionReason(CodeableConceptDt theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getActionReason().add(theValue);
        return this;
    }

    public CodeableConceptDt getActionReasonFirstRep() {
        if (this.getActionReason().isEmpty()) {
            return this.addActionReason();
        }
        return this.getActionReason().get(0);
    }

    public List<Actor> getActor() {
        if (this.myActor == null) {
            this.myActor = new ArrayList<Actor>();
        }
        return this.myActor;
    }

    public Contract setActor(List<Actor> theValue) {
        this.myActor = theValue;
        return this;
    }

    public Actor addActor() {
        Actor newType = new Actor();
        this.getActor().add(newType);
        return newType;
    }

    public Contract addActor(Actor theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getActor().add(theValue);
        return this;
    }

    public Actor getActorFirstRep() {
        if (this.getActor().isEmpty()) {
            return this.addActor();
        }
        return this.getActor().get(0);
    }

    public List<ValuedItem> getValuedItem() {
        if (this.myValuedItem == null) {
            this.myValuedItem = new ArrayList<ValuedItem>();
        }
        return this.myValuedItem;
    }

    public Contract setValuedItem(List<ValuedItem> theValue) {
        this.myValuedItem = theValue;
        return this;
    }

    public ValuedItem addValuedItem() {
        ValuedItem newType = new ValuedItem();
        this.getValuedItem().add(newType);
        return newType;
    }

    public Contract addValuedItem(ValuedItem theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getValuedItem().add(theValue);
        return this;
    }

    public ValuedItem getValuedItemFirstRep() {
        if (this.getValuedItem().isEmpty()) {
            return this.addValuedItem();
        }
        return this.getValuedItem().get(0);
    }

    public List<Signer> getSigner() {
        if (this.mySigner == null) {
            this.mySigner = new ArrayList<Signer>();
        }
        return this.mySigner;
    }

    public Contract setSigner(List<Signer> theValue) {
        this.mySigner = theValue;
        return this;
    }

    public Signer addSigner() {
        Signer newType = new Signer();
        this.getSigner().add(newType);
        return newType;
    }

    public Contract addSigner(Signer theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getSigner().add(theValue);
        return this;
    }

    public Signer getSignerFirstRep() {
        if (this.getSigner().isEmpty()) {
            return this.addSigner();
        }
        return this.getSigner().get(0);
    }

    public List<Term> getTerm() {
        if (this.myTerm == null) {
            this.myTerm = new ArrayList<Term>();
        }
        return this.myTerm;
    }

    public Contract setTerm(List<Term> theValue) {
        this.myTerm = theValue;
        return this;
    }

    public Term addTerm() {
        Term newType = new Term();
        this.getTerm().add(newType);
        return newType;
    }

    public Contract addTerm(Term theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getTerm().add(theValue);
        return this;
    }

    public Term getTermFirstRep() {
        if (this.getTerm().isEmpty()) {
            return this.addTerm();
        }
        return this.getTerm().get(0);
    }

    public IDatatype getBinding() {
        return this.myBinding;
    }

    public Contract setBinding(IDatatype theValue) {
        this.myBinding = theValue;
        return this;
    }

    public List<Friendly> getFriendly() {
        if (this.myFriendly == null) {
            this.myFriendly = new ArrayList<Friendly>();
        }
        return this.myFriendly;
    }

    public Contract setFriendly(List<Friendly> theValue) {
        this.myFriendly = theValue;
        return this;
    }

    public Friendly addFriendly() {
        Friendly newType = new Friendly();
        this.getFriendly().add(newType);
        return newType;
    }

    public Contract addFriendly(Friendly theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getFriendly().add(theValue);
        return this;
    }

    public Friendly getFriendlyFirstRep() {
        if (this.getFriendly().isEmpty()) {
            return this.addFriendly();
        }
        return this.getFriendly().get(0);
    }

    public List<Legal> getLegal() {
        if (this.myLegal == null) {
            this.myLegal = new ArrayList<Legal>();
        }
        return this.myLegal;
    }

    public Contract setLegal(List<Legal> theValue) {
        this.myLegal = theValue;
        return this;
    }

    public Legal addLegal() {
        Legal newType = new Legal();
        this.getLegal().add(newType);
        return newType;
    }

    public Contract addLegal(Legal theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getLegal().add(theValue);
        return this;
    }

    public Legal getLegalFirstRep() {
        if (this.getLegal().isEmpty()) {
            return this.addLegal();
        }
        return this.getLegal().get(0);
    }

    public List<Rule> getRule() {
        if (this.myRule == null) {
            this.myRule = new ArrayList<Rule>();
        }
        return this.myRule;
    }

    public Contract setRule(List<Rule> theValue) {
        this.myRule = theValue;
        return this;
    }

    public Rule addRule() {
        Rule newType = new Rule();
        this.getRule().add(newType);
        return newType;
    }

    public Contract addRule(Rule theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getRule().add(theValue);
        return this;
    }

    public Rule getRuleFirstRep() {
        if (this.getRule().isEmpty()) {
            return this.addRule();
        }
        return this.getRule().get(0);
    }

    public String getResourceName() {
        return "Contract";
    }

    public FhirVersionEnum getStructureFhirVersionEnum() {
        return FhirVersionEnum.DSTU2;
    }

    @Block
    public static class Actor
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="entity", order=0, min=1, max=1, summary=false, modifier=false, type={Contract.class, Device.class, Group.class, Location.class, Organization.class, Patient.class, Practitioner.class, RelatedPerson.class, Substance.class})
        @Description(shortDefinition="", formalDefinition="Who or what actors are assigned roles in this Contract.")
        private ResourceReferenceDt myEntity;
        @Child(name="role", type={CodeableConceptDt.class}, order=1, min=0, max=-1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Role type of actors assigned roles in this Contract.")
        private List<CodeableConceptDt> myRole;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myEntity, this.myRole});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myEntity, this.myRole});
        }

        public ResourceReferenceDt getEntity() {
            if (this.myEntity == null) {
                this.myEntity = new ResourceReferenceDt();
            }
            return this.myEntity;
        }

        public Actor setEntity(ResourceReferenceDt theValue) {
            this.myEntity = theValue;
            return this;
        }

        public List<CodeableConceptDt> getRole() {
            if (this.myRole == null) {
                this.myRole = new ArrayList<CodeableConceptDt>();
            }
            return this.myRole;
        }

        public Actor setRole(List<CodeableConceptDt> theValue) {
            this.myRole = theValue;
            return this;
        }

        public CodeableConceptDt addRole() {
            CodeableConceptDt newType = new CodeableConceptDt();
            this.getRole().add(newType);
            return newType;
        }

        public Actor addRole(CodeableConceptDt theValue) {
            if (theValue == null) {
                throw new NullPointerException("theValue must not be null");
            }
            this.getRole().add(theValue);
            return this;
        }

        public CodeableConceptDt getRoleFirstRep() {
            if (this.getRole().isEmpty()) {
                return this.addRole();
            }
            return this.getRole().get(0);
        }
    }

    @Block
    public static class ValuedItem
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="entity", order=0, min=0, max=1, summary=false, modifier=false, type={CodeableConceptDt.class, IResource.class})
        @Description(shortDefinition="", formalDefinition="Specific type of Contract Valued Item that may be priced.")
        private IDatatype myEntity;
        @Child(name="identifier", type={IdentifierDt.class}, order=1, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Identifies a Contract Valued Item instance.")
        private IdentifierDt myIdentifier;
        @Child(name="effectiveTime", type={DateTimeDt.class}, order=2, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Indicates the time during which this Contract ValuedItem information is effective.")
        private DateTimeDt myEffectiveTime;
        @Child(name="quantity", type={SimpleQuantityDt.class}, order=3, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Specifies the units by which the Contract Valued Item is measured or counted, and quantifies the countable or measurable Contract Valued Item instances.")
        private SimpleQuantityDt myQuantity;
        @Child(name="unitPrice", type={MoneyDt.class}, order=4, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="A Contract Valued Item unit valuation measure.")
        private MoneyDt myUnitPrice;
        @Child(name="factor", type={DecimalDt.class}, order=5, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="A real number that represents a multiplier used in determining the overall value of the Contract Valued Item delivered. The concept of a Factor allows for a discount or surcharge multiplier to be applied to a monetary amount.")
        private DecimalDt myFactor;
        @Child(name="points", type={DecimalDt.class}, order=6, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="An amount that expresses the weighting (based on difficulty, cost and/or resource intensiveness) associated with the Contract Valued Item delivered. The concept of Points allows for assignment of point values for a Contract Valued Item, such that a monetary amount can be assigned to each point.")
        private DecimalDt myPoints;
        @Child(name="net", type={MoneyDt.class}, order=7, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Expresses the product of the Contract Valued Item unitQuantity and the unitPriceAmt. For example, the formula: unit Quantity * unit Price (Cost per Point) * factor Number  * points = net Amount. Quantity, factor and points are assumed to be 1 if not supplied.")
        private MoneyDt myNet;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myEntity, this.myIdentifier, this.myEffectiveTime, this.myQuantity, this.myUnitPrice, this.myFactor, this.myPoints, this.myNet});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myEntity, this.myIdentifier, this.myEffectiveTime, this.myQuantity, this.myUnitPrice, this.myFactor, this.myPoints, this.myNet});
        }

        public IDatatype getEntity() {
            return this.myEntity;
        }

        public ValuedItem setEntity(IDatatype theValue) {
            this.myEntity = theValue;
            return this;
        }

        public IdentifierDt getIdentifier() {
            if (this.myIdentifier == null) {
                this.myIdentifier = new IdentifierDt();
            }
            return this.myIdentifier;
        }

        public ValuedItem setIdentifier(IdentifierDt theValue) {
            this.myIdentifier = theValue;
            return this;
        }

        public DateTimeDt getEffectiveTimeElement() {
            if (this.myEffectiveTime == null) {
                this.myEffectiveTime = new DateTimeDt();
            }
            return this.myEffectiveTime;
        }

        public Date getEffectiveTime() {
            return (Date)this.getEffectiveTimeElement().getValue();
        }

        public ValuedItem setEffectiveTime(DateTimeDt theValue) {
            this.myEffectiveTime = theValue;
            return this;
        }

        public ValuedItem setEffectiveTimeWithSecondsPrecision(Date theDate) {
            this.myEffectiveTime = new DateTimeDt(theDate);
            return this;
        }

        public ValuedItem setEffectiveTime(Date theDate, TemporalPrecisionEnum thePrecision) {
            this.myEffectiveTime = new DateTimeDt(theDate, thePrecision);
            return this;
        }

        public SimpleQuantityDt getQuantity() {
            if (this.myQuantity == null) {
                this.myQuantity = new SimpleQuantityDt();
            }
            return this.myQuantity;
        }

        public ValuedItem setQuantity(SimpleQuantityDt theValue) {
            this.myQuantity = theValue;
            return this;
        }

        public MoneyDt getUnitPrice() {
            if (this.myUnitPrice == null) {
                this.myUnitPrice = new MoneyDt();
            }
            return this.myUnitPrice;
        }

        public ValuedItem setUnitPrice(MoneyDt theValue) {
            this.myUnitPrice = theValue;
            return this;
        }

        public DecimalDt getFactorElement() {
            if (this.myFactor == null) {
                this.myFactor = new DecimalDt();
            }
            return this.myFactor;
        }

        public BigDecimal getFactor() {
            return (BigDecimal)this.getFactorElement().getValue();
        }

        public ValuedItem setFactor(DecimalDt theValue) {
            this.myFactor = theValue;
            return this;
        }

        public ValuedItem setFactor(double theValue) {
            this.myFactor = new DecimalDt(theValue);
            return this;
        }

        public ValuedItem setFactor(BigDecimal theValue) {
            this.myFactor = new DecimalDt(theValue);
            return this;
        }

        public ValuedItem setFactor(long theValue) {
            this.myFactor = new DecimalDt(theValue);
            return this;
        }

        public DecimalDt getPointsElement() {
            if (this.myPoints == null) {
                this.myPoints = new DecimalDt();
            }
            return this.myPoints;
        }

        public BigDecimal getPoints() {
            return (BigDecimal)this.getPointsElement().getValue();
        }

        public ValuedItem setPoints(DecimalDt theValue) {
            this.myPoints = theValue;
            return this;
        }

        public ValuedItem setPoints(double theValue) {
            this.myPoints = new DecimalDt(theValue);
            return this;
        }

        public ValuedItem setPoints(BigDecimal theValue) {
            this.myPoints = new DecimalDt(theValue);
            return this;
        }

        public ValuedItem setPoints(long theValue) {
            this.myPoints = new DecimalDt(theValue);
            return this;
        }

        public MoneyDt getNet() {
            if (this.myNet == null) {
                this.myNet = new MoneyDt();
            }
            return this.myNet;
        }

        public ValuedItem setNet(MoneyDt theValue) {
            this.myNet = theValue;
            return this;
        }
    }

    @Block
    public static class Signer
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="type", type={CodingDt.class}, order=0, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Role of this Contract signer, e.g. notary, grantee.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/valueset-contract-signer-type")
        private CodingDt myType;
        @Child(name="party", order=1, min=1, max=1, summary=false, modifier=false, type={Organization.class, Patient.class, Practitioner.class, RelatedPerson.class})
        @Description(shortDefinition="", formalDefinition="Party which is a signator to this Contract.")
        private ResourceReferenceDt myParty;
        @Child(name="signature", type={StringDt.class}, order=2, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Legally binding Contract DSIG signature contents in Base64.")
        private StringDt mySignature;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myType, this.myParty, this.mySignature});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myType, this.myParty, this.mySignature});
        }

        public CodingDt getType() {
            if (this.myType == null) {
                this.myType = new CodingDt();
            }
            return this.myType;
        }

        public Signer setType(CodingDt theValue) {
            this.myType = theValue;
            return this;
        }

        public ResourceReferenceDt getParty() {
            if (this.myParty == null) {
                this.myParty = new ResourceReferenceDt();
            }
            return this.myParty;
        }

        public Signer setParty(ResourceReferenceDt theValue) {
            this.myParty = theValue;
            return this;
        }

        public StringDt getSignatureElement() {
            if (this.mySignature == null) {
                this.mySignature = new StringDt();
            }
            return this.mySignature;
        }

        public String getSignature() {
            return (String)this.getSignatureElement().getValue();
        }

        public Signer setSignature(StringDt theValue) {
            this.mySignature = theValue;
            return this;
        }

        public Signer setSignature(String theString) {
            this.mySignature = new StringDt(theString);
            return this;
        }
    }

    @Block
    public static class Term
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="identifier", type={IdentifierDt.class}, order=0, min=0, max=1, summary=true, modifier=false)
        @Description(shortDefinition="", formalDefinition="Unique identifier for this particular Contract Provision.")
        private IdentifierDt myIdentifier;
        @Child(name="issued", type={DateTimeDt.class}, order=1, min=0, max=1, summary=true, modifier=false)
        @Description(shortDefinition="", formalDefinition="When this Contract Provision was issued.")
        private DateTimeDt myIssued;
        @Child(name="applies", type={PeriodDt.class}, order=2, min=0, max=1, summary=true, modifier=false)
        @Description(shortDefinition="", formalDefinition="Relevant time or time-period when this Contract Provision is applicable.")
        private PeriodDt myApplies;
        @Child(name="type", type={CodeableConceptDt.class}, order=3, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Type of Contract Provision such as specific requirements, purposes for actions, obligations, prohibitions, e.g. life time maximum benefit.")
        private CodeableConceptDt myType;
        @Child(name="subType", type={CodeableConceptDt.class}, order=4, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Subtype of this Contract Provision, e.g. life time maximum payment for a contract term for specific valued item, e.g. disability payment.")
        private CodeableConceptDt mySubType;
        @Child(name="subject", order=5, min=0, max=1, summary=false, modifier=false, type={IResource.class})
        @Description(shortDefinition="", formalDefinition="Who or what this Contract Provision is about.")
        private ResourceReferenceDt mySubject;
        @Child(name="action", type={CodeableConceptDt.class}, order=6, min=0, max=-1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Action stipulated by this Contract Provision.")
        private List<CodeableConceptDt> myAction;
        @Child(name="actionReason", type={CodeableConceptDt.class}, order=7, min=0, max=-1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Reason or purpose for the action stipulated by this Contract Provision.")
        private List<CodeableConceptDt> myActionReason;
        @Child(name="actor", order=8, min=0, max=-1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="List of actors participating in this Contract Provision.")
        private List<TermActor> myActor;
        @Child(name="text", type={StringDt.class}, order=9, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Human readable form of this Contract Provision.")
        private StringDt myText;
        @Child(name="valuedItem", order=10, min=0, max=-1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Contract Provision Valued Item List")
        private List<TermValuedItem> myValuedItem;
        @Child(name="group", type={Term.class}, order=11, min=0, max=-1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Nested group of Contract Provisions.")
        private List<Term> myGroup;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myIdentifier, this.myIssued, this.myApplies, this.myType, this.mySubType, this.mySubject, this.myAction, this.myActionReason, this.myActor, this.myText, this.myValuedItem, this.myGroup});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myIdentifier, this.myIssued, this.myApplies, this.myType, this.mySubType, this.mySubject, this.myAction, this.myActionReason, this.myActor, this.myText, this.myValuedItem, this.myGroup});
        }

        public IdentifierDt getIdentifier() {
            if (this.myIdentifier == null) {
                this.myIdentifier = new IdentifierDt();
            }
            return this.myIdentifier;
        }

        public Term setIdentifier(IdentifierDt theValue) {
            this.myIdentifier = theValue;
            return this;
        }

        public DateTimeDt getIssuedElement() {
            if (this.myIssued == null) {
                this.myIssued = new DateTimeDt();
            }
            return this.myIssued;
        }

        public Date getIssued() {
            return (Date)this.getIssuedElement().getValue();
        }

        public Term setIssued(DateTimeDt theValue) {
            this.myIssued = theValue;
            return this;
        }

        public Term setIssuedWithSecondsPrecision(Date theDate) {
            this.myIssued = new DateTimeDt(theDate);
            return this;
        }

        public Term setIssued(Date theDate, TemporalPrecisionEnum thePrecision) {
            this.myIssued = new DateTimeDt(theDate, thePrecision);
            return this;
        }

        public PeriodDt getApplies() {
            if (this.myApplies == null) {
                this.myApplies = new PeriodDt();
            }
            return this.myApplies;
        }

        public Term setApplies(PeriodDt theValue) {
            this.myApplies = theValue;
            return this;
        }

        public CodeableConceptDt getType() {
            if (this.myType == null) {
                this.myType = new CodeableConceptDt();
            }
            return this.myType;
        }

        public Term setType(CodeableConceptDt theValue) {
            this.myType = theValue;
            return this;
        }

        public CodeableConceptDt getSubType() {
            if (this.mySubType == null) {
                this.mySubType = new CodeableConceptDt();
            }
            return this.mySubType;
        }

        public Term setSubType(CodeableConceptDt theValue) {
            this.mySubType = theValue;
            return this;
        }

        public ResourceReferenceDt getSubject() {
            if (this.mySubject == null) {
                this.mySubject = new ResourceReferenceDt();
            }
            return this.mySubject;
        }

        public Term setSubject(ResourceReferenceDt theValue) {
            this.mySubject = theValue;
            return this;
        }

        public List<CodeableConceptDt> getAction() {
            if (this.myAction == null) {
                this.myAction = new ArrayList<CodeableConceptDt>();
            }
            return this.myAction;
        }

        public Term setAction(List<CodeableConceptDt> theValue) {
            this.myAction = theValue;
            return this;
        }

        public CodeableConceptDt addAction() {
            CodeableConceptDt newType = new CodeableConceptDt();
            this.getAction().add(newType);
            return newType;
        }

        public Term addAction(CodeableConceptDt theValue) {
            if (theValue == null) {
                throw new NullPointerException("theValue must not be null");
            }
            this.getAction().add(theValue);
            return this;
        }

        public CodeableConceptDt getActionFirstRep() {
            if (this.getAction().isEmpty()) {
                return this.addAction();
            }
            return this.getAction().get(0);
        }

        public List<CodeableConceptDt> getActionReason() {
            if (this.myActionReason == null) {
                this.myActionReason = new ArrayList<CodeableConceptDt>();
            }
            return this.myActionReason;
        }

        public Term setActionReason(List<CodeableConceptDt> theValue) {
            this.myActionReason = theValue;
            return this;
        }

        public CodeableConceptDt addActionReason() {
            CodeableConceptDt newType = new CodeableConceptDt();
            this.getActionReason().add(newType);
            return newType;
        }

        public Term addActionReason(CodeableConceptDt theValue) {
            if (theValue == null) {
                throw new NullPointerException("theValue must not be null");
            }
            this.getActionReason().add(theValue);
            return this;
        }

        public CodeableConceptDt getActionReasonFirstRep() {
            if (this.getActionReason().isEmpty()) {
                return this.addActionReason();
            }
            return this.getActionReason().get(0);
        }

        public List<TermActor> getActor() {
            if (this.myActor == null) {
                this.myActor = new ArrayList<TermActor>();
            }
            return this.myActor;
        }

        public Term setActor(List<TermActor> theValue) {
            this.myActor = theValue;
            return this;
        }

        public TermActor addActor() {
            TermActor newType = new TermActor();
            this.getActor().add(newType);
            return newType;
        }

        public Term addActor(TermActor theValue) {
            if (theValue == null) {
                throw new NullPointerException("theValue must not be null");
            }
            this.getActor().add(theValue);
            return this;
        }

        public TermActor getActorFirstRep() {
            if (this.getActor().isEmpty()) {
                return this.addActor();
            }
            return this.getActor().get(0);
        }

        public StringDt getTextElement() {
            if (this.myText == null) {
                this.myText = new StringDt();
            }
            return this.myText;
        }

        public String getText() {
            return (String)this.getTextElement().getValue();
        }

        public Term setText(StringDt theValue) {
            this.myText = theValue;
            return this;
        }

        public Term setText(String theString) {
            this.myText = new StringDt(theString);
            return this;
        }

        public List<TermValuedItem> getValuedItem() {
            if (this.myValuedItem == null) {
                this.myValuedItem = new ArrayList<TermValuedItem>();
            }
            return this.myValuedItem;
        }

        public Term setValuedItem(List<TermValuedItem> theValue) {
            this.myValuedItem = theValue;
            return this;
        }

        public TermValuedItem addValuedItem() {
            TermValuedItem newType = new TermValuedItem();
            this.getValuedItem().add(newType);
            return newType;
        }

        public Term addValuedItem(TermValuedItem theValue) {
            if (theValue == null) {
                throw new NullPointerException("theValue must not be null");
            }
            this.getValuedItem().add(theValue);
            return this;
        }

        public TermValuedItem getValuedItemFirstRep() {
            if (this.getValuedItem().isEmpty()) {
                return this.addValuedItem();
            }
            return this.getValuedItem().get(0);
        }

        public List<Term> getGroup() {
            if (this.myGroup == null) {
                this.myGroup = new ArrayList<Term>();
            }
            return this.myGroup;
        }

        public Term setGroup(List<Term> theValue) {
            this.myGroup = theValue;
            return this;
        }

        public Term addGroup() {
            Term newType = new Term();
            this.getGroup().add(newType);
            return newType;
        }

        public Term addGroup(Term theValue) {
            if (theValue == null) {
                throw new NullPointerException("theValue must not be null");
            }
            this.getGroup().add(theValue);
            return this;
        }

        public Term getGroupFirstRep() {
            if (this.getGroup().isEmpty()) {
                return this.addGroup();
            }
            return this.getGroup().get(0);
        }
    }

    @Block
    public static class Friendly
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="content", order=0, min=1, max=1, summary=false, modifier=false, type={AttachmentDt.class, Composition.class, DocumentReference.class, QuestionnaireResponse.class})
        @Description(shortDefinition="", formalDefinition="Human readable rendering of this Contract in a format and representation intended to enhance comprehension and ensure understandability.")
        private IDatatype myContent;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myContent});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myContent});
        }

        public IDatatype getContent() {
            return this.myContent;
        }

        public Friendly setContent(IDatatype theValue) {
            this.myContent = theValue;
            return this;
        }
    }

    @Block
    public static class Legal
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="content", order=0, min=1, max=1, summary=false, modifier=false, type={AttachmentDt.class, Composition.class, DocumentReference.class, QuestionnaireResponse.class})
        @Description(shortDefinition="", formalDefinition="Contract legal text in human renderable form.")
        private IDatatype myContent;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myContent});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myContent});
        }

        public IDatatype getContent() {
            return this.myContent;
        }

        public Legal setContent(IDatatype theValue) {
            this.myContent = theValue;
            return this;
        }
    }

    @Block
    public static class Rule
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="content", order=0, min=1, max=1, summary=false, modifier=false, type={AttachmentDt.class, DocumentReference.class})
        @Description(shortDefinition="", formalDefinition="Computable Contract conveyed using a policy rule language (e.g. XACML, DKAL, SecPal).")
        private IDatatype myContent;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myContent});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myContent});
        }

        public IDatatype getContent() {
            return this.myContent;
        }

        public Rule setContent(IDatatype theValue) {
            this.myContent = theValue;
            return this;
        }
    }

    @Block
    public static class TermValuedItem
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="entity", order=0, min=0, max=1, summary=false, modifier=false, type={CodeableConceptDt.class, IResource.class})
        @Description(shortDefinition="", formalDefinition="Specific type of Contract Provision Valued Item that may be priced.")
        private IDatatype myEntity;
        @Child(name="identifier", type={IdentifierDt.class}, order=1, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Identifies a Contract Provision Valued Item instance.")
        private IdentifierDt myIdentifier;
        @Child(name="effectiveTime", type={DateTimeDt.class}, order=2, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Indicates the time during which this Contract Term ValuedItem information is effective.")
        private DateTimeDt myEffectiveTime;
        @Child(name="quantity", type={SimpleQuantityDt.class}, order=3, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Specifies the units by which the Contract Provision Valued Item is measured or counted, and quantifies the countable or measurable Contract Term Valued Item instances.")
        private SimpleQuantityDt myQuantity;
        @Child(name="unitPrice", type={MoneyDt.class}, order=4, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="A Contract Provision Valued Item unit valuation measure.")
        private MoneyDt myUnitPrice;
        @Child(name="factor", type={DecimalDt.class}, order=5, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="A real number that represents a multiplier used in determining the overall value of the Contract Provision Valued Item delivered. The concept of a Factor allows for a discount or surcharge multiplier to be applied to a monetary amount.")
        private DecimalDt myFactor;
        @Child(name="points", type={DecimalDt.class}, order=6, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="An amount that expresses the weighting (based on difficulty, cost and/or resource intensiveness) associated with the Contract Provision Valued Item delivered. The concept of Points allows for assignment of point values for a Contract ProvisionValued Item, such that a monetary amount can be assigned to each point.")
        private DecimalDt myPoints;
        @Child(name="net", type={MoneyDt.class}, order=7, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Expresses the product of the Contract Provision Valued Item unitQuantity and the unitPriceAmt. For example, the formula: unit Quantity * unit Price (Cost per Point) * factor Number  * points = net Amount. Quantity, factor and points are assumed to be 1 if not supplied.")
        private MoneyDt myNet;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myEntity, this.myIdentifier, this.myEffectiveTime, this.myQuantity, this.myUnitPrice, this.myFactor, this.myPoints, this.myNet});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myEntity, this.myIdentifier, this.myEffectiveTime, this.myQuantity, this.myUnitPrice, this.myFactor, this.myPoints, this.myNet});
        }

        public IDatatype getEntity() {
            return this.myEntity;
        }

        public TermValuedItem setEntity(IDatatype theValue) {
            this.myEntity = theValue;
            return this;
        }

        public IdentifierDt getIdentifier() {
            if (this.myIdentifier == null) {
                this.myIdentifier = new IdentifierDt();
            }
            return this.myIdentifier;
        }

        public TermValuedItem setIdentifier(IdentifierDt theValue) {
            this.myIdentifier = theValue;
            return this;
        }

        public DateTimeDt getEffectiveTimeElement() {
            if (this.myEffectiveTime == null) {
                this.myEffectiveTime = new DateTimeDt();
            }
            return this.myEffectiveTime;
        }

        public Date getEffectiveTime() {
            return (Date)this.getEffectiveTimeElement().getValue();
        }

        public TermValuedItem setEffectiveTime(DateTimeDt theValue) {
            this.myEffectiveTime = theValue;
            return this;
        }

        public TermValuedItem setEffectiveTimeWithSecondsPrecision(Date theDate) {
            this.myEffectiveTime = new DateTimeDt(theDate);
            return this;
        }

        public TermValuedItem setEffectiveTime(Date theDate, TemporalPrecisionEnum thePrecision) {
            this.myEffectiveTime = new DateTimeDt(theDate, thePrecision);
            return this;
        }

        public SimpleQuantityDt getQuantity() {
            if (this.myQuantity == null) {
                this.myQuantity = new SimpleQuantityDt();
            }
            return this.myQuantity;
        }

        public TermValuedItem setQuantity(SimpleQuantityDt theValue) {
            this.myQuantity = theValue;
            return this;
        }

        public MoneyDt getUnitPrice() {
            if (this.myUnitPrice == null) {
                this.myUnitPrice = new MoneyDt();
            }
            return this.myUnitPrice;
        }

        public TermValuedItem setUnitPrice(MoneyDt theValue) {
            this.myUnitPrice = theValue;
            return this;
        }

        public DecimalDt getFactorElement() {
            if (this.myFactor == null) {
                this.myFactor = new DecimalDt();
            }
            return this.myFactor;
        }

        public BigDecimal getFactor() {
            return (BigDecimal)this.getFactorElement().getValue();
        }

        public TermValuedItem setFactor(DecimalDt theValue) {
            this.myFactor = theValue;
            return this;
        }

        public TermValuedItem setFactor(double theValue) {
            this.myFactor = new DecimalDt(theValue);
            return this;
        }

        public TermValuedItem setFactor(BigDecimal theValue) {
            this.myFactor = new DecimalDt(theValue);
            return this;
        }

        public TermValuedItem setFactor(long theValue) {
            this.myFactor = new DecimalDt(theValue);
            return this;
        }

        public DecimalDt getPointsElement() {
            if (this.myPoints == null) {
                this.myPoints = new DecimalDt();
            }
            return this.myPoints;
        }

        public BigDecimal getPoints() {
            return (BigDecimal)this.getPointsElement().getValue();
        }

        public TermValuedItem setPoints(DecimalDt theValue) {
            this.myPoints = theValue;
            return this;
        }

        public TermValuedItem setPoints(double theValue) {
            this.myPoints = new DecimalDt(theValue);
            return this;
        }

        public TermValuedItem setPoints(BigDecimal theValue) {
            this.myPoints = new DecimalDt(theValue);
            return this;
        }

        public TermValuedItem setPoints(long theValue) {
            this.myPoints = new DecimalDt(theValue);
            return this;
        }

        public MoneyDt getNet() {
            if (this.myNet == null) {
                this.myNet = new MoneyDt();
            }
            return this.myNet;
        }

        public TermValuedItem setNet(MoneyDt theValue) {
            this.myNet = theValue;
            return this;
        }
    }

    @Block
    public static class TermActor
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="entity", order=0, min=1, max=1, summary=false, modifier=false, type={Contract.class, Device.class, Group.class, Location.class, Organization.class, Patient.class, Practitioner.class, RelatedPerson.class, Substance.class})
        @Description(shortDefinition="", formalDefinition="The actor assigned a role in this Contract Provision.")
        private ResourceReferenceDt myEntity;
        @Child(name="role", type={CodeableConceptDt.class}, order=1, min=0, max=-1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Role played by the actor assigned this role in this Contract Provision.")
        private List<CodeableConceptDt> myRole;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myEntity, this.myRole});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myEntity, this.myRole});
        }

        public ResourceReferenceDt getEntity() {
            if (this.myEntity == null) {
                this.myEntity = new ResourceReferenceDt();
            }
            return this.myEntity;
        }

        public TermActor setEntity(ResourceReferenceDt theValue) {
            this.myEntity = theValue;
            return this;
        }

        public List<CodeableConceptDt> getRole() {
            if (this.myRole == null) {
                this.myRole = new ArrayList<CodeableConceptDt>();
            }
            return this.myRole;
        }

        public TermActor setRole(List<CodeableConceptDt> theValue) {
            this.myRole = theValue;
            return this;
        }

        public CodeableConceptDt addRole() {
            CodeableConceptDt newType = new CodeableConceptDt();
            this.getRole().add(newType);
            return newType;
        }

        public TermActor addRole(CodeableConceptDt theValue) {
            if (theValue == null) {
                throw new NullPointerException("theValue must not be null");
            }
            this.getRole().add(theValue);
            return this;
        }

        public CodeableConceptDt getRoleFirstRep() {
            if (this.getRole().isEmpty()) {
                return this.addRole();
            }
            return this.getRole().get(0);
        }
    }
}

