/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu2.resource;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.IResourceBlock;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.base.resource.BaseOperationOutcome;
import ca.uhn.fhir.model.dstu2.composite.CodeableConceptDt;
import ca.uhn.fhir.model.dstu2.resource.BaseResource;
import ca.uhn.fhir.model.dstu2.valueset.IssueSeverityEnum;
import ca.uhn.fhir.model.dstu2.valueset.IssueTypeEnum;
import ca.uhn.fhir.model.primitive.BoundCodeDt;
import ca.uhn.fhir.model.primitive.CodeDt;
import ca.uhn.fhir.model.primitive.StringDt;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.List;

@ResourceDef(name="OperationOutcome", profile="http://hl7.org/fhir/profiles/OperationOutcome", id="operationoutcome")
public class OperationOutcome
extends BaseResource
implements BaseOperationOutcome {
    @Child(name="issue", order=0, min=1, max=-1, summary=false, modifier=false)
    @Description(shortDefinition="", formalDefinition="An error, warning or information message that results from a system action")
    private List<Issue> myIssue;

    public boolean isEmpty() {
        return super.isBaseEmpty() && ElementUtil.isEmpty(this.myIssue);
    }

    public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
        return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myIssue});
    }

    public List<Issue> getIssue() {
        if (this.myIssue == null) {
            this.myIssue = new ArrayList<Issue>();
        }
        return this.myIssue;
    }

    public OperationOutcome setIssue(List<Issue> theValue) {
        this.myIssue = theValue;
        return this;
    }

    public Issue addIssue() {
        Issue newType = new Issue();
        this.getIssue().add(newType);
        return newType;
    }

    public OperationOutcome addIssue(Issue theValue) {
        if (theValue == null) {
            throw new NullPointerException("theValue must not be null");
        }
        this.getIssue().add(theValue);
        return this;
    }

    public Issue getIssueFirstRep() {
        if (this.getIssue().isEmpty()) {
            return this.addIssue();
        }
        return this.getIssue().get(0);
    }

    public String getResourceName() {
        return "OperationOutcome";
    }

    public FhirVersionEnum getStructureFhirVersionEnum() {
        return FhirVersionEnum.DSTU2;
    }

    @Block
    public static class Issue
    extends BaseOperationOutcome.BaseIssue
    implements IResourceBlock {
        @Child(name="severity", type={CodeDt.class}, order=0, min=1, max=1, summary=false, modifier=true)
        @Description(shortDefinition="", formalDefinition="Indicates whether the issue indicates a variation from successful processing")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/issue-severity")
        private BoundCodeDt<IssueSeverityEnum> mySeverity;
        @Child(name="code", type={CodeDt.class}, order=1, min=1, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Describes the type of the issue. The system that creates an OperationOutcome SHALL choose the most applicable code from the IssueType value set, and may additional provide its own code for the error in the details element")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/issue-type")
        private BoundCodeDt<IssueTypeEnum> myCode;
        @Child(name="details", type={CodeableConceptDt.class}, order=2, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Additional details about the error. This may be a text description of the error, or a system code that identifies the error")
        private CodeableConceptDt myDetails;
        @Child(name="diagnostics", type={StringDt.class}, order=3, min=0, max=1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="Additional diagnostic information about the issue.  Typically, this may be a description of how a value is erroneous, or a stack dump to help trace the issue.")
        private StringDt myDiagnostics;
        @Child(name="location", type={StringDt.class}, order=4, min=0, max=-1, summary=false, modifier=false)
        @Description(shortDefinition="", formalDefinition="A simple XPath limited to element names, repetition indicators and the default child access that identifies one of the elements in the resource that caused this issue to be raised.")
        private List<StringDt> myLocation;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.mySeverity, this.myCode, this.myDetails, this.myDiagnostics, this.myLocation});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.mySeverity, this.myCode, this.myDetails, this.myDiagnostics, this.myLocation});
        }

        public BoundCodeDt<IssueSeverityEnum> getSeverityElement() {
            if (this.mySeverity == null) {
                this.mySeverity = new BoundCodeDt(IssueSeverityEnum.VALUESET_BINDER);
            }
            return this.mySeverity;
        }

        public String getSeverity() {
            return (String)this.getSeverityElement().getValue();
        }

        public Issue setSeverity(BoundCodeDt<IssueSeverityEnum> theValue) {
            this.mySeverity = theValue;
            return this;
        }

        public Issue setSeverity(IssueSeverityEnum theValue) {
            this.setSeverity((BoundCodeDt<IssueSeverityEnum>)new BoundCodeDt(IssueSeverityEnum.VALUESET_BINDER, (Enum)theValue));
            return this;
        }

        public BoundCodeDt<IssueTypeEnum> getCodeElement() {
            if (this.myCode == null) {
                this.myCode = new BoundCodeDt(IssueTypeEnum.VALUESET_BINDER);
            }
            return this.myCode;
        }

        public String getCode() {
            return (String)this.getCodeElement().getValue();
        }

        public Issue setCode(BoundCodeDt<IssueTypeEnum> theValue) {
            this.myCode = theValue;
            return this;
        }

        public Issue setCode(IssueTypeEnum theValue) {
            this.setCode((BoundCodeDt<IssueTypeEnum>)new BoundCodeDt(IssueTypeEnum.VALUESET_BINDER, (Enum)theValue));
            return this;
        }

        public CodeableConceptDt getDetails() {
            if (this.myDetails == null) {
                this.myDetails = new CodeableConceptDt();
            }
            return this.myDetails;
        }

        public Issue setDetails(CodeableConceptDt theValue) {
            this.myDetails = theValue;
            return this;
        }

        public StringDt getDiagnosticsElement() {
            if (this.myDiagnostics == null) {
                this.myDiagnostics = new StringDt();
            }
            return this.myDiagnostics;
        }

        public String getDiagnostics() {
            return (String)this.getDiagnosticsElement().getValue();
        }

        public Issue setDiagnostics(StringDt theValue) {
            this.myDiagnostics = theValue;
            return this;
        }

        public Issue setDiagnostics(String theString) {
            this.myDiagnostics = new StringDt(theString);
            return this;
        }

        public List<StringDt> getLocation() {
            if (this.myLocation == null) {
                this.myLocation = new ArrayList<StringDt>();
            }
            return this.myLocation;
        }

        public Issue setLocation(List<StringDt> theValue) {
            this.myLocation = theValue;
            return this;
        }

        public StringDt addLocation() {
            StringDt newType = new StringDt();
            this.getLocation().add(newType);
            return newType;
        }

        public Issue addLocation(StringDt theValue) {
            if (theValue == null) {
                throw new NullPointerException("theValue must not be null");
            }
            this.getLocation().add(theValue);
            return this;
        }

        public StringDt getLocationFirstRep() {
            if (this.getLocation().isEmpty()) {
                return this.addLocation();
            }
            return this.getLocation().get(0);
        }

        public Issue addLocation(String theString) {
            if (this.myLocation == null) {
                this.myLocation = new ArrayList<StringDt>();
            }
            this.myLocation.add(new StringDt(theString));
            return this;
        }

        @Deprecated
        public StringDt getDetailsElement() {
            return this.getDiagnosticsElement();
        }

        @Deprecated
        public BaseOperationOutcome.BaseIssue setDetails(String theString) {
            this.setDiagnostics(theString);
            return this;
        }
    }
}

