/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Compartment;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.dstu3.model.Attachment;
import org.hl7.fhir.dstu3.model.BackboneElement;
import org.hl7.fhir.dstu3.model.Base;
import org.hl7.fhir.dstu3.model.CarePlan;
import org.hl7.fhir.dstu3.model.CodeType;
import org.hl7.fhir.dstu3.model.CodeableConcept;
import org.hl7.fhir.dstu3.model.Configuration;
import org.hl7.fhir.dstu3.model.DateTimeType;
import org.hl7.fhir.dstu3.model.Device;
import org.hl7.fhir.dstu3.model.DomainResource;
import org.hl7.fhir.dstu3.model.Encounter;
import org.hl7.fhir.dstu3.model.EnumFactory;
import org.hl7.fhir.dstu3.model.Enumeration;
import org.hl7.fhir.dstu3.model.EpisodeOfCare;
import org.hl7.fhir.dstu3.model.Group;
import org.hl7.fhir.dstu3.model.Identifier;
import org.hl7.fhir.dstu3.model.ImagingManifest;
import org.hl7.fhir.dstu3.model.ImagingStudy;
import org.hl7.fhir.dstu3.model.ImmunizationRecommendation;
import org.hl7.fhir.dstu3.model.InstantType;
import org.hl7.fhir.dstu3.model.Location;
import org.hl7.fhir.dstu3.model.Media;
import org.hl7.fhir.dstu3.model.MedicationRequest;
import org.hl7.fhir.dstu3.model.NutritionOrder;
import org.hl7.fhir.dstu3.model.Observation;
import org.hl7.fhir.dstu3.model.Organization;
import org.hl7.fhir.dstu3.model.Patient;
import org.hl7.fhir.dstu3.model.Period;
import org.hl7.fhir.dstu3.model.Practitioner;
import org.hl7.fhir.dstu3.model.PrimitiveType;
import org.hl7.fhir.dstu3.model.ProcedureRequest;
import org.hl7.fhir.dstu3.model.Property;
import org.hl7.fhir.dstu3.model.Reference;
import org.hl7.fhir.dstu3.model.ReferralRequest;
import org.hl7.fhir.dstu3.model.Resource;
import org.hl7.fhir.dstu3.model.ResourceType;
import org.hl7.fhir.dstu3.model.Specimen;
import org.hl7.fhir.dstu3.model.StringType;
import org.hl7.fhir.dstu3.model.Type;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="DiagnosticReport", profile="http://hl7.org/fhir/Profile/DiagnosticReport")
public class DiagnosticReport
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Business identifier for report", formalDefinition="Identifiers assigned to this report by the performer or other systems.")
    protected List<Identifier> identifier;
    @Child(name="basedOn", type={CarePlan.class, ImmunizationRecommendation.class, MedicationRequest.class, NutritionOrder.class, ProcedureRequest.class, ReferralRequest.class}, order=1, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="What was requested", formalDefinition="Details concerning a test or procedure requested.")
    protected List<Reference> basedOn;
    protected List<Resource> basedOnTarget;
    @Child(name="status", type={CodeType.class}, order=2, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="registered | partial | preliminary | final +", formalDefinition="The status of the diagnostic report as a whole.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/diagnostic-report-status")
    protected Enumeration<DiagnosticReportStatus> status;
    @Child(name="category", type={CodeableConcept.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Service category", formalDefinition="A code that classifies the clinical discipline, department or diagnostic service that created the report (e.g. cardiology, biochemistry, hematology, MRI). This is used for searching, sorting and display purposes.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/diagnostic-service-sections")
    protected CodeableConcept category;
    @Child(name="code", type={CodeableConcept.class}, order=4, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Name/Code for this diagnostic report", formalDefinition="A code or name that describes this diagnostic report.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/report-codes")
    protected CodeableConcept code;
    @Child(name="subject", type={Patient.class, Group.class, Device.class, Location.class}, order=5, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The subject of the report - usually, but not always, the patient", formalDefinition="The subject of the report. Usually, but not always, this is a patient. However diagnostic services also perform analyses on specimens collected from a variety of other sources.")
    protected Reference subject;
    protected Resource subjectTarget;
    @Child(name="context", type={Encounter.class, EpisodeOfCare.class}, order=6, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Health care event when test ordered", formalDefinition="The healthcare event  (e.g. a patient and healthcare provider interaction) which this DiagnosticReport per is about.")
    protected Reference context;
    protected Resource contextTarget;
    @Child(name="effective", type={DateTimeType.class, Period.class}, order=7, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Clinically relevant time/time-period for report", formalDefinition="The time or time-period the observed values are related to. When the subject of the report is a patient, this is usually either the time of the procedure or of specimen collection(s), but very often the source of the date/time is not known, only the date/time itself.")
    protected Type effective;
    @Child(name="issued", type={InstantType.class}, order=8, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="DateTime this version was released", formalDefinition="The date and time that this version of the report was released from the source diagnostic service.")
    protected InstantType issued;
    @Child(name="performer", type={}, order=9, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Participants in producing the report", formalDefinition="Indicates who or what participated in producing the report.")
    protected List<DiagnosticReportPerformerComponent> performer;
    @Child(name="specimen", type={Specimen.class}, order=10, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Specimens this report is based on", formalDefinition="Details about the specimens on which this diagnostic report is based.")
    protected List<Reference> specimen;
    protected List<Specimen> specimenTarget;
    @Child(name="result", type={Observation.class}, order=11, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Observations - simple, or complex nested groups", formalDefinition="Observations that are part of this diagnostic report. Observations can be simple name/value pairs (e.g. \"atomic\" results), or they can be grouping observations that include references to other members of the group (e.g. \"panels\").")
    protected List<Reference> result;
    protected List<Observation> resultTarget;
    @Child(name="imagingStudy", type={ImagingStudy.class, ImagingManifest.class}, order=12, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Reference to full details of imaging associated with the diagnostic report", formalDefinition="One or more links to full details of any imaging performed during the diagnostic investigation. Typically, this is imaging performed by DICOM enabled modalities, but this is not required. A fully enabled PACS viewer can use this information to provide views of the source images.")
    protected List<Reference> imagingStudy;
    protected List<Resource> imagingStudyTarget;
    @Child(name="image", type={}, order=13, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Key images associated with this report", formalDefinition="A list of key images associated with this report. The images are generally created during the diagnostic process, and may be directly of the patient, or of treated specimens (i.e. slides of interest).")
    protected List<DiagnosticReportImageComponent> image;
    @Child(name="conclusion", type={StringType.class}, order=14, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Clinical Interpretation of test results", formalDefinition="Concise and clinically contextualized impression / summary of the diagnostic report.")
    protected StringType conclusion;
    @Child(name="codedDiagnosis", type={CodeableConcept.class}, order=15, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Codes for the conclusion", formalDefinition="Codes for the conclusion.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/clinical-findings")
    protected List<CodeableConcept> codedDiagnosis;
    @Child(name="presentedForm", type={Attachment.class}, order=16, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Entire report as issued", formalDefinition="Rich text representation of the entire result as issued by the diagnostic service. Multiple formats are allowed but they SHALL be semantically equivalent.")
    protected List<Attachment> presentedForm;
    private static final long serialVersionUID = 989012294L;
    @SearchParamDefinition(name="date", path="DiagnosticReport.effective", description="The clinically relevant time of the report", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="identifier", path="DiagnosticReport.identifier", description="An identifier for the report", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="image", path="DiagnosticReport.image.link", description="A reference to the image source.", type="reference", target={Media.class})
    public static final String SP_IMAGE = "image";
    public static final ReferenceClientParam IMAGE = new ReferenceClientParam("image");
    public static final Include INCLUDE_IMAGE = new Include("DiagnosticReport:image").toLocked();
    @SearchParamDefinition(name="performer", path="DiagnosticReport.performer.actor", description="Who was the source of the report (organization)", type="reference", providesMembershipIn={@Compartment(name="Practitioner")}, target={Organization.class, Practitioner.class})
    public static final String SP_PERFORMER = "performer";
    public static final ReferenceClientParam PERFORMER = new ReferenceClientParam("performer");
    public static final Include INCLUDE_PERFORMER = new Include("DiagnosticReport:performer").toLocked();
    @SearchParamDefinition(name="code", path="DiagnosticReport.code", description="The code for the report as a whole, as opposed to codes for the atomic results, which are the names on the observation resource referred to from the result", type="token")
    public static final String SP_CODE = "code";
    public static final TokenClientParam CODE = new TokenClientParam("code");
    @SearchParamDefinition(name="subject", path="DiagnosticReport.subject", description="The subject of the report", type="reference", providesMembershipIn={@Compartment(name="Device"), @Compartment(name="Patient")}, target={Device.class, Group.class, Location.class, Patient.class})
    public static final String SP_SUBJECT = "subject";
    public static final ReferenceClientParam SUBJECT = new ReferenceClientParam("subject");
    public static final Include INCLUDE_SUBJECT = new Include("DiagnosticReport:subject").toLocked();
    @SearchParamDefinition(name="diagnosis", path="DiagnosticReport.codedDiagnosis", description="A coded diagnosis on the report", type="token")
    public static final String SP_DIAGNOSIS = "diagnosis";
    public static final TokenClientParam DIAGNOSIS = new TokenClientParam("diagnosis");
    @SearchParamDefinition(name="encounter", path="DiagnosticReport.context", description="The Encounter when the order was made", type="reference", providesMembershipIn={@Compartment(name="Encounter")}, target={Encounter.class})
    public static final String SP_ENCOUNTER = "encounter";
    public static final ReferenceClientParam ENCOUNTER = new ReferenceClientParam("encounter");
    public static final Include INCLUDE_ENCOUNTER = new Include("DiagnosticReport:encounter").toLocked();
    @SearchParamDefinition(name="result", path="DiagnosticReport.result", description="Link to an atomic result (observation resource)", type="reference", target={Observation.class})
    public static final String SP_RESULT = "result";
    public static final ReferenceClientParam RESULT = new ReferenceClientParam("result");
    public static final Include INCLUDE_RESULT = new Include("DiagnosticReport:result").toLocked();
    @SearchParamDefinition(name="based-on", path="DiagnosticReport.basedOn", description="Reference to the procedure request.", type="reference", target={CarePlan.class, ImmunizationRecommendation.class, MedicationRequest.class, NutritionOrder.class, ProcedureRequest.class, ReferralRequest.class})
    public static final String SP_BASED_ON = "based-on";
    public static final ReferenceClientParam BASED_ON = new ReferenceClientParam("based-on");
    public static final Include INCLUDE_BASED_ON = new Include("DiagnosticReport:based-on").toLocked();
    @SearchParamDefinition(name="patient", path="DiagnosticReport.subject", description="The subject of the report if a patient", type="reference", target={Patient.class})
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    public static final Include INCLUDE_PATIENT = new Include("DiagnosticReport:patient").toLocked();
    @SearchParamDefinition(name="specimen", path="DiagnosticReport.specimen", description="The specimen details", type="reference", target={Specimen.class})
    public static final String SP_SPECIMEN = "specimen";
    public static final ReferenceClientParam SPECIMEN = new ReferenceClientParam("specimen");
    public static final Include INCLUDE_SPECIMEN = new Include("DiagnosticReport:specimen").toLocked();
    @SearchParamDefinition(name="context", path="DiagnosticReport.context", description="Healthcare event (Episode of Care or Encounter) related to the report", type="reference", target={Encounter.class, EpisodeOfCare.class})
    public static final String SP_CONTEXT = "context";
    public static final ReferenceClientParam CONTEXT = new ReferenceClientParam("context");
    public static final Include INCLUDE_CONTEXT = new Include("DiagnosticReport:context").toLocked();
    @SearchParamDefinition(name="issued", path="DiagnosticReport.issued", description="When the report was issued", type="date")
    public static final String SP_ISSUED = "issued";
    public static final DateClientParam ISSUED = new DateClientParam("issued");
    @SearchParamDefinition(name="category", path="DiagnosticReport.category", description="Which diagnostic discipline/department created the report", type="token")
    public static final String SP_CATEGORY = "category";
    public static final TokenClientParam CATEGORY = new TokenClientParam("category");
    @SearchParamDefinition(name="status", path="DiagnosticReport.status", description="The status of the report", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");

    public DiagnosticReport() {
    }

    public DiagnosticReport(Enumeration<DiagnosticReportStatus> status, CodeableConcept code) {
        this.status = status;
        this.code = code;
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public DiagnosticReport setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public DiagnosticReport addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public List<Reference> getBasedOn() {
        if (this.basedOn == null) {
            this.basedOn = new ArrayList<Reference>();
        }
        return this.basedOn;
    }

    public DiagnosticReport setBasedOn(List<Reference> theBasedOn) {
        this.basedOn = theBasedOn;
        return this;
    }

    public boolean hasBasedOn() {
        if (this.basedOn == null) {
            return false;
        }
        for (Reference item : this.basedOn) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addBasedOn() {
        Reference t = new Reference();
        if (this.basedOn == null) {
            this.basedOn = new ArrayList<Reference>();
        }
        this.basedOn.add(t);
        return t;
    }

    public DiagnosticReport addBasedOn(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.basedOn == null) {
            this.basedOn = new ArrayList<Reference>();
        }
        this.basedOn.add(t);
        return this;
    }

    public Reference getBasedOnFirstRep() {
        if (this.getBasedOn().isEmpty()) {
            this.addBasedOn();
        }
        return this.getBasedOn().get(0);
    }

    @Deprecated
    public List<Resource> getBasedOnTarget() {
        if (this.basedOnTarget == null) {
            this.basedOnTarget = new ArrayList<Resource>();
        }
        return this.basedOnTarget;
    }

    public Enumeration<DiagnosticReportStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DiagnosticReport.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<DiagnosticReportStatus>(new DiagnosticReportStatusEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public DiagnosticReport setStatusElement(Enumeration<DiagnosticReportStatus> value) {
        this.status = value;
        return this;
    }

    public DiagnosticReportStatus getStatus() {
        return this.status == null ? null : (DiagnosticReportStatus)((Object)this.status.getValue());
    }

    public DiagnosticReport setStatus(DiagnosticReportStatus value) {
        if (this.status == null) {
            this.status = new Enumeration<DiagnosticReportStatus>(new DiagnosticReportStatusEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    public CodeableConcept getCategory() {
        if (this.category == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DiagnosticReport.category");
            }
            if (Configuration.doAutoCreate()) {
                this.category = new CodeableConcept();
            }
        }
        return this.category;
    }

    public boolean hasCategory() {
        return this.category != null && !this.category.isEmpty();
    }

    public DiagnosticReport setCategory(CodeableConcept value) {
        this.category = value;
        return this;
    }

    public CodeableConcept getCode() {
        if (this.code == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DiagnosticReport.code");
            }
            if (Configuration.doAutoCreate()) {
                this.code = new CodeableConcept();
            }
        }
        return this.code;
    }

    public boolean hasCode() {
        return this.code != null && !this.code.isEmpty();
    }

    public DiagnosticReport setCode(CodeableConcept value) {
        this.code = value;
        return this;
    }

    public Reference getSubject() {
        if (this.subject == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DiagnosticReport.subject");
            }
            if (Configuration.doAutoCreate()) {
                this.subject = new Reference();
            }
        }
        return this.subject;
    }

    public boolean hasSubject() {
        return this.subject != null && !this.subject.isEmpty();
    }

    public DiagnosticReport setSubject(Reference value) {
        this.subject = value;
        return this;
    }

    public Resource getSubjectTarget() {
        return this.subjectTarget;
    }

    public DiagnosticReport setSubjectTarget(Resource value) {
        this.subjectTarget = value;
        return this;
    }

    public Reference getContext() {
        if (this.context == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DiagnosticReport.context");
            }
            if (Configuration.doAutoCreate()) {
                this.context = new Reference();
            }
        }
        return this.context;
    }

    public boolean hasContext() {
        return this.context != null && !this.context.isEmpty();
    }

    public DiagnosticReport setContext(Reference value) {
        this.context = value;
        return this;
    }

    public Resource getContextTarget() {
        return this.contextTarget;
    }

    public DiagnosticReport setContextTarget(Resource value) {
        this.contextTarget = value;
        return this;
    }

    public Type getEffective() {
        return this.effective;
    }

    public DateTimeType getEffectiveDateTimeType() throws FHIRException {
        if (!(this.effective instanceof DateTimeType)) {
            throw new FHIRException("Type mismatch: the type DateTimeType was expected, but " + this.effective.getClass().getName() + " was encountered");
        }
        return (DateTimeType)this.effective;
    }

    public boolean hasEffectiveDateTimeType() {
        return this.effective instanceof DateTimeType;
    }

    public Period getEffectivePeriod() throws FHIRException {
        if (!(this.effective instanceof Period)) {
            throw new FHIRException("Type mismatch: the type Period was expected, but " + this.effective.getClass().getName() + " was encountered");
        }
        return (Period)this.effective;
    }

    public boolean hasEffectivePeriod() {
        return this.effective instanceof Period;
    }

    public boolean hasEffective() {
        return this.effective != null && !this.effective.isEmpty();
    }

    public DiagnosticReport setEffective(Type value) {
        this.effective = value;
        return this;
    }

    public InstantType getIssuedElement() {
        if (this.issued == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DiagnosticReport.issued");
            }
            if (Configuration.doAutoCreate()) {
                this.issued = new InstantType();
            }
        }
        return this.issued;
    }

    public boolean hasIssuedElement() {
        return this.issued != null && !this.issued.isEmpty();
    }

    public boolean hasIssued() {
        return this.issued != null && !this.issued.isEmpty();
    }

    public DiagnosticReport setIssuedElement(InstantType value) {
        this.issued = value;
        return this;
    }

    public Date getIssued() {
        return this.issued == null ? null : (Date)this.issued.getValue();
    }

    public DiagnosticReport setIssued(Date value) {
        if (value == null) {
            this.issued = null;
        } else {
            if (this.issued == null) {
                this.issued = new InstantType();
            }
            this.issued.setValue(value);
        }
        return this;
    }

    public List<DiagnosticReportPerformerComponent> getPerformer() {
        if (this.performer == null) {
            this.performer = new ArrayList<DiagnosticReportPerformerComponent>();
        }
        return this.performer;
    }

    public DiagnosticReport setPerformer(List<DiagnosticReportPerformerComponent> thePerformer) {
        this.performer = thePerformer;
        return this;
    }

    public boolean hasPerformer() {
        if (this.performer == null) {
            return false;
        }
        for (DiagnosticReportPerformerComponent item : this.performer) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public DiagnosticReportPerformerComponent addPerformer() {
        DiagnosticReportPerformerComponent t = new DiagnosticReportPerformerComponent();
        if (this.performer == null) {
            this.performer = new ArrayList<DiagnosticReportPerformerComponent>();
        }
        this.performer.add(t);
        return t;
    }

    public DiagnosticReport addPerformer(DiagnosticReportPerformerComponent t) {
        if (t == null) {
            return this;
        }
        if (this.performer == null) {
            this.performer = new ArrayList<DiagnosticReportPerformerComponent>();
        }
        this.performer.add(t);
        return this;
    }

    public DiagnosticReportPerformerComponent getPerformerFirstRep() {
        if (this.getPerformer().isEmpty()) {
            this.addPerformer();
        }
        return this.getPerformer().get(0);
    }

    public List<Reference> getSpecimen() {
        if (this.specimen == null) {
            this.specimen = new ArrayList<Reference>();
        }
        return this.specimen;
    }

    public DiagnosticReport setSpecimen(List<Reference> theSpecimen) {
        this.specimen = theSpecimen;
        return this;
    }

    public boolean hasSpecimen() {
        if (this.specimen == null) {
            return false;
        }
        for (Reference item : this.specimen) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addSpecimen() {
        Reference t = new Reference();
        if (this.specimen == null) {
            this.specimen = new ArrayList<Reference>();
        }
        this.specimen.add(t);
        return t;
    }

    public DiagnosticReport addSpecimen(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.specimen == null) {
            this.specimen = new ArrayList<Reference>();
        }
        this.specimen.add(t);
        return this;
    }

    public Reference getSpecimenFirstRep() {
        if (this.getSpecimen().isEmpty()) {
            this.addSpecimen();
        }
        return this.getSpecimen().get(0);
    }

    @Deprecated
    public List<Specimen> getSpecimenTarget() {
        if (this.specimenTarget == null) {
            this.specimenTarget = new ArrayList<Specimen>();
        }
        return this.specimenTarget;
    }

    @Deprecated
    public Specimen addSpecimenTarget() {
        Specimen r = new Specimen();
        if (this.specimenTarget == null) {
            this.specimenTarget = new ArrayList<Specimen>();
        }
        this.specimenTarget.add(r);
        return r;
    }

    public List<Reference> getResult() {
        if (this.result == null) {
            this.result = new ArrayList<Reference>();
        }
        return this.result;
    }

    public DiagnosticReport setResult(List<Reference> theResult) {
        this.result = theResult;
        return this;
    }

    public boolean hasResult() {
        if (this.result == null) {
            return false;
        }
        for (Reference item : this.result) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addResult() {
        Reference t = new Reference();
        if (this.result == null) {
            this.result = new ArrayList<Reference>();
        }
        this.result.add(t);
        return t;
    }

    public DiagnosticReport addResult(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.result == null) {
            this.result = new ArrayList<Reference>();
        }
        this.result.add(t);
        return this;
    }

    public Reference getResultFirstRep() {
        if (this.getResult().isEmpty()) {
            this.addResult();
        }
        return this.getResult().get(0);
    }

    @Deprecated
    public List<Observation> getResultTarget() {
        if (this.resultTarget == null) {
            this.resultTarget = new ArrayList<Observation>();
        }
        return this.resultTarget;
    }

    @Deprecated
    public Observation addResultTarget() {
        Observation r = new Observation();
        if (this.resultTarget == null) {
            this.resultTarget = new ArrayList<Observation>();
        }
        this.resultTarget.add(r);
        return r;
    }

    public List<Reference> getImagingStudy() {
        if (this.imagingStudy == null) {
            this.imagingStudy = new ArrayList<Reference>();
        }
        return this.imagingStudy;
    }

    public DiagnosticReport setImagingStudy(List<Reference> theImagingStudy) {
        this.imagingStudy = theImagingStudy;
        return this;
    }

    public boolean hasImagingStudy() {
        if (this.imagingStudy == null) {
            return false;
        }
        for (Reference item : this.imagingStudy) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addImagingStudy() {
        Reference t = new Reference();
        if (this.imagingStudy == null) {
            this.imagingStudy = new ArrayList<Reference>();
        }
        this.imagingStudy.add(t);
        return t;
    }

    public DiagnosticReport addImagingStudy(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.imagingStudy == null) {
            this.imagingStudy = new ArrayList<Reference>();
        }
        this.imagingStudy.add(t);
        return this;
    }

    public Reference getImagingStudyFirstRep() {
        if (this.getImagingStudy().isEmpty()) {
            this.addImagingStudy();
        }
        return this.getImagingStudy().get(0);
    }

    @Deprecated
    public List<Resource> getImagingStudyTarget() {
        if (this.imagingStudyTarget == null) {
            this.imagingStudyTarget = new ArrayList<Resource>();
        }
        return this.imagingStudyTarget;
    }

    public List<DiagnosticReportImageComponent> getImage() {
        if (this.image == null) {
            this.image = new ArrayList<DiagnosticReportImageComponent>();
        }
        return this.image;
    }

    public DiagnosticReport setImage(List<DiagnosticReportImageComponent> theImage) {
        this.image = theImage;
        return this;
    }

    public boolean hasImage() {
        if (this.image == null) {
            return false;
        }
        for (DiagnosticReportImageComponent item : this.image) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public DiagnosticReportImageComponent addImage() {
        DiagnosticReportImageComponent t = new DiagnosticReportImageComponent();
        if (this.image == null) {
            this.image = new ArrayList<DiagnosticReportImageComponent>();
        }
        this.image.add(t);
        return t;
    }

    public DiagnosticReport addImage(DiagnosticReportImageComponent t) {
        if (t == null) {
            return this;
        }
        if (this.image == null) {
            this.image = new ArrayList<DiagnosticReportImageComponent>();
        }
        this.image.add(t);
        return this;
    }

    public DiagnosticReportImageComponent getImageFirstRep() {
        if (this.getImage().isEmpty()) {
            this.addImage();
        }
        return this.getImage().get(0);
    }

    public StringType getConclusionElement() {
        if (this.conclusion == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DiagnosticReport.conclusion");
            }
            if (Configuration.doAutoCreate()) {
                this.conclusion = new StringType();
            }
        }
        return this.conclusion;
    }

    public boolean hasConclusionElement() {
        return this.conclusion != null && !this.conclusion.isEmpty();
    }

    public boolean hasConclusion() {
        return this.conclusion != null && !this.conclusion.isEmpty();
    }

    public DiagnosticReport setConclusionElement(StringType value) {
        this.conclusion = value;
        return this;
    }

    public String getConclusion() {
        return this.conclusion == null ? null : (String)this.conclusion.getValue();
    }

    public DiagnosticReport setConclusion(String value) {
        if (Utilities.noString((String)value)) {
            this.conclusion = null;
        } else {
            if (this.conclusion == null) {
                this.conclusion = new StringType();
            }
            this.conclusion.setValue(value);
        }
        return this;
    }

    public List<CodeableConcept> getCodedDiagnosis() {
        if (this.codedDiagnosis == null) {
            this.codedDiagnosis = new ArrayList<CodeableConcept>();
        }
        return this.codedDiagnosis;
    }

    public DiagnosticReport setCodedDiagnosis(List<CodeableConcept> theCodedDiagnosis) {
        this.codedDiagnosis = theCodedDiagnosis;
        return this;
    }

    public boolean hasCodedDiagnosis() {
        if (this.codedDiagnosis == null) {
            return false;
        }
        for (CodeableConcept item : this.codedDiagnosis) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addCodedDiagnosis() {
        CodeableConcept t = new CodeableConcept();
        if (this.codedDiagnosis == null) {
            this.codedDiagnosis = new ArrayList<CodeableConcept>();
        }
        this.codedDiagnosis.add(t);
        return t;
    }

    public DiagnosticReport addCodedDiagnosis(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.codedDiagnosis == null) {
            this.codedDiagnosis = new ArrayList<CodeableConcept>();
        }
        this.codedDiagnosis.add(t);
        return this;
    }

    public CodeableConcept getCodedDiagnosisFirstRep() {
        if (this.getCodedDiagnosis().isEmpty()) {
            this.addCodedDiagnosis();
        }
        return this.getCodedDiagnosis().get(0);
    }

    public List<Attachment> getPresentedForm() {
        if (this.presentedForm == null) {
            this.presentedForm = new ArrayList<Attachment>();
        }
        return this.presentedForm;
    }

    public DiagnosticReport setPresentedForm(List<Attachment> thePresentedForm) {
        this.presentedForm = thePresentedForm;
        return this;
    }

    public boolean hasPresentedForm() {
        if (this.presentedForm == null) {
            return false;
        }
        for (Attachment item : this.presentedForm) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Attachment addPresentedForm() {
        Attachment t = new Attachment();
        if (this.presentedForm == null) {
            this.presentedForm = new ArrayList<Attachment>();
        }
        this.presentedForm.add(t);
        return t;
    }

    public DiagnosticReport addPresentedForm(Attachment t) {
        if (t == null) {
            return this;
        }
        if (this.presentedForm == null) {
            this.presentedForm = new ArrayList<Attachment>();
        }
        this.presentedForm.add(t);
        return this;
    }

    public Attachment getPresentedFormFirstRep() {
        if (this.getPresentedForm().isEmpty()) {
            this.addPresentedForm();
        }
        return this.getPresentedForm().get(0);
    }

    @Override
    protected void listChildren(List<Property> childrenList) {
        super.listChildren(childrenList);
        childrenList.add(new Property(SP_IDENTIFIER, "Identifier", "Identifiers assigned to this report by the performer or other systems.", 0, Integer.MAX_VALUE, this.identifier));
        childrenList.add(new Property("basedOn", "Reference(CarePlan|ImmunizationRecommendation|MedicationRequest|NutritionOrder|ProcedureRequest|ReferralRequest)", "Details concerning a test or procedure requested.", 0, Integer.MAX_VALUE, this.basedOn));
        childrenList.add(new Property(SP_STATUS, SP_CODE, "The status of the diagnostic report as a whole.", 0, Integer.MAX_VALUE, this.status));
        childrenList.add(new Property(SP_CATEGORY, "CodeableConcept", "A code that classifies the clinical discipline, department or diagnostic service that created the report (e.g. cardiology, biochemistry, hematology, MRI). This is used for searching, sorting and display purposes.", 0, Integer.MAX_VALUE, this.category));
        childrenList.add(new Property(SP_CODE, "CodeableConcept", "A code or name that describes this diagnostic report.", 0, Integer.MAX_VALUE, this.code));
        childrenList.add(new Property(SP_SUBJECT, "Reference(Patient|Group|Device|Location)", "The subject of the report. Usually, but not always, this is a patient. However diagnostic services also perform analyses on specimens collected from a variety of other sources.", 0, Integer.MAX_VALUE, this.subject));
        childrenList.add(new Property(SP_CONTEXT, "Reference(Encounter|EpisodeOfCare)", "The healthcare event  (e.g. a patient and healthcare provider interaction) which this DiagnosticReport per is about.", 0, Integer.MAX_VALUE, this.context));
        childrenList.add(new Property("effective[x]", "dateTime|Period", "The time or time-period the observed values are related to. When the subject of the report is a patient, this is usually either the time of the procedure or of specimen collection(s), but very often the source of the date/time is not known, only the date/time itself.", 0, Integer.MAX_VALUE, this.effective));
        childrenList.add(new Property(SP_ISSUED, "instant", "The date and time that this version of the report was released from the source diagnostic service.", 0, Integer.MAX_VALUE, this.issued));
        childrenList.add(new Property(SP_PERFORMER, "", "Indicates who or what participated in producing the report.", 0, Integer.MAX_VALUE, this.performer));
        childrenList.add(new Property(SP_SPECIMEN, "Reference(Specimen)", "Details about the specimens on which this diagnostic report is based.", 0, Integer.MAX_VALUE, this.specimen));
        childrenList.add(new Property(SP_RESULT, "Reference(Observation)", "Observations that are part of this diagnostic report. Observations can be simple name/value pairs (e.g. \"atomic\" results), or they can be grouping observations that include references to other members of the group (e.g. \"panels\").", 0, Integer.MAX_VALUE, this.result));
        childrenList.add(new Property("imagingStudy", "Reference(ImagingStudy|ImagingManifest)", "One or more links to full details of any imaging performed during the diagnostic investigation. Typically, this is imaging performed by DICOM enabled modalities, but this is not required. A fully enabled PACS viewer can use this information to provide views of the source images.", 0, Integer.MAX_VALUE, this.imagingStudy));
        childrenList.add(new Property(SP_IMAGE, "", "A list of key images associated with this report. The images are generally created during the diagnostic process, and may be directly of the patient, or of treated specimens (i.e. slides of interest).", 0, Integer.MAX_VALUE, this.image));
        childrenList.add(new Property("conclusion", "string", "Concise and clinically contextualized impression / summary of the diagnostic report.", 0, Integer.MAX_VALUE, this.conclusion));
        childrenList.add(new Property("codedDiagnosis", "CodeableConcept", "Codes for the conclusion.", 0, Integer.MAX_VALUE, this.codedDiagnosis));
        childrenList.add(new Property("presentedForm", "Attachment", "Rich text representation of the entire result as issued by the diagnostic service. Multiple formats are allowed but they SHALL be semantically equivalent.", 0, Integer.MAX_VALUE, this.presentedForm));
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case -332612366: {
                return this.basedOn == null ? new Base[]{} : this.basedOn.toArray(new Base[this.basedOn.size()]);
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.status;
                }
                return baseArray;
            }
            case 50511102: {
                Base[] baseArray;
                if (this.category == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.category;
                }
                return baseArray;
            }
            case 3059181: {
                Base[] baseArray;
                if (this.code == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.code;
                }
                return baseArray;
            }
            case -1867885268: {
                Base[] baseArray;
                if (this.subject == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.subject;
                }
                return baseArray;
            }
            case 951530927: {
                Base[] baseArray;
                if (this.context == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.context;
                }
                return baseArray;
            }
            case -1468651097: {
                Base[] baseArray;
                if (this.effective == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.effective;
                }
                return baseArray;
            }
            case -1179159893: {
                Base[] baseArray;
                if (this.issued == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.issued;
                }
                return baseArray;
            }
            case 481140686: {
                return this.performer == null ? new Base[]{} : this.performer.toArray(new Base[this.performer.size()]);
            }
            case -2132868344: {
                return this.specimen == null ? new Base[]{} : this.specimen.toArray(new Base[this.specimen.size()]);
            }
            case -934426595: {
                return this.result == null ? new Base[]{} : this.result.toArray(new Base[this.result.size()]);
            }
            case -814900911: {
                return this.imagingStudy == null ? new Base[]{} : this.imagingStudy.toArray(new Base[this.imagingStudy.size()]);
            }
            case 100313435: {
                return this.image == null ? new Base[]{} : this.image.toArray(new Base[this.image.size()]);
            }
            case -1731259873: {
                Base[] baseArray;
                if (this.conclusion == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.conclusion;
                }
                return baseArray;
            }
            case -1364269926: {
                return this.codedDiagnosis == null ? new Base[]{} : this.codedDiagnosis.toArray(new Base[this.codedDiagnosis.size()]);
            }
            case 230090366: {
                return this.presentedForm == null ? new Base[]{} : this.presentedForm.toArray(new Base[this.presentedForm.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(this.castToIdentifier(value));
                return value;
            }
            case -332612366: {
                this.getBasedOn().add(this.castToReference(value));
                return value;
            }
            case -892481550: {
                value = new DiagnosticReportStatusEnumFactory().fromType(this.castToCode(value));
                this.status = value;
                return value;
            }
            case 50511102: {
                this.category = this.castToCodeableConcept(value);
                return value;
            }
            case 3059181: {
                this.code = this.castToCodeableConcept(value);
                return value;
            }
            case -1867885268: {
                this.subject = this.castToReference(value);
                return value;
            }
            case 951530927: {
                this.context = this.castToReference(value);
                return value;
            }
            case -1468651097: {
                this.effective = this.castToType(value);
                return value;
            }
            case -1179159893: {
                this.issued = this.castToInstant(value);
                return value;
            }
            case 481140686: {
                this.getPerformer().add((DiagnosticReportPerformerComponent)((Object)value));
                return value;
            }
            case -2132868344: {
                this.getSpecimen().add(this.castToReference(value));
                return value;
            }
            case -934426595: {
                this.getResult().add(this.castToReference(value));
                return value;
            }
            case -814900911: {
                this.getImagingStudy().add(this.castToReference(value));
                return value;
            }
            case 100313435: {
                this.getImage().add((DiagnosticReportImageComponent)((Object)value));
                return value;
            }
            case -1731259873: {
                this.conclusion = this.castToString(value);
                return value;
            }
            case -1364269926: {
                this.getCodedDiagnosis().add(this.castToCodeableConcept(value));
                return value;
            }
            case 230090366: {
                this.getPresentedForm().add(this.castToAttachment(value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(this.castToIdentifier(value));
        } else if (name.equals("basedOn")) {
            this.getBasedOn().add(this.castToReference(value));
        } else if (name.equals(SP_STATUS)) {
            value = new DiagnosticReportStatusEnumFactory().fromType(this.castToCode(value));
            this.status = value;
        } else if (name.equals(SP_CATEGORY)) {
            this.category = this.castToCodeableConcept(value);
        } else if (name.equals(SP_CODE)) {
            this.code = this.castToCodeableConcept(value);
        } else if (name.equals(SP_SUBJECT)) {
            this.subject = this.castToReference(value);
        } else if (name.equals(SP_CONTEXT)) {
            this.context = this.castToReference(value);
        } else if (name.equals("effective[x]")) {
            this.effective = this.castToType(value);
        } else if (name.equals(SP_ISSUED)) {
            this.issued = this.castToInstant(value);
        } else if (name.equals(SP_PERFORMER)) {
            this.getPerformer().add((DiagnosticReportPerformerComponent)((Object)value));
        } else if (name.equals(SP_SPECIMEN)) {
            this.getSpecimen().add(this.castToReference(value));
        } else if (name.equals(SP_RESULT)) {
            this.getResult().add(this.castToReference(value));
        } else if (name.equals("imagingStudy")) {
            this.getImagingStudy().add(this.castToReference(value));
        } else if (name.equals(SP_IMAGE)) {
            this.getImage().add((DiagnosticReportImageComponent)((Object)value));
        } else if (name.equals("conclusion")) {
            this.conclusion = this.castToString(value);
        } else if (name.equals("codedDiagnosis")) {
            this.getCodedDiagnosis().add(this.castToCodeableConcept(value));
        } else if (name.equals("presentedForm")) {
            this.getPresentedForm().add(this.castToAttachment(value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case -332612366: {
                return this.addBasedOn();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case 50511102: {
                return this.getCategory();
            }
            case 3059181: {
                return this.getCode();
            }
            case -1867885268: {
                return this.getSubject();
            }
            case 951530927: {
                return this.getContext();
            }
            case 247104889: {
                return this.getEffective();
            }
            case -1468651097: {
                return this.getEffective();
            }
            case -1179159893: {
                return this.getIssuedElement();
            }
            case 481140686: {
                return this.addPerformer();
            }
            case -2132868344: {
                return this.addSpecimen();
            }
            case -934426595: {
                return this.addResult();
            }
            case -814900911: {
                return this.addImagingStudy();
            }
            case 100313435: {
                return this.addImage();
            }
            case -1731259873: {
                return this.getConclusionElement();
            }
            case -1364269926: {
                return this.addCodedDiagnosis();
            }
            case 230090366: {
                return this.addPresentedForm();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case -332612366: {
                return new String[]{"Reference"};
            }
            case -892481550: {
                return new String[]{SP_CODE};
            }
            case 50511102: {
                return new String[]{"CodeableConcept"};
            }
            case 3059181: {
                return new String[]{"CodeableConcept"};
            }
            case -1867885268: {
                return new String[]{"Reference"};
            }
            case 951530927: {
                return new String[]{"Reference"};
            }
            case -1468651097: {
                return new String[]{"dateTime", "Period"};
            }
            case -1179159893: {
                return new String[]{"instant"};
            }
            case 481140686: {
                return new String[0];
            }
            case -2132868344: {
                return new String[]{"Reference"};
            }
            case -934426595: {
                return new String[]{"Reference"};
            }
            case -814900911: {
                return new String[]{"Reference"};
            }
            case 100313435: {
                return new String[0];
            }
            case -1731259873: {
                return new String[]{"string"};
            }
            case -1364269926: {
                return new String[]{"CodeableConcept"};
            }
            case 230090366: {
                return new String[]{"Attachment"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals("basedOn")) {
            return this.addBasedOn();
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a primitive type DiagnosticReport.status");
        }
        if (name.equals(SP_CATEGORY)) {
            this.category = new CodeableConcept();
            return this.category;
        }
        if (name.equals(SP_CODE)) {
            this.code = new CodeableConcept();
            return this.code;
        }
        if (name.equals(SP_SUBJECT)) {
            this.subject = new Reference();
            return this.subject;
        }
        if (name.equals(SP_CONTEXT)) {
            this.context = new Reference();
            return this.context;
        }
        if (name.equals("effectiveDateTime")) {
            this.effective = new DateTimeType();
            return this.effective;
        }
        if (name.equals("effectivePeriod")) {
            this.effective = new Period();
            return this.effective;
        }
        if (name.equals(SP_ISSUED)) {
            throw new FHIRException("Cannot call addChild on a primitive type DiagnosticReport.issued");
        }
        if (name.equals(SP_PERFORMER)) {
            return this.addPerformer();
        }
        if (name.equals(SP_SPECIMEN)) {
            return this.addSpecimen();
        }
        if (name.equals(SP_RESULT)) {
            return this.addResult();
        }
        if (name.equals("imagingStudy")) {
            return this.addImagingStudy();
        }
        if (name.equals(SP_IMAGE)) {
            return this.addImage();
        }
        if (name.equals("conclusion")) {
            throw new FHIRException("Cannot call addChild on a primitive type DiagnosticReport.conclusion");
        }
        if (name.equals("codedDiagnosis")) {
            return this.addCodedDiagnosis();
        }
        if (name.equals("presentedForm")) {
            return this.addPresentedForm();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "DiagnosticReport";
    }

    @Override
    public DiagnosticReport copy() {
        DiagnosticReport dst = new DiagnosticReport();
        this.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        if (this.basedOn != null) {
            dst.basedOn = new ArrayList<Reference>();
            for (Reference reference : this.basedOn) {
                dst.basedOn.add(reference.copy());
            }
        }
        dst.status = this.status == null ? null : this.status.copy();
        dst.category = this.category == null ? null : this.category.copy();
        dst.code = this.code == null ? null : this.code.copy();
        dst.subject = this.subject == null ? null : this.subject.copy();
        dst.context = this.context == null ? null : this.context.copy();
        dst.effective = this.effective == null ? null : this.effective.copy();
        InstantType instantType = dst.issued = this.issued == null ? null : this.issued.copy();
        if (this.performer != null) {
            dst.performer = new ArrayList<DiagnosticReportPerformerComponent>();
            for (DiagnosticReportPerformerComponent diagnosticReportPerformerComponent : this.performer) {
                dst.performer.add(diagnosticReportPerformerComponent.copy());
            }
        }
        if (this.specimen != null) {
            dst.specimen = new ArrayList<Reference>();
            for (Reference reference : this.specimen) {
                dst.specimen.add(reference.copy());
            }
        }
        if (this.result != null) {
            dst.result = new ArrayList<Reference>();
            for (Reference reference : this.result) {
                dst.result.add(reference.copy());
            }
        }
        if (this.imagingStudy != null) {
            dst.imagingStudy = new ArrayList<Reference>();
            for (Reference reference : this.imagingStudy) {
                dst.imagingStudy.add(reference.copy());
            }
        }
        if (this.image != null) {
            dst.image = new ArrayList<DiagnosticReportImageComponent>();
            for (DiagnosticReportImageComponent diagnosticReportImageComponent : this.image) {
                dst.image.add(diagnosticReportImageComponent.copy());
            }
        }
        StringType stringType = dst.conclusion = this.conclusion == null ? null : this.conclusion.copy();
        if (this.codedDiagnosis != null) {
            dst.codedDiagnosis = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.codedDiagnosis) {
                dst.codedDiagnosis.add(codeableConcept.copy());
            }
        }
        if (this.presentedForm != null) {
            dst.presentedForm = new ArrayList<Attachment>();
            for (Attachment attachment : this.presentedForm) {
                dst.presentedForm.add(attachment.copy());
            }
        }
        return dst;
    }

    protected DiagnosticReport typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other) {
        if (!super.equalsDeep(other)) {
            return false;
        }
        if (!(other instanceof DiagnosticReport)) {
            return false;
        }
        DiagnosticReport o = (DiagnosticReport)other;
        return DiagnosticReport.compareDeep(this.identifier, o.identifier, true) && DiagnosticReport.compareDeep(this.basedOn, o.basedOn, true) && DiagnosticReport.compareDeep(this.status, o.status, true) && DiagnosticReport.compareDeep(this.category, o.category, true) && DiagnosticReport.compareDeep(this.code, o.code, true) && DiagnosticReport.compareDeep(this.subject, o.subject, true) && DiagnosticReport.compareDeep(this.context, o.context, true) && DiagnosticReport.compareDeep(this.effective, o.effective, true) && DiagnosticReport.compareDeep(this.issued, o.issued, true) && DiagnosticReport.compareDeep(this.performer, o.performer, true) && DiagnosticReport.compareDeep(this.specimen, o.specimen, true) && DiagnosticReport.compareDeep(this.result, o.result, true) && DiagnosticReport.compareDeep(this.imagingStudy, o.imagingStudy, true) && DiagnosticReport.compareDeep(this.image, o.image, true) && DiagnosticReport.compareDeep(this.conclusion, o.conclusion, true) && DiagnosticReport.compareDeep(this.codedDiagnosis, o.codedDiagnosis, true) && DiagnosticReport.compareDeep(this.presentedForm, o.presentedForm, true);
    }

    @Override
    public boolean equalsShallow(Base other) {
        if (!super.equalsShallow(other)) {
            return false;
        }
        if (!(other instanceof DiagnosticReport)) {
            return false;
        }
        DiagnosticReport o = (DiagnosticReport)other;
        return DiagnosticReport.compareValues(this.status, o.status, true) && DiagnosticReport.compareValues(this.issued, o.issued, true) && DiagnosticReport.compareValues(this.conclusion, o.conclusion, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.basedOn, this.status, this.category, this.code, this.subject, this.context, this.effective, this.issued, this.performer, this.specimen, this.result, this.imagingStudy, this.image, this.conclusion, this.codedDiagnosis, this.presentedForm});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.DiagnosticReport;
    }

    @Block
    public static class DiagnosticReportImageComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="comment", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Comment about the image (e.g. explanation)", formalDefinition="A comment about the image. Typically, this is used to provide an explanation for why the image is included, or to draw the viewer's attention to important features.")
        protected StringType comment;
        @Child(name="link", type={Media.class}, order=2, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Reference to the image source", formalDefinition="Reference to the image source.")
        protected Reference link;
        protected Media linkTarget;
        private static final long serialVersionUID = 935791940L;

        public DiagnosticReportImageComponent() {
        }

        public DiagnosticReportImageComponent(Reference link) {
            this.link = link;
        }

        public StringType getCommentElement() {
            if (this.comment == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DiagnosticReportImageComponent.comment");
                }
                if (Configuration.doAutoCreate()) {
                    this.comment = new StringType();
                }
            }
            return this.comment;
        }

        public boolean hasCommentElement() {
            return this.comment != null && !this.comment.isEmpty();
        }

        public boolean hasComment() {
            return this.comment != null && !this.comment.isEmpty();
        }

        public DiagnosticReportImageComponent setCommentElement(StringType value) {
            this.comment = value;
            return this;
        }

        public String getComment() {
            return this.comment == null ? null : (String)this.comment.getValue();
        }

        public DiagnosticReportImageComponent setComment(String value) {
            if (Utilities.noString((String)value)) {
                this.comment = null;
            } else {
                if (this.comment == null) {
                    this.comment = new StringType();
                }
                this.comment.setValue(value);
            }
            return this;
        }

        public Reference getLink() {
            if (this.link == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DiagnosticReportImageComponent.link");
                }
                if (Configuration.doAutoCreate()) {
                    this.link = new Reference();
                }
            }
            return this.link;
        }

        public boolean hasLink() {
            return this.link != null && !this.link.isEmpty();
        }

        public DiagnosticReportImageComponent setLink(Reference value) {
            this.link = value;
            return this;
        }

        public Media getLinkTarget() {
            if (this.linkTarget == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DiagnosticReportImageComponent.link");
                }
                if (Configuration.doAutoCreate()) {
                    this.linkTarget = new Media();
                }
            }
            return this.linkTarget;
        }

        public DiagnosticReportImageComponent setLinkTarget(Media value) {
            this.linkTarget = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("comment", "string", "A comment about the image. Typically, this is used to provide an explanation for why the image is included, or to draw the viewer's attention to important features.", 0, Integer.MAX_VALUE, this.comment));
            childrenList.add(new Property("link", "Reference(Media)", "Reference to the image source.", 0, Integer.MAX_VALUE, this.link));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 950398559: {
                    Base[] baseArray;
                    if (this.comment == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.comment;
                    }
                    return baseArray;
                }
                case 3321850: {
                    Base[] baseArray;
                    if (this.link == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.link;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 950398559: {
                    this.comment = this.castToString(value);
                    return value;
                }
                case 3321850: {
                    this.link = this.castToReference(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("comment")) {
                this.comment = this.castToString(value);
            } else if (name.equals("link")) {
                this.link = this.castToReference(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 950398559: {
                    return this.getCommentElement();
                }
                case 3321850: {
                    return this.getLink();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 950398559: {
                    return new String[]{"string"};
                }
                case 3321850: {
                    return new String[]{"Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("comment")) {
                throw new FHIRException("Cannot call addChild on a primitive type DiagnosticReport.comment");
            }
            if (name.equals("link")) {
                this.link = new Reference();
                return this.link;
            }
            return super.addChild(name);
        }

        @Override
        public DiagnosticReportImageComponent copy() {
            DiagnosticReportImageComponent dst = new DiagnosticReportImageComponent();
            this.copyValues(dst);
            dst.comment = this.comment == null ? null : this.comment.copy();
            dst.link = this.link == null ? null : this.link.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof DiagnosticReportImageComponent)) {
                return false;
            }
            DiagnosticReportImageComponent o = (DiagnosticReportImageComponent)other;
            return DiagnosticReportImageComponent.compareDeep(this.comment, o.comment, true) && DiagnosticReportImageComponent.compareDeep(this.link, o.link, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof DiagnosticReportImageComponent)) {
                return false;
            }
            DiagnosticReportImageComponent o = (DiagnosticReportImageComponent)other;
            return DiagnosticReportImageComponent.compareValues(this.comment, o.comment, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.comment, this.link});
        }

        @Override
        public String fhirType() {
            return "DiagnosticReport.image";
        }
    }

    @Block
    public static class DiagnosticReportPerformerComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="role", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Type of performer", formalDefinition="Describes the type of participation (e.g.  a responsible party, author, or verifier).")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/performer-role")
        protected CodeableConcept role;
        @Child(name="actor", type={Practitioner.class, Organization.class}, order=2, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Practitioner or Organization  participant", formalDefinition="The reference to the  practitioner or organization involved in producing the report. For example, the diagnostic service that is responsible for issuing the report.")
        protected Reference actor;
        protected Resource actorTarget;
        private static final long serialVersionUID = 805521719L;

        public DiagnosticReportPerformerComponent() {
        }

        public DiagnosticReportPerformerComponent(Reference actor) {
            this.actor = actor;
        }

        public CodeableConcept getRole() {
            if (this.role == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DiagnosticReportPerformerComponent.role");
                }
                if (Configuration.doAutoCreate()) {
                    this.role = new CodeableConcept();
                }
            }
            return this.role;
        }

        public boolean hasRole() {
            return this.role != null && !this.role.isEmpty();
        }

        public DiagnosticReportPerformerComponent setRole(CodeableConcept value) {
            this.role = value;
            return this;
        }

        public Reference getActor() {
            if (this.actor == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DiagnosticReportPerformerComponent.actor");
                }
                if (Configuration.doAutoCreate()) {
                    this.actor = new Reference();
                }
            }
            return this.actor;
        }

        public boolean hasActor() {
            return this.actor != null && !this.actor.isEmpty();
        }

        public DiagnosticReportPerformerComponent setActor(Reference value) {
            this.actor = value;
            return this;
        }

        public Resource getActorTarget() {
            return this.actorTarget;
        }

        public DiagnosticReportPerformerComponent setActorTarget(Resource value) {
            this.actorTarget = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("role", "CodeableConcept", "Describes the type of participation (e.g.  a responsible party, author, or verifier).", 0, Integer.MAX_VALUE, this.role));
            childrenList.add(new Property("actor", "Reference(Practitioner|Organization)", "The reference to the  practitioner or organization involved in producing the report. For example, the diagnostic service that is responsible for issuing the report.", 0, Integer.MAX_VALUE, this.actor));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3506294: {
                    Base[] baseArray;
                    if (this.role == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.role;
                    }
                    return baseArray;
                }
                case 92645877: {
                    Base[] baseArray;
                    if (this.actor == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.actor;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3506294: {
                    this.role = this.castToCodeableConcept(value);
                    return value;
                }
                case 92645877: {
                    this.actor = this.castToReference(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("role")) {
                this.role = this.castToCodeableConcept(value);
            } else if (name.equals("actor")) {
                this.actor = this.castToReference(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3506294: {
                    return this.getRole();
                }
                case 92645877: {
                    return this.getActor();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3506294: {
                    return new String[]{"CodeableConcept"};
                }
                case 92645877: {
                    return new String[]{"Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("role")) {
                this.role = new CodeableConcept();
                return this.role;
            }
            if (name.equals("actor")) {
                this.actor = new Reference();
                return this.actor;
            }
            return super.addChild(name);
        }

        @Override
        public DiagnosticReportPerformerComponent copy() {
            DiagnosticReportPerformerComponent dst = new DiagnosticReportPerformerComponent();
            this.copyValues(dst);
            dst.role = this.role == null ? null : this.role.copy();
            dst.actor = this.actor == null ? null : this.actor.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof DiagnosticReportPerformerComponent)) {
                return false;
            }
            DiagnosticReportPerformerComponent o = (DiagnosticReportPerformerComponent)other;
            return DiagnosticReportPerformerComponent.compareDeep(this.role, o.role, true) && DiagnosticReportPerformerComponent.compareDeep(this.actor, o.actor, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof DiagnosticReportPerformerComponent)) {
                return false;
            }
            DiagnosticReportPerformerComponent o = (DiagnosticReportPerformerComponent)other;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.role, this.actor});
        }

        @Override
        public String fhirType() {
            return "DiagnosticReport.performer";
        }
    }

    public static class DiagnosticReportStatusEnumFactory
    implements EnumFactory<DiagnosticReportStatus> {
        @Override
        public DiagnosticReportStatus fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("registered".equals(codeString)) {
                return DiagnosticReportStatus.REGISTERED;
            }
            if ("partial".equals(codeString)) {
                return DiagnosticReportStatus.PARTIAL;
            }
            if ("preliminary".equals(codeString)) {
                return DiagnosticReportStatus.PRELIMINARY;
            }
            if ("final".equals(codeString)) {
                return DiagnosticReportStatus.FINAL;
            }
            if ("amended".equals(codeString)) {
                return DiagnosticReportStatus.AMENDED;
            }
            if ("corrected".equals(codeString)) {
                return DiagnosticReportStatus.CORRECTED;
            }
            if ("appended".equals(codeString)) {
                return DiagnosticReportStatus.APPENDED;
            }
            if ("cancelled".equals(codeString)) {
                return DiagnosticReportStatus.CANCELLED;
            }
            if ("entered-in-error".equals(codeString)) {
                return DiagnosticReportStatus.ENTEREDINERROR;
            }
            if ("unknown".equals(codeString)) {
                return DiagnosticReportStatus.UNKNOWN;
            }
            throw new IllegalArgumentException("Unknown DiagnosticReportStatus code '" + codeString + "'");
        }

        public Enumeration<DiagnosticReportStatus> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<DiagnosticReportStatus>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("registered".equals(codeString)) {
                return new Enumeration<DiagnosticReportStatus>(this, DiagnosticReportStatus.REGISTERED);
            }
            if ("partial".equals(codeString)) {
                return new Enumeration<DiagnosticReportStatus>(this, DiagnosticReportStatus.PARTIAL);
            }
            if ("preliminary".equals(codeString)) {
                return new Enumeration<DiagnosticReportStatus>(this, DiagnosticReportStatus.PRELIMINARY);
            }
            if ("final".equals(codeString)) {
                return new Enumeration<DiagnosticReportStatus>(this, DiagnosticReportStatus.FINAL);
            }
            if ("amended".equals(codeString)) {
                return new Enumeration<DiagnosticReportStatus>(this, DiagnosticReportStatus.AMENDED);
            }
            if ("corrected".equals(codeString)) {
                return new Enumeration<DiagnosticReportStatus>(this, DiagnosticReportStatus.CORRECTED);
            }
            if ("appended".equals(codeString)) {
                return new Enumeration<DiagnosticReportStatus>(this, DiagnosticReportStatus.APPENDED);
            }
            if ("cancelled".equals(codeString)) {
                return new Enumeration<DiagnosticReportStatus>(this, DiagnosticReportStatus.CANCELLED);
            }
            if ("entered-in-error".equals(codeString)) {
                return new Enumeration<DiagnosticReportStatus>(this, DiagnosticReportStatus.ENTEREDINERROR);
            }
            if ("unknown".equals(codeString)) {
                return new Enumeration<DiagnosticReportStatus>(this, DiagnosticReportStatus.UNKNOWN);
            }
            throw new FHIRException("Unknown DiagnosticReportStatus code '" + codeString + "'");
        }

        @Override
        public String toCode(DiagnosticReportStatus code) {
            if (code == DiagnosticReportStatus.REGISTERED) {
                return "registered";
            }
            if (code == DiagnosticReportStatus.PARTIAL) {
                return "partial";
            }
            if (code == DiagnosticReportStatus.PRELIMINARY) {
                return "preliminary";
            }
            if (code == DiagnosticReportStatus.FINAL) {
                return "final";
            }
            if (code == DiagnosticReportStatus.AMENDED) {
                return "amended";
            }
            if (code == DiagnosticReportStatus.CORRECTED) {
                return "corrected";
            }
            if (code == DiagnosticReportStatus.APPENDED) {
                return "appended";
            }
            if (code == DiagnosticReportStatus.CANCELLED) {
                return "cancelled";
            }
            if (code == DiagnosticReportStatus.ENTEREDINERROR) {
                return "entered-in-error";
            }
            if (code == DiagnosticReportStatus.UNKNOWN) {
                return "unknown";
            }
            return "?";
        }

        @Override
        public String toSystem(DiagnosticReportStatus code) {
            return code.getSystem();
        }
    }

    public static enum DiagnosticReportStatus {
        REGISTERED,
        PARTIAL,
        PRELIMINARY,
        FINAL,
        AMENDED,
        CORRECTED,
        APPENDED,
        CANCELLED,
        ENTEREDINERROR,
        UNKNOWN,
        NULL;


        public static DiagnosticReportStatus fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("registered".equals(codeString)) {
                return REGISTERED;
            }
            if ("partial".equals(codeString)) {
                return PARTIAL;
            }
            if ("preliminary".equals(codeString)) {
                return PRELIMINARY;
            }
            if ("final".equals(codeString)) {
                return FINAL;
            }
            if ("amended".equals(codeString)) {
                return AMENDED;
            }
            if ("corrected".equals(codeString)) {
                return CORRECTED;
            }
            if ("appended".equals(codeString)) {
                return APPENDED;
            }
            if ("cancelled".equals(codeString)) {
                return CANCELLED;
            }
            if ("entered-in-error".equals(codeString)) {
                return ENTEREDINERROR;
            }
            if ("unknown".equals(codeString)) {
                return UNKNOWN;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown DiagnosticReportStatus code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case REGISTERED: {
                    return "registered";
                }
                case PARTIAL: {
                    return "partial";
                }
                case PRELIMINARY: {
                    return "preliminary";
                }
                case FINAL: {
                    return "final";
                }
                case AMENDED: {
                    return "amended";
                }
                case CORRECTED: {
                    return "corrected";
                }
                case APPENDED: {
                    return "appended";
                }
                case CANCELLED: {
                    return "cancelled";
                }
                case ENTEREDINERROR: {
                    return "entered-in-error";
                }
                case UNKNOWN: {
                    return "unknown";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case REGISTERED: {
                    return "http://hl7.org/fhir/diagnostic-report-status";
                }
                case PARTIAL: {
                    return "http://hl7.org/fhir/diagnostic-report-status";
                }
                case PRELIMINARY: {
                    return "http://hl7.org/fhir/diagnostic-report-status";
                }
                case FINAL: {
                    return "http://hl7.org/fhir/diagnostic-report-status";
                }
                case AMENDED: {
                    return "http://hl7.org/fhir/diagnostic-report-status";
                }
                case CORRECTED: {
                    return "http://hl7.org/fhir/diagnostic-report-status";
                }
                case APPENDED: {
                    return "http://hl7.org/fhir/diagnostic-report-status";
                }
                case CANCELLED: {
                    return "http://hl7.org/fhir/diagnostic-report-status";
                }
                case ENTEREDINERROR: {
                    return "http://hl7.org/fhir/diagnostic-report-status";
                }
                case UNKNOWN: {
                    return "http://hl7.org/fhir/diagnostic-report-status";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case REGISTERED: {
                    return "The existence of the report is registered, but there is nothing yet available.";
                }
                case PARTIAL: {
                    return "This is a partial (e.g. initial, interim or preliminary) report: data in the report may be incomplete or unverified.";
                }
                case PRELIMINARY: {
                    return "Verified early results are available, but not all  results are final.";
                }
                case FINAL: {
                    return "The report is complete and verified by an authorized person.";
                }
                case AMENDED: {
                    return "Subsequent to being final, the report has been modified.  This includes any change in the results, diagnosis, narrative text, or other content of a report that has been issued.";
                }
                case CORRECTED: {
                    return "Subsequent to being final, the report has been modified  to correct an error in the report or referenced results.";
                }
                case APPENDED: {
                    return "Subsequent to being final, the report has been modified by adding new content. The existing content is unchanged.";
                }
                case CANCELLED: {
                    return "The report is unavailable because the measurement was not started or not completed (also sometimes called \"aborted\").";
                }
                case ENTEREDINERROR: {
                    return "The report has been withdrawn following a previous final release.  This electronic record should never have existed, though it is possible that real-world decisions were based on it. (If real-world activity has occurred, the status should be \"cancelled\" rather than \"entered-in-error\".)";
                }
                case UNKNOWN: {
                    return "The authoring system does not know which of the status values currently applies for this request. Note: This concept is not to be used for \"other\" - one of the listed statuses is presumed to apply, it's just not known which one.";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case REGISTERED: {
                    return "Registered";
                }
                case PARTIAL: {
                    return "Partial";
                }
                case PRELIMINARY: {
                    return "Preliminary";
                }
                case FINAL: {
                    return "Final";
                }
                case AMENDED: {
                    return "Amended";
                }
                case CORRECTED: {
                    return "Corrected";
                }
                case APPENDED: {
                    return "Appended";
                }
                case CANCELLED: {
                    return "Cancelled";
                }
                case ENTEREDINERROR: {
                    return "Entered in Error";
                }
                case UNKNOWN: {
                    return "Unknown";
                }
            }
            return "?";
        }
    }
}

